/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.internal.repl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.scalaide.core.internal.project.ScalaProject$;
import org.scalaide.core.internal.repl.InterpreterLaunchConstants$;
import org.scalaide.logging.HasLogger;
import org.scalaide.logging.HasLogger$class;
import org.scalaide.logging.Logger;
import org.scalaide.util.eclipse.SWTUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011!#\u00138uKJ\u0004(/\u001a;fe6\u000b\u0017N\u001c+bE*\u00111\u0001B\u0001\u0005e\u0016\u0004HN\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005\u0011Q/\u001b\u0006\u0003\u0013)\t\u0001b]2bY\u0006LG-\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AD\u000e\u0011\u0005=IR\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00067bk:\u001c\u0007nQ8oM&<WO]1uS>t7O\u0003\u0002\b')\u0011A#F\u0001\u0006I\u0016\u0014Wo\u001a\u0006\u0003-]\t1A\u001b3u\u0015\tA\"\"A\u0004fG2L\u0007o]3\n\u0005i\u0001\"!\u0004&bm\u0006d\u0015-\u001e8dQR\u000b'\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u0011\u00059An\\4hS:<\u0017B\u0001\u0011\u001e\u0005%A\u0015m\u001d'pO\u001e,'\u000fC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0005!Iq\u0005\u0001a\u0001\u0002\u0004%\t\u0002K\u0001\u000fg\u0016,GmU2sSB$H+\u001a=u+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u001d9\u0018\u000eZ4fiNT!AL\f\u0002\u0007M<H/\u0003\u00021W\t!A+\u001a=u\u0011%\u0011\u0004\u00011AA\u0002\u0013E1'\u0001\ntK\u0016$7k\u0019:jaR$V\r\u001f;`I\u0015\fHC\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0011)f.\u001b;\t\u000fm\n\u0014\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u0003*\u0003=\u0019X-\u001a3TGJL\u0007\u000f\u001e+fqR\u0004\u0003\"B \u0001\t\u0003\u0002\u0015aB5t-\u0006d\u0017\u000e\u001a\u000b\u0003\u0003\u0012\u0003\"!\u000e\"\n\u0005\r3$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000bz\u0002\rAR\u0001\rY\u0006,hn\u00195D_:4\u0017n\u001a\t\u0003\u000f.k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAaY8sK*\u0011AcF\u0005\u0003\u0019\"\u0013A#\u0013'bk:\u001c\u0007nQ8oM&<WO]1uS>t\u0007\"\u0002(\u0001\t\u0003z\u0015!D2sK\u0006$XmQ8oiJ|G\u000e\u0006\u00025!\")\u0011+\u0014a\u0001%\u00061\u0001/\u0019:f]R\u0004\"AK*\n\u0005Q[#!C\"p[B|7/\u001b;f\u0011\u00151\u0006\u0001\"\u0011X\u0003\u001d9W\r\u001e(b[\u0016$\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019\u0019FO]5oO\"I\u0011\r\u0001a\u0001\u0002\u0004%\t\u0001K\u0001\nMB\u0013xN\u001b+fqRD\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00013\u0002\u001b\u0019\u0004&o\u001c6UKb$x\fJ3r)\t!T\rC\u0004<E\u0006\u0005\t\u0019A\u0015\t\r\u001d\u0004\u0001\u0015)\u0003*\u0003)1\u0007K]8k)\u0016DH\u000f\t\u0005\nS\u0002\u0001\r\u00111A\u0005\u0002)\f1B\u001a)s_*\u0014U\u000f\u001e;p]V\t1\u000e\u0005\u0002+Y&\u0011Qn\u000b\u0002\u0007\u0005V$Ho\u001c8\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\u0018a\u00044Qe>T')\u001e;u_:|F%Z9\u0015\u0005Q\n\bbB\u001eo\u0003\u0003\u0005\ra\u001b\u0005\u0007g\u0002\u0001\u000b\u0015B6\u0002\u0019\u0019\u0004&o\u001c6CkR$xN\u001c\u0011\t\u000bU\u0004A\u0011\u0003<\u0002'\r\u0014X-\u0019;f!J|'.Z2u\u000b\u0012LGo\u001c:\u0015\u0005Q:\b\"B)u\u0001\u0004\u0011\u0006\"B=\u0001\t#Q\u0018AF2sK\u0006$XmU3fIN\u001b'/\u001b9u\u000b\u0012LGo\u001c:\u0015\u0005QZ\b\"B)y\u0001\u0004\u0011\u0006\"B?\u0001\t\u0013q\u0018a\u00075b]\u0012dW\r\u0015:pU\u0016\u001cGOQ;ui>t7+\u001a7fGR,G\rF\u00015\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\t!c\u00195p_N,7kY1mCB\u0013xN[3diR\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tY!\u0004\u0002\u0002\n)\u0011\u0011*F\u0005\u0005\u0003\u001b\tIA\u0001\u0007J\u0015\u00064\u0018\r\u0015:pU\u0016\u001cG\u000fC\u0004\u0002\u0012\u0001!I!a\u0005\u0002\u0019\u001d,GOS1wC6{G-\u001a7\u0015\u0005\u0005U\u0001\u0003BA\u0004\u0003/IA!!\u0007\u0002\n\tQ\u0011JS1wC6{G-\u001a7\t\u000f\u0005u\u0001\u0001\"\u0005\u0002\u0004\u0005yq-\u001a;TG\u0006d\u0017\r\u0015:pU\u0016\u001cG\u000fC\u0004\u0002\"\u0001!\t\"a\t\u0002!\u001d,GoV8sWN\u0004\u0018mY3S_>$HCAA\u0013!\u0011\t9#a\f\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t\u0011B]3t_V\u00148-Z:\u000b\u0005%;\u0012\u0002BA\u0019\u0003S\u0011a\"S,pe.\u001c\b/Y2f%>|G\u000fC\u0004\u00026\u0001!\t%a\u000e\u0002\u001d%t\u0017\u000e^5bY&TXM\u0012:p[R\u0019A'!\u000f\t\u000f\u0005m\u00121\u0007a\u0001\r\u000611m\u001c8gS\u001eDq!a\u0010\u0001\t\u0013\t\t%A\fva\u0012\fG/\u001a)s_*,7\r\u001e$s_6\u001cuN\u001c4jOR\u0019A'a\u0011\t\u000f\u0005m\u0012Q\ba\u0001\r\"9\u0011q\t\u0001\u0005\n\u0005%\u0013AG;qI\u0006$XmU3fIN\u001b'/\u001b9u\rJ|WnQ8oM&<Gc\u0001\u001b\u0002L!9\u00111HA#\u0001\u00041\u0005BBA(\u0001\u0011Ea0\u0001\u0007nCB\u0014Vm]8ve\u000e,7\u000fC\u0004\u0002T\u0001!\t%!\u0016\u0002\u0019A,'OZ8s[\u0006\u0003\b\u000f\\=\u0015\u0007Q\n9\u0006\u0003\u0005\u0002<\u0005E\u0003\u0019AA-!\r9\u00151L\u0005\u0004\u0003;B%aH%MCVt7\r[\"p]\u001aLw-\u001e:bi&|gnV8sW&twmQ8qs\"9\u0011\u0011\r\u0001\u0005B\u0005\r\u0014aC:fi\u0012+g-Y;miN$2\u0001NA3\u0011!\tY$a\u0018A\u0002\u0005e\u0003\u0002DA5\u0001A\u0005\t\u0011!A\u0005\u0002\u0005-\u0014!\u000b9s_R,7\r^3eIU\u0004H-\u0019;f\u0019\u0006,hn\u00195D_:4\u0017nZ;sCRLwN\u001c#jC2|w\rF\u0002\u007f\u0003[B\u0001bOA4\u0003\u0003\u0005\r\u0001\n")
public class InterpreterMainTab
extends JavaLaunchTab
implements HasLogger {
    private Text seedScriptText;
    private Text fProjText;
    private Button fProjButton;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InterpreterMainTab interpreterMainTab = this;
        synchronized (interpreterMainTab) {
            if (!this.bitmap$0) {
                this.logger = HasLogger$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Logger eclipseLog() {
        return HasLogger$class.eclipseLog(this);
    }

    public /* synthetic */ void protected$updateLaunchConfigurationDialog(InterpreterMainTab x$1) {
        x$1.updateLaunchConfigurationDialog();
    }

    public Text seedScriptText() {
        return this.seedScriptText;
    }

    public void seedScriptText_$eq(Text x$1) {
        this.seedScriptText = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText().getText().trim();
        if (name.length() <= 0) return true;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(name, 4);
        if (status.isOK()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists()) {
                if (project.isOpen()) return true;
                this.setErrorMessage("Project is not open");
                return false;
            }
            this.setErrorMessage("Project does not exist");
            return false;
        }
        this.setErrorMessage("Name does not exist on workspace.");
        return false;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createSeedScriptEditor(comp);
        this.setControl((Control)comp);
    }

    public String getName() {
        return "Main";
    }

    public Text fProjText() {
        return this.fProjText;
    }

    public void fProjText_$eq(Text x$1) {
        this.fProjText = x$1;
    }

    public Button fProjButton() {
        return this.fProjButton;
    }

    public void fProjButton_$eq(Button x$1) {
        this.fProjButton = x$1;
    }

    public void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project Setup");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText_$eq(new Text((Composite)group, 2052));
        gd = new GridData(768);
        this.fProjText().setLayoutData((Object)gd);
        this.fProjText().setFont(font);
        this.fProjText().addModifyListener(SWTUtils$.MODULE$.noArgFnToModifyListener((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpreterMainTab $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.protected$updateLaunchConfigurationDialog(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.fProjButton_$eq(this.createPushButton((Composite)group, "Scala Project", null));
        this.fProjButton().addSelectionListener((SelectionListener)SWTUtils$.MODULE$.noArgFnToSelectionAdapter((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpreterMainTab $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$scalaide$ui$internal$repl$InterpreterMainTab$$handleProjectButtonSelected();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void createSeedScriptEditor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Interpreter Seed Script");
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new FillLayout());
        this.seedScriptText_$eq(new Text((Composite)group, 2818));
    }

    public void org$scalaide$ui$internal$repl$InterpreterMainTab$$handleProjectButtonSelected() {
        IJavaProject project = this.chooseScalaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText().setText(projectName);
    }

    private IJavaProject chooseScalaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Select a Scala Project");
        dialog.setMessage("");
        try {
            Object[] scalaProjects = (Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects()).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(IJavaProject project) {
                    return ScalaProject$.MODULE$.isScalaProject(project);
                }
            })).toArray(ClassTag$.MODULE$.Object());
            dialog.setElements(scalaProjects);
        }
        catch (JavaModelException javaModelException) {
            this.eclipseLog().error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Java model exception";
                }
            }, javaModelException);
        }
        IJavaProject scalaProject = this.getScalaProject();
        if (scalaProject != null) {
            IJavaProject iJavaProject = scalaProject;
            dialog.setInitialSelections((Object[])Nil$.MODULE$.$colon$colon((Object)iJavaProject).toArray(ClassTag$.MODULE$.Object()));
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public IJavaProject getScalaProject() {
        String projectName = this.fProjText().getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateSeedScriptFromConfig(config);
        super.initializeFrom(config);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            this.setErrorMessage(coreException.getStatus().getMessage());
        }
        if (this.fProjText() != null) {
            this.fProjText().setText(projectName);
        }
    }

    private void updateSeedScriptFromConfig(ILaunchConfiguration config) {
        if (this.seedScriptText() != null) {
            this.seedScriptText().setText(config.getAttribute(InterpreterLaunchConstants$.MODULE$.SEED_SCRIPT(), ""));
        }
    }

    public void mapResources() {
        try {
            IJavaProject javaProject = this.getScalaProject();
            if (javaProject != null && javaProject.exists() && !javaProject.isOpen()) {
                // empty if block
            }
        }
        catch (CoreException coreException) {
            this.setErrorMessage(coreException.getStatus().getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText().getText().trim());
        config.setAttribute(InterpreterLaunchConstants$.MODULE$.SEED_SCRIPT(), this.seedScriptText().getText().trim());
        this.mapResources();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement == null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            config.setAttribute(InterpreterLaunchConstants$.MODULE$.SEED_SCRIPT(), "");
        } else {
            this.initializeJavaProject(javaElement, config);
        }
    }

    public InterpreterMainTab() {
        HasLogger$class.$init$(this);
    }
}

