/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.internal.repl;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.scalaide.core.IScalaPlugin$;
import org.scalaide.ui.internal.repl.CommandField;
import org.scalaide.ui.internal.repl.CommandFieldWithLineNumbersAndMenu;
import org.scalaide.ui.internal.repl.InterpreterConsoleView;
import org.scalaide.ui.internal.repl.InterpreterConsoleView$;
import org.scalaide.ui.internal.repl.InterpreterConsoleView$$anonfun$displayCode$1$;
import org.scalaide.ui.internal.repl.StyledTextWithSimpleMenu;
import org.scalaide.ui.syntax.ScalariformToSyntaxClass$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalariform.lexer.ScalaLexer$;
import scalariform.lexer.Token;

public abstract class InterpreterConsoleView$class {
    public static void doOnLineNumbersVisibilityUpdate(InterpreterConsoleView $this, boolean enabled) {
    }

    public static CommandFieldWithLineNumbersAndMenu createCommandField(InterpreterConsoleView $this, Composite parent, Seq suggestedStyles) {
        return new CommandFieldWithLineNumbersAndMenu($this, parent, suggestedStyles){
            private final /* synthetic */ InterpreterConsoleView $outer;

            public String helpText() {
                return "<type an expression>\tCTRL+ENTER to evaluate\nto browse expressions from history use:\tCTRL+Up and CTRL+Down";
            }

            public void onLineNumbersVisibilityUpdated(boolean enabled) {
                this.$outer.doOnLineNumbersVisibilityUpdate(enabled);
            }

            public /* synthetic */ InterpreterConsoleView org$scalaide$ui$internal$repl$InterpreterConsoleView$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(parent$1, BoxesRunTime.unboxToInt((Object)suggestedStyles$1.reduce((Function2)new Serializable($outer){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int l, int r) {
                        return this.apply$mcIII$sp(l, r);
                    }

                    public int apply$mcIII$sp(int l, int r) {
                        return l | r;
                    }
                })));
                this.setEvaluator(new CommandField.Evaluator(this){
                    private final /* synthetic */ InterpreterConsoleView$.anon.1 $outer;

                    public void eval(String command) {
                        this.$outer.org$scalaide$ui$internal$repl$InterpreterConsoleView$$anon$$$outer().evaluate(command);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
    }

    public static void createInterpreterPartControl(InterpreterConsoleView $this, Composite parent) {
        $this.display_$eq(parent.getDisplay());
        ColorRegistry reg = JFaceResources.getColorRegistry();
        $this.codeBgColor_$eq(reg.get(InterpreterConsoleView$.MODULE$.BackgroundColor()));
        $this.codeFgColor_$eq(reg.get(InterpreterConsoleView$.MODULE$.ForegroundColor()));
        $this.errorFgColor_$eq(reg.get(InterpreterConsoleView$.MODULE$.ErrorForegroundColor()));
        $this.interpreterPanel_$eq(new SashForm(parent, 512));
        $this.interpreterPanel().setLayout((Layout)new FillLayout());
        $this.resultsTextWidget_$eq(new StyledTextWithSimpleMenu((Composite)$this.interpreterPanel(), 2816));
        $this.resultsTextWidget().setLayout((Layout)new FillLayout());
        $this.resultsTextWidget().setEditable(false);
        $this.resultsTextWidget().setCaret(new Caret((Canvas)$this.resultsTextWidget(), 0));
        $this.resultsTextWidget().setAlwaysShowScrollBars(false);
        $this.resultsTextWidget().setBackground(reg.get(InterpreterConsoleView$.MODULE$.BackgroundColor()));
        Font editorFont = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        $this.resultsTextWidget().setFont(editorFont);
        $this.inputCommandField_$eq($this.createCommandField((Composite)$this.interpreterPanel(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2048, 2, 256, 512, 16})))));
        $this.inputCommandField().setFont(editorFont);
        $this.inputCommandField().setLayout((Layout)new FillLayout());
        $this.inputCommandField().setAlwaysShowScrollBars(false);
        $this.interpreterPanel().setWeights(new int[]{3, 1});
    }

    public static void displayCode(InterpreterConsoleView $this, String text) {
        $this.displayPadded($this.codeBgColor(), (Function0<BoxedUnit>)new Serializable($this, text){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpreterConsoleView $outer;
            private final String text$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IPreferenceStore prefStore = ((AbstractUIPlugin)IScalaPlugin$.MODULE$.apply()).getPreferenceStore();
                ScalaLexer$.MODULE$.rawTokenise(this.text$1, true, ScalaLexer$.MODULE$.rawTokenise$default$3()).foreach((Function1)new Serializable(this, prefStore){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ InterpreterConsoleView$.anonfun.displayCode.1 $outer;
                    private final IPreferenceStore prefStore$1;

                    public final void apply(Token token) {
                        TextAttribute textAttribute = ScalariformToSyntaxClass$.MODULE$.apply(token).getTextAttribute(this.prefStore$1);
                        Color bgColor = (Color)Option$.MODULE$.apply((Object)textAttribute.getBackground()).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ InterpreterConsoleView$$anonfun$displayCode$1$.anonfun.apply.mcV.sp.1 $outer;

                            public final Color apply() {
                                return this.$outer.org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$anonfun$$$outer().org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$$outer().codeBgColor();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        String x$2 = token.text();
                        Color x$3 = textAttribute.getForeground();
                        Color x$4 = bgColor;
                        int x$5 = textAttribute.getStyle();
                        boolean x$6 = false;
                        Font x$7 = this.$outer.org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$$outer().appendText$default$5();
                        this.$outer.org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$$outer().appendText(x$2, x$3, x$4, x$5, x$7, x$6);
                    }

                    public /* synthetic */ InterpreterConsoleView$.anonfun.displayCode.1 org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prefStore$1 = prefStore$1;
                    }
                });
                String x$8 = "\n";
                Color x$9 = this.$outer.codeFgColor();
                Color x$10 = this.$outer.codeBgColor();
                int x$11 = 0;
                boolean x$12 = false;
                Font x$13 = this.$outer.appendText$default$5();
                this.$outer.appendText(x$8, x$9, x$10, x$11, x$13, x$12);
            }

            public /* synthetic */ InterpreterConsoleView org$scalaide$ui$internal$repl$InterpreterConsoleView$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.text$1 = text$1;
            }
        });
    }

    public static void displayOutput(InterpreterConsoleView $this, String text) {
        $this.displayPadded($this.codeBgColor(), (Function0<BoxedUnit>)new Serializable($this, text){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpreterConsoleView $outer;
            private final String text$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.appendText(new StringBuilder().append((Object)this.text$2).append((Object)"\n").toString(), this.$outer.codeFgColor(), this.$outer.codeBgColor(), 0, this.$outer.appendText$default$5(), this.$outer.appendText$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.text$2 = text$2;
            }
        });
    }

    public static void displayError(InterpreterConsoleView $this, String text) {
        $this.displayPadded($this.codeBgColor(), (Function0<BoxedUnit>)new Serializable($this, text){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpreterConsoleView $outer;
            private final String text$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.appendText(new StringBuilder().append((Object)this.text$3).append((Object)"\n").toString(), this.$outer.errorFgColor(), this.$outer.codeBgColor(), 0, this.$outer.appendText$default$5(), this.$outer.appendText$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.text$3 = text$3;
            }
        });
    }

    public static void displayPadded(InterpreterConsoleView $this, Color bgColor, Function0 display) {
        InterpreterConsoleView$class.insertSpacing($this, bgColor);
        display.apply$mcV$sp();
    }

    private static void insertSpacing(InterpreterConsoleView $this, Color bgColor) {
        FontData[] fontData = $this.resultsTextWidget().getFont().getFontData();
        Predef$.MODULE$.refArrayOps((Object[])fontData).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(FontData x$1) {
                x$1.setHeight(4);
            }
        });
        Font font = new Font((Device)$this.display(), fontData);
        $this.appendText("\n ", null, bgColor, 0, font, $this.appendText$default$6());
    }

    public static void appendText(InterpreterConsoleView $this, String text, Color fgColor, Color bgColor, int fontStyle, Font font, boolean insertNewline) {
        int lastOffset = $this.resultsTextWidget().getCharCount();
        int oldLastLine = $this.resultsTextWidget().getLineCount();
        String outputStr = insertNewline ? new StringBuilder().append((Object)"\n").append((Object)new StringOps(Predef$.MODULE$.augmentString(text)).stripLineEnd()).append((Object)"\n\n").toString() : text;
        $this.resultsTextWidget().append(outputStr);
        StyleRange style1 = new StyleRange(lastOffset, outputStr.length(), fgColor, null, fontStyle);
        style1.font = font;
        $this.resultsTextWidget().setStyleRange(style1);
        int lastLine = $this.resultsTextWidget().getLineCount();
        if (bgColor != null) {
            $this.resultsTextWidget().setLineBackground(oldLastLine - 1, lastLine - oldLastLine, bgColor);
        }
        $this.resultsTextWidget().setTopIndex($this.resultsTextWidget().getLineCount() - 1);
        StyleRange style2 = new StyleRange(lastOffset, outputStr.length(), fgColor, null, fontStyle);
        style2.font = font;
        $this.resultsTextWidget().setStyleRange(style2);
    }

    public static Font appendText$default$5(InterpreterConsoleView $this) {
        return null;
    }

    public static boolean appendText$default$6(InterpreterConsoleView $this) {
        return false;
    }

    public static void dispose(InterpreterConsoleView $this) {
        if ($this.interpreterPanel() != null) {
            $this.interpreterPanel().dispose();
        }
        if ($this.inputCommandField() != null) {
            $this.inputCommandField().dispose();
        }
        if ($this.resultsTextWidget() != null) {
            $this.resultsTextWidget().dispose();
        }
    }

    public static void $init$(InterpreterConsoleView $this) {
        $this.interpreterPanel_$eq(null);
        $this.resultsTextWidget_$eq(null);
        $this.inputCommandField_$eq(null);
        $this.codeBgColor_$eq(null);
        $this.codeFgColor_$eq(null);
        $this.errorFgColor_$eq(null);
        $this.display_$eq(null);
    }
}

