/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.internal.repl;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.scalaide.ui.internal.repl.CommandField;
import org.scalaide.ui.internal.repl.InputContextMenuAndLineNumbers;
import org.scalaide.ui.internal.repl.InterpreterConsoleView$;
import org.scalaide.util.eclipse.SWTUtils$;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public abstract class InputContextMenuAndLineNumbers$class {
    public static void onLineNumbersVisibilityUpdated(InputContextMenuAndLineNumbers $this, boolean enabled) {
    }

    public static void setLineNumbersVisibility(InputContextMenuAndLineNumbers $this, boolean visible) {
        $this.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$lineNumbersItem().setSelection(visible);
        InputContextMenuAndLineNumbers$class.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$updateLineNumbersVisibility($this);
    }

    private static MenuItem initContextMenuAndReturnLineNumbersItem(InputContextMenuAndLineNumbers $this) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Menu contextMenu = new Menu((Control)$this);
        ((Control)$this).setMenu(contextMenu);
        MenuItem cutItem = InputContextMenuAndLineNumbers$class.createCutMenuItem($this, contextMenu, sharedImages);
        MenuItem copyItem = InputContextMenuAndLineNumbers$class.createCopyMenuItem($this, contextMenu, sharedImages);
        InputContextMenuAndLineNumbers$class.createPasteMenuItem($this, contextMenu, sharedImages);
        new MenuItem(contextMenu, 2);
        MenuItem clearItem = InputContextMenuAndLineNumbers$class.createClearMenuItem($this, contextMenu);
        MenuItem clearAfterEvaluationItem = InputContextMenuAndLineNumbers$class.createClearAfterEvaluationMenuItem($this, contextMenu);
        new MenuItem(contextMenu, 2);
        MenuItem lineNumbersMenuItem = InputContextMenuAndLineNumbers$class.createLineNumbersMenuItem($this, contextMenu);
        contextMenu.addListener(22, new Listener($this, cutItem, copyItem, clearItem, clearAfterEvaluationItem){
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;
            private final MenuItem cutItem$1;
            private final MenuItem copyItem$1;
            private final MenuItem clearItem$1;
            private final MenuItem clearAfterEvaluationItem$1;

            public void handleEvent(Event event) {
                Point selection2 = ((StyledText)this.$outer).getSelection();
                boolean textSelected = selection2.x != selection2.y;
                this.cutItem$1.setEnabled(textSelected);
                this.copyItem$1.setEnabled(textSelected);
                this.clearItem$1.setEnabled(!((CommandField)((Object)this.$outer)).isEmpty());
                this.clearAfterEvaluationItem$1.setSelection(((CommandField)((Object)this.$outer)).clearTextAfterEvaluation());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cutItem$1 = cutItem$1;
                this.copyItem$1 = copyItem$1;
                this.clearItem$1 = clearItem$1;
                this.clearAfterEvaluationItem$1 = clearAfterEvaluationItem$1;
            }
        });
        return lineNumbersMenuItem;
    }

    private static MenuItem createCutMenuItem(InputContextMenuAndLineNumbers $this, Menu menu, ISharedImages sharedImages) {
        return InputContextMenuAndLineNumbers$class.createSimpleMenuItem($this, menu, "Cut", sharedImages.getImage("IMG_TOOL_CUT"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((StyledText)this.$outer).cut();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static MenuItem createCopyMenuItem(InputContextMenuAndLineNumbers $this, Menu menu, ISharedImages sharedImages) {
        return InputContextMenuAndLineNumbers$class.createSimpleMenuItem($this, menu, "Copy", sharedImages.getImage("IMG_TOOL_COPY"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((StyledText)this.$outer).copy();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static MenuItem createPasteMenuItem(InputContextMenuAndLineNumbers $this, Menu menu, ISharedImages sharedImages) {
        return InputContextMenuAndLineNumbers$class.createSimpleMenuItem($this, menu, "Paste", sharedImages.getImage("IMG_TOOL_PASTE"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((StyledText)this.$outer).paste();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static MenuItem createClearMenuItem(InputContextMenuAndLineNumbers $this, Menu menu) {
        return InputContextMenuAndLineNumbers$class.createSimpleMenuItem($this, menu, "Clear", ConsolePluginImages.getImage((String)"IMG_ELCL_CLEAR"), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((CommandField)((Object)this.$outer)).clear();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static MenuItem createLineNumbersMenuItem(InputContextMenuAndLineNumbers $this, Menu menu) {
        void var2_2;
        MenuItem lineNumbersItem = new MenuItem(menu, 32);
        lineNumbersItem.setText("Show Line Numbers");
        lineNumbersItem.addSelectionListener((SelectionListener)SWTUtils$.MODULE$.noArgFnToSelectionAdapter((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputContextMenuAndLineNumbers$class.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$updateLineNumbersVisibility(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static MenuItem createClearAfterEvaluationMenuItem(InputContextMenuAndLineNumbers $this, Menu menu) {
        void var2_2;
        MenuItem menuItem = new MenuItem(menu, 32);
        menuItem.setText("Clear Text After Evaluation");
        menuItem.addSelectionListener((SelectionListener)SWTUtils$.MODULE$.noArgFnToSelectionAdapter((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((CommandField)((Object)this.$outer)).clearTextAfterEvaluation_$eq(!((CommandField)((Object)this.$outer)).clearTextAfterEvaluation());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        return var2_2;
    }

    private static MenuItem createSimpleMenuItem(InputContextMenuAndLineNumbers $this, Menu menu, String text, Image image, Function0 onSelected) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(text);
        menuItem.setImage(image);
        menuItem.addSelectionListener((SelectionListener)SWTUtils$.MODULE$.noArgFnToSelectionAdapter((Function0<Object>)onSelected));
        return menuItem;
    }

    public static void org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$updateLineNumbersVisibility(InputContextMenuAndLineNumbers $this) {
        boolean lineNumbersEnabled = $this.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$lineNumbersItem().getSelection();
        if (lineNumbersEnabled) {
            ((StyledText)$this).addModifyListener($this.lineNumbersModifyListener());
            InputContextMenuAndLineNumbers$class.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$redrawWithLineNumbers($this);
        } else {
            ((StyledText)$this).removeModifyListener($this.lineNumbersModifyListener());
            ((StyledText)$this).setLineBullet(0, ((StyledText)$this).getLineCount(), null);
        }
        $this.onLineNumbersVisibilityUpdated(lineNumbersEnabled);
    }

    public static void org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$redrawWithLineNumbers(InputContextMenuAndLineNumbers $this) {
        int maxLine = ((StyledText)$this).getLineCount();
        int lineCountWidth = Math.max(String.valueOf(maxLine).length(), 3);
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, lineCountWidth * 8 + 5);
        Bullet bullet = new Bullet(2, style);
        bullet.style.background = $this.lineNumberBgColor();
        ((StyledText)$this).setLineBullet(0, ((StyledText)$this).getLineCount(), null);
        ((StyledText)$this).setLineBullet(0, ((StyledText)$this).getLineCount(), bullet);
    }

    public static void $init$(InputContextMenuAndLineNumbers $this) {
        $this.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$_setter_$lineNumberBgColor_$eq(JFaceResources.getColorRegistry().get(InterpreterConsoleView$.MODULE$.LineNumberBackgroundColor()));
        $this.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$_setter_$lineNumbersModifyListener_$eq(SWTUtils$.MODULE$.noArgFnToModifyListener((Function0<BoxedUnit>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputContextMenuAndLineNumbers $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputContextMenuAndLineNumbers$class.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$redrawWithLineNumbers(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$_setter_$org$scalaide$ui$internal$repl$InputContextMenuAndLineNumbers$$lineNumbersItem_$eq(InputContextMenuAndLineNumbers$class.initContextMenuAndReturnLineNumbersItem($this));
        ((StyledText)$this).setBackground(JFaceResources.getColorRegistry().get(InterpreterConsoleView$.MODULE$.BackgroundColor()));
        ((StyledText)$this).setForeground(JFaceResources.getColorRegistry().get(InterpreterConsoleView$.MODULE$.ForegroundColor()));
    }
}

