/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.internal.editor.autoedits;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.scalaide.core.internal.statistics.Features$AutoEscapeBackslashes$;
import org.scalaide.core.internal.statistics.Features$AutoEscapeLiterals$;
import org.scalaide.core.internal.statistics.Features$AutoRemoveEscapedSign$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001f\t12\u000b\u001e:j]\u001e\fU\u000f^8FI&$8\u000b\u001e:bi\u0016<\u0017P\u0003\u0002\u0004\t\u0005I\u0011-\u001e;pK\u0012LGo\u001d\u0006\u0003\u000b\u0019\ta!\u001a3ji>\u0014(BA\u0004\t\u0003!Ig\u000e^3s]\u0006d'BA\u0005\u000b\u0003\t)\u0018N\u0003\u0002\f\u0019\u0005A1oY1mC&$WMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0007\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011\u0004I\u0007\u00025)\u00111\u0004H\u0001\u0005i\u0016DHO\u0003\u0002\u001e=\u0005)!NZ1dK*\u0011q\u0004D\u0001\bK\u000ed\u0017\u000e]:f\u0013\t\t#DA\tJ\u0003V$x.\u00123jiN#(/\u0019;fOfD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\ra\u0006\u0014H/\u001b;j_:Lgn\u001a\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I\u0001O]3g'R|'/\u001a\t\u0003cQj\u0011A\r\u0006\u0003gq\t!\u0002\u001d:fM\u0016\u0014XM\\2f\u0013\t)$G\u0001\tJ!J,g-\u001a:f]\u000e,7\u000b^8sK\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"2!O\u001e=!\tQ\u0004!D\u0001\u0003\u0011\u0015\u0019c\u00071\u0001%\u0011\u0015yc\u00071\u00011\u0011\u0015q\u0004\u0001\"\u0011@\u0003a\u0019Wo\u001d;p[&TX\rR8dk6,g\u000e^\"p[6\fg\u000e\u001a\u000b\u0004\u0001\u000eC\u0005C\u0001\u0014B\u0013\t\u0011uE\u0001\u0003V]&$\b\"\u0002#>\u0001\u0004)\u0015\u0001\u00033pGVlWM\u001c;\u0011\u0005e1\u0015BA$\u001b\u0005%IEi\\2v[\u0016tG\u000fC\u0003J{\u0001\u0007!*A\u0004d_6l\u0017M\u001c3\u0011\u0005eY\u0015B\u0001'\u001b\u0005=!unY;nK:$8i\\7nC:$\u0007")
public class StringAutoEditStrategy
implements IAutoEditStrategy {
    private final String partitioning;
    private final IPreferenceStore prefStore;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        boolean isAutoEscapeLiteralEnabled = this.prefStore.getBoolean("scala.tools.eclipse.editor.autoEscapeLiterals");
        boolean isAutoEscapeSignEnabled = this.prefStore.getBoolean("scala.tools.eclipse.editor.autoEscapeSign");
        boolean isAutoRemoveEscapedSignEnabled = this.prefStore.getBoolean("scala.tools.eclipse.editor.autoRemoveEscapedSign");
        if (command.length > 1) {
            return;
        }
        String string = command.text;
        if ("\\".equals(string) && isAutoEscapeSignEnabled) {
            this.handleEscapeSign$1(document, command);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("\"".equals(string)) {
            this.handleClosingLiteral$1(document, command, isAutoEscapeLiteralEnabled);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("".equals(string) && isAutoRemoveEscapedSignEnabled) {
            this.removeEscapedSign$1(document, command);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final boolean ch$1(int i, char c, IDocument document$1, DocumentCommand command$1) {
        int o = command$1.offset + i;
        return o >= 0 && o < document$1.getLength() && document$1.getChar(o) == c;
    }

    private final boolean isStringTerminated$1(IDocument document$1, DocumentCommand command$1) {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document$1, (String)this.partitioning, (int)command$1.offset, (boolean)true);
        int endPos = partition.getOffset() + partition.getLength() - 1;
        boolean isStringTerminated = document$1.getChar(endPos) == '\"';
        boolean isTerminationEscaped = document$1.getChar(endPos - 1) == '\\';
        return isStringTerminated && !isTerminationEscaped;
    }

    private final boolean isEscapeSequence$1(int i, IDocument document$1, DocumentCommand command$1) {
        return new StringOps(Predef$.MODULE$.augmentString("btnfr\"'\\")).contains((Object)BoxesRunTime.boxToCharacter((char)document$1.getChar(command$1.offset + i)));
    }

    private final void removeEscapedSign$1(IDocument document$1, DocumentCommand command$1) {
        if (this.ch$1(-1, '\\', document$1, command$1) && this.isEscapeSequence$1(0, document$1, command$1)) {
            Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter(Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter$default$1());
            command$1.length = 2;
            --command$1.offset;
        } else if (this.ch$1(0, '\\', document$1, command$1) && this.isEscapeSequence$1(1, document$1, command$1)) {
            if (this.ch$1(1, '\"', document$1, command$1)) {
                if (this.isStringTerminated$1(document$1, command$1)) {
                    Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter(Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter$default$1());
                    command$1.length = 2;
                }
            } else {
                Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter(Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter$default$1());
                command$1.length = 2;
            }
        }
    }

    private final void jumpOverClosingLiteral$1(DocumentCommand command$1) {
        command$1.text = "";
        command$1.caretOffset = command$1.offset + 1;
    }

    private final void handleClosingLiteral$1(IDocument document$1, DocumentCommand command$1, boolean isAutoEscapeLiteralEnabled$1) {
        if (this.ch$1(0, '\"', document$1, command$1) && this.ch$1(-1, '\"', document$1, command$1) && !this.ch$1(-2, '\\', document$1, command$1)) {
            this.jumpOverClosingLiteral$1(command$1);
        } else if (isAutoEscapeLiteralEnabled$1 && this.isStringTerminated$1(document$1, command$1)) {
            Features$AutoEscapeLiterals$.MODULE$.incUsageCounter(Features$AutoEscapeLiterals$.MODULE$.incUsageCounter$default$1());
            if (this.ch$1(-1, '\\', document$1, command$1)) {
                if (this.ch$1(-2, '\\', document$1, command$1)) {
                    command$1.text = "\\\"";
                }
            } else {
                command$1.text = "\\\"";
            }
        }
    }

    private final void handleEscapeSign$1(IDocument document$1, DocumentCommand command$1) {
        Features$AutoEscapeBackslashes$.MODULE$.incUsageCounter(Features$AutoEscapeBackslashes$.MODULE$.incUsageCounter$default$1());
        if (this.ch$1(-1, '\\', document$1, command$1)) {
            if (this.ch$1(-2, '\\', document$1, command$1)) {
                command$1.text = "\\\\";
            }
        } else {
            command$1.text = "\\\\";
        }
    }

    public StringAutoEditStrategy(String partitioning, IPreferenceStore prefStore) {
        this.partitioning = partitioning;
        this.prefStore = prefStore;
    }
}

