/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.ui.internal.editor.autoedits;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.scalaide.core.internal.statistics.Features$AutoEscapeBackslashes$;
import org.scalaide.core.internal.statistics.Features$AutoRemoveEscapedSign$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u001f\t9B*\u001b;fe\u0006d\u0017)\u001e;p\u000b\u0012LGo\u0015;sCR,w-\u001f\u0006\u0003\u0007\u0011\t\u0011\"Y;u_\u0016$\u0017\u000e^:\u000b\u0005\u00151\u0011AB3eSR|'O\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u0005\u0011Q/\u001b\u0006\u0003\u00171\t\u0001b]2bY\u0006LG-\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\r\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u0011\u000e\u0003iQ!a\u0007\u000f\u0002\tQ,\u0007\u0010\u001e\u0006\u0003;y\tQA\u001b4bG\u0016T!a\b\u0007\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011\u0011E\u0007\u0002\u0012\u0013\u0006+Ho\\#eSR\u001cFO]1uK\u001eL\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0013A\u0014XMZ*u_J,\u0007CA\u0013)\u001b\u00051#BA\u0014\u001d\u0003)\u0001(/\u001a4fe\u0016t7-Z\u0005\u0003S\u0019\u0012\u0001#\u0013)sK\u001a,'/\u001a8dKN#xN]3\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\tis\u0006\u0005\u0002/\u00015\t!\u0001C\u0003$U\u0001\u0007A\u0005C\u00032\u0001\u0011\u0005#'\u0001\rdkN$x.\\5{K\u0012{7-^7f]R\u001cu.\\7b]\u0012$2aM\u001d?!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;\t\u000bi\u0002\u0004\u0019A\u001e\u0002\u0011\u0011|7-^7f]R\u0004\"!\u0007\u001f\n\u0005uR\"!C%E_\u000e,X.\u001a8u\u0011\u0015y\u0004\u00071\u0001A\u0003\u001d\u0019w.\\7b]\u0012\u0004\"!G!\n\u0005\tS\"a\u0004#pGVlWM\u001c;D_6l\u0017M\u001c3")
public class LiteralAutoEditStrategy
implements IAutoEditStrategy {
    private final IPreferenceStore prefStore;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        boolean isMultiLineStringLiteral;
        boolean isAutoEscapeSignEnabled = this.prefStore.getBoolean("scala.tools.eclipse.editor.autoEscapeSign");
        boolean isAutoRemoveEscapedSignEnabled = this.prefStore.getBoolean("scala.tools.eclipse.editor.autoRemoveEscapedSign");
        if (command.length > 1) {
            return;
        }
        boolean isCharacterLiteral = this.ch$1(-1, '\'', document, command) && this.ch$1(0, '\'', document, command);
        boolean bl = isMultiLineStringLiteral = this.ch$1(-2, '\"', document, command) && this.ch$1(-1, '\"', document, command);
        if (isMultiLineStringLiteral) {
            this.customizeMultiLineLiteral$1(command);
        } else if (isCharacterLiteral) {
            this.customizeLiteral$1(document, command, isAutoEscapeSignEnabled, isAutoRemoveEscapedSignEnabled);
        } else {
            this.customizeChar$1(document, command, isAutoRemoveEscapedSignEnabled);
        }
    }

    private final boolean ch$1(int i, char c, IDocument document$1, DocumentCommand command$1) {
        int o = command$1.offset + i;
        return o >= 0 && o < document$1.getLength() && document$1.getChar(o) == c;
    }

    private final boolean isEscapeSequence$1(int i, IDocument document$1, DocumentCommand command$1) {
        return new StringOps(Predef$.MODULE$.augmentString("btnfr\"'\\")).contains((Object)BoxesRunTime.boxToCharacter((char)document$1.getChar(command$1.offset + i)));
    }

    private final void removeLiteral$1(IDocument document$1, DocumentCommand command$1) {
        if (this.ch$1(-1, '\\', document$1, command$1) && this.isEscapeSequence$1(0, document$1, command$1)) {
            command$1.length = 2;
            --command$1.offset;
        } else if (this.ch$1(0, '\\', document$1, command$1) && this.isEscapeSequence$1(1, document$1, command$1)) {
            if (this.ch$1(1, '\'', document$1, command$1)) {
                if (this.ch$1(2, '\'', document$1, command$1)) {
                    command$1.length = 2;
                }
            } else {
                command$1.length = 2;
            }
        } else if (this.ch$1(0, '\"', document$1, command$1) && this.ch$1(1, '\"', document$1, command$1) || this.ch$1(0, '\'', document$1, command$1) && this.ch$1(1, '\'', document$1, command$1)) {
            command$1.length = 2;
        }
    }

    private final void removeEscapedSign$1(IDocument document$1, DocumentCommand command$1) {
        if (this.ch$1(-1, '\\', document$1, command$1)) {
            Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter(Features$AutoRemoveEscapedSign$.MODULE$.incUsageCounter$default$1());
            command$1.length = 2;
            --command$1.offset;
        }
    }

    private final void jumpOverClosingLiteral$1(DocumentCommand command$1) {
        command$1.text = "";
        command$1.caretOffset = command$1.offset + 1;
    }

    private final void handleClosingLiteral$1(IDocument document$1, DocumentCommand command$1) {
        boolean isCharFilled;
        boolean bl = this.ch$1(-1, '\'', document$1, command$1) ? this.ch$1(-2, '\\', document$1, command$1) : (isCharFilled = !this.ch$1(-1, '\\', document$1, command$1));
        if (this.ch$1(0, '\'', document$1, command$1) && isCharFilled) {
            this.jumpOverClosingLiteral$1(command$1);
        }
    }

    private final void handleEscapeSign$1(IDocument document$1, DocumentCommand command$1) {
        Features$AutoEscapeBackslashes$.MODULE$.incUsageCounter(Features$AutoEscapeBackslashes$.MODULE$.incUsageCounter$default$1());
        if (!this.ch$1(-1, '\\', document$1, command$1)) {
            command$1.text = "\\\\";
        }
    }

    private final void handleClosingMultiLineLiteral$1(DocumentCommand command$1) {
        command$1.caretOffset = command$1.offset + 1;
        command$1.text = new StringOps(Predef$.MODULE$.augmentString(command$1.text)).$times(4);
        command$1.shiftsCaret = false;
    }

    private final void customizeLiteral$1(IDocument document$1, DocumentCommand command$1, boolean isAutoEscapeSignEnabled$1, boolean isAutoRemoveEscapedSignEnabled$1) {
        String string = command$1.text;
        if ("\\".equals(string) && isAutoEscapeSignEnabled$1) {
            this.handleEscapeSign$1(document$1, command$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("'".equals(string)) {
            this.handleClosingLiteral$1(document$1, command$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("".equals(string) && isAutoRemoveEscapedSignEnabled$1) {
            this.removeEscapedSign$1(document$1, command$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final boolean isEmptyLiteral$1(IDocument document$1, DocumentCommand command$1) {
        return (this.ch$1(0, '\'', document$1, command$1) && this.ch$1(1, '\'', document$1, command$1) || this.ch$1(0, '\"', document$1, command$1) && this.ch$1(1, '\"', document$1, command$1)) && !this.ch$1(-1, '\\', document$1, command$1);
    }

    private final void deleteEmptyLiteral$1(DocumentCommand command$1) {
        command$1.length = 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void customizeChar$1(IDocument document$1, DocumentCommand command$1, boolean isAutoRemoveEscapedSignEnabled$1) {
        boolean bl = false;
        String string = null;
        String string2 = command$1.text;
        if ("".equals(string2)) {
            bl = true;
            string = string2;
            if (this.isEmptyLiteral$1(document$1, command$1)) {
                this.deleteEmptyLiteral$1(command$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && isAutoRemoveEscapedSignEnabled$1) {
            this.removeLiteral$1(document$1, command$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void customizeMultiLineLiteral$1(DocumentCommand command$1) {
        String string = command$1.text;
        if ("\"".equals(string)) {
            this.handleClosingMultiLineLiteral$1(command$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LiteralAutoEditStrategy(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
    }
}

