/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.core.internal.logging.log4j;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.scalaide.core.internal.logging.log4j.Log4JFacade;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0001\u00059\u00111\u0002T8hi)\u001buN\u001c4jO*\u00111\u0001B\u0001\u0006Y><GG\u001b\u0006\u0003\u000b\u0019\tq\u0001\\8hO&twM\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u0005!1m\u001c:f\u0015\tYA\"\u0001\u0005tG\u0006d\u0017-\u001b3f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u0011!Q\u0001\na\t!\u0002\\8h\u001b\u0006t\u0017mZ3s\u0007\u0001\u0001\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u00171{w\r\u000e&GC\u000e\fG-\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0001\u0003CA\r\u0001\u0011\u00151B\u00041\u0001\u0019\u0011\u001d\u0011\u0003A1A\u0005\n\r\na\u0001\\1z_V$X#\u0001\u0013\u0011\u0005\u0015JS\"\u0001\u0014\u000b\u0005\r9#B\u0001\u0015\r\u0003\u0019\t\u0007/Y2iK&\u0011!F\n\u0002\u000e!\u0006$H/\u001a:o\u0019\u0006Lx.\u001e;\t\r1\u0002\u0001\u0015!\u0003%\u0003\u001da\u0017-_8vi\u0002BqA\f\u0001C\u0002\u0013%q&A\bd_:\u001cx\u000e\\3BaB,g\u000eZ3s+\u0005\u0001\u0004CA\u00132\u0013\t\u0011dEA\bD_:\u001cx\u000e\\3BaB,g\u000eZ3s\u0011\u0019!\u0004\u0001)A\u0005a\u0005\u00012m\u001c8t_2,\u0017\t\u001d9f]\u0012,'\u000f\t\u0005\u0006m\u0001!\taN\u0001\nG>tg-[4ve\u0016$2\u0001O\u001eF!\t\u0001\u0012(\u0003\u0002;#\t!QK\\5u\u0011\u0015aT\u00071\u0001>\u0003\u001dawn\u001a$jY\u0016\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u0005%|'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012AAR5mK\")a)\u000ea\u0001\u000f\u0006\t\u0002O]3gKJ\u0014X\r\u001a'pO2+g/\u001a7\u0011\u0005\u0015B\u0015BA%'\u0005\u0015aUM^3m\u0011\u0015Y\u0005\u0001\"\u0001M\u0003I\tG\rZ\"p]N|G.Z!qa\u0016tG-\u001a:\u0015\u0003aBQA\u0014\u0001\u0005\u00021\u000bQC]3n_Z,7i\u001c8t_2,\u0017\t\u001d9f]\u0012,'\u000f")
public class Log4JConfig {
    private final Log4JFacade logManager;
    private final PatternLayout layout;
    private final ConsoleAppender consoleAppender;

    private PatternLayout layout() {
        return this.layout;
    }

    private ConsoleAppender consoleAppender() {
        return this.consoleAppender;
    }

    public void configure(File logFile, Level preferredLogLevel) {
        RollingFileAppender appender = new RollingFileAppender((Layout)this.layout(), logFile.getAbsolutePath(), true);
        Logger rootLogger = this.logManager.getRootLogger();
        rootLogger.setLevel(preferredLogLevel);
        rootLogger.addAppender((Appender)appender);
        if (this.logManager.isConsoleAppenderEnabled()) {
            this.addConsoleAppender();
        }
    }

    public void addConsoleAppender() {
        Logger rootLogger = this.logManager.getRootLogger();
        rootLogger.addAppender((Appender)this.consoleAppender());
    }

    public void removeConsoleAppender() {
        Logger rootLogger = this.logManager.getRootLogger();
        rootLogger.removeAppender((Appender)this.consoleAppender());
    }

    public Log4JConfig(Log4JFacade logManager) {
        this.logManager = logManager;
        this.layout = new PatternLayout("%d %5p [%t] - %c - %m%n");
        this.consoleAppender = new ConsoleAppender((Layout)this.layout(), "System.out");
    }
}

