/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.core.internal.logging;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.scalaide.core.internal.ScalaPlugin$;
import org.scalaide.core.internal.logging.StreamRedirect$;
import org.scalaide.core.internal.logging.log4j.Log4JFacade;
import org.scalaide.logging.HasLogger;
import org.scalaide.logging.HasLogger$class;
import org.scalaide.logging.Level$;
import org.scalaide.logging.Logger;
import org.scalaide.util.eclipse.SWTUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LogManager$
extends Log4JFacade
implements HasLogger {
    public static final LogManager$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LogManager$();
    }

    private Logger logger$lzycompute() {
        LogManager$ logManager$ = this;
        synchronized (logManager$) {
            if (!this.bitmap$0) {
                this.logger = HasLogger$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Logger eclipseLog() {
        return HasLogger$class.eclipseLog(this);
    }

    public void org$scalaide$core$internal$logging$LogManager$$updateLogLevel(PropertyChangeEvent event) {
        String string = event.getProperty();
        String string2 = "scala.tools.eclipse.logging.ui.properties.LogLevel";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String level = (String)event.getNewValue();
            this.setLogLevel(Level$.MODULE$.withName(level));
        }
    }

    public void org$scalaide$core$internal$logging$LogManager$$updateConsoleAppenderStatus(PropertyChangeEvent event) {
        String string = event.getProperty();
        String string2 = "scala.tools.eclipse.logging.ui.properties.ConsoleAppenderEnabled";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            boolean enable = BoxesRunTime.unboxToBoolean((Object)event.getNewValue());
            this.withoutConsoleRedirects((Function0<BoxedUnit>)new Serializable(enable){
                public static final long serialVersionUID = 0L;
                private final boolean enable$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    LogManager$.MODULE$.updateConsoleAppender(this.enable$1);
                }
                {
                    this.enable$1 = enable$1;
                }
            });
        }
    }

    public void org$scalaide$core$internal$logging$LogManager$$updateStdRedirectStatus(PropertyChangeEvent event) {
        String string = event.getProperty();
        String string2 = "scala.tools.eclipse.logging.ui.properties.RedirectSdtErrOut";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            boolean enable = BoxesRunTime.unboxToBoolean((Object)event.getNewValue());
            if (enable) {
                this.redirectStdOutAndStdErr();
            } else {
                this.disableRedirectStdOutAndStdErr();
            }
            if (enable != BoxesRunTime.unboxToBoolean((Object)event.getOldValue())) {
                ScalaPlugin$.MODULE$.apply().resetAllPresentationCompilers();
            }
        }
    }

    @Override
    public String logFileName() {
        return "scala-ide.log";
    }

    @Override
    public void configure(String logOutputLocation, Enumeration.Value preferredLogLevel) {
        super.configure(logOutputLocation, preferredLogLevel);
        IPreferenceStore prefStore = ScalaPlugin$.MODULE$.apply().getPreferenceStore();
        prefStore.addPropertyChangeListener(SWTUtils$.MODULE$.fnToPropertyChangeListener((Function1<PropertyChangeEvent, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(PropertyChangeEvent event) {
                LogManager$.MODULE$.org$scalaide$core$internal$logging$LogManager$$updateLogLevel(event);
            }
        }));
        prefStore.addPropertyChangeListener(SWTUtils$.MODULE$.fnToPropertyChangeListener((Function1<PropertyChangeEvent, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(PropertyChangeEvent event) {
                LogManager$.MODULE$.org$scalaide$core$internal$logging$LogManager$$updateConsoleAppenderStatus(event);
            }
        }));
        prefStore.addPropertyChangeListener(SWTUtils$.MODULE$.fnToPropertyChangeListener((Function1<PropertyChangeEvent, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(PropertyChangeEvent event) {
                LogManager$.MODULE$.org$scalaide$core$internal$logging$LogManager$$updateStdRedirectStatus(event);
            }
        }));
        if (prefStore.getBoolean("scala.tools.eclipse.logging.ui.properties.RedirectSdtErrOut")) {
            this.redirectStdOutAndStdErr();
            ScalaPlugin$.MODULE$.apply().resetAllPresentationCompilers();
        }
    }

    @Override
    public void setLogLevel(Enumeration.Value level) {
        super.setLogLevel(level);
        this.logger().info((Function0<Object>)new Serializable(level){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value level$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Log level is `%s`")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.level$1}));
            }
            {
                this.level$1 = level$1;
            }
        });
    }

    @Override
    public Enumeration.Value currentLogLevel() {
        String levelName = ScalaPlugin$.MODULE$.apply().getPreferenceStore().getString("scala.tools.eclipse.logging.ui.properties.LogLevel");
        return levelName.isEmpty() ? this.defaultLogLevel() : Level$.MODULE$.withName(levelName);
    }

    public Enumeration.Value defaultLogLevel() {
        return Level$.MODULE$.WARN();
    }

    @Override
    public boolean isConsoleAppenderEnabled() {
        return ScalaPlugin$.MODULE$.apply().getPreferenceStore().getBoolean("scala.tools.eclipse.logging.ui.properties.ConsoleAppenderEnabled");
    }

    private void withoutConsoleRedirects(Function0<BoxedUnit> f) {
        try {
            this.disableRedirectStdOutAndStdErr();
            f.apply$mcV$sp();
            return;
        }
        finally {
            this.redirectStdOutAndStdErr();
        }
    }

    private void redirectStdOutAndStdErr() {
        StreamRedirect$.MODULE$.redirectStdOutput();
        StreamRedirect$.MODULE$.redirectStdError();
    }

    private void disableRedirectStdOutAndStdErr() {
        StreamRedirect$.MODULE$.disableRedirectStdOutput();
        StreamRedirect$.MODULE$.disableRedirectStdError();
    }

    private LogManager$() {
        MODULE$ = this;
        HasLogger$class.$init$(this);
    }
}

