/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.core.internal.lexical;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.scalaide.core.internal.lexical.WordMatcher;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0005\u001b\t\u00012i\\7cS:,GmV8sIJ+H.\u001a\u0006\u0003\u0007\u0011\tq\u0001\\3yS\u000e\fGN\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\tI!\"\u0001\u0005tG\u0006d\u0017-\u001b3f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u0018A5\t\u0001D\u0003\u0002\u001a5\u0005)!/\u001e7fg*\u00111\u0004H\u0001\u0005i\u0016DHO\u0003\u0002\u001e=\u0005)!NZ1dK*\u0011qDC\u0001\bK\u000ed\u0017\u000e]:f\u0013\t\t\u0003DA\u0003J%VdW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003!!W\r^3di>\u0014\bCA\f&\u0013\t1\u0003DA\u0007J/>\u0014H\rR3uK\u000e$xN\u001d\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u00059Q.\u0019;dQ\u0016\u0014\bC\u0001\u0016,\u001b\u0005\u0011\u0011B\u0001\u0017\u0003\u0005-9vN\u001d3NCR\u001c\u0007.\u001a:\t\u000b9\u0002A\u0011A\u0018\u0002\rqJg.\u001b;?)\r\u0001\u0014G\r\t\u0003U\u0001AQaI\u0017A\u0002\u0011BQ\u0001K\u0017A\u0002%BQ\u0001\u000e\u0001\u0005BU\n\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003me\u0002\"aF\u001c\n\u0005aB\"AB%U_.,g\u000eC\u0003;g\u0001\u00071(A\u0004tG\u0006tg.\u001a:\u0011\u0005]a\u0014BA\u001f\u0019\u0005EI5\t[1sC\u000e$XM]*dC:tWM\u001d")
public class CombinedWordRule
implements IRule {
    private final IWordDetector detector;
    private final WordMatcher matcher;

    public IToken evaluate(ICharacterScanner scanner) {
        IToken iToken;
        char wordStart = (char)scanner.read();
        if (this.detector.isWordStart(wordStart)) {
            StringBuilder word = new StringBuilder().append(wordStart);
            char c = (char)scanner.read();
            while (c != '\uffffffff' && this.detector.isWordPart(c)) {
                word.append(c);
                c = (char)scanner.read();
            }
            scanner.unread();
            IToken tok = this.matcher.evaluate(word.toString());
            if (tok.isUndefined()) {
                int i = word.length();
                while (--i >= 0) {
                    scanner.unread();
                }
                iToken = Token.UNDEFINED;
            } else {
                iToken = tok;
            }
        } else {
            scanner.unread();
            iToken = Token.UNDEFINED;
        }
        return iToken;
    }

    public CombinedWordRule(IWordDetector detector, WordMatcher matcher) {
        this.detector = detector;
        this.matcher = matcher;
    }
}

