/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.eclipse.contribution.weaving.jdt.jcompiler;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import scala.tools.eclipse.contribution.weaving.jdt.jcompiler.ExpandableResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildManagerStore {
    public static final BuildManagerStore INSTANCE = new BuildManagerStore();
    private Map<IProject, File[]> projectToJavaSourceFiles = new HashMap<IProject, File[]>();

    private BuildManagerStore() {
    }

    public IResourceDelta appendJavaSourceFilesToCompile(IResourceDelta delta, IProject project) {
        if (delta == null) {
            return delta;
        }
        File[] files = this.projectToJavaSourceFiles.get(project);
        if (files == null || files.length == 0) {
            return delta;
        }
        ExpandableResourceDelta newDelta = ExpandableResourceDelta.duplicate(delta);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IFile[] iFileArray = workspaceRoot.findFilesForLocationURI(file.toURI());
            int n3 = iFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile resource = iFileArray[n4];
                if (resource.getProject() == project) {
                    newDelta.addChangedResource((IResource)resource);
                }
                ++n4;
            }
            ++n2;
        }
        return newDelta;
    }

    public void setJavaSourceFilesToCompile(File[] files, IProject project) {
        if (files == null) {
            this.projectToJavaSourceFiles.remove(project);
        } else {
            this.projectToJavaSourceFiles.put(project, files);
        }
    }

    private IProject project(AbstractImageBuilder imageBuilder) {
        Field[] fields = AbstractImageBuilder.class.getDeclaredFields();
        Field javaBuilderField = null;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if ("javaBuilder".equals(f.getName())) {
                javaBuilderField = f;
                javaBuilderField.setAccessible(true);
            }
            ++n2;
        }
        JavaBuilder builder = null;
        try {
            builder = (JavaBuilder)javaBuilderField.get(imageBuilder);
            if (builder == null) {
                throw new IllegalArgumentException("java builder of image builder is null");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("image builder met problems with retrieving java builder", e);
        }
        return builder.getProject();
    }

    public void filterProjectSources(List<SourceFile> sources, AbstractImageBuilder imageBuilder) {
        IProject project = this.project(imageBuilder);
        if (!this.isScalaProject(project)) {
            return;
        }
        ArrayList<SourceFile> sourcesToCompile = new ArrayList<SourceFile>();
        File[] scopeProjectSources = this.projectToJavaSourceFiles.get(project);
        ArrayList projectFiles = scopeProjectSources != null ? Arrays.asList(scopeProjectSources) : new ArrayList();
        for (SourceFile source : sources) {
            File file = source.resource.getRawLocation().makeAbsolute().toFile();
            if (!projectFiles.contains(file)) continue;
            sourcesToCompile.add(source);
        }
        sources.retainAll(sourcesToCompile);
    }

    private boolean isScalaProject(IProject project) {
        try {
            return project.hasNature("org.scala-ide.sdt.core.scalanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

