/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDelta
extends Delta {
    public DeleteDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size2 = this.getOriginal().size();
        for (int i = 0; i < size2; ++i) {
            target.remove(position);
        }
    }

    @Override
    public void restore(List<Object> target) {
        int position = this.getRevised().getPosition();
        List<?> lines2 = this.getOriginal().getLines();
        for (int i = 0; i < lines2.size(); ++i) {
            target.add(position + i, lines2.get(i));
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + "]";
    }
}

