/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeDelta
extends Delta {
    public ChangeDelta(Chunk original, Chunk revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<Object> target) throws PatchFailedException {
        int i;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size2 = this.getOriginal().size();
        for (i = 0; i < size2; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<Object> target) {
        int i;
        int position = this.getRevised().getPosition();
        int size2 = this.getRevised().size();
        for (i = 0; i < size2; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getOriginal().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void verify(List<?> target) throws PatchFailedException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + " to " + this.getRevised().getLines() + "]";
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

