/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.model;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.scalaide.debug.internal.JDIUtil$;
import org.scalaide.debug.internal.ScalaDebugPlugin$;
import org.scalaide.debug.internal.ScalaDebugger$;
import org.scalaide.debug.internal.model.ScalaArrayReference;
import org.scalaide.debug.internal.model.ScalaObjectReference;
import org.scalaide.debug.internal.model.ScalaPrimitiveValue;
import org.scalaide.debug.internal.model.ScalaThread;
import org.scalaide.debug.internal.model.ScalaValue;
import org.scalaide.debug.internal.model.ScalaValue$;
import org.scalaide.logging.HasLogger;
import org.scalaide.logging.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ScalaLogicalStructureProvider$
implements ILogicalStructureType,
HasLogger {
    public static final ScalaLogicalStructureProvider$ MODULE$;
    private ILogicalStructureType[] org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes;
    private final String getId;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new ScalaLogicalStructureProvider$();
    }

    private ILogicalStructureType[] org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes$lzycompute() {
        ScalaLogicalStructureProvider$ scalaLogicalStructureProvider$ = this;
        synchronized (scalaLogicalStructureProvider$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes = (ILogicalStructureType[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ILogicalStructureType.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes;
        }
    }

    private Logger logger$lzycompute() {
        ScalaLogicalStructureProvider$ scalaLogicalStructureProvider$ = this;
        synchronized (scalaLogicalStructureProvider$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = HasLogger.class.logger((HasLogger)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public Logger eclipseLog() {
        return HasLogger.class.eclipseLog((HasLogger)this);
    }

    public ILogicalStructureType[] org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes$lzycompute() : this.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$emptyLogicalStructureTypes;
    }

    public boolean isScalaCollection(ScalaObjectReference objectReference) {
        return BoxesRunTime.unboxToBoolean((Object)objectReference.wrapJDIException("Exception while checking if passed object reference is a Scala collection type").apply((Function0)new Serializable(objectReference){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference objectReference$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ScalaLogicalStructureProvider$.MODULE$.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$checkIfImplements(this.objectReference$1.referenceType(), "scala.collection.TraversableOnce");
            }
            {
                this.objectReference$1 = objectReference$1;
            }
        }));
    }

    public boolean isTraversableLike(ScalaObjectReference objectReference) {
        return BoxesRunTime.unboxToBoolean((Object)objectReference.wrapJDIException("Exception while checking if passed object reference is TraversableLike").apply((Function0)new Serializable(objectReference){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference objectReference$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ScalaLogicalStructureProvider$.MODULE$.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$checkIfImplements(this.objectReference$2.referenceType(), "scala.collection.TraversableLike");
            }
            {
                this.objectReference$2 = objectReference$2;
            }
        }));
    }

    public String getDescription() {
        return "Flat the Scala collections";
    }

    public String getId() {
        return this.getId;
    }

    public IValue getLogicalStructure(IValue value) {
        return (IValue)this.callToArray(value).getOrElse((Function0)new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final IValue value$1;

            public final IValue apply() {
                return this.value$1;
            }
            {
                this.value$1 = value$1;
            }
        });
    }

    public boolean providesLogicalStructure(IValue value) {
        return true;
    }

    public String getDescription(IValue value) {
        return this.getDescription();
    }

    public boolean org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$checkIfImplements(ReferenceType refType, String interfaceName) {
        boolean bl;
        ReferenceType referenceType2 = refType;
        if (referenceType2 instanceof ClassType) {
            ClassType classType = (ClassType)referenceType2;
            bl = JDIUtil$.MODULE$.implements(classType, interfaceName);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean hasDefiniteSize(ScalaObjectReference collectionRef, ScalaThread thread) {
        return BoxesRunTime.unboxToBoolean((Object)collectionRef.wrapJDIException("Exception while checking if collection has definite size").apply((Function0)new Serializable(collectionRef, thread){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference collectionRef$2;
            private final ScalaThread thread$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((BooleanValue)((ScalaPrimitiveValue)this.collectionRef$2.invokeMethod("hasDefiniteSize", "()Z", this.thread$2, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]))).underlying()).value();
            }
            {
                this.collectionRef$2 = collectionRef$2;
                this.thread$2 = thread$2;
            }
        }));
    }

    public ScalaThread hasDefiniteSize$default$2() {
        return ScalaDebugger$.MODULE$.currentThread();
    }

    public boolean callIsEmpty(ScalaObjectReference collectionRef, ScalaThread thread) {
        return BoxesRunTime.unboxToBoolean((Object)collectionRef.wrapJDIException("Exception while checking if collection is empty").apply((Function0)new Serializable(collectionRef, thread){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference collectionRef$3;
            private final ScalaThread thread$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((BooleanValue)((ScalaPrimitiveValue)this.collectionRef$3.invokeMethod("isEmpty", "()Z", this.thread$3, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]))).underlying()).value();
            }
            {
                this.collectionRef$3 = collectionRef$3;
                this.thread$3 = thread$3;
            }
        }));
    }

    public ScalaThread callIsEmpty$default$2() {
        return ScalaDebugger$.MODULE$.currentThread();
    }

    public ScalaArrayReference callToArray(ScalaObjectReference collectionRef, ScalaThread thread) {
        return (ScalaArrayReference)((Object)collectionRef.wrapJDIException("Exception while converting collection to Array").apply((Function0)new Serializable(collectionRef, thread){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference collectionRef$1;
            private final ScalaThread thread$1;

            public final ScalaArrayReference apply() {
                Tuple2 tuple2;
                Tuple2 tuple22 = tuple2 = this.collectionRef$1.getDebugTarget().is2_10Compatible(this.thread$1) ? new Tuple2((Object)this.collectionRef$1.getDebugTarget().objectByName("scala.reflect.ClassManifestFactory", false, null), (Object)"(Lscala/reflect/ClassTag;)Ljava/lang/Object;") : new Tuple2((Object)this.collectionRef$1.getDebugTarget().objectByName("scala.reflect.Manifest", false, null), (Object)"(Lscala/reflect/ClassManifest;)Ljava/lang/Object;");
                if (tuple2 != null) {
                    Tuple2 tuple23;
                    ScalaObjectReference manifestObject = (ScalaObjectReference)tuple2._1();
                    String toArraySignature = (String)tuple2._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)manifestObject, (Object)toArraySignature);
                    ScalaObjectReference manifestObject2 = (ScalaObjectReference)tuple24._1();
                    String toArraySignature2 = (String)tuple24._2();
                    ScalaValue scalaValue = manifestObject2.invokeMethod("Any", this.thread$1, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]));
                    if (scalaValue instanceof ScalaObjectReference) {
                        ScalaObjectReference scalaObjectReference;
                        ScalaObjectReference scalaObjectReference2;
                        ScalaObjectReference anyManifestObject = scalaObjectReference2 = (scalaObjectReference = (ScalaObjectReference)scalaValue);
                        return (ScalaArrayReference)this.collectionRef$1.invokeMethod("toArray", toArraySignature2, this.thread$1, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[]{anyManifestObject}));
                    }
                    throw new Exception("Unexpected return value for Manifest.Any()");
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.collectionRef$1 = collectionRef$1;
                this.thread$1 = thread$1;
            }
        }));
    }

    public Tuple2<ScalaObjectReference, ScalaObjectReference> splitCollection(ScalaObjectReference traversableLikeRef, int splitAtIndex, ScalaThread thread) {
        return (Tuple2)traversableLikeRef.wrapJDIException("Exception while splitting collection at index $index").apply((Function0)new Serializable(traversableLikeRef, splitAtIndex, thread){
            public static final long serialVersionUID = 0L;
            private final ScalaObjectReference traversableLikeRef$1;
            private final int splitAtIndex$1;
            private final ScalaThread thread$4;

            public final Tuple2<ScalaObjectReference, ScalaObjectReference> apply() {
                ScalaValue arg = ScalaValue$.MODULE$.apply(BoxesRunTime.boxToInteger((int)this.splitAtIndex$1), this.traversableLikeRef$1.getDebugTarget());
                ScalaObjectReference tupleWithParts = (ScalaObjectReference)this.traversableLikeRef$1.invokeMethod("splitAt", "(I)Lscala/Tuple2;", this.thread$4, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[]{arg}));
                ScalaObjectReference firstPart = ScalaLogicalStructureProvider$.MODULE$.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$getElementOfTuple(tupleWithParts, 1, this.thread$4);
                ScalaObjectReference secondPart = ScalaLogicalStructureProvider$.MODULE$.org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$getElementOfTuple(tupleWithParts, 2, this.thread$4);
                return new Tuple2((Object)firstPart, (Object)secondPart);
            }
            {
                this.traversableLikeRef$1 = traversableLikeRef$1;
                this.splitAtIndex$1 = splitAtIndex$1;
                this.thread$4 = thread$4;
            }
        });
    }

    public ScalaThread splitCollection$default$3() {
        return ScalaDebugger$.MODULE$.currentThread();
    }

    public ScalaObjectReference org$scalaide$debug$internal$model$ScalaLogicalStructureProvider$$getElementOfTuple(ScalaObjectReference tupleRef, int elementNumber, ScalaThread thread) {
        Predef$.MODULE$.require(elementNumber > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tuple element number must be positive"})).s((Seq)Nil$.MODULE$);
            }
        });
        return (ScalaObjectReference)tupleRef.invokeMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)elementNumber)})), "()Ljava/lang/Object;", thread, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]));
    }

    private Option<IValue> callToArray(IValue value) {
        Some some;
        ScalaObjectReference scalaValue = (ScalaObjectReference)value;
        try {
            some = new Some((Object)this.callToArray(scalaValue, this.callToArray$default$2()));
        }
        catch (Exception exception) {
            this.logger().debug((Function0)new Serializable(scalaValue){
                public static final long serialVersionUID = 0L;
                private final ScalaObjectReference scalaValue$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Failed to compute logical structure for '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.scalaValue$1}));
                }
                {
                    this.scalaValue$1 = scalaValue$1;
                }
            }, (Throwable)exception);
            some = None$.MODULE$;
        }
        return some;
    }

    public ScalaThread callToArray$default$2() {
        return ScalaDebugger$.MODULE$.currentThread();
    }

    private ScalaLogicalStructureProvider$() {
        MODULE$ = this;
        HasLogger.class.$init$((HasLogger)this);
        this.getId = new StringBuilder().append((Object)ScalaDebugPlugin$.MODULE$.id()).append((Object)".logicalstructure.collection").toString();
    }
}

