/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.model;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;
import org.scalaide.debug.internal.JdiEventReceiver;
import org.scalaide.debug.internal.JdiEventReceiver$class;
import org.scalaide.debug.internal.async.BreakOnDeadLetters;
import org.scalaide.debug.internal.async.RetainedStackManager;
import org.scalaide.debug.internal.breakpoints.ScalaDebugBreakpointManager;
import org.scalaide.debug.internal.hcr.ScalaHotCodeReplaceManager;
import org.scalaide.debug.internal.model.ScalaClassType;
import org.scalaide.debug.internal.model.ScalaDebugCache;
import org.scalaide.debug.internal.model.ScalaDebugElement;
import org.scalaide.debug.internal.model.ScalaDebugTarget$;
import org.scalaide.debug.internal.model.ScalaDebugTargetSubordinate;
import org.scalaide.debug.internal.model.ScalaJdiEventDispatcher;
import org.scalaide.debug.internal.model.ScalaObjectReference;
import org.scalaide.debug.internal.model.ScalaReferenceType;
import org.scalaide.debug.internal.model.ScalaStringReference;
import org.scalaide.debug.internal.model.ScalaThread;
import org.scalaide.debug.internal.model.ScalaThread$;
import org.scalaide.debug.internal.model.ScalaType$;
import org.scalaide.debug.internal.model.ScalaValue;
import org.scalaide.debug.internal.model.ScalaValue$;
import org.scalaide.debug.internal.views.AsyncDebugView;
import org.scalaide.util.ui.DisplayThread$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rUw!B\u0001\u0003\u0011\u0003i\u0011\u0001E*dC2\fG)\u001a2vOR\u000b'oZ3u\u0015\t\u0019A!A\u0003n_\u0012,GN\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005)A-\u001a2vO*\u0011\u0011BC\u0001\tg\u000e\fG.Y5eK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\tTG\u0006d\u0017\rR3ck\u001e$\u0016M]4fiN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tIB$D\u0001\u001b\u0015\tY\u0002\"A\u0004m_\u001e<\u0017N\\4\n\u0005uQ\"!\u0003%bg2{wmZ3s\u0011\u0015yr\u0002\"\u0001!\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0003#\u001f\u0011\u00051%A\u0003baBd\u0017\u0010F\u0007%\u0007/\u001bIja'\u0004\u001e\u000e}5\u0011\u0015\t\u0003\u001d\u00152Q\u0001\u0005\u0002\u0002\u0002\u0019\u001aR!J\u0014+]a\u0001\"A\u0004\u0015\n\u0005%\u0012!!E*dC2\fG)\u001a2vO\u0016cW-\\3oiB\u00111\u0006L\u0007\u0002\t%\u0011Q\u0006\u0002\u0002\u0011\u0015\u0012LWI^3oiJ+7-Z5wKJ\u0004\"a\f\u001c\u000e\u0003AR!aA\u0019\u000b\u0005I\u001a\u0014\u0001B2pe\u0016T!a\u0002\u001b\u000b\u0005UR\u0011aB3dY&\u00048/Z\u0005\u0003oA\u0012A\"\u0013#fEV<G+\u0019:hKRD\u0001\"O\u0013\u0003\u0006\u0004%\tAO\u0001\u000fm&\u0014H/^1m\u001b\u0006\u001c\u0007.\u001b8f+\u0005Y\u0004C\u0001\u001fD\u001b\u0005i$B\u0001 @\u0003\rQG-\u001b\u0006\u0003\u0001\u0006\u000b1a];o\u0015\u0005\u0011\u0015aA2p[&\u0011A)\u0010\u0002\u000f-&\u0014H/^1m\u001b\u0006\u001c\u0007.\u001b8f\u0011!1UE!A!\u0002\u0013Y\u0014a\u0004<jeR,\u0018\r\\'bG\"Lg.\u001a\u0011\t\u0011!+#\u0011!Q\u0001\n%\u000ba\u0001\\1v]\u000eD\u0007C\u0001&L\u001b\u0005\t\u0014B\u0001'2\u0005\u001dIE*Y;oG\"D\u0001BT\u0013\u0003\u0002\u0003\u0006IaT\u0001\baJ|7-Z:t!\ty\u0003+\u0003\u0002Ra\tA\u0011\n\u0015:pG\u0016\u001c8\u000f\u0003\u0005TK\t\u0005\t\u0015!\u0003U\u0003=\tG\u000e\\8x\t&\u001c8m\u001c8oK\u000e$\bCA\nV\u0013\t1FCA\u0004C_>dW-\u00198\t\u0011a+#\u0011!Q\u0001\nQ\u000ba\"\u00197m_^$VM]7j]\u0006$X\r\u0003\u0005[K\t\u0015\r\u0011\"\u0001\\\u0003%\u0019G.Y:t!\u0006$\b.F\u0001]!\r\u0019RlX\u0005\u0003=R\u0011aa\u00149uS>t\u0007c\u00011iW:\u0011\u0011M\u001a\b\u0003E\u0016l\u0011a\u0019\u0006\u0003I2\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005\u001d$\u0012a\u00029bG.\fw-Z\u0005\u0003S*\u00141aU3r\u0015\t9G\u0003\u0005\u0002m_:\u00111#\\\u0005\u0003]R\ta\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000e\u0006\u0005\tg\u0016\u0012\t\u0011)A\u00059\u0006Q1\r\\1tgB\u000bG\u000f\u001b\u0011\t\u000b})C\u0011B;\u0015\u000f\u00112x\u000f_={w\")\u0011\b\u001ea\u0001w!)\u0001\n\u001ea\u0001\u0013\")a\n\u001ea\u0001\u001f\")1\u000b\u001ea\u0001)\")\u0001\f\u001ea\u0001)\")!\f\u001ea\u00019\")Q0\nC!}\u0006AAo\\*ue&tw\rF\u0001l\u0011\u001d\t\t!\nC!\u0003\u0007\tqB\u0019:fC.\u0004x.\u001b8u\u0003\u0012$W\r\u001a\u000b\u0005\u0003\u000b\tY\u0001E\u0002\u0014\u0003\u000fI1!!\u0003\u0015\u0005\u0011)f.\u001b;\t\u000f\u00055q\u00101\u0001\u0002\u0010\u0005Q!M]3bWB|\u0017N\u001c;\u0011\u0007=\n\t\"C\u0002\u0002\u0014A\u00121\"\u0013\"sK\u0006\\\u0007o\\5oi\"9\u0011qC\u0013\u0005B\u0005e\u0011!\u00052sK\u0006\\\u0007o\\5oi\u000eC\u0017M\\4fIR1\u0011QAA\u000e\u0003;A\u0001\"!\u0004\u0002\u0016\u0001\u0007\u0011q\u0002\u0005\t\u0003?\t)\u00021\u0001\u0002\"\u0005)A-\u001a7uCB!\u00111EA\u0016\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!\u0003:fg>,(oY3t\u0015\t\u0011D'\u0003\u0003\u0002.\u0005\u0015\"\u0001D%NCJ\\WM\u001d#fYR\f\u0007bBA\u0019K\u0011\u0005\u00131G\u0001\u0012EJ,\u0017m\u001b9pS:$(+Z7pm\u0016$GCBA\u0003\u0003k\t9\u0004\u0003\u0005\u0002\u000e\u0005=\u0002\u0019AA\b\u0011!\ty\"a\fA\u0002\u0005\u0005\u0002bBA\u001eK\u0011\u0005\u0013QH\u0001\nO\u0016$H*Y;oG\"$\u0012!\u0013\u0005\u0007\u0003\u0003*C\u0011\t@\u0002\u000f\u001d,GOT1nK\"9\u0011QI\u0013\u0005B\u0005\u001d\u0013AC4fiB\u0013xnY3tgR\tq\nC\u0004\u0002L\u0015\"\t%!\u0014\u0002\u0015\u001d,G\u000f\u00165sK\u0006$7\u000f\u0006\u0002\u0002PA)1#!\u0015\u0002V%\u0019\u00111\u000b\u000b\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\n9&C\u0002\u0002ZA\u0012q!\u0013+ie\u0016\fG\rC\u0004\u0002^\u0015\"\t%a\u0018\u0002\u0015!\f7\u000f\u00165sK\u0006$7\u000fF\u0001U\u0011\u001d\t\u0019'\nC!\u0003K\n!c];qa>\u0014Ho\u001d\"sK\u0006\\\u0007o\\5oiR\u0019A+a\u001a\t\u0011\u00055\u0011\u0011\ra\u0001\u0003\u001fAq!a\u001b&\t\u0003\ny&A\u0007dC:$\u0015n]2p]:,7\r\u001e\u0005\b\u0003_*C\u0011IA9\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0003\u0003\u000bAq!!\u001e&\t\u0003\ny&\u0001\bjg\u0012K7oY8o]\u0016\u001cG/\u001a3\t\u000f\u0005eT\u0005\"\u0011\u0002|\u0005qq-\u001a;NK6|'/\u001f\"m_\u000e\\GCBA?\u0003\u0007\u000bi\tE\u00020\u0003\u007fJ1!!!1\u00051IU*Z7pef\u0014En\\2l\u0011!\t))a\u001eA\u0002\u0005\u001d\u0015\u0001D:uCJ$\u0018\t\u001a3sKN\u001c\bcA\n\u0002\n&\u0019\u00111\u0012\u000b\u0003\t1{gn\u001a\u0005\t\u0003\u001f\u000b9\b1\u0001\u0002\b\u00061A.\u001a8hi\"Dq!a%&\t\u0003\ny&\u0001\rtkB\u0004xN\u001d;t'R|'/Y4f%\u0016$(/[3wC2Dq!a&&\t\u0003\ny&A\u0005dC:\u0014Vm];nK\"9\u00111T\u0013\u0005B\u0005}\u0013AC2b]N+8\u000f]3oI\"9\u0011qT\u0013\u0005B\u0005}\u0013aC5t'V\u001c\b/\u001a8eK\u0012Dq!a)&\t\u0003\n\t(\u0001\u0004sKN,X.\u001a\u0005\b\u0003O+C\u0011IA9\u0003\u001d\u0019Xo\u001d9f]\u0012Dq!a+&\t\u0003\ny&\u0001\u0007dC:$VM]7j]\u0006$X\rC\u0004\u00020\u0016\"\t%a\u0018\u0002\u0019%\u001cH+\u001a:nS:\fG/\u001a3\t\u000f\u0005MV\u0005\"\u0011\u0002r\u0005IA/\u001a:nS:\fG/\u001a\u0005\b\u0003o+C\u0011IA]\u000399W\r\u001e#fEV<G+\u0019:hKR$\u0012\u0001\n\u0005\b\u0003{+C\u0011KA`\u0003-IgN\\3s\u0011\u0006tG\r\\3\u0016\u0005\u0005\u0005\u0007cB\n\u0002D\u0006\u001d\u00171[\u0005\u0004\u0003\u000b$\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T1!!4>\u0003\u0015)g/\u001a8u\u0013\u0011\t\t.a3\u0003\u000b\u00153XM\u001c;\u0011\t\u0005U\u0017Q\u001d\b\u0005\u0003/\fI.D\u0001&\u0011)\tY.\nb\u0001\u000e\u00031\u0011Q\\\u0001\fgV\u0014wN\u001d3j]\u0006$X-\u0006\u0002\u0002`B\u0019a\"!9\n\u0007\u0005\r(AA\u000eTG\u0006d\u0017\rR3ck\u001e$\u0016M]4fiN+(m\u001c:eS:\fG/Z\u0005\u0004\u0003Od#!D*uCf\u001cVo\u001d9f]\u0012,G\rC\u0005\u0002l\u0016\u0012\r\u0011\"\u0003\u0002n\u00069!/\u001e8oS:<WCAAx!\u0011\t\tPa\u0001\u000e\u0005\u0005M(\u0002BA{\u0003o\fa!\u0019;p[&\u001c'\u0002BA}\u0003w\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti0a@\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u0003\tAA[1wC&!!QAAz\u00055\tEo\\7jG\n{w\u000e\\3b]\"A!\u0011B\u0013!\u0002\u0013\ty/\u0001\u0005sk:t\u0017N\\4!\u0011%\u0011i!\nb\u0001\n\u0013\u0011y!A\u0004uQJ,\u0017\rZ:\u0016\u0005\tE\u0001CBAy\u0005'\u00119\"\u0003\u0003\u0003\u0016\u0005M(aD!u_6L7MU3gKJ,gnY3\u0011\u000b\u0001\u0014IB!\b\n\u0007\tm!N\u0001\u0003MSN$\bc\u0001\b\u0003 %\u0019!\u0011\u0005\u0002\u0003\u0017M\u001b\u0017\r\\1UQJ,\u0017\r\u001a\u0005\t\u0005K)\u0003\u0015!\u0003\u0003\u0012\u0005AA\u000f\u001b:fC\u0012\u001c\b\u0005\u0003\u0006\u0003*\u0015\u0012\r\u0011\"\u0001\u0005\u0003[\f!$[:QKJ4wN]7j]\u001eDu\u000e^\"pI\u0016\u0014V\r\u001d7bG\u0016D\u0001B!\f&A\u0003%\u0011q^\u0001\u001cSN\u0004VM\u001d4pe6Lgn\u001a%pi\u000e{G-\u001a*fa2\f7-\u001a\u0011\t\u0015\tERE1A\u0007\u0002\u0019\u0011\u0019$A\bfm\u0016tG\u000fR5ta\u0006$8\r[3s+\t\u0011)\u0004E\u0002\u000f\u0005oI1A!\u000f\u0003\u0005]\u00196-\u00197b\u0015\u0012LWI^3oi\u0012K7\u000f]1uG\",'\u000f\u0003\u0006\u0003>\u0015\u0012\rQ\"\u0001\u0007\u0005\u007f\t\u0011C\u0019:fC.\u0004x.\u001b8u\u001b\u0006t\u0017mZ3s+\t\u0011\t\u0005\u0005\u0003\u0003D\t%SB\u0001B#\u0015\r\u00119\u0005B\u0001\fEJ,\u0017m\u001b9pS:$8/\u0003\u0003\u0003L\t\u0015#aG*dC2\fG)\u001a2vO\n\u0013X-Y6q_&tG/T1oC\u001e,'\u000f\u0003\u0006\u0003P\u0015\u0012\rQ\"\u0001\u0007\u0005#\n!\u0002[2s\u001b\u0006t\u0017mZ3s+\t\u0011\u0019\u0006\u0005\u0003\u0014;\nU\u0003\u0003\u0002B,\u0005;j!A!\u0017\u000b\u0007\tmC!A\u0002iGJLAAa\u0018\u0003Z\tQ2kY1mC\"{GoQ8eKJ+\u0007\u000f\\1dK6\u000bg.Y4fe\"Q!1M\u0013C\u0002\u001b\u0005aA!\u001a\u0002\u000b\r\f7\r[3\u0016\u0005\t\u001d\u0004c\u0001\b\u0003j%\u0019!1\u000e\u0002\u0003\u001fM\u001b\u0017\r\\1EK\n,xmQ1dQ\u0016D!Ba\u001c&\u0005\u00045\tA\u0002B9\u00035\u0011X\r^1j]\u0016$7\u000b^1dWV\u0011!1\u000f\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)\u0019!\u0011\u0010\u0003\u0002\u000b\u0005\u001c\u0018P\\2\n\t\tu$q\u000f\u0002\u0015%\u0016$\u0018-\u001b8fIN#\u0018mY6NC:\fw-\u001a:\t\u0015\t\u0005UE1A\u0005\u0002\u0019\u0011\u0019)\u0001\nce\u0016\f7n\u00148EK\u0006$G*\u001a;uKJ\u001cXC\u0001BC!\u0011\u0011)Ha\"\n\t\t%%q\u000f\u0002\u0013\u0005J,\u0017m[(o\t\u0016\fG\rT3ui\u0016\u00148\u000f\u0003\u0005\u0003\u000e\u0016\u0002\u000b\u0011\u0002BC\u0003M\u0011'/Z1l\u001f:$U-\u00193MKR$XM]:!\u0011\u001d\u0011\t*\nC\u0005\u0003c\nqc\u001d;beRTE-[#wK:$H)[:qCR\u001c\u0007.\u001a:\t\u0011\tUU\u0005\"\u0001\u0007\u0005/\u000bq\u0002\u001e5sK\u0006$7+^:qK:$W\r\u001a\u000b\u0007\u0003\u000b\u0011IJa)\t\u0011\tm%1\u0013a\u0001\u0005;\u000ba\u0001\u001e5sK\u0006$\u0007c\u0001\u001f\u0003 &\u0019!\u0011U\u001f\u0003\u001fQC'/Z1e%\u00164WM]3oG\u0016D\u0001B!*\u0003\u0014\u0002\u0007!qU\u0001\fKZ,g\u000e\u001e#fi\u0006LG\u000eE\u0002\u0014\u0005SK1Aa+\u0015\u0005\rIe\u000e\u001e\u0005\n\u0005_+\u0003\u0019!C\u0005\u0005c\u000bAb]2bY\u00064VM]:j_:,\"Aa-\u0011\tMi&Q\u0017\t\u0005\u0005o\u0013\t-\u0004\u0002\u0003:*!!1\u0018B_\u0003%1'/Y7fo>\u00148NC\u0002\u0003@*\tAa\\:hS&!!1\u0019B]\u0005\u001d1VM]:j_:D\u0011Ba2&\u0001\u0004%IA!3\u0002!M\u001c\u0017\r\\1WKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003BA\u0003\u0005\u0017D!B!4\u0003F\u0006\u0005\t\u0019\u0001BZ\u0003\rAH%\r\u0005\t\u0005#,\u0003\u0015)\u0003\u00034\u0006i1oY1mCZ+'o]5p]\u0002BCAa4\u0003VB\u00191Ca6\n\u0007\teGC\u0001\u0005w_2\fG/\u001b7f\u0011\u001d\u0011i.\nC\u0005\u0005?\fqbZ3u'\u000e\fG.\u0019,feNLwN\u001c\u000b\u0005\u0005g\u0013\t\u000f\u0003\u0005\u0003\u001c\nm\u0007\u0019\u0001B\u000f\u0011\u001d\u0011)/\nC\u0005\u0005O\f\u0011CZ3uG\"\u001c6-\u00197b-\u0016\u00148/[8o)\u0011\u0011\u0019L!;\t\u0011\tm%1\u001da\u0001\u0005;AqA!<&\t\u0003\u0011y/A\bjgJz\u0016hQ8na\u0006$\u0018N\u00197f)\r!&\u0011\u001f\u0005\t\u00057\u0013Y\u000f1\u0001\u0003\u001e!9!Q_\u0013\u0005\u0002\t]\u0018\u0001E5te}\u000b\u0004gQ8na\u0006$\u0018N\u00197f)\r!&\u0011 \u0005\t\u00057\u0013\u0019\u00101\u0001\u0003\u001e!9!Q`\u0013\u0005\u0002\t}\u0018\u0001D8cU\u0016\u001cGOQ=OC6,G\u0003CB\u0001\u0007\u000f\u0019Yaa\u0004\u0011\u00079\u0019\u0019!C\u0002\u0004\u0006\t\u0011AcU2bY\u0006|%M[3diJ+g-\u001a:f]\u000e,\u0007bBB\u0005\u0005w\u0004\ra[\u0001\u000b_\nTWm\u0019;OC6,\u0007bBB\u0007\u0005w\u0004\r\u0001V\u0001\riJLhi\u001c:dK2{\u0017\r\u001a\u0005\t\u00057\u0013Y\u00101\u0001\u0003\u001e!911C\u0013\u0005\n\rU\u0011aC2mCN\u001c()\u001f(b[\u0016$\u0002ba\u0006\u0004\u001e\r\u000521\u0005\t\u0004\u001d\re\u0011bAB\u000e\u0005\t\u00112kY1mCJ+g-\u001a:f]\u000e,G+\u001f9f\u0011\u001d\u0019yb!\u0005A\u0002-\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u0007\u001b\u0019\t\u00021\u0001U\u0011!\u0011Yj!\u0005A\u0002\tu\u0001bBB\u0014K\u0011%1\u0011F\u0001\nM>\u00148-\u001a'pC\u0012$baa\u0006\u0004,\r5\u0002bBB\u0010\u0007K\u0001\ra\u001b\u0005\t\u00057\u001b)\u00031\u0001\u0003\u001e!91\u0011G\u0013\u0005\n\rM\u0012AD4fi\u000ec\u0017m]:M_\u0006$WM\u001d\u000b\u0007\u0007\u0003\u0019)d!\u000f\t\u0011\r]2q\u0006a\u0001\u0007\u0003\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\t\u00057\u001by\u00031\u0001\u0003\u001e!91QH\u0013\u0005\u0002\u0005E\u0014\u0001C1ui\u0006\u001c\u0007.\u001a3\t\u0011\r\u0005S\u0005\"\u0001\u0003\u0003c\n\u0011B^7Ti\u0006\u0014H/\u001a3\t\u0011\r\u0015S\u0005\"\u0001\u0003\u0003c\naB^7ESN\u001cwN\u001c8fGR,G\rC\u0004\u0004J\u0015\"I!!\u001d\u0002'\rdW-\u0019:Bgft7\rR3ck\u001e4\u0016.Z<\t\u000f\r5S\u0005\"\u0003\u0002r\u0005qA-[:q_N,G\u000b\u001b:fC\u0012\u001c\b\u0002CB)K\u0011\u0005!aa\u0015\u0002\u0013\u0005$G\r\u00165sK\u0006$G\u0003\u0002B\u000f\u0007+B\u0001Ba'\u0004P\u0001\u0007!Q\u0014\u0005\t\u00073*C\u0011\u0001\u0002\u0004\\\u0005a!/Z7pm\u0016$\u0006N]3bIR!\u0011QAB/\u0011!\u0011Yja\u0016A\u0002\tu\u0005\u0002CB1K\u0011\u0005!aa\u0019\u0002#%t\u0017\u000e^5bY&TX\r\u00165sK\u0006$7\u000f\u0006\u0003\u0002\u0006\r\u0015\u0004\u0002CB4\u0007?\u0002\ra!\u001b\u0002\u0003Q\u0004R\u0001\u0019B\r\u0005;C\u0001b!\u001c&\t\u0003!1qN\u0001\u001akB$\u0017\r^3Ti\u0006\u001c7N\u0012:b[\u0016\u001c\u0018I\u001a;fe\"\u001b'\u000f\u0006\u0003\u0004r\rm\u0004CBB:\u0007o\n)!\u0004\u0002\u0004v)\u0019\u0011\u0011 \u000b\n\t\re4Q\u000f\u0002\u0007\rV$XO]3\t\u000f\ru41\u000ea\u0001)\u0006\u0011BM]8q\u0003\u001a4Wm\u0019;fI\u001a\u0013\u0018-\\3t\u0011!\u0019\t)\nC\u0001\u0005\r\r\u0015aD4fiN\u001b\u0017\r\\1UQJ,\u0017\rZ:\u0016\u0005\t]\u0001bBBDK\u0011\u00051\u0011R\u0001\u000fO\u0016$8kY1mCRC'/Z1e)\u0011\u0019Yi!$\u0011\tMi&Q\u0004\u0005\t\u0007\u001f\u001b)\t1\u0001\u0003\u001e\u0006IA\u000f\u001b:fC\u0012\u0014VM\u001a\u0005\t\u0007'+C\u0011\u0001\u0002\u0004\u0016\u0006a1-\u00198Q_B4%/Y7fgV\tA\u000bC\u0003:C\u0001\u00071\bC\u0003IC\u0001\u0007\u0011\nC\u0003OC\u0001\u0007q\nC\u0003TC\u0001\u0007A\u000bC\u0003YC\u0001\u0007A\u000bC\u0004[CA\u0005\t\u0019\u0001/\t\u0013\r\u0015vB1A\u0005\u0002\r\u001d\u0016\u0001\u0006<feNLwN\\*ue&tw\rU1ui\u0016\u0014h.\u0006\u0002\u0004*B!11VBZ\u001b\t\u0019iK\u0003\u0003\u00040\u000eE\u0016\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005uH#\u0003\u0003\u00046\u000e5&!\u0002*fO\u0016D\b\u0002CB]\u001f\u0001\u0006Ia!+\u0002+Y,'o]5p]N#(/\u001b8h!\u0006$H/\u001a:oA!I1QX\b\u0012\u0002\u0013\u00051qX\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u00111\u0011\u0019\u0016\u00049\u000e\r7FABc!\u0011\u00199m!5\u000e\u0005\r%'\u0002BBf\u0007\u001b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r=G#\u0001\u0006b]:|G/\u0019;j_:LAaa5\u0004J\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class ScalaDebugTarget
extends ScalaDebugElement
implements JdiEventReceiver,
IDebugTarget {
    private final VirtualMachine virtualMachine;
    private final ILaunch launch;
    private final IProcess process;
    private final boolean allowDisconnect;
    private final boolean allowTerminate;
    private final Option<Seq<String>> classPath;
    private final AtomicBoolean running;
    private final AtomicReference<List<ScalaThread>> threads;
    private final AtomicBoolean isPerformingHotCodeReplace;
    private final BreakOnDeadLetters breakOnDeadLetters;
    private volatile Option<Version> scalaVersion;

    public static Option<Seq<String>> apply$default$6() {
        return ScalaDebugTarget$.MODULE$.apply$default$6();
    }

    public static Regex versionStringPattern() {
        return ScalaDebugTarget$.MODULE$.versionStringPattern();
    }

    public static ScalaDebugTarget apply(VirtualMachine virtualMachine, ILaunch iLaunch, IProcess iProcess, boolean bl, boolean bl2, Option<Seq<String>> option) {
        return ScalaDebugTarget$.MODULE$.apply(virtualMachine, iLaunch, iProcess, bl, bl2, option);
    }

    @Override
    public final Future<Object> handle(Event event, ExecutionContext ec) {
        return JdiEventReceiver$class.handle(this, event, ec);
    }

    public VirtualMachine virtualMachine() {
        return this.virtualMachine;
    }

    public Option<Seq<String>> classPath() {
        return this.classPath;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ScalaDebugTarget(vm = ", ", launch = ", ", process = ", ", allowDisconnect = ", ", allowTerminate = ", ", classpath = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.virtualMachine(), this.launch, this.process, BoxesRunTime.boxToBoolean((boolean)this.allowDisconnect), BoxesRunTime.boxToBoolean((boolean)this.allowTerminate), Option$.MODULE$.option2Iterable(this.classPath().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$1) {
                return x$1.mkString(":");
            }
        })).mkString()}));
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getName() {
        return "Scala Debug Target";
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() {
        return (IThread[])((TraversableOnce)this.threads().get()).toArray(ClassTag$.MODULE$.apply(IThread.class));
    }

    public boolean hasThreads() {
        return !((SeqLike)this.threads().get()).isEmpty();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean canDisconnect() {
        return this.allowDisconnect && this.running().get();
    }

    public void disconnect() {
        this.virtualMachine().dispose();
        this.vmDisconnected();
    }

    public boolean isDisconnected() {
        return !this.running().get();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean supportsStorageRetrieval() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void suspend() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public boolean canTerminate() {
        return this.allowTerminate && this.running().get();
    }

    @Override
    public boolean isTerminated() {
        return !this.running().get();
    }

    @Override
    public void terminate() {
        this.virtualMachine().exit(1);
        this.vmDisconnected();
    }

    @Override
    public ScalaDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public PartialFunction<Event, Object> innerHandle() {
        return this.subordinate().innerHandle();
    }

    private AtomicBoolean running() {
        return this.running;
    }

    private AtomicReference<List<ScalaThread>> threads() {
        return this.threads;
    }

    public AtomicBoolean isPerformingHotCodeReplace() {
        return this.isPerformingHotCodeReplace;
    }

    public abstract ScalaJdiEventDispatcher eventDispatcher();

    public abstract ScalaDebugBreakpointManager breakpointManager();

    public abstract Option<ScalaHotCodeReplaceManager> hcrManager();

    public abstract ScalaDebugTargetSubordinate subordinate();

    public abstract ScalaDebugCache cache();

    public abstract RetainedStackManager retainedStack();

    public BreakOnDeadLetters breakOnDeadLetters() {
        return this.breakOnDeadLetters;
    }

    public void org$scalaide$debug$internal$model$ScalaDebugTarget$$startJdiEventDispatcher() {
        this.eventDispatcher().run();
    }

    public void threadSuspended(ThreadReference thread, int eventDetail) {
        this.subordinate().threadSuspended(thread, eventDetail);
    }

    private Option<Version> scalaVersion() {
        return this.scalaVersion;
    }

    private void scalaVersion_$eq(Option<Version> x$1) {
        this.scalaVersion = x$1;
    }

    private Option<Version> getScalaVersion(ScalaThread thread) {
        if (this.scalaVersion().isEmpty()) {
            this.scalaVersion_$eq(this.fetchScalaVersion(thread));
        }
        return this.scalaVersion();
    }

    private Option<Version> fetchScalaVersion(ScalaThread thread) {
        Throwable throwable2;
        block10: {
            None$ none$;
            try {
                Some some;
                ScalaObjectReference propertiesObject = this.objectByName("scala.util.Properties", true, thread);
                ScalaValue scalaValue = propertiesObject.fieldValue("versionString");
                if (scalaValue instanceof ScalaStringReference) {
                    Some some2;
                    ScalaStringReference scalaStringReference = (ScalaStringReference)scalaValue;
                    String string = scalaStringReference.underlying().value();
                    Option option = ScalaDebugTarget$.MODULE$.versionStringPattern().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String version = (String)((LinearSeqOptimized)option.get()).apply(0);
                        some2 = new Some((Object)new Version(version));
                    } else {
                        this.logger().warn((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Unable to parse Properties.versionString";
                            }
                        });
                        some2 = new Some((Object)new Version(0, 0, 0));
                    }
                    some = some2;
                } else {
                    this.logger().warn((Function0)new Serializable(this, scalaValue){
                        public static final long serialVersionUID = 0L;
                        private final ScalaValue x1$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Properties.versionString returned an unexpected value: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$2}));
                        }
                        {
                            this.x1$2 = x1$2;
                        }
                    });
                    some = new Some((Object)new Version(0, 0, 0));
                }
                none$ = some;
            }
            catch (Throwable throwable2) {
                None$ none$2;
                ClassNotLoadedException classNotLoadedException;
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ClassNotLoadedException && (classNotLoadedException = (ClassNotLoadedException)throwable3).getMessage().contains("scala.Predef")) {
                    this.logger().warn((Function0)new Serializable(this, classNotLoadedException){
                        public static final long serialVersionUID = 0L;
                        private final ClassNotLoadedException x11$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Too early to get Scala version number from the VM: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x11$1}));
                        }
                        {
                            this.x11$1 = x11$1;
                        }
                    });
                    none$2 = None$.MODULE$;
                } else if (throwable3 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable3;
                    this.logger().warn((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to parse Scala version number from the VM";
                        }
                    }, (Throwable)illegalArgumentException);
                    none$2 = new Some((Object)new Version(0, 0, 0));
                } else {
                    if (!(throwable3 instanceof Exception)) break block10;
                    Exception exception = (Exception)throwable3;
                    this.logger().warn((Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception x13$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Failed to get Scala version number from the VM: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x13$1}));
                        }
                        {
                            this.x13$1 = x13$1;
                        }
                    });
                    none$2 = new Some((Object)new Version(0, 0, 0));
                }
                none$ = none$2;
            }
            return none$;
        }
        throw throwable2;
    }

    public boolean is2_9Compatible(ScalaThread thread) {
        return this.getScalaVersion(thread).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Version v) {
                return v.getMajor() == 2 && v.getMinor() >= 9;
            }
        });
    }

    public boolean is2_10Compatible(ScalaThread thread) {
        return this.getScalaVersion(thread).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Version v) {
                return v.getMajor() == 2 && v.getMinor() >= 10;
            }
        });
    }

    public ScalaObjectReference objectByName(String objectName, boolean tryForceLoad, ScalaThread thread) {
        String moduleClassName = new StringBuilder().append((Object)objectName).append((Object)BoxesRunTime.boxToCharacter((char)'$')).toString();
        return (ScalaObjectReference)this.wrapJDIException(new StringBuilder().append((Object)"Exception while retrieving module debug element `").append((Object)moduleClassName).append((Object)"`").toString()).apply((Function0)new Serializable(this, tryForceLoad, thread, moduleClassName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDebugTarget $outer;
            private final boolean tryForceLoad$1;
            private final ScalaThread thread$2;
            private final String moduleClassName$1;

            public final ScalaObjectReference apply() {
                return (ScalaObjectReference)this.$outer.org$scalaide$debug$internal$model$ScalaDebugTarget$$classByName(this.moduleClassName$1, this.tryForceLoad$1, this.thread$2).fieldValue("MODULE$");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tryForceLoad$1 = tryForceLoad$1;
                this.thread$2 = thread$2;
                this.moduleClassName$1 = moduleClassName$1;
            }
        });
    }

    public ScalaReferenceType org$scalaide$debug$internal$model$ScalaDebugTarget$$classByName(String typeName, boolean tryForceLoad, ScalaThread thread) {
        List list;
        block4: {
            block5: {
                ScalaReferenceType scalaReferenceType;
                block3: {
                    block2: {
                        list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.virtualMachine().classesByName(typeName)).asScala()).toList();
                        if (!(list instanceof .colon.colon)) break block2;
                        .colon.colon colon2 = (.colon.colon)list;
                        ReferenceType t = (ReferenceType)colon2.head();
                        scalaReferenceType = ScalaType$.MODULE$.apply(t, this);
                        break block3;
                    }
                    if (!Nil$.MODULE$.equals(list)) break block4;
                    if (!tryForceLoad) break block5;
                    scalaReferenceType = this.forceLoad(typeName, thread);
                }
                return scalaReferenceType;
            }
            throw new ClassNotLoadedException(typeName, new StringBuilder().append((Object)"No force load requested for ").append((Object)typeName).toString());
        }
        throw new MatchError((Object)list);
    }

    private ScalaReferenceType forceLoad(String typeName, ScalaThread thread) {
        ScalaObjectReference predef = this.objectByName("scala.Predef", false, null);
        ScalaObjectReference classLoader = this.getClassLoader(predef, thread);
        classLoader.invokeMethod("loadClass", thread, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[]{ScalaValue$.MODULE$.apply(typeName, this)}));
        java.util.List<ReferenceType> entities = this.virtualMachine().classesByName(typeName);
        if (entities.isEmpty()) {
            throw new ClassNotLoadedException(typeName, "Unable to force load");
        }
        return ScalaType$.MODULE$.apply(entities.get(0), this);
    }

    private ScalaObjectReference getClassLoader(ScalaObjectReference instance, ScalaThread thread) {
        ScalaObjectReference scalaObjectReference;
        ClassLoaderReference typeClassLoader = instance.underlying().referenceType().classLoader();
        if (typeClassLoader == null) {
            ScalaClassType classLoaderClass = (ScalaClassType)this.org$scalaide$debug$internal$model$ScalaDebugTarget$$classByName("java.lang.ClassLoader", false, null);
            scalaObjectReference = (ScalaObjectReference)classLoaderClass.invokeMethod("getSystemClassLoader", thread, (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]));
        } else {
            scalaObjectReference = new ScalaObjectReference(typeClassLoader, this);
        }
        return scalaObjectReference;
    }

    public void attached() {
        this.subordinate().attachedToVm();
    }

    public void vmStarted() {
        this.initializeThreads((List<ThreadReference>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.virtualMachine().allThreads()).asScala()).toList());
        this.retainedStack().start();
        this.breakpointManager().init();
        this.breakOnDeadLetters().start();
        this.hcrManager().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ScalaHotCodeReplaceManager x$2) {
                x$2.init();
            }
        });
        this.fireChangeEvent(512);
    }

    public void vmDisconnected() {
        if (this.running().getAndSet(false)) {
            this.eventDispatcher().dispose();
            this.breakpointManager().dispose();
            this.subordinate().removeSubscriptions();
            this.hcrManager().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ScalaHotCodeReplaceManager x$3) {
                    x$3.dispose();
                }
            });
            this.cache().dispose();
            this.retainedStack().dispose();
            this.breakOnDeadLetters().dispose();
            this.clearAsyncDebugView();
            this.disposeThreads();
            this.fireTerminateEvent();
        }
    }

    private void clearAsyncDebugView() {
        DisplayThread$.MODULE$.asyncExec((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option$.MODULE$.apply((Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(IWorkbenchWindow w) {
                        Option$.MODULE$.apply((Object)w.getActivePage()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(IWorkbenchPage p) {
                                Option$.MODULE$.apply((Object)p.findView("org.scala-ide.sdt.debug.asyncView")).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(IViewPart view) {
                                        ((AsyncDebugView)view).clearDebugView();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void disposeThreads() {
        List<ScalaThread> previousThreads = this.threads().getAndSet((List<ScalaThread>)Nil$.MODULE$);
        previousThreads.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ScalaThread x$4) {
                x$4.dispose();
            }
        });
    }

    public ScalaThread addThread(ThreadReference thread) {
        List prev = Nil$.MODULE$;
        List next = Nil$.MODULE$;
        ScalaThread threadToAdd = ScalaThread$.MODULE$.apply(this, thread);
        do {
            List list = next = (prev = this.threads().get()).exists((Function1)new Serializable(this, thread){
                public static final long serialVersionUID = 0L;
                private final ThreadReference thread$3;

                public final boolean apply(ScalaThread x$5) {
                    return x$5.threadRef() == this.thread$3;
                }
                {
                    this.thread$3 = thread$3;
                }
            }) ? prev : (List)prev.$colon$plus((Object)threadToAdd, List$.MODULE$.canBuildFrom());
        } while (!this.threads().compareAndSet((List<ScalaThread>)prev, (List<ScalaThread>)next));
        return threadToAdd;
    }

    public void removeThread(ThreadReference thread) {
        List<ScalaThread> prev = Nil$.MODULE$;
        Tuple2 next = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        do {
            prev = this.threads().get();
            next = prev.partition((Function1)new Serializable(this, thread){
                public static final long serialVersionUID = 0L;
                private final ThreadReference thread$4;

                public final boolean apply(ScalaThread x$6) {
                    return x$6.threadRef() == this.thread$4;
                }
                {
                    this.thread$4 = thread$4;
                }
            });
        } while (!this.threads().compareAndSet(prev, (List<ScalaThread>)next._2()));
        ((List)next._1()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ScalaThread x$7) {
                x$7.terminatedFromScala();
            }
        });
    }

    public void initializeThreads(List<ThreadReference> t) {
        this.threads().getAndSet((List<ScalaThread>)t.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDebugTarget $outer;

            public final ScalaThread apply(ThreadReference x$8) {
                return ScalaThread$.MODULE$.apply(this.$outer, x$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    public Future<BoxedUnit> updateStackFramesAfterHcr(boolean dropAffectedFrames) {
        return this.subordinate().updateStackFrameAfterHcr(dropAffectedFrames);
    }

    public List<ScalaThread> getScalaThreads() {
        return this.threads().get();
    }

    public Option<ScalaThread> getScalaThread(ThreadReference threadRef) {
        return ((LinearSeqOptimized)this.threads().get()).find((Function1)new Serializable(this, threadRef){
            public static final long serialVersionUID = 0L;
            private final ThreadReference threadRef$1;

            public final boolean apply(ScalaThread x$9) {
                ThreadReference threadReference = x$9.threadRef();
                ThreadReference threadReference2 = this.threadRef$1;
                return !(threadReference != null ? !threadReference.equals(threadReference2) : threadReference2 != null);
            }
            {
                this.threadRef$1 = threadRef$1;
            }
        });
    }

    public boolean canPopFrames() {
        return this.running().get() && this.virtualMachine().canPopFrames();
    }

    public ScalaDebugTarget(VirtualMachine virtualMachine, ILaunch launch, IProcess process, boolean allowDisconnect, boolean allowTerminate, Option<Seq<String>> classPath) {
        this.virtualMachine = virtualMachine;
        this.launch = launch;
        this.process = process;
        this.allowDisconnect = allowDisconnect;
        this.allowTerminate = allowTerminate;
        this.classPath = classPath;
        super(null);
        JdiEventReceiver$class.$init$(this);
        this.running = new AtomicBoolean(true);
        this.threads = new AtomicReference<Nil$>(Nil$.MODULE$);
        this.isPerformingHotCodeReplace = new AtomicBoolean();
        this.breakOnDeadLetters = new BreakOnDeadLetters(this);
        this.scalaVersion = None$.MODULE$;
    }
}

