/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.model;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.scalaide.debug.internal.ScalaSourceLookupParticipant$;
import org.scalaide.debug.internal.async.RetainedStackManager;
import org.scalaide.debug.internal.breakpoints.ScalaDebugBreakpointManager;
import org.scalaide.debug.internal.breakpoints.ScalaDebugBreakpointManager$;
import org.scalaide.debug.internal.hcr.ScalaHotCodeReplaceManager;
import org.scalaide.debug.internal.hcr.ScalaHotCodeReplaceManager$;
import org.scalaide.debug.internal.model.JdiRequestFactory$;
import org.scalaide.debug.internal.model.ScalaDebugCache;
import org.scalaide.debug.internal.model.ScalaDebugCache$;
import org.scalaide.debug.internal.model.ScalaDebugTarget;
import org.scalaide.debug.internal.model.ScalaDebugTargetSubordinate;
import org.scalaide.debug.internal.model.ScalaDebugTargetSubordinate$;
import org.scalaide.debug.internal.model.ScalaJdiEventDispatcher;
import org.scalaide.debug.internal.model.ScalaJdiEventDispatcher$;
import org.scalaide.logging.HasLogger;
import org.scalaide.logging.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class ScalaDebugTarget$
implements HasLogger {
    public static final ScalaDebugTarget$ MODULE$;
    private final Regex versionStringPattern;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ScalaDebugTarget$();
    }

    private Logger logger$lzycompute() {
        ScalaDebugTarget$ scalaDebugTarget$ = this;
        synchronized (scalaDebugTarget$) {
            if (!this.bitmap$0) {
                this.logger = HasLogger.class.logger((HasLogger)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger eclipseLog() {
        return HasLogger.class.eclipseLog((HasLogger)this);
    }

    public ScalaDebugTarget apply(VirtualMachine virtualMachine, ILaunch launch, IProcess process, boolean allowDisconnect, boolean allowTerminate, Option<Seq<String>> classPath) {
        ThreadStartRequest threadStartRequest = JdiRequestFactory$.MODULE$.createThreadStartRequest(virtualMachine);
        ThreadDeathRequest threadDeathRequest = JdiRequestFactory$.MODULE$.createThreadDeathRequest(virtualMachine);
        ScalaDebugTarget debugTarget = new ScalaDebugTarget(virtualMachine, launch, process, allowDisconnect, allowTerminate, classPath, threadStartRequest, threadDeathRequest){
            private final ScalaDebugTargetSubordinate subordinate;
            private final ScalaDebugBreakpointManager breakpointManager;
            private final Option<ScalaHotCodeReplaceManager> hcrManager;
            private final ScalaJdiEventDispatcher eventDispatcher;
            private final ScalaDebugCache cache;
            private final RetainedStackManager retainedStack;

            public ScalaDebugTargetSubordinate subordinate() {
                return this.subordinate;
            }

            public ScalaDebugBreakpointManager breakpointManager() {
                return this.breakpointManager;
            }

            public Option<ScalaHotCodeReplaceManager> hcrManager() {
                return this.hcrManager;
            }

            public ScalaJdiEventDispatcher eventDispatcher() {
                return this.eventDispatcher;
            }

            public ScalaDebugCache cache() {
                return this.cache;
            }

            public RetainedStackManager retainedStack() {
                return this.retainedStack;
            }
            {
                this.subordinate = ScalaDebugTargetSubordinate$.MODULE$.apply(threadStartRequest$1, threadDeathRequest$1, this);
                this.breakpointManager = ScalaDebugBreakpointManager$.MODULE$.apply(this);
                this.hcrManager = ScalaHotCodeReplaceManager$.MODULE$.create(this.subordinate());
                this.eventDispatcher = ScalaJdiEventDispatcher$.MODULE$.apply(this.virtualMachine(), this);
                this.cache = ScalaDebugCache$.MODULE$.apply(this);
                this.retainedStack = new RetainedStackManager(this);
            }
        };
        launch.addDebugTarget((IDebugTarget)debugTarget);
        ISourceLocator iSourceLocator = launch.getSourceLocator();
        if (iSourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector iSourceLookupDirector = (ISourceLookupDirector)iSourceLocator;
            iSourceLookupDirector.addParticipants((ISourceLookupParticipant[])((Object[])new ISourceLookupParticipant[]{ScalaSourceLookupParticipant$.MODULE$}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn((Function0)new Serializable(iSourceLocator){
                public static final long serialVersionUID = 0L;
                private final ISourceLocator x1$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Unable to recognize source locator %s, cannot add Scala participant")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        debugTarget.org$scalaide$debug$internal$model$ScalaDebugTarget$$startJdiEventDispatcher();
        debugTarget.fireCreationEvent();
        return debugTarget;
    }

    public Option<Seq<String>> apply$default$6() {
        return None$.MODULE$;
    }

    public Regex versionStringPattern() {
        return this.versionStringPattern;
    }

    private ScalaDebugTarget$() {
        MODULE$ = this;
        HasLogger.class.$init$((HasLogger)this);
        this.versionStringPattern = new StringOps(Predef$.MODULE$.augmentString("version ([^-]*).*")).r();
    }
}

