/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.InstructionPointerAnnotation;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.scalaide.debug.internal.ScalaDebugPlugin$;
import org.scalaide.debug.internal.model.ScalaDebugModelPresentation$;
import org.scalaide.debug.internal.model.ScalaDebugTarget;
import org.scalaide.debug.internal.model.ScalaStackFrame;
import org.scalaide.debug.internal.model.ScalaThread;
import org.scalaide.debug.internal.model.VirtualVariable;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0001\u0003\u0011\u0003i\u0011aG*dC2\fG)\u001a2vO6{G-\u001a7Qe\u0016\u001cXM\u001c;bi&|gN\u0003\u0002\u0004\t\u0005)Qn\u001c3fY*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0006I\u0016\u0014Wo\u001a\u0006\u0003\u0013)\t\u0001b]2bY\u0006LG-\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tY2kY1mC\u0012+'-^4N_\u0012,G\u000e\u0015:fg\u0016tG/\u0019;j_:\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0003\u001d\u001f\u0011\u0005Q$A\u0007d_6\u0004X\u000f^3EKR\f\u0017\u000e\u001c\u000b\u0003=\u0015\u0002\"a\b\u0012\u000f\u0005M\u0001\u0013BA\u0011\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111\u0005\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\"\u0002\"\u0002\u0014\u001c\u0001\u00049\u0013!\u0002<bYV,\u0007C\u0001\u00150\u001b\u0005I#BA\u0002+\u0015\tYC&\u0001\u0003d_J,'BA\u0004.\u0015\tq#\"A\u0004fG2L\u0007o]3\n\u0005AJ#AB%WC2,X\rC\u00033\u001f\u0011\u00051'A\u0004uKb$hi\u001c:\u0015\u0005y!\u0004\"B\u001b2\u0001\u00041\u0014\u0001\u0003<be&\f'\r\\3\u0011\u0005!:\u0014B\u0001\u001d*\u0005%Ie+\u0019:jC\ndW\rC\u0003\u001d\u001f\u0011%!\b\u0006\u0002\u001fw!)A(\u000fa\u0001{\u0005q\u0011M\u001d:bsJ+g-\u001a:f]\u000e,\u0007C\u0001\b?\u0013\ty$AA\nTG\u0006d\u0017-\u0011:sCf\u0014VMZ3sK:\u001cW\rC\u0003\u001d\u001f\u0011%\u0011\t\u0006\u0002\u001f\u0005\")1\t\u0011a\u0001\t\u0006yqN\u00196fGR\u0014VMZ3sK:\u001cW\r\u0005\u0002\u000f\u000b&\u0011aI\u0001\u0002\u0015'\u000e\fG.Y(cU\u0016\u001cGOU3gKJ,gnY3\u0007\tA\u0011\u0001\u0001S\n\u0005\u000f&\u000bv\u000b\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\r=\u0013'.Z2u!\t\u0011V+D\u0001T\u0015\t!F&\u0001\u0002vS&\u0011ak\u0015\u0002\u0018\u0013\u0012+'-^4N_\u0012,G\u000e\u0015:fg\u0016tG/\u0019;j_:\u0004\"A\u0015-\n\u0005e\u001b&aH%J]N$(/^2uS>t\u0007k\\5oi\u0016\u0014\bK]3tK:$\u0018\r^5p]\")\u0011d\u0012C\u00017R\tA\f\u0005\u0002\u000f\u000f\")al\u0012C!?\u0006Y\u0011\r\u001a3MSN$XM\\3s)\t\u00017\r\u0005\u0002\u0014C&\u0011!\r\u0006\u0002\u0005+:LG\u000fC\u0003e;\u0002\u0007Q-\u0001\u0005mSN$XM\\3s!\t17.D\u0001h\u0015\tA\u0017.A\u0004wS\u0016<XM]:\u000b\u0005)l\u0013!\u00026gC\u000e,\u0017B\u00017h\u0005YIE*\u00192fYB\u0013xN^5eKJd\u0015n\u001d;f]\u0016\u0014\b\"\u00028H\t\u0003z\u0017a\u00023jgB|7/\u001a\u000b\u0002A\")\u0011o\u0012C!e\u0006y\u0011n\u001d'bE\u0016d\u0007K]8qKJ$\u0018\u0010F\u0002tmn\u0004\"a\u0005;\n\u0005U$\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006oB\u0004\r\u0001_\u0001\bK2,W.\u001a8u!\t\u0019\u00120\u0003\u0002{)\t\u0019\u0011I\\=\t\u000bq\u0004\b\u0019\u0001\u0010\u0002\u0011A\u0014x\u000e]3sifDQA`$\u0005B}\faB]3n_Z,G*[:uK:,'\u000fF\u0002a\u0003\u0003AQ\u0001Z?A\u0002\u0015Da\u0001H$\u0005B\u0005\u0015A#\u00021\u0002\b\u0005%\u0001B\u0002\u0014\u0002\u0004\u0001\u0007q\u0005C\u0004e\u0003\u0007\u0001\r!a\u0003\u0011\u0007I\u000bi!C\u0002\u0002\u0010M\u0013A#\u0013,bYV,G)\u001a;bS2d\u0015n\u001d;f]\u0016\u0014\bbBA\n\u000f\u0012\u0005\u0013QC\u0001\tO\u0016$\u0018*\\1hKR!\u0011qCA\u0014!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0001b\u001a:ba\"L7m\u001d\u0006\u0004\u0003Ci\u0013aA:xi&!\u0011QEA\u000e\u0005\u0015IU.Y4f\u0011\u00199\u0018\u0011\u0003a\u0001q\"9\u00111F$\u0005B\u00055\u0012aB4fiR+\u0007\u0010\u001e\u000b\u0004=\u0005=\u0002BB<\u0002*\u0001\u0007\u0001\u0010C\u0004\u00024\u001d#\t%!\u000e\u0002\u0019M,G/\u0011;ue&\u0014W\u000f^3\u0015\u000b\u0001\f9$a\u000f\t\u000f\u0005e\u0012\u0011\u0007a\u0001=\u0005\u00191.Z=\t\r\u0019\n\t\u00041\u0001y\u0011\u001d\tyd\u0012C!\u0003\u0003\n1bZ3u\u000b\u0012LGo\u001c:JIR)a$a\u0011\u0002R!A\u0011QIA\u001f\u0001\u0004\t9%A\u0003j]B,H\u000f\u0005\u0003\u0002J\u00055SBAA&\u0015\t!V&\u0003\u0003\u0002P\u0005-#\u0001D%FI&$xN]%oaV$\bBB<\u0002>\u0001\u0007\u0001\u0010C\u0004\u0002V\u001d#\t%a\u0016\u0002\u001d\u001d,G/\u00123ji>\u0014\u0018J\u001c9viR!\u0011qIA-\u0011\u001d\t)%a\u0015A\u0002aDq!!\u0018H\t\u0003\ty&\u0001\nhKR\u001c6-\u00197b)\"\u0014X-\u00193UKb$Hc\u0001\u0010\u0002b!A\u00111MA.\u0001\u0004\t)'\u0001\u0004uQJ,\u0017\r\u001a\t\u0004\u001d\u0005\u001d\u0014bAA5\u0005\tY1kY1mCRC'/Z1e\u0011\u001d\tig\u0012C\u0001\u0003_\nacZ3u'\u000e\fG.Y*uC\u000e\\gI]1nKR+\u0007\u0010\u001e\u000b\u0004=\u0005E\u0004\u0002CA:\u0003W\u0002\r!!\u001e\u0002\u0015M$\u0018mY6Ge\u0006lW\rE\u0002\u000f\u0003oJ1!!\u001f\u0003\u0005=\u00196-\u00197b'R\f7m\u001b$sC6,\u0007bBA?\u000f\u0012\u0005\u0013qP\u0001 O\u0016$\u0018J\\:ueV\u001cG/[8o!>Lg\u000e^3s\u0003:tw\u000e^1uS>tGCBAA\u0003#\u000bY\n\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\rM|WO]2f\u0015\r\tY)[\u0001\u0005i\u0016DH/\u0003\u0003\u0002\u0010\u0006\u0015%AC!o]>$\u0018\r^5p]\"A\u00111SA>\u0001\u0004\t)*\u0001\u0006fI&$xN\u001d)beR\u0004B!!\u0013\u0002\u0018&!\u0011\u0011TA&\u0005-IU\tZ5u_J\u0004\u0016M\u001d;\t\u0011\u0005u\u00151\u0010a\u0001\u0003?\u000bQA\u001a:b[\u0016\u00042\u0001KAQ\u0013\r\t\u0019+\u000b\u0002\f\u0013N#\u0018mY6Ge\u0006lW\rC\u0004\u0002(\u001e#\t%!+\u0002G\u001d,G/\u00138tiJ,8\r^5p]B{\u0017N\u001c;fe\u0006sgn\u001c;bi&|g\u000eV=qKR)a$a+\u0002.\"A\u00111SAS\u0001\u0004\t)\n\u0003\u0005\u0002\u001e\u0006\u0015\u0006\u0019AAP\u0011\u001d\t\tl\u0012C!\u0003g\u000b!dZ3u\u0013:\u001cHO];di&|g\u000eU8j]R,'/S7bO\u0016$b!a\u0006\u00026\u0006]\u0006\u0002CAJ\u0003_\u0003\r!!&\t\u0011\u0005u\u0015q\u0016a\u0001\u0003?Cq!a/H\t\u0003\ni,A\rhKRLen\u001d;sk\u000e$\u0018n\u001c8Q_&tG/\u001a:UKb$H#\u0002\u0010\u0002@\u0006\u0005\u0007\u0002CAJ\u0003s\u0003\r!!&\t\u0011\u0005u\u0015\u0011\u0018a\u0001\u0003?\u0003")
public class ScalaDebugModelPresentation
implements IInstructionPointerPresentation {
    public static String textFor(IVariable iVariable) {
        return ScalaDebugModelPresentation$.MODULE$.textFor(iVariable);
    }

    public void addListener(ILabelProviderListener listener) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void removeListener(ILabelProviderListener listener) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        new Job(this, value, listener){
            private final IValue value$1;
            private final IValueDetailListener listener$1;

            public IStatus run(IProgressMonitor progressMonitor) {
                this.listener$1.detailComputed(this.value$1, ScalaDebugModelPresentation$.MODULE$.computeDetail(this.value$1));
                return Status.OK_STATUS;
            }
            {
                this.value$1 = value$1;
                this.listener$1 = listener$1;
                super("Computing Scala debug details");
            }
        }.schedule();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getImage(Object element) {
        String string;
        boolean bl = false;
        VirtualVariable virtualVariable = null;
        Object object = element;
        if (object instanceof ScalaDebugTarget) {
            return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
        }
        if (object instanceof ScalaThread) {
            return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
        }
        if (object instanceof ScalaStackFrame) {
            return DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
        }
        if (object instanceof IndexedVariablePartition) {
            return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        }
        if (object instanceof VirtualVariable) {
            bl = true;
            virtualVariable = (VirtualVariable)((Object)object);
            String string2 = virtualVariable.name();
            if ("<sender>".equals(string2)) {
                return ScalaDebugPlugin$.MODULE$.plugin().registry().get("images.actor");
            }
        }
        if (bl && "<parent>".equals(string = virtualVariable.name())) {
            return ScalaDebugPlugin$.MODULE$.plugin().registry().get("images.actor");
        }
        if (object instanceof IVariable) {
            return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        }
        if (!(object instanceof IStackFrame)) return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        return DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
    }

    public String getText(Object element) {
        String string;
        Object object = element;
        if (object instanceof ScalaDebugTarget) {
            ScalaDebugTarget scalaDebugTarget = (ScalaDebugTarget)object;
            string = scalaDebugTarget.getName();
        } else if (object instanceof ScalaThread) {
            ScalaThread scalaThread = (ScalaThread)((Object)object);
            string = this.getScalaThreadText(scalaThread);
        } else if (object instanceof ScalaStackFrame) {
            ScalaStackFrame scalaStackFrame = (ScalaStackFrame)((Object)object);
            string = this.getScalaStackFrameText(scalaStackFrame);
        } else if (object instanceof IVariable) {
            IVariable iVariable = (IVariable)object;
            string = ScalaDebugModelPresentation$.MODULE$.textFor(iVariable);
        } else {
            string = element.toString();
        }
        return string;
    }

    public void setAttribute(String key, Object value) {
    }

    public String getEditorId(IEditorInput input, Object element) {
        return EditorUtility.getEditorID((IEditorInput)input);
    }

    public IEditorInput getEditorInput(Object input) {
        return EditorUtility.getEditorInput((Object)input);
    }

    public String getScalaThreadText(ScalaThread thread) {
        return thread.isSystemThread() ? new StringOps(Predef$.MODULE$.augmentString("Daemon System Thread [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{thread.getName()})) : new StringOps(Predef$.MODULE$.augmentString("Thread [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{thread.getName()}));
    }

    public String getScalaStackFrameText(ScalaStackFrame stackFrame) {
        int lineNumber;
        return new StringOps(Predef$.MODULE$.augmentString("%s line: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stackFrame.getMethodFullName(), (lineNumber = stackFrame.getLineNumber()) == -1 ? "not available" : ((Object)BoxesRunTime.boxToInteger((int)lineNumber)).toString()}));
    }

    public Annotation getInstructionPointerAnnotation(IEditorPart editorPart, IStackFrame frame) {
        return new InstructionPointerAnnotation(frame, "org.eclipse.debug.ui.secondaryIP", DebugUIMessages.InstructionPointerAnnotation_1, DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER"));
    }

    public String getInstructionPointerAnnotationType(IEditorPart editorPart, IStackFrame frame) {
        return "org.eclipse.debug.ui.secondaryIP";
    }

    public Image getInstructionPointerImage(IEditorPart editorPart, IStackFrame frame) {
        return DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
    }

    public String getInstructionPointerText(IEditorPart editorPart, IStackFrame frame) {
        return DebugUIMessages.InstructionPointerAnnotation_1;
    }
}

