/*
 * Decompiled with CFR 0.152.
 */
package org.scalaide.debug.internal.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.scalaide.debug.internal.ScalaDebugger$;
import org.scalaide.debug.internal.model.ScalaArrayReference;
import org.scalaide.debug.internal.model.ScalaNullValue;
import org.scalaide.debug.internal.model.ScalaObjectReference;
import org.scalaide.debug.internal.model.ScalaPrimitiveValue;
import org.scalaide.debug.internal.model.ScalaStringReference;
import org.scalaide.debug.internal.model.ScalaValue;
import org.scalaide.debug.internal.model.ScalaValue$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.util.Try$;

public final class ScalaDebugModelPresentation$ {
    public static final ScalaDebugModelPresentation$ MODULE$;

    static {
        new ScalaDebugModelPresentation$();
    }

    public String computeDetail(IValue value) {
        block7: {
            String string;
            block3: {
                IValue iValue;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                iValue = value;
                                if (!(iValue instanceof ScalaPrimitiveValue)) break block2;
                                ScalaPrimitiveValue scalaPrimitiveValue = (ScalaPrimitiveValue)iValue;
                                string = scalaPrimitiveValue.getValueString();
                                break block3;
                            }
                            if (!(iValue instanceof ScalaStringReference)) break block4;
                            ScalaStringReference scalaStringReference = (ScalaStringReference)iValue;
                            string = scalaStringReference.underlying().value();
                            break block3;
                        }
                        if (!(iValue instanceof ScalaNullValue)) break block5;
                        string = "null";
                        break block3;
                    }
                    if (!(iValue instanceof ScalaArrayReference)) break block6;
                    ScalaArrayReference scalaArrayReference = (ScalaArrayReference)iValue;
                    string = this.computeDetail(scalaArrayReference);
                    break block3;
                }
                if (!(iValue instanceof ScalaObjectReference)) break block7;
                ScalaObjectReference scalaObjectReference = (ScalaObjectReference)iValue;
                string = this.computeDetail(scalaObjectReference);
            }
            return string;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String textFor(IVariable variable) {
        String name = (String)Try$.MODULE$.apply((Function0)new Serializable(variable){
            public static final long serialVersionUID = 0L;
            private final IVariable variable$1;

            public final String apply() {
                return this.variable$1.getName();
            }
            {
                this.variable$1 = variable$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unavailable Name";
            }
        });
        String value = (String)Try$.MODULE$.apply((Function0)new Serializable(variable){
            public static final long serialVersionUID = 0L;
            private final IVariable variable$1;

            public final IValue apply() {
                return this.variable$1.getValue();
            }
            {
                this.variable$1 = variable$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(IValue x$1) {
                return ScalaDebugModelPresentation$.MODULE$.computeDetail(x$1);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unavailable Value";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}));
    }

    private String computeDetail(ScalaArrayReference arrayReference) {
        ArrayReference array = arrayReference.underlying();
        return array.length() == 0 ? "Array()" : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(array.getValues()).asScala()).map((Function1)new Serializable(arrayReference){
            public static final long serialVersionUID = 0L;
            private final ScalaArrayReference arrayReference$1;

            public final String apply(Value value) {
                return ScalaDebugModelPresentation$.MODULE$.computeDetail(ScalaValue$.MODULE$.apply(value, this.arrayReference$1.getDebugTarget()));
            }
            {
                this.arrayReference$1 = arrayReference$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("Array(", ", ", ")");
    }

    private String computeDetail(ScalaObjectReference objectReference) {
        String string;
        if (ScalaDebugger$.MODULE$.currentThread() == null) {
            string = "";
        } else {
            try {
                String string2;
                ScalaValue scalaValue = objectReference.invokeMethod("toString", "()Ljava/lang/String;", ScalaDebugger$.MODULE$.currentThread(), (Seq<ScalaValue>)Predef$.MODULE$.wrapRefArray((Object[])new ScalaValue[0]));
                if (scalaValue instanceof ScalaStringReference) {
                    ScalaStringReference scalaStringReference = (ScalaStringReference)scalaValue;
                    string2 = scalaStringReference.underlying().value();
                } else if (scalaValue instanceof ScalaNullValue) {
                    string2 = "null";
                } else {
                    throw new MatchError((Object)scalaValue);
                }
                string = string2;
            }
            catch (Exception exception) {
                string = new StringOps(Predef$.MODULE$.augmentString("exception while invoking toString(): %s\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage(), exception.getStackTrace()}));
            }
        }
        return string;
    }

    private ScalaDebugModelPresentation$() {
        MODULE$ = this;
    }
}

