topic "Packages, Assemblies and Nests";
[ $$0,0#00000000000000000000000000000000:Default]
[=b133;*R+184 $$1,2#50732784410233463530219518343157:Heading1]
[a17;*@(170.42.0) $$2,3#48345324464242285505540720043115:Heading2]
[ph2 $$3,3#42410412485283044863419059360682:Enumaration]
[a83;*R6 $$4,5#31310162474203024125188417583966:caption]
[b42;a42;ph2 $$5,5#45413000475342174754091244180557:text]
[b83;*4 $$6,5#07864147445237544204411237157677:title]
[b17;t246;C@5;2 $$7,7#20902679421464641399138805415013:code]
[{_}%EN-US 
[s4; Packages, Assemblies `& Nests&]
[s6; Packages&]
[s5; Packages are centric to U`+`+.  An executable application is 
built from a package.  A package can also build into a dynamic 
link library.  A package can be used by other packages.  A package 
corresponds to a single directory with the directory name being 
the name of the package.  The package directory contains the 
package definition file (a plain text file with a .upp extension), 
which always has the same name as the package directory.  The 
package definition file contains a list of the source files that 
make up the package, plus information on what type of package 
it is, how it should be built and what other packages it uses. 
 The source files for the package are normally located in the 
package directory and its subdirectories, but they may be in 
any desired location.  A package directory must be located in 
an assembly nest or in the sub`-folders of a nest (see [/ Package`-locations 
]below).&]
[s5; The package definition file is maintained by TheIDE and you 
should never need to manipulate it manually.  The package definition 
file is updated at various times by TheIDE, including :&]
[s3;l288;i150;O0;~~~160; When you add/remove source files to/from 
a package&]
[s3;l288;i150;O0;~~~160; When you add/remove packages used by the 
package&]
[s3;l288;i150;O0;~~~160; When you change package build settings using 
the [/ package`-organizer]&]
[s3;l288;i150;O0;~~~160; When you change the package build configurations 
using [/ main`-package`-configuration]&]
[s3;l288;i150;O0;~~~160; When you change/assign custom build steps 
for the package&]
[s5; For more detail on configuring packages and assemblies, [^topic`:`/`/ide`/app`/ConfiguringPackagesAssemblies`$en`-us^ s
ee this].&]
[s5; When a package is built, the compiler will be invoked for each 
of the source files that belong to the package and for any source 
files that belong to packages directly or indirectly used by 
the [* main package.]&]
[s6; Assemblies&]
[s5; An assembly can be thought of as a collection of packages but 
it is actually just a set of paths which determine where U`+`+ 
looks for the packages needed to build a package (or application). 
 The assembly paths also determine where the compiler looks for 
files named in C`+`+ #include directives.  An assembly also specifies 
the root folder for the location for the output files (.obj, 
.exe etc) produced by a build plus the location of common files. 
 The paths defined by the assembly are stored in an assembly 
definition file which has a .var extension and is stored in the 
U`+`+ root installation directory.  A package can be associated 
with multiple assemblies.  Files produced by a build are actually 
placed in a sub`-folder of the output root folder and the sub`-folder 
is named according to the package name, the [* build flags] and 
the compiler that was used.  e.g. for the HelloWorld example 
when built with MSVC`+`+ 7.1 compiler, the output file folder 
is typically [/ C:/upp/out/HelloWorld/MSC71.Gui.Main] where [/ C:/upp/out] 
is specified as the output folder root in the assembly.&]
[s6; Opening a package&]
[s3; To open a package, the [/ Set`-main`-package] option on the File 
menu in TheIDE is used. The `"Select main package`" dialog will 
appear.&]
[s3; &]
[s0;= 
@@rawimage:2956&1618
(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)
&]
[s3; &]
[s5; First select an assembly in the left hand pane, then select 
one of the assembly`'s packages in the right hand pane. Click 
OK and the selected package will be opened in TheIDE with the 
package name shown in TheIDE application window title bar.  The 
package that has been opened is referred to as the [* main package] 
and it appears first in the list of packages shown at the left`-hand`-side 
of TheIDE.  To select a different [* main package], the [/ Set`-main`-package] 
option from the File menu can be used.  For more detail on creating 
and configuring packages and assemblies, [^topic`:`/`/ide`/app`/ConfiguringPackagesAssemblies`$en`-us^ s
ee this].&]
[s5; In TheIDE, a build command builds a package, not an assembly, 
but the assembly determines where the needed packages and include 
files are looked for.  The Build option on TheIDE build`-menu 
always builds the [* main package].  The build`-package option 
can be used to build any of the packages that are directly or 
indirectly used by the [* main package] i.e. any of the packages 
displayed in the package list at the left hand side of TheIDE. 
 On the Project menu in TheIDE, the [/ add`-package], [/ package`-organizer] 
and [/ main`-package`-configuration] options apply to the [* main 
package].  The [/ project`-export] option on the File menu exports 
the main package and all the packages that are directly and indirectly 
used by the main package, to any folder you choose.&]
[s6; Nests&]
[s5; U`+`+ requires that packages be organized into nests.  A nest 
is actually just a directory containing a set of package directories 
and source files.  An assembly defines an ordered list of nests 
(paths) and the packages contained in those nests form the packages 
of the assembly.  The packages associated with an assembly are 
shown in the right hand pane of the [/ Select`-main`-package] dialog 
when the assembly name is highlighted in the left hand pane. 
 The nest paths specified in an assembly can also be used to 
set additional include paths for the compiler. See [/ Include`-paths`-and`-#include
`-directives] below for more detail.&]
[s5; The assembly containing all of the U`+`+ library packages is 
uppsrc and the name of the associated nest is also uppsrc.&]
[s6; The U`+`+ examples assembly&]
[s5; The assembly containing all of the U`+`+ examples (such as HelloWorld), 
is named `"examples`" and you can see it in the select`-main`-package 
dialog.  It has two nests, `"examples`" and `"uppsrc`".  On the 
Windows platform, the path setting for the nests of the examples 
assembly might appear as follows :&]
[s5; C:/upp/examples;C:/upp/uppsrc&]
[s5; where C:`\upp is the U`+`+ root installation directory.  A semicolon 
separates the path settings for each nest  The examples nest 
contains all of the U`+`+ examples packages and the uppsrc nest 
contains all of the U`+`+ core library packages.&]
[s5; For portability, [*_@(170.42.150) forward slashes should be used 
in all path specifications] rather than back`-slashes.  This 
also applies to #include directives.&]
[s6; Include paths and #include directives&]
[s5; The nest paths defined in an assembly determine where U`+`+ 
looks for the assembly`'s packages.  These paths are also added 
to the `"include path list`" for the compilation of source files 
via the `"`-I`" (or equivalent) compiler command line option. 
 e.g. for the examples assembly above, the `-I command line setting 
(for GCC) would be &]
[s5; `-IC:/upp/examples `-IC:/upp/uppsrc&]
[s5; This means that the path names used in #include directives in 
C`+`+ source files can begin with the name of a folder/package 
that is the member of an assembly nest.  e.g. in the HelloWorld 
example hello.cpp file you will see&]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s5; CtrlLib is the name of a U`+`+ library package in the uppsrc 
nest.  Angle brackets should be used in a #include directive 
when #including U`+`+ source files because this prevents the 
compiler from looking in the current directory for a folder named 
e.g. `"CtrlLib`".  i.e. with all U`+`+ supported compilers, the 
angle brackets means the search for the included file begins 
with the paths specified in the `-I directive.  When #including 
files that are members of the same folder (or sub`-folders) as 
the file doing the #include, then double quotes should be used 
instead of angle brackets.&]
[s5; On non`-Windows platforms, folder names are case sensitive so 
[*_@(141.42.150) it is recommended that the correct case always 
be used]  e.g. CtrlLib and not ctrllib.&]
[s5; See [/ Alternative`-#include`-path`-mechanisms] below for additional 
information.&]
[s6; Package locations&]
[s5; A package folder does not have to be located in a top level 
nest folder.  It may be located in a sub`-folder of a nest folder 
if desired.  For example, consider the following directory structure.&]
[s5; [/ Nest1/Pkg1]&]
[s5; [/ Nest1/Project1/Pkg2]&]
[s5; [/ Nest1/Project1/Client/Pkg3]&]
[s5; [/ Nest1/Project1/Common]&]
[s5; and an assembly nest path setting of&]
[s5; [/ C:/upp/Nest1;C:/upp/uppsrc]&]
[s5; Pkg1 is located in the top level Nest1 folder. Pkg2 is located 
in the Project1 sub`-folder of Nest1.  U`+`+ searches all of 
the sub`-folders of a nest to maximum depth when looking for 
packages.&]
[s5; A source file in Pkg3 can #include a source file in Pkg2 (File2.h) 
with&]
[s7; #include <Project1/Pkg2/File2.h>&]
[s5; Double quotes can be used instead of angle brackets providing 
the Pkg3 folder does not contain a Project1 folder.&]
[s5; A source file in Pkg3 can #include a file from its own folder 
(File3.h) with either&]
[s7; #include `"File3.h`"&]
[s3; or&]
[s7; #include <Project1/Client/Pkg3/File3.h>&]
[s5; The organization of packages and #includes shown above allows 
the Project1 folder to be located in any nest.without changing 
any of the #includes.because all of the pathnames begin with 
Project1.  It also allows an assembly to switch between different 
revisions of Project1 just by changing the assembly nest path 
setting.&]
[s5; When a package is created using the Create`-new`-package dialog, 
the package name must include some path information if the package 
is not a top level folder within a nest. e.g. for the Project1/Pkg2 
package above, the package name needs to be entered as Project1/Pkg2. 
 For Pkg1, the package name can be entered as just Pkg1 because 
the package is in a top level nest folder.&]
[s5; An assembly may contain multiple projects/applications or just 
one project.  If there are multiple projects in an assembly then 
you need to consider the package/folder/file name issue described 
below.&]
[s6; Package/folder/file names&]
[s5; It is usually necessary that the names of the folders and files 
that appear in the top level nest folders of an assembly be [*_@(113.42.150) unique
 across all the top level nest folders of that assembly] unless 
duplicated names are referenced using a complete path specification. 
 This means that if an assembly includes the uppsrc nest, then 
the other nests of that assembly must not contain packages or 
folders that have the same name as folders/packages in the uppsrc 
nest.  e.g. The HelloWorld examples nest cannot contain packages 
with names such as CtrlLib, RichEdit or Common because these 
are the names of uppsrc library packages.&]
[s5; Hence the names of uppsrc packages need to be avoided when choosing 
names for folders/packages that are located in a top level nest 
folder if the assembly includes the uppsrc nest.  Refer to the 
uppsrc folder in the U`+`+ installation path for the full list 
of uppsrc package/folder names.  The names of uppsrc packages 
need to be avoided as folder names within any folder that is 
specified as an include path to the compiler (see [/ alternative`-include`-path`-me
chanisms] below).&]
[s5; If a package is to be distributed to others, one way of avoiding 
a clash of package names is to locate them in a folder whose 
name is likely to be unique e.g. &]
[s5; Nest1/CZ1Soft/Pkg1.  &]
[s5; and&]
[s7; #include <CZ1Soft/Pkg1/File1.h>&]
[s5; CZ1Soft is a name that has a reasonable chance of being unique. 
 The name of the Pkg1 folder can be anything because it is not 
a top level nest folder and.is not specified as an include path 
to the compiler.&]
[s5; If source files are placed directly in a nest folder (e.g. Nest1 
above), then the names need to be unique across all nest folders 
of the assembly unless they are always accessed with either a 
complete path specification or with no path specification (in 
which case they need to be in the same folder as the including 
file). e.g.&]
[s3;l160;i96;O0; #include `"File1.h`" contains no path specification.&]
[s3;l160;i96;O0; #include `"../Pkg2/File2.h`" is a complete path 
specification.&]
[s3;l160;i96;O0; #include <Project1/Pkg2/File2.h> is an incomplete 
path specification.&]
[s5; Note `"..`" in a path specification means `"parent folder`" 
i.e. up one level&]
[s6; Alternative #include path mechanisms&]
[s5; The nest paths specified in an assembly are normally used to 
identify the directory (or directory tree) where packages can 
be found and, as explained above, the `"normal`" method of #including 
header files is that when the header file name involves an incomplete 
path, the given pathname begins with the name of a top`-level 
nest folder e.g. #include <CtrlLib/CtrlLib.h>.  CtrlLib is the 
name of a top`-level nest folder because it is located in the 
uppsrc nest.&]
[s5; Because the paths specified in an assembly are added to the 
`"include path list`" for the compiler (using `-I or /I), you 
can use this mechanism to add directories to the include path 
list, even if those directories don`'t contain any packages. 
 You need to remember that the search for packages looks in all 
sub`-folders of the assembly nest paths and also that you may 
need to avoid using folder names that are the names of uppsrc 
packages (see the [/ Package`-folder`-names] section above).  The 
order of the `-I (or /I) directives supplied to the compiler 
is the same as the order of the nest paths specified in the assembly 
and this determines the search order when the compiler looks 
for #include files.&]
[s5; e.g. suppose you have a folder, C:/SomeFolder, that contains 
a header file SomeHeader.h.  You can add SomeFolder to the assembly 
nest path like this&]
[s5; C:/upp/examples;C:/upp/uppsrc;C:/SomeFolder&]
[s3; &]
[s3; In your source files you can now write&]
[s7; #include <SomeHeader.h>&]
[s3; or&]
[s7; #include `"SomeHeader.h`"&]
[s5; Angle brackets are preferred because they mean the search begins 
in paths specified in `-I directives rather than in the folder 
containing the file doing the #include&]
[s5; .Providing the header files in the SomeFolder folder use angle 
brackets when #including uppsrc files, it will not matter if 
the SomeFolder folder contains directories that have the same 
name as uppsrc directories, because C:/SomeFolder is last in the 
assembly nest path list.&]
[s5; You can also use the [/ package`-organizer] in TheIDE to specify 
additional include paths.  The [/ package`-organizer] allows you 
to enter additional switches to be passed to the compiler for 
all packages, for specific packages or for specific source files. 
 This allows you to add a `-I switch (or /I) to specify an include 
path.  These switches get added to the compiler command line 
[/ after] the `-I switches for the assembly nest paths.  To see 
how the compiler is invoked when a source file is compiled, turn 
on the [/ verbose] option in the Setup menu in TheIDE.  You can 
use [* build flags] to restrict the additional compiler switches 
to be in effect only when your own package`'s source files are 
being compiled.  The [/^topic`:`/`/ide`/app`/ConfiguringPackagesAssemblies`$en`-us^ p
ackage`-organizer] also allows you to specify compiler switches 
for specific files.&]
[s6; Layout file #includes&]
[s5; A layout file contains a description of the GUI part of a project 
i.e. the layout of widgets etc.  e.g. the AddressBook example 
in the examples assembly uses a layout file and the AddressBook.cpp 
file has the following two lines.&]
[s7; #define LAYOUTFILE <AddressBook/AddressBook.lay>&]
[s7; #include <CtrlCore/lay.h>&]
[s5; The #define for LAYOUTFILE should use angle brackets and not 
double quotes and must also include a path specification that 
starts with a top level folder of a nest. i.e. it should not 
be written as&]
[s7; #define LAYOUTFILE `"AddressBook.lay`"&]
[s5; because the CtrlCore/lay.h file uses it to #include the layout 
file (multiple times) with&]
[s7; #include LAYOUTFILE&]
[s0;2 ]]