
;--- JWasm allows parts of a relocatable label to be pushed.

	.386

_TEXT16 segment use16 'CODE'
_start:
	mov ah,4Ch
	int 21h
_TEXT16 ends

_TEXT32 segment use32 'CODE'

	db 16 dup (55)

lbl32:

;--- currently LOW generates a 6A opcode - this is NOT a good idea
;--- because the byte is sign-extended, and the assembler can't know if the least-
;--- significant byte of the offset will be < 80h or not.

	push low lbl32			;should push a dword with 8-bit fixup

;--- since v2.12, "push lowword offset32" pushes a word instead of a dword,
;--- because masm does so as well. To push a dword value with a 16-bit fixup,
;--- pushd is required. The different behavior in jwasm v2.05-v2.11 is regarded
;--- as a regression.
	push lowword lbl32		;should push a word with 16-bit fixup
	pushd lowword lbl32		;should push a dword with 16-bit fixup
	push low32 lbl32		;should push a dword with 32-bit fixup

;--- actually, the SEG operator causes a 16-bit push in Masm/JWasm.
;--- IMO it would have been better if the operator DOES not
;--- force a specific size of the push operand, but just the fixup type.

	push seg lbl32

_TEXT32 ends

STACK segment stack
	db 100h dup (?)
STACK ends

END _start
