import itertools

TONES = [
    ('E4', 0.1, 0.1),
    ('E4', 0.1, 0.1),
    ('E4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('E4', 0.1, 0.3),
    ('G4', 0.1, 0.7),
    ('G3', 0.1, 0.7),
    ('C4', 0.3, 0.3),
    ('G3', 0.3, 0.3),
    ('E3', 0.3, 0.3),
    ('A3', 0.3, 0.1),
    ('B3', 0.1, 0.3),
    ('A#3', 0.2, 0.1),
    ('A3', 0.1, 0.3),
    ('G3', 0.1, 0.15),
    ('E4', 0.1, 0.15),
    ('G4', 0.1, 0.15),
    ('A4', 0.1, 0.3),
    ('F4', 0.1, 0.1),
    ('G4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.1),
    ('B3', 0.1, 0.5),
    ('C4', 0.3, 0.3),
    ('G3', 0.3, 0.3),
    ('E3', 0.3, 0.3),
    ('A3', 0.3, 0.1),
    ('B3', 0.1, 0.3),
    ('A#3', 0.2, 0.1),
    ('A3', 0.1, 0.3),
    ('G3', 0.1, 0.15),
    ('E4', 0.1, 0.15),
    ('G4', 0.1, 0.15),
    ('A4', 0.1, 0.3),
    ('F4', 0.1, 0.1),
    ('G4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.1),
    ('B3', 0.1, 0.9),
    ('G4', 0.1, 0.1),
    ('F#4', 0.1, 0.1),
    ('F4', 0.1, 0.1),
    ('D#4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('G#3', 0.1, 0.1),
    ('A3', 0.1, 0.1),
    ('C4', 0.1, 0.3),
    ('A3', 0.1, 0.1),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.5),
    ('G4', 0.1, 0.1),
    ('F#4', 0.1, 0.1),
    ('F4', 0.1, 0.1),
    ('D#4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('C5', 0.1, 0.3),
    ('C5', 0.1, 0.1),
    ('C5', 0.1, 1.1),
    ('G4', 0.1, 0.1),
    ('F#4', 0.1, 0.1),
    ('F4', 0.1, 0.1),
    ('D#4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('G#3', 0.1, 0.1),
    ('A3', 0.1, 0.1),
    ('C4', 0.1, 0.3),
    ('A3', 0.1, 0.1),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.5),
    ('D#4', 0.3, 0.3),
    ('D4', 0.3, 0.3),
    ('C4', 0.3, 1.3),
    ('C4', 0.1, 0.1),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.3),
    ('E4', 0.2, 0.05),
    ('C4', 0.2, 0.05),
    ('A3', 0.2, 0.05),
    ('G3', 0.1, 0.7),
    ('C4', 0.1, 0.1),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.1),
    ('E4', 0.1, 0.7),
    ('A4', 0.1, 0.3),
    ('G4', 0.1, 0.5),
    ('C4', 0.1, 0.1),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('D4', 0.1, 0.3),
    ('E4', 0.2, 0.05),
    ('C4', 0.2, 0.05),
    ('A3', 0.2, 0.05),
    ('G3', 0.1, 0.7),
    ('E4', 0.1, 0.1),
    ('E4', 0.1, 0.3),
    ('E4', 0.1, 0.3),
    ('C4', 0.1, 0.1),
    ('E4', 0.1, 0.3),
    ('G4', 0.1, 0.7),
    ('G3', 0.1, 0.7),
    ('G3', 0.1, 0.125),
    ('C4', 0.1, 0.125),
    ('E4', 0.1, 0.125),
    ('G4', 0.1, 0.125),
    ('C5', 0.1, 0.125),
    ('E5', 0.1, 0.125),
    ('G5', 0.1, 0.575),
    ('E5', 0.1, 0.575),
    ('G#3', 0.1, 0.125),
    ('C4', 0.1, 0.125),
    ('D#4', 0.1, 0.125),
    ('G#4', 0.1, 0.125),
    ('C5', 0.1, 0.125),
    ('D#5', 0.1, 0.125),
    ('G#5', 0.1, 0.575),
    ('D#5', 0.1, 0.575),
    ('A#3', 0.1, 0.125),
    ('D4', 0.1, 0.125),
    ('F4', 0.1, 0.125),
    ('A#4', 0.1, 0.125),
    ('D5', 0.1, 0.125),
    ('F5', 0.1, 0.125),
    ('A#5', 0.1, 0.575),
    ('A#5', 0.1, 0.125),
    ('A#5', 0.1, 0.125),
    ('A#5', 0.1, 0.125),
    ('C6', 0.675, 0),
]


def play_sound():
    note, length, wait = TONES.pop(0)
    if TONES:
        clock.schedule(play_sound, length + wait)
    tone.play(note, length)


clock.schedule(play_sound, 1.0)


# We just put something on the screen
BLOCK_POSITIONS = [
    (750, 50),
    (750, 550),
    (50, 550),
    (50, 50),
]
block_positions = itertools.cycle(BLOCK_POSITIONS)
block = Actor('block', center=(50, 50))


def draw():
    screen.clear()
    block.draw()


def move_block():
    """Move the block to the next position over 1 second."""
    animate(
        block,
        duration=1,
        pos=next(block_positions),
        on_finished=move_block
    )


move_block()
