/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.IvyComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;

public class IvyDependencyDescriptor
extends ExternalDependencyDescriptor {
    private final ModuleComponentSelector selector;
    private final String dynamicConstraintVersion;
    private final boolean changing;
    private final boolean transitive;
    private final boolean optional;
    private final SetMultimap<String, String> confs;
    private final List<Exclude> excludes;
    private final List<Artifact> dependencyArtifacts;

    public IvyDependencyDescriptor(ModuleComponentSelector selector, String dynamicConstraintVersion, boolean changing, boolean transitive, boolean optional, Multimap<String, String> confMappings, List<Artifact> artifacts, List<Exclude> excludes) {
        this.selector = selector;
        this.dynamicConstraintVersion = dynamicConstraintVersion;
        this.changing = changing;
        this.transitive = transitive;
        this.optional = optional;
        this.confs = ImmutableSetMultimap.copyOf(confMappings);
        this.dependencyArtifacts = ImmutableList.copyOf(artifacts);
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public IvyDependencyDescriptor(ModuleComponentSelector requested, ListMultimap<String, String> confMappings) {
        this(requested, requested.getVersion(), false, true, false, (Multimap<String, String>)confMappings, Collections.emptyList(), Collections.emptyList());
    }

    public String toString() {
        return "dependency: " + this.getSelector() + ", confs: " + this.confs;
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isConstraint() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    public String getDynamicConstraintVersion() {
        return this.dynamicConstraintVersion;
    }

    public SetMultimap<String, String> getConfMappings() {
        return this.confs;
    }

    @Override
    protected IvyDependencyDescriptor withRequested(ModuleComponentSelector newRequested) {
        return new IvyDependencyDescriptor(newRequested, this.dynamicConstraintVersion, this.changing, this.transitive, this.isOptional(), (Multimap<String, String>)this.confs, this.getDependencyArtifacts(), this.excludes);
    }

    public List<? extends VariantGraphResolveState> selectLegacyConfigurations(ConfigurationMetadata fromConfiguration, IvyComponentGraphResolveState ivyComponent, ResolutionFailureHandler resolutionFailureHandler) {
        Set wildcardPatterns;
        LinkedList<ConfigurationGraphResolveState> targets = new LinkedList<ConfigurationGraphResolveState>();
        boolean matched = false;
        String fromConfigName = fromConfiguration.getName();
        for (String config : fromConfiguration.getHierarchy()) {
            if (!this.confs.containsKey((Object)config)) continue;
            Set targetPatterns = this.confs.get((Object)config);
            if (!targetPatterns.isEmpty()) {
                matched = true;
            }
            for (String targetPattern : targetPatterns) {
                this.findMatches(ivyComponent, fromConfigName, config, targetPattern, targets, resolutionFailureHandler);
            }
        }
        if (!matched && this.confs.containsKey((Object)"%")) {
            for (String targetPattern : this.confs.get((Object)"%")) {
                this.findMatches(ivyComponent, fromConfigName, fromConfigName, targetPattern, targets, resolutionFailureHandler);
            }
        }
        if (!(wildcardPatterns = this.confs.get((Object)"*")).isEmpty()) {
            boolean excludeWildcards = false;
            for (String confName : fromConfiguration.getHierarchy()) {
                if (!this.confs.containsKey((Object)("!" + confName))) continue;
                excludeWildcards = true;
                break;
            }
            if (!excludeWildcards) {
                for (String targetPattern : wildcardPatterns) {
                    this.findMatches(ivyComponent, fromConfigName, fromConfigName, targetPattern, targets, resolutionFailureHandler);
                }
            }
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)targets.size());
        for (ConfigurationGraphResolveState target : targets) {
            builder.add((Object)target.asVariant());
        }
        return builder.build();
    }

    private void findMatches(IvyComponentGraphResolveState targetComponent, String fromConfiguration, String patternConfiguration, String targetPattern, List<ConfigurationGraphResolveState> targetConfigurations, ResolutionFailureHandler resolutionFailureHandler) {
        int startFallback = targetPattern.indexOf(40);
        if (startFallback >= 0 && targetPattern.endsWith(")")) {
            String preferred = targetPattern.substring(0, startFallback);
            ConfigurationGraphResolveState configuration = targetComponent.getConfiguration(preferred);
            if (configuration != null) {
                this.maybeAddConfiguration(targetConfigurations, configuration);
                return;
            }
            targetPattern = targetPattern.substring(startFallback + 1, targetPattern.length() - 1);
        }
        if (targetPattern.equals("*")) {
            for (String targetName : targetComponent.getConfigurationNames()) {
                ConfigurationGraphResolveState configuration = targetComponent.getConfiguration(targetName);
                if (!configuration.getMetadata().isVisible()) continue;
                this.maybeAddConfiguration(targetConfigurations, configuration);
            }
            return;
        }
        if (targetPattern.equals("@")) {
            targetPattern = patternConfiguration;
        } else if (targetPattern.equals("#")) {
            targetPattern = fromConfiguration;
        }
        ConfigurationGraphResolveState configuration = targetComponent.getConfiguration(targetPattern);
        if (configuration == null) {
            throw resolutionFailureHandler.configurationDoesNotExistFailure(targetComponent, targetPattern);
        }
        this.maybeAddConfiguration(targetConfigurations, configuration);
    }

    private void maybeAddConfiguration(List<ConfigurationGraphResolveState> configurations, ConfigurationGraphResolveState toAdd) {
        Iterator<ConfigurationGraphResolveState> iter = configurations.iterator();
        while (iter.hasNext()) {
            ConfigurationGraphResolveState configuration = iter.next();
            if (configuration.getMetadata().getHierarchy().contains(toAdd.getName())) {
                return;
            }
            if (!toAdd.getMetadata().getHierarchy().contains(configuration.getName())) continue;
            iter.remove();
        }
        configurations.add(toAdd);
    }

    public List<Exclude> getAllExcludes() {
        return this.excludes;
    }

    public List<ExcludeMetadata> getConfigurationExcludes(Collection<String> configurations) {
        if (this.excludes.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder rules = ImmutableList.builderWithExpectedSize((int)this.excludes.size());
        for (Exclude exclude : this.excludes) {
            Set<String> ruleConfigurations = exclude.getConfigurations();
            if (!IvyDependencyDescriptor.include(ruleConfigurations, configurations)) continue;
            rules.add((Object)exclude);
        }
        return rules.build();
    }

    public List<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    public ImmutableList<IvyArtifactName> getConfigurationArtifacts(ConfigurationMetadata fromConfiguration) {
        if (this.dependencyArtifacts.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableSet<String> includedConfigurations = fromConfiguration.getHierarchy();
        ImmutableList.Builder artifacts = ImmutableList.builder();
        for (Artifact depArtifact : this.dependencyArtifacts) {
            Set<String> artifactConfigurations = depArtifact.getConfigurations();
            if (!IvyDependencyDescriptor.include(artifactConfigurations, includedConfigurations)) continue;
            IvyArtifactName ivyArtifactName = depArtifact.getArtifactName();
            artifacts.add((Object)ivyArtifactName);
        }
        return artifacts.build();
    }

    protected static boolean include(Iterable<String> configurations, Collection<String> acceptedConfigurations) {
        for (String configuration : configurations) {
            if (configuration.equals("*")) {
                return true;
            }
            if (!acceptedConfigurations.contains(configuration)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IvyDependencyDescriptor that = (IvyDependencyDescriptor)o;
        return this.changing == that.changing && this.transitive == that.transitive && this.optional == that.optional && Objects.equal((Object)this.selector, (Object)that.selector) && Objects.equal((Object)this.dynamicConstraintVersion, (Object)that.dynamicConstraintVersion) && Objects.equal(this.confs, that.confs) && Objects.equal(this.excludes, that.excludes) && Objects.equal(this.dependencyArtifacts, that.dependencyArtifacts);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.selector, this.dynamicConstraintVersion, this.changing, this.transitive, this.optional, this.confs, this.excludes, this.dependencyArtifacts});
    }
}

