// This code conforms with the UFC specification version 2.0.3
// and was automatically generated by FFC version 1.0-beta2+.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'quadrature'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __BIHARMONIC_H
#define __BIHARMONIC_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class biharmonic_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Real', Cell('triangle', Space(2)), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values.
    *values = 0.0;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.0};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[1] = {0.0};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.0};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.0}};
    
    static const double dmats1[1][1] = \
    {{0.0}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.0;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
      y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
    y[1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new biharmonic_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class biharmonic_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.17320508, -0.1, 0.12171612, 0.094280904, 0.054433105};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.17320508, -0.1, 0.12171612, -0.094280904, 0.054433105};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.23094011, 0.13333333, 0.0, 0.18856181, -0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, -0.23094011, 0.13333333, 0.0, -0.18856181, -0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.0, -0.26666667, -0.24343225, 0.0, 0.054433105};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, -0.17320508, -0.1, 0.12171612, 0.094280904, 0.054433105};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.17320508, -0.1, 0.12171612, -0.094280904, 0.054433105};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.23094011, 0.13333333, 0.0, 0.18856181, -0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, -0.23094011, 0.13333333, 0.0, -0.18856181, -0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.0, -0.26666667, -0.24343225, 0.0, 0.054433105};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new biharmonic_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  biharmonic_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~biharmonic_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Real', Cell('triangle', Space(2)), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 1;
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = 0;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (0)" << std::endl;
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.33333333*x[0][0] + 0.33333333*x[1][0] + 0.33333333*x[2][0];
    coordinates[0][1] = 0.33333333*x[0][1] + 0.33333333*x[1][1] + 0.33333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new biharmonic_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  biharmonic_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~biharmonic_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.5*x[1][0] + 0.5*x[2][0];
    coordinates[3][1] = 0.5*x[1][1] + 0.5*x[2][1];
    coordinates[4][0] = 0.5*x[0][0] + 0.5*x[2][0];
    coordinates[4][1] = 0.5*x[0][1] + 0.5*x[2][1];
    coordinates[5][0] = 0.5*x[0][0] + 0.5*x[1][0];
    coordinates[5][1] = 0.5*x[0][1] + 0.5*x[1][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new biharmonic_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W1 = 0.5;
    // Quadrature points on the UFC reference element: (0.33333333, 0.33333333)
    
    // Value of basis functions at quadrature points.
    static const double FE0_D02[1][3] = \
    {{4.0, 4.0, -8.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[3] = {0, 2, 4};
    
    // Array of non-zero columns
    static const unsigned int nzc4[3] = {0, 1, 5};
    
    static const double FE0_D11[1][4] = \
    {{4.0, 4.0, -4.0, -4.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[4] = {0, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 36; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 81.
    double G[6];
    G[0] = W1*det*(K_10*K_10*K_10*K_10 + K_11*K_11*(2.0*K_10*K_10 + K_11*K_11));
    G[1] = W1*det*(K_10*K_10*(K_00*K_00 + K_01*K_01) + K_11*K_11*(K_00*K_00 + K_01*K_01));
    G[2] = W1*det*(K_00*K_00*K_00*K_00 + K_01*K_01*(2.0*K_00*K_00 + K_01*K_01));
    G[3] = 2.0*W1*det*(K_00*K_10*K_10*K_10 + K_11*(K_01*K_10*K_10 + K_11*(K_00*K_10 + K_01*K_11)));
    G[4] = 2.0*W1*det*(K_00*K_00*K_00*K_10 + K_01*(K_00*K_01*K_10 + K_11*(K_00*K_00 + K_01*K_01)));
    G[5] = W1*det*(4.0*K_00*K_00*K_10*K_10 + K_01*K_11*(4.0*K_01*K_11 + 8.0*K_00*K_10));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 300
    // Only 1 integration point, omitting IP loop.
    
    // Number of operations for primary indices: 108
    for (unsigned int j = 0; j < 3; j++)
    {
      for (unsigned int k = 0; k < 3; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc1[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[0];
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc4[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[1];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc1[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[1];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc4[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[2];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 72
    for (unsigned int j = 0; j < 4; j++)
    {
      for (unsigned int k = 0; k < 3; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc1[k]] += FE0_D02[0][k]*FE0_D11[0][j]*G[3];
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc4[k]] += FE0_D02[0][k]*FE0_D11[0][j]*G[4];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 48
    for (unsigned int j = 0; j < 4; j++)
    {
      for (unsigned int k = 0; k < 4; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc3[k]] += FE0_D11[0][j]*FE0_D11[0][k]*G[5];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 72
    for (unsigned int j = 0; j < 3; j++)
    {
      for (unsigned int k = 0; k < 4; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc3[k]] += FE0_D02[0][j]*FE0_D11[0][k]*G[3];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc3[k]] += FE0_D02[0][j]*FE0_D11[0][k]*G[4];
      }// end loop over 'k'
    }// end loop over 'j'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class biharmonic_interior_facet_integral_0_0: public ufc::interior_facet_integral
{
public:

  /// Constructor
  biharmonic_interior_facet_integral_0_0() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_interior_facet_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c0,
                               const ufc::cell& c1,
                               unsigned int facet0,
                               unsigned int facet1) const
  {
    // Extract vertex coordinates
    const double * const * x0 = c0.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J0_00 = x0[1][0] - x0[0][0];
    const double J0_01 = x0[2][0] - x0[0][0];
    const double J0_10 = x0[1][1] - x0[0][1];
    const double J0_11 = x0[2][1] - x0[0][1];
    
    // Compute determinant of Jacobian
    double detJ0 = J0_00*J0_11 - J0_01*J0_10;
    
    // Compute inverse of Jacobian
    const double K0_00 =  J0_11 / detJ0;
    const double K0_01 = -J0_01 / detJ0;
    const double K0_10 = -J0_10 / detJ0;
    const double K0_11 =  J0_00 / detJ0;
    
    // Extract vertex coordinates
    const double * const * x1 = c1.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J1_00 = x1[1][0] - x1[0][0];
    const double J1_01 = x1[2][0] - x1[0][0];
    const double J1_10 = x1[1][1] - x1[0][1];
    const double J1_11 = x1[2][1] - x1[0][1];
    
    // Compute determinant of Jacobian
    double detJ1 = J1_00*J1_11 - J1_01*J1_10;
    
    // Compute inverse of Jacobian
    const double K1_00 =  J1_11 / detJ1;
    const double K1_01 = -J1_01 / detJ1;
    const double K1_10 = -J1_10 / detJ1;
    const double K1_11 =  J1_00 / detJ1;
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet0][0];
    const unsigned int v1 = edge_vertices[facet0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x0[v1][0] - x0[v0][0];
    const double dx1 = x0[v1][1] - x0[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    const bool direction = dx1*(x0[facet0][0] - x0[v0][0]) - dx0*(x0[facet0][1] - x0[v0][1]) < 0;// Compute facet normals from the facet scale factor constants
    const double n00 = direction ? dx1 / det : -dx1 / det;
    const double n01 = direction ? -dx0 / det : dx0 / det;// Compute facet normals from the facet scale factor constants
    const double n10 = !direction ? dx1 / det : -dx1 / det;
    const double n11 = !direction ? -dx0 / det : dx0 / det;
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W2[2] = {0.5, 0.5};
    // Quadrature points on the UFC reference element: (0.21132487), (0.78867513)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0_D01[2][5] = \
    {{1.0, -0.15470054, 3.1547005, -0.84529946, -3.1547005},
    {1.0, 2.1547005, 0.84529946, -3.1547005, -0.84529946}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[5] = {0, 2, 3, 4, 5};
    
    static const double FE0_f0_D02[2][3] = \
    {{4.0, 4.0, -8.0},
    {4.0, 4.0, -8.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc5[3] = {0, 1, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc2[3] = {0, 2, 4};
    
    static const double FE0_f0_D10[2][5] = \
    {{1.0, 2.1547005, 0.84529946, -0.84529946, -3.1547005},
    {1.0, -0.15470054, 3.1547005, -3.1547005, -0.84529946}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    static const double FE0_f0_D11[2][4] = \
    {{4.0, 4.0, -4.0, -4.0},
    {4.0, 4.0, -4.0, -4.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {0, 3, 4, 5};
    
    static const double FE0_f1_D01[2][3] = \
    {{-2.1547005, -0.15470054, 2.3094011},
    {0.15470054, 2.1547005, -2.3094011}};
    
    // Array of non-zero columns
    static const unsigned int nzc11[3] = {0, 1, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc7[3] = {0, 2, 4};
    
    static const double FE0_f1_D10[2][5] = \
    {{-2.1547005, -1.0, 0.84529946, -0.84529946, 3.1547005},
    {0.15470054, -1.0, 3.1547005, -3.1547005, 0.84529946}};
    
    // Array of non-zero columns
    static const unsigned int nzc8[5] = {0, 1, 3, 4, 5};
    
    static const double FE0_f2_D01[2][5] = \
    {{-2.1547005, -1.0, 0.84529946, 3.1547005, -0.84529946},
    {0.15470054, -1.0, 3.1547005, 0.84529946, -3.1547005}};
    
    // Array of non-zero columns
    static const unsigned int nzc10[5] = {0, 2, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 450.
    double G[34];
    G[0] = -0.5*det*(K1_10*K1_10*K1_10*n10 + K1_11*(K1_10*K1_11*n10 + n11*(K1_10*K1_10 + K1_11*K1_11)));
    G[1] = -0.5*det*(K1_10*K1_10*(K1_00*n10 + K1_01*n11) + K1_11*K1_11*(K1_00*n10 + K1_01*n11));
    G[2] = -0.5*det*(K1_10*K1_10*(K0_10*n00 + K0_11*n01) + K1_11*K1_11*(K0_10*n00 + K0_11*n01));
    G[3] = -0.5*det*(K1_10*K1_10*(K0_00*n00 + K0_01*n01) + K1_11*K1_11*(K0_00*n00 + K0_01*n01));
    G[4] = -0.5*det*(K1_10*n10*(K1_00*K1_00 + K1_01*K1_01) + K1_11*n11*(K1_00*K1_00 + K1_01*K1_01));
    G[5] = -0.5*det*(K1_00*K1_00*K1_00*n10 + K1_01*(K1_00*K1_01*n10 + n11*(K1_00*K1_00 + K1_01*K1_01)));
    G[6] = -0.5*det*(K1_00*K1_00*(K0_10*n00 + K0_11*n01) + K1_01*K1_01*(K0_10*n00 + K0_11*n01));
    G[7] = -0.5*det*(K1_00*K1_00*(K0_00*n00 + K0_01*n01) + K1_01*K1_01*(K0_00*n00 + K0_01*n01));
    G[8] = -0.5*det*(K1_10*n10*(K0_10*K0_10 + K0_11*K0_11) + K1_11*n11*(K0_10*K0_10 + K0_11*K0_11));
    G[9] = -0.5*det*(K1_00*n10*(K0_10*K0_10 + K0_11*K0_11) + K1_01*n11*(K0_10*K0_10 + K0_11*K0_11));
    G[10] = -0.5*det*(K0_10*K0_10*K0_10*n00 + K0_11*(K0_10*K0_11*n00 + n01*(K0_10*K0_10 + K0_11*K0_11)));
    G[11] = -0.5*det*(K0_10*K0_10*(K0_00*n00 + K0_01*n01) + K0_11*K0_11*(K0_00*n00 + K0_01*n01));
    G[12] = -0.5*det*(K1_10*n10*(K0_00*K0_00 + K0_01*K0_01) + K1_11*n11*(K0_00*K0_00 + K0_01*K0_01));
    G[13] = -0.5*det*(K1_00*n10*(K0_00*K0_00 + K0_01*K0_01) + K1_01*n11*(K0_00*K0_00 + K0_01*K0_01));
    G[14] = -0.5*det*(K0_10*n00*(K0_00*K0_00 + K0_01*K0_01) + K0_11*n01*(K0_00*K0_00 + K0_01*K0_01));
    G[15] = -0.5*det*(K0_00*K0_00*K0_00*n00 + K0_01*(K0_00*K0_01*n00 + n01*(K0_00*K0_00 + K0_01*K0_01)));
    G[16] =  - det*(K1_00*K1_10*K1_10*n10 + K1_11*(K1_01*K1_10*n10 + n11*(K1_00*K1_10 + K1_01*K1_11)));
    G[17] =  - det*(K1_00*K1_00*K1_10*n10 + K1_01*(K1_00*K1_11*n10 + n11*(K1_00*K1_10 + K1_01*K1_11)));
    G[18] =  - det*(K1_00*K1_10*(K0_10*n00 + K0_11*n01) + K1_01*K1_11*(K0_10*n00 + K0_11*n01));
    G[19] =  - det*(K1_00*K1_10*(K0_00*n00 + K0_01*n01) + K1_01*K1_11*(K0_00*n00 + K0_01*n01));
    G[20] =  - det*(K1_10*n10*(K0_00*K0_10 + K0_01*K0_11) + K1_11*n11*(K0_00*K0_10 + K0_01*K0_11));
    G[21] =  - det*(K1_00*n10*(K0_00*K0_10 + K0_01*K0_11) + K1_01*n11*(K0_00*K0_10 + K0_01*K0_11));
    G[22] =  - det*(K0_00*K0_10*K0_10*n00 + K0_11*(K0_01*K0_10*n00 + n01*(K0_00*K0_10 + K0_01*K0_11)));
    G[23] =  - det*(K0_00*K0_00*K0_10*n00 + K0_01*(K0_00*K0_11*n00 + n01*(K0_00*K0_10 + K0_01*K0_11)));
    G[24] = det*w[1][0]*(K1_10*K1_10*n10*n10 + K1_11*n11*(2.0*K1_10*n10 + K1_11*n11))/w[0][0];
    G[25] = det*w[1][0]*(K1_00*K1_10*n10*n10 + n11*(K1_01*K1_11*n11 + n10*(K1_00*K1_11 + K1_01*K1_10)))/w[0][0];
    G[26] = det*w[1][0]*(K1_10*n10*(K0_10*n00 + K0_11*n01) + K1_11*n11*(K0_10*n00 + K0_11*n01))/w[0][0];
    G[27] = det*w[1][0]*(K1_10*n10*(K0_00*n00 + K0_01*n01) + K1_11*n11*(K0_00*n00 + K0_01*n01))/w[0][0];
    G[28] = det*w[1][0]*(K1_00*K1_00*n10*n10 + K1_01*n11*(2.0*K1_00*n10 + K1_01*n11))/w[0][0];
    G[29] = det*w[1][0]*(K1_00*n10*(K0_10*n00 + K0_11*n01) + K1_01*n11*(K0_10*n00 + K0_11*n01))/w[0][0];
    G[30] = det*w[1][0]*(K1_00*n10*(K0_00*n00 + K0_01*n01) + K1_01*n11*(K0_00*n00 + K0_01*n01))/w[0][0];
    G[31] = det*w[1][0]*(K0_10*K0_10*n00*n00 + K0_11*n01*(2.0*K0_10*n00 + K0_11*n01))/w[0][0];
    G[32] = det*w[1][0]*(K0_00*K0_10*n00*n00 + n01*(K0_01*K0_11*n01 + n00*(K0_00*K0_11 + K0_01*K0_10)))/w[0][0];
    G[33] = det*w[1][0]*(K0_00*K0_00*n00*n00 + K0_01*n01*(2.0*K0_00*n00 + K0_01*n01))/w[0][0];
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    switch (facet0)
    {
    case 0:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 7268
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 7268
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 480
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 720
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[15];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 480
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 1200
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 720
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[15];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc7[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc7[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D10[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc8[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc8[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc11[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc11[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f2_D01[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f2_D01[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc10[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f2_D01[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc10[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f2_D01[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc7[k]] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc7[k]] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc8[k]] += FE0_f0_D01[ip][j]*FE0_f1_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc8[k]] += FE0_f0_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D10[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc10[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc8[k]] += FE0_f1_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc10[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc10[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc11[k]] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc11[k]] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc11[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc10[k]] += FE0_f0_D01[ip][j]*FE0_f2_D01[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc10[k]] += FE0_f0_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f2_D01[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc10[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc10[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc10[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc11[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc10[k]] += FE0_f1_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc10[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc10[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc10[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc10[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc10[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc10[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc10[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc10[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc11[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + (nzc10[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc10[j] + 6)*12 + nzc10[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + (nzc10[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc10[j]*12 + nzc10[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975872, 0.054975872, 0.054975872, 0.11169079, 0.11169079, 0.11169079};
    // Quadrature points on the UFC reference element: (0.81684757, 0.091576214), (0.091576214, 0.81684757), (0.091576214, 0.091576214), (0.10810302, 0.44594849), (0.44594849, 0.10810302), (0.44594849, 0.44594849)
    
    // Value of basis functions at quadrature points.
    static const double FE0[6][6] = \
    {{-0.074803808, 0.51763234, -0.074803808, 0.29921523, 0.033544812, 0.29921523},
    {-0.074803808, -0.074803808, 0.51763234, 0.29921523, 0.29921523, 0.033544812},
    {0.51763234, -0.074803808, -0.074803808, 0.033544812, 0.29921523, 0.29921523},
    {-0.048208378, -0.084730493, -0.048208378, 0.19283351, 0.79548023, 0.19283351},
    {-0.048208378, -0.048208378, -0.084730493, 0.19283351, 0.19283351, 0.79548023},
    {-0.084730493, -0.048208378, -0.048208378, 0.79548023, 0.19283351, 0.19283351}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 6; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 156
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 6; r++)
      {
        F0 += FE0[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 2
      double I[1];
      // Number of operations: 2
      I[0] = F0*W6[ip]*det;
      
      
      // Number of operations for primary indices: 12
      for (unsigned int j = 0; j < 6; j++)
      {
        // Number of operations to compute entry: 2
        A[j] += FE0[ip][j]*I[0];
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_0: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), MultiIndex((Index(1),), {Index(1): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(3),), {Index(3): 2})), MultiIndex((Index(3),), {Index(3): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2}))), Measure('cell', 0, None)), Integral(Sum(Product(Division(PositiveRestricted(Constant(Cell('triangle', Space(2)), 1)), PositiveRestricted(Constant(Cell('triangle', Space(2)), 0))), Product(Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(4),), {Index(4): 2})), MultiIndex((Index(4),), {Index(4): 2}))), MultiIndex((Index(5),), {Index(5): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(5),), {Index(5): 2}))), MultiIndex((Index(5),), {Index(5): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(6),), {Index(6): 2})), MultiIndex((Index(6),), {Index(6): 2}))), MultiIndex((Index(7),), {Index(7): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(7),), {Index(7): 2}))), MultiIndex((Index(7),), {Index(7): 2}))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(8),), {Index(8): 2})), MultiIndex((Index(8),), {Index(8): 2}))), MultiIndex((Index(9),), {Index(9): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(9),), {Index(9): 2}))), MultiIndex((Index(9),), {Index(9): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(10),), {Index(10): 2})), MultiIndex((Index(10),), {Index(10): 2}))), MultiIndex((Index(11),), {Index(11): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(11),), {Index(11): 2}))), MultiIndex((Index(11),), {Index(11): 2}))))), Sum(Product(IntValue(-1, (), (), {}), Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(12),), {Index(12): 2})), MultiIndex((Index(13),), {Index(13): 2})), MultiIndex((Index(13),), {Index(13): 2})), MultiIndex((Index(12),), {Index(12): 2})), MultiIndex((Index(12),), {Index(12): 2}))), PositiveRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(14),), {Index(14): 2})), MultiIndex((Index(15),), {Index(15): 2})), MultiIndex((Index(15),), {Index(15): 2})), MultiIndex((Index(14),), {Index(14): 2})), MultiIndex((Index(14),), {Index(14): 2}))))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(16),), {Index(16): 2})), MultiIndex((Index(16),), {Index(16): 2}))), MultiIndex((Index(17),), {Index(17): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(17),), {Index(17): 2}))), MultiIndex((Index(17),), {Index(17): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(18),), {Index(18): 2})), MultiIndex((Index(18),), {Index(18): 2}))), MultiIndex((Index(19),), {Index(19): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(19),), {Index(19): 2}))), MultiIndex((Index(19),), {Index(19): 2}))))), Product(IntValue(-1, (), (), {}), Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(20),), {Index(20): 2})), MultiIndex((Index(21),), {Index(21): 2})), MultiIndex((Index(21),), {Index(21): 2})), MultiIndex((Index(20),), {Index(20): 2})), MultiIndex((Index(20),), {Index(20): 2}))), PositiveRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 1), MultiIndex((Index(22),), {Index(22): 2})), MultiIndex((Index(23),), {Index(23): 2})), MultiIndex((Index(23),), {Index(23): 2})), MultiIndex((Index(22),), {Index(22): 2})), MultiIndex((Index(22),), {Index(22): 2}))))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(24),), {Index(24): 2})), MultiIndex((Index(24),), {Index(24): 2}))), MultiIndex((Index(25),), {Index(25): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(25),), {Index(25): 2}))), MultiIndex((Index(25),), {Index(25): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), MultiIndex((Index(26),), {Index(26): 2})), MultiIndex((Index(26),), {Index(26): 2}))), MultiIndex((Index(27),), {Index(27): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', Space(2)))), MultiIndex((Index(27),), {Index(27): 2}))), MultiIndex((Index(27),), {Index(27): 2}))))))), Measure('interior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 1;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 2:
      {
        return new biharmonic_finite_element_0();
        break;
      }
    case 3:
      {
        return new biharmonic_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 2:
      {
        return new biharmonic_dofmap_0();
        break;
      }
    case 3:
      {
        return new biharmonic_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_interior_facet_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_1: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 2, None), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
