#! /usr/bin/env python

#Common imports
import os, sys
import unittest
import DiskSearchTest
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), '..'))
import platform

#import specific to the test
from libdisksearch import DSDoc
import ConstantsForTests

class TestCase(DiskSearchTest.TestCase):
    def setUp(self):
        self.dsdoc = DSDoc.DSDoc()
        self.filename = None
        self.userFile =os.path.join(os.path.expanduser ("~"), '.disksearchdb')
        self.backupFile(self.userFile)

    def tearDown(self):
        self.rmfile(self.filename)
        self.restoreFile(self.userFile)

    def testDisk(self):
        if platform.system() != 'Windows':
            assert('cdrom' in self.dsdoc.mountPoint)
        else:
            self.assertStringsEqual(self.dsdoc.mountPoint, 'd:')

        self.assertEqual(self.dsdoc.searchString, "")
        self.assertEqual(self.dsdoc.searchRegExpMode, 0)
        self.assertEqual(self.dsdoc.searchCaseSensitive, 0)
        self.assertEqual(self.dsdoc.mediaType, None)
        self.assertEqual(self.dsdoc.mountMode, 0)

    #I'm really suprised that Windows accept '/' as a directory separator. Tomas
    def testLoad_disklist1(self):
        self.filename = os.path.join(os.path.expanduser ("~"), '.disksearchdb')
        fh = open(self.filename, 'w')
        fh.write(ConstantsForTests.database)
        fh.close()
        self.dsdoc.load_disklist(None)
        #~ self.assertStringsEqual(self.filename, self.dsdoc.archiveName)) #Todo: use this line instead of the following one
        self.assertStringsEqual(os.path.expanduser ("~") + '/.disksearchdb', self.dsdoc.archiveName)
        self.assertListsEqual(self.dsdoc.diskList.content[0].content, ConstantsForTests.diskContentList)

    def testLoad_disklist2(self):
        self.filename = os.tempnam()
        fh = open(self.filename, 'w')
        fh.write(ConstantsForTests.database)
        fh.close()
        self.dsdoc.load_disklist(self.filename)
        self.assertStringsEqual(self.filename, self.dsdoc.archiveName)
        self.assertListsEqual(self.dsdoc.diskList.content[0].content, ConstantsForTests.diskContentList)

    def testLoad_disklist3(self):
        self.rmfile(os.path.join(os.path.expanduser ("~"), '.disksearchdb'))
        self.filename = os.path.join(os.path.expanduser ("~"), '.cdsearchdb')
        #~ fn1 = os.path.join(os.path.expanduser ("~"), '.disksearchdb')
        fh = open(self.filename, 'w')
        fh.write(ConstantsForTests.database)
        fh.close()
        self.dsdoc.load_disklist(None)
        #~ self.assertStringsEqual(fn1, self.dsdoc.archiveName) #Todo: use this line instead of the following one
        self.assertStringsEqual(os.path.expanduser ("~") + '/.disksearchdb', self.dsdoc.archiveName)
        self.assertListsEqual(self.dsdoc.diskList.content[0].content, ConstantsForTests.diskContentList)

    def testLoad_disklist4(self):
        self.filename = os.path.join(os.path.expanduser ("~"), '.disksearchdb')
        self.rmfile(self.filename)
        self.dsdoc.load_disklist(None)
        self.assertListsEqual(self.dsdoc.diskList.content, [])

def suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestCase))
    return suite

if __name__ == '__main__':
    unittest.main()
