##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

class Disk:
    """This class is for storing the content of a disk (e.g. a CD-ROM). The 
    content is stored in a list as in this example:
    [["dir1", [
        ["1.txt", 4534],
        ["2.txt", 5531],
        ["3.txt", 5363]]],
     ["dir2", [
        ["4.txt", 5342],
        ["5.txt", 7653],
        ["6.txt", 2324]]]
    Each directory is a sublist. The first item is the full directory name. The 
    second item is a sublist of all files of this directory. Each file entry is a 
    sublist again. The first item is the filename and the second the size in bytes.
    The size item is optional, it must be present but can be None."""
    
    def __init__ (self, name, type, remark, timestamp, content):
        """Creates a disk object with specified name, media type, remark, timestamp
        and content. All the possible media types are listed in class cdromlist.
        The timestamp (python time) is for when the disk was added (optional)."""

        self.name = name
        self.type = type
        self.remark = remark
        self.timestamp = timestamp
        self.content = content
