##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

# import PyGTK2 modules (with necessary version check)
import pygtk
pygtk.require ("2.0")
import gtk

import DSDoc
import DSView


class DSApp:
    """This is the main class of the application. It contains the model and 
    the view classes and is responsible for the startup."""
    
    # class attribute of the application view 
    view = DSView.DSView ()

    # class attribute of the application model 
    doc = DSDoc.DSDoc ()
    
    def __init__ (self, archive):
        """Constructor of DSApp class. The optional (command line argument) archive 
        parameter specifies the full filename of the disk archive."""

        # create and display GUI
        self.__class__.view.init_gui ()
        
        # load and display disk list (show wait cursor while this)
        self.__class__.view.show_wait_cursor (self.__class__.view.app_disksearch.window)
        self.__class__.doc.load_disklist (archive)
        self.__class__.view.display_disk_list ()
        self.__class__.view.show_default_cursor (self.__class__.view.app_disksearch.window)
            
        # start gtk main event loop
        gtk.main ()
