// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ParserKey_h__
#define __ParserKey_h__

namespace Puma {


class ParserKey {
public:
  static char getKey () { return '-'; }
  static const char *getLongKey () { return "--"; }
  static unsigned int getKeyLength () { return 1; }
  static unsigned int getLongKeyLength () { return 2; }
   
  static bool isKey (const string &arg) { return arg[0] == getKey (); }
  static bool isLongKey (const string &arg) { return arg.find (getLongKey ()) == 0; }
};


} // namespace Puma

#endif /* __ParserKey_h__ */
