#include <stdio.h>

// this example illustrates how thisJoinPoint->id() can be used.
// Advice 1 and 2 is called when function Foo::g () is executed.
// In both cases the join point is "execution of Foo::g ()" and
// the resulting join point ID must be the same.
// The call to Foo::g(), which is intercepted by advice 3 is a
// different join point, thus gives a different ID.

aspect IDs {
  advice execution("void Foo::f()") || execution("void Foo::g()") : before () {
    printf ("1-before %s id %d\n", thisJoinPoint->signature (),
	    thisJoinPoint->id ());
  }

  advice execution("void Foo::g()") || execution("void Foo::h()") : before () {
    printf ("2-before %s id %d\n", thisJoinPoint->signature (),
	    thisJoinPoint->id ());
  }
  advice call("void Foo::g()") : before () {
    printf ("3-before %s id %d\n", thisJoinPoint->signature (), 
	    thisJoinPoint->id ());
  }
};

class Foo
 {
   public:
      void f () {}
      void g () {}
      void h () {}
 };

int main ()
 {
   Foo foo;

   foo.f ();
   foo.g ();
   foo.h ();
   return 0;
 }
