// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OrderInfo_h__
#define __OrderInfo_h__

#include "PointCutEvaluator.h"
#include "PointCutContext.h"
#include "JoinPointLoc.h"

class OrderInfo {

  JPL_Aspect &_aspect;
  JPL_Order &_order;
  list<PointCutExpr*> _pces;
  PointCutExpr* _jp_pce;

  void add_pce (PointCutExpr *pce) { _pces.push_back (pce); }
  void set_jp_pce (PointCutExpr *jp_pce) { _jp_pce = jp_pce; }

 public:

  OrderInfo (JPL_Aspect &a, JPL_Order &o) : _aspect (a), _order (o), _jp_pce (0) {}
  ~OrderInfo () {
    for (list<PointCutExpr*>::iterator i = _pces.begin ();
         i != _pces.end (); ++i)
      PointCutEvaluator::destroy (*i);
    if (_jp_pce)
      PointCutEvaluator::destroy (_jp_pce);
  }
  const list<PointCutExpr*> &pces () const { return _pces; }
  PointCutExpr *jp_pce () const { return _jp_pce; }
  JPL_Aspect &aspect () const { return _aspect; }
  JPL_Order &order () const { return _order; }
  void analyze_exprs (ErrorStream &err, JoinPointModel &jpm) {
    PointCutContext context (jpm);
    PointCutEvaluator eval (err, context);
    context.concrete_aspect (_aspect);
    set_jp_pce (eval.create (_order.expr (), JoinPointLoc::Any));
    const list<CTree*> &exprs = _order.pces ();
    for (list<CTree*>::const_iterator i = exprs.begin (); i != exprs.end (); ++i)
      add_pce (eval.create (*i, JoinPointLoc::Aspect));
  }
  
};

#endif // __OrderInfo_h__
