// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ModelElementFactory_h__
#define __ModelElementFactory_h__

#include <string>
using std::string;

class JPL_Class;
class JPL_Aspect;
class JPL_Function;
class JPL_AdviceCode;
class JPL_ClassSlice;
class JPL_Method;
class JPL_MethodCall;
class JPL_Construction;
class JPL_Destruction;

/* interface for classes that can act as factories for join-point model
 * elements.
 */
 
class ModelElementFactory {
public:
  virtual ~ModelElementFactory () {}
  virtual JPL_Type *make_type (const string &s) = 0;
  virtual JPL_Namespace *make_namespace (const string &s) = 0;
  virtual JPL_Class *make_class (const string &s) = 0;
  virtual JPL_Aspect *make_aspect (const string &s) = 0;
  virtual JPL_Function *make_function (const string &n, const string &s) = 0;
  virtual JPL_AdviceCode *make_advice_code (const string &n, const string &s) = 0;
  virtual JPL_ClassSlice *make_class_slice (const string &s) = 0;
  virtual JPL_Method *make_execution () = 0;
  virtual JPL_MethodCall *make_call () = 0;
  virtual JPL_Construction *make_construction () = 0;
  virtual JPL_Destruction *make_destruction () = 0;
};

#endif // __ModelElementFactory_h__
