#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: xmlfile.py
#  Author: Alfredo Jr. <junix>
#  Creation: 29/10/2006
#  Changed: 12/11/2006
#  Purpose: XML Class
##
######################################################

import xml.dom.minidom
import string

import utils

(BOLVAL, METHOD, HOST, DISTRIBUTION, VERSION, SECTION, ARCHITECTURE, PATH, MEDIA) = range(9)

class XMLFile:
	def node_text(self, node):
		text = ''
		for child in node.childNodes:
			if child.nodeType is child.TEXT_NODE:
				text += child.data
			return text

	def parse(self, file):
		children_names = []
		if not utils.fileExist(file):
			self.createDefaultConfigFile(file)
			
		x = xml.dom.minidom.parse(file)
		nodes = x.documentElement
		children1 = [node for node in nodes.childNodes if node.nodeType == x.ELEMENT_NODE]
		for father in children1:
			children2 = [node for node in father.childNodes if node.nodeType == x.ELEMENT_NODE]
			for child in children2:
				children_names.append(child.nodeName + ', ' + self.node_text(child))
		return (children_names)

	def createDefaultConfigFile(self, file):
		"""Persists the server list and its folders to a xml file."""
		util = utils.SystemInfo()
		aFile = open(file,"w")
		aFile.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
		aFile.write('<download version="1.0">\n')
		aFile.write('    <settings>\n')
		if util.distro == 'ubuntu':
			aFile.write('        <host>archive.ubuntu.com</host>\n')
		else:
			aFile.write('        <host>ftp.debian.org</host>\n')
		aFile.write('        <dist>%s</dist>\n' % util.distro )
		aFile.write('        <method>http</method>\n')
		aFile.write('        <version>%s</version>\n' % util.codename)
		aFile.write('        <section>main</section>\n')
		aFile.write('        <arch>%s</arch>\n'  % util.architecture)
		aFile.write('        <path>/tmp/aptoncd</path>\n')
		aFile.write('        <media>CD</media>\n')
		aFile.write('    </settings>\n')
		aFile.write('</download>\n')
		aFile.close()

	def load_conf(self, file):
		util = utils.SystemInfo()
		host = 'archive.ubuntu.com'
		dist =  util.distro
		method = 'http'
		version = util.codename
		section = 'main'
		arch = util.architecture
		path = '/tmp/aptoncd'
		media = 'CD'
		try:
			node_text = self.parse(file)
			for child in node_text:
				if child.split(",")[0] == 'host':
					host = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'dist':
					dist = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'method':
					method = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'version':
					version = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'section':
					section = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'arch':
					arch = string.strip(child.split(",")[1])
				elif child.split(",")[0] == 'path':
					path = string.strip(child.split(",")[1]).encode('utf8')
				elif child.split(",")[0] == 'media':
					media = string.strip(child.split(",")[1])	
		except:
			return [False,'','','','','','','','']
		return [True, method, host, dist,  version, section, arch, path, media]
