/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.transport.multiplex;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import javax.management.MBeanServer;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * <p>
 * Copyright (c) Jul 21, 2006
 * </p>
 */
public class RestartServerTestServer extends ServerTestCase
{
   public static String locatorURI = "multiplex://localhost:3737";
   public static int ssPort = 3638;
   private ServerSocket ss;
   
   public void setUp()
   {
      try
      {
         ss = new ServerSocket(ssPort);
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }  
   }
   
   public void testBody()
   {
      try
      {
         Socket s = ss.accept();
         InputStream is = s.getInputStream();
         OutputStream os = s.getOutputStream();
         
         Connector connector = new Connector(locatorURI);
         connector.create();
         connector.addInvocationHandler("test", new SampleInvocationHandler(3));
         connector.start();
         os.write(2);
         
         is.read();
         connector.stop();
         System.out.println("********** stopped first Connector *************");
         connector = new Connector(locatorURI);
         connector.create();
         connector.addInvocationHandler("test", new SampleInvocationHandler(7));
         connector.start();
         System.out.println("********** started second Connector *************");
         os.write(4);
         
         is.read();
         connector.stop();
         s.close();
         ss.close();
         System.out.println("test done.");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
   
   
   public static void main(String[] args)
   {
      RestartServerTestServer server = new RestartServerTestServer();
      server.setUp();
      server.testBody();
      System.out.println("done.");
   }

   public static class SampleInvocationHandler implements ServerInvocationHandler
   {
      private InvokerCallbackHandler callbackHandler;
      private int secret;
      
      public SampleInvocationHandler(int secret)
      {   
         this.secret = secret;
      }
      
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         return new Integer(secret);
      }
      
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         System.out.println("adding callback listener");
         this.callbackHandler = callbackHandler;
         
         try
         {
            Callback callback = new Callback(new Integer(secret));
            callbackHandler.handleCallback(callback);
         }
         catch(Exception e)
         {
            e.printStackTrace();
         }
      }
      
      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
      }
      
      public void setMBeanServer(MBeanServer server)
      {
      }
      
      public void setInvoker(ServerInvoker invoker)
      {
      }
      
      public InvokerCallbackHandler getCallbackHandler()
      {
         return callbackHandler;
      }
   }
}
