/*
** portmon.h -- Obligatory header file
** Copyright (C) 2002 Nik Reiman <nik@aboleo.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA
*/

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <sys/types.h>
#include <netinet/in.h>
#include <time.h>
#include <sys/time.h>

#define MAXINT 32768
#define STRSMALL 32
#define STRMED 128
#define STRLARGE 512

// flags
int report_flag;
int daemonize_flag;

struct port
{
  int port;
  int is_down;
  time_t downtime;
  struct sockaddr_in addr;
};

// create an array of hosts
struct host_struct
{
  char name[STRMED];
  struct port ports[STRSMALL];
  int num_ports;
}
 *hosts;

// place to hold error messages
char *err_msg;
// place we log crap
char logfile[STRLARGE];
// timeout (seconds)
int timeout;
// verbose mode
int verbose;

// Functions in various files

// portmon.c
char *get_time (time_t cur_time);
int log_write (char *msg);
void version (void);
void portmon_exit (int signal);
char *get_time (time_t cur_time);
void help (void);

// action.c
int err_action(char *hostname, char *err_msg);

// tcp_ping.c
int tcp_ping (struct sockaddr_in addr, int port);
void alarm_signal (int sig);

// icmp_ping.c
int icmp_ping (struct sockaddr_in addr);
int in_cksum (unsigned short *buf, int len);
int wait_icmp (struct sockaddr_in *src);
void ms_to_tv (int ms, struct timeval *tv);
int send_echo (struct sockaddr_in *dest);
int tv_to_ms (struct timeval *tv);

// report.c
int report (int num_hosts, int num_probes, int lag_timeout, char *output_fmt);
int format_output(char *output_fmt, char *out_str, char *hostname, int port, int lag, char status, char *wd_status);

// config.c
int read_config (char *config_name);

// exec_proc.c
int exec_proc(char *command, time_t cur_time, char *hostname, char *err_msg);
