/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept exit syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process dies/exists we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"


char p_do_exit_kretprobe_state = 0;

static struct kretprobe p_do_exit_kretprobe = {
    .kp.symbol_name = "do_exit",
    .handler = p_do_exit_ret,
    .entry_handler = p_do_exit_entry,
    .data_size = sizeof(struct p_do_exit_data),
};


int p_do_exit_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   unsigned long p_flags;

   p_debug_kprobe_log(
          "p_do_exit_entry: comm[%s] Pid:%d",current->comm,current->pid);

//   p_ed_enforce_validation();

   p_tasks_write_lock(&p_flags);
   if (p_remove_task_pid_f(task_pid_nr(current))) {
      ;// DEBUG: p_debug_log(P_LOG_DEBUG, "Can't remove pid %u, name %s", task_pid_nr(current), current->comm);
   }
   p_tasks_write_unlock(&p_flags);

   /* A dump_stack() here will give a stack backtrace */
   return 0;
}


int p_do_exit_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(do_exit)
