/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'search_binary_handler' syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls execve, we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - 18.I.2021:   Replace one 'search_binary_handler' hook with two
 *                 independent one to reduce the race window while
 *                 the process is not being verified
 *  - 28.XII.2020: Replace various execve syscall hooks with one hook
 *                 of the function 'search_binary_handler'
 *  - Created:     18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"


char p_security_bprm_committed_creds_kretprobe_state = 0;

static struct kretprobe p_security_bprm_committed_creds_kretprobe = {
    .kp.symbol_name = "security_bprm_committed_creds",
    .handler = p_security_bprm_committed_creds_ret,
    .entry_handler = NULL,
    .data_size = sizeof(struct p_security_bprm_committed_creds_data),
};


notrace struct inode *p_get_inode_from_task(struct task_struct *p_arg) {

   struct mm_struct *p_mm;
   struct inode *p_inode = NULL;

   if (!p_arg) {
      return NULL;
   }

   /*
    * This function is called from the context of newly created
    * Process which is intercepted by our *probes. This means
    * Process did not take control yet. Before we finish our work
    * Nothing bad should happen in context of parsing mm_struct.
    * For this specific operation (reading pointer to exe_file)
    * It is safe to not use read lock. Process can't die before it
    * is not even taken control.
    * Additionally, we are under IRQ disabled context and it is
    * Not safe to take any mutex/semaphore since we can be forced
    * to sleep.
    * Current implementation works well!
    */
//   down_read(&p_arg->mm->mmap_sem);

   p_mm = p_arg->mm;
   if (p_mm->exe_file) {
      p_inode = p_mm->exe_file->f_inode;
   }

//   up_read(&p_arg->mm->mmap_sem);

   return p_inode;
}

LKRG_DEBUG_TRACE int p_security_bprm_committed_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

//   struct inode *p_inode;
   struct p_ed_process *p_tmp;
   unsigned long p_flags;

/*
   p_inode = p_get_inode_from_task(current);

   p_debug_kprobe_log(
          "p_search_binary_handler_ret: returned value => %ld comm[%s] Pid:%d inode[%ld]",
           p_regs_get_ret(p_regs),current->comm,current->pid,p_inode->i_ino);
*/

   // Update process
   p_tasks_write_lock(&p_flags);
   if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
      // This process is on the ED list - update information!
      p_update_ed_process(p_tmp, current, 1);
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_reset(p_tmp, 40);
#endif
      p_reset_ed_flags(p_tmp);
   }
   p_tasks_write_unlock(&p_flags);

//   p_ed_enforce_validation();

   return 0;
}

GENERATE_INSTALL_FUNC(security_bprm_committed_creds)
