/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - selinux function
 *
 * Notes:
 *  - None
 *
 * Timeline:
 *  - Created: 17.III.2021
 *
 * Author:
 *  - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#include "../../p_lkrg_main.h"

#ifdef P_SELINUX_VERIFY
 #if LINUX_VERSION_CODE >= KERNEL_VERSION(4,17,0)

int p_selinux_state_init(void) {

   P_SYM_INIT(selinux_state)

   p_selinux_state_update();
   return P_LKRG_SUCCESS;

p_sym_error:
   return P_LKRG_GENERAL_ERROR;
}

void p_selinux_state_restore(void) {

   P_SYM(p_selinux_state)->enforcing = p_ed_guard_globals.p_selinux.p_selinux_enforcing;
}


int p_selinux_state_enforcing(void) {

   return P_SYM(p_selinux_state)->enforcing;
}

 #else
int p_selinux_state_init(void) {

   P_SYM_INIT(selinux_enforcing)

   p_selinux_state_update();
   return P_LKRG_SUCCESS;

p_sym_error:
   return P_LKRG_GENERAL_ERROR;
}

void p_selinux_state_restore(void) {

   *P_SYM(p_selinux_enforcing) = p_ed_guard_globals.p_selinux.p_selinux_enforcing;
}

int p_selinux_state_enforcing(void) {

   return *P_SYM(p_selinux_enforcing);
}
 #endif

void p_selinux_state_update(void) {

   p_ed_guard_globals.p_selinux.p_selinux_enforcing = p_selinux_state_enforcing();
}

int p_selinux_state_changed(void) {

   return p_selinux_state_enforcing() != p_ed_guard_globals.p_selinux.p_selinux_enforcing;
}

#endif
