#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1654
#define LARGE_STATE_COUNT 225
#define SYMBOL_COUNT 234
#define ALIAS_COUNT 4
#define TOKEN_COUNT 105
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 124

enum ts_symbol_identifiers {
  anon_sym_LBRACE = 1,
  anon_sym_RBRACE = 2,
  anon_sym_impl = 3,
  anon_sym_of = 4,
  anon_sym_SEMI = 5,
  anon_sym_trait = 6,
  anon_sym_type = 7,
  anon_sym_COLON = 8,
  anon_sym_const = 9,
  anon_sym_EQ = 10,
  anon_sym_BANG = 11,
  anon_sym_POUND = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_mod = 15,
  anon_sym_struct = 16,
  anon_sym_enum = 17,
  anon_sym_COMMA = 18,
  anon_sym_fn = 19,
  anon_sym_DASH_GT = 20,
  anon_sym_implicits = 21,
  anon_sym_let = 22,
  anon_sym_use = 23,
  anon_sym_COLON_COLON = 24,
  anon_sym_as = 25,
  anon_sym_STAR = 26,
  anon_sym_LPAREN = 27,
  anon_sym__ = 28,
  anon_sym_RPAREN = 29,
  anon_sym_u8 = 30,
  anon_sym_i8 = 31,
  anon_sym_u16 = 32,
  anon_sym_i16 = 33,
  anon_sym_u32 = 34,
  anon_sym_i32 = 35,
  anon_sym_u64 = 36,
  anon_sym_i64 = 37,
  anon_sym_u128 = 38,
  anon_sym_i128 = 39,
  anon_sym_usize = 40,
  anon_sym_bool = 41,
  anon_sym_ByteArray = 42,
  anon_sym_felt252 = 43,
  anon_sym_LT = 44,
  anon_sym_GT = 45,
  anon_sym_PLUS = 46,
  anon_sym_DASH = 47,
  anon_sym_SLASH = 48,
  anon_sym_PERCENT = 49,
  anon_sym_CARET = 50,
  anon_sym_TILDE = 51,
  anon_sym_AMP = 52,
  anon_sym_PIPE = 53,
  anon_sym_AMP_AMP = 54,
  anon_sym_PIPE_PIPE = 55,
  anon_sym_LT_LT = 56,
  anon_sym_GT_GT = 57,
  anon_sym_PLUS_EQ = 58,
  anon_sym_DASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_CARET_EQ = 63,
  anon_sym_AMP_EQ = 64,
  anon_sym_PIPE_EQ = 65,
  anon_sym_EQ_EQ = 66,
  anon_sym_BANG_EQ = 67,
  anon_sym_GT_EQ = 68,
  anon_sym_LT_EQ = 69,
  anon_sym_AT = 70,
  anon_sym_DOT_DOT = 71,
  anon_sym_DOT = 72,
  anon_sym_EQ_GT = 73,
  anon_sym_QMARK = 74,
  anon_sym_break = 75,
  anon_sym_continue = 76,
  anon_sym_default = 77,
  anon_sym_if = 78,
  anon_sym_extern = 79,
  anon_sym_nopanic = 80,
  anon_sym_loop = 81,
  anon_sym_match = 82,
  anon_sym_pub = 83,
  anon_sym_return = 84,
  anon_sym_static = 85,
  anon_sym_while = 86,
  anon_sym_for = 87,
  sym_numeric_literal = 88,
  aux_sym_string_literal_token1 = 89,
  aux_sym_string_literal_token2 = 90,
  anon_sym_DQUOTE = 91,
  sym_shortstring_literal = 92,
  anon_sym_true = 93,
  anon_sym_false = 94,
  anon_sym_DOLLAR = 95,
  anon_sym_LT2 = 96,
  anon_sym_else = 97,
  anon_sym_in = 98,
  anon_sym_ref = 99,
  sym_identifier = 100,
  sym_mutable_specifier = 101,
  sym_super = 102,
  sym_crate = 103,
  sym_line_comment = 104,
  sym_source_file = 105,
  sym__statement = 106,
  sym_declaration_list = 107,
  sym_impl_item = 108,
  sym_trait_item = 109,
  sym_associated_type = 110,
  sym_associated_impl = 111,
  sym_const_item = 112,
  sym_macro_invocation = 113,
  sym_empty_statement = 114,
  sym_attribute_item = 115,
  sym_inner_attribute_item = 116,
  sym_attribute = 117,
  sym_mod_item = 118,
  sym_struct_item = 119,
  sym_enum_item = 120,
  sym_enum_variant_list = 121,
  sym_enum_variant = 122,
  sym_field_declaration_list = 123,
  sym_field_declaration = 124,
  sym_type_item = 125,
  sym_extern_type = 126,
  sym_external_function_item = 127,
  sym_function_item = 128,
  sym_function_signature_item = 129,
  sym_function = 130,
  sym_let_declaration = 131,
  sym_use_declaration = 132,
  sym__use_clause = 133,
  sym_scoped_use_list = 134,
  sym_use_list = 135,
  sym_use_as_clause = 136,
  sym_use_wildcard = 137,
  sym_parameters = 138,
  sym_parameter = 139,
  sym__type = 140,
  sym_type_parameters = 141,
  sym_const_parameter = 142,
  sym_constrained_type_parameter = 143,
  sym_generic_type = 144,
  sym_generic_type_with_turbofish = 145,
  sym_array_type = 146,
  sym_delim_token_tree = 147,
  sym__delim_tokens = 148,
  sym__pattern = 149,
  sym_tuple_pattern = 150,
  sym_slice_pattern = 151,
  sym_struct_pattern = 152,
  sym_field_pattern = 153,
  sym_field_initializer_list = 154,
  sym_shorthand_field_initializer = 155,
  sym_field_initializer = 156,
  sym_base_field_initializer = 157,
  sym_mut_pattern = 158,
  sym_or_pattern = 159,
  sym__literal = 160,
  sym__literal_pattern = 161,
  sym_negative_literal = 162,
  sym_string_literal = 163,
  sym_boolean_literal = 164,
  sym__non_delim_token = 165,
  sym_scoped_identifier = 166,
  sym_scoped_type_identifier_in_expression_position = 167,
  sym_scoped_type_identifier = 168,
  sym_tuple_type = 169,
  sym_unit_type = 170,
  sym_type_arguments = 171,
  sym_expression_statement = 172,
  sym_expression = 173,
  sym_generic_function = 174,
  sym_tuple_expression = 175,
  sym_return_expression = 176,
  sym_struct_expression = 177,
  sym_assignment_expression = 178,
  sym_break_expression = 179,
  sym_continue_expression = 180,
  sym_index_expression = 181,
  sym_array_expression = 182,
  sym_parenthesized_expression = 183,
  sym_unit_expression = 184,
  sym_compound_assignment_expr = 185,
  sym__expression_ending_with_block = 186,
  sym_unary_expression = 187,
  sym_try_expression = 188,
  sym_field_expression = 189,
  sym_block = 190,
  sym_if_expression = 191,
  sym__condition = 192,
  sym_let_condition = 193,
  sym_else_clause = 194,
  sym_match_expression = 195,
  sym_match_block = 196,
  sym_match_arm = 197,
  sym_last_match_arm = 198,
  sym_tuple_enum_pattern = 199,
  sym_match_pattern = 200,
  sym_while_expression = 201,
  sym_for_expression = 202,
  sym_loop_expression = 203,
  sym_binary_expression = 204,
  sym_snapshot_type = 205,
  sym_call_expression = 206,
  sym_arguments = 207,
  sym_named_argument = 208,
  sym_reference_expression = 209,
  sym_visibility_modifier = 210,
  sym_extern = 211,
  sym_nopanic = 212,
  sym_ref_specifier = 213,
  aux_sym_source_file_repeat1 = 214,
  aux_sym_declaration_list_repeat1 = 215,
  aux_sym_enum_variant_list_repeat1 = 216,
  aux_sym_enum_variant_list_repeat2 = 217,
  aux_sym_field_declaration_list_repeat1 = 218,
  aux_sym_function_repeat1 = 219,
  aux_sym_use_list_repeat1 = 220,
  aux_sym_parameters_repeat1 = 221,
  aux_sym_type_parameters_repeat1 = 222,
  aux_sym_delim_token_tree_repeat1 = 223,
  aux_sym__non_special_token_repeat1 = 224,
  aux_sym_tuple_pattern_repeat1 = 225,
  aux_sym_struct_pattern_repeat1 = 226,
  aux_sym_field_initializer_list_repeat1 = 227,
  aux_sym_type_arguments_repeat1 = 228,
  aux_sym_tuple_expression_repeat1 = 229,
  aux_sym_array_expression_repeat1 = 230,
  aux_sym_match_block_repeat1 = 231,
  aux_sym_match_arm_repeat1 = 232,
  aux_sym_arguments_repeat1 = 233,
  alias_sym_field_identifier = 234,
  alias_sym_primitive_type = 235,
  alias_sym_shorthand_field_identifier = 236,
  alias_sym_type_identifier = 237,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_impl] = "impl",
  [anon_sym_of] = "of",
  [anon_sym_SEMI] = ";",
  [anon_sym_trait] = "trait",
  [anon_sym_type] = "type",
  [anon_sym_COLON] = ":",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_mod] = "mod",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_COMMA] = ",",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_implicits] = "implicits",
  [anon_sym_let] = "let",
  [anon_sym_use] = "use",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_LPAREN] = "(",
  [anon_sym__] = "_",
  [anon_sym_RPAREN] = ")",
  [anon_sym_u8] = "identifier",
  [anon_sym_i8] = "identifier",
  [anon_sym_u16] = "identifier",
  [anon_sym_i16] = "identifier",
  [anon_sym_u32] = "identifier",
  [anon_sym_i32] = "identifier",
  [anon_sym_u64] = "identifier",
  [anon_sym_i64] = "identifier",
  [anon_sym_u128] = "identifier",
  [anon_sym_i128] = "identifier",
  [anon_sym_usize] = "identifier",
  [anon_sym_bool] = "identifier",
  [anon_sym_ByteArray] = "identifier",
  [anon_sym_felt252] = "identifier",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_AT] = "@",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK] = "\?",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_default] = "default",
  [anon_sym_if] = "if",
  [anon_sym_extern] = "extern",
  [anon_sym_nopanic] = "nopanic",
  [anon_sym_loop] = "loop",
  [anon_sym_match] = "match",
  [anon_sym_pub] = "pub",
  [anon_sym_return] = "return",
  [anon_sym_static] = "static",
  [anon_sym_while] = "while",
  [anon_sym_for] = "for",
  [sym_numeric_literal] = "numeric_literal",
  [aux_sym_string_literal_token1] = "\"",
  [aux_sym_string_literal_token2] = "string_literal_token2",
  [anon_sym_DQUOTE] = "\"",
  [sym_shortstring_literal] = "shortstring_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LT2] = "<",
  [anon_sym_else] = "else",
  [anon_sym_in] = "in",
  [anon_sym_ref] = "ref",
  [sym_identifier] = "identifier",
  [sym_mutable_specifier] = "mutable_specifier",
  [sym_super] = "super",
  [sym_crate] = "crate",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym_declaration_list] = "declaration_list",
  [sym_impl_item] = "impl_item",
  [sym_trait_item] = "trait_item",
  [sym_associated_type] = "associated_type",
  [sym_associated_impl] = "associated_impl",
  [sym_const_item] = "const_item",
  [sym_macro_invocation] = "macro_invocation",
  [sym_empty_statement] = "empty_statement",
  [sym_attribute_item] = "attribute_item",
  [sym_inner_attribute_item] = "inner_attribute_item",
  [sym_attribute] = "attribute",
  [sym_mod_item] = "mod_item",
  [sym_struct_item] = "struct_item",
  [sym_enum_item] = "enum_item",
  [sym_enum_variant_list] = "enum_variant_list",
  [sym_enum_variant] = "enum_variant",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_type_item] = "type_item",
  [sym_extern_type] = "extern_type",
  [sym_external_function_item] = "external_function_item",
  [sym_function_item] = "function_item",
  [sym_function_signature_item] = "function_signature_item",
  [sym_function] = "function",
  [sym_let_declaration] = "let_declaration",
  [sym_use_declaration] = "use_declaration",
  [sym__use_clause] = "_use_clause",
  [sym_scoped_use_list] = "scoped_use_list",
  [sym_use_list] = "use_list",
  [sym_use_as_clause] = "use_as_clause",
  [sym_use_wildcard] = "use_wildcard",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__type] = "_type",
  [sym_type_parameters] = "type_parameters",
  [sym_const_parameter] = "const_parameter",
  [sym_constrained_type_parameter] = "constrained_type_parameter",
  [sym_generic_type] = "generic_type",
  [sym_generic_type_with_turbofish] = "generic_type_with_turbofish",
  [sym_array_type] = "array_type",
  [sym_delim_token_tree] = "token_tree",
  [sym__delim_tokens] = "_delim_tokens",
  [sym__pattern] = "_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_slice_pattern] = "slice_pattern",
  [sym_struct_pattern] = "struct_pattern",
  [sym_field_pattern] = "field_pattern",
  [sym_field_initializer_list] = "field_initializer_list",
  [sym_shorthand_field_initializer] = "shorthand_field_initializer",
  [sym_field_initializer] = "field_initializer",
  [sym_base_field_initializer] = "base_field_initializer",
  [sym_mut_pattern] = "mut_pattern",
  [sym_or_pattern] = "or_pattern",
  [sym__literal] = "_literal",
  [sym__literal_pattern] = "_literal_pattern",
  [sym_negative_literal] = "negative_literal",
  [sym_string_literal] = "string_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__non_delim_token] = "_non_delim_token",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_scoped_type_identifier_in_expression_position] = "scoped_type_identifier",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_tuple_type] = "tuple_type",
  [sym_unit_type] = "unit_type",
  [sym_type_arguments] = "type_arguments",
  [sym_expression_statement] = "expression_statement",
  [sym_expression] = "expression",
  [sym_generic_function] = "generic_function",
  [sym_tuple_expression] = "tuple_expression",
  [sym_return_expression] = "return_expression",
  [sym_struct_expression] = "struct_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_break_expression] = "break_expression",
  [sym_continue_expression] = "continue_expression",
  [sym_index_expression] = "index_expression",
  [sym_array_expression] = "array_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_unit_expression] = "unit_expression",
  [sym_compound_assignment_expr] = "compound_assignment_expr",
  [sym__expression_ending_with_block] = "_expression_ending_with_block",
  [sym_unary_expression] = "unary_expression",
  [sym_try_expression] = "try_expression",
  [sym_field_expression] = "field_expression",
  [sym_block] = "block",
  [sym_if_expression] = "if_expression",
  [sym__condition] = "_condition",
  [sym_let_condition] = "let_condition",
  [sym_else_clause] = "else_clause",
  [sym_match_expression] = "match_expression",
  [sym_match_block] = "match_block",
  [sym_match_arm] = "match_arm",
  [sym_last_match_arm] = "match_arm",
  [sym_tuple_enum_pattern] = "tuple_enum_pattern",
  [sym_match_pattern] = "match_pattern",
  [sym_while_expression] = "while_expression",
  [sym_for_expression] = "for_expression",
  [sym_loop_expression] = "loop_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_snapshot_type] = "snapshot_type",
  [sym_call_expression] = "call_expression",
  [sym_arguments] = "arguments",
  [sym_named_argument] = "named_argument",
  [sym_reference_expression] = "reference_expression",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_extern] = "extern",
  [sym_nopanic] = "nopanic",
  [sym_ref_specifier] = "ref_specifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_declaration_list_repeat1] = "declaration_list_repeat1",
  [aux_sym_enum_variant_list_repeat1] = "enum_variant_list_repeat1",
  [aux_sym_enum_variant_list_repeat2] = "enum_variant_list_repeat2",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_function_repeat1] = "function_repeat1",
  [aux_sym_use_list_repeat1] = "use_list_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_delim_token_tree_repeat1] = "delim_token_tree_repeat1",
  [aux_sym__non_special_token_repeat1] = "_non_special_token_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym_struct_pattern_repeat1] = "struct_pattern_repeat1",
  [aux_sym_field_initializer_list_repeat1] = "field_initializer_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_array_expression_repeat1] = "array_expression_repeat1",
  [aux_sym_match_block_repeat1] = "match_block_repeat1",
  [aux_sym_match_arm_repeat1] = "match_arm_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_primitive_type] = "primitive_type",
  [alias_sym_shorthand_field_identifier] = "shorthand_field_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_impl] = anon_sym_impl,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_implicits] = anon_sym_implicits,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym__] = anon_sym__,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_u8] = sym_identifier,
  [anon_sym_i8] = sym_identifier,
  [anon_sym_u16] = sym_identifier,
  [anon_sym_i16] = sym_identifier,
  [anon_sym_u32] = sym_identifier,
  [anon_sym_i32] = sym_identifier,
  [anon_sym_u64] = sym_identifier,
  [anon_sym_i64] = sym_identifier,
  [anon_sym_u128] = sym_identifier,
  [anon_sym_i128] = sym_identifier,
  [anon_sym_usize] = sym_identifier,
  [anon_sym_bool] = sym_identifier,
  [anon_sym_ByteArray] = sym_identifier,
  [anon_sym_felt252] = sym_identifier,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_nopanic] = anon_sym_nopanic,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_for] = anon_sym_for,
  [sym_numeric_literal] = sym_numeric_literal,
  [aux_sym_string_literal_token1] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token2] = aux_sym_string_literal_token2,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_shortstring_literal] = sym_shortstring_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_ref] = anon_sym_ref,
  [sym_identifier] = sym_identifier,
  [sym_mutable_specifier] = sym_mutable_specifier,
  [sym_super] = sym_super,
  [sym_crate] = sym_crate,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym_declaration_list] = sym_declaration_list,
  [sym_impl_item] = sym_impl_item,
  [sym_trait_item] = sym_trait_item,
  [sym_associated_type] = sym_associated_type,
  [sym_associated_impl] = sym_associated_impl,
  [sym_const_item] = sym_const_item,
  [sym_macro_invocation] = sym_macro_invocation,
  [sym_empty_statement] = sym_empty_statement,
  [sym_attribute_item] = sym_attribute_item,
  [sym_inner_attribute_item] = sym_inner_attribute_item,
  [sym_attribute] = sym_attribute,
  [sym_mod_item] = sym_mod_item,
  [sym_struct_item] = sym_struct_item,
  [sym_enum_item] = sym_enum_item,
  [sym_enum_variant_list] = sym_enum_variant_list,
  [sym_enum_variant] = sym_enum_variant,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_type_item] = sym_type_item,
  [sym_extern_type] = sym_extern_type,
  [sym_external_function_item] = sym_external_function_item,
  [sym_function_item] = sym_function_item,
  [sym_function_signature_item] = sym_function_signature_item,
  [sym_function] = sym_function,
  [sym_let_declaration] = sym_let_declaration,
  [sym_use_declaration] = sym_use_declaration,
  [sym__use_clause] = sym__use_clause,
  [sym_scoped_use_list] = sym_scoped_use_list,
  [sym_use_list] = sym_use_list,
  [sym_use_as_clause] = sym_use_as_clause,
  [sym_use_wildcard] = sym_use_wildcard,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__type] = sym__type,
  [sym_type_parameters] = sym_type_parameters,
  [sym_const_parameter] = sym_const_parameter,
  [sym_constrained_type_parameter] = sym_constrained_type_parameter,
  [sym_generic_type] = sym_generic_type,
  [sym_generic_type_with_turbofish] = sym_generic_type_with_turbofish,
  [sym_array_type] = sym_array_type,
  [sym_delim_token_tree] = sym_delim_token_tree,
  [sym__delim_tokens] = sym__delim_tokens,
  [sym__pattern] = sym__pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_slice_pattern] = sym_slice_pattern,
  [sym_struct_pattern] = sym_struct_pattern,
  [sym_field_pattern] = sym_field_pattern,
  [sym_field_initializer_list] = sym_field_initializer_list,
  [sym_shorthand_field_initializer] = sym_shorthand_field_initializer,
  [sym_field_initializer] = sym_field_initializer,
  [sym_base_field_initializer] = sym_base_field_initializer,
  [sym_mut_pattern] = sym_mut_pattern,
  [sym_or_pattern] = sym_or_pattern,
  [sym__literal] = sym__literal,
  [sym__literal_pattern] = sym__literal_pattern,
  [sym_negative_literal] = sym_negative_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__non_delim_token] = sym__non_delim_token,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_scoped_type_identifier_in_expression_position] = sym_scoped_type_identifier,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_tuple_type] = sym_tuple_type,
  [sym_unit_type] = sym_unit_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_expression_statement] = sym_expression_statement,
  [sym_expression] = sym_expression,
  [sym_generic_function] = sym_generic_function,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_return_expression] = sym_return_expression,
  [sym_struct_expression] = sym_struct_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_break_expression] = sym_break_expression,
  [sym_continue_expression] = sym_continue_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_unit_expression] = sym_unit_expression,
  [sym_compound_assignment_expr] = sym_compound_assignment_expr,
  [sym__expression_ending_with_block] = sym__expression_ending_with_block,
  [sym_unary_expression] = sym_unary_expression,
  [sym_try_expression] = sym_try_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_block] = sym_block,
  [sym_if_expression] = sym_if_expression,
  [sym__condition] = sym__condition,
  [sym_let_condition] = sym_let_condition,
  [sym_else_clause] = sym_else_clause,
  [sym_match_expression] = sym_match_expression,
  [sym_match_block] = sym_match_block,
  [sym_match_arm] = sym_match_arm,
  [sym_last_match_arm] = sym_match_arm,
  [sym_tuple_enum_pattern] = sym_tuple_enum_pattern,
  [sym_match_pattern] = sym_match_pattern,
  [sym_while_expression] = sym_while_expression,
  [sym_for_expression] = sym_for_expression,
  [sym_loop_expression] = sym_loop_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_snapshot_type] = sym_snapshot_type,
  [sym_call_expression] = sym_call_expression,
  [sym_arguments] = sym_arguments,
  [sym_named_argument] = sym_named_argument,
  [sym_reference_expression] = sym_reference_expression,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_extern] = sym_extern,
  [sym_nopanic] = sym_nopanic,
  [sym_ref_specifier] = sym_ref_specifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_declaration_list_repeat1] = aux_sym_declaration_list_repeat1,
  [aux_sym_enum_variant_list_repeat1] = aux_sym_enum_variant_list_repeat1,
  [aux_sym_enum_variant_list_repeat2] = aux_sym_enum_variant_list_repeat2,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_function_repeat1] = aux_sym_function_repeat1,
  [aux_sym_use_list_repeat1] = aux_sym_use_list_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_delim_token_tree_repeat1] = aux_sym_delim_token_tree_repeat1,
  [aux_sym__non_special_token_repeat1] = aux_sym__non_special_token_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym_struct_pattern_repeat1] = aux_sym_struct_pattern_repeat1,
  [aux_sym_field_initializer_list_repeat1] = aux_sym_field_initializer_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_array_expression_repeat1] = aux_sym_array_expression_repeat1,
  [aux_sym_match_block_repeat1] = aux_sym_match_block_repeat1,
  [aux_sym_match_arm_repeat1] = aux_sym_match_arm_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_primitive_type] = alias_sym_primitive_type,
  [alias_sym_shorthand_field_identifier] = alias_sym_shorthand_field_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_impl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implicits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_usize] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ByteArray] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_felt252] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nopanic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [sym_numeric_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_shortstring_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_crate] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_impl_item] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_item] = {
    .visible = true,
    .named = true,
  },
  [sym_associated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_associated_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_const_item] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_item] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_attribute_item] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_mod_item] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant_list] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_item] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_let_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_use_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__use_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_scoped_use_list] = {
    .visible = true,
    .named = true,
  },
  [sym_use_list] = {
    .visible = true,
    .named = true,
  },
  [sym_use_as_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_use_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_const_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type_with_turbofish] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_delim_token_tree] = {
    .visible = true,
    .named = true,
  },
  [sym__delim_tokens] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_shorthand_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_base_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_mut_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__literal_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_negative_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__non_delim_token] = {
    .visible = false,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier_in_expression_position] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_generic_function] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_break_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unit_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assignment_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_ending_with_block] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__condition] = {
    .visible = false,
    .named = true,
  },
  [sym_let_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_last_match_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_enum_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_match_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_while_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_snapshot_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_extern] = {
    .visible = true,
    .named = true,
  },
  [sym_nopanic] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_variant_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_delim_token_tree_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__non_special_token_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_arm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_bound = 6,
  field_condition = 7,
  field_consequence = 8,
  field_element = 9,
  field_field = 10,
  field_function = 11,
  field_implicit_arguments = 12,
  field_left = 13,
  field_length = 14,
  field_list = 15,
  field_macro = 16,
  field_name = 17,
  field_operator = 18,
  field_parameters = 19,
  field_path = 20,
  field_pattern = 21,
  field_return_type = 22,
  field_right = 23,
  field_type = 24,
  field_type_arguments = 25,
  field_type_parameters = 26,
  field_value = 27,
  field_variant = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_bound] = "bound",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_field] = "field",
  [field_function] = "function",
  [field_implicit_arguments] = "implicit_arguments",
  [field_left] = "left",
  [field_length] = "length",
  [field_list] = "list",
  [field_macro] = "macro",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_variant] = "variant",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 11, .length = 2},
  [16] = {.index = 14, .length = 1},
  [17] = {.index = 15, .length = 1},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 18, .length = 1},
  [21] = {.index = 16, .length = 2},
  [22] = {.index = 16, .length = 2},
  [23] = {.index = 19, .length = 2},
  [24] = {.index = 21, .length = 2},
  [25] = {.index = 23, .length = 2},
  [26] = {.index = 25, .length = 2},
  [27] = {.index = 27, .length = 1},
  [28] = {.index = 18, .length = 1},
  [29] = {.index = 19, .length = 2},
  [30] = {.index = 28, .length = 2},
  [31] = {.index = 16, .length = 2},
  [32] = {.index = 16, .length = 2},
  [33] = {.index = 19, .length = 2},
  [34] = {.index = 30, .length = 2},
  [35] = {.index = 32, .length = 3},
  [36] = {.index = 35, .length = 2},
  [37] = {.index = 35, .length = 2},
  [38] = {.index = 37, .length = 1},
  [41] = {.index = 38, .length = 2},
  [42] = {.index = 40, .length = 3},
  [43] = {.index = 43, .length = 1},
  [44] = {.index = 43, .length = 1},
  [45] = {.index = 44, .length = 1},
  [46] = {.index = 45, .length = 3},
  [47] = {.index = 48, .length = 3},
  [48] = {.index = 51, .length = 1},
  [49] = {.index = 52, .length = 1},
  [50] = {.index = 51, .length = 1},
  [51] = {.index = 53, .length = 1},
  [52] = {.index = 51, .length = 1},
  [53] = {.index = 54, .length = 2},
  [54] = {.index = 56, .length = 2},
  [55] = {.index = 54, .length = 2},
  [56] = {.index = 56, .length = 2},
  [57] = {.index = 58, .length = 3},
  [58] = {.index = 61, .length = 1},
  [59] = {.index = 62, .length = 2},
  [60] = {.index = 61, .length = 1},
  [61] = {.index = 62, .length = 2},
  [62] = {.index = 64, .length = 1},
  [63] = {.index = 65, .length = 1},
  [64] = {.index = 66, .length = 1},
  [65] = {.index = 67, .length = 2},
  [67] = {.index = 67, .length = 2},
  [68] = {.index = 27, .length = 1},
  [69] = {.index = 69, .length = 1},
  [70] = {.index = 70, .length = 1},
  [71] = {.index = 71, .length = 3},
  [72] = {.index = 74, .length = 4},
  [73] = {.index = 78, .length = 4},
  [74] = {.index = 0, .length = 1},
  [75] = {.index = 82, .length = 2},
  [76] = {.index = 84, .length = 2},
  [78] = {.index = 86, .length = 3},
  [79] = {.index = 89, .length = 2},
  [80] = {.index = 89, .length = 2},
  [81] = {.index = 91, .length = 2},
  [82] = {.index = 93, .length = 3},
  [83] = {.index = 96, .length = 1},
  [84] = {.index = 97, .length = 1},
  [86] = {.index = 98, .length = 1},
  [87] = {.index = 99, .length = 2},
  [88] = {.index = 101, .length = 3},
  [89] = {.index = 104, .length = 1},
  [90] = {.index = 105, .length = 2},
  [91] = {.index = 107, .length = 2},
  [92] = {.index = 109, .length = 4},
  [93] = {.index = 113, .length = 5},
  [94] = {.index = 118, .length = 4},
  [95] = {.index = 122, .length = 5},
  [96] = {.index = 127, .length = 2},
  [97] = {.index = 129, .length = 2},
  [98] = {.index = 131, .length = 2},
  [99] = {.index = 133, .length = 1},
  [100] = {.index = 134, .length = 2},
  [101] = {.index = 136, .length = 2},
  [102] = {.index = 136, .length = 2},
  [103] = {.index = 138, .length = 1},
  [104] = {.index = 139, .length = 2},
  [105] = {.index = 139, .length = 2},
  [106] = {.index = 141, .length = 2},
  [107] = {.index = 143, .length = 4},
  [108] = {.index = 147, .length = 3},
  [109] = {.index = 67, .length = 2},
  [110] = {.index = 150, .length = 5},
  [111] = {.index = 155, .length = 5},
  [112] = {.index = 160, .length = 6},
  [113] = {.index = 166, .length = 2},
  [114] = {.index = 168, .length = 3},
  [115] = {.index = 171, .length = 1},
  [116] = {.index = 172, .length = 2},
  [117] = {.index = 174, .length = 3},
  [118] = {.index = 177, .length = 2},
  [119] = {.index = 179, .length = 6},
  [120] = {.index = 185, .length = 6},
  [121] = {.index = 191, .length = 3},
  [122] = {.index = 194, .length = 3},
  [123] = {.index = 197, .length = 7},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_body, 1},
  [2] =
    {field_value, 1},
  [3] =
    {field_body, 1},
    {field_name, 0},
  [5] =
    {field_arguments, 1},
    {field_function, 0},
  [7] =
    {field_body, 2},
    {field_name, 1},
  [9] =
    {field_name, 1},
    {field_parameters, 2},
  [11] =
    {field_type, 0},
    {field_type_arguments, 1},
  [13] =
    {field_pattern, 1},
  [14] =
    {field_list, 1},
  [15] =
    {field_argument, 1},
  [16] =
    {field_name, 2},
    {field_path, 0},
  [18] =
    {field_macro, 0},
  [19] =
    {field_type, 0},
    {field_type_arguments, 2},
  [21] =
    {field_condition, 1},
    {field_consequence, 2},
  [23] =
    {field_body, 2},
    {field_value, 1},
  [25] =
    {field_body, 2},
    {field_condition, 1},
  [27] =
    {field_value, 2},
  [28] =
    {field_function, 0},
    {field_type_arguments, 2},
  [30] =
    {field_left, 0},
    {field_right, 2},
  [32] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [35] =
    {field_field, 2},
    {field_value, 0},
  [37] =
    {field_body, 2},
  [38] =
    {field_name, 1},
    {field_type_parameters, 2},
  [40] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [43] =
    {field_arguments, 1},
  [44] =
    {field_variant, 0},
  [45] =
    {field_implicit_arguments, 3},
    {field_name, 1},
    {field_parameters, 2},
  [48] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [51] =
    {field_type, 0},
  [52] =
    {field_name, 0},
  [53] =
    {field_pattern, 2},
  [54] =
    {field_list, 2},
    {field_path, 0},
  [56] =
    {field_alias, 2},
    {field_path, 0},
  [58] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [61] =
    {field_name, 2},
  [62] =
    {field_body, 3},
    {field_name, 2},
  [64] =
    {field_argument, 2},
  [65] =
    {field_type, 1},
  [66] =
    {field_body, 4},
  [67] =
    {field_name, 1},
    {field_type, 3},
  [69] =
    {field_length, 3},
  [70] =
    {field_variant, 1},
  [71] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [74] =
    {field_implicit_arguments, 3},
    {field_implicit_arguments, 4},
    {field_name, 1},
    {field_parameters, 2},
  [78] =
    {field_implicit_arguments, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [82] =
    {field_pattern, 1},
    {field_type, 3},
  [84] =
    {field_pattern, 1},
    {field_value, 3},
  [86] =
    {field_body, 4},
    {field_pattern, 1},
    {field_value, 3},
  [89] =
    {field_field, 0},
    {field_value, 2},
  [91] =
    {field_name, 2},
    {field_type_parameters, 3},
  [93] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [96] =
    {field_name, 3},
  [97] =
    {field_element, 1},
  [98] =
    {field_type_parameters, 2},
  [99] =
    {field_body, 5},
    {field_type_parameters, 2},
  [101] =
    {field_name, 1},
    {field_type, 4},
    {field_type_parameters, 2},
  [104] =
    {field_length, 4},
  [105] =
    {field_name, 0},
    {field_type, 2},
  [107] =
    {field_pattern, 0},
    {field_type, 2},
  [109] =
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [113] =
    {field_implicit_arguments, 3},
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 2},
  [118] =
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [122] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [127] =
    {field_name, 0},
    {field_pattern, 2},
  [129] =
    {field_pattern, 2},
    {field_type, 4},
  [131] =
    {field_pattern, 2},
    {field_value, 4},
  [133] =
    {field_condition, 2},
  [134] =
    {field_pattern, 0},
    {field_value, 2},
  [136] =
    {field_field, 1},
    {field_value, 3},
  [138] =
    {field_body, 5},
  [139] =
    {field_name, 2},
    {field_type, 4},
  [141] =
    {field_name, 3},
    {field_type_parameters, 4},
  [143] =
    {field_bound, 3},
    {field_left, 0},
    {field_left, 1},
    {field_left, 2},
  [147] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 5},
  [150] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [155] =
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [160] =
    {field_implicit_arguments, 4},
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [166] =
    {field_name, 1},
    {field_pattern, 3},
  [168] =
    {field_pattern, 1},
    {field_type, 3},
    {field_value, 5},
  [171] =
    {field_type_parameters, 3},
  [172] =
    {field_body, 6},
    {field_type_parameters, 3},
  [174] =
    {field_name, 2},
    {field_type, 5},
    {field_type_parameters, 3},
  [177] =
    {field_element, 1},
    {field_length, 3},
  [179] =
    {field_implicit_arguments, 5},
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [185] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [191] =
    {field_pattern, 2},
    {field_type, 4},
    {field_value, 6},
  [194] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 6},
  [197] =
    {field_implicit_arguments, 6},
    {field_implicit_arguments, 7},
    {field_implicit_arguments, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [3] = {
    [1] = alias_sym_type_identifier,
  },
  [6] = {
    [0] = alias_sym_type_identifier,
  },
  [9] = {
    [1] = alias_sym_type_identifier,
  },
  [12] = {
    [0] = sym_identifier,
  },
  [13] = {
    [0] = alias_sym_type_identifier,
  },
  [19] = {
    [2] = alias_sym_type_identifier,
  },
  [20] = {
    [0] = sym_identifier,
  },
  [21] = {
    [0] = sym_identifier,
  },
  [22] = {
    [0] = sym_identifier,
    [2] = alias_sym_type_identifier,
  },
  [23] = {
    [0] = sym_identifier,
  },
  [29] = {
    [0] = alias_sym_type_identifier,
  },
  [31] = {
    [0] = sym_generic_type,
  },
  [32] = {
    [0] = sym_generic_type,
    [2] = alias_sym_type_identifier,
  },
  [37] = {
    [2] = alias_sym_field_identifier,
  },
  [39] = {
    [0] = alias_sym_primitive_type,
  },
  [40] = {
    [0] = alias_sym_type_identifier,
  },
  [41] = {
    [1] = alias_sym_type_identifier,
  },
  [42] = {
    [1] = alias_sym_type_identifier,
  },
  [44] = {
    [0] = sym_identifier,
  },
  [48] = {
    [0] = alias_sym_type_identifier,
  },
  [49] = {
    [0] = alias_sym_shorthand_field_identifier,
  },
  [52] = {
    [0] = sym_generic_type,
  },
  [55] = {
    [0] = sym_identifier,
  },
  [56] = {
    [0] = sym_identifier,
  },
  [58] = {
    [2] = alias_sym_type_identifier,
  },
  [59] = {
    [2] = alias_sym_type_identifier,
  },
  [65] = {
    [1] = alias_sym_type_identifier,
  },
  [66] = {
    [1] = alias_sym_type_identifier,
  },
  [68] = {
    [0] = sym_identifier,
  },
  [74] = {
    [1] = alias_sym_shorthand_field_identifier,
  },
  [77] = {
    [3] = sym_identifier,
  },
  [80] = {
    [0] = alias_sym_field_identifier,
  },
  [81] = {
    [2] = alias_sym_type_identifier,
  },
  [82] = {
    [2] = alias_sym_type_identifier,
  },
  [83] = {
    [3] = alias_sym_type_identifier,
  },
  [85] = {
    [2] = alias_sym_type_identifier,
  },
  [88] = {
    [1] = alias_sym_type_identifier,
  },
  [90] = {
    [0] = alias_sym_field_identifier,
  },
  [96] = {
    [0] = alias_sym_field_identifier,
  },
  [102] = {
    [1] = alias_sym_field_identifier,
  },
  [104] = {
    [2] = alias_sym_type_identifier,
  },
  [106] = {
    [3] = alias_sym_type_identifier,
  },
  [107] = {
    [1] = alias_sym_type_identifier,
  },
  [109] = {
    [1] = alias_sym_field_identifier,
  },
  [113] = {
    [1] = alias_sym_field_identifier,
  },
  [117] = {
    [2] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_generic_type_with_turbofish, 2,
    sym_generic_type_with_turbofish,
    sym_generic_type,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 5,
  [7] = 5,
  [8] = 2,
  [9] = 5,
  [10] = 2,
  [11] = 11,
  [12] = 12,
  [13] = 5,
  [14] = 2,
  [15] = 5,
  [16] = 12,
  [17] = 5,
  [18] = 2,
  [19] = 5,
  [20] = 2,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 24,
  [26] = 26,
  [27] = 27,
  [28] = 27,
  [29] = 29,
  [30] = 30,
  [31] = 26,
  [32] = 29,
  [33] = 26,
  [34] = 27,
  [35] = 30,
  [36] = 36,
  [37] = 24,
  [38] = 36,
  [39] = 30,
  [40] = 26,
  [41] = 29,
  [42] = 27,
  [43] = 24,
  [44] = 36,
  [45] = 30,
  [46] = 36,
  [47] = 24,
  [48] = 36,
  [49] = 30,
  [50] = 26,
  [51] = 27,
  [52] = 29,
  [53] = 29,
  [54] = 21,
  [55] = 22,
  [56] = 22,
  [57] = 21,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 63,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 67,
  [84] = 84,
  [85] = 75,
  [86] = 76,
  [87] = 81,
  [88] = 88,
  [89] = 88,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 93,
  [95] = 95,
  [96] = 92,
  [97] = 91,
  [98] = 98,
  [99] = 99,
  [100] = 99,
  [101] = 101,
  [102] = 95,
  [103] = 103,
  [104] = 104,
  [105] = 101,
  [106] = 103,
  [107] = 107,
  [108] = 107,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 113,
  [114] = 111,
  [115] = 115,
  [116] = 115,
  [117] = 109,
  [118] = 113,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 119,
  [123] = 123,
  [124] = 121,
  [125] = 123,
  [126] = 126,
  [127] = 121,
  [128] = 121,
  [129] = 129,
  [130] = 123,
  [131] = 131,
  [132] = 131,
  [133] = 133,
  [134] = 133,
  [135] = 135,
  [136] = 136,
  [137] = 135,
  [138] = 138,
  [139] = 138,
  [140] = 140,
  [141] = 140,
  [142] = 140,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 147,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 143,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 148,
  [166] = 166,
  [167] = 167,
  [168] = 163,
  [169] = 145,
  [170] = 170,
  [171] = 171,
  [172] = 153,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 151,
  [177] = 177,
  [178] = 154,
  [179] = 163,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 152,
  [184] = 184,
  [185] = 184,
  [186] = 186,
  [187] = 187,
  [188] = 151,
  [189] = 155,
  [190] = 157,
  [191] = 149,
  [192] = 167,
  [193] = 193,
  [194] = 180,
  [195] = 147,
  [196] = 146,
  [197] = 145,
  [198] = 167,
  [199] = 158,
  [200] = 159,
  [201] = 173,
  [202] = 180,
  [203] = 154,
  [204] = 181,
  [205] = 181,
  [206] = 206,
  [207] = 206,
  [208] = 155,
  [209] = 157,
  [210] = 210,
  [211] = 211,
  [212] = 162,
  [213] = 158,
  [214] = 161,
  [215] = 152,
  [216] = 166,
  [217] = 159,
  [218] = 218,
  [219] = 143,
  [220] = 164,
  [221] = 162,
  [222] = 146,
  [223] = 223,
  [224] = 223,
  [225] = 77,
  [226] = 63,
  [227] = 67,
  [228] = 76,
  [229] = 81,
  [230] = 71,
  [231] = 75,
  [232] = 232,
  [233] = 232,
  [234] = 81,
  [235] = 235,
  [236] = 75,
  [237] = 237,
  [238] = 76,
  [239] = 235,
  [240] = 240,
  [241] = 84,
  [242] = 75,
  [243] = 81,
  [244] = 76,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 82,
  [255] = 80,
  [256] = 256,
  [257] = 70,
  [258] = 72,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 69,
  [264] = 79,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 68,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 74,
  [295] = 295,
  [296] = 296,
  [297] = 78,
  [298] = 76,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 81,
  [305] = 75,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 344,
  [347] = 344,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 348,
  [352] = 348,
  [353] = 349,
  [354] = 349,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 358,
  [362] = 360,
  [363] = 363,
  [364] = 363,
  [365] = 359,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 367,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 366,
  [377] = 374,
  [378] = 372,
  [379] = 370,
  [380] = 369,
  [381] = 375,
  [382] = 368,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 385,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 385,
  [395] = 384,
  [396] = 393,
  [397] = 386,
  [398] = 398,
  [399] = 388,
  [400] = 400,
  [401] = 391,
  [402] = 400,
  [403] = 403,
  [404] = 404,
  [405] = 403,
  [406] = 404,
  [407] = 404,
  [408] = 403,
  [409] = 327,
  [410] = 410,
  [411] = 410,
  [412] = 410,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 84,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 75,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 76,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 81,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 60,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 64,
  [494] = 65,
  [495] = 495,
  [496] = 290,
  [497] = 251,
  [498] = 327,
  [499] = 499,
  [500] = 308,
  [501] = 309,
  [502] = 252,
  [503] = 313,
  [504] = 248,
  [505] = 334,
  [506] = 333,
  [507] = 331,
  [508] = 270,
  [509] = 289,
  [510] = 271,
  [511] = 273,
  [512] = 274,
  [513] = 253,
  [514] = 262,
  [515] = 420,
  [516] = 259,
  [517] = 311,
  [518] = 340,
  [519] = 312,
  [520] = 249,
  [521] = 323,
  [522] = 324,
  [523] = 329,
  [524] = 337,
  [525] = 338,
  [526] = 299,
  [527] = 306,
  [528] = 275,
  [529] = 332,
  [530] = 318,
  [531] = 287,
  [532] = 277,
  [533] = 315,
  [534] = 272,
  [535] = 261,
  [536] = 317,
  [537] = 281,
  [538] = 307,
  [539] = 303,
  [540] = 330,
  [541] = 302,
  [542] = 542,
  [543] = 336,
  [544] = 542,
  [545] = 300,
  [546] = 278,
  [547] = 342,
  [548] = 301,
  [549] = 269,
  [550] = 310,
  [551] = 499,
  [552] = 335,
  [553] = 296,
  [554] = 295,
  [555] = 293,
  [556] = 292,
  [557] = 322,
  [558] = 321,
  [559] = 326,
  [560] = 328,
  [561] = 325,
  [562] = 341,
  [563] = 319,
  [564] = 291,
  [565] = 314,
  [566] = 285,
  [567] = 283,
  [568] = 250,
  [569] = 288,
  [570] = 256,
  [571] = 265,
  [572] = 266,
  [573] = 267,
  [574] = 284,
  [575] = 280,
  [576] = 268,
  [577] = 282,
  [578] = 578,
  [579] = 279,
  [580] = 276,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 426,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 420,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 427,
  [594] = 425,
  [595] = 595,
  [596] = 596,
  [597] = 587,
  [598] = 591,
  [599] = 424,
  [600] = 592,
  [601] = 601,
  [602] = 442,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 608,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 610,
  [616] = 616,
  [617] = 612,
  [618] = 604,
  [619] = 619,
  [620] = 610,
  [621] = 621,
  [622] = 622,
  [623] = 604,
  [624] = 624,
  [625] = 609,
  [626] = 610,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 416,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 327,
  [639] = 639,
  [640] = 640,
  [641] = 610,
  [642] = 604,
  [643] = 422,
  [644] = 613,
  [645] = 415,
  [646] = 646,
  [647] = 624,
  [648] = 640,
  [649] = 649,
  [650] = 603,
  [651] = 636,
  [652] = 652,
  [653] = 653,
  [654] = 604,
  [655] = 628,
  [656] = 652,
  [657] = 610,
  [658] = 604,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 610,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 653,
  [667] = 616,
  [668] = 433,
  [669] = 616,
  [670] = 670,
  [671] = 671,
  [672] = 418,
  [673] = 417,
  [674] = 674,
  [675] = 425,
  [676] = 607,
  [677] = 677,
  [678] = 619,
  [679] = 679,
  [680] = 419,
  [681] = 604,
  [682] = 441,
  [683] = 683,
  [684] = 677,
  [685] = 622,
  [686] = 424,
  [687] = 687,
  [688] = 610,
  [689] = 621,
  [690] = 614,
  [691] = 687,
  [692] = 692,
  [693] = 434,
  [694] = 604,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 635,
  [700] = 426,
  [701] = 434,
  [702] = 607,
  [703] = 605,
  [704] = 442,
  [705] = 421,
  [706] = 706,
  [707] = 427,
  [708] = 84,
  [709] = 619,
  [710] = 710,
  [711] = 453,
  [712] = 461,
  [713] = 471,
  [714] = 475,
  [715] = 477,
  [716] = 478,
  [717] = 479,
  [718] = 480,
  [719] = 481,
  [720] = 482,
  [721] = 461,
  [722] = 436,
  [723] = 492,
  [724] = 433,
  [725] = 441,
  [726] = 726,
  [727] = 444,
  [728] = 728,
  [729] = 432,
  [730] = 730,
  [731] = 731,
  [732] = 429,
  [733] = 733,
  [734] = 734,
  [735] = 445,
  [736] = 439,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 472,
  [742] = 742,
  [743] = 743,
  [744] = 76,
  [745] = 269,
  [746] = 81,
  [747] = 75,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 742,
  [752] = 453,
  [753] = 471,
  [754] = 754,
  [755] = 462,
  [756] = 749,
  [757] = 462,
  [758] = 492,
  [759] = 475,
  [760] = 472,
  [761] = 761,
  [762] = 477,
  [763] = 478,
  [764] = 446,
  [765] = 765,
  [766] = 482,
  [767] = 738,
  [768] = 479,
  [769] = 769,
  [770] = 726,
  [771] = 710,
  [772] = 750,
  [773] = 754,
  [774] = 480,
  [775] = 327,
  [776] = 481,
  [777] = 777,
  [778] = 765,
  [779] = 748,
  [780] = 733,
  [781] = 737,
  [782] = 777,
  [783] = 470,
  [784] = 79,
  [785] = 459,
  [786] = 448,
  [787] = 469,
  [788] = 460,
  [789] = 68,
  [790] = 487,
  [791] = 74,
  [792] = 70,
  [793] = 60,
  [794] = 72,
  [795] = 64,
  [796] = 457,
  [797] = 485,
  [798] = 69,
  [799] = 451,
  [800] = 456,
  [801] = 455,
  [802] = 447,
  [803] = 452,
  [804] = 449,
  [805] = 486,
  [806] = 484,
  [807] = 489,
  [808] = 463,
  [809] = 809,
  [810] = 476,
  [811] = 80,
  [812] = 78,
  [813] = 490,
  [814] = 82,
  [815] = 464,
  [816] = 450,
  [817] = 466,
  [818] = 465,
  [819] = 495,
  [820] = 454,
  [821] = 467,
  [822] = 491,
  [823] = 468,
  [824] = 488,
  [825] = 473,
  [826] = 458,
  [827] = 65,
  [828] = 828,
  [829] = 483,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 833,
  [836] = 832,
  [837] = 373,
  [838] = 327,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 841,
  [843] = 840,
  [844] = 840,
  [845] = 841,
  [846] = 840,
  [847] = 840,
  [848] = 840,
  [849] = 840,
  [850] = 840,
  [851] = 851,
  [852] = 851,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 856,
  [859] = 422,
  [860] = 855,
  [861] = 853,
  [862] = 854,
  [863] = 419,
  [864] = 418,
  [865] = 421,
  [866] = 67,
  [867] = 63,
  [868] = 77,
  [869] = 71,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 875,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 854,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 856,
  [887] = 887,
  [888] = 855,
  [889] = 853,
  [890] = 883,
  [891] = 64,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 894,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 61,
  [904] = 904,
  [905] = 905,
  [906] = 60,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 895,
  [913] = 904,
  [914] = 893,
  [915] = 915,
  [916] = 916,
  [917] = 857,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 922,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 933,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 900,
  [945] = 894,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 919,
  [950] = 918,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 853,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 961,
  [964] = 900,
  [965] = 854,
  [966] = 966,
  [967] = 856,
  [968] = 968,
  [969] = 960,
  [970] = 855,
  [971] = 968,
  [972] = 966,
  [973] = 973,
  [974] = 870,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 976,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 870,
  [983] = 983,
  [984] = 984,
  [985] = 870,
  [986] = 986,
  [987] = 987,
  [988] = 874,
  [989] = 418,
  [990] = 990,
  [991] = 870,
  [992] = 874,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 897,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 419,
  [1003] = 1003,
  [1004] = 874,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 421,
  [1008] = 422,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 415,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1011,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 373,
  [1026] = 1026,
  [1027] = 1014,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 417,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1028,
  [1037] = 1037,
  [1038] = 874,
  [1039] = 1019,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 373,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1026,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1009,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 416,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1056,
  [1060] = 1054,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1064,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1068,
  [1073] = 1073,
  [1074] = 1062,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1070,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1073,
  [1081] = 1061,
  [1082] = 1071,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1083,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1085,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1091,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1091,
  [1099] = 1085,
  [1100] = 1083,
  [1101] = 1097,
  [1102] = 1094,
  [1103] = 1092,
  [1104] = 1095,
  [1105] = 1105,
  [1106] = 1088,
  [1107] = 1096,
  [1108] = 1076,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1069,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1076,
  [1116] = 1092,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1119,
  [1121] = 1118,
  [1122] = 1117,
  [1123] = 1091,
  [1124] = 1085,
  [1125] = 1069,
  [1126] = 1083,
  [1127] = 1127,
  [1128] = 1091,
  [1129] = 1085,
  [1130] = 1083,
  [1131] = 1091,
  [1132] = 1065,
  [1133] = 1085,
  [1134] = 1083,
  [1135] = 1097,
  [1136] = 1066,
  [1137] = 1094,
  [1138] = 1009,
  [1139] = 1092,
  [1140] = 1078,
  [1141] = 1088,
  [1142] = 1076,
  [1143] = 1089,
  [1144] = 1144,
  [1145] = 1110,
  [1146] = 1146,
  [1147] = 1086,
  [1148] = 1148,
  [1149] = 1111,
  [1150] = 1069,
  [1151] = 1113,
  [1152] = 1086,
  [1153] = 1114,
  [1154] = 1091,
  [1155] = 1085,
  [1156] = 1083,
  [1157] = 902,
  [1158] = 1070,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1073,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 64,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 921,
  [1175] = 1175,
  [1176] = 327,
  [1177] = 925,
  [1178] = 77,
  [1179] = 927,
  [1180] = 1180,
  [1181] = 60,
  [1182] = 71,
  [1183] = 1183,
  [1184] = 1114,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 61,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 63,
  [1198] = 67,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1021,
  [1202] = 327,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 932,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 930,
  [1212] = 1212,
  [1213] = 937,
  [1214] = 1214,
  [1215] = 1206,
  [1216] = 1216,
  [1217] = 1191,
  [1218] = 1166,
  [1219] = 1173,
  [1220] = 1220,
  [1221] = 954,
  [1222] = 1173,
  [1223] = 1214,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1212,
  [1228] = 1194,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 923,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 926,
  [1253] = 946,
  [1254] = 1165,
  [1255] = 1226,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 953,
  [1259] = 957,
  [1260] = 1232,
  [1261] = 956,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1237,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1245,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1209,
  [1274] = 1274,
  [1275] = 948,
  [1276] = 943,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 942,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1233,
  [1283] = 955,
  [1284] = 935,
  [1285] = 938,
  [1286] = 916,
  [1287] = 931,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1236,
  [1291] = 1291,
  [1292] = 929,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1263,
  [1297] = 1265,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 924,
  [1304] = 1272,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 939,
  [1308] = 1288,
  [1309] = 1309,
  [1310] = 1274,
  [1311] = 920,
  [1312] = 1305,
  [1313] = 1302,
  [1314] = 1309,
  [1315] = 1247,
  [1316] = 1247,
  [1317] = 1207,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1204,
  [1321] = 1306,
  [1322] = 1196,
  [1323] = 940,
  [1324] = 1319,
  [1325] = 1169,
  [1326] = 1300,
  [1327] = 1167,
  [1328] = 1165,
  [1329] = 1301,
  [1330] = 1190,
  [1331] = 1299,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 941,
  [1335] = 1295,
  [1336] = 1251,
  [1337] = 1248,
  [1338] = 1172,
  [1339] = 1163,
  [1340] = 947,
  [1341] = 951,
  [1342] = 1298,
  [1343] = 1243,
  [1344] = 952,
  [1345] = 1318,
  [1346] = 1240,
  [1347] = 1239,
  [1348] = 1348,
  [1349] = 1229,
  [1350] = 1294,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1356,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1357,
  [1366] = 1357,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 882,
  [1379] = 65,
  [1380] = 1380,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1385,
  [1387] = 1387,
  [1388] = 1388,
  [1389] = 1389,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1375,
  [1402] = 1383,
  [1403] = 1385,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1390,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1382,
  [1411] = 1411,
  [1412] = 1404,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1363,
  [1416] = 1355,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1354,
  [1421] = 1370,
  [1422] = 1370,
  [1423] = 1376,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1351,
  [1427] = 1427,
  [1428] = 1414,
  [1429] = 1427,
  [1430] = 1430,
  [1431] = 1376,
  [1432] = 1432,
  [1433] = 1384,
  [1434] = 1434,
  [1435] = 1396,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1430,
  [1439] = 1353,
  [1440] = 1409,
  [1441] = 1432,
  [1442] = 1442,
  [1443] = 1404,
  [1444] = 1356,
  [1445] = 1445,
  [1446] = 1409,
  [1447] = 1447,
  [1448] = 1436,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1398,
  [1453] = 1451,
  [1454] = 1454,
  [1455] = 1436,
  [1456] = 1404,
  [1457] = 1360,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1409,
  [1461] = 1461,
  [1462] = 1419,
  [1463] = 1351,
  [1464] = 1432,
  [1465] = 1351,
  [1466] = 1430,
  [1467] = 1430,
  [1468] = 1468,
  [1469] = 1358,
  [1470] = 1470,
  [1471] = 1381,
  [1472] = 1409,
  [1473] = 1473,
  [1474] = 1424,
  [1475] = 1404,
  [1476] = 1427,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1361,
  [1480] = 1404,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1408,
  [1485] = 1442,
  [1486] = 1351,
  [1487] = 1409,
  [1488] = 1351,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1491,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1491,
  [1503] = 1503,
  [1504] = 1503,
  [1505] = 1505,
  [1506] = 1491,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1491,
  [1517] = 1517,
  [1518] = 1496,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1491,
  [1522] = 1508,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1503,
  [1529] = 1529,
  [1530] = 1491,
  [1531] = 1491,
  [1532] = 898,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1503,
  [1539] = 1539,
  [1540] = 1499,
  [1541] = 1517,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1547,
  [1549] = 1549,
  [1550] = 1495,
  [1551] = 1512,
  [1552] = 1515,
  [1553] = 1524,
  [1554] = 1500,
  [1555] = 1555,
  [1556] = 1507,
  [1557] = 1497,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1511,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1564,
  [1567] = 1567,
  [1568] = 1543,
  [1569] = 1510,
  [1570] = 1537,
  [1571] = 1489,
  [1572] = 1503,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1576,
  [1580] = 1580,
  [1581] = 1533,
  [1582] = 1536,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1519,
  [1586] = 1586,
  [1587] = 1573,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1507,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1546,
  [1600] = 1539,
  [1601] = 907,
  [1602] = 1602,
  [1603] = 1534,
  [1604] = 1535,
  [1605] = 1605,
  [1606] = 1517,
  [1607] = 1543,
  [1608] = 908,
  [1609] = 1535,
  [1610] = 1534,
  [1611] = 1598,
  [1612] = 1612,
  [1613] = 1593,
  [1614] = 1562,
  [1615] = 1577,
  [1616] = 1534,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1543,
  [1620] = 1594,
  [1621] = 1534,
  [1622] = 1526,
  [1623] = 1543,
  [1624] = 1525,
  [1625] = 1543,
  [1626] = 1501,
  [1627] = 1602,
  [1628] = 1580,
  [1629] = 1589,
  [1630] = 1588,
  [1631] = 1631,
  [1632] = 1586,
  [1633] = 1633,
  [1634] = 1514,
  [1635] = 1635,
  [1636] = 1597,
  [1637] = 1618,
  [1638] = 1635,
  [1639] = 1583,
  [1640] = 1490,
  [1641] = 1510,
  [1642] = 1573,
  [1643] = 1586,
  [1644] = 1644,
  [1645] = 1586,
  [1646] = 1586,
  [1647] = 1527,
  [1648] = 1633,
  [1649] = 1523,
  [1650] = 1513,
  [1651] = 1505,
  [1652] = 1544,
  [1653] = 1612,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(250);
      ADVANCE_MAP(
        '!', 269,
        '"', 411,
        '#', 270,
        '$', 418,
        '%', 334,
        '&', 339,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 332,
        '.', 362,
        '/', 333,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 419,
        '=', 267,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 207,
        '[', 271,
        ']', 272,
        '^', 336,
        '_', 293,
        'a', 180,
        'b', 19,
        'c', 18,
        'd', 122,
        'e', 148,
        'f', 94,
        'i', 63,
        'l', 123,
        'm', 99,
        'n', 164,
        'o', 130,
        'p', 201,
        'r', 110,
        's', 185,
        't', 173,
        'u', 64,
        'w', 134,
        '{', 251,
        '|', 341,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(246);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '#', 270,
        '$', 418,
        '%', 334,
        '&', 339,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 332,
        '.', 362,
        '/', 333,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 325,
        '=', 267,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '^', 336,
        '_', 294,
        'b', 425,
        'c', 427,
        'd', 478,
        'e', 526,
        'f', 458,
        'i', 430,
        'l', 491,
        'm', 465,
        'n', 536,
        'p', 573,
        'r', 498,
        's', 563,
        't', 543,
        'u', 434,
        'w', 503,
        '{', 251,
        '|', 341,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '^', 335,
        '_', 404,
        'b', 425,
        'c', 428,
        'd', 478,
        'f', 459,
        'i', 431,
        'l', 533,
        'm', 468,
        'r', 479,
        's', 575,
        't', 552,
        'u', 435,
        'w', 503,
        '{', 251,
        '|', 342,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        '*', 291,
        '+', 329,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        '<', 325,
        '=', 267,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 582,
        '[', 271,
        '^', 335,
        '_', 404,
        'b', 425,
        'c', 428,
        'd', 478,
        'f', 459,
        'i', 431,
        'l', 533,
        'm', 468,
        'r', 479,
        's', 575,
        't', 552,
        'u', 435,
        'w', 503,
        '{', 251,
        '|', 342,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 269,
        '%', 334,
        '&', 338,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        ';', 256,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        '[', 271,
        ']', 272,
        '^', 335,
        'a', 180,
        'e', 147,
        'i', 157,
        'n', 164,
        '{', 251,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(394);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 268,
        '"', 406,
        '#', 270,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 290,
        ',', 279,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 324,
        '=', 265,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '_', 404,
        'b', 425,
        'c', 428,
        'd', 478,
        'f', 459,
        'i', 431,
        'l', 533,
        'm', 468,
        'r', 479,
        's', 575,
        't', 552,
        'u', 435,
        'w', 503,
        '{', 251,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 268,
        '"', 406,
        '\'', 24,
        '(', 292,
        '*', 290,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 89,
        '@', 359,
        'B', 582,
        '[', 271,
        '_', 404,
        'b', 425,
        'c', 428,
        'd', 478,
        'f', 459,
        'i', 431,
        'l', 491,
        'm', 468,
        'r', 479,
        's', 575,
        't', 552,
        'u', 435,
        'w', 503,
        '{', 251,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 268,
        '"', 406,
        '\'', 24,
        '(', 292,
        '*', 290,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 89,
        '@', 359,
        'B', 582,
        '[', 271,
        '_', 404,
        'b', 425,
        'c', 428,
        'd', 478,
        'f', 459,
        'i', 431,
        'l', 533,
        'm', 467,
        'r', 479,
        's', 575,
        't', 552,
        'u', 435,
        'w', 503,
        '{', 251,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 268,
        '(', 292,
        ')', 295,
        ',', 279,
        '-', 91,
        '/', 62,
        ':', 262,
        ';', 256,
        '<', 419,
        '=', 265,
        '>', 326,
        '[', 271,
        ']', 272,
        'i', 158,
        'n', 164,
        'o', 130,
        '{', 251,
        '|', 340,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 268,
        '(', 292,
        ',', 279,
        '/', 62,
        ':', 89,
        ';', 256,
        '<', 419,
        '=', 92,
        ']', 272,
        'i', 129,
        '{', 251,
        '|', 340,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 90,
        '"', 411,
        '#', 270,
        '%', 334,
        '&', 338,
        '(', 292,
        '*', 291,
        '+', 329,
        '-', 331,
        '.', 361,
        '/', 333,
        ':', 89,
        ';', 256,
        '<', 325,
        '=', 267,
        '>', 327,
        '?', 364,
        'B', 582,
        '[', 271,
        '^', 335,
        'b', 531,
        'c', 537,
        'd', 478,
        'e', 526,
        'f', 494,
        'i', 432,
        'l', 492,
        'm', 532,
        'p', 573,
        's', 565,
        't', 550,
        'u', 434,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 90,
        '"', 406,
        '#', 270,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        'B', 582,
        '[', 271,
        '^', 335,
        '_', 294,
        'b', 426,
        'c', 429,
        'd', 478,
        'e', 520,
        'f', 460,
        'i', 433,
        'm', 579,
        's', 575,
        't', 552,
        'u', 435,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 90,
        '"', 406,
        '#', 270,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        'B', 582,
        '[', 271,
        '^', 335,
        '_', 294,
        'b', 426,
        'c', 429,
        'd', 478,
        'f', 460,
        'i', 433,
        'm', 579,
        's', 575,
        't', 552,
        'u', 435,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 90,
        '#', 270,
        '%', 334,
        '&', 338,
        '(', 292,
        '*', 291,
        '+', 329,
        '-', 331,
        '.', 361,
        '/', 333,
        ':', 89,
        ';', 256,
        '<', 325,
        '=', 267,
        '>', 327,
        '?', 364,
        'B', 582,
        '[', 271,
        '^', 335,
        'b', 531,
        'c', 537,
        'd', 478,
        'e', 526,
        'f', 494,
        'i', 432,
        'l', 492,
        'm', 532,
        'p', 573,
        's', 565,
        't', 550,
        'u', 434,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 90,
        '%', 334,
        '&', 338,
        '(', 292,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        ':', 261,
        '<', 325,
        '=', 267,
        '>', 327,
        '?', 364,
        '[', 271,
        '^', 335,
        'e', 147,
        '|', 342,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 406,
        '#', 270,
        '\'', 24,
        '(', 292,
        ')', 295,
        ',', 279,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 89,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '_', 294,
        'b', 426,
        'c', 429,
        'd', 478,
        'f', 460,
        'i', 433,
        'm', 579,
        's', 575,
        't', 552,
        'u', 435,
        '|', 340,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '"', 406,
        '#', 270,
        '\'', 24,
        '(', 292,
        ')', 295,
        ',', 279,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 89,
        '@', 359,
        'B', 582,
        '[', 271,
        '_', 294,
        'b', 426,
        'c', 429,
        'd', 478,
        'f', 460,
        'i', 433,
        'm', 579,
        'r', 493,
        's', 575,
        't', 552,
        'u', 435,
        '|', 340,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '"', 406,
        '\'', 24,
        '(', 292,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 89,
        '>', 326,
        '@', 359,
        'B', 582,
        '[', 271,
        '_', 404,
        'b', 426,
        'c', 429,
        'd', 478,
        'f', 460,
        'i', 433,
        's', 575,
        't', 552,
        'u', 435,
        '{', 251,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(159);
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(165);
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '#', 270,
        '+', 328,
        '-', 330,
        '/', 62,
        ':', 89,
        '>', 326,
        'B', 582,
        'b', 531,
        'c', 537,
        'd', 478,
        'f', 495,
        'i', 432,
        's', 575,
        'u', 435,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(270);
      if (lookahead == ',') ADVANCE(279);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == '0') ADVANCE(392);
      if (lookahead == '_') ADVANCE(404);
      if (lookahead == '}') ADVANCE(252);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(270);
      if (lookahead == ',') ADVANCE(279);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == 'p') ADVANCE(573);
      if (lookahead == '}') ADVANCE(252);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 23:
      if (lookahead == '\'') ADVANCE(413);
      END_STATE();
    case 24:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(245);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 25:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(216);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(214);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 27:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(217);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 28:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(218);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 29:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(219);
      if (lookahead != 0) ADVANCE(28);
      END_STATE();
    case 30:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(220);
      if (lookahead != 0) ADVANCE(29);
      END_STATE();
    case 31:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(221);
      if (lookahead != 0) ADVANCE(30);
      END_STATE();
    case 32:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 33:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(223);
      if (lookahead != 0) ADVANCE(32);
      END_STATE();
    case 34:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(224);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 35:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 36:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(226);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 37:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(227);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(228);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(229);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 40:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 41:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(233);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 44:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(234);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(235);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(236);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(237);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(238);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(239);
      if (lookahead != 0) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(240);
      if (lookahead != 0) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(241);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(242);
      if (lookahead != 0) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') ADVANCE(244);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 55:
      ADVANCE_MAP(
        '(', 292,
        ')', 295,
        '*', 290,
        ',', 279,
        '/', 62,
        ':', 89,
        '@', 359,
        'B', 582,
        '[', 271,
        'b', 531,
        'd', 478,
        'f', 495,
        'i', 433,
        's', 575,
        'u', 435,
        '{', 251,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(55);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 56:
      ADVANCE_MAP(
        '(', 292,
        '/', 62,
        ':', 89,
        ';', 256,
        '@', 359,
        'B', 582,
        '[', 271,
        'b', 531,
        'd', 478,
        'f', 495,
        'i', 433,
        'n', 536,
        's', 575,
        'u', 435,
        '{', 251,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(56);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 57:
      if (lookahead == '(') ADVANCE(292);
      if (lookahead == '/') ADVANCE(62);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(57);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 58:
      ADVANCE_MAP(
        ')', 295,
        ',', 279,
        '/', 62,
        ':', 261,
        ';', 256,
        '<', 324,
        '=', 265,
        '>', 326,
        ']', 272,
        'i', 158,
        'n', 164,
        'o', 130,
        '{', 251,
        '|', 340,
        '}', 252,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(58);
      END_STATE();
    case 59:
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == '<') ADVANCE(419);
      if (lookahead == 's') ADVANCE(575);
      if (lookahead == '{') ADVANCE(251);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(59);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 60:
      if (lookahead == ',') ADVANCE(279);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == 'm') ADVANCE(579);
      if (lookahead == '}') ADVANCE(252);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(60);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 61:
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 62:
      if (lookahead == '/') ADVANCE(592);
      END_STATE();
    case 63:
      if (lookahead == '1') ADVANCE(67);
      if (lookahead == '3') ADVANCE(68);
      if (lookahead == '6') ADVANCE(78);
      if (lookahead == '8') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(371);
      if (lookahead == 'm') ADVANCE(169);
      if (lookahead == 'n') ADVANCE(422);
      END_STATE();
    case 64:
      if (lookahead == '1') ADVANCE(73);
      if (lookahead == '3') ADVANCE(69);
      if (lookahead == '6') ADVANCE(79);
      if (lookahead == '8') ADVANCE(296);
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 65:
      if (lookahead == '1') ADVANCE(75);
      if (lookahead == '2') ADVANCE(81);
      if (lookahead == '3') ADVANCE(70);
      if (lookahead == '6') ADVANCE(80);
      if (lookahead == '8') ADVANCE(391);
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 66:
      if (lookahead == '1') ADVANCE(75);
      if (lookahead == '3') ADVANCE(70);
      if (lookahead == '6') ADVANCE(80);
      if (lookahead == '8') ADVANCE(391);
      END_STATE();
    case 67:
      if (lookahead == '2') ADVANCE(87);
      if (lookahead == '6') ADVANCE(302);
      END_STATE();
    case 68:
      if (lookahead == '2') ADVANCE(306);
      END_STATE();
    case 69:
      if (lookahead == '2') ADVANCE(304);
      END_STATE();
    case 70:
      if (lookahead == '2') ADVANCE(391);
      END_STATE();
    case 71:
      if (lookahead == '2') ADVANCE(322);
      END_STATE();
    case 72:
      if (lookahead == '2') ADVANCE(412);
      END_STATE();
    case 73:
      if (lookahead == '2') ADVANCE(88);
      if (lookahead == '6') ADVANCE(300);
      END_STATE();
    case 74:
      if (lookahead == '2') ADVANCE(83);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(86);
      if (lookahead == '6') ADVANCE(391);
      END_STATE();
    case 76:
      if (lookahead == '2') ADVANCE(82);
      END_STATE();
    case 77:
      if (lookahead == '2') ADVANCE(84);
      END_STATE();
    case 78:
      if (lookahead == '4') ADVANCE(310);
      END_STATE();
    case 79:
      if (lookahead == '4') ADVANCE(308);
      END_STATE();
    case 80:
      if (lookahead == '4') ADVANCE(391);
      END_STATE();
    case 81:
      if (lookahead == '5') ADVANCE(85);
      END_STATE();
    case 82:
      if (lookahead == '5') ADVANCE(70);
      END_STATE();
    case 83:
      if (lookahead == '5') ADVANCE(71);
      END_STATE();
    case 84:
      if (lookahead == '5') ADVANCE(72);
      END_STATE();
    case 85:
      if (lookahead == '6') ADVANCE(391);
      END_STATE();
    case 86:
      if (lookahead == '8') ADVANCE(391);
      END_STATE();
    case 87:
      if (lookahead == '8') ADVANCE(314);
      END_STATE();
    case 88:
      if (lookahead == '8') ADVANCE(312);
      END_STATE();
    case 89:
      if (lookahead == ':') ADVANCE(288);
      END_STATE();
    case 90:
      if (lookahead == '=') ADVANCE(356);
      END_STATE();
    case 91:
      if (lookahead == '>') ADVANCE(282);
      END_STATE();
    case 92:
      if (lookahead == '>') ADVANCE(363);
      END_STATE();
    case 93:
      if (lookahead == 'A') ADVANCE(179);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'e') ADVANCE(149);
      if (lookahead == 'n') ADVANCE(280);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 96:
      if (lookahead == 'a') ADVANCE(208);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(163);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(141);
      if (lookahead == 'u') ADVANCE(115);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'o') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(188);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(205);
      END_STATE();
    case 101:
      if (lookahead == 'a') ADVANCE(196);
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 102:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 103:
      if (lookahead == 'b') ADVANCE(381);
      END_STATE();
    case 104:
      if (lookahead == 'c') ADVANCE(385);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(375);
      END_STATE();
    case 106:
      if (lookahead == 'c') ADVANCE(135);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(191);
      END_STATE();
    case 108:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(273);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(286);
      if (lookahead == 'i') ADVANCE(209);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(391);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(420);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(414);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(591);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(416);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(387);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(367);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(186);
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 129:
      if (lookahead == 'f') ADVANCE(371);
      END_STATE();
    case 130:
      if (lookahead == 'f') ADVANCE(255);
      END_STATE();
    case 131:
      if (lookahead == 'f') ADVANCE(423);
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 132:
      if (lookahead == 'f') ADVANCE(100);
      END_STATE();
    case 133:
      if (lookahead == 'f') ADVANCE(128);
      END_STATE();
    case 134:
      if (lookahead == 'h') ADVANCE(139);
      END_STATE();
    case 135:
      if (lookahead == 'h') ADVANCE(379);
      END_STATE();
    case 136:
      if (lookahead == 'i') ADVANCE(162);
      END_STATE();
    case 137:
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 138:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 139:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(108);
      END_STATE();
    case 141:
      if (lookahead == 'i') ADVANCE(190);
      END_STATE();
    case 142:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(365);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(318);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(253);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(182);
      END_STATE();
    case 148:
      if (lookahead == 'l') ADVANCE(182);
      if (lookahead == 'n') ADVANCE(202);
      if (lookahead == 'x') ADVANCE(197);
      END_STATE();
    case 149:
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(140);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(192);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 154:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 155:
      if (lookahead == 'l') ADVANCE(200);
      END_STATE();
    case 156:
      if (lookahead == 'm') ADVANCE(277);
      END_STATE();
    case 157:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 158:
      if (lookahead == 'm') ADVANCE(170);
      if (lookahead == 'n') ADVANCE(422);
      END_STATE();
    case 159:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 160:
      if (lookahead == 'n') ADVANCE(373);
      END_STATE();
    case 161:
      if (lookahead == 'n') ADVANCE(383);
      END_STATE();
    case 162:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 163:
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 164:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(145);
      END_STATE();
    case 166:
      if (lookahead == 'o') ADVANCE(167);
      END_STATE();
    case 167:
      if (lookahead == 'p') ADVANCE(377);
      END_STATE();
    case 168:
      if (lookahead == 'p') ADVANCE(97);
      END_STATE();
    case 169:
      if (lookahead == 'p') ADVANCE(146);
      END_STATE();
    case 170:
      if (lookahead == 'p') ADVANCE(150);
      END_STATE();
    case 171:
      if (lookahead == 'p') ADVANCE(126);
      END_STATE();
    case 172:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 173:
      if (lookahead == 'r') ADVANCE(98);
      if (lookahead == 'y') ADVANCE(172);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(389);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(589);
      END_STATE();
    case 176:
      if (lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 178:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 179:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 180:
      if (lookahead == 's') ADVANCE(289);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(283);
      END_STATE();
    case 182:
      if (lookahead == 's') ADVANCE(114);
      END_STATE();
    case 183:
      if (lookahead == 's') ADVANCE(189);
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 184:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(101);
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(587);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 190:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(369);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(181);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 201:
      if (lookahead == 'u') ADVANCE(103);
      END_STATE();
    case 202:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 203:
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(121);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 206:
      if (lookahead == 'u') ADVANCE(177);
      END_STATE();
    case 207:
      if (lookahead == 'y') ADVANCE(195);
      END_STATE();
    case 208:
      if (lookahead == 'y') ADVANCE(320);
      END_STATE();
    case 209:
      if (lookahead == 'z') ADVANCE(119);
      END_STATE();
    case 210:
      if (lookahead == 'z') ADVANCE(112);
      END_STATE();
    case 211:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(396);
      END_STATE();
    case 212:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(398);
      END_STATE();
    case 213:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(402);
      END_STATE();
    case 214:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(23);
      END_STATE();
    case 215:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(410);
      END_STATE();
    case 216:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(26);
      END_STATE();
    case 217:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 218:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 219:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 220:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(29);
      END_STATE();
    case 221:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(30);
      END_STATE();
    case 222:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 223:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 224:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 225:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(34);
      END_STATE();
    case 226:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(35);
      END_STATE();
    case 227:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(36);
      END_STATE();
    case 228:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(37);
      END_STATE();
    case 229:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(38);
      END_STATE();
    case 230:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(39);
      END_STATE();
    case 231:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 232:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(41);
      END_STATE();
    case 233:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(42);
      END_STATE();
    case 234:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(43);
      END_STATE();
    case 235:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(44);
      END_STATE();
    case 236:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(45);
      END_STATE();
    case 237:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(46);
      END_STATE();
    case 238:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(47);
      END_STATE();
    case 239:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 240:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(49);
      END_STATE();
    case 241:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(50);
      END_STATE();
    case 242:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(51);
      END_STATE();
    case 243:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(52);
      END_STATE();
    case 244:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(53);
      END_STATE();
    case 245:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(54);
      END_STATE();
    case 246:
      if (eof) ADVANCE(250);
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '#', 270,
        '$', 418,
        '%', 334,
        '&', 339,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 332,
        '.', 362,
        '/', 333,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 419,
        '=', 267,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 207,
        '[', 271,
        ']', 272,
        '^', 336,
        '_', 293,
        'a', 180,
        'b', 19,
        'c', 18,
        'd', 122,
        'e', 148,
        'f', 94,
        'i', 63,
        'l', 123,
        'm', 99,
        'n', 164,
        'o', 130,
        'p', 201,
        'r', 110,
        's', 185,
        't', 173,
        'u', 64,
        'w', 134,
        '{', 251,
        '|', 341,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(246);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 247:
      if (eof) ADVANCE(250);
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '#', 270,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 291,
        '+', 329,
        ',', 279,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        ';', 256,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '^', 335,
        '_', 404,
        'b', 425,
        'c', 427,
        'd', 478,
        'e', 526,
        'f', 458,
        'i', 430,
        'l', 491,
        'm', 466,
        'p', 573,
        'r', 479,
        's', 565,
        't', 543,
        'u', 434,
        'w', 503,
        '{', 251,
        '|', 342,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(247);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 248:
      if (eof) ADVANCE(250);
      ADVANCE_MAP(
        '!', 269,
        '"', 406,
        '#', 270,
        '%', 334,
        '&', 338,
        '\'', 24,
        '(', 292,
        '*', 291,
        '+', 329,
        '-', 331,
        '.', 361,
        '/', 333,
        '0', 392,
        ':', 89,
        ';', 256,
        '<', 325,
        '=', 266,
        '>', 327,
        '?', 364,
        '@', 359,
        'B', 582,
        '[', 271,
        '^', 335,
        '_', 404,
        'b', 425,
        'c', 427,
        'd', 478,
        'e', 519,
        'f', 458,
        'i', 430,
        'l', 491,
        'm', 466,
        'p', 573,
        'r', 479,
        's', 565,
        't', 543,
        'u', 434,
        'w', 503,
        '{', 251,
        '|', 342,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(248);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 249:
      if (eof) ADVANCE(250);
      ADVANCE_MAP(
        '!', 268,
        '"', 406,
        '#', 270,
        '\'', 24,
        '(', 292,
        ')', 295,
        '*', 290,
        ',', 279,
        '-', 330,
        '/', 62,
        '0', 392,
        ':', 262,
        ';', 256,
        '<', 419,
        '=', 265,
        '>', 326,
        '@', 359,
        'B', 582,
        '[', 271,
        ']', 272,
        '_', 404,
        'b', 425,
        'c', 427,
        'd', 478,
        'e', 526,
        'f', 458,
        'i', 430,
        'l', 491,
        'm', 466,
        'p', 573,
        'r', 479,
        's', 565,
        't', 543,
        'u', 434,
        'w', 503,
        '{', 251,
        '|', 340,
        '}', 252,
        '~', 337,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(249);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(394);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_impl);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_impl);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_trait);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(288);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(355);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(355);
      if (lookahead == '>') ADVANCE(363);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(356);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_mod);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_struct);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_enum);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_implicits);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(349);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_u8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_i8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_u16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_i16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_u32);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_u32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_i32);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_i32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_u64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_i64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_u128);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_u128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_i128);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_i128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_usize);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_usize);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_ByteArray);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_ByteArray);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_felt252);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_felt252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(345);
      if (lookahead == '=') ADVANCE(358);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(357);
      if (lookahead == '>') ADVANCE(346);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(347);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(348);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(348);
      if (lookahead == '>') ADVANCE(282);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(592);
      if (lookahead == '=') ADVANCE(350);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(351);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(352);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(343);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(343);
      if (lookahead == '=') ADVANCE(353);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(354);
      if (lookahead == '|') ADVANCE(344);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(344);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_default);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_extern);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_nopanic);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_nopanic);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_loop);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_match);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_pub);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_numeric_literal);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(393);
      if (lookahead == 'b') ADVANCE(211);
      if (lookahead == 'o') ADVANCE(212);
      if (lookahead == 'x') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(393);
      if (lookahead == 'f') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(394);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(395);
      if (lookahead == 'f') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(65);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(396);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(395);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(396);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(397);
      if (lookahead == 'f') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(398);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(398);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 'e') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(402);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 'f') ADVANCE(399);
      if (lookahead == 'i') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(402);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (lookahead == 'l') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(402);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(402);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(403);
      if (lookahead == 'f') ADVANCE(499);
      if (lookahead == 'i') ADVANCE(437);
      if (lookahead == 'u') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (lookahead == '_') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(404);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_numeric_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '"') ADVANCE(592);
      if (lookahead == '\\') ADVANCE(593);
      if (lookahead != 0) ADVANCE(407);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(409);
      if (lookahead == '\\') ADVANCE(215);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(408);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(410);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '/') ADVANCE(407);
      if (lookahead == '\\') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(410);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\\') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(410);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_shortstring_literal);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_shortstring_literal);
      if (lookahead == '_') ADVANCE(133);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_LT2);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_ref);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(534);
      if (lookahead == 'r') ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(406);
      if (lookahead == 'o') ADVANCE(530);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(438);
      if (lookahead == '3') ADVANCE(439);
      if (lookahead == '6') ADVANCE(447);
      if (lookahead == '8') ADVANCE(299);
      if (lookahead == 'f') ADVANCE(372);
      if (lookahead == 'm') ADVANCE(539);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(438);
      if (lookahead == '3') ADVANCE(439);
      if (lookahead == '6') ADVANCE(447);
      if (lookahead == '8') ADVANCE(299);
      if (lookahead == 'f') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(438);
      if (lookahead == '3') ADVANCE(439);
      if (lookahead == '6') ADVANCE(447);
      if (lookahead == '8') ADVANCE(299);
      if (lookahead == 'm') ADVANCE(539);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(438);
      if (lookahead == '3') ADVANCE(439);
      if (lookahead == '6') ADVANCE(447);
      if (lookahead == '8') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(443);
      if (lookahead == '3') ADVANCE(440);
      if (lookahead == '6') ADVANCE(448);
      if (lookahead == '8') ADVANCE(297);
      if (lookahead == 's') ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(443);
      if (lookahead == '3') ADVANCE(440);
      if (lookahead == '6') ADVANCE(448);
      if (lookahead == '8') ADVANCE(297);
      if (lookahead == 's') ADVANCE(505);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(445);
      if (lookahead == '2') ADVANCE(450);
      if (lookahead == '3') ADVANCE(441);
      if (lookahead == '6') ADVANCE(449);
      if (lookahead == '8') ADVANCE(405);
      if (lookahead == 's') ADVANCE(511);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '1') ADVANCE(445);
      if (lookahead == '3') ADVANCE(441);
      if (lookahead == '6') ADVANCE(449);
      if (lookahead == '8') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(455);
      if (lookahead == '6') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(456);
      if (lookahead == '6') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(454);
      if (lookahead == '6') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '2') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '4') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '5') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '6') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(551);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(513);
      if (lookahead == 'e') ADVANCE(516);
      if (lookahead == 'n') ADVANCE(281);
      if (lookahead == 'o') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(513);
      if (lookahead == 'e') ADVANCE(516);
      if (lookahead == 'o') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(513);
      if (lookahead == 'e') ADVANCE(516);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(512);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(583);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(510);
      if (lookahead == 'u') ADVANCE(484);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(510);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(558);
      if (lookahead == 'o') ADVANCE(477);
      if (lookahead == 'u') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(558);
      if (lookahead == 'o') ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(558);
      if (lookahead == 'u') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(558);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(581);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(570);
      if (lookahead == 'r') ADVANCE(576);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(504);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(561);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(502);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(500);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(287);
      if (lookahead == 'i') ADVANCE(584);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(557);
      if (lookahead == 'o') ADVANCE(535);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(557);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(516);
      if (lookahead == 'n') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(516);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(545);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(521);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(424);
      if (lookahead == 't') ADVANCE(577);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(469);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(509);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(584);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(528);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(474);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(518);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(585);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(555);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(562);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(488);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(556);
      if (lookahead == 'n') ADVANCE(574);
      if (lookahead == 'x') ADVANCE(571);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(553);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(574);
      if (lookahead == 'x') ADVANCE(571);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(580);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(508);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(569);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(535);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(514);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(540);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(527);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(470);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(463);
      if (lookahead == 'y') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(590);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(462);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(576);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(525);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(464);
      if (lookahead == 'y') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(547);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(578);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(559);
      if (lookahead == 't') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(559);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(471);
      if (lookahead == 'u') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(588);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(548);
      if (lookahead == 'u') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(577);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(482);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(507);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(476);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(484);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(489);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(567);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(487);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(586);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(586);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_mutable_specifier);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_mutable_specifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_super);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(586);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_crate);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(592);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(407);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 249},
  [2] = {.lex_state = 249},
  [3] = {.lex_state = 249},
  [4] = {.lex_state = 249},
  [5] = {.lex_state = 249},
  [6] = {.lex_state = 249},
  [7] = {.lex_state = 249},
  [8] = {.lex_state = 249},
  [9] = {.lex_state = 249},
  [10] = {.lex_state = 249},
  [11] = {.lex_state = 249},
  [12] = {.lex_state = 249},
  [13] = {.lex_state = 249},
  [14] = {.lex_state = 249},
  [15] = {.lex_state = 249},
  [16] = {.lex_state = 249},
  [17] = {.lex_state = 249},
  [18] = {.lex_state = 249},
  [19] = {.lex_state = 249},
  [20] = {.lex_state = 249},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 2},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 247},
  [69] = {.lex_state = 247},
  [70] = {.lex_state = 247},
  [71] = {.lex_state = 247},
  [72] = {.lex_state = 247},
  [73] = {.lex_state = 247},
  [74] = {.lex_state = 247},
  [75] = {.lex_state = 247},
  [76] = {.lex_state = 247},
  [77] = {.lex_state = 247},
  [78] = {.lex_state = 247},
  [79] = {.lex_state = 247},
  [80] = {.lex_state = 247},
  [81] = {.lex_state = 247},
  [82] = {.lex_state = 247},
  [83] = {.lex_state = 247},
  [84] = {.lex_state = 248},
  [85] = {.lex_state = 248},
  [86] = {.lex_state = 248},
  [87] = {.lex_state = 248},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 247},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 247},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 247},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 6},
  [124] = {.lex_state = 6},
  [125] = {.lex_state = 6},
  [126] = {.lex_state = 6},
  [127] = {.lex_state = 6},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 6},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 7},
  [141] = {.lex_state = 7},
  [142] = {.lex_state = 7},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 5},
  [164] = {.lex_state = 5},
  [165] = {.lex_state = 5},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 5},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 5},
  [192] = {.lex_state = 5},
  [193] = {.lex_state = 5},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 5},
  [196] = {.lex_state = 5},
  [197] = {.lex_state = 5},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 5},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 5},
  [204] = {.lex_state = 5},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 5},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 5},
  [211] = {.lex_state = 5},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 5},
  [215] = {.lex_state = 5},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 5},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 5},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 5},
  [223] = {.lex_state = 5},
  [224] = {.lex_state = 5},
  [225] = {.lex_state = 10},
  [226] = {.lex_state = 10},
  [227] = {.lex_state = 10},
  [228] = {.lex_state = 10},
  [229] = {.lex_state = 10},
  [230] = {.lex_state = 10},
  [231] = {.lex_state = 10},
  [232] = {.lex_state = 10},
  [233] = {.lex_state = 10},
  [234] = {.lex_state = 249},
  [235] = {.lex_state = 10},
  [236] = {.lex_state = 249},
  [237] = {.lex_state = 16},
  [238] = {.lex_state = 249},
  [239] = {.lex_state = 10},
  [240] = {.lex_state = 10},
  [241] = {.lex_state = 11},
  [242] = {.lex_state = 11},
  [243] = {.lex_state = 11},
  [244] = {.lex_state = 11},
  [245] = {.lex_state = 16},
  [246] = {.lex_state = 16},
  [247] = {.lex_state = 16},
  [248] = {.lex_state = 249},
  [249] = {.lex_state = 249},
  [250] = {.lex_state = 249},
  [251] = {.lex_state = 249},
  [252] = {.lex_state = 249},
  [253] = {.lex_state = 249},
  [254] = {.lex_state = 12},
  [255] = {.lex_state = 12},
  [256] = {.lex_state = 249},
  [257] = {.lex_state = 12},
  [258] = {.lex_state = 12},
  [259] = {.lex_state = 249},
  [260] = {.lex_state = 249},
  [261] = {.lex_state = 249},
  [262] = {.lex_state = 249},
  [263] = {.lex_state = 12},
  [264] = {.lex_state = 12},
  [265] = {.lex_state = 249},
  [266] = {.lex_state = 249},
  [267] = {.lex_state = 249},
  [268] = {.lex_state = 249},
  [269] = {.lex_state = 249},
  [270] = {.lex_state = 249},
  [271] = {.lex_state = 249},
  [272] = {.lex_state = 249},
  [273] = {.lex_state = 249},
  [274] = {.lex_state = 249},
  [275] = {.lex_state = 249},
  [276] = {.lex_state = 249},
  [277] = {.lex_state = 249},
  [278] = {.lex_state = 249},
  [279] = {.lex_state = 249},
  [280] = {.lex_state = 249},
  [281] = {.lex_state = 249},
  [282] = {.lex_state = 249},
  [283] = {.lex_state = 249},
  [284] = {.lex_state = 249},
  [285] = {.lex_state = 249},
  [286] = {.lex_state = 12},
  [287] = {.lex_state = 249},
  [288] = {.lex_state = 249},
  [289] = {.lex_state = 249},
  [290] = {.lex_state = 249},
  [291] = {.lex_state = 249},
  [292] = {.lex_state = 249},
  [293] = {.lex_state = 249},
  [294] = {.lex_state = 12},
  [295] = {.lex_state = 249},
  [296] = {.lex_state = 249},
  [297] = {.lex_state = 12},
  [298] = {.lex_state = 12},
  [299] = {.lex_state = 249},
  [300] = {.lex_state = 249},
  [301] = {.lex_state = 249},
  [302] = {.lex_state = 249},
  [303] = {.lex_state = 249},
  [304] = {.lex_state = 12},
  [305] = {.lex_state = 12},
  [306] = {.lex_state = 249},
  [307] = {.lex_state = 249},
  [308] = {.lex_state = 249},
  [309] = {.lex_state = 249},
  [310] = {.lex_state = 249},
  [311] = {.lex_state = 249},
  [312] = {.lex_state = 249},
  [313] = {.lex_state = 249},
  [314] = {.lex_state = 249},
  [315] = {.lex_state = 249},
  [316] = {.lex_state = 12},
  [317] = {.lex_state = 249},
  [318] = {.lex_state = 249},
  [319] = {.lex_state = 249},
  [320] = {.lex_state = 16},
  [321] = {.lex_state = 249},
  [322] = {.lex_state = 249},
  [323] = {.lex_state = 249},
  [324] = {.lex_state = 249},
  [325] = {.lex_state = 249},
  [326] = {.lex_state = 249},
  [327] = {.lex_state = 249},
  [328] = {.lex_state = 249},
  [329] = {.lex_state = 249},
  [330] = {.lex_state = 249},
  [331] = {.lex_state = 249},
  [332] = {.lex_state = 249},
  [333] = {.lex_state = 249},
  [334] = {.lex_state = 249},
  [335] = {.lex_state = 249},
  [336] = {.lex_state = 249},
  [337] = {.lex_state = 249},
  [338] = {.lex_state = 249},
  [339] = {.lex_state = 12},
  [340] = {.lex_state = 249},
  [341] = {.lex_state = 249},
  [342] = {.lex_state = 249},
  [343] = {.lex_state = 16},
  [344] = {.lex_state = 15},
  [345] = {.lex_state = 16},
  [346] = {.lex_state = 15},
  [347] = {.lex_state = 15},
  [348] = {.lex_state = 15},
  [349] = {.lex_state = 15},
  [350] = {.lex_state = 15},
  [351] = {.lex_state = 15},
  [352] = {.lex_state = 15},
  [353] = {.lex_state = 15},
  [354] = {.lex_state = 15},
  [355] = {.lex_state = 15},
  [356] = {.lex_state = 15},
  [357] = {.lex_state = 15},
  [358] = {.lex_state = 15},
  [359] = {.lex_state = 15},
  [360] = {.lex_state = 15},
  [361] = {.lex_state = 15},
  [362] = {.lex_state = 15},
  [363] = {.lex_state = 15},
  [364] = {.lex_state = 15},
  [365] = {.lex_state = 15},
  [366] = {.lex_state = 15},
  [367] = {.lex_state = 15},
  [368] = {.lex_state = 15},
  [369] = {.lex_state = 15},
  [370] = {.lex_state = 15},
  [371] = {.lex_state = 15},
  [372] = {.lex_state = 15},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 15},
  [375] = {.lex_state = 15},
  [376] = {.lex_state = 15},
  [377] = {.lex_state = 15},
  [378] = {.lex_state = 15},
  [379] = {.lex_state = 15},
  [380] = {.lex_state = 15},
  [381] = {.lex_state = 15},
  [382] = {.lex_state = 15},
  [383] = {.lex_state = 15},
  [384] = {.lex_state = 15},
  [385] = {.lex_state = 15},
  [386] = {.lex_state = 15},
  [387] = {.lex_state = 15},
  [388] = {.lex_state = 15},
  [389] = {.lex_state = 15},
  [390] = {.lex_state = 15},
  [391] = {.lex_state = 15},
  [392] = {.lex_state = 15},
  [393] = {.lex_state = 15},
  [394] = {.lex_state = 15},
  [395] = {.lex_state = 15},
  [396] = {.lex_state = 15},
  [397] = {.lex_state = 15},
  [398] = {.lex_state = 15},
  [399] = {.lex_state = 15},
  [400] = {.lex_state = 15},
  [401] = {.lex_state = 15},
  [402] = {.lex_state = 15},
  [403] = {.lex_state = 17},
  [404] = {.lex_state = 17},
  [405] = {.lex_state = 17},
  [406] = {.lex_state = 17},
  [407] = {.lex_state = 17},
  [408] = {.lex_state = 17},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 17},
  [411] = {.lex_state = 17},
  [412] = {.lex_state = 17},
  [413] = {.lex_state = 17},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 4},
  [416] = {.lex_state = 4},
  [417] = {.lex_state = 4},
  [418] = {.lex_state = 4},
  [419] = {.lex_state = 4},
  [420] = {.lex_state = 2},
  [421] = {.lex_state = 4},
  [422] = {.lex_state = 4},
  [423] = {.lex_state = 4},
  [424] = {.lex_state = 2},
  [425] = {.lex_state = 2},
  [426] = {.lex_state = 2},
  [427] = {.lex_state = 2},
  [428] = {.lex_state = 56},
  [429] = {.lex_state = 2},
  [430] = {.lex_state = 56},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 2},
  [433] = {.lex_state = 2},
  [434] = {.lex_state = 2},
  [435] = {.lex_state = 2},
  [436] = {.lex_state = 2},
  [437] = {.lex_state = 4},
  [438] = {.lex_state = 56},
  [439] = {.lex_state = 2},
  [440] = {.lex_state = 56},
  [441] = {.lex_state = 2},
  [442] = {.lex_state = 2},
  [443] = {.lex_state = 4},
  [444] = {.lex_state = 2},
  [445] = {.lex_state = 2},
  [446] = {.lex_state = 2},
  [447] = {.lex_state = 2},
  [448] = {.lex_state = 2},
  [449] = {.lex_state = 2},
  [450] = {.lex_state = 2},
  [451] = {.lex_state = 2},
  [452] = {.lex_state = 2},
  [453] = {.lex_state = 2},
  [454] = {.lex_state = 2},
  [455] = {.lex_state = 2},
  [456] = {.lex_state = 2},
  [457] = {.lex_state = 2},
  [458] = {.lex_state = 2},
  [459] = {.lex_state = 2},
  [460] = {.lex_state = 2},
  [461] = {.lex_state = 2},
  [462] = {.lex_state = 2},
  [463] = {.lex_state = 2},
  [464] = {.lex_state = 2},
  [465] = {.lex_state = 2},
  [466] = {.lex_state = 2},
  [467] = {.lex_state = 2},
  [468] = {.lex_state = 2},
  [469] = {.lex_state = 2},
  [470] = {.lex_state = 2},
  [471] = {.lex_state = 2},
  [472] = {.lex_state = 2},
  [473] = {.lex_state = 2},
  [474] = {.lex_state = 2},
  [475] = {.lex_state = 2},
  [476] = {.lex_state = 2},
  [477] = {.lex_state = 2},
  [478] = {.lex_state = 2},
  [479] = {.lex_state = 2},
  [480] = {.lex_state = 2},
  [481] = {.lex_state = 2},
  [482] = {.lex_state = 2},
  [483] = {.lex_state = 2},
  [484] = {.lex_state = 2},
  [485] = {.lex_state = 2},
  [486] = {.lex_state = 2},
  [487] = {.lex_state = 2},
  [488] = {.lex_state = 2},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 2},
  [491] = {.lex_state = 2},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 2},
  [494] = {.lex_state = 2},
  [495] = {.lex_state = 2},
  [496] = {.lex_state = 10},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 10},
  [499] = {.lex_state = 2},
  [500] = {.lex_state = 10},
  [501] = {.lex_state = 10},
  [502] = {.lex_state = 10},
  [503] = {.lex_state = 10},
  [504] = {.lex_state = 10},
  [505] = {.lex_state = 10},
  [506] = {.lex_state = 10},
  [507] = {.lex_state = 10},
  [508] = {.lex_state = 10},
  [509] = {.lex_state = 10},
  [510] = {.lex_state = 10},
  [511] = {.lex_state = 10},
  [512] = {.lex_state = 10},
  [513] = {.lex_state = 10},
  [514] = {.lex_state = 10},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 10},
  [517] = {.lex_state = 10},
  [518] = {.lex_state = 10},
  [519] = {.lex_state = 10},
  [520] = {.lex_state = 10},
  [521] = {.lex_state = 10},
  [522] = {.lex_state = 10},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 10},
  [525] = {.lex_state = 10},
  [526] = {.lex_state = 10},
  [527] = {.lex_state = 10},
  [528] = {.lex_state = 10},
  [529] = {.lex_state = 10},
  [530] = {.lex_state = 10},
  [531] = {.lex_state = 10},
  [532] = {.lex_state = 10},
  [533] = {.lex_state = 10},
  [534] = {.lex_state = 10},
  [535] = {.lex_state = 10},
  [536] = {.lex_state = 10},
  [537] = {.lex_state = 10},
  [538] = {.lex_state = 10},
  [539] = {.lex_state = 10},
  [540] = {.lex_state = 10},
  [541] = {.lex_state = 10},
  [542] = {.lex_state = 2},
  [543] = {.lex_state = 10},
  [544] = {.lex_state = 2},
  [545] = {.lex_state = 10},
  [546] = {.lex_state = 10},
  [547] = {.lex_state = 10},
  [548] = {.lex_state = 10},
  [549] = {.lex_state = 10},
  [550] = {.lex_state = 10},
  [551] = {.lex_state = 2},
  [552] = {.lex_state = 10},
  [553] = {.lex_state = 10},
  [554] = {.lex_state = 10},
  [555] = {.lex_state = 10},
  [556] = {.lex_state = 10},
  [557] = {.lex_state = 10},
  [558] = {.lex_state = 10},
  [559] = {.lex_state = 10},
  [560] = {.lex_state = 10},
  [561] = {.lex_state = 10},
  [562] = {.lex_state = 10},
  [563] = {.lex_state = 10},
  [564] = {.lex_state = 10},
  [565] = {.lex_state = 10},
  [566] = {.lex_state = 10},
  [567] = {.lex_state = 10},
  [568] = {.lex_state = 10},
  [569] = {.lex_state = 10},
  [570] = {.lex_state = 10},
  [571] = {.lex_state = 10},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 10},
  [575] = {.lex_state = 10},
  [576] = {.lex_state = 10},
  [577] = {.lex_state = 10},
  [578] = {.lex_state = 15},
  [579] = {.lex_state = 10},
  [580] = {.lex_state = 10},
  [581] = {.lex_state = 55},
  [582] = {.lex_state = 20},
  [583] = {.lex_state = 20},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 55},
  [586] = {.lex_state = 20},
  [587] = {.lex_state = 2},
  [588] = {.lex_state = 20},
  [589] = {.lex_state = 2},
  [590] = {.lex_state = 20},
  [591] = {.lex_state = 2},
  [592] = {.lex_state = 2},
  [593] = {.lex_state = 3},
  [594] = {.lex_state = 3},
  [595] = {.lex_state = 20},
  [596] = {.lex_state = 20},
  [597] = {.lex_state = 2},
  [598] = {.lex_state = 2},
  [599] = {.lex_state = 3},
  [600] = {.lex_state = 2},
  [601] = {.lex_state = 55},
  [602] = {.lex_state = 3},
  [603] = {.lex_state = 55},
  [604] = {.lex_state = 2},
  [605] = {.lex_state = 55},
  [606] = {.lex_state = 20},
  [607] = {.lex_state = 55},
  [608] = {.lex_state = 2},
  [609] = {.lex_state = 55},
  [610] = {.lex_state = 2},
  [611] = {.lex_state = 2},
  [612] = {.lex_state = 55},
  [613] = {.lex_state = 55},
  [614] = {.lex_state = 55},
  [615] = {.lex_state = 2},
  [616] = {.lex_state = 2},
  [617] = {.lex_state = 55},
  [618] = {.lex_state = 2},
  [619] = {.lex_state = 2},
  [620] = {.lex_state = 2},
  [621] = {.lex_state = 55},
  [622] = {.lex_state = 55},
  [623] = {.lex_state = 2},
  [624] = {.lex_state = 55},
  [625] = {.lex_state = 55},
  [626] = {.lex_state = 2},
  [627] = {.lex_state = 20},
  [628] = {.lex_state = 55},
  [629] = {.lex_state = 2},
  [630] = {.lex_state = 2},
  [631] = {.lex_state = 2},
  [632] = {.lex_state = 55},
  [633] = {.lex_state = 3},
  [634] = {.lex_state = 55},
  [635] = {.lex_state = 2},
  [636] = {.lex_state = 55},
  [637] = {.lex_state = 2},
  [638] = {.lex_state = 16},
  [639] = {.lex_state = 2},
  [640] = {.lex_state = 55},
  [641] = {.lex_state = 2},
  [642] = {.lex_state = 2},
  [643] = {.lex_state = 3},
  [644] = {.lex_state = 55},
  [645] = {.lex_state = 3},
  [646] = {.lex_state = 15},
  [647] = {.lex_state = 55},
  [648] = {.lex_state = 55},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 55},
  [651] = {.lex_state = 55},
  [652] = {.lex_state = 55},
  [653] = {.lex_state = 55},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 55},
  [656] = {.lex_state = 55},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 2},
  [660] = {.lex_state = 55},
  [661] = {.lex_state = 2},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 55},
  [664] = {.lex_state = 55},
  [665] = {.lex_state = 2},
  [666] = {.lex_state = 55},
  [667] = {.lex_state = 2},
  [668] = {.lex_state = 3},
  [669] = {.lex_state = 2},
  [670] = {.lex_state = 20},
  [671] = {.lex_state = 2},
  [672] = {.lex_state = 3},
  [673] = {.lex_state = 3},
  [674] = {.lex_state = 2},
  [675] = {.lex_state = 2},
  [676] = {.lex_state = 55},
  [677] = {.lex_state = 2},
  [678] = {.lex_state = 2},
  [679] = {.lex_state = 55},
  [680] = {.lex_state = 3},
  [681] = {.lex_state = 2},
  [682] = {.lex_state = 3},
  [683] = {.lex_state = 2},
  [684] = {.lex_state = 2},
  [685] = {.lex_state = 55},
  [686] = {.lex_state = 2},
  [687] = {.lex_state = 2},
  [688] = {.lex_state = 2},
  [689] = {.lex_state = 55},
  [690] = {.lex_state = 55},
  [691] = {.lex_state = 2},
  [692] = {.lex_state = 55},
  [693] = {.lex_state = 3},
  [694] = {.lex_state = 2},
  [695] = {.lex_state = 2},
  [696] = {.lex_state = 15},
  [697] = {.lex_state = 55},
  [698] = {.lex_state = 2},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 2},
  [701] = {.lex_state = 2},
  [702] = {.lex_state = 55},
  [703] = {.lex_state = 55},
  [704] = {.lex_state = 2},
  [705] = {.lex_state = 3},
  [706] = {.lex_state = 55},
  [707] = {.lex_state = 2},
  [708] = {.lex_state = 14},
  [709] = {.lex_state = 2},
  [710] = {.lex_state = 3},
  [711] = {.lex_state = 2},
  [712] = {.lex_state = 2},
  [713] = {.lex_state = 2},
  [714] = {.lex_state = 2},
  [715] = {.lex_state = 2},
  [716] = {.lex_state = 2},
  [717] = {.lex_state = 2},
  [718] = {.lex_state = 2},
  [719] = {.lex_state = 2},
  [720] = {.lex_state = 2},
  [721] = {.lex_state = 3},
  [722] = {.lex_state = 3},
  [723] = {.lex_state = 2},
  [724] = {.lex_state = 2},
  [725] = {.lex_state = 2},
  [726] = {.lex_state = 2},
  [727] = {.lex_state = 3},
  [728] = {.lex_state = 15},
  [729] = {.lex_state = 3},
  [730] = {.lex_state = 2},
  [731] = {.lex_state = 15},
  [732] = {.lex_state = 3},
  [733] = {.lex_state = 2},
  [734] = {.lex_state = 2},
  [735] = {.lex_state = 3},
  [736] = {.lex_state = 3},
  [737] = {.lex_state = 2},
  [738] = {.lex_state = 2},
  [739] = {.lex_state = 2},
  [740] = {.lex_state = 2},
  [741] = {.lex_state = 2},
  [742] = {.lex_state = 2},
  [743] = {.lex_state = 2},
  [744] = {.lex_state = 14},
  [745] = {.lex_state = 15},
  [746] = {.lex_state = 14},
  [747] = {.lex_state = 14},
  [748] = {.lex_state = 2},
  [749] = {.lex_state = 2},
  [750] = {.lex_state = 2},
  [751] = {.lex_state = 2},
  [752] = {.lex_state = 3},
  [753] = {.lex_state = 3},
  [754] = {.lex_state = 2},
  [755] = {.lex_state = 3},
  [756] = {.lex_state = 3},
  [757] = {.lex_state = 2},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 3},
  [761] = {.lex_state = 2},
  [762] = {.lex_state = 3},
  [763] = {.lex_state = 3},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 2},
  [766] = {.lex_state = 3},
  [767] = {.lex_state = 2},
  [768] = {.lex_state = 3},
  [769] = {.lex_state = 2},
  [770] = {.lex_state = 2},
  [771] = {.lex_state = 2},
  [772] = {.lex_state = 2},
  [773] = {.lex_state = 2},
  [774] = {.lex_state = 3},
  [775] = {.lex_state = 15},
  [776] = {.lex_state = 3},
  [777] = {.lex_state = 2},
  [778] = {.lex_state = 2},
  [779] = {.lex_state = 2},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 2},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 3},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 3},
  [788] = {.lex_state = 3},
  [789] = {.lex_state = 3},
  [790] = {.lex_state = 3},
  [791] = {.lex_state = 3},
  [792] = {.lex_state = 3},
  [793] = {.lex_state = 3},
  [794] = {.lex_state = 3},
  [795] = {.lex_state = 3},
  [796] = {.lex_state = 3},
  [797] = {.lex_state = 3},
  [798] = {.lex_state = 3},
  [799] = {.lex_state = 3},
  [800] = {.lex_state = 3},
  [801] = {.lex_state = 3},
  [802] = {.lex_state = 3},
  [803] = {.lex_state = 3},
  [804] = {.lex_state = 3},
  [805] = {.lex_state = 3},
  [806] = {.lex_state = 3},
  [807] = {.lex_state = 3},
  [808] = {.lex_state = 3},
  [809] = {.lex_state = 55},
  [810] = {.lex_state = 3},
  [811] = {.lex_state = 3},
  [812] = {.lex_state = 3},
  [813] = {.lex_state = 3},
  [814] = {.lex_state = 3},
  [815] = {.lex_state = 3},
  [816] = {.lex_state = 3},
  [817] = {.lex_state = 3},
  [818] = {.lex_state = 3},
  [819] = {.lex_state = 3},
  [820] = {.lex_state = 3},
  [821] = {.lex_state = 3},
  [822] = {.lex_state = 3},
  [823] = {.lex_state = 3},
  [824] = {.lex_state = 3},
  [825] = {.lex_state = 3},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 3},
  [828] = {.lex_state = 15},
  [829] = {.lex_state = 3},
  [830] = {.lex_state = 55},
  [831] = {.lex_state = 55},
  [832] = {.lex_state = 55},
  [833] = {.lex_state = 55},
  [834] = {.lex_state = 55},
  [835] = {.lex_state = 55},
  [836] = {.lex_state = 55},
  [837] = {.lex_state = 20},
  [838] = {.lex_state = 20},
  [839] = {.lex_state = 55},
  [840] = {.lex_state = 55},
  [841] = {.lex_state = 55},
  [842] = {.lex_state = 55},
  [843] = {.lex_state = 55},
  [844] = {.lex_state = 55},
  [845] = {.lex_state = 55},
  [846] = {.lex_state = 55},
  [847] = {.lex_state = 55},
  [848] = {.lex_state = 55},
  [849] = {.lex_state = 55},
  [850] = {.lex_state = 55},
  [851] = {.lex_state = 55},
  [852] = {.lex_state = 55},
  [853] = {.lex_state = 8},
  [854] = {.lex_state = 8},
  [855] = {.lex_state = 8},
  [856] = {.lex_state = 8},
  [857] = {.lex_state = 8},
  [858] = {.lex_state = 8},
  [859] = {.lex_state = 8},
  [860] = {.lex_state = 8},
  [861] = {.lex_state = 8},
  [862] = {.lex_state = 8},
  [863] = {.lex_state = 8},
  [864] = {.lex_state = 8},
  [865] = {.lex_state = 8},
  [866] = {.lex_state = 58},
  [867] = {.lex_state = 58},
  [868] = {.lex_state = 58},
  [869] = {.lex_state = 58},
  [870] = {.lex_state = 8},
  [871] = {.lex_state = 8},
  [872] = {.lex_state = 8},
  [873] = {.lex_state = 8},
  [874] = {.lex_state = 8},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 8},
  [878] = {.lex_state = 8},
  [879] = {.lex_state = 8},
  [880] = {.lex_state = 9},
  [881] = {.lex_state = 8},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 21},
  [884] = {.lex_state = 8},
  [885] = {.lex_state = 8},
  [886] = {.lex_state = 9},
  [887] = {.lex_state = 8},
  [888] = {.lex_state = 9},
  [889] = {.lex_state = 9},
  [890] = {.lex_state = 21},
  [891] = {.lex_state = 58},
  [892] = {.lex_state = 8},
  [893] = {.lex_state = 21},
  [894] = {.lex_state = 249},
  [895] = {.lex_state = 22},
  [896] = {.lex_state = 249},
  [897] = {.lex_state = 8},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 8},
  [900] = {.lex_state = 249},
  [901] = {.lex_state = 8},
  [902] = {.lex_state = 8},
  [903] = {.lex_state = 58},
  [904] = {.lex_state = 21},
  [905] = {.lex_state = 8},
  [906] = {.lex_state = 58},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 8},
  [910] = {.lex_state = 8},
  [911] = {.lex_state = 8},
  [912] = {.lex_state = 22},
  [913] = {.lex_state = 21},
  [914] = {.lex_state = 21},
  [915] = {.lex_state = 8},
  [916] = {.lex_state = 58},
  [917] = {.lex_state = 9},
  [918] = {.lex_state = 22},
  [919] = {.lex_state = 22},
  [920] = {.lex_state = 58},
  [921] = {.lex_state = 58},
  [922] = {.lex_state = 22},
  [923] = {.lex_state = 58},
  [924] = {.lex_state = 58},
  [925] = {.lex_state = 58},
  [926] = {.lex_state = 58},
  [927] = {.lex_state = 58},
  [928] = {.lex_state = 22},
  [929] = {.lex_state = 58},
  [930] = {.lex_state = 58},
  [931] = {.lex_state = 58},
  [932] = {.lex_state = 58},
  [933] = {.lex_state = 22},
  [934] = {.lex_state = 21},
  [935] = {.lex_state = 58},
  [936] = {.lex_state = 22},
  [937] = {.lex_state = 58},
  [938] = {.lex_state = 58},
  [939] = {.lex_state = 58},
  [940] = {.lex_state = 58},
  [941] = {.lex_state = 58},
  [942] = {.lex_state = 58},
  [943] = {.lex_state = 58},
  [944] = {.lex_state = 8},
  [945] = {.lex_state = 249},
  [946] = {.lex_state = 58},
  [947] = {.lex_state = 58},
  [948] = {.lex_state = 58},
  [949] = {.lex_state = 22},
  [950] = {.lex_state = 22},
  [951] = {.lex_state = 58},
  [952] = {.lex_state = 58},
  [953] = {.lex_state = 58},
  [954] = {.lex_state = 58},
  [955] = {.lex_state = 58},
  [956] = {.lex_state = 58},
  [957] = {.lex_state = 58},
  [958] = {.lex_state = 22},
  [959] = {.lex_state = 249},
  [960] = {.lex_state = 22},
  [961] = {.lex_state = 22},
  [962] = {.lex_state = 22},
  [963] = {.lex_state = 22},
  [964] = {.lex_state = 249},
  [965] = {.lex_state = 249},
  [966] = {.lex_state = 22},
  [967] = {.lex_state = 249},
  [968] = {.lex_state = 22},
  [969] = {.lex_state = 22},
  [970] = {.lex_state = 249},
  [971] = {.lex_state = 22},
  [972] = {.lex_state = 22},
  [973] = {.lex_state = 249},
  [974] = {.lex_state = 249},
  [975] = {.lex_state = 249},
  [976] = {.lex_state = 22},
  [977] = {.lex_state = 249},
  [978] = {.lex_state = 22},
  [979] = {.lex_state = 22},
  [980] = {.lex_state = 22},
  [981] = {.lex_state = 249},
  [982] = {.lex_state = 249},
  [983] = {.lex_state = 59},
  [984] = {.lex_state = 249},
  [985] = {.lex_state = 9},
  [986] = {.lex_state = 59},
  [987] = {.lex_state = 59},
  [988] = {.lex_state = 249},
  [989] = {.lex_state = 9},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 249},
  [992] = {.lex_state = 9},
  [993] = {.lex_state = 249},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 249},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 8},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 249},
  [1002] = {.lex_state = 9},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 249},
  [1005] = {.lex_state = 8},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 9},
  [1008] = {.lex_state = 9},
  [1009] = {.lex_state = 249},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 60},
  [1012] = {.lex_state = 249},
  [1013] = {.lex_state = 8},
  [1014] = {.lex_state = 60},
  [1015] = {.lex_state = 8},
  [1016] = {.lex_state = 8},
  [1017] = {.lex_state = 8},
  [1018] = {.lex_state = 60},
  [1019] = {.lex_state = 5},
  [1020] = {.lex_state = 249},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 8},
  [1023] = {.lex_state = 8},
  [1024] = {.lex_state = 8},
  [1025] = {.lex_state = 22},
  [1026] = {.lex_state = 5},
  [1027] = {.lex_state = 60},
  [1028] = {.lex_state = 58},
  [1029] = {.lex_state = 249},
  [1030] = {.lex_state = 8},
  [1031] = {.lex_state = 249},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 249},
  [1034] = {.lex_state = 8},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 58},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 249},
  [1039] = {.lex_state = 5},
  [1040] = {.lex_state = 8},
  [1041] = {.lex_state = 59},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 8},
  [1044] = {.lex_state = 8},
  [1045] = {.lex_state = 21},
  [1046] = {.lex_state = 8},
  [1047] = {.lex_state = 4},
  [1048] = {.lex_state = 5},
  [1049] = {.lex_state = 4},
  [1050] = {.lex_state = 58},
  [1051] = {.lex_state = 249},
  [1052] = {.lex_state = 8},
  [1053] = {.lex_state = 21},
  [1054] = {.lex_state = 5},
  [1055] = {.lex_state = 249},
  [1056] = {.lex_state = 5},
  [1057] = {.lex_state = 58},
  [1058] = {.lex_state = 8},
  [1059] = {.lex_state = 5},
  [1060] = {.lex_state = 5},
  [1061] = {.lex_state = 60},
  [1062] = {.lex_state = 58},
  [1063] = {.lex_state = 249},
  [1064] = {.lex_state = 60},
  [1065] = {.lex_state = 249},
  [1066] = {.lex_state = 249},
  [1067] = {.lex_state = 60},
  [1068] = {.lex_state = 5},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 249},
  [1071] = {.lex_state = 60},
  [1072] = {.lex_state = 5},
  [1073] = {.lex_state = 58},
  [1074] = {.lex_state = 58},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 249},
  [1078] = {.lex_state = 60},
  [1079] = {.lex_state = 249},
  [1080] = {.lex_state = 249},
  [1081] = {.lex_state = 60},
  [1082] = {.lex_state = 60},
  [1083] = {.lex_state = 59},
  [1084] = {.lex_state = 249},
  [1085] = {.lex_state = 59},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 59},
  [1088] = {.lex_state = 59},
  [1089] = {.lex_state = 58},
  [1090] = {.lex_state = 59},
  [1091] = {.lex_state = 59},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 59},
  [1094] = {.lex_state = 59},
  [1095] = {.lex_state = 249},
  [1096] = {.lex_state = 249},
  [1097] = {.lex_state = 59},
  [1098] = {.lex_state = 59},
  [1099] = {.lex_state = 59},
  [1100] = {.lex_state = 59},
  [1101] = {.lex_state = 59},
  [1102] = {.lex_state = 59},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 249},
  [1105] = {.lex_state = 249},
  [1106] = {.lex_state = 59},
  [1107] = {.lex_state = 249},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 249},
  [1110] = {.lex_state = 58},
  [1111] = {.lex_state = 5},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 5},
  [1114] = {.lex_state = 249},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 59},
  [1118] = {.lex_state = 59},
  [1119] = {.lex_state = 59},
  [1120] = {.lex_state = 59},
  [1121] = {.lex_state = 59},
  [1122] = {.lex_state = 59},
  [1123] = {.lex_state = 59},
  [1124] = {.lex_state = 59},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 59},
  [1127] = {.lex_state = 58},
  [1128] = {.lex_state = 59},
  [1129] = {.lex_state = 59},
  [1130] = {.lex_state = 59},
  [1131] = {.lex_state = 59},
  [1132] = {.lex_state = 249},
  [1133] = {.lex_state = 59},
  [1134] = {.lex_state = 59},
  [1135] = {.lex_state = 59},
  [1136] = {.lex_state = 249},
  [1137] = {.lex_state = 59},
  [1138] = {.lex_state = 249},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 60},
  [1141] = {.lex_state = 59},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 58},
  [1144] = {.lex_state = 59},
  [1145] = {.lex_state = 58},
  [1146] = {.lex_state = 5},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 58},
  [1149] = {.lex_state = 5},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 5},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 58},
  [1154] = {.lex_state = 59},
  [1155] = {.lex_state = 59},
  [1156] = {.lex_state = 59},
  [1157] = {.lex_state = 9},
  [1158] = {.lex_state = 249},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 249},
  [1162] = {.lex_state = 14},
  [1163] = {.lex_state = 5},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 249},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 9},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 9},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 21},
  [1177] = {.lex_state = 9},
  [1178] = {.lex_state = 9},
  [1179] = {.lex_state = 9},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 9},
  [1182] = {.lex_state = 9},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 249},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 60},
  [1188] = {.lex_state = 249},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 9},
  [1193] = {.lex_state = 9},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 249},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 9},
  [1198] = {.lex_state = 9},
  [1199] = {.lex_state = 14},
  [1200] = {.lex_state = 249},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 22},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 9},
  [1206] = {.lex_state = 249},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 9},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 9},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 249},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 9},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 249},
  [1225] = {.lex_state = 249},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 14},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 249},
  [1242] = {.lex_state = 249},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 249},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 9},
  [1247] = {.lex_state = 249},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 249},
  [1250] = {.lex_state = 249},
  [1251] = {.lex_state = 5},
  [1252] = {.lex_state = 9},
  [1253] = {.lex_state = 9},
  [1254] = {.lex_state = 249},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 249},
  [1257] = {.lex_state = 249},
  [1258] = {.lex_state = 9},
  [1259] = {.lex_state = 9},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 9},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 14},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 9},
  [1276] = {.lex_state = 9},
  [1277] = {.lex_state = 249},
  [1278] = {.lex_state = 249},
  [1279] = {.lex_state = 9},
  [1280] = {.lex_state = 249},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 9},
  [1284] = {.lex_state = 9},
  [1285] = {.lex_state = 9},
  [1286] = {.lex_state = 9},
  [1287] = {.lex_state = 9},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 249},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 249},
  [1292] = {.lex_state = 9},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 9},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 5},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 9},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 9},
  [1312] = {.lex_state = 5},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 249},
  [1316] = {.lex_state = 249},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 9},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 249},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 14},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 9},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 5},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 5},
  [1340] = {.lex_state = 9},
  [1341] = {.lex_state = 9},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 9},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 14},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 59},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 8},
  [1357] = {.lex_state = 249},
  [1358] = {.lex_state = 8},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 8},
  [1362] = {.lex_state = 8},
  [1363] = {.lex_state = 249},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 249},
  [1366] = {.lex_state = 249},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 58},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 59},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 249},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 57},
  [1379] = {.lex_state = 249},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 249},
  [1382] = {.lex_state = 249},
  [1383] = {.lex_state = 59},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 249},
  [1386] = {.lex_state = 249},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 58},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 249},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 21},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 249},
  [1402] = {.lex_state = 59},
  [1403] = {.lex_state = 249},
  [1404] = {.lex_state = 59},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 249},
  [1408] = {.lex_state = 59},
  [1409] = {.lex_state = 59},
  [1410] = {.lex_state = 249},
  [1411] = {.lex_state = 249},
  [1412] = {.lex_state = 59},
  [1413] = {.lex_state = 249},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 249},
  [1416] = {.lex_state = 0},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 59},
  [1422] = {.lex_state = 59},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 59},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 59},
  [1427] = {.lex_state = 59},
  [1428] = {.lex_state = 0},
  [1429] = {.lex_state = 59},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 0},
  [1434] = {.lex_state = 249},
  [1435] = {.lex_state = 249},
  [1436] = {.lex_state = 59},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 0},
  [1440] = {.lex_state = 59},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 249},
  [1443] = {.lex_state = 59},
  [1444] = {.lex_state = 8},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 59},
  [1447] = {.lex_state = 249},
  [1448] = {.lex_state = 59},
  [1449] = {.lex_state = 249},
  [1450] = {.lex_state = 0},
  [1451] = {.lex_state = 249},
  [1452] = {.lex_state = 21},
  [1453] = {.lex_state = 249},
  [1454] = {.lex_state = 0},
  [1455] = {.lex_state = 59},
  [1456] = {.lex_state = 59},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 59},
  [1461] = {.lex_state = 0},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 59},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 59},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 0},
  [1468] = {.lex_state = 58},
  [1469] = {.lex_state = 8},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 249},
  [1472] = {.lex_state = 59},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 59},
  [1475] = {.lex_state = 59},
  [1476] = {.lex_state = 59},
  [1477] = {.lex_state = 249},
  [1478] = {.lex_state = 249},
  [1479] = {.lex_state = 8},
  [1480] = {.lex_state = 59},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 249},
  [1484] = {.lex_state = 59},
  [1485] = {.lex_state = 249},
  [1486] = {.lex_state = 59},
  [1487] = {.lex_state = 59},
  [1488] = {.lex_state = 59},
  [1489] = {.lex_state = 4},
  [1490] = {.lex_state = 249},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 14},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 57},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 0},
  [1500] = {.lex_state = 57},
  [1501] = {.lex_state = 57},
  [1502] = {.lex_state = 0},
  [1503] = {.lex_state = 10},
  [1504] = {.lex_state = 10},
  [1505] = {.lex_state = 57},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 57},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 0},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 57},
  [1513] = {.lex_state = 57},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 57},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 57},
  [1523] = {.lex_state = 57},
  [1524] = {.lex_state = 57},
  [1525] = {.lex_state = 57},
  [1526] = {.lex_state = 57},
  [1527] = {.lex_state = 57},
  [1528] = {.lex_state = 10},
  [1529] = {.lex_state = 57},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 57},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 408},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 57},
  [1538] = {.lex_state = 10},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 57},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 57},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 57},
  [1554] = {.lex_state = 57},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 57},
  [1558] = {.lex_state = 57},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 14},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 57},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 57},
  [1571] = {.lex_state = 4},
  [1572] = {.lex_state = 10},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 14},
  [1575] = {.lex_state = 57},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 57},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 14},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 57},
  [1591] = {.lex_state = 14},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 57},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 57},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 408},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 57},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 408},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 57},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 408},
  [1617] = {.lex_state = 57},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0},
  [1621] = {.lex_state = 408},
  [1622] = {.lex_state = 57},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 57},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 57},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 14},
  [1631] = {.lex_state = 14},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 57},
  [1634] = {.lex_state = 0},
  [1635] = {.lex_state = 14},
  [1636] = {.lex_state = 0},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 14},
  [1639] = {.lex_state = 0},
  [1640] = {.lex_state = 249},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 0},
  [1644] = {.lex_state = 14},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 57},
  [1648] = {.lex_state = 57},
  [1649] = {.lex_state = 57},
  [1650] = {.lex_state = 57},
  [1651] = {.lex_state = 57},
  [1652] = {.lex_state = 57},
  [1653] = {.lex_state = 57},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_impl] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_u128] = ACTIONS(1),
    [anon_sym_i128] = ACTIONS(1),
    [anon_sym_usize] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_ByteArray] = ACTIONS(1),
    [anon_sym_felt252] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_nopanic] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [sym_numeric_literal] = ACTIONS(1),
    [aux_sym_string_literal_token1] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_shortstring_literal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LT2] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [sym_mutable_specifier] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_crate] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1605),
    [sym__statement] = STATE(11),
    [sym_impl_item] = STATE(11),
    [sym_trait_item] = STATE(11),
    [sym_associated_type] = STATE(11),
    [sym_associated_impl] = STATE(11),
    [sym_const_item] = STATE(11),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(11),
    [sym_attribute_item] = STATE(11),
    [sym_inner_attribute_item] = STATE(11),
    [sym_mod_item] = STATE(11),
    [sym_struct_item] = STATE(11),
    [sym_enum_item] = STATE(11),
    [sym_type_item] = STATE(11),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(11),
    [sym_function_item] = STATE(11),
    [sym_function_signature_item] = STATE(11),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(11),
    [sym_use_declaration] = STATE(11),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(11),
    [sym_expression] = STATE(761),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(618),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(681),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(658),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(85),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__statement] = STATE(2),
    [sym_impl_item] = STATE(2),
    [sym_trait_item] = STATE(2),
    [sym_associated_type] = STATE(2),
    [sym_associated_impl] = STATE(2),
    [sym_const_item] = STATE(2),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(2),
    [sym_attribute_item] = STATE(2),
    [sym_inner_attribute_item] = STATE(2),
    [sym_mod_item] = STATE(2),
    [sym_struct_item] = STATE(2),
    [sym_enum_item] = STATE(2),
    [sym_type_item] = STATE(2),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(2),
    [sym_function_item] = STATE(2),
    [sym_function_signature_item] = STATE(2),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(2),
    [sym_use_declaration] = STATE(2),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(2),
    [sym_expression] = STATE(615),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(2),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__statement] = STATE(3),
    [sym_impl_item] = STATE(3),
    [sym_trait_item] = STATE(3),
    [sym_associated_type] = STATE(3),
    [sym_associated_impl] = STATE(3),
    [sym_const_item] = STATE(3),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(3),
    [sym_attribute_item] = STATE(3),
    [sym_inner_attribute_item] = STATE(3),
    [sym_mod_item] = STATE(3),
    [sym_struct_item] = STATE(3),
    [sym_enum_item] = STATE(3),
    [sym_type_item] = STATE(3),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(3),
    [sym_function_item] = STATE(3),
    [sym_function_signature_item] = STATE(3),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(3),
    [sym_use_declaration] = STATE(3),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(3),
    [sym_expression] = STATE(662),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(3),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__statement] = STATE(8),
    [sym_impl_item] = STATE(8),
    [sym_trait_item] = STATE(8),
    [sym_associated_type] = STATE(8),
    [sym_associated_impl] = STATE(8),
    [sym_const_item] = STATE(8),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(8),
    [sym_attribute_item] = STATE(8),
    [sym_inner_attribute_item] = STATE(8),
    [sym_mod_item] = STATE(8),
    [sym_struct_item] = STATE(8),
    [sym_enum_item] = STATE(8),
    [sym_type_item] = STATE(8),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(8),
    [sym_function_item] = STATE(8),
    [sym_function_signature_item] = STATE(8),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(8),
    [sym_use_declaration] = STATE(8),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(8),
    [sym_expression] = STATE(626),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(8),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(91),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(654),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(4),
    [sym_impl_item] = STATE(4),
    [sym_trait_item] = STATE(4),
    [sym_associated_type] = STATE(4),
    [sym_associated_impl] = STATE(4),
    [sym_const_item] = STATE(4),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(4),
    [sym_attribute_item] = STATE(4),
    [sym_inner_attribute_item] = STATE(4),
    [sym_mod_item] = STATE(4),
    [sym_struct_item] = STATE(4),
    [sym_enum_item] = STATE(4),
    [sym_type_item] = STATE(4),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(4),
    [sym_function_item] = STATE(4),
    [sym_function_signature_item] = STATE(4),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(4),
    [sym_use_declaration] = STATE(4),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(4),
    [sym_expression] = STATE(657),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(4),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(604),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(16),
    [sym_impl_item] = STATE(16),
    [sym_trait_item] = STATE(16),
    [sym_associated_type] = STATE(16),
    [sym_associated_impl] = STATE(16),
    [sym_const_item] = STATE(16),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(16),
    [sym_attribute_item] = STATE(16),
    [sym_inner_attribute_item] = STATE(16),
    [sym_mod_item] = STATE(16),
    [sym_struct_item] = STATE(16),
    [sym_enum_item] = STATE(16),
    [sym_type_item] = STATE(16),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(16),
    [sym_function_item] = STATE(16),
    [sym_function_signature_item] = STATE(16),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(16),
    [sym_use_declaration] = STATE(16),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(16),
    [sym_expression] = STATE(761),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(102),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(761),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(104),
    [anon_sym_impl] = ACTIONS(106),
    [anon_sym_SEMI] = ACTIONS(109),
    [anon_sym_trait] = ACTIONS(112),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(118),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(124),
    [anon_sym_LBRACK] = ACTIONS(127),
    [anon_sym_mod] = ACTIONS(130),
    [anon_sym_struct] = ACTIONS(133),
    [anon_sym_enum] = ACTIONS(136),
    [anon_sym_fn] = ACTIONS(139),
    [anon_sym_let] = ACTIONS(142),
    [anon_sym_use] = ACTIONS(145),
    [anon_sym_COLON_COLON] = ACTIONS(148),
    [anon_sym_STAR] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(151),
    [anon_sym_u8] = ACTIONS(154),
    [anon_sym_i8] = ACTIONS(154),
    [anon_sym_u16] = ACTIONS(154),
    [anon_sym_i16] = ACTIONS(154),
    [anon_sym_u32] = ACTIONS(154),
    [anon_sym_i32] = ACTIONS(154),
    [anon_sym_u64] = ACTIONS(154),
    [anon_sym_i64] = ACTIONS(154),
    [anon_sym_u128] = ACTIONS(154),
    [anon_sym_i128] = ACTIONS(154),
    [anon_sym_usize] = ACTIONS(154),
    [anon_sym_bool] = ACTIONS(154),
    [anon_sym_ByteArray] = ACTIONS(154),
    [anon_sym_felt252] = ACTIONS(154),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_AT] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(160),
    [anon_sym_continue] = ACTIONS(163),
    [anon_sym_default] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_extern] = ACTIONS(172),
    [anon_sym_loop] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(178),
    [anon_sym_pub] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(190),
    [sym_numeric_literal] = ACTIONS(193),
    [aux_sym_string_literal_token1] = ACTIONS(196),
    [sym_shortstring_literal] = ACTIONS(199),
    [anon_sym_true] = ACTIONS(202),
    [anon_sym_false] = ACTIONS(202),
    [anon_sym_ref] = ACTIONS(205),
    [sym_identifier] = ACTIONS(208),
    [sym_super] = ACTIONS(211),
    [sym_line_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__statement] = STATE(14),
    [sym_impl_item] = STATE(14),
    [sym_trait_item] = STATE(14),
    [sym_associated_type] = STATE(14),
    [sym_associated_impl] = STATE(14),
    [sym_const_item] = STATE(14),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(14),
    [sym_attribute_item] = STATE(14),
    [sym_inner_attribute_item] = STATE(14),
    [sym_mod_item] = STATE(14),
    [sym_struct_item] = STATE(14),
    [sym_enum_item] = STATE(14),
    [sym_type_item] = STATE(14),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(14),
    [sym_function_item] = STATE(14),
    [sym_function_signature_item] = STATE(14),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(14),
    [sym_use_declaration] = STATE(14),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(14),
    [sym_expression] = STATE(620),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(623),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(18),
    [sym_impl_item] = STATE(18),
    [sym_trait_item] = STATE(18),
    [sym_associated_type] = STATE(18),
    [sym_associated_impl] = STATE(18),
    [sym_const_item] = STATE(18),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(18),
    [sym_attribute_item] = STATE(18),
    [sym_inner_attribute_item] = STATE(18),
    [sym_mod_item] = STATE(18),
    [sym_struct_item] = STATE(18),
    [sym_enum_item] = STATE(18),
    [sym_type_item] = STATE(18),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(18),
    [sym_function_item] = STATE(18),
    [sym_function_signature_item] = STATE(18),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(18),
    [sym_use_declaration] = STATE(18),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(18),
    [sym_expression] = STATE(641),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__statement] = STATE(16),
    [sym_impl_item] = STATE(16),
    [sym_trait_item] = STATE(16),
    [sym_associated_type] = STATE(16),
    [sym_associated_impl] = STATE(16),
    [sym_const_item] = STATE(16),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(16),
    [sym_attribute_item] = STATE(16),
    [sym_inner_attribute_item] = STATE(16),
    [sym_mod_item] = STATE(16),
    [sym_struct_item] = STATE(16),
    [sym_enum_item] = STATE(16),
    [sym_type_item] = STATE(16),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(16),
    [sym_function_item] = STATE(16),
    [sym_function_signature_item] = STATE(16),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(16),
    [sym_use_declaration] = STATE(16),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(16),
    [sym_expression] = STATE(761),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(104),
    [anon_sym_LBRACE] = ACTIONS(101),
    [anon_sym_impl] = ACTIONS(106),
    [anon_sym_SEMI] = ACTIONS(109),
    [anon_sym_trait] = ACTIONS(112),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(118),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(124),
    [anon_sym_LBRACK] = ACTIONS(127),
    [anon_sym_mod] = ACTIONS(130),
    [anon_sym_struct] = ACTIONS(133),
    [anon_sym_enum] = ACTIONS(136),
    [anon_sym_fn] = ACTIONS(139),
    [anon_sym_let] = ACTIONS(142),
    [anon_sym_use] = ACTIONS(145),
    [anon_sym_COLON_COLON] = ACTIONS(148),
    [anon_sym_STAR] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(151),
    [anon_sym_u8] = ACTIONS(154),
    [anon_sym_i8] = ACTIONS(154),
    [anon_sym_u16] = ACTIONS(154),
    [anon_sym_i16] = ACTIONS(154),
    [anon_sym_u32] = ACTIONS(154),
    [anon_sym_i32] = ACTIONS(154),
    [anon_sym_u64] = ACTIONS(154),
    [anon_sym_i64] = ACTIONS(154),
    [anon_sym_u128] = ACTIONS(154),
    [anon_sym_i128] = ACTIONS(154),
    [anon_sym_usize] = ACTIONS(154),
    [anon_sym_bool] = ACTIONS(154),
    [anon_sym_ByteArray] = ACTIONS(154),
    [anon_sym_felt252] = ACTIONS(154),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_AT] = ACTIONS(121),
    [anon_sym_break] = ACTIONS(160),
    [anon_sym_continue] = ACTIONS(163),
    [anon_sym_default] = ACTIONS(166),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_extern] = ACTIONS(172),
    [anon_sym_loop] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(178),
    [anon_sym_pub] = ACTIONS(181),
    [anon_sym_return] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(190),
    [sym_numeric_literal] = ACTIONS(193),
    [aux_sym_string_literal_token1] = ACTIONS(196),
    [sym_shortstring_literal] = ACTIONS(199),
    [anon_sym_true] = ACTIONS(202),
    [anon_sym_false] = ACTIONS(202),
    [anon_sym_ref] = ACTIONS(205),
    [sym_identifier] = ACTIONS(208),
    [sym_super] = ACTIONS(211),
    [sym_line_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(20),
    [sym_impl_item] = STATE(20),
    [sym_trait_item] = STATE(20),
    [sym_associated_type] = STATE(20),
    [sym_associated_impl] = STATE(20),
    [sym_const_item] = STATE(20),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(20),
    [sym_attribute_item] = STATE(20),
    [sym_inner_attribute_item] = STATE(20),
    [sym_mod_item] = STATE(20),
    [sym_struct_item] = STATE(20),
    [sym_enum_item] = STATE(20),
    [sym_type_item] = STATE(20),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(20),
    [sym_function_item] = STATE(20),
    [sym_function_signature_item] = STATE(20),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(20),
    [sym_use_declaration] = STATE(20),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(20),
    [sym_expression] = STATE(688),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(20),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(642),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__statement] = STATE(10),
    [sym_impl_item] = STATE(10),
    [sym_trait_item] = STATE(10),
    [sym_associated_type] = STATE(10),
    [sym_associated_impl] = STATE(10),
    [sym_const_item] = STATE(10),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(10),
    [sym_attribute_item] = STATE(10),
    [sym_inner_attribute_item] = STATE(10),
    [sym_mod_item] = STATE(10),
    [sym_struct_item] = STATE(10),
    [sym_enum_item] = STATE(10),
    [sym_type_item] = STATE(10),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(10),
    [sym_function_item] = STATE(10),
    [sym_function_signature_item] = STATE(10),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(10),
    [sym_use_declaration] = STATE(10),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(10),
    [sym_expression] = STATE(610),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(10),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__statement] = STATE(12),
    [sym_impl_item] = STATE(12),
    [sym_trait_item] = STATE(12),
    [sym_associated_type] = STATE(12),
    [sym_associated_impl] = STATE(12),
    [sym_const_item] = STATE(12),
    [sym_macro_invocation] = STATE(95),
    [sym_empty_statement] = STATE(12),
    [sym_attribute_item] = STATE(12),
    [sym_inner_attribute_item] = STATE(12),
    [sym_mod_item] = STATE(12),
    [sym_struct_item] = STATE(12),
    [sym_enum_item] = STATE(12),
    [sym_type_item] = STATE(12),
    [sym_extern_type] = STATE(340),
    [sym_external_function_item] = STATE(12),
    [sym_function_item] = STATE(12),
    [sym_function_signature_item] = STATE(12),
    [sym_function] = STATE(1166),
    [sym_let_declaration] = STATE(12),
    [sym_use_declaration] = STATE(12),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression_statement] = STATE(12),
    [sym_expression] = STATE(694),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(90),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(90),
    [sym_if_expression] = STATE(90),
    [sym_match_expression] = STATE(90),
    [sym_while_expression] = STATE(90),
    [sym_for_expression] = STATE(90),
    [sym_loop_expression] = STATE(90),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [sym_visibility_modifier] = STATE(875),
    [sym_extern] = STATE(1191),
    [aux_sym_source_file_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_impl] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_trait] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_struct] = ACTIONS(27),
    [anon_sym_enum] = ACTIONS(29),
    [anon_sym_fn] = ACTIONS(31),
    [anon_sym_let] = ACTIONS(33),
    [anon_sym_use] = ACTIONS(35),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_extern] = ACTIONS(53),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_pub] = ACTIONS(59),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(472),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(228),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(232),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(228),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(234),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_PERCENT] = ACTIONS(230),
    [anon_sym_CARET] = ACTIONS(228),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_AMP_AMP] = ACTIONS(228),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_GT_GT] = ACTIONS(228),
    [anon_sym_PLUS_EQ] = ACTIONS(228),
    [anon_sym_DASH_EQ] = ACTIONS(228),
    [anon_sym_STAR_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_PERCENT_EQ] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_BANG_EQ] = ACTIONS(228),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(228),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(462),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(232),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_RBRACK] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP_AMP] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_GT_GT] = ACTIONS(238),
    [anon_sym_PLUS_EQ] = ACTIONS(238),
    [anon_sym_DASH_EQ] = ACTIONS(238),
    [anon_sym_STAR_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_PERCENT_EQ] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_BANG_EQ] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(242),
    [anon_sym_RBRACE] = ACTIONS(245),
    [anon_sym_impl] = ACTIONS(247),
    [anon_sym_SEMI] = ACTIONS(250),
    [anon_sym_trait] = ACTIONS(247),
    [anon_sym_type] = ACTIONS(247),
    [anon_sym_COLON] = ACTIONS(253),
    [anon_sym_const] = ACTIONS(247),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(253),
    [anon_sym_POUND] = ACTIONS(250),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_RBRACK] = ACTIONS(245),
    [anon_sym_mod] = ACTIONS(247),
    [anon_sym_struct] = ACTIONS(247),
    [anon_sym_enum] = ACTIONS(247),
    [anon_sym_COMMA] = ACTIONS(250),
    [anon_sym_fn] = ACTIONS(247),
    [anon_sym_DASH_GT] = ACTIONS(250),
    [anon_sym_let] = ACTIONS(247),
    [anon_sym_use] = ACTIONS(247),
    [anon_sym_COLON_COLON] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym__] = ACTIONS(253),
    [anon_sym_RPAREN] = ACTIONS(245),
    [anon_sym_u8] = ACTIONS(262),
    [anon_sym_i8] = ACTIONS(262),
    [anon_sym_u16] = ACTIONS(262),
    [anon_sym_i16] = ACTIONS(262),
    [anon_sym_u32] = ACTIONS(262),
    [anon_sym_i32] = ACTIONS(262),
    [anon_sym_u64] = ACTIONS(262),
    [anon_sym_i64] = ACTIONS(262),
    [anon_sym_u128] = ACTIONS(262),
    [anon_sym_i128] = ACTIONS(262),
    [anon_sym_usize] = ACTIONS(262),
    [anon_sym_bool] = ACTIONS(262),
    [anon_sym_ByteArray] = ACTIONS(262),
    [anon_sym_felt252] = ACTIONS(262),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(253),
    [anon_sym_TILDE] = ACTIONS(250),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_AMP_AMP] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(250),
    [anon_sym_GT_GT] = ACTIONS(250),
    [anon_sym_PLUS_EQ] = ACTIONS(250),
    [anon_sym_DASH_EQ] = ACTIONS(250),
    [anon_sym_STAR_EQ] = ACTIONS(250),
    [anon_sym_SLASH_EQ] = ACTIONS(250),
    [anon_sym_PERCENT_EQ] = ACTIONS(250),
    [anon_sym_CARET_EQ] = ACTIONS(250),
    [anon_sym_AMP_EQ] = ACTIONS(250),
    [anon_sym_PIPE_EQ] = ACTIONS(250),
    [anon_sym_EQ_EQ] = ACTIONS(250),
    [anon_sym_BANG_EQ] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(250),
    [anon_sym_LT_EQ] = ACTIONS(250),
    [anon_sym_AT] = ACTIONS(250),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_EQ_GT] = ACTIONS(250),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_break] = ACTIONS(247),
    [anon_sym_continue] = ACTIONS(247),
    [anon_sym_default] = ACTIONS(247),
    [anon_sym_if] = ACTIONS(247),
    [anon_sym_extern] = ACTIONS(247),
    [anon_sym_nopanic] = ACTIONS(247),
    [anon_sym_loop] = ACTIONS(247),
    [anon_sym_match] = ACTIONS(247),
    [anon_sym_pub] = ACTIONS(247),
    [anon_sym_return] = ACTIONS(247),
    [anon_sym_static] = ACTIONS(247),
    [anon_sym_while] = ACTIONS(247),
    [anon_sym_for] = ACTIONS(247),
    [sym_numeric_literal] = ACTIONS(268),
    [aux_sym_string_literal_token1] = ACTIONS(271),
    [sym_shortstring_literal] = ACTIONS(274),
    [anon_sym_true] = ACTIONS(277),
    [anon_sym_false] = ACTIONS(277),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [sym_identifier] = ACTIONS(247),
    [sym_mutable_specifier] = ACTIONS(247),
    [sym_super] = ACTIONS(247),
    [sym_line_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_delim_token_tree] = STATE(28),
    [sym__delim_tokens] = STATE(28),
    [sym__literal] = STATE(28),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(28),
    [aux_sym_delim_token_tree_repeat1] = STATE(28),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_impl] = ACTIONS(287),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(287),
    [anon_sym_type] = ACTIONS(287),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(287),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(287),
    [anon_sym_struct] = ACTIONS(287),
    [anon_sym_enum] = ACTIONS(287),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(287),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(287),
    [anon_sym_use] = ACTIONS(287),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(287),
    [anon_sym_continue] = ACTIONS(287),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_if] = ACTIONS(287),
    [anon_sym_extern] = ACTIONS(287),
    [anon_sym_nopanic] = ACTIONS(287),
    [anon_sym_loop] = ACTIONS(287),
    [anon_sym_match] = ACTIONS(287),
    [anon_sym_pub] = ACTIONS(287),
    [anon_sym_return] = ACTIONS(287),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(287),
    [anon_sym_for] = ACTIONS(287),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [sym_identifier] = ACTIONS(287),
    [sym_mutable_specifier] = ACTIONS(287),
    [sym_super] = ACTIONS(287),
    [sym_line_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_delim_token_tree] = STATE(51),
    [sym__delim_tokens] = STATE(51),
    [sym__literal] = STATE(51),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(51),
    [aux_sym_delim_token_tree_repeat1] = STATE(51),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_impl] = ACTIONS(313),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(313),
    [anon_sym_type] = ACTIONS(313),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(313),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(313),
    [anon_sym_struct] = ACTIONS(313),
    [anon_sym_enum] = ACTIONS(313),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(313),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(313),
    [anon_sym_use] = ACTIONS(313),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(313),
    [anon_sym_continue] = ACTIONS(313),
    [anon_sym_default] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(313),
    [anon_sym_extern] = ACTIONS(313),
    [anon_sym_nopanic] = ACTIONS(313),
    [anon_sym_loop] = ACTIONS(313),
    [anon_sym_match] = ACTIONS(313),
    [anon_sym_pub] = ACTIONS(313),
    [anon_sym_return] = ACTIONS(313),
    [anon_sym_static] = ACTIONS(313),
    [anon_sym_while] = ACTIONS(313),
    [anon_sym_for] = ACTIONS(313),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(315),
    [sym_identifier] = ACTIONS(313),
    [sym_mutable_specifier] = ACTIONS(313),
    [sym_super] = ACTIONS(313),
    [sym_line_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(323),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(323),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_delim_token_tree] = STATE(33),
    [sym__delim_tokens] = STATE(33),
    [sym__literal] = STATE(33),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(33),
    [aux_sym_delim_token_tree_repeat1] = STATE(33),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(325),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(325),
    [anon_sym_type] = ACTIONS(325),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(325),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(325),
    [anon_sym_struct] = ACTIONS(325),
    [anon_sym_enum] = ACTIONS(325),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(325),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(325),
    [anon_sym_use] = ACTIONS(325),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(325),
    [anon_sym_continue] = ACTIONS(325),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_extern] = ACTIONS(325),
    [anon_sym_nopanic] = ACTIONS(325),
    [anon_sym_loop] = ACTIONS(325),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_pub] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(325),
    [anon_sym_static] = ACTIONS(325),
    [anon_sym_while] = ACTIONS(325),
    [anon_sym_for] = ACTIONS(325),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(329),
    [sym_identifier] = ACTIONS(325),
    [sym_mutable_specifier] = ACTIONS(325),
    [sym_super] = ACTIONS(325),
    [sym_line_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(331),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(331),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(323),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_delim_token_tree] = STATE(31),
    [sym__delim_tokens] = STATE(31),
    [sym__literal] = STATE(31),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(31),
    [aux_sym_delim_token_tree_repeat1] = STATE(31),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(333),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(333),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(333),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(333),
    [anon_sym_struct] = ACTIONS(333),
    [anon_sym_enum] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(333),
    [anon_sym_use] = ACTIONS(333),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(333),
    [anon_sym_continue] = ACTIONS(333),
    [anon_sym_default] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_extern] = ACTIONS(333),
    [anon_sym_nopanic] = ACTIONS(333),
    [anon_sym_loop] = ACTIONS(333),
    [anon_sym_match] = ACTIONS(333),
    [anon_sym_pub] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(333),
    [anon_sym_for] = ACTIONS(333),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(337),
    [sym_identifier] = ACTIONS(333),
    [sym_mutable_specifier] = ACTIONS(333),
    [sym_super] = ACTIONS(333),
    [sym_line_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_delim_token_tree] = STATE(32),
    [sym__delim_tokens] = STATE(32),
    [sym__literal] = STATE(32),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(32),
    [aux_sym_delim_token_tree_repeat1] = STATE(32),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(339),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(339),
    [anon_sym_type] = ACTIONS(339),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(339),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(335),
    [anon_sym_mod] = ACTIONS(339),
    [anon_sym_struct] = ACTIONS(339),
    [anon_sym_enum] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(339),
    [anon_sym_use] = ACTIONS(339),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(339),
    [anon_sym_continue] = ACTIONS(339),
    [anon_sym_default] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_extern] = ACTIONS(339),
    [anon_sym_nopanic] = ACTIONS(339),
    [anon_sym_loop] = ACTIONS(339),
    [anon_sym_match] = ACTIONS(339),
    [anon_sym_pub] = ACTIONS(339),
    [anon_sym_return] = ACTIONS(339),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(339),
    [anon_sym_for] = ACTIONS(339),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(341),
    [sym_identifier] = ACTIONS(339),
    [sym_mutable_specifier] = ACTIONS(339),
    [sym_super] = ACTIONS(339),
    [sym_line_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_delim_token_tree] = STATE(34),
    [sym__delim_tokens] = STATE(34),
    [sym__literal] = STATE(34),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(34),
    [aux_sym_delim_token_tree_repeat1] = STATE(34),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_impl] = ACTIONS(343),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(343),
    [anon_sym_struct] = ACTIONS(343),
    [anon_sym_enum] = ACTIONS(343),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(343),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(343),
    [anon_sym_use] = ACTIONS(343),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(343),
    [anon_sym_continue] = ACTIONS(343),
    [anon_sym_default] = ACTIONS(343),
    [anon_sym_if] = ACTIONS(343),
    [anon_sym_extern] = ACTIONS(343),
    [anon_sym_nopanic] = ACTIONS(343),
    [anon_sym_loop] = ACTIONS(343),
    [anon_sym_match] = ACTIONS(343),
    [anon_sym_pub] = ACTIONS(343),
    [anon_sym_return] = ACTIONS(343),
    [anon_sym_static] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_for] = ACTIONS(343),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(345),
    [sym_identifier] = ACTIONS(343),
    [sym_mutable_specifier] = ACTIONS(343),
    [sym_super] = ACTIONS(343),
    [sym_line_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_delim_token_tree] = STATE(29),
    [sym__delim_tokens] = STATE(29),
    [sym__literal] = STATE(29),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(29),
    [aux_sym_delim_token_tree_repeat1] = STATE(29),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(347),
    [anon_sym_type] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(347),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(327),
    [anon_sym_mod] = ACTIONS(347),
    [anon_sym_struct] = ACTIONS(347),
    [anon_sym_enum] = ACTIONS(347),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(347),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(347),
    [anon_sym_use] = ACTIONS(347),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(347),
    [anon_sym_continue] = ACTIONS(347),
    [anon_sym_default] = ACTIONS(347),
    [anon_sym_if] = ACTIONS(347),
    [anon_sym_extern] = ACTIONS(347),
    [anon_sym_nopanic] = ACTIONS(347),
    [anon_sym_loop] = ACTIONS(347),
    [anon_sym_match] = ACTIONS(347),
    [anon_sym_pub] = ACTIONS(347),
    [anon_sym_return] = ACTIONS(347),
    [anon_sym_static] = ACTIONS(347),
    [anon_sym_while] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(347),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(349),
    [sym_identifier] = ACTIONS(347),
    [sym_mutable_specifier] = ACTIONS(347),
    [sym_super] = ACTIONS(347),
    [sym_line_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_delim_token_tree] = STATE(50),
    [sym__delim_tokens] = STATE(50),
    [sym__literal] = STATE(50),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(50),
    [aux_sym_delim_token_tree_repeat1] = STATE(50),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(351),
    [anon_sym_type] = ACTIONS(351),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(351),
    [anon_sym_struct] = ACTIONS(351),
    [anon_sym_enum] = ACTIONS(351),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(351),
    [anon_sym_use] = ACTIONS(351),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(311),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(351),
    [anon_sym_continue] = ACTIONS(351),
    [anon_sym_default] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(351),
    [anon_sym_extern] = ACTIONS(351),
    [anon_sym_nopanic] = ACTIONS(351),
    [anon_sym_loop] = ACTIONS(351),
    [anon_sym_match] = ACTIONS(351),
    [anon_sym_pub] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(351),
    [anon_sym_static] = ACTIONS(351),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(351),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(353),
    [sym_identifier] = ACTIONS(351),
    [sym_mutable_specifier] = ACTIONS(351),
    [sym_super] = ACTIONS(351),
    [sym_line_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(355),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_delim_token_tree] = STATE(27),
    [sym__delim_tokens] = STATE(27),
    [sym__literal] = STATE(27),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(27),
    [aux_sym_delim_token_tree_repeat1] = STATE(27),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(327),
    [anon_sym_impl] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(357),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(357),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(357),
    [anon_sym_struct] = ACTIONS(357),
    [anon_sym_enum] = ACTIONS(357),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(357),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(357),
    [anon_sym_use] = ACTIONS(357),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(357),
    [anon_sym_continue] = ACTIONS(357),
    [anon_sym_default] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(357),
    [anon_sym_extern] = ACTIONS(357),
    [anon_sym_nopanic] = ACTIONS(357),
    [anon_sym_loop] = ACTIONS(357),
    [anon_sym_match] = ACTIONS(357),
    [anon_sym_pub] = ACTIONS(357),
    [anon_sym_return] = ACTIONS(357),
    [anon_sym_static] = ACTIONS(357),
    [anon_sym_while] = ACTIONS(357),
    [anon_sym_for] = ACTIONS(357),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(359),
    [sym_identifier] = ACTIONS(357),
    [sym_mutable_specifier] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_line_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_delim_token_tree] = STATE(53),
    [sym__delim_tokens] = STATE(53),
    [sym__literal] = STATE(53),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(53),
    [aux_sym_delim_token_tree_repeat1] = STATE(53),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(361),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(361),
    [anon_sym_type] = ACTIONS(361),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(361),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(311),
    [anon_sym_mod] = ACTIONS(361),
    [anon_sym_struct] = ACTIONS(361),
    [anon_sym_enum] = ACTIONS(361),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(361),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(361),
    [anon_sym_use] = ACTIONS(361),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(361),
    [anon_sym_continue] = ACTIONS(361),
    [anon_sym_default] = ACTIONS(361),
    [anon_sym_if] = ACTIONS(361),
    [anon_sym_extern] = ACTIONS(361),
    [anon_sym_nopanic] = ACTIONS(361),
    [anon_sym_loop] = ACTIONS(361),
    [anon_sym_match] = ACTIONS(361),
    [anon_sym_pub] = ACTIONS(361),
    [anon_sym_return] = ACTIONS(361),
    [anon_sym_static] = ACTIONS(361),
    [anon_sym_while] = ACTIONS(361),
    [anon_sym_for] = ACTIONS(361),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(363),
    [sym_identifier] = ACTIONS(361),
    [sym_mutable_specifier] = ACTIONS(361),
    [sym_super] = ACTIONS(361),
    [sym_line_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_delim_token_tree] = STATE(40),
    [sym__delim_tokens] = STATE(40),
    [sym__literal] = STATE(40),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(40),
    [aux_sym_delim_token_tree_repeat1] = STATE(40),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(365),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(365),
    [anon_sym_type] = ACTIONS(365),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(365),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(365),
    [anon_sym_struct] = ACTIONS(365),
    [anon_sym_enum] = ACTIONS(365),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(365),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_use] = ACTIONS(365),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(365),
    [anon_sym_continue] = ACTIONS(365),
    [anon_sym_default] = ACTIONS(365),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_extern] = ACTIONS(365),
    [anon_sym_nopanic] = ACTIONS(365),
    [anon_sym_loop] = ACTIONS(365),
    [anon_sym_match] = ACTIONS(365),
    [anon_sym_pub] = ACTIONS(365),
    [anon_sym_return] = ACTIONS(365),
    [anon_sym_static] = ACTIONS(365),
    [anon_sym_while] = ACTIONS(365),
    [anon_sym_for] = ACTIONS(365),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(369),
    [sym_identifier] = ACTIONS(365),
    [sym_mutable_specifier] = ACTIONS(365),
    [sym_super] = ACTIONS(365),
    [sym_line_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_delim_token_tree] = STATE(41),
    [sym__delim_tokens] = STATE(41),
    [sym__literal] = STATE(41),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(41),
    [aux_sym_delim_token_tree_repeat1] = STATE(41),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(371),
    [anon_sym_type] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(371),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(367),
    [anon_sym_mod] = ACTIONS(371),
    [anon_sym_struct] = ACTIONS(371),
    [anon_sym_enum] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(371),
    [anon_sym_use] = ACTIONS(371),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(371),
    [anon_sym_continue] = ACTIONS(371),
    [anon_sym_default] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_extern] = ACTIONS(371),
    [anon_sym_nopanic] = ACTIONS(371),
    [anon_sym_loop] = ACTIONS(371),
    [anon_sym_match] = ACTIONS(371),
    [anon_sym_pub] = ACTIONS(371),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_for] = ACTIONS(371),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(373),
    [sym_identifier] = ACTIONS(371),
    [sym_mutable_specifier] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_line_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_delim_token_tree] = STATE(42),
    [sym__delim_tokens] = STATE(42),
    [sym__literal] = STATE(42),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(42),
    [aux_sym_delim_token_tree_repeat1] = STATE(42),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(367),
    [anon_sym_impl] = ACTIONS(375),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(375),
    [anon_sym_type] = ACTIONS(375),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(375),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(375),
    [anon_sym_struct] = ACTIONS(375),
    [anon_sym_enum] = ACTIONS(375),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(375),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(375),
    [anon_sym_use] = ACTIONS(375),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(375),
    [anon_sym_continue] = ACTIONS(375),
    [anon_sym_default] = ACTIONS(375),
    [anon_sym_if] = ACTIONS(375),
    [anon_sym_extern] = ACTIONS(375),
    [anon_sym_nopanic] = ACTIONS(375),
    [anon_sym_loop] = ACTIONS(375),
    [anon_sym_match] = ACTIONS(375),
    [anon_sym_pub] = ACTIONS(375),
    [anon_sym_return] = ACTIONS(375),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_while] = ACTIONS(375),
    [anon_sym_for] = ACTIONS(375),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(377),
    [sym_identifier] = ACTIONS(375),
    [sym_mutable_specifier] = ACTIONS(375),
    [sym_super] = ACTIONS(375),
    [sym_line_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_delim_token_tree] = STATE(52),
    [sym__delim_tokens] = STATE(52),
    [sym__literal] = STATE(52),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(52),
    [aux_sym_delim_token_tree_repeat1] = STATE(52),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(379),
    [anon_sym_type] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(285),
    [anon_sym_mod] = ACTIONS(379),
    [anon_sym_struct] = ACTIONS(379),
    [anon_sym_enum] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(379),
    [anon_sym_use] = ACTIONS(379),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(379),
    [anon_sym_default] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_extern] = ACTIONS(379),
    [anon_sym_nopanic] = ACTIONS(379),
    [anon_sym_loop] = ACTIONS(379),
    [anon_sym_match] = ACTIONS(379),
    [anon_sym_pub] = ACTIONS(379),
    [anon_sym_return] = ACTIONS(379),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_while] = ACTIONS(379),
    [anon_sym_for] = ACTIONS(379),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(381),
    [sym_identifier] = ACTIONS(379),
    [sym_mutable_specifier] = ACTIONS(379),
    [sym_super] = ACTIONS(379),
    [sym_line_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_delim_token_tree] = STATE(26),
    [sym__delim_tokens] = STATE(26),
    [sym__literal] = STATE(26),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(26),
    [aux_sym_delim_token_tree_repeat1] = STATE(26),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(383),
    [anon_sym_type] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(383),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(383),
    [anon_sym_struct] = ACTIONS(383),
    [anon_sym_enum] = ACTIONS(383),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(383),
    [anon_sym_use] = ACTIONS(383),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(285),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(383),
    [anon_sym_continue] = ACTIONS(383),
    [anon_sym_default] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(383),
    [anon_sym_extern] = ACTIONS(383),
    [anon_sym_nopanic] = ACTIONS(383),
    [anon_sym_loop] = ACTIONS(383),
    [anon_sym_match] = ACTIONS(383),
    [anon_sym_pub] = ACTIONS(383),
    [anon_sym_return] = ACTIONS(383),
    [anon_sym_static] = ACTIONS(383),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_for] = ACTIONS(383),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(385),
    [sym_identifier] = ACTIONS(383),
    [sym_mutable_specifier] = ACTIONS(383),
    [sym_super] = ACTIONS(383),
    [sym_line_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_RBRACE] = ACTIONS(387),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(319),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_delim_token_tree] = STATE(23),
    [sym__delim_tokens] = STATE(23),
    [sym__literal] = STATE(23),
    [sym_negative_literal] = STATE(65),
    [sym_string_literal] = STATE(65),
    [sym_boolean_literal] = STATE(65),
    [sym__non_delim_token] = STATE(23),
    [aux_sym_delim_token_tree_repeat1] = STATE(23),
    [aux_sym__non_special_token_repeat1] = STATE(59),
    [anon_sym_LBRACE] = ACTIONS(283),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_type] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_BANG] = ACTIONS(291),
    [anon_sym_POUND] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_RBRACK] = ACTIONS(387),
    [anon_sym_mod] = ACTIONS(317),
    [anon_sym_struct] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(289),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_use] = ACTIONS(317),
    [anon_sym_COLON_COLON] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(291),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym__] = ACTIONS(291),
    [anon_sym_u8] = ACTIONS(297),
    [anon_sym_i8] = ACTIONS(297),
    [anon_sym_u16] = ACTIONS(297),
    [anon_sym_i16] = ACTIONS(297),
    [anon_sym_u32] = ACTIONS(297),
    [anon_sym_i32] = ACTIONS(297),
    [anon_sym_u64] = ACTIONS(297),
    [anon_sym_i64] = ACTIONS(297),
    [anon_sym_u128] = ACTIONS(297),
    [anon_sym_i128] = ACTIONS(297),
    [anon_sym_usize] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_ByteArray] = ACTIONS(297),
    [anon_sym_felt252] = ACTIONS(297),
    [anon_sym_LT] = ACTIONS(291),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_PLUS] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(291),
    [anon_sym_PERCENT] = ACTIONS(291),
    [anon_sym_CARET] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_AMP] = ACTIONS(291),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_LT_LT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(289),
    [anon_sym_PLUS_EQ] = ACTIONS(289),
    [anon_sym_DASH_EQ] = ACTIONS(289),
    [anon_sym_STAR_EQ] = ACTIONS(289),
    [anon_sym_SLASH_EQ] = ACTIONS(289),
    [anon_sym_PERCENT_EQ] = ACTIONS(289),
    [anon_sym_CARET_EQ] = ACTIONS(289),
    [anon_sym_AMP_EQ] = ACTIONS(289),
    [anon_sym_PIPE_EQ] = ACTIONS(289),
    [anon_sym_EQ_EQ] = ACTIONS(289),
    [anon_sym_BANG_EQ] = ACTIONS(289),
    [anon_sym_GT_EQ] = ACTIONS(289),
    [anon_sym_LT_EQ] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym_DOT] = ACTIONS(291),
    [anon_sym_EQ_GT] = ACTIONS(289),
    [anon_sym_QMARK] = ACTIONS(289),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_extern] = ACTIONS(317),
    [anon_sym_nopanic] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_pub] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [sym_numeric_literal] = ACTIONS(301),
    [aux_sym_string_literal_token1] = ACTIONS(303),
    [sym_shortstring_literal] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(321),
    [sym_identifier] = ACTIONS(317),
    [sym_mutable_specifier] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(760),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(391),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_PERCENT] = ACTIONS(230),
    [anon_sym_CARET] = ACTIONS(228),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_AMP_AMP] = ACTIONS(228),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_GT_GT] = ACTIONS(228),
    [anon_sym_PLUS_EQ] = ACTIONS(228),
    [anon_sym_DASH_EQ] = ACTIONS(228),
    [anon_sym_STAR_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_PERCENT_EQ] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_BANG_EQ] = ACTIONS(228),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_DOT] = ACTIONS(228),
    [anon_sym_EQ_GT] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(228),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(755),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(391),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP_AMP] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_GT_GT] = ACTIONS(238),
    [anon_sym_PLUS_EQ] = ACTIONS(238),
    [anon_sym_DASH_EQ] = ACTIONS(238),
    [anon_sym_STAR_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_PERCENT_EQ] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_BANG_EQ] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(757),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(238),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP_AMP] = ACTIONS(238),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_GT_GT] = ACTIONS(238),
    [anon_sym_PLUS_EQ] = ACTIONS(238),
    [anon_sym_DASH_EQ] = ACTIONS(238),
    [anon_sym_STAR_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_PERCENT_EQ] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_BANG_EQ] = ACTIONS(238),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_DOT] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(238),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(741),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(230),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_SLASH] = ACTIONS(230),
    [anon_sym_PERCENT] = ACTIONS(230),
    [anon_sym_CARET] = ACTIONS(228),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(230),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_AMP_AMP] = ACTIONS(228),
    [anon_sym_PIPE_PIPE] = ACTIONS(228),
    [anon_sym_LT_LT] = ACTIONS(228),
    [anon_sym_GT_GT] = ACTIONS(228),
    [anon_sym_PLUS_EQ] = ACTIONS(228),
    [anon_sym_DASH_EQ] = ACTIONS(228),
    [anon_sym_STAR_EQ] = ACTIONS(228),
    [anon_sym_SLASH_EQ] = ACTIONS(228),
    [anon_sym_PERCENT_EQ] = ACTIONS(228),
    [anon_sym_EQ_EQ] = ACTIONS(228),
    [anon_sym_BANG_EQ] = ACTIONS(228),
    [anon_sym_GT_EQ] = ACTIONS(228),
    [anon_sym_LT_EQ] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_DOT] = ACTIONS(228),
    [anon_sym_QMARK] = ACTIONS(228),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [58] = {
    [aux_sym__non_special_token_repeat1] = STATE(58),
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_RBRACE] = ACTIONS(459),
    [anon_sym_impl] = ACTIONS(461),
    [anon_sym_SEMI] = ACTIONS(463),
    [anon_sym_trait] = ACTIONS(461),
    [anon_sym_type] = ACTIONS(461),
    [anon_sym_COLON] = ACTIONS(466),
    [anon_sym_const] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_POUND] = ACTIONS(463),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(459),
    [anon_sym_mod] = ACTIONS(461),
    [anon_sym_struct] = ACTIONS(461),
    [anon_sym_enum] = ACTIONS(461),
    [anon_sym_COMMA] = ACTIONS(463),
    [anon_sym_fn] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(463),
    [anon_sym_let] = ACTIONS(461),
    [anon_sym_use] = ACTIONS(461),
    [anon_sym_COLON_COLON] = ACTIONS(463),
    [anon_sym_STAR] = ACTIONS(466),
    [anon_sym_LPAREN] = ACTIONS(459),
    [anon_sym__] = ACTIONS(466),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_u8] = ACTIONS(461),
    [anon_sym_i8] = ACTIONS(461),
    [anon_sym_u16] = ACTIONS(461),
    [anon_sym_i16] = ACTIONS(461),
    [anon_sym_u32] = ACTIONS(461),
    [anon_sym_i32] = ACTIONS(461),
    [anon_sym_u64] = ACTIONS(461),
    [anon_sym_i64] = ACTIONS(461),
    [anon_sym_u128] = ACTIONS(461),
    [anon_sym_i128] = ACTIONS(461),
    [anon_sym_usize] = ACTIONS(461),
    [anon_sym_bool] = ACTIONS(461),
    [anon_sym_ByteArray] = ACTIONS(461),
    [anon_sym_felt252] = ACTIONS(461),
    [anon_sym_LT] = ACTIONS(466),
    [anon_sym_GT] = ACTIONS(466),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_DASH] = ACTIONS(466),
    [anon_sym_SLASH] = ACTIONS(466),
    [anon_sym_PERCENT] = ACTIONS(466),
    [anon_sym_CARET] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(466),
    [anon_sym_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(463),
    [anon_sym_GT_GT] = ACTIONS(463),
    [anon_sym_PLUS_EQ] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(463),
    [anon_sym_STAR_EQ] = ACTIONS(463),
    [anon_sym_SLASH_EQ] = ACTIONS(463),
    [anon_sym_PERCENT_EQ] = ACTIONS(463),
    [anon_sym_CARET_EQ] = ACTIONS(463),
    [anon_sym_AMP_EQ] = ACTIONS(463),
    [anon_sym_PIPE_EQ] = ACTIONS(463),
    [anon_sym_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(463),
    [anon_sym_DOT_DOT] = ACTIONS(463),
    [anon_sym_DOT] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(463),
    [anon_sym_break] = ACTIONS(461),
    [anon_sym_continue] = ACTIONS(461),
    [anon_sym_default] = ACTIONS(461),
    [anon_sym_if] = ACTIONS(461),
    [anon_sym_extern] = ACTIONS(461),
    [anon_sym_nopanic] = ACTIONS(461),
    [anon_sym_loop] = ACTIONS(461),
    [anon_sym_match] = ACTIONS(461),
    [anon_sym_pub] = ACTIONS(461),
    [anon_sym_return] = ACTIONS(461),
    [anon_sym_static] = ACTIONS(461),
    [anon_sym_while] = ACTIONS(461),
    [anon_sym_for] = ACTIONS(461),
    [sym_numeric_literal] = ACTIONS(461),
    [aux_sym_string_literal_token1] = ACTIONS(459),
    [sym_shortstring_literal] = ACTIONS(459),
    [anon_sym_true] = ACTIONS(461),
    [anon_sym_false] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(459),
    [sym_identifier] = ACTIONS(461),
    [sym_mutable_specifier] = ACTIONS(461),
    [sym_super] = ACTIONS(461),
    [sym_line_comment] = ACTIONS(3),
  },
  [59] = {
    [aux_sym__non_special_token_repeat1] = STATE(58),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_impl] = ACTIONS(471),
    [anon_sym_SEMI] = ACTIONS(473),
    [anon_sym_trait] = ACTIONS(471),
    [anon_sym_type] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(475),
    [anon_sym_const] = ACTIONS(471),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_POUND] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(469),
    [anon_sym_RBRACK] = ACTIONS(469),
    [anon_sym_mod] = ACTIONS(471),
    [anon_sym_struct] = ACTIONS(471),
    [anon_sym_enum] = ACTIONS(471),
    [anon_sym_COMMA] = ACTIONS(473),
    [anon_sym_fn] = ACTIONS(471),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_let] = ACTIONS(471),
    [anon_sym_use] = ACTIONS(471),
    [anon_sym_COLON_COLON] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(475),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym__] = ACTIONS(475),
    [anon_sym_RPAREN] = ACTIONS(469),
    [anon_sym_u8] = ACTIONS(471),
    [anon_sym_i8] = ACTIONS(471),
    [anon_sym_u16] = ACTIONS(471),
    [anon_sym_i16] = ACTIONS(471),
    [anon_sym_u32] = ACTIONS(471),
    [anon_sym_i32] = ACTIONS(471),
    [anon_sym_u64] = ACTIONS(471),
    [anon_sym_i64] = ACTIONS(471),
    [anon_sym_u128] = ACTIONS(471),
    [anon_sym_i128] = ACTIONS(471),
    [anon_sym_usize] = ACTIONS(471),
    [anon_sym_bool] = ACTIONS(471),
    [anon_sym_ByteArray] = ACTIONS(471),
    [anon_sym_felt252] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(475),
    [anon_sym_GT] = ACTIONS(475),
    [anon_sym_PLUS] = ACTIONS(475),
    [anon_sym_DASH] = ACTIONS(475),
    [anon_sym_SLASH] = ACTIONS(475),
    [anon_sym_PERCENT] = ACTIONS(475),
    [anon_sym_CARET] = ACTIONS(475),
    [anon_sym_TILDE] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(475),
    [anon_sym_AMP_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_LT_LT] = ACTIONS(473),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_PLUS_EQ] = ACTIONS(473),
    [anon_sym_DASH_EQ] = ACTIONS(473),
    [anon_sym_STAR_EQ] = ACTIONS(473),
    [anon_sym_SLASH_EQ] = ACTIONS(473),
    [anon_sym_PERCENT_EQ] = ACTIONS(473),
    [anon_sym_CARET_EQ] = ACTIONS(473),
    [anon_sym_AMP_EQ] = ACTIONS(473),
    [anon_sym_PIPE_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(473),
    [anon_sym_DOT_DOT] = ACTIONS(473),
    [anon_sym_DOT] = ACTIONS(475),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(473),
    [anon_sym_break] = ACTIONS(471),
    [anon_sym_continue] = ACTIONS(471),
    [anon_sym_default] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(471),
    [anon_sym_extern] = ACTIONS(471),
    [anon_sym_nopanic] = ACTIONS(471),
    [anon_sym_loop] = ACTIONS(471),
    [anon_sym_match] = ACTIONS(471),
    [anon_sym_pub] = ACTIONS(471),
    [anon_sym_return] = ACTIONS(471),
    [anon_sym_static] = ACTIONS(471),
    [anon_sym_while] = ACTIONS(471),
    [anon_sym_for] = ACTIONS(471),
    [sym_numeric_literal] = ACTIONS(471),
    [aux_sym_string_literal_token1] = ACTIONS(469),
    [sym_shortstring_literal] = ACTIONS(469),
    [anon_sym_true] = ACTIONS(471),
    [anon_sym_false] = ACTIONS(471),
    [anon_sym_DOLLAR] = ACTIONS(469),
    [sym_identifier] = ACTIONS(471),
    [sym_mutable_specifier] = ACTIONS(471),
    [sym_super] = ACTIONS(471),
    [sym_line_comment] = ACTIONS(3),
  },
  [60] = {
    [anon_sym_LBRACE] = ACTIONS(477),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_impl] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_trait] = ACTIONS(479),
    [anon_sym_type] = ACTIONS(479),
    [anon_sym_COLON] = ACTIONS(479),
    [anon_sym_const] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_BANG] = ACTIONS(479),
    [anon_sym_POUND] = ACTIONS(477),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_RBRACK] = ACTIONS(477),
    [anon_sym_mod] = ACTIONS(479),
    [anon_sym_struct] = ACTIONS(479),
    [anon_sym_enum] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(477),
    [anon_sym_fn] = ACTIONS(479),
    [anon_sym_DASH_GT] = ACTIONS(477),
    [anon_sym_let] = ACTIONS(479),
    [anon_sym_use] = ACTIONS(479),
    [anon_sym_COLON_COLON] = ACTIONS(477),
    [anon_sym_STAR] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(477),
    [anon_sym__] = ACTIONS(479),
    [anon_sym_RPAREN] = ACTIONS(477),
    [anon_sym_u8] = ACTIONS(479),
    [anon_sym_i8] = ACTIONS(479),
    [anon_sym_u16] = ACTIONS(479),
    [anon_sym_i16] = ACTIONS(479),
    [anon_sym_u32] = ACTIONS(479),
    [anon_sym_i32] = ACTIONS(479),
    [anon_sym_u64] = ACTIONS(479),
    [anon_sym_i64] = ACTIONS(479),
    [anon_sym_u128] = ACTIONS(479),
    [anon_sym_i128] = ACTIONS(479),
    [anon_sym_usize] = ACTIONS(479),
    [anon_sym_bool] = ACTIONS(479),
    [anon_sym_ByteArray] = ACTIONS(479),
    [anon_sym_felt252] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_SLASH] = ACTIONS(479),
    [anon_sym_PERCENT] = ACTIONS(479),
    [anon_sym_CARET] = ACTIONS(479),
    [anon_sym_TILDE] = ACTIONS(477),
    [anon_sym_AMP] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(479),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_LT_LT] = ACTIONS(477),
    [anon_sym_GT_GT] = ACTIONS(477),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_STAR_EQ] = ACTIONS(477),
    [anon_sym_SLASH_EQ] = ACTIONS(477),
    [anon_sym_PERCENT_EQ] = ACTIONS(477),
    [anon_sym_CARET_EQ] = ACTIONS(477),
    [anon_sym_AMP_EQ] = ACTIONS(477),
    [anon_sym_PIPE_EQ] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_AT] = ACTIONS(477),
    [anon_sym_DOT_DOT] = ACTIONS(477),
    [anon_sym_DOT] = ACTIONS(479),
    [anon_sym_EQ_GT] = ACTIONS(477),
    [anon_sym_QMARK] = ACTIONS(477),
    [anon_sym_break] = ACTIONS(479),
    [anon_sym_continue] = ACTIONS(479),
    [anon_sym_default] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(479),
    [anon_sym_extern] = ACTIONS(479),
    [anon_sym_nopanic] = ACTIONS(479),
    [anon_sym_loop] = ACTIONS(479),
    [anon_sym_match] = ACTIONS(479),
    [anon_sym_pub] = ACTIONS(479),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_while] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(479),
    [sym_numeric_literal] = ACTIONS(479),
    [aux_sym_string_literal_token1] = ACTIONS(477),
    [sym_shortstring_literal] = ACTIONS(477),
    [anon_sym_true] = ACTIONS(479),
    [anon_sym_false] = ACTIONS(479),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym_identifier] = ACTIONS(479),
    [sym_mutable_specifier] = ACTIONS(479),
    [sym_super] = ACTIONS(479),
    [sym_line_comment] = ACTIONS(3),
  },
  [61] = {
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_impl] = ACTIONS(483),
    [anon_sym_SEMI] = ACTIONS(481),
    [anon_sym_trait] = ACTIONS(483),
    [anon_sym_type] = ACTIONS(483),
    [anon_sym_COLON] = ACTIONS(483),
    [anon_sym_const] = ACTIONS(483),
    [anon_sym_EQ] = ACTIONS(483),
    [anon_sym_BANG] = ACTIONS(483),
    [anon_sym_POUND] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(481),
    [anon_sym_RBRACK] = ACTIONS(481),
    [anon_sym_mod] = ACTIONS(483),
    [anon_sym_struct] = ACTIONS(483),
    [anon_sym_enum] = ACTIONS(483),
    [anon_sym_COMMA] = ACTIONS(481),
    [anon_sym_fn] = ACTIONS(483),
    [anon_sym_DASH_GT] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(483),
    [anon_sym_use] = ACTIONS(483),
    [anon_sym_COLON_COLON] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(481),
    [anon_sym__] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(481),
    [anon_sym_u8] = ACTIONS(483),
    [anon_sym_i8] = ACTIONS(483),
    [anon_sym_u16] = ACTIONS(483),
    [anon_sym_i16] = ACTIONS(483),
    [anon_sym_u32] = ACTIONS(483),
    [anon_sym_i32] = ACTIONS(483),
    [anon_sym_u64] = ACTIONS(483),
    [anon_sym_i64] = ACTIONS(483),
    [anon_sym_u128] = ACTIONS(483),
    [anon_sym_i128] = ACTIONS(483),
    [anon_sym_usize] = ACTIONS(483),
    [anon_sym_bool] = ACTIONS(483),
    [anon_sym_ByteArray] = ACTIONS(483),
    [anon_sym_felt252] = ACTIONS(483),
    [anon_sym_LT] = ACTIONS(483),
    [anon_sym_GT] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(483),
    [anon_sym_SLASH] = ACTIONS(483),
    [anon_sym_PERCENT] = ACTIONS(483),
    [anon_sym_CARET] = ACTIONS(483),
    [anon_sym_TILDE] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_LT_LT] = ACTIONS(481),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_PLUS_EQ] = ACTIONS(481),
    [anon_sym_DASH_EQ] = ACTIONS(481),
    [anon_sym_STAR_EQ] = ACTIONS(481),
    [anon_sym_SLASH_EQ] = ACTIONS(481),
    [anon_sym_PERCENT_EQ] = ACTIONS(481),
    [anon_sym_CARET_EQ] = ACTIONS(481),
    [anon_sym_AMP_EQ] = ACTIONS(481),
    [anon_sym_PIPE_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_GT_EQ] = ACTIONS(481),
    [anon_sym_LT_EQ] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(481),
    [anon_sym_DOT_DOT] = ACTIONS(481),
    [anon_sym_DOT] = ACTIONS(483),
    [anon_sym_EQ_GT] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_break] = ACTIONS(483),
    [anon_sym_continue] = ACTIONS(483),
    [anon_sym_default] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(483),
    [anon_sym_extern] = ACTIONS(483),
    [anon_sym_nopanic] = ACTIONS(483),
    [anon_sym_loop] = ACTIONS(483),
    [anon_sym_match] = ACTIONS(483),
    [anon_sym_pub] = ACTIONS(483),
    [anon_sym_return] = ACTIONS(483),
    [anon_sym_static] = ACTIONS(483),
    [anon_sym_while] = ACTIONS(483),
    [anon_sym_for] = ACTIONS(483),
    [sym_numeric_literal] = ACTIONS(483),
    [aux_sym_string_literal_token1] = ACTIONS(481),
    [sym_shortstring_literal] = ACTIONS(481),
    [anon_sym_true] = ACTIONS(483),
    [anon_sym_false] = ACTIONS(483),
    [anon_sym_DOLLAR] = ACTIONS(481),
    [sym_identifier] = ACTIONS(483),
    [sym_mutable_specifier] = ACTIONS(483),
    [sym_super] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
  },
  [62] = {
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_impl] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_trait] = ACTIONS(487),
    [anon_sym_type] = ACTIONS(487),
    [anon_sym_COLON] = ACTIONS(487),
    [anon_sym_const] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(487),
    [anon_sym_POUND] = ACTIONS(485),
    [anon_sym_LBRACK] = ACTIONS(485),
    [anon_sym_RBRACK] = ACTIONS(485),
    [anon_sym_mod] = ACTIONS(487),
    [anon_sym_struct] = ACTIONS(487),
    [anon_sym_enum] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(485),
    [anon_sym_fn] = ACTIONS(487),
    [anon_sym_DASH_GT] = ACTIONS(485),
    [anon_sym_let] = ACTIONS(487),
    [anon_sym_use] = ACTIONS(487),
    [anon_sym_COLON_COLON] = ACTIONS(485),
    [anon_sym_STAR] = ACTIONS(487),
    [anon_sym_LPAREN] = ACTIONS(485),
    [anon_sym__] = ACTIONS(487),
    [anon_sym_RPAREN] = ACTIONS(485),
    [anon_sym_u8] = ACTIONS(487),
    [anon_sym_i8] = ACTIONS(487),
    [anon_sym_u16] = ACTIONS(487),
    [anon_sym_i16] = ACTIONS(487),
    [anon_sym_u32] = ACTIONS(487),
    [anon_sym_i32] = ACTIONS(487),
    [anon_sym_u64] = ACTIONS(487),
    [anon_sym_i64] = ACTIONS(487),
    [anon_sym_u128] = ACTIONS(487),
    [anon_sym_i128] = ACTIONS(487),
    [anon_sym_usize] = ACTIONS(487),
    [anon_sym_bool] = ACTIONS(487),
    [anon_sym_ByteArray] = ACTIONS(487),
    [anon_sym_felt252] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_CARET] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_AMP] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_LT_LT] = ACTIONS(485),
    [anon_sym_GT_GT] = ACTIONS(485),
    [anon_sym_PLUS_EQ] = ACTIONS(485),
    [anon_sym_DASH_EQ] = ACTIONS(485),
    [anon_sym_STAR_EQ] = ACTIONS(485),
    [anon_sym_SLASH_EQ] = ACTIONS(485),
    [anon_sym_PERCENT_EQ] = ACTIONS(485),
    [anon_sym_CARET_EQ] = ACTIONS(485),
    [anon_sym_AMP_EQ] = ACTIONS(485),
    [anon_sym_PIPE_EQ] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(485),
    [anon_sym_BANG_EQ] = ACTIONS(485),
    [anon_sym_GT_EQ] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(485),
    [anon_sym_DOT_DOT] = ACTIONS(485),
    [anon_sym_DOT] = ACTIONS(487),
    [anon_sym_EQ_GT] = ACTIONS(485),
    [anon_sym_QMARK] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_default] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_extern] = ACTIONS(487),
    [anon_sym_nopanic] = ACTIONS(487),
    [anon_sym_loop] = ACTIONS(487),
    [anon_sym_match] = ACTIONS(487),
    [anon_sym_pub] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(487),
    [anon_sym_static] = ACTIONS(487),
    [anon_sym_while] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(487),
    [sym_numeric_literal] = ACTIONS(487),
    [aux_sym_string_literal_token1] = ACTIONS(485),
    [sym_shortstring_literal] = ACTIONS(485),
    [anon_sym_true] = ACTIONS(487),
    [anon_sym_false] = ACTIONS(487),
    [anon_sym_DOLLAR] = ACTIONS(485),
    [sym_identifier] = ACTIONS(487),
    [sym_mutable_specifier] = ACTIONS(487),
    [sym_super] = ACTIONS(487),
    [sym_line_comment] = ACTIONS(3),
  },
  [63] = {
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_impl] = ACTIONS(491),
    [anon_sym_SEMI] = ACTIONS(489),
    [anon_sym_trait] = ACTIONS(491),
    [anon_sym_type] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(491),
    [anon_sym_const] = ACTIONS(491),
    [anon_sym_EQ] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_POUND] = ACTIONS(489),
    [anon_sym_LBRACK] = ACTIONS(489),
    [anon_sym_RBRACK] = ACTIONS(489),
    [anon_sym_mod] = ACTIONS(491),
    [anon_sym_struct] = ACTIONS(491),
    [anon_sym_enum] = ACTIONS(491),
    [anon_sym_COMMA] = ACTIONS(489),
    [anon_sym_fn] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(489),
    [anon_sym_let] = ACTIONS(491),
    [anon_sym_use] = ACTIONS(491),
    [anon_sym_COLON_COLON] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym__] = ACTIONS(491),
    [anon_sym_RPAREN] = ACTIONS(489),
    [anon_sym_u8] = ACTIONS(491),
    [anon_sym_i8] = ACTIONS(491),
    [anon_sym_u16] = ACTIONS(491),
    [anon_sym_i16] = ACTIONS(491),
    [anon_sym_u32] = ACTIONS(491),
    [anon_sym_i32] = ACTIONS(491),
    [anon_sym_u64] = ACTIONS(491),
    [anon_sym_i64] = ACTIONS(491),
    [anon_sym_u128] = ACTIONS(491),
    [anon_sym_i128] = ACTIONS(491),
    [anon_sym_usize] = ACTIONS(491),
    [anon_sym_bool] = ACTIONS(491),
    [anon_sym_ByteArray] = ACTIONS(491),
    [anon_sym_felt252] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_PERCENT] = ACTIONS(491),
    [anon_sym_CARET] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_LT_LT] = ACTIONS(489),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_PLUS_EQ] = ACTIONS(489),
    [anon_sym_DASH_EQ] = ACTIONS(489),
    [anon_sym_STAR_EQ] = ACTIONS(489),
    [anon_sym_SLASH_EQ] = ACTIONS(489),
    [anon_sym_PERCENT_EQ] = ACTIONS(489),
    [anon_sym_CARET_EQ] = ACTIONS(489),
    [anon_sym_AMP_EQ] = ACTIONS(489),
    [anon_sym_PIPE_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [anon_sym_DOT_DOT] = ACTIONS(489),
    [anon_sym_DOT] = ACTIONS(491),
    [anon_sym_EQ_GT] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_break] = ACTIONS(491),
    [anon_sym_continue] = ACTIONS(491),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_extern] = ACTIONS(491),
    [anon_sym_nopanic] = ACTIONS(491),
    [anon_sym_loop] = ACTIONS(491),
    [anon_sym_match] = ACTIONS(491),
    [anon_sym_pub] = ACTIONS(491),
    [anon_sym_return] = ACTIONS(491),
    [anon_sym_static] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(491),
    [sym_numeric_literal] = ACTIONS(491),
    [aux_sym_string_literal_token1] = ACTIONS(489),
    [sym_shortstring_literal] = ACTIONS(489),
    [anon_sym_true] = ACTIONS(491),
    [anon_sym_false] = ACTIONS(491),
    [anon_sym_DOLLAR] = ACTIONS(489),
    [sym_identifier] = ACTIONS(491),
    [sym_mutable_specifier] = ACTIONS(491),
    [sym_super] = ACTIONS(491),
    [sym_line_comment] = ACTIONS(3),
  },
  [64] = {
    [anon_sym_LBRACE] = ACTIONS(493),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_impl] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_trait] = ACTIONS(495),
    [anon_sym_type] = ACTIONS(495),
    [anon_sym_COLON] = ACTIONS(495),
    [anon_sym_const] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_POUND] = ACTIONS(493),
    [anon_sym_LBRACK] = ACTIONS(493),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_mod] = ACTIONS(495),
    [anon_sym_struct] = ACTIONS(495),
    [anon_sym_enum] = ACTIONS(495),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_fn] = ACTIONS(495),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_let] = ACTIONS(495),
    [anon_sym_use] = ACTIONS(495),
    [anon_sym_COLON_COLON] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(493),
    [anon_sym__] = ACTIONS(495),
    [anon_sym_RPAREN] = ACTIONS(493),
    [anon_sym_u8] = ACTIONS(495),
    [anon_sym_i8] = ACTIONS(495),
    [anon_sym_u16] = ACTIONS(495),
    [anon_sym_i16] = ACTIONS(495),
    [anon_sym_u32] = ACTIONS(495),
    [anon_sym_i32] = ACTIONS(495),
    [anon_sym_u64] = ACTIONS(495),
    [anon_sym_i64] = ACTIONS(495),
    [anon_sym_u128] = ACTIONS(495),
    [anon_sym_i128] = ACTIONS(495),
    [anon_sym_usize] = ACTIONS(495),
    [anon_sym_bool] = ACTIONS(495),
    [anon_sym_ByteArray] = ACTIONS(495),
    [anon_sym_felt252] = ACTIONS(495),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_LT_LT] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(493),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_STAR_EQ] = ACTIONS(493),
    [anon_sym_SLASH_EQ] = ACTIONS(493),
    [anon_sym_PERCENT_EQ] = ACTIONS(493),
    [anon_sym_CARET_EQ] = ACTIONS(493),
    [anon_sym_AMP_EQ] = ACTIONS(493),
    [anon_sym_PIPE_EQ] = ACTIONS(493),
    [anon_sym_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_AT] = ACTIONS(493),
    [anon_sym_DOT_DOT] = ACTIONS(493),
    [anon_sym_DOT] = ACTIONS(495),
    [anon_sym_EQ_GT] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(493),
    [anon_sym_break] = ACTIONS(495),
    [anon_sym_continue] = ACTIONS(495),
    [anon_sym_default] = ACTIONS(495),
    [anon_sym_if] = ACTIONS(495),
    [anon_sym_extern] = ACTIONS(495),
    [anon_sym_nopanic] = ACTIONS(495),
    [anon_sym_loop] = ACTIONS(495),
    [anon_sym_match] = ACTIONS(495),
    [anon_sym_pub] = ACTIONS(495),
    [anon_sym_return] = ACTIONS(495),
    [anon_sym_static] = ACTIONS(495),
    [anon_sym_while] = ACTIONS(495),
    [anon_sym_for] = ACTIONS(495),
    [sym_numeric_literal] = ACTIONS(495),
    [aux_sym_string_literal_token1] = ACTIONS(493),
    [sym_shortstring_literal] = ACTIONS(493),
    [anon_sym_true] = ACTIONS(495),
    [anon_sym_false] = ACTIONS(495),
    [anon_sym_DOLLAR] = ACTIONS(493),
    [sym_identifier] = ACTIONS(495),
    [sym_mutable_specifier] = ACTIONS(495),
    [sym_super] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
  },
  [65] = {
    [anon_sym_LBRACE] = ACTIONS(497),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_impl] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_trait] = ACTIONS(499),
    [anon_sym_type] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(499),
    [anon_sym_const] = ACTIONS(499),
    [anon_sym_EQ] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_POUND] = ACTIONS(497),
    [anon_sym_LBRACK] = ACTIONS(497),
    [anon_sym_RBRACK] = ACTIONS(497),
    [anon_sym_mod] = ACTIONS(499),
    [anon_sym_struct] = ACTIONS(499),
    [anon_sym_enum] = ACTIONS(499),
    [anon_sym_COMMA] = ACTIONS(497),
    [anon_sym_fn] = ACTIONS(499),
    [anon_sym_DASH_GT] = ACTIONS(497),
    [anon_sym_let] = ACTIONS(499),
    [anon_sym_use] = ACTIONS(499),
    [anon_sym_COLON_COLON] = ACTIONS(497),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym__] = ACTIONS(499),
    [anon_sym_RPAREN] = ACTIONS(497),
    [anon_sym_u8] = ACTIONS(499),
    [anon_sym_i8] = ACTIONS(499),
    [anon_sym_u16] = ACTIONS(499),
    [anon_sym_i16] = ACTIONS(499),
    [anon_sym_u32] = ACTIONS(499),
    [anon_sym_i32] = ACTIONS(499),
    [anon_sym_u64] = ACTIONS(499),
    [anon_sym_i64] = ACTIONS(499),
    [anon_sym_u128] = ACTIONS(499),
    [anon_sym_i128] = ACTIONS(499),
    [anon_sym_usize] = ACTIONS(499),
    [anon_sym_bool] = ACTIONS(499),
    [anon_sym_ByteArray] = ACTIONS(499),
    [anon_sym_felt252] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_AMP] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(497),
    [anon_sym_PIPE_PIPE] = ACTIONS(497),
    [anon_sym_LT_LT] = ACTIONS(497),
    [anon_sym_GT_GT] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(497),
    [anon_sym_DASH_EQ] = ACTIONS(497),
    [anon_sym_STAR_EQ] = ACTIONS(497),
    [anon_sym_SLASH_EQ] = ACTIONS(497),
    [anon_sym_PERCENT_EQ] = ACTIONS(497),
    [anon_sym_CARET_EQ] = ACTIONS(497),
    [anon_sym_AMP_EQ] = ACTIONS(497),
    [anon_sym_PIPE_EQ] = ACTIONS(497),
    [anon_sym_EQ_EQ] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(497),
    [anon_sym_GT_EQ] = ACTIONS(497),
    [anon_sym_LT_EQ] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(497),
    [anon_sym_DOT_DOT] = ACTIONS(497),
    [anon_sym_DOT] = ACTIONS(499),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(497),
    [anon_sym_break] = ACTIONS(499),
    [anon_sym_continue] = ACTIONS(499),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_extern] = ACTIONS(499),
    [anon_sym_nopanic] = ACTIONS(499),
    [anon_sym_loop] = ACTIONS(499),
    [anon_sym_match] = ACTIONS(499),
    [anon_sym_pub] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [sym_numeric_literal] = ACTIONS(499),
    [aux_sym_string_literal_token1] = ACTIONS(497),
    [sym_shortstring_literal] = ACTIONS(497),
    [anon_sym_true] = ACTIONS(499),
    [anon_sym_false] = ACTIONS(499),
    [anon_sym_DOLLAR] = ACTIONS(497),
    [sym_identifier] = ACTIONS(499),
    [sym_mutable_specifier] = ACTIONS(499),
    [sym_super] = ACTIONS(499),
    [sym_line_comment] = ACTIONS(3),
  },
  [66] = {
    [anon_sym_LBRACE] = ACTIONS(501),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_impl] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(501),
    [anon_sym_trait] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_COLON] = ACTIONS(503),
    [anon_sym_const] = ACTIONS(503),
    [anon_sym_EQ] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(503),
    [anon_sym_POUND] = ACTIONS(501),
    [anon_sym_LBRACK] = ACTIONS(501),
    [anon_sym_RBRACK] = ACTIONS(501),
    [anon_sym_mod] = ACTIONS(503),
    [anon_sym_struct] = ACTIONS(503),
    [anon_sym_enum] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(501),
    [anon_sym_fn] = ACTIONS(503),
    [anon_sym_DASH_GT] = ACTIONS(501),
    [anon_sym_let] = ACTIONS(503),
    [anon_sym_use] = ACTIONS(503),
    [anon_sym_COLON_COLON] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(501),
    [anon_sym__] = ACTIONS(503),
    [anon_sym_RPAREN] = ACTIONS(501),
    [anon_sym_u8] = ACTIONS(503),
    [anon_sym_i8] = ACTIONS(503),
    [anon_sym_u16] = ACTIONS(503),
    [anon_sym_i16] = ACTIONS(503),
    [anon_sym_u32] = ACTIONS(503),
    [anon_sym_i32] = ACTIONS(503),
    [anon_sym_u64] = ACTIONS(503),
    [anon_sym_i64] = ACTIONS(503),
    [anon_sym_u128] = ACTIONS(503),
    [anon_sym_i128] = ACTIONS(503),
    [anon_sym_usize] = ACTIONS(503),
    [anon_sym_bool] = ACTIONS(503),
    [anon_sym_ByteArray] = ACTIONS(503),
    [anon_sym_felt252] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(503),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_PLUS] = ACTIONS(503),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_SLASH] = ACTIONS(503),
    [anon_sym_PERCENT] = ACTIONS(503),
    [anon_sym_CARET] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(501),
    [anon_sym_AMP] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(503),
    [anon_sym_AMP_AMP] = ACTIONS(501),
    [anon_sym_PIPE_PIPE] = ACTIONS(501),
    [anon_sym_LT_LT] = ACTIONS(501),
    [anon_sym_GT_GT] = ACTIONS(501),
    [anon_sym_PLUS_EQ] = ACTIONS(501),
    [anon_sym_DASH_EQ] = ACTIONS(501),
    [anon_sym_STAR_EQ] = ACTIONS(501),
    [anon_sym_SLASH_EQ] = ACTIONS(501),
    [anon_sym_PERCENT_EQ] = ACTIONS(501),
    [anon_sym_CARET_EQ] = ACTIONS(501),
    [anon_sym_AMP_EQ] = ACTIONS(501),
    [anon_sym_PIPE_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ] = ACTIONS(501),
    [anon_sym_GT_EQ] = ACTIONS(501),
    [anon_sym_LT_EQ] = ACTIONS(501),
    [anon_sym_AT] = ACTIONS(501),
    [anon_sym_DOT_DOT] = ACTIONS(501),
    [anon_sym_DOT] = ACTIONS(503),
    [anon_sym_EQ_GT] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(501),
    [anon_sym_break] = ACTIONS(503),
    [anon_sym_continue] = ACTIONS(503),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_extern] = ACTIONS(503),
    [anon_sym_nopanic] = ACTIONS(503),
    [anon_sym_loop] = ACTIONS(503),
    [anon_sym_match] = ACTIONS(503),
    [anon_sym_pub] = ACTIONS(503),
    [anon_sym_return] = ACTIONS(503),
    [anon_sym_static] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_for] = ACTIONS(503),
    [sym_numeric_literal] = ACTIONS(505),
    [aux_sym_string_literal_token1] = ACTIONS(501),
    [sym_shortstring_literal] = ACTIONS(501),
    [anon_sym_true] = ACTIONS(503),
    [anon_sym_false] = ACTIONS(503),
    [anon_sym_DOLLAR] = ACTIONS(501),
    [sym_identifier] = ACTIONS(503),
    [sym_mutable_specifier] = ACTIONS(503),
    [sym_super] = ACTIONS(503),
    [sym_line_comment] = ACTIONS(3),
  },
  [67] = {
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_impl] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_trait] = ACTIONS(510),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_COLON] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_EQ] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_POUND] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(508),
    [anon_sym_RBRACK] = ACTIONS(508),
    [anon_sym_mod] = ACTIONS(510),
    [anon_sym_struct] = ACTIONS(510),
    [anon_sym_enum] = ACTIONS(510),
    [anon_sym_COMMA] = ACTIONS(508),
    [anon_sym_fn] = ACTIONS(510),
    [anon_sym_DASH_GT] = ACTIONS(508),
    [anon_sym_let] = ACTIONS(510),
    [anon_sym_use] = ACTIONS(510),
    [anon_sym_COLON_COLON] = ACTIONS(508),
    [anon_sym_STAR] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym__] = ACTIONS(510),
    [anon_sym_RPAREN] = ACTIONS(508),
    [anon_sym_u8] = ACTIONS(510),
    [anon_sym_i8] = ACTIONS(510),
    [anon_sym_u16] = ACTIONS(510),
    [anon_sym_i16] = ACTIONS(510),
    [anon_sym_u32] = ACTIONS(510),
    [anon_sym_i32] = ACTIONS(510),
    [anon_sym_u64] = ACTIONS(510),
    [anon_sym_i64] = ACTIONS(510),
    [anon_sym_u128] = ACTIONS(510),
    [anon_sym_i128] = ACTIONS(510),
    [anon_sym_usize] = ACTIONS(510),
    [anon_sym_bool] = ACTIONS(510),
    [anon_sym_ByteArray] = ACTIONS(510),
    [anon_sym_felt252] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(510),
    [anon_sym_PERCENT] = ACTIONS(510),
    [anon_sym_CARET] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_AMP] = ACTIONS(510),
    [anon_sym_PIPE] = ACTIONS(510),
    [anon_sym_AMP_AMP] = ACTIONS(508),
    [anon_sym_PIPE_PIPE] = ACTIONS(508),
    [anon_sym_LT_LT] = ACTIONS(508),
    [anon_sym_GT_GT] = ACTIONS(508),
    [anon_sym_PLUS_EQ] = ACTIONS(508),
    [anon_sym_DASH_EQ] = ACTIONS(508),
    [anon_sym_STAR_EQ] = ACTIONS(508),
    [anon_sym_SLASH_EQ] = ACTIONS(508),
    [anon_sym_PERCENT_EQ] = ACTIONS(508),
    [anon_sym_CARET_EQ] = ACTIONS(508),
    [anon_sym_AMP_EQ] = ACTIONS(508),
    [anon_sym_PIPE_EQ] = ACTIONS(508),
    [anon_sym_EQ_EQ] = ACTIONS(508),
    [anon_sym_BANG_EQ] = ACTIONS(508),
    [anon_sym_GT_EQ] = ACTIONS(508),
    [anon_sym_LT_EQ] = ACTIONS(508),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_DOT_DOT] = ACTIONS(508),
    [anon_sym_DOT] = ACTIONS(510),
    [anon_sym_EQ_GT] = ACTIONS(508),
    [anon_sym_QMARK] = ACTIONS(508),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_extern] = ACTIONS(510),
    [anon_sym_nopanic] = ACTIONS(510),
    [anon_sym_loop] = ACTIONS(510),
    [anon_sym_match] = ACTIONS(510),
    [anon_sym_pub] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [sym_numeric_literal] = ACTIONS(510),
    [aux_sym_string_literal_token1] = ACTIONS(508),
    [sym_shortstring_literal] = ACTIONS(508),
    [anon_sym_true] = ACTIONS(510),
    [anon_sym_false] = ACTIONS(510),
    [anon_sym_DOLLAR] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [sym_mutable_specifier] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_line_comment] = ACTIONS(3),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(512),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_impl] = ACTIONS(514),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_trait] = ACTIONS(514),
    [anon_sym_type] = ACTIONS(514),
    [anon_sym_const] = ACTIONS(514),
    [anon_sym_EQ] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(514),
    [anon_sym_POUND] = ACTIONS(512),
    [anon_sym_LBRACK] = ACTIONS(512),
    [anon_sym_RBRACK] = ACTIONS(512),
    [anon_sym_mod] = ACTIONS(514),
    [anon_sym_struct] = ACTIONS(514),
    [anon_sym_enum] = ACTIONS(514),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_fn] = ACTIONS(514),
    [anon_sym_let] = ACTIONS(514),
    [anon_sym_use] = ACTIONS(514),
    [anon_sym_COLON_COLON] = ACTIONS(512),
    [anon_sym_STAR] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(512),
    [anon_sym_RPAREN] = ACTIONS(512),
    [anon_sym_u8] = ACTIONS(514),
    [anon_sym_i8] = ACTIONS(514),
    [anon_sym_u16] = ACTIONS(514),
    [anon_sym_i16] = ACTIONS(514),
    [anon_sym_u32] = ACTIONS(514),
    [anon_sym_i32] = ACTIONS(514),
    [anon_sym_u64] = ACTIONS(514),
    [anon_sym_i64] = ACTIONS(514),
    [anon_sym_u128] = ACTIONS(514),
    [anon_sym_i128] = ACTIONS(514),
    [anon_sym_usize] = ACTIONS(514),
    [anon_sym_bool] = ACTIONS(514),
    [anon_sym_ByteArray] = ACTIONS(514),
    [anon_sym_felt252] = ACTIONS(514),
    [anon_sym_LT] = ACTIONS(514),
    [anon_sym_GT] = ACTIONS(514),
    [anon_sym_PLUS] = ACTIONS(514),
    [anon_sym_DASH] = ACTIONS(514),
    [anon_sym_SLASH] = ACTIONS(514),
    [anon_sym_PERCENT] = ACTIONS(514),
    [anon_sym_CARET] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(512),
    [anon_sym_AMP] = ACTIONS(514),
    [anon_sym_PIPE] = ACTIONS(514),
    [anon_sym_AMP_AMP] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(512),
    [anon_sym_LT_LT] = ACTIONS(512),
    [anon_sym_GT_GT] = ACTIONS(512),
    [anon_sym_PLUS_EQ] = ACTIONS(512),
    [anon_sym_DASH_EQ] = ACTIONS(512),
    [anon_sym_STAR_EQ] = ACTIONS(512),
    [anon_sym_SLASH_EQ] = ACTIONS(512),
    [anon_sym_PERCENT_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(512),
    [anon_sym_DOT] = ACTIONS(512),
    [anon_sym_QMARK] = ACTIONS(512),
    [anon_sym_break] = ACTIONS(514),
    [anon_sym_continue] = ACTIONS(514),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_extern] = ACTIONS(514),
    [anon_sym_loop] = ACTIONS(514),
    [anon_sym_match] = ACTIONS(514),
    [anon_sym_pub] = ACTIONS(514),
    [anon_sym_return] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(514),
    [sym_numeric_literal] = ACTIONS(514),
    [aux_sym_string_literal_token1] = ACTIONS(512),
    [sym_shortstring_literal] = ACTIONS(512),
    [anon_sym_true] = ACTIONS(514),
    [anon_sym_false] = ACTIONS(514),
    [anon_sym_ref] = ACTIONS(514),
    [sym_identifier] = ACTIONS(514),
    [sym_super] = ACTIONS(514),
    [sym_line_comment] = ACTIONS(3),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(516),
    [anon_sym_LBRACE] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_impl] = ACTIONS(518),
    [anon_sym_SEMI] = ACTIONS(516),
    [anon_sym_trait] = ACTIONS(518),
    [anon_sym_type] = ACTIONS(518),
    [anon_sym_const] = ACTIONS(518),
    [anon_sym_EQ] = ACTIONS(518),
    [anon_sym_BANG] = ACTIONS(518),
    [anon_sym_POUND] = ACTIONS(516),
    [anon_sym_LBRACK] = ACTIONS(516),
    [anon_sym_RBRACK] = ACTIONS(516),
    [anon_sym_mod] = ACTIONS(518),
    [anon_sym_struct] = ACTIONS(518),
    [anon_sym_enum] = ACTIONS(518),
    [anon_sym_COMMA] = ACTIONS(516),
    [anon_sym_fn] = ACTIONS(518),
    [anon_sym_let] = ACTIONS(518),
    [anon_sym_use] = ACTIONS(518),
    [anon_sym_COLON_COLON] = ACTIONS(516),
    [anon_sym_STAR] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(516),
    [anon_sym_RPAREN] = ACTIONS(516),
    [anon_sym_u8] = ACTIONS(518),
    [anon_sym_i8] = ACTIONS(518),
    [anon_sym_u16] = ACTIONS(518),
    [anon_sym_i16] = ACTIONS(518),
    [anon_sym_u32] = ACTIONS(518),
    [anon_sym_i32] = ACTIONS(518),
    [anon_sym_u64] = ACTIONS(518),
    [anon_sym_i64] = ACTIONS(518),
    [anon_sym_u128] = ACTIONS(518),
    [anon_sym_i128] = ACTIONS(518),
    [anon_sym_usize] = ACTIONS(518),
    [anon_sym_bool] = ACTIONS(518),
    [anon_sym_ByteArray] = ACTIONS(518),
    [anon_sym_felt252] = ACTIONS(518),
    [anon_sym_LT] = ACTIONS(518),
    [anon_sym_GT] = ACTIONS(518),
    [anon_sym_PLUS] = ACTIONS(518),
    [anon_sym_DASH] = ACTIONS(518),
    [anon_sym_SLASH] = ACTIONS(518),
    [anon_sym_PERCENT] = ACTIONS(518),
    [anon_sym_CARET] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(516),
    [anon_sym_AMP] = ACTIONS(518),
    [anon_sym_PIPE] = ACTIONS(518),
    [anon_sym_AMP_AMP] = ACTIONS(516),
    [anon_sym_PIPE_PIPE] = ACTIONS(516),
    [anon_sym_LT_LT] = ACTIONS(516),
    [anon_sym_GT_GT] = ACTIONS(516),
    [anon_sym_PLUS_EQ] = ACTIONS(516),
    [anon_sym_DASH_EQ] = ACTIONS(516),
    [anon_sym_STAR_EQ] = ACTIONS(516),
    [anon_sym_SLASH_EQ] = ACTIONS(516),
    [anon_sym_PERCENT_EQ] = ACTIONS(516),
    [anon_sym_EQ_EQ] = ACTIONS(516),
    [anon_sym_BANG_EQ] = ACTIONS(516),
    [anon_sym_GT_EQ] = ACTIONS(516),
    [anon_sym_LT_EQ] = ACTIONS(516),
    [anon_sym_AT] = ACTIONS(516),
    [anon_sym_DOT] = ACTIONS(516),
    [anon_sym_QMARK] = ACTIONS(516),
    [anon_sym_break] = ACTIONS(518),
    [anon_sym_continue] = ACTIONS(518),
    [anon_sym_default] = ACTIONS(518),
    [anon_sym_if] = ACTIONS(518),
    [anon_sym_extern] = ACTIONS(518),
    [anon_sym_loop] = ACTIONS(518),
    [anon_sym_match] = ACTIONS(518),
    [anon_sym_pub] = ACTIONS(518),
    [anon_sym_return] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(518),
    [sym_numeric_literal] = ACTIONS(518),
    [aux_sym_string_literal_token1] = ACTIONS(516),
    [sym_shortstring_literal] = ACTIONS(516),
    [anon_sym_true] = ACTIONS(518),
    [anon_sym_false] = ACTIONS(518),
    [anon_sym_ref] = ACTIONS(518),
    [sym_identifier] = ACTIONS(518),
    [sym_super] = ACTIONS(518),
    [sym_line_comment] = ACTIONS(3),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(520),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_impl] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_trait] = ACTIONS(522),
    [anon_sym_type] = ACTIONS(522),
    [anon_sym_const] = ACTIONS(522),
    [anon_sym_EQ] = ACTIONS(522),
    [anon_sym_BANG] = ACTIONS(522),
    [anon_sym_POUND] = ACTIONS(520),
    [anon_sym_LBRACK] = ACTIONS(520),
    [anon_sym_RBRACK] = ACTIONS(520),
    [anon_sym_mod] = ACTIONS(522),
    [anon_sym_struct] = ACTIONS(522),
    [anon_sym_enum] = ACTIONS(522),
    [anon_sym_COMMA] = ACTIONS(520),
    [anon_sym_fn] = ACTIONS(522),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_use] = ACTIONS(522),
    [anon_sym_COLON_COLON] = ACTIONS(520),
    [anon_sym_STAR] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(520),
    [anon_sym_RPAREN] = ACTIONS(520),
    [anon_sym_u8] = ACTIONS(522),
    [anon_sym_i8] = ACTIONS(522),
    [anon_sym_u16] = ACTIONS(522),
    [anon_sym_i16] = ACTIONS(522),
    [anon_sym_u32] = ACTIONS(522),
    [anon_sym_i32] = ACTIONS(522),
    [anon_sym_u64] = ACTIONS(522),
    [anon_sym_i64] = ACTIONS(522),
    [anon_sym_u128] = ACTIONS(522),
    [anon_sym_i128] = ACTIONS(522),
    [anon_sym_usize] = ACTIONS(522),
    [anon_sym_bool] = ACTIONS(522),
    [anon_sym_ByteArray] = ACTIONS(522),
    [anon_sym_felt252] = ACTIONS(522),
    [anon_sym_LT] = ACTIONS(522),
    [anon_sym_GT] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(522),
    [anon_sym_PERCENT] = ACTIONS(522),
    [anon_sym_CARET] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(520),
    [anon_sym_AMP] = ACTIONS(522),
    [anon_sym_PIPE] = ACTIONS(522),
    [anon_sym_AMP_AMP] = ACTIONS(520),
    [anon_sym_PIPE_PIPE] = ACTIONS(520),
    [anon_sym_LT_LT] = ACTIONS(520),
    [anon_sym_GT_GT] = ACTIONS(520),
    [anon_sym_PLUS_EQ] = ACTIONS(520),
    [anon_sym_DASH_EQ] = ACTIONS(520),
    [anon_sym_STAR_EQ] = ACTIONS(520),
    [anon_sym_SLASH_EQ] = ACTIONS(520),
    [anon_sym_PERCENT_EQ] = ACTIONS(520),
    [anon_sym_EQ_EQ] = ACTIONS(520),
    [anon_sym_BANG_EQ] = ACTIONS(520),
    [anon_sym_GT_EQ] = ACTIONS(520),
    [anon_sym_LT_EQ] = ACTIONS(520),
    [anon_sym_AT] = ACTIONS(520),
    [anon_sym_DOT] = ACTIONS(520),
    [anon_sym_QMARK] = ACTIONS(520),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [anon_sym_default] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_extern] = ACTIONS(522),
    [anon_sym_loop] = ACTIONS(522),
    [anon_sym_match] = ACTIONS(522),
    [anon_sym_pub] = ACTIONS(522),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [sym_numeric_literal] = ACTIONS(522),
    [aux_sym_string_literal_token1] = ACTIONS(520),
    [sym_shortstring_literal] = ACTIONS(520),
    [anon_sym_true] = ACTIONS(522),
    [anon_sym_false] = ACTIONS(522),
    [anon_sym_ref] = ACTIONS(522),
    [sym_identifier] = ACTIONS(522),
    [sym_super] = ACTIONS(522),
    [sym_line_comment] = ACTIONS(3),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(524),
    [anon_sym_LBRACE] = ACTIONS(524),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_impl] = ACTIONS(526),
    [anon_sym_SEMI] = ACTIONS(524),
    [anon_sym_trait] = ACTIONS(526),
    [anon_sym_type] = ACTIONS(526),
    [anon_sym_const] = ACTIONS(526),
    [anon_sym_EQ] = ACTIONS(526),
    [anon_sym_BANG] = ACTIONS(526),
    [anon_sym_POUND] = ACTIONS(524),
    [anon_sym_LBRACK] = ACTIONS(524),
    [anon_sym_RBRACK] = ACTIONS(524),
    [anon_sym_mod] = ACTIONS(526),
    [anon_sym_struct] = ACTIONS(526),
    [anon_sym_enum] = ACTIONS(526),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_fn] = ACTIONS(526),
    [anon_sym_let] = ACTIONS(526),
    [anon_sym_use] = ACTIONS(526),
    [anon_sym_COLON_COLON] = ACTIONS(524),
    [anon_sym_STAR] = ACTIONS(526),
    [anon_sym_LPAREN] = ACTIONS(524),
    [anon_sym_RPAREN] = ACTIONS(524),
    [anon_sym_u8] = ACTIONS(526),
    [anon_sym_i8] = ACTIONS(526),
    [anon_sym_u16] = ACTIONS(526),
    [anon_sym_i16] = ACTIONS(526),
    [anon_sym_u32] = ACTIONS(526),
    [anon_sym_i32] = ACTIONS(526),
    [anon_sym_u64] = ACTIONS(526),
    [anon_sym_i64] = ACTIONS(526),
    [anon_sym_u128] = ACTIONS(526),
    [anon_sym_i128] = ACTIONS(526),
    [anon_sym_usize] = ACTIONS(526),
    [anon_sym_bool] = ACTIONS(526),
    [anon_sym_ByteArray] = ACTIONS(526),
    [anon_sym_felt252] = ACTIONS(526),
    [anon_sym_LT] = ACTIONS(526),
    [anon_sym_GT] = ACTIONS(526),
    [anon_sym_PLUS] = ACTIONS(526),
    [anon_sym_DASH] = ACTIONS(526),
    [anon_sym_SLASH] = ACTIONS(526),
    [anon_sym_PERCENT] = ACTIONS(526),
    [anon_sym_CARET] = ACTIONS(524),
    [anon_sym_TILDE] = ACTIONS(524),
    [anon_sym_AMP] = ACTIONS(526),
    [anon_sym_PIPE] = ACTIONS(526),
    [anon_sym_AMP_AMP] = ACTIONS(524),
    [anon_sym_PIPE_PIPE] = ACTIONS(524),
    [anon_sym_LT_LT] = ACTIONS(524),
    [anon_sym_GT_GT] = ACTIONS(524),
    [anon_sym_PLUS_EQ] = ACTIONS(524),
    [anon_sym_DASH_EQ] = ACTIONS(524),
    [anon_sym_STAR_EQ] = ACTIONS(524),
    [anon_sym_SLASH_EQ] = ACTIONS(524),
    [anon_sym_PERCENT_EQ] = ACTIONS(524),
    [anon_sym_EQ_EQ] = ACTIONS(524),
    [anon_sym_BANG_EQ] = ACTIONS(524),
    [anon_sym_GT_EQ] = ACTIONS(524),
    [anon_sym_LT_EQ] = ACTIONS(524),
    [anon_sym_AT] = ACTIONS(524),
    [anon_sym_DOT] = ACTIONS(524),
    [anon_sym_QMARK] = ACTIONS(524),
    [anon_sym_break] = ACTIONS(526),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_default] = ACTIONS(526),
    [anon_sym_if] = ACTIONS(526),
    [anon_sym_extern] = ACTIONS(526),
    [anon_sym_loop] = ACTIONS(526),
    [anon_sym_match] = ACTIONS(526),
    [anon_sym_pub] = ACTIONS(526),
    [anon_sym_return] = ACTIONS(526),
    [anon_sym_while] = ACTIONS(526),
    [anon_sym_for] = ACTIONS(526),
    [sym_numeric_literal] = ACTIONS(526),
    [aux_sym_string_literal_token1] = ACTIONS(524),
    [sym_shortstring_literal] = ACTIONS(524),
    [anon_sym_true] = ACTIONS(526),
    [anon_sym_false] = ACTIONS(526),
    [anon_sym_ref] = ACTIONS(526),
    [sym_identifier] = ACTIONS(526),
    [sym_super] = ACTIONS(526),
    [sym_line_comment] = ACTIONS(3),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(528),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_impl] = ACTIONS(530),
    [anon_sym_SEMI] = ACTIONS(528),
    [anon_sym_trait] = ACTIONS(530),
    [anon_sym_type] = ACTIONS(530),
    [anon_sym_const] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(530),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_POUND] = ACTIONS(528),
    [anon_sym_LBRACK] = ACTIONS(528),
    [anon_sym_RBRACK] = ACTIONS(528),
    [anon_sym_mod] = ACTIONS(530),
    [anon_sym_struct] = ACTIONS(530),
    [anon_sym_enum] = ACTIONS(530),
    [anon_sym_COMMA] = ACTIONS(528),
    [anon_sym_fn] = ACTIONS(530),
    [anon_sym_let] = ACTIONS(530),
    [anon_sym_use] = ACTIONS(530),
    [anon_sym_COLON_COLON] = ACTIONS(528),
    [anon_sym_STAR] = ACTIONS(530),
    [anon_sym_LPAREN] = ACTIONS(528),
    [anon_sym_RPAREN] = ACTIONS(528),
    [anon_sym_u8] = ACTIONS(530),
    [anon_sym_i8] = ACTIONS(530),
    [anon_sym_u16] = ACTIONS(530),
    [anon_sym_i16] = ACTIONS(530),
    [anon_sym_u32] = ACTIONS(530),
    [anon_sym_i32] = ACTIONS(530),
    [anon_sym_u64] = ACTIONS(530),
    [anon_sym_i64] = ACTIONS(530),
    [anon_sym_u128] = ACTIONS(530),
    [anon_sym_i128] = ACTIONS(530),
    [anon_sym_usize] = ACTIONS(530),
    [anon_sym_bool] = ACTIONS(530),
    [anon_sym_ByteArray] = ACTIONS(530),
    [anon_sym_felt252] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(530),
    [anon_sym_GT] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(530),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_SLASH] = ACTIONS(530),
    [anon_sym_PERCENT] = ACTIONS(530),
    [anon_sym_CARET] = ACTIONS(528),
    [anon_sym_TILDE] = ACTIONS(528),
    [anon_sym_AMP] = ACTIONS(530),
    [anon_sym_PIPE] = ACTIONS(530),
    [anon_sym_AMP_AMP] = ACTIONS(528),
    [anon_sym_PIPE_PIPE] = ACTIONS(528),
    [anon_sym_LT_LT] = ACTIONS(528),
    [anon_sym_GT_GT] = ACTIONS(528),
    [anon_sym_PLUS_EQ] = ACTIONS(528),
    [anon_sym_DASH_EQ] = ACTIONS(528),
    [anon_sym_STAR_EQ] = ACTIONS(528),
    [anon_sym_SLASH_EQ] = ACTIONS(528),
    [anon_sym_PERCENT_EQ] = ACTIONS(528),
    [anon_sym_EQ_EQ] = ACTIONS(528),
    [anon_sym_BANG_EQ] = ACTIONS(528),
    [anon_sym_GT_EQ] = ACTIONS(528),
    [anon_sym_LT_EQ] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(528),
    [anon_sym_DOT] = ACTIONS(528),
    [anon_sym_QMARK] = ACTIONS(528),
    [anon_sym_break] = ACTIONS(530),
    [anon_sym_continue] = ACTIONS(530),
    [anon_sym_default] = ACTIONS(530),
    [anon_sym_if] = ACTIONS(530),
    [anon_sym_extern] = ACTIONS(530),
    [anon_sym_loop] = ACTIONS(530),
    [anon_sym_match] = ACTIONS(530),
    [anon_sym_pub] = ACTIONS(530),
    [anon_sym_return] = ACTIONS(530),
    [anon_sym_while] = ACTIONS(530),
    [anon_sym_for] = ACTIONS(530),
    [sym_numeric_literal] = ACTIONS(530),
    [aux_sym_string_literal_token1] = ACTIONS(528),
    [sym_shortstring_literal] = ACTIONS(528),
    [anon_sym_true] = ACTIONS(530),
    [anon_sym_false] = ACTIONS(530),
    [anon_sym_ref] = ACTIONS(530),
    [sym_identifier] = ACTIONS(530),
    [sym_super] = ACTIONS(530),
    [sym_line_comment] = ACTIONS(3),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_impl] = ACTIONS(491),
    [anon_sym_SEMI] = ACTIONS(489),
    [anon_sym_trait] = ACTIONS(491),
    [anon_sym_type] = ACTIONS(491),
    [anon_sym_const] = ACTIONS(491),
    [anon_sym_EQ] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_POUND] = ACTIONS(489),
    [anon_sym_LBRACK] = ACTIONS(489),
    [anon_sym_RBRACK] = ACTIONS(489),
    [anon_sym_mod] = ACTIONS(491),
    [anon_sym_struct] = ACTIONS(491),
    [anon_sym_enum] = ACTIONS(491),
    [anon_sym_COMMA] = ACTIONS(489),
    [anon_sym_fn] = ACTIONS(491),
    [anon_sym_let] = ACTIONS(491),
    [anon_sym_use] = ACTIONS(491),
    [anon_sym_COLON_COLON] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_RPAREN] = ACTIONS(489),
    [anon_sym_u8] = ACTIONS(491),
    [anon_sym_i8] = ACTIONS(491),
    [anon_sym_u16] = ACTIONS(491),
    [anon_sym_i16] = ACTIONS(491),
    [anon_sym_u32] = ACTIONS(491),
    [anon_sym_i32] = ACTIONS(491),
    [anon_sym_u64] = ACTIONS(491),
    [anon_sym_i64] = ACTIONS(491),
    [anon_sym_u128] = ACTIONS(491),
    [anon_sym_i128] = ACTIONS(491),
    [anon_sym_usize] = ACTIONS(491),
    [anon_sym_bool] = ACTIONS(491),
    [anon_sym_ByteArray] = ACTIONS(491),
    [anon_sym_felt252] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_PERCENT] = ACTIONS(491),
    [anon_sym_CARET] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_LT_LT] = ACTIONS(489),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_PLUS_EQ] = ACTIONS(489),
    [anon_sym_DASH_EQ] = ACTIONS(489),
    [anon_sym_STAR_EQ] = ACTIONS(489),
    [anon_sym_SLASH_EQ] = ACTIONS(489),
    [anon_sym_PERCENT_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [anon_sym_DOT] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_break] = ACTIONS(491),
    [anon_sym_continue] = ACTIONS(491),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_extern] = ACTIONS(491),
    [anon_sym_loop] = ACTIONS(491),
    [anon_sym_match] = ACTIONS(491),
    [anon_sym_pub] = ACTIONS(491),
    [anon_sym_return] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(491),
    [sym_numeric_literal] = ACTIONS(491),
    [aux_sym_string_literal_token1] = ACTIONS(489),
    [sym_shortstring_literal] = ACTIONS(489),
    [anon_sym_true] = ACTIONS(491),
    [anon_sym_false] = ACTIONS(491),
    [anon_sym_ref] = ACTIONS(491),
    [sym_identifier] = ACTIONS(491),
    [sym_super] = ACTIONS(491),
    [sym_line_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(532),
    [anon_sym_LBRACE] = ACTIONS(532),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_impl] = ACTIONS(534),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_trait] = ACTIONS(534),
    [anon_sym_type] = ACTIONS(534),
    [anon_sym_const] = ACTIONS(534),
    [anon_sym_EQ] = ACTIONS(534),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_POUND] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(532),
    [anon_sym_RBRACK] = ACTIONS(532),
    [anon_sym_mod] = ACTIONS(534),
    [anon_sym_struct] = ACTIONS(534),
    [anon_sym_enum] = ACTIONS(534),
    [anon_sym_COMMA] = ACTIONS(532),
    [anon_sym_fn] = ACTIONS(534),
    [anon_sym_let] = ACTIONS(534),
    [anon_sym_use] = ACTIONS(534),
    [anon_sym_COLON_COLON] = ACTIONS(532),
    [anon_sym_STAR] = ACTIONS(534),
    [anon_sym_LPAREN] = ACTIONS(532),
    [anon_sym_RPAREN] = ACTIONS(532),
    [anon_sym_u8] = ACTIONS(534),
    [anon_sym_i8] = ACTIONS(534),
    [anon_sym_u16] = ACTIONS(534),
    [anon_sym_i16] = ACTIONS(534),
    [anon_sym_u32] = ACTIONS(534),
    [anon_sym_i32] = ACTIONS(534),
    [anon_sym_u64] = ACTIONS(534),
    [anon_sym_i64] = ACTIONS(534),
    [anon_sym_u128] = ACTIONS(534),
    [anon_sym_i128] = ACTIONS(534),
    [anon_sym_usize] = ACTIONS(534),
    [anon_sym_bool] = ACTIONS(534),
    [anon_sym_ByteArray] = ACTIONS(534),
    [anon_sym_felt252] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_GT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_SLASH] = ACTIONS(534),
    [anon_sym_PERCENT] = ACTIONS(534),
    [anon_sym_CARET] = ACTIONS(532),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_AMP] = ACTIONS(534),
    [anon_sym_PIPE] = ACTIONS(534),
    [anon_sym_AMP_AMP] = ACTIONS(532),
    [anon_sym_PIPE_PIPE] = ACTIONS(532),
    [anon_sym_LT_LT] = ACTIONS(532),
    [anon_sym_GT_GT] = ACTIONS(532),
    [anon_sym_PLUS_EQ] = ACTIONS(532),
    [anon_sym_DASH_EQ] = ACTIONS(532),
    [anon_sym_STAR_EQ] = ACTIONS(532),
    [anon_sym_SLASH_EQ] = ACTIONS(532),
    [anon_sym_PERCENT_EQ] = ACTIONS(532),
    [anon_sym_EQ_EQ] = ACTIONS(532),
    [anon_sym_BANG_EQ] = ACTIONS(532),
    [anon_sym_GT_EQ] = ACTIONS(532),
    [anon_sym_LT_EQ] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_DOT] = ACTIONS(532),
    [anon_sym_QMARK] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(534),
    [anon_sym_continue] = ACTIONS(534),
    [anon_sym_default] = ACTIONS(534),
    [anon_sym_if] = ACTIONS(534),
    [anon_sym_extern] = ACTIONS(534),
    [anon_sym_loop] = ACTIONS(534),
    [anon_sym_match] = ACTIONS(534),
    [anon_sym_pub] = ACTIONS(534),
    [anon_sym_return] = ACTIONS(534),
    [anon_sym_while] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(534),
    [sym_numeric_literal] = ACTIONS(534),
    [aux_sym_string_literal_token1] = ACTIONS(532),
    [sym_shortstring_literal] = ACTIONS(532),
    [anon_sym_true] = ACTIONS(534),
    [anon_sym_false] = ACTIONS(534),
    [anon_sym_ref] = ACTIONS(534),
    [sym_identifier] = ACTIONS(534),
    [sym_super] = ACTIONS(534),
    [sym_line_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(536),
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_impl] = ACTIONS(538),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_trait] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(538),
    [anon_sym_const] = ACTIONS(538),
    [anon_sym_EQ] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_POUND] = ACTIONS(536),
    [anon_sym_LBRACK] = ACTIONS(536),
    [anon_sym_RBRACK] = ACTIONS(536),
    [anon_sym_mod] = ACTIONS(538),
    [anon_sym_struct] = ACTIONS(538),
    [anon_sym_enum] = ACTIONS(538),
    [anon_sym_COMMA] = ACTIONS(536),
    [anon_sym_fn] = ACTIONS(538),
    [anon_sym_let] = ACTIONS(538),
    [anon_sym_use] = ACTIONS(538),
    [anon_sym_COLON_COLON] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(538),
    [anon_sym_LPAREN] = ACTIONS(536),
    [anon_sym_RPAREN] = ACTIONS(536),
    [anon_sym_u8] = ACTIONS(538),
    [anon_sym_i8] = ACTIONS(538),
    [anon_sym_u16] = ACTIONS(538),
    [anon_sym_i16] = ACTIONS(538),
    [anon_sym_u32] = ACTIONS(538),
    [anon_sym_i32] = ACTIONS(538),
    [anon_sym_u64] = ACTIONS(538),
    [anon_sym_i64] = ACTIONS(538),
    [anon_sym_u128] = ACTIONS(538),
    [anon_sym_i128] = ACTIONS(538),
    [anon_sym_usize] = ACTIONS(538),
    [anon_sym_bool] = ACTIONS(538),
    [anon_sym_ByteArray] = ACTIONS(538),
    [anon_sym_felt252] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(538),
    [anon_sym_DASH] = ACTIONS(538),
    [anon_sym_SLASH] = ACTIONS(538),
    [anon_sym_PERCENT] = ACTIONS(538),
    [anon_sym_CARET] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_AMP] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_AMP_AMP] = ACTIONS(536),
    [anon_sym_PIPE_PIPE] = ACTIONS(536),
    [anon_sym_LT_LT] = ACTIONS(536),
    [anon_sym_GT_GT] = ACTIONS(536),
    [anon_sym_PLUS_EQ] = ACTIONS(536),
    [anon_sym_DASH_EQ] = ACTIONS(536),
    [anon_sym_STAR_EQ] = ACTIONS(536),
    [anon_sym_SLASH_EQ] = ACTIONS(536),
    [anon_sym_PERCENT_EQ] = ACTIONS(536),
    [anon_sym_EQ_EQ] = ACTIONS(536),
    [anon_sym_BANG_EQ] = ACTIONS(536),
    [anon_sym_GT_EQ] = ACTIONS(536),
    [anon_sym_LT_EQ] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_DOT] = ACTIONS(536),
    [anon_sym_QMARK] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(538),
    [anon_sym_continue] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(538),
    [anon_sym_extern] = ACTIONS(538),
    [anon_sym_loop] = ACTIONS(538),
    [anon_sym_match] = ACTIONS(538),
    [anon_sym_pub] = ACTIONS(538),
    [anon_sym_return] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(538),
    [anon_sym_for] = ACTIONS(538),
    [sym_numeric_literal] = ACTIONS(538),
    [aux_sym_string_literal_token1] = ACTIONS(536),
    [sym_shortstring_literal] = ACTIONS(536),
    [anon_sym_true] = ACTIONS(538),
    [anon_sym_false] = ACTIONS(538),
    [anon_sym_ref] = ACTIONS(538),
    [sym_identifier] = ACTIONS(538),
    [sym_super] = ACTIONS(538),
    [sym_line_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(540),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_impl] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(540),
    [anon_sym_trait] = ACTIONS(542),
    [anon_sym_type] = ACTIONS(542),
    [anon_sym_const] = ACTIONS(542),
    [anon_sym_EQ] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_POUND] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(540),
    [anon_sym_RBRACK] = ACTIONS(540),
    [anon_sym_mod] = ACTIONS(542),
    [anon_sym_struct] = ACTIONS(542),
    [anon_sym_enum] = ACTIONS(542),
    [anon_sym_COMMA] = ACTIONS(540),
    [anon_sym_fn] = ACTIONS(542),
    [anon_sym_let] = ACTIONS(542),
    [anon_sym_use] = ACTIONS(542),
    [anon_sym_COLON_COLON] = ACTIONS(540),
    [anon_sym_STAR] = ACTIONS(542),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_u8] = ACTIONS(542),
    [anon_sym_i8] = ACTIONS(542),
    [anon_sym_u16] = ACTIONS(542),
    [anon_sym_i16] = ACTIONS(542),
    [anon_sym_u32] = ACTIONS(542),
    [anon_sym_i32] = ACTIONS(542),
    [anon_sym_u64] = ACTIONS(542),
    [anon_sym_i64] = ACTIONS(542),
    [anon_sym_u128] = ACTIONS(542),
    [anon_sym_i128] = ACTIONS(542),
    [anon_sym_usize] = ACTIONS(542),
    [anon_sym_bool] = ACTIONS(542),
    [anon_sym_ByteArray] = ACTIONS(542),
    [anon_sym_felt252] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_GT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_SLASH] = ACTIONS(542),
    [anon_sym_PERCENT] = ACTIONS(542),
    [anon_sym_CARET] = ACTIONS(540),
    [anon_sym_TILDE] = ACTIONS(540),
    [anon_sym_AMP] = ACTIONS(542),
    [anon_sym_PIPE] = ACTIONS(542),
    [anon_sym_AMP_AMP] = ACTIONS(540),
    [anon_sym_PIPE_PIPE] = ACTIONS(540),
    [anon_sym_LT_LT] = ACTIONS(540),
    [anon_sym_GT_GT] = ACTIONS(540),
    [anon_sym_PLUS_EQ] = ACTIONS(540),
    [anon_sym_DASH_EQ] = ACTIONS(540),
    [anon_sym_STAR_EQ] = ACTIONS(540),
    [anon_sym_SLASH_EQ] = ACTIONS(540),
    [anon_sym_PERCENT_EQ] = ACTIONS(540),
    [anon_sym_EQ_EQ] = ACTIONS(540),
    [anon_sym_BANG_EQ] = ACTIONS(540),
    [anon_sym_GT_EQ] = ACTIONS(540),
    [anon_sym_LT_EQ] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_DOT] = ACTIONS(540),
    [anon_sym_QMARK] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(542),
    [anon_sym_continue] = ACTIONS(542),
    [anon_sym_default] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_extern] = ACTIONS(542),
    [anon_sym_loop] = ACTIONS(542),
    [anon_sym_match] = ACTIONS(542),
    [anon_sym_pub] = ACTIONS(542),
    [anon_sym_return] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(542),
    [anon_sym_for] = ACTIONS(542),
    [sym_numeric_literal] = ACTIONS(542),
    [aux_sym_string_literal_token1] = ACTIONS(540),
    [sym_shortstring_literal] = ACTIONS(540),
    [anon_sym_true] = ACTIONS(542),
    [anon_sym_false] = ACTIONS(542),
    [anon_sym_ref] = ACTIONS(542),
    [sym_identifier] = ACTIONS(542),
    [sym_super] = ACTIONS(542),
    [sym_line_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(544),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_impl] = ACTIONS(546),
    [anon_sym_SEMI] = ACTIONS(544),
    [anon_sym_trait] = ACTIONS(546),
    [anon_sym_type] = ACTIONS(546),
    [anon_sym_const] = ACTIONS(546),
    [anon_sym_EQ] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_POUND] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(544),
    [anon_sym_RBRACK] = ACTIONS(544),
    [anon_sym_mod] = ACTIONS(546),
    [anon_sym_struct] = ACTIONS(546),
    [anon_sym_enum] = ACTIONS(546),
    [anon_sym_COMMA] = ACTIONS(544),
    [anon_sym_fn] = ACTIONS(546),
    [anon_sym_let] = ACTIONS(546),
    [anon_sym_use] = ACTIONS(546),
    [anon_sym_COLON_COLON] = ACTIONS(544),
    [anon_sym_STAR] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(544),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_u8] = ACTIONS(546),
    [anon_sym_i8] = ACTIONS(546),
    [anon_sym_u16] = ACTIONS(546),
    [anon_sym_i16] = ACTIONS(546),
    [anon_sym_u32] = ACTIONS(546),
    [anon_sym_i32] = ACTIONS(546),
    [anon_sym_u64] = ACTIONS(546),
    [anon_sym_i64] = ACTIONS(546),
    [anon_sym_u128] = ACTIONS(546),
    [anon_sym_i128] = ACTIONS(546),
    [anon_sym_usize] = ACTIONS(546),
    [anon_sym_bool] = ACTIONS(546),
    [anon_sym_ByteArray] = ACTIONS(546),
    [anon_sym_felt252] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_GT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(546),
    [anon_sym_PERCENT] = ACTIONS(546),
    [anon_sym_CARET] = ACTIONS(544),
    [anon_sym_TILDE] = ACTIONS(544),
    [anon_sym_AMP] = ACTIONS(546),
    [anon_sym_PIPE] = ACTIONS(546),
    [anon_sym_AMP_AMP] = ACTIONS(544),
    [anon_sym_PIPE_PIPE] = ACTIONS(544),
    [anon_sym_LT_LT] = ACTIONS(544),
    [anon_sym_GT_GT] = ACTIONS(544),
    [anon_sym_PLUS_EQ] = ACTIONS(544),
    [anon_sym_DASH_EQ] = ACTIONS(544),
    [anon_sym_STAR_EQ] = ACTIONS(544),
    [anon_sym_SLASH_EQ] = ACTIONS(544),
    [anon_sym_PERCENT_EQ] = ACTIONS(544),
    [anon_sym_EQ_EQ] = ACTIONS(544),
    [anon_sym_BANG_EQ] = ACTIONS(544),
    [anon_sym_GT_EQ] = ACTIONS(544),
    [anon_sym_LT_EQ] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_DOT] = ACTIONS(544),
    [anon_sym_QMARK] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(546),
    [anon_sym_continue] = ACTIONS(546),
    [anon_sym_default] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_extern] = ACTIONS(546),
    [anon_sym_loop] = ACTIONS(546),
    [anon_sym_match] = ACTIONS(546),
    [anon_sym_pub] = ACTIONS(546),
    [anon_sym_return] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(546),
    [sym_numeric_literal] = ACTIONS(546),
    [aux_sym_string_literal_token1] = ACTIONS(544),
    [sym_shortstring_literal] = ACTIONS(544),
    [anon_sym_true] = ACTIONS(546),
    [anon_sym_false] = ACTIONS(546),
    [anon_sym_ref] = ACTIONS(546),
    [sym_identifier] = ACTIONS(546),
    [sym_super] = ACTIONS(546),
    [sym_line_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(548),
    [anon_sym_LBRACE] = ACTIONS(548),
    [anon_sym_RBRACE] = ACTIONS(548),
    [anon_sym_impl] = ACTIONS(550),
    [anon_sym_SEMI] = ACTIONS(548),
    [anon_sym_trait] = ACTIONS(550),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_const] = ACTIONS(550),
    [anon_sym_EQ] = ACTIONS(550),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_POUND] = ACTIONS(548),
    [anon_sym_LBRACK] = ACTIONS(548),
    [anon_sym_RBRACK] = ACTIONS(548),
    [anon_sym_mod] = ACTIONS(550),
    [anon_sym_struct] = ACTIONS(550),
    [anon_sym_enum] = ACTIONS(550),
    [anon_sym_COMMA] = ACTIONS(548),
    [anon_sym_fn] = ACTIONS(550),
    [anon_sym_let] = ACTIONS(550),
    [anon_sym_use] = ACTIONS(550),
    [anon_sym_COLON_COLON] = ACTIONS(548),
    [anon_sym_STAR] = ACTIONS(550),
    [anon_sym_LPAREN] = ACTIONS(548),
    [anon_sym_RPAREN] = ACTIONS(548),
    [anon_sym_u8] = ACTIONS(550),
    [anon_sym_i8] = ACTIONS(550),
    [anon_sym_u16] = ACTIONS(550),
    [anon_sym_i16] = ACTIONS(550),
    [anon_sym_u32] = ACTIONS(550),
    [anon_sym_i32] = ACTIONS(550),
    [anon_sym_u64] = ACTIONS(550),
    [anon_sym_i64] = ACTIONS(550),
    [anon_sym_u128] = ACTIONS(550),
    [anon_sym_i128] = ACTIONS(550),
    [anon_sym_usize] = ACTIONS(550),
    [anon_sym_bool] = ACTIONS(550),
    [anon_sym_ByteArray] = ACTIONS(550),
    [anon_sym_felt252] = ACTIONS(550),
    [anon_sym_LT] = ACTIONS(550),
    [anon_sym_GT] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(550),
    [anon_sym_DASH] = ACTIONS(550),
    [anon_sym_SLASH] = ACTIONS(550),
    [anon_sym_PERCENT] = ACTIONS(550),
    [anon_sym_CARET] = ACTIONS(548),
    [anon_sym_TILDE] = ACTIONS(548),
    [anon_sym_AMP] = ACTIONS(550),
    [anon_sym_PIPE] = ACTIONS(550),
    [anon_sym_AMP_AMP] = ACTIONS(548),
    [anon_sym_PIPE_PIPE] = ACTIONS(548),
    [anon_sym_LT_LT] = ACTIONS(548),
    [anon_sym_GT_GT] = ACTIONS(548),
    [anon_sym_PLUS_EQ] = ACTIONS(548),
    [anon_sym_DASH_EQ] = ACTIONS(548),
    [anon_sym_STAR_EQ] = ACTIONS(548),
    [anon_sym_SLASH_EQ] = ACTIONS(548),
    [anon_sym_PERCENT_EQ] = ACTIONS(548),
    [anon_sym_EQ_EQ] = ACTIONS(548),
    [anon_sym_BANG_EQ] = ACTIONS(548),
    [anon_sym_GT_EQ] = ACTIONS(548),
    [anon_sym_LT_EQ] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_DOT] = ACTIONS(548),
    [anon_sym_QMARK] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(550),
    [anon_sym_continue] = ACTIONS(550),
    [anon_sym_default] = ACTIONS(550),
    [anon_sym_if] = ACTIONS(550),
    [anon_sym_extern] = ACTIONS(550),
    [anon_sym_loop] = ACTIONS(550),
    [anon_sym_match] = ACTIONS(550),
    [anon_sym_pub] = ACTIONS(550),
    [anon_sym_return] = ACTIONS(550),
    [anon_sym_while] = ACTIONS(550),
    [anon_sym_for] = ACTIONS(550),
    [sym_numeric_literal] = ACTIONS(550),
    [aux_sym_string_literal_token1] = ACTIONS(548),
    [sym_shortstring_literal] = ACTIONS(548),
    [anon_sym_true] = ACTIONS(550),
    [anon_sym_false] = ACTIONS(550),
    [anon_sym_ref] = ACTIONS(550),
    [sym_identifier] = ACTIONS(550),
    [sym_super] = ACTIONS(550),
    [sym_line_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(552),
    [anon_sym_impl] = ACTIONS(554),
    [anon_sym_SEMI] = ACTIONS(552),
    [anon_sym_trait] = ACTIONS(554),
    [anon_sym_type] = ACTIONS(554),
    [anon_sym_const] = ACTIONS(554),
    [anon_sym_EQ] = ACTIONS(554),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_POUND] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(552),
    [anon_sym_RBRACK] = ACTIONS(552),
    [anon_sym_mod] = ACTIONS(554),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_enum] = ACTIONS(554),
    [anon_sym_COMMA] = ACTIONS(552),
    [anon_sym_fn] = ACTIONS(554),
    [anon_sym_let] = ACTIONS(554),
    [anon_sym_use] = ACTIONS(554),
    [anon_sym_COLON_COLON] = ACTIONS(552),
    [anon_sym_STAR] = ACTIONS(554),
    [anon_sym_LPAREN] = ACTIONS(552),
    [anon_sym_RPAREN] = ACTIONS(552),
    [anon_sym_u8] = ACTIONS(554),
    [anon_sym_i8] = ACTIONS(554),
    [anon_sym_u16] = ACTIONS(554),
    [anon_sym_i16] = ACTIONS(554),
    [anon_sym_u32] = ACTIONS(554),
    [anon_sym_i32] = ACTIONS(554),
    [anon_sym_u64] = ACTIONS(554),
    [anon_sym_i64] = ACTIONS(554),
    [anon_sym_u128] = ACTIONS(554),
    [anon_sym_i128] = ACTIONS(554),
    [anon_sym_usize] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_ByteArray] = ACTIONS(554),
    [anon_sym_felt252] = ACTIONS(554),
    [anon_sym_LT] = ACTIONS(554),
    [anon_sym_GT] = ACTIONS(554),
    [anon_sym_PLUS] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(554),
    [anon_sym_SLASH] = ACTIONS(554),
    [anon_sym_PERCENT] = ACTIONS(554),
    [anon_sym_CARET] = ACTIONS(552),
    [anon_sym_TILDE] = ACTIONS(552),
    [anon_sym_AMP] = ACTIONS(554),
    [anon_sym_PIPE] = ACTIONS(554),
    [anon_sym_AMP_AMP] = ACTIONS(552),
    [anon_sym_PIPE_PIPE] = ACTIONS(552),
    [anon_sym_LT_LT] = ACTIONS(552),
    [anon_sym_GT_GT] = ACTIONS(552),
    [anon_sym_PLUS_EQ] = ACTIONS(552),
    [anon_sym_DASH_EQ] = ACTIONS(552),
    [anon_sym_STAR_EQ] = ACTIONS(552),
    [anon_sym_SLASH_EQ] = ACTIONS(552),
    [anon_sym_PERCENT_EQ] = ACTIONS(552),
    [anon_sym_EQ_EQ] = ACTIONS(552),
    [anon_sym_BANG_EQ] = ACTIONS(552),
    [anon_sym_GT_EQ] = ACTIONS(552),
    [anon_sym_LT_EQ] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_DOT] = ACTIONS(552),
    [anon_sym_QMARK] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(554),
    [anon_sym_continue] = ACTIONS(554),
    [anon_sym_default] = ACTIONS(554),
    [anon_sym_if] = ACTIONS(554),
    [anon_sym_extern] = ACTIONS(554),
    [anon_sym_loop] = ACTIONS(554),
    [anon_sym_match] = ACTIONS(554),
    [anon_sym_pub] = ACTIONS(554),
    [anon_sym_return] = ACTIONS(554),
    [anon_sym_while] = ACTIONS(554),
    [anon_sym_for] = ACTIONS(554),
    [sym_numeric_literal] = ACTIONS(554),
    [aux_sym_string_literal_token1] = ACTIONS(552),
    [sym_shortstring_literal] = ACTIONS(552),
    [anon_sym_true] = ACTIONS(554),
    [anon_sym_false] = ACTIONS(554),
    [anon_sym_ref] = ACTIONS(554),
    [sym_identifier] = ACTIONS(554),
    [sym_super] = ACTIONS(554),
    [sym_line_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(556),
    [anon_sym_RBRACE] = ACTIONS(556),
    [anon_sym_impl] = ACTIONS(558),
    [anon_sym_SEMI] = ACTIONS(556),
    [anon_sym_trait] = ACTIONS(558),
    [anon_sym_type] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(558),
    [anon_sym_EQ] = ACTIONS(558),
    [anon_sym_BANG] = ACTIONS(558),
    [anon_sym_POUND] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(556),
    [anon_sym_RBRACK] = ACTIONS(556),
    [anon_sym_mod] = ACTIONS(558),
    [anon_sym_struct] = ACTIONS(558),
    [anon_sym_enum] = ACTIONS(558),
    [anon_sym_COMMA] = ACTIONS(556),
    [anon_sym_fn] = ACTIONS(558),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_use] = ACTIONS(558),
    [anon_sym_COLON_COLON] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(556),
    [anon_sym_RPAREN] = ACTIONS(556),
    [anon_sym_u8] = ACTIONS(558),
    [anon_sym_i8] = ACTIONS(558),
    [anon_sym_u16] = ACTIONS(558),
    [anon_sym_i16] = ACTIONS(558),
    [anon_sym_u32] = ACTIONS(558),
    [anon_sym_i32] = ACTIONS(558),
    [anon_sym_u64] = ACTIONS(558),
    [anon_sym_i64] = ACTIONS(558),
    [anon_sym_u128] = ACTIONS(558),
    [anon_sym_i128] = ACTIONS(558),
    [anon_sym_usize] = ACTIONS(558),
    [anon_sym_bool] = ACTIONS(558),
    [anon_sym_ByteArray] = ACTIONS(558),
    [anon_sym_felt252] = ACTIONS(558),
    [anon_sym_LT] = ACTIONS(558),
    [anon_sym_GT] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(558),
    [anon_sym_DASH] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(558),
    [anon_sym_PERCENT] = ACTIONS(558),
    [anon_sym_CARET] = ACTIONS(556),
    [anon_sym_TILDE] = ACTIONS(556),
    [anon_sym_AMP] = ACTIONS(558),
    [anon_sym_PIPE] = ACTIONS(558),
    [anon_sym_AMP_AMP] = ACTIONS(556),
    [anon_sym_PIPE_PIPE] = ACTIONS(556),
    [anon_sym_LT_LT] = ACTIONS(556),
    [anon_sym_GT_GT] = ACTIONS(556),
    [anon_sym_PLUS_EQ] = ACTIONS(556),
    [anon_sym_DASH_EQ] = ACTIONS(556),
    [anon_sym_STAR_EQ] = ACTIONS(556),
    [anon_sym_SLASH_EQ] = ACTIONS(556),
    [anon_sym_PERCENT_EQ] = ACTIONS(556),
    [anon_sym_EQ_EQ] = ACTIONS(556),
    [anon_sym_BANG_EQ] = ACTIONS(556),
    [anon_sym_GT_EQ] = ACTIONS(556),
    [anon_sym_LT_EQ] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(556),
    [anon_sym_DOT] = ACTIONS(556),
    [anon_sym_QMARK] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(558),
    [anon_sym_continue] = ACTIONS(558),
    [anon_sym_default] = ACTIONS(558),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_extern] = ACTIONS(558),
    [anon_sym_loop] = ACTIONS(558),
    [anon_sym_match] = ACTIONS(558),
    [anon_sym_pub] = ACTIONS(558),
    [anon_sym_return] = ACTIONS(558),
    [anon_sym_while] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(558),
    [sym_numeric_literal] = ACTIONS(558),
    [aux_sym_string_literal_token1] = ACTIONS(556),
    [sym_shortstring_literal] = ACTIONS(556),
    [anon_sym_true] = ACTIONS(558),
    [anon_sym_false] = ACTIONS(558),
    [anon_sym_ref] = ACTIONS(558),
    [sym_identifier] = ACTIONS(558),
    [sym_super] = ACTIONS(558),
    [sym_line_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_RBRACE] = ACTIONS(560),
    [anon_sym_impl] = ACTIONS(562),
    [anon_sym_SEMI] = ACTIONS(560),
    [anon_sym_trait] = ACTIONS(562),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_const] = ACTIONS(562),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_POUND] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(560),
    [anon_sym_RBRACK] = ACTIONS(560),
    [anon_sym_mod] = ACTIONS(562),
    [anon_sym_struct] = ACTIONS(562),
    [anon_sym_enum] = ACTIONS(562),
    [anon_sym_COMMA] = ACTIONS(560),
    [anon_sym_fn] = ACTIONS(562),
    [anon_sym_let] = ACTIONS(562),
    [anon_sym_use] = ACTIONS(562),
    [anon_sym_COLON_COLON] = ACTIONS(560),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_RPAREN] = ACTIONS(560),
    [anon_sym_u8] = ACTIONS(562),
    [anon_sym_i8] = ACTIONS(562),
    [anon_sym_u16] = ACTIONS(562),
    [anon_sym_i16] = ACTIONS(562),
    [anon_sym_u32] = ACTIONS(562),
    [anon_sym_i32] = ACTIONS(562),
    [anon_sym_u64] = ACTIONS(562),
    [anon_sym_i64] = ACTIONS(562),
    [anon_sym_u128] = ACTIONS(562),
    [anon_sym_i128] = ACTIONS(562),
    [anon_sym_usize] = ACTIONS(562),
    [anon_sym_bool] = ACTIONS(562),
    [anon_sym_ByteArray] = ACTIONS(562),
    [anon_sym_felt252] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(562),
    [anon_sym_DASH] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(562),
    [anon_sym_PERCENT] = ACTIONS(562),
    [anon_sym_CARET] = ACTIONS(560),
    [anon_sym_TILDE] = ACTIONS(560),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP_AMP] = ACTIONS(560),
    [anon_sym_PIPE_PIPE] = ACTIONS(560),
    [anon_sym_LT_LT] = ACTIONS(560),
    [anon_sym_GT_GT] = ACTIONS(560),
    [anon_sym_PLUS_EQ] = ACTIONS(560),
    [anon_sym_DASH_EQ] = ACTIONS(560),
    [anon_sym_STAR_EQ] = ACTIONS(560),
    [anon_sym_SLASH_EQ] = ACTIONS(560),
    [anon_sym_PERCENT_EQ] = ACTIONS(560),
    [anon_sym_EQ_EQ] = ACTIONS(560),
    [anon_sym_BANG_EQ] = ACTIONS(560),
    [anon_sym_GT_EQ] = ACTIONS(560),
    [anon_sym_LT_EQ] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_DOT] = ACTIONS(560),
    [anon_sym_QMARK] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(562),
    [anon_sym_continue] = ACTIONS(562),
    [anon_sym_default] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_extern] = ACTIONS(562),
    [anon_sym_loop] = ACTIONS(562),
    [anon_sym_match] = ACTIONS(562),
    [anon_sym_pub] = ACTIONS(562),
    [anon_sym_return] = ACTIONS(562),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(562),
    [sym_numeric_literal] = ACTIONS(562),
    [aux_sym_string_literal_token1] = ACTIONS(560),
    [sym_shortstring_literal] = ACTIONS(560),
    [anon_sym_true] = ACTIONS(562),
    [anon_sym_false] = ACTIONS(562),
    [anon_sym_ref] = ACTIONS(562),
    [sym_identifier] = ACTIONS(562),
    [sym_super] = ACTIONS(562),
    [sym_line_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_RBRACE] = ACTIONS(564),
    [anon_sym_impl] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(564),
    [anon_sym_trait] = ACTIONS(566),
    [anon_sym_type] = ACTIONS(566),
    [anon_sym_const] = ACTIONS(566),
    [anon_sym_EQ] = ACTIONS(566),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_POUND] = ACTIONS(564),
    [anon_sym_LBRACK] = ACTIONS(564),
    [anon_sym_RBRACK] = ACTIONS(564),
    [anon_sym_mod] = ACTIONS(566),
    [anon_sym_struct] = ACTIONS(566),
    [anon_sym_enum] = ACTIONS(566),
    [anon_sym_COMMA] = ACTIONS(564),
    [anon_sym_fn] = ACTIONS(566),
    [anon_sym_let] = ACTIONS(566),
    [anon_sym_use] = ACTIONS(566),
    [anon_sym_COLON_COLON] = ACTIONS(564),
    [anon_sym_STAR] = ACTIONS(566),
    [anon_sym_LPAREN] = ACTIONS(564),
    [anon_sym_RPAREN] = ACTIONS(564),
    [anon_sym_u8] = ACTIONS(566),
    [anon_sym_i8] = ACTIONS(566),
    [anon_sym_u16] = ACTIONS(566),
    [anon_sym_i16] = ACTIONS(566),
    [anon_sym_u32] = ACTIONS(566),
    [anon_sym_i32] = ACTIONS(566),
    [anon_sym_u64] = ACTIONS(566),
    [anon_sym_i64] = ACTIONS(566),
    [anon_sym_u128] = ACTIONS(566),
    [anon_sym_i128] = ACTIONS(566),
    [anon_sym_usize] = ACTIONS(566),
    [anon_sym_bool] = ACTIONS(566),
    [anon_sym_ByteArray] = ACTIONS(566),
    [anon_sym_felt252] = ACTIONS(566),
    [anon_sym_LT] = ACTIONS(566),
    [anon_sym_GT] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(566),
    [anon_sym_DASH] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(566),
    [anon_sym_PERCENT] = ACTIONS(566),
    [anon_sym_CARET] = ACTIONS(564),
    [anon_sym_TILDE] = ACTIONS(564),
    [anon_sym_AMP] = ACTIONS(566),
    [anon_sym_PIPE] = ACTIONS(566),
    [anon_sym_AMP_AMP] = ACTIONS(564),
    [anon_sym_PIPE_PIPE] = ACTIONS(564),
    [anon_sym_LT_LT] = ACTIONS(564),
    [anon_sym_GT_GT] = ACTIONS(564),
    [anon_sym_PLUS_EQ] = ACTIONS(564),
    [anon_sym_DASH_EQ] = ACTIONS(564),
    [anon_sym_STAR_EQ] = ACTIONS(564),
    [anon_sym_SLASH_EQ] = ACTIONS(564),
    [anon_sym_PERCENT_EQ] = ACTIONS(564),
    [anon_sym_EQ_EQ] = ACTIONS(564),
    [anon_sym_BANG_EQ] = ACTIONS(564),
    [anon_sym_GT_EQ] = ACTIONS(564),
    [anon_sym_LT_EQ] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(564),
    [anon_sym_QMARK] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(566),
    [anon_sym_continue] = ACTIONS(566),
    [anon_sym_default] = ACTIONS(566),
    [anon_sym_if] = ACTIONS(566),
    [anon_sym_extern] = ACTIONS(566),
    [anon_sym_loop] = ACTIONS(566),
    [anon_sym_match] = ACTIONS(566),
    [anon_sym_pub] = ACTIONS(566),
    [anon_sym_return] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_for] = ACTIONS(566),
    [sym_numeric_literal] = ACTIONS(566),
    [aux_sym_string_literal_token1] = ACTIONS(564),
    [sym_shortstring_literal] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [anon_sym_ref] = ACTIONS(566),
    [sym_identifier] = ACTIONS(566),
    [sym_super] = ACTIONS(566),
    [sym_line_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_impl] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_trait] = ACTIONS(510),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_EQ] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_POUND] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(508),
    [anon_sym_RBRACK] = ACTIONS(508),
    [anon_sym_mod] = ACTIONS(510),
    [anon_sym_struct] = ACTIONS(510),
    [anon_sym_enum] = ACTIONS(510),
    [anon_sym_COMMA] = ACTIONS(508),
    [anon_sym_fn] = ACTIONS(510),
    [anon_sym_let] = ACTIONS(510),
    [anon_sym_use] = ACTIONS(510),
    [anon_sym_COLON_COLON] = ACTIONS(508),
    [anon_sym_STAR] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_RPAREN] = ACTIONS(508),
    [anon_sym_u8] = ACTIONS(510),
    [anon_sym_i8] = ACTIONS(510),
    [anon_sym_u16] = ACTIONS(510),
    [anon_sym_i16] = ACTIONS(510),
    [anon_sym_u32] = ACTIONS(510),
    [anon_sym_i32] = ACTIONS(510),
    [anon_sym_u64] = ACTIONS(510),
    [anon_sym_i64] = ACTIONS(510),
    [anon_sym_u128] = ACTIONS(510),
    [anon_sym_i128] = ACTIONS(510),
    [anon_sym_usize] = ACTIONS(510),
    [anon_sym_bool] = ACTIONS(510),
    [anon_sym_ByteArray] = ACTIONS(510),
    [anon_sym_felt252] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(510),
    [anon_sym_PERCENT] = ACTIONS(510),
    [anon_sym_CARET] = ACTIONS(508),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_AMP] = ACTIONS(510),
    [anon_sym_PIPE] = ACTIONS(510),
    [anon_sym_AMP_AMP] = ACTIONS(508),
    [anon_sym_PIPE_PIPE] = ACTIONS(508),
    [anon_sym_LT_LT] = ACTIONS(508),
    [anon_sym_GT_GT] = ACTIONS(508),
    [anon_sym_PLUS_EQ] = ACTIONS(508),
    [anon_sym_DASH_EQ] = ACTIONS(508),
    [anon_sym_STAR_EQ] = ACTIONS(508),
    [anon_sym_SLASH_EQ] = ACTIONS(508),
    [anon_sym_PERCENT_EQ] = ACTIONS(508),
    [anon_sym_EQ_EQ] = ACTIONS(508),
    [anon_sym_BANG_EQ] = ACTIONS(508),
    [anon_sym_GT_EQ] = ACTIONS(508),
    [anon_sym_LT_EQ] = ACTIONS(508),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_DOT] = ACTIONS(508),
    [anon_sym_QMARK] = ACTIONS(508),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_extern] = ACTIONS(510),
    [anon_sym_loop] = ACTIONS(510),
    [anon_sym_match] = ACTIONS(510),
    [anon_sym_pub] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [sym_numeric_literal] = ACTIONS(510),
    [aux_sym_string_literal_token1] = ACTIONS(508),
    [sym_shortstring_literal] = ACTIONS(508),
    [anon_sym_true] = ACTIONS(510),
    [anon_sym_false] = ACTIONS(510),
    [anon_sym_ref] = ACTIONS(510),
    [sym_identifier] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_line_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_else_clause] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_RBRACE] = ACTIONS(568),
    [anon_sym_impl] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(568),
    [anon_sym_trait] = ACTIONS(570),
    [anon_sym_type] = ACTIONS(570),
    [anon_sym_const] = ACTIONS(570),
    [anon_sym_EQ] = ACTIONS(570),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_POUND] = ACTIONS(568),
    [anon_sym_LBRACK] = ACTIONS(568),
    [anon_sym_mod] = ACTIONS(570),
    [anon_sym_struct] = ACTIONS(570),
    [anon_sym_enum] = ACTIONS(570),
    [anon_sym_fn] = ACTIONS(570),
    [anon_sym_let] = ACTIONS(570),
    [anon_sym_use] = ACTIONS(570),
    [anon_sym_COLON_COLON] = ACTIONS(568),
    [anon_sym_STAR] = ACTIONS(570),
    [anon_sym_LPAREN] = ACTIONS(568),
    [anon_sym_u8] = ACTIONS(570),
    [anon_sym_i8] = ACTIONS(570),
    [anon_sym_u16] = ACTIONS(570),
    [anon_sym_i16] = ACTIONS(570),
    [anon_sym_u32] = ACTIONS(570),
    [anon_sym_i32] = ACTIONS(570),
    [anon_sym_u64] = ACTIONS(570),
    [anon_sym_i64] = ACTIONS(570),
    [anon_sym_u128] = ACTIONS(570),
    [anon_sym_i128] = ACTIONS(570),
    [anon_sym_usize] = ACTIONS(570),
    [anon_sym_bool] = ACTIONS(570),
    [anon_sym_ByteArray] = ACTIONS(570),
    [anon_sym_felt252] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(570),
    [anon_sym_GT] = ACTIONS(570),
    [anon_sym_PLUS] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(570),
    [anon_sym_SLASH] = ACTIONS(570),
    [anon_sym_PERCENT] = ACTIONS(570),
    [anon_sym_CARET] = ACTIONS(568),
    [anon_sym_TILDE] = ACTIONS(568),
    [anon_sym_AMP] = ACTIONS(570),
    [anon_sym_PIPE] = ACTIONS(570),
    [anon_sym_AMP_AMP] = ACTIONS(568),
    [anon_sym_PIPE_PIPE] = ACTIONS(568),
    [anon_sym_LT_LT] = ACTIONS(568),
    [anon_sym_GT_GT] = ACTIONS(568),
    [anon_sym_PLUS_EQ] = ACTIONS(568),
    [anon_sym_DASH_EQ] = ACTIONS(568),
    [anon_sym_STAR_EQ] = ACTIONS(568),
    [anon_sym_SLASH_EQ] = ACTIONS(568),
    [anon_sym_PERCENT_EQ] = ACTIONS(568),
    [anon_sym_EQ_EQ] = ACTIONS(568),
    [anon_sym_BANG_EQ] = ACTIONS(568),
    [anon_sym_GT_EQ] = ACTIONS(568),
    [anon_sym_LT_EQ] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_DOT] = ACTIONS(568),
    [anon_sym_QMARK] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(570),
    [anon_sym_continue] = ACTIONS(570),
    [anon_sym_default] = ACTIONS(570),
    [anon_sym_if] = ACTIONS(570),
    [anon_sym_extern] = ACTIONS(570),
    [anon_sym_loop] = ACTIONS(570),
    [anon_sym_match] = ACTIONS(570),
    [anon_sym_pub] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(570),
    [anon_sym_while] = ACTIONS(570),
    [anon_sym_for] = ACTIONS(570),
    [sym_numeric_literal] = ACTIONS(570),
    [aux_sym_string_literal_token1] = ACTIONS(568),
    [sym_shortstring_literal] = ACTIONS(568),
    [anon_sym_true] = ACTIONS(570),
    [anon_sym_false] = ACTIONS(570),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_ref] = ACTIONS(570),
    [sym_identifier] = ACTIONS(570),
    [sym_super] = ACTIONS(570),
    [sym_line_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(536),
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_impl] = ACTIONS(538),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_trait] = ACTIONS(538),
    [anon_sym_type] = ACTIONS(538),
    [anon_sym_const] = ACTIONS(538),
    [anon_sym_EQ] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_POUND] = ACTIONS(536),
    [anon_sym_LBRACK] = ACTIONS(536),
    [anon_sym_mod] = ACTIONS(538),
    [anon_sym_struct] = ACTIONS(538),
    [anon_sym_enum] = ACTIONS(538),
    [anon_sym_fn] = ACTIONS(538),
    [anon_sym_let] = ACTIONS(538),
    [anon_sym_use] = ACTIONS(538),
    [anon_sym_COLON_COLON] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(538),
    [anon_sym_LPAREN] = ACTIONS(536),
    [anon_sym_u8] = ACTIONS(538),
    [anon_sym_i8] = ACTIONS(538),
    [anon_sym_u16] = ACTIONS(538),
    [anon_sym_i16] = ACTIONS(538),
    [anon_sym_u32] = ACTIONS(538),
    [anon_sym_i32] = ACTIONS(538),
    [anon_sym_u64] = ACTIONS(538),
    [anon_sym_i64] = ACTIONS(538),
    [anon_sym_u128] = ACTIONS(538),
    [anon_sym_i128] = ACTIONS(538),
    [anon_sym_usize] = ACTIONS(538),
    [anon_sym_bool] = ACTIONS(538),
    [anon_sym_ByteArray] = ACTIONS(538),
    [anon_sym_felt252] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(538),
    [anon_sym_DASH] = ACTIONS(538),
    [anon_sym_SLASH] = ACTIONS(538),
    [anon_sym_PERCENT] = ACTIONS(538),
    [anon_sym_CARET] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_AMP] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_AMP_AMP] = ACTIONS(536),
    [anon_sym_PIPE_PIPE] = ACTIONS(536),
    [anon_sym_LT_LT] = ACTIONS(536),
    [anon_sym_GT_GT] = ACTIONS(536),
    [anon_sym_PLUS_EQ] = ACTIONS(536),
    [anon_sym_DASH_EQ] = ACTIONS(536),
    [anon_sym_STAR_EQ] = ACTIONS(536),
    [anon_sym_SLASH_EQ] = ACTIONS(536),
    [anon_sym_PERCENT_EQ] = ACTIONS(536),
    [anon_sym_EQ_EQ] = ACTIONS(536),
    [anon_sym_BANG_EQ] = ACTIONS(536),
    [anon_sym_GT_EQ] = ACTIONS(536),
    [anon_sym_LT_EQ] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_DOT] = ACTIONS(536),
    [anon_sym_QMARK] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(538),
    [anon_sym_continue] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(538),
    [anon_sym_extern] = ACTIONS(538),
    [anon_sym_loop] = ACTIONS(538),
    [anon_sym_match] = ACTIONS(538),
    [anon_sym_pub] = ACTIONS(538),
    [anon_sym_return] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(538),
    [anon_sym_for] = ACTIONS(538),
    [sym_numeric_literal] = ACTIONS(538),
    [aux_sym_string_literal_token1] = ACTIONS(536),
    [sym_shortstring_literal] = ACTIONS(536),
    [anon_sym_true] = ACTIONS(538),
    [anon_sym_false] = ACTIONS(538),
    [anon_sym_else] = ACTIONS(538),
    [anon_sym_ref] = ACTIONS(538),
    [sym_identifier] = ACTIONS(538),
    [sym_super] = ACTIONS(538),
    [sym_line_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(540),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_impl] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(540),
    [anon_sym_trait] = ACTIONS(542),
    [anon_sym_type] = ACTIONS(542),
    [anon_sym_const] = ACTIONS(542),
    [anon_sym_EQ] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_POUND] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(540),
    [anon_sym_mod] = ACTIONS(542),
    [anon_sym_struct] = ACTIONS(542),
    [anon_sym_enum] = ACTIONS(542),
    [anon_sym_fn] = ACTIONS(542),
    [anon_sym_let] = ACTIONS(542),
    [anon_sym_use] = ACTIONS(542),
    [anon_sym_COLON_COLON] = ACTIONS(540),
    [anon_sym_STAR] = ACTIONS(542),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym_u8] = ACTIONS(542),
    [anon_sym_i8] = ACTIONS(542),
    [anon_sym_u16] = ACTIONS(542),
    [anon_sym_i16] = ACTIONS(542),
    [anon_sym_u32] = ACTIONS(542),
    [anon_sym_i32] = ACTIONS(542),
    [anon_sym_u64] = ACTIONS(542),
    [anon_sym_i64] = ACTIONS(542),
    [anon_sym_u128] = ACTIONS(542),
    [anon_sym_i128] = ACTIONS(542),
    [anon_sym_usize] = ACTIONS(542),
    [anon_sym_bool] = ACTIONS(542),
    [anon_sym_ByteArray] = ACTIONS(542),
    [anon_sym_felt252] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_GT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_SLASH] = ACTIONS(542),
    [anon_sym_PERCENT] = ACTIONS(542),
    [anon_sym_CARET] = ACTIONS(540),
    [anon_sym_TILDE] = ACTIONS(540),
    [anon_sym_AMP] = ACTIONS(542),
    [anon_sym_PIPE] = ACTIONS(542),
    [anon_sym_AMP_AMP] = ACTIONS(540),
    [anon_sym_PIPE_PIPE] = ACTIONS(540),
    [anon_sym_LT_LT] = ACTIONS(540),
    [anon_sym_GT_GT] = ACTIONS(540),
    [anon_sym_PLUS_EQ] = ACTIONS(540),
    [anon_sym_DASH_EQ] = ACTIONS(540),
    [anon_sym_STAR_EQ] = ACTIONS(540),
    [anon_sym_SLASH_EQ] = ACTIONS(540),
    [anon_sym_PERCENT_EQ] = ACTIONS(540),
    [anon_sym_EQ_EQ] = ACTIONS(540),
    [anon_sym_BANG_EQ] = ACTIONS(540),
    [anon_sym_GT_EQ] = ACTIONS(540),
    [anon_sym_LT_EQ] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_DOT] = ACTIONS(540),
    [anon_sym_QMARK] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(542),
    [anon_sym_continue] = ACTIONS(542),
    [anon_sym_default] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_extern] = ACTIONS(542),
    [anon_sym_loop] = ACTIONS(542),
    [anon_sym_match] = ACTIONS(542),
    [anon_sym_pub] = ACTIONS(542),
    [anon_sym_return] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(542),
    [anon_sym_for] = ACTIONS(542),
    [sym_numeric_literal] = ACTIONS(542),
    [aux_sym_string_literal_token1] = ACTIONS(540),
    [sym_shortstring_literal] = ACTIONS(540),
    [anon_sym_true] = ACTIONS(542),
    [anon_sym_false] = ACTIONS(542),
    [anon_sym_else] = ACTIONS(542),
    [anon_sym_ref] = ACTIONS(542),
    [sym_identifier] = ACTIONS(542),
    [sym_super] = ACTIONS(542),
    [sym_line_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_RBRACE] = ACTIONS(560),
    [anon_sym_impl] = ACTIONS(562),
    [anon_sym_SEMI] = ACTIONS(560),
    [anon_sym_trait] = ACTIONS(562),
    [anon_sym_type] = ACTIONS(562),
    [anon_sym_const] = ACTIONS(562),
    [anon_sym_EQ] = ACTIONS(562),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_POUND] = ACTIONS(560),
    [anon_sym_LBRACK] = ACTIONS(560),
    [anon_sym_mod] = ACTIONS(562),
    [anon_sym_struct] = ACTIONS(562),
    [anon_sym_enum] = ACTIONS(562),
    [anon_sym_fn] = ACTIONS(562),
    [anon_sym_let] = ACTIONS(562),
    [anon_sym_use] = ACTIONS(562),
    [anon_sym_COLON_COLON] = ACTIONS(560),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_u8] = ACTIONS(562),
    [anon_sym_i8] = ACTIONS(562),
    [anon_sym_u16] = ACTIONS(562),
    [anon_sym_i16] = ACTIONS(562),
    [anon_sym_u32] = ACTIONS(562),
    [anon_sym_i32] = ACTIONS(562),
    [anon_sym_u64] = ACTIONS(562),
    [anon_sym_i64] = ACTIONS(562),
    [anon_sym_u128] = ACTIONS(562),
    [anon_sym_i128] = ACTIONS(562),
    [anon_sym_usize] = ACTIONS(562),
    [anon_sym_bool] = ACTIONS(562),
    [anon_sym_ByteArray] = ACTIONS(562),
    [anon_sym_felt252] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_GT] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(562),
    [anon_sym_DASH] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(562),
    [anon_sym_PERCENT] = ACTIONS(562),
    [anon_sym_CARET] = ACTIONS(560),
    [anon_sym_TILDE] = ACTIONS(560),
    [anon_sym_AMP] = ACTIONS(562),
    [anon_sym_PIPE] = ACTIONS(562),
    [anon_sym_AMP_AMP] = ACTIONS(560),
    [anon_sym_PIPE_PIPE] = ACTIONS(560),
    [anon_sym_LT_LT] = ACTIONS(560),
    [anon_sym_GT_GT] = ACTIONS(560),
    [anon_sym_PLUS_EQ] = ACTIONS(560),
    [anon_sym_DASH_EQ] = ACTIONS(560),
    [anon_sym_STAR_EQ] = ACTIONS(560),
    [anon_sym_SLASH_EQ] = ACTIONS(560),
    [anon_sym_PERCENT_EQ] = ACTIONS(560),
    [anon_sym_EQ_EQ] = ACTIONS(560),
    [anon_sym_BANG_EQ] = ACTIONS(560),
    [anon_sym_GT_EQ] = ACTIONS(560),
    [anon_sym_LT_EQ] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_DOT] = ACTIONS(560),
    [anon_sym_QMARK] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(562),
    [anon_sym_continue] = ACTIONS(562),
    [anon_sym_default] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_extern] = ACTIONS(562),
    [anon_sym_loop] = ACTIONS(562),
    [anon_sym_match] = ACTIONS(562),
    [anon_sym_pub] = ACTIONS(562),
    [anon_sym_return] = ACTIONS(562),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(562),
    [sym_numeric_literal] = ACTIONS(562),
    [aux_sym_string_literal_token1] = ACTIONS(560),
    [sym_shortstring_literal] = ACTIONS(560),
    [anon_sym_true] = ACTIONS(562),
    [anon_sym_false] = ACTIONS(562),
    [anon_sym_else] = ACTIONS(562),
    [anon_sym_ref] = ACTIONS(562),
    [sym_identifier] = ACTIONS(562),
    [sym_super] = ACTIONS(562),
    [sym_line_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(105),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(600),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1298),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(105),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(578),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(580),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(101),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(592),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1342),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(101),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(586),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(588),
    [anon_sym_RBRACE] = ACTIONS(588),
    [anon_sym_impl] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(588),
    [anon_sym_trait] = ACTIONS(590),
    [anon_sym_type] = ACTIONS(590),
    [anon_sym_const] = ACTIONS(590),
    [anon_sym_EQ] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_POUND] = ACTIONS(588),
    [anon_sym_LBRACK] = ACTIONS(588),
    [anon_sym_mod] = ACTIONS(590),
    [anon_sym_struct] = ACTIONS(590),
    [anon_sym_enum] = ACTIONS(590),
    [anon_sym_fn] = ACTIONS(590),
    [anon_sym_let] = ACTIONS(590),
    [anon_sym_use] = ACTIONS(590),
    [anon_sym_COLON_COLON] = ACTIONS(588),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_u8] = ACTIONS(590),
    [anon_sym_i8] = ACTIONS(590),
    [anon_sym_u16] = ACTIONS(590),
    [anon_sym_i16] = ACTIONS(590),
    [anon_sym_u32] = ACTIONS(590),
    [anon_sym_i32] = ACTIONS(590),
    [anon_sym_u64] = ACTIONS(590),
    [anon_sym_i64] = ACTIONS(590),
    [anon_sym_u128] = ACTIONS(590),
    [anon_sym_i128] = ACTIONS(590),
    [anon_sym_usize] = ACTIONS(590),
    [anon_sym_bool] = ACTIONS(590),
    [anon_sym_ByteArray] = ACTIONS(590),
    [anon_sym_felt252] = ACTIONS(590),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(588),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(594),
    [anon_sym_PIPE_PIPE] = ACTIONS(594),
    [anon_sym_LT_LT] = ACTIONS(594),
    [anon_sym_GT_GT] = ACTIONS(594),
    [anon_sym_PLUS_EQ] = ACTIONS(594),
    [anon_sym_DASH_EQ] = ACTIONS(594),
    [anon_sym_STAR_EQ] = ACTIONS(594),
    [anon_sym_SLASH_EQ] = ACTIONS(594),
    [anon_sym_PERCENT_EQ] = ACTIONS(594),
    [anon_sym_EQ_EQ] = ACTIONS(594),
    [anon_sym_BANG_EQ] = ACTIONS(594),
    [anon_sym_GT_EQ] = ACTIONS(594),
    [anon_sym_LT_EQ] = ACTIONS(594),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_DOT] = ACTIONS(594),
    [anon_sym_QMARK] = ACTIONS(594),
    [anon_sym_break] = ACTIONS(590),
    [anon_sym_continue] = ACTIONS(590),
    [anon_sym_default] = ACTIONS(590),
    [anon_sym_if] = ACTIONS(590),
    [anon_sym_extern] = ACTIONS(590),
    [anon_sym_loop] = ACTIONS(590),
    [anon_sym_match] = ACTIONS(590),
    [anon_sym_pub] = ACTIONS(590),
    [anon_sym_return] = ACTIONS(590),
    [anon_sym_while] = ACTIONS(590),
    [anon_sym_for] = ACTIONS(590),
    [sym_numeric_literal] = ACTIONS(590),
    [aux_sym_string_literal_token1] = ACTIONS(588),
    [sym_shortstring_literal] = ACTIONS(588),
    [anon_sym_true] = ACTIONS(590),
    [anon_sym_false] = ACTIONS(590),
    [anon_sym_ref] = ACTIONS(590),
    [sym_identifier] = ACTIONS(590),
    [sym_super] = ACTIONS(590),
    [sym_line_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(596),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(598),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(600),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(602),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(594),
    [anon_sym_impl] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(594),
    [anon_sym_trait] = ACTIONS(606),
    [anon_sym_type] = ACTIONS(606),
    [anon_sym_const] = ACTIONS(606),
    [anon_sym_EQ] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(606),
    [anon_sym_POUND] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_mod] = ACTIONS(606),
    [anon_sym_struct] = ACTIONS(606),
    [anon_sym_enum] = ACTIONS(606),
    [anon_sym_fn] = ACTIONS(606),
    [anon_sym_let] = ACTIONS(606),
    [anon_sym_use] = ACTIONS(606),
    [anon_sym_COLON_COLON] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(594),
    [anon_sym_u8] = ACTIONS(606),
    [anon_sym_i8] = ACTIONS(606),
    [anon_sym_u16] = ACTIONS(606),
    [anon_sym_i16] = ACTIONS(606),
    [anon_sym_u32] = ACTIONS(606),
    [anon_sym_i32] = ACTIONS(606),
    [anon_sym_u64] = ACTIONS(606),
    [anon_sym_i64] = ACTIONS(606),
    [anon_sym_u128] = ACTIONS(606),
    [anon_sym_i128] = ACTIONS(606),
    [anon_sym_usize] = ACTIONS(606),
    [anon_sym_bool] = ACTIONS(606),
    [anon_sym_ByteArray] = ACTIONS(606),
    [anon_sym_felt252] = ACTIONS(606),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(594),
    [anon_sym_PIPE_PIPE] = ACTIONS(594),
    [anon_sym_LT_LT] = ACTIONS(594),
    [anon_sym_GT_GT] = ACTIONS(594),
    [anon_sym_PLUS_EQ] = ACTIONS(594),
    [anon_sym_DASH_EQ] = ACTIONS(594),
    [anon_sym_STAR_EQ] = ACTIONS(594),
    [anon_sym_SLASH_EQ] = ACTIONS(594),
    [anon_sym_PERCENT_EQ] = ACTIONS(594),
    [anon_sym_EQ_EQ] = ACTIONS(594),
    [anon_sym_BANG_EQ] = ACTIONS(594),
    [anon_sym_GT_EQ] = ACTIONS(594),
    [anon_sym_LT_EQ] = ACTIONS(594),
    [anon_sym_AT] = ACTIONS(604),
    [anon_sym_DOT] = ACTIONS(594),
    [anon_sym_QMARK] = ACTIONS(594),
    [anon_sym_break] = ACTIONS(606),
    [anon_sym_continue] = ACTIONS(606),
    [anon_sym_default] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(606),
    [anon_sym_extern] = ACTIONS(606),
    [anon_sym_loop] = ACTIONS(606),
    [anon_sym_match] = ACTIONS(606),
    [anon_sym_pub] = ACTIONS(606),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(606),
    [sym_numeric_literal] = ACTIONS(606),
    [aux_sym_string_literal_token1] = ACTIONS(604),
    [sym_shortstring_literal] = ACTIONS(604),
    [anon_sym_true] = ACTIONS(606),
    [anon_sym_false] = ACTIONS(606),
    [anon_sym_ref] = ACTIONS(606),
    [sym_identifier] = ACTIONS(606),
    [sym_super] = ACTIONS(606),
    [sym_line_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(608),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(610),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(104),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(639),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1425),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(104),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(103),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(499),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(103),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(612),
    [anon_sym_COMMA] = ACTIONS(614),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(106),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(551),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(106),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(616),
    [anon_sym_COMMA] = ACTIONS(618),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(597),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1240),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [102] = {
    [anon_sym_LBRACE] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(604),
    [anon_sym_impl] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(594),
    [anon_sym_trait] = ACTIONS(606),
    [anon_sym_type] = ACTIONS(606),
    [anon_sym_const] = ACTIONS(606),
    [anon_sym_EQ] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(606),
    [anon_sym_POUND] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_mod] = ACTIONS(606),
    [anon_sym_struct] = ACTIONS(606),
    [anon_sym_enum] = ACTIONS(606),
    [anon_sym_fn] = ACTIONS(606),
    [anon_sym_let] = ACTIONS(606),
    [anon_sym_use] = ACTIONS(606),
    [anon_sym_COLON_COLON] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(594),
    [anon_sym_u8] = ACTIONS(606),
    [anon_sym_i8] = ACTIONS(606),
    [anon_sym_u16] = ACTIONS(606),
    [anon_sym_i16] = ACTIONS(606),
    [anon_sym_u32] = ACTIONS(606),
    [anon_sym_i32] = ACTIONS(606),
    [anon_sym_u64] = ACTIONS(606),
    [anon_sym_i64] = ACTIONS(606),
    [anon_sym_u128] = ACTIONS(606),
    [anon_sym_i128] = ACTIONS(606),
    [anon_sym_usize] = ACTIONS(606),
    [anon_sym_bool] = ACTIONS(606),
    [anon_sym_ByteArray] = ACTIONS(606),
    [anon_sym_felt252] = ACTIONS(606),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(594),
    [anon_sym_PIPE_PIPE] = ACTIONS(594),
    [anon_sym_LT_LT] = ACTIONS(594),
    [anon_sym_GT_GT] = ACTIONS(594),
    [anon_sym_PLUS_EQ] = ACTIONS(594),
    [anon_sym_DASH_EQ] = ACTIONS(594),
    [anon_sym_STAR_EQ] = ACTIONS(594),
    [anon_sym_SLASH_EQ] = ACTIONS(594),
    [anon_sym_PERCENT_EQ] = ACTIONS(594),
    [anon_sym_EQ_EQ] = ACTIONS(594),
    [anon_sym_BANG_EQ] = ACTIONS(594),
    [anon_sym_GT_EQ] = ACTIONS(594),
    [anon_sym_LT_EQ] = ACTIONS(594),
    [anon_sym_AT] = ACTIONS(604),
    [anon_sym_DOT] = ACTIONS(594),
    [anon_sym_QMARK] = ACTIONS(594),
    [anon_sym_break] = ACTIONS(606),
    [anon_sym_continue] = ACTIONS(606),
    [anon_sym_default] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(606),
    [anon_sym_extern] = ACTIONS(606),
    [anon_sym_loop] = ACTIONS(606),
    [anon_sym_match] = ACTIONS(606),
    [anon_sym_pub] = ACTIONS(606),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(606),
    [sym_numeric_literal] = ACTIONS(606),
    [aux_sym_string_literal_token1] = ACTIONS(604),
    [sym_shortstring_literal] = ACTIONS(604),
    [anon_sym_true] = ACTIONS(606),
    [anon_sym_false] = ACTIONS(606),
    [anon_sym_ref] = ACTIONS(606),
    [sym_identifier] = ACTIONS(606),
    [sym_super] = ACTIONS(606),
    [sym_line_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(598),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(623),
    [anon_sym_POUND] = ACTIONS(626),
    [anon_sym_LBRACK] = ACTIONS(629),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_COLON_COLON] = ACTIONS(634),
    [anon_sym_STAR] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(637),
    [anon_sym_u8] = ACTIONS(640),
    [anon_sym_i8] = ACTIONS(640),
    [anon_sym_u16] = ACTIONS(640),
    [anon_sym_i16] = ACTIONS(640),
    [anon_sym_u32] = ACTIONS(640),
    [anon_sym_i32] = ACTIONS(640),
    [anon_sym_u64] = ACTIONS(640),
    [anon_sym_i64] = ACTIONS(640),
    [anon_sym_u128] = ACTIONS(640),
    [anon_sym_i128] = ACTIONS(640),
    [anon_sym_usize] = ACTIONS(640),
    [anon_sym_bool] = ACTIONS(640),
    [anon_sym_ByteArray] = ACTIONS(640),
    [anon_sym_felt252] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(649),
    [anon_sym_default] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_loop] = ACTIONS(658),
    [anon_sym_match] = ACTIONS(661),
    [anon_sym_return] = ACTIONS(664),
    [anon_sym_while] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(670),
    [sym_numeric_literal] = ACTIONS(673),
    [aux_sym_string_literal_token1] = ACTIONS(676),
    [sym_shortstring_literal] = ACTIONS(679),
    [anon_sym_true] = ACTIONS(682),
    [anon_sym_false] = ACTIONS(682),
    [anon_sym_ref] = ACTIONS(685),
    [sym_identifier] = ACTIONS(688),
    [sym_super] = ACTIONS(691),
    [sym_line_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(659),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1418),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(587),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_named_argument] = STATE(1346),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(582),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(591),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(623),
    [anon_sym_POUND] = ACTIONS(626),
    [anon_sym_LBRACK] = ACTIONS(629),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_COLON_COLON] = ACTIONS(634),
    [anon_sym_STAR] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(637),
    [anon_sym_u8] = ACTIONS(640),
    [anon_sym_i8] = ACTIONS(640),
    [anon_sym_u16] = ACTIONS(640),
    [anon_sym_i16] = ACTIONS(640),
    [anon_sym_u32] = ACTIONS(640),
    [anon_sym_i32] = ACTIONS(640),
    [anon_sym_u64] = ACTIONS(640),
    [anon_sym_i64] = ACTIONS(640),
    [anon_sym_u128] = ACTIONS(640),
    [anon_sym_i128] = ACTIONS(640),
    [anon_sym_usize] = ACTIONS(640),
    [anon_sym_bool] = ACTIONS(640),
    [anon_sym_ByteArray] = ACTIONS(640),
    [anon_sym_felt252] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(649),
    [anon_sym_default] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_loop] = ACTIONS(658),
    [anon_sym_match] = ACTIONS(661),
    [anon_sym_return] = ACTIONS(664),
    [anon_sym_while] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(670),
    [sym_numeric_literal] = ACTIONS(673),
    [aux_sym_string_literal_token1] = ACTIONS(676),
    [sym_shortstring_literal] = ACTIONS(679),
    [anon_sym_true] = ACTIONS(682),
    [anon_sym_false] = ACTIONS(682),
    [anon_sym_ref] = ACTIONS(685),
    [sym_identifier] = ACTIONS(688),
    [sym_super] = ACTIONS(691),
    [sym_line_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(100),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(542),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(100),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(694),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(99),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(544),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(99),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(698),
    [anon_sym_COMMA] = ACTIONS(700),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(702),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(704),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(708),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(712),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(119),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(699),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(119),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(122),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(635),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(122),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(716),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(718),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(720),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(765),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(129),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(631),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(129),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1466),
    [sym_let_condition] = STATE(1466),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(778),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1441),
    [sym_let_condition] = STATE(1441),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1467),
    [sym_let_condition] = STATE(1467),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1432),
    [sym_let_condition] = STATE(1432),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(756),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym__condition] = STATE(1542),
    [sym_let_condition] = STATE(1542),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_let] = ACTIONS(726),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1438),
    [sym_let_condition] = STATE(1438),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [128] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1430),
    [sym_let_condition] = STATE(1430),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [129] = {
    [sym_macro_invocation] = STATE(485),
    [sym_attribute_item] = STATE(373),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(674),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_enum_variant_list_repeat1] = STATE(373),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(576),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(749),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym__condition] = STATE(1464),
    [sym_let_condition] = STATE(1464),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(722),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(684),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(136),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(730),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(677),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(136),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(732),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(691),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(138),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(687),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(736),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(608),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(132),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(738),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(743),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(136),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(743),
    [anon_sym_LBRACK] = ACTIONS(746),
    [anon_sym_COLON_COLON] = ACTIONS(749),
    [anon_sym_STAR] = ACTIONS(743),
    [anon_sym_LPAREN] = ACTIONS(752),
    [anon_sym_RPAREN] = ACTIONS(755),
    [anon_sym_u8] = ACTIONS(757),
    [anon_sym_i8] = ACTIONS(757),
    [anon_sym_u16] = ACTIONS(757),
    [anon_sym_i16] = ACTIONS(757),
    [anon_sym_u32] = ACTIONS(757),
    [anon_sym_i32] = ACTIONS(757),
    [anon_sym_u64] = ACTIONS(757),
    [anon_sym_i64] = ACTIONS(757),
    [anon_sym_u128] = ACTIONS(757),
    [anon_sym_i128] = ACTIONS(757),
    [anon_sym_usize] = ACTIONS(757),
    [anon_sym_bool] = ACTIONS(757),
    [anon_sym_ByteArray] = ACTIONS(757),
    [anon_sym_felt252] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_TILDE] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(743),
    [anon_sym_break] = ACTIONS(763),
    [anon_sym_continue] = ACTIONS(766),
    [anon_sym_default] = ACTIONS(769),
    [anon_sym_if] = ACTIONS(772),
    [anon_sym_loop] = ACTIONS(775),
    [anon_sym_match] = ACTIONS(778),
    [anon_sym_return] = ACTIONS(781),
    [anon_sym_while] = ACTIONS(784),
    [anon_sym_for] = ACTIONS(787),
    [sym_numeric_literal] = ACTIONS(790),
    [aux_sym_string_literal_token1] = ACTIONS(793),
    [sym_shortstring_literal] = ACTIONS(796),
    [anon_sym_true] = ACTIONS(799),
    [anon_sym_false] = ACTIONS(799),
    [anon_sym_ref] = ACTIONS(802),
    [sym_identifier] = ACTIONS(805),
    [sym_super] = ACTIONS(808),
    [sym_line_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(611),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(131),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(608),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(136),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(738),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(611),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [aux_sym_tuple_expression_repeat1] = STATE(136),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(811),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [140] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(446),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_mutable_specifier] = ACTIONS(813),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [141] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(764),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_mutable_specifier] = ACTIONS(815),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [142] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(446),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_mutable_specifier] = ACTIONS(817),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [143] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(722),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [144] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(637),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [145] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(475),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [146] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(471),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [147] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(453),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [148] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(782),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [149] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(710),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [150] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(769),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [151] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(729),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(819),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(432),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [153] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(742),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [154] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(478),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [155] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(479),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(711),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [157] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(480),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [158] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(481),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [159] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(482),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [160] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(436),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [161] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(738),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [162] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(492),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [163] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(678),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [164] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(733),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [165] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(777),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [166] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(748),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [167] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(715),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [168] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(709),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [169] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(714),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [170] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(698),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [171] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(730),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(339),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(339),
    [sym_if_expression] = STATE(339),
    [sym_match_expression] = STATE(339),
    [sym_while_expression] = STATE(339),
    [sym_for_expression] = STATE(339),
    [sym_loop_expression] = STATE(339),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(821),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(823),
    [anon_sym_loop] = ACTIONS(825),
    [anon_sym_match] = ACTIONS(827),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(829),
    [anon_sym_for] = ACTIONS(831),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [172] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(751),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [173] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(750),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [174] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(661),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [175] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(665),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [176] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(432),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(833),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [177] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(695),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [178] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(716),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [179] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(619),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [180] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(669),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [181] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(444),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [182] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(740),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [183] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(432),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [184] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(770),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [185] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(726),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [186] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(739),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [187] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(683),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(316),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(316),
    [sym_if_expression] = STATE(316),
    [sym_match_expression] = STATE(316),
    [sym_while_expression] = STATE(316),
    [sym_for_expression] = STATE(316),
    [sym_loop_expression] = STATE(316),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(821),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(823),
    [anon_sym_loop] = ACTIONS(825),
    [anon_sym_match] = ACTIONS(827),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(829),
    [anon_sym_for] = ACTIONS(831),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [188] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(432),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(833),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [189] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(717),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [190] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(718),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [191] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(771),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [192] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(477),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [193] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(734),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(316),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(316),
    [sym_if_expression] = STATE(316),
    [sym_match_expression] = STATE(316),
    [sym_while_expression] = STATE(316),
    [sym_for_expression] = STATE(316),
    [sym_loop_expression] = STATE(316),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(821),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(823),
    [anon_sym_loop] = ACTIONS(825),
    [anon_sym_match] = ACTIONS(827),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(829),
    [anon_sym_for] = ACTIONS(831),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [194] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(616),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [195] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(752),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [196] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(753),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [197] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(759),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [198] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(762),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [199] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(719),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [200] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(720),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [201] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(772),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [202] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(667),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [203] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(763),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [204] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(444),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [205] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(727),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [206] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(773),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [207] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(754),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [208] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(768),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [209] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(774),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [210] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(629),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [211] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(630),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [212] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(723),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [213] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(776),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [214] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(767),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [215] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(729),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [216] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(779),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [217] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(766),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [218] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(671),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(339),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(339),
    [sym_if_expression] = STATE(339),
    [sym_match_expression] = STATE(339),
    [sym_while_expression] = STATE(339),
    [sym_for_expression] = STATE(339),
    [sym_loop_expression] = STATE(339),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(821),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(823),
    [anon_sym_loop] = ACTIONS(825),
    [anon_sym_match] = ACTIONS(827),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(829),
    [anon_sym_for] = ACTIONS(831),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [219] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(436),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [220] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(780),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
  },
  [221] = {
    [sym_macro_invocation] = STATE(797),
    [sym_generic_type_with_turbofish] = STATE(1219),
    [sym__literal] = STATE(813),
    [sym_negative_literal] = STATE(827),
    [sym_string_literal] = STATE(827),
    [sym_boolean_literal] = STATE(827),
    [sym_scoped_identifier] = STATE(693),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1433),
    [sym_expression] = STATE(758),
    [sym_generic_function] = STATE(813),
    [sym_tuple_expression] = STATE(813),
    [sym_return_expression] = STATE(813),
    [sym_struct_expression] = STATE(813),
    [sym_assignment_expression] = STATE(813),
    [sym_break_expression] = STATE(813),
    [sym_continue_expression] = STATE(813),
    [sym_index_expression] = STATE(813),
    [sym_array_expression] = STATE(813),
    [sym_parenthesized_expression] = STATE(813),
    [sym_unit_expression] = STATE(813),
    [sym_compound_assignment_expr] = STATE(813),
    [sym__expression_ending_with_block] = STATE(813),
    [sym_unary_expression] = STATE(813),
    [sym_try_expression] = STATE(813),
    [sym_field_expression] = STATE(732),
    [sym_block] = STATE(813),
    [sym_if_expression] = STATE(813),
    [sym_match_expression] = STATE(813),
    [sym_while_expression] = STATE(813),
    [sym_for_expression] = STATE(813),
    [sym_loop_expression] = STATE(813),
    [sym_binary_expression] = STATE(813),
    [sym_call_expression] = STATE(813),
    [sym_reference_expression] = STATE(813),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_COLON_COLON] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_u8] = ACTIONS(399),
    [anon_sym_i8] = ACTIONS(399),
    [anon_sym_u16] = ACTIONS(399),
    [anon_sym_i16] = ACTIONS(399),
    [anon_sym_u32] = ACTIONS(399),
    [anon_sym_i32] = ACTIONS(399),
    [anon_sym_u64] = ACTIONS(399),
    [anon_sym_i64] = ACTIONS(399),
    [anon_sym_u128] = ACTIONS(399),
    [anon_sym_i128] = ACTIONS(399),
    [anon_sym_usize] = ACTIONS(399),
    [anon_sym_bool] = ACTIONS(399),
    [anon_sym_ByteArray] = ACTIONS(399),
    [anon_sym_felt252] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(409),
    [anon_sym_if] = ACTIONS(411),
    [anon_sym_loop] = ACTIONS(413),
    [anon_sym_match] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(421),
    [sym_numeric_literal] = ACTIONS(423),
    [aux_sym_string_literal_token1] = ACTIONS(425),
    [sym_shortstring_literal] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_ref] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [sym_super] = ACTIONS(435),
    [sym_line_comment] = ACTIONS(3),
  },
  [222] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1222),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(701),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(713),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(441),
    [anon_sym_i8] = ACTIONS(441),
    [anon_sym_u16] = ACTIONS(441),
    [anon_sym_i16] = ACTIONS(441),
    [anon_sym_u32] = ACTIONS(441),
    [anon_sym_i32] = ACTIONS(441),
    [anon_sym_u64] = ACTIONS(441),
    [anon_sym_i64] = ACTIONS(441),
    [anon_sym_u128] = ACTIONS(441),
    [anon_sym_i128] = ACTIONS(441),
    [anon_sym_usize] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_ByteArray] = ACTIONS(441),
    [anon_sym_felt252] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(451),
    [sym_identifier] = ACTIONS(453),
    [sym_super] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
  },
  [223] = {
    [sym_macro_invocation] = STATE(485),
    [sym_generic_type_with_turbofish] = STATE(1173),
    [sym__literal] = STATE(490),
    [sym_negative_literal] = STATE(494),
    [sym_string_literal] = STATE(494),
    [sym_boolean_literal] = STATE(494),
    [sym_scoped_identifier] = STATE(434),
    [sym_scoped_type_identifier_in_expression_position] = STATE(1384),
    [sym_expression] = STATE(781),
    [sym_generic_function] = STATE(490),
    [sym_tuple_expression] = STATE(490),
    [sym_return_expression] = STATE(490),
    [sym_struct_expression] = STATE(490),
    [sym_assignment_expression] = STATE(490),
    [sym_break_expression] = STATE(490),
    [sym_continue_expression] = STATE(490),
    [sym_index_expression] = STATE(490),
    [sym_array_expression] = STATE(490),
    [sym_parenthesized_expression] = STATE(490),
    [sym_unit_expression] = STATE(490),
    [sym_compound_assignment_expr] = STATE(490),
    [sym__expression_ending_with_block] = STATE(490),
    [sym_unary_expression] = STATE(490),
    [sym_try_expression] = STATE(490),
    [sym_field_expression] = STATE(429),
    [sym_block] = STATE(490),
    [sym_if_expression] = STATE(490),
    [sym_match_expression] = STATE(490),
    [sym_while_expression] = STATE(490),
    [sym_for_expression] = STATE(490),
    [sym_loop_expression] = STATE(490),
    [sym_binary_expression] = STATE(490),
    [sym_call_expression] = STATE(490),
    [sym_reference_expression] = STATE(490),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_u8] = ACTIONS(41),
    [anon_sym_i8] = ACTIONS(41),
    [anon_sym_u16] = ACTIONS(41),
    [anon_sym_i16] = ACTIONS(41),
    [anon_sym_u32] = ACTIONS(41),
    [anon_sym_i32] = ACTIONS(41),
    [anon_sym_u64] = ACTIONS(41),
    [anon_sym_i64] = ACTIONS(41),
    [anon_sym_u128] = ACTIONS(41),
    [anon_sym_i128] = ACTIONS(41),
    [anon_sym_usize] = ACTIONS(41),
    [anon_sym_bool] = ACTIONS(41),
    [anon_sym_ByteArray] = ACTIONS(41),
    [anon_sym_felt252] = ACTIONS(41),
    [anon_sym_DASH] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_default] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_loop] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_for] = ACTIONS(65),
    [sym_numeric_literal] = ACTIONS(67),
    [aux_sym_string_literal_token1] = ACTIONS(69),
    [sym_shortstring_literal] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(73),
    [anon_sym_false] = ACTIONS(73),
    [anon_sym_ref] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [sym_super] = ACTIONS(79),
    [sym_line_comment] 