/* The event_stream interface for X11 with Xt, and/or tty frames.
   Copyright (C) 1991-5, 1997 Free Software Foundation, Inc.
   Copyright (C) 1995 Sun Microsystems, Inc.
   Copyright (C) 1996, 2001, 2002, 2003, 2005, 2010 Ben Wing.
   Copyright (C) 2010 Didier Verna

This file is part of XEmacs.

XEmacs is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs.  If not, see <http://www.gnu.org/licenses/>. */

/* Synched up with: Not in FSF. */

/* NOTE: It would be possible to fix things so that all of GTK, Windows, X,
   TTY and stream can have consoles at the same time.  We already do lots
   of combinations.  Basically, either call select() directly or some
   interface onto it, and select() over all the filedescs, including the
   X and GTK socket, and under Cygwin, the Windows device.  Then for whichever
   filedesc there's an event, call the appropriate window-system-specific
   method to pull the event(s) and store onto the dispatch queue. --ben */

#include <config.h>
#include "lisp.h"

#include "blocktype.h"
#include "buffer.h"
#include "charset.h"
#include "console.h"
#include "device-impl.h"
#include "elhash.h"
#include "events.h"
#include "file-coding.h"
#include "frame-impl.h"
#include "glyphs.h"
#include "lstream.h"
#include "process.h"
#include "redisplay.h"
#include "window.h"

#include "console-tty.h"

#include "console-x-impl.h"
#include "fontcolor-x.h"
#include "../lwlib/lwlib.h"
#include "EmacsFrame.h"

#include "sysproc.h" /* for MAXDESC */
#include "systime.h"

#include "xintrinsicp.h"	/* CoreP.h needs this */
#include <X11/CoreP.h>		/* Numerous places access the fields of
				   a core widget directly.  We could
				   use XtGetValues(), but ... */
#include <X11/ShellP.h>

#if defined (HAVE_XIM) && defined (XIM_MOTIF)
#include "xmotif.h"
#endif

#ifdef HAVE_DRAGNDROP
#include "dragdrop.h"
#endif

#ifdef WIN32_ANY
extern int mswindows_is_blocking;
#endif

/* For Russian C-x processing. */
Lisp_Object Vx_us_keymap_description;
Fixnum Vx_us_keymap_first_keycode;

/* used in glyphs-x.c */
void enqueue_focus_event (Widget wants_it, Lisp_Object frame, int in_p);
static void handle_focus_event_1 (struct frame *f, int in_p);
static void handle_focus_event_2 (Window w, struct frame *f, int in_p);

static struct event_stream *Xt_event_stream;

/* With the new event model, all events go through XtDispatchEvent()
   and are picked up by an event handler that is added to each frame
   widget. (This is how it's supposed to be.) In the old method,
   Emacs sucks out events directly from XtNextEvent() and only
   dispatches the events that it doesn't need to deal with.  This
   old way has lots of corresponding junk that is no longer
   necessary: lwlib extensions, synthetic XAnyEvents, unnecessary
   magic events, etc. */

/* The one and only one application context that Emacs uses. */
XtAppContext Xt_app_con;

/* Do we accept events sent by other clients? */
int x_allow_sendevents;

#ifdef DEBUG_XEMACS
Fixnum debug_x_events;
#endif

static int process_events_occurred;
static int tty_events_occurred;
static Widget widget_with_focus;

/* Mask of bits indicating the descriptors that we wait for input on */
extern SELECT_TYPE input_wait_mask, non_fake_input_wait_mask;
extern SELECT_TYPE process_only_mask, tty_only_mask;

/* #### This should be String, but G++ 4.3 doesn't apply the const
   specifier the same way for String (typedef'd to char*) and char*. */
static const char * x_fallback_resources[] =
{
  /* This file is automatically generated from the app-defaults file
     in ../etc/Emacs.ad.  These resources are consulted only if no
     app-defaults file is found at all.
   */
#include <Emacs.ad.h>
  0
};

static Lisp_Object x_keysym_to_emacs_keysym (KeySym keysym);
void emacs_Xt_mapping_action (Widget w, XEvent *event);
void debug_process_finalization (Lisp_Process *p);
void emacs_Xt_event_handler (Widget wid, XtPointer closure, XEvent *event,
			     Boolean *continue_to_dispatch);

static int last_quit_check_signal_tick_count;

#define THIS_IS_X
#include "event-xlike-inc.c"

/* Use an appropriate map to Unicode within x_keysym_to_character. Arguments
   are evaluated multiple times.

   Breaks if an X11 keysym maps to zero in Unicode. */

#define USE_UNICODE_MAP(keysym, map)					\
  if (keysym >= FIRST_KNOWN_##map					\
      && (keysym < (FIRST_KNOWN_##map + countof (map)))			\
      && map[keysym - FIRST_KNOWN_##map ]) do				\
    {									\
      keysym -= FIRST_KNOWN_##map ;					\
      /* Use the language-environment precedence list, not that of */   \
      /* the current buffer. */                                         \
      return make_char (filtered_unicode_to_ichar                       \
                        ((int) map[keysym],                             \
                         Vdefault_unicode_precedence_array, NULL,       \
                         CONVERR_SUCCEED));                             \
    } while (0)

/* Maps to Unicode for X11 KeySyms, where we don't have a direct internal
   mapping based on a Mule character set, or whatever. Taken from Markus
   Kuhn's X11.keysyms--if you're ever comparing with that file, note the
   sequences of KeySyms often leave out entries, so you'll have to fill them
   in. Doesn't include support for Hangul, which it should, if the X11
   Hangul keysyms have ever been used anywhere. */

static UINT_16_BIT const TECHNICAL[] = 
  {
    0x23B7,	/* #x08A1 LEFT RADICAL	Technical */

#define FIRST_KNOWN_TECHNICAL 0x8A1

    0x0,	/* #x08A2 TOP LEFT RADICAL	Technical */
    0x0,	/* #x08A3 HORIZONTAL CONNECTOR	Technical */
    0x2320,	/* #x08A4 TOP INTEGRAL	Technical */
    0x2321,	/* #x08A5 BOTTOM INTEGRAL	Technical */
    0x0,	/* #x08A6 VERTICAL CONNECTOR	Technical */
    0x23A1,	/* #x08A7 TOP LEFT SQUARE BRACKET	Technical */
    0x23A3,	/* #x08A8 BOTTOM LEFT SQUARE BRACKET	Technical */
    0x23A4,	/* #x08A9 TOP RIGHT SQUARE BRACKET	Technical */
    0x23A6,	/* #x08AA BOTTOM RIGHT SQUARE BRACKET	Technical */
    0x239B,	/* #x08AB TOP LEFT PARENTHESIS	Technical */
    0x239D,	/* #x08AC BOTTOM LEFT PARENTHESIS	Technical */
    0x239E,	/* #x08AD TOP RIGHT PARENTHESIS	Technical */
    0x23A0,	/* #x08AE BOTTOM RIGHT PARENTHESIS	Technical */
    0x23A8,	/* #x08AF LEFT MIDDLE CURLY BRACE	Technical */
    0x23AC,	/* #x08B0 RIGHT MIDDLE CURLY BRACE	Technical */
    0x0,	/* #x08B1 TOP LEFT SUMMATION	Technical */
    0x0,	/* #x08B2 BOTTOM LEFT SUMMATION	Technical */
    0x0,	/* #x08B3 TOP VERTICAL SUMMATION CONNECTOR	Technical */
    0x0,	/* #x08B4 BOTTOM VERTICAL SUMMATION CONNECTOR	Technical */
    0x0,	/* #x08B5 TOP RIGHT SUMMATION	Technical */
    0x0,	/* #x08B6 BOTTOM RIGHT SUMMATION	Technical */
    0x0,	/* #x08B7 RIGHT MIDDLE SUMMATION	Technical */
    0x0,	/* #x08B8 */
    0x0,	/* #x08B9 */
    0x0,	/* #x08BA */
    0x0,	/* #x08BB */
    0x2264,	/* #x08BC LESS THAN OR EQUAL SIGN	Technical */
    0x2260,	/* #x08BD NOT EQUAL SIGN	Technical */
    0x2265,	/* #x08BE GREATER THAN OR EQUAL SIGN	Technical */
    0x222B,	/* #x08BF INTEGRAL	Technical */
    0x2234,	/* #x08C0 THEREFORE	Technical */
    0x221D,	/* #x08C1 VARIATION, PROPORTIONAL TO	Technical */
    0x221E,	/* #x08C2 INFINITY	Technical */
    0x0,	/* #x08C3 */
    0x0,	/* #x08C4 */
    0x2207,	/* #x08C5 NABLA, DEL	Technical */
    0x0,	/* #x08C6 */
    0x0,	/* #x08C7 */
    0x223C,	/* #x08C8 IS APPROXIMATE TO	Technical */
    0x2243,	/* #x08C9 SIMILAR OR EQUAL TO	Technical */
    0x0,	/* #x08CA */
    0x0,	/* #x08CB */
    0x0,	/* #x08CC */
    0x21D4,	/* #x08CD IF AND ONLY IF	Technical */
    0x21D2,	/* #x08CE IMPLIES	Technical */
    0x2261,	/* #x08CF IDENTICAL TO	Technical */
    0x0,	/* #x08D0 */
    0x0,	/* #x08D1 */
    0x0,	/* #x08D2 */
    0x0,	/* #x08D3 */
    0x0,	/* #x08D4 */
    0x0,	/* #x08D5 */
    0x221A,	/* #x08D6 RADICAL	Technical */
    0x0,	/* #x08D7 */
    0x0,	/* #x08D8 */
    0x0,	/* #x08D9 */
    0x2282,	/* #x08DA IS INCLUDED IN	Technical */
    0x2283,	/* #x08DB INCLUDES	Technical */
    0x2229,	/* #x08DC INTERSECTION	Technical */
    0x222A,	/* #x08DD UNION	Technical */
    0x2227,	/* #x08DE LOGICAL AND	Technical */
    0x2228,	/* #x08DF LOGICAL OR	Technical */
    0x0,	/* #x08E0 */
    0x0,	/* #x08E1 */
    0x0,	/* #x08E2 */
    0x0,	/* #x08E3 */
    0x0,	/* #x08E4 */
    0x0,	/* #x08E5 */
    0x0,	/* #x08E6 */
    0x0,	/* #x08E7 */
    0x0,	/* #x08E8 */
    0x0,	/* #x08E9 */
    0x0,	/* #x08Ea */
    0x0,	/* #x08Eb */
    0x0,	/* #x08Ec */
    0x0,	/* #x08Ed */
    0x0,	/* #x08Ee */
    0x2202,	/* #x08EF PARTIAL DERIVATIVE	Technical */
    0x0,	/* #x08F0 */
    0x0,	/* #x08F1 */
    0x0,	/* #x08F2 */
    0x0,	/* #x08F3 */
    0x0,	/* #x08F4 */
    0x0,	/* #x08F5 */
    0x0192,	/* #x08F6 FUNCTION	Technical */
    0x0,	/* #x08F7 */
    0x0,	/* #x08F8 */
    0x0,	/* #x08F9 */
    0x0,	/* #x08FA */
    0x2190,	/* #x08FB LEFT ARROW	Technical */
    0x2191,	/* #x08FC UPWARD ARROW	Technical */
    0x2192,	/* #x08FD RIGHT ARROW	Technical */
    0x2193,	/* #x08FE DOWNWARD ARROW	Technical */
  };

static UINT_16_BIT const SPECIAL[] = 
  {
    0x25C6,	/* #x09E0 SOLID DIAMOND	Special */

#define FIRST_KNOWN_SPECIAL 0x9E0

    0x2592,	/* #x09E1 CHECKERBOARD	Special */
    0x2409,	/* #x09E2 ``HT''	Special */
    0x240C,	/* #x09E3 ``FF''	Special */
    0x240D,	/* #x09E4 ``CR''	Special */
    0x240A,	/* #x09E5 ``LF''	Special */
    0x0,	/* #x09E6 */
    0x0,	/* #x09E7 */
    0x2424,	/* #x09E8 ``NL''	Special */
    0x240B,	/* #x09E9 ``VT''	Special */
    0x2518,	/* #x09EA LOWER-RIGHT CORNER	Special */
    0x2510,	/* #x09EB UPPER-RIGHT CORNER	Special */
    0x250C,	/* #x09EC UPPER-LEFT CORNER	Special */
    0x2514,	/* #x09ED LOWER-LEFT CORNER	Special */
    0x253C,	/* #x09EE CROSSING-LINES	Special */
    0x23BA,	/* #x09EF HORIZONTAL LINE, SCAN 1	Special */
    0x23BB,	/* #x09F0 HORIZONTAL LINE, SCAN 3	Special */
    0x2500,	/* #x09F1 HORIZONTAL LINE, SCAN 5	Special */
    0x23BC,	/* #x09F2 HORIZONTAL LINE, SCAN 7	Special */
    0x23BD,	/* #x09F3 HORIZONTAL LINE, SCAN 9	Special */
    0x251C,	/* #x09F4 LEFT ``T''	Special */
    0x2524,	/* #x09F5 RIGHT ``T''	Special */
    0x2534,	/* #x09F6 BOTTOM ``T''	Special */
    0x252C,	/* #x09F7 TOP ``T''	Special */
    0x2502	/* #x09F8 VERTICAL BAR	Special */
  };

static UINT_16_BIT const PUBLISHING[] = 
  {
    0x2003,	/* #x0AA1 EM SPACE	Publish */

#define FIRST_KNOWN_PUBLISHING 0xAA1

    0x2002,	/* #x0AA2 EN SPACE	Publish */
    0x2004,	/* #x0AA3 3/EM SPACE	Publish */
    0x2005,	/* #x0AA4 4/EM SPACE	Publish */
    0x2007,	/* #x0AA5 DIGIT SPACE	Publish */
    0x2008,	/* #x0AA6 PUNCTUATION SPACE	Publish */
    0x2009,	/* #x0AA7 THIN SPACE	Publish */
    0x200A,	/* #x0AA8 HAIR SPACE	Publish */
    0x2014,	/* #x0AA9 EM DASH	Publish */
    0x2013,	/* #x0AAA EN DASH	Publish */
    0x0,	/* #x0AAB */
    0x0,	/* #x0AAC SIGNIFICANT BLANK SYMBOL	Publish */
    0x0,	/* #x0AAD */
    0x2026,	/* #x0AAE ELLIPSIS	Publish */
    0x2025,	/* #x0AAF DOUBLE BASELINE DOT	Publish */
    0x2153,	/* #x0AB0 VULGAR FRACTION ONE THIRD	Publish */
    0x2154,	/* #x0AB1 VULGAR FRACTION TWO THIRDS	Publish */
    0x2155,	/* #x0AB2 VULGAR FRACTION ONE FIFTH	Publish */
    0x2156,	/* #x0AB3 VULGAR FRACTION TWO FIFTHS	Publish */
    0x2157,	/* #x0AB4 VULGAR FRACTION THREE FIFTHS	Publish */
    0x2158,	/* #x0AB5 VULGAR FRACTION FOUR FIFTHS	Publish */
    0x2159,	/* #x0AB6 VULGAR FRACTION ONE SIXTH	Publish */
    0x215A,	/* #x0AB7 VULGAR FRACTION FIVE SIXTHS	Publish */
    0x2105,	/* #x0AB8 CARE OF	Publish */
    0x0,	/* #x0AB9 */
    0x0,	/* #x0ABA */
    0x2012,	/* #x0ABB FIGURE DASH	Publish */
    0x3008,	/* #x0ABC LEFT ANGLE BRACKET	Publish */
    0x002E,	/* #x0ABD DECIMAL POINT	Publish */
    0x3009,	/* #x0ABE RIGHT ANGLE BRACKET	Publish */
    0x0,	/* #x0ABF MARKER	Publish */
    0x0,	/* #x0AC0 */
    0x0,	/* #x0AC1 */
    0x0,	/* #x0AC2 */
    0x215B,	/* #x0AC3 VULGAR FRACTION ONE EIGHTH	Publish */
    0x215C,	/* #x0AC4 VULGAR FRACTION THREE EIGHTHS	Publish */
    0x215D,	/* #x0AC5 VULGAR FRACTION FIVE EIGHTHS	Publish */
    0x215E,	/* #x0AC6 VULGAR FRACTION SEVEN EIGHTHS	Publish */
    0x0,	/* #x0AC7 */
    0x0,	/* #x0AC8 */
    0x2122,	/* #x0AC9 TRADEMARK SIGN	Publish */
    0x0,	/* #x0ACA SIGNATURE MARK	Publish */
    0x0,	/* #x0ACB TRADEMARK SIGN IN CIRCLE	Publish */
    0x0,	/* #x0ACC LEFT OPEN TRIANGLE	Publish */
    0x0,	/* #x0ACD RIGHT OPEN TRIANGLE	Publish */
    0x0,	/* #x0ACE EM OPEN CIRCLE	Publish */
    0x0,	/* #x0ACF EM OPEN RECTANGLE	Publish */
    0x2018,	/* #x0AD0 LEFT SINGLE QUOTATION MARK	Publish */
    0x2019,	/* #x0AD1 RIGHT SINGLE QUOTATION MARK	Publish */
    0x201C,	/* #x0AD2 LEFT DOUBLE QUOTATION MARK	Publish */
    0x201D,	/* #x0AD3 RIGHT DOUBLE QUOTATION MARK	Publish */
    0x211E,	/* #x0AD4 PRESCRIPTION, TAKE, RECIPE	Publish */
    0x0,	/* #x0AD5 */
    0x2032,	/* #x0AD6 MINUTES	Publish */
    0x2033,	/* #x0AD7 SECONDS	Publish */
    0x0,	/* #x0AD8 */
    0x271D,	/* #x0AD9 LATIN CROSS	Publish */
    0x0,	/* #x0ADA HEXAGRAM	Publish */
    0x0,	/* #x0ADB FILLED RECTANGLE BULLET	Publish */
    0x0,	/* #x0ADC FILLED LEFT TRIANGLE BULLET	Publish */
    0x0,	/* #x0ADD FILLED RIGHT TRIANGLE BULLET	Publish */
    0x0,	/* #x0ADE EM FILLED CIRCLE	Publish */
    0x0,	/* #x0ADF EM FILLED RECTANGLE	Publish */
    0x0,	/* #x0AE0 EN OPEN CIRCLE BULLET	Publish */
    0x0,	/* #x0AE1 EN OPEN SQUARE BULLET	Publish */
    0x0,	/* #x0AE2 OPEN RECTANGULAR BULLET	Publish */
    0x0,	/* #x0AE3 OPEN TRIANGULAR BULLET UP	Publish */
    0x0,	/* #x0AE4 OPEN TRIANGULAR BULLET DOWN	Publish */
    0x0,	/* #x0AE5 OPEN STAR	Publish */
    0x0,	/* #x0AE6 EN FILLED CIRCLE BULLET	Publish */
    0x0,	/* #x0AE7 EN FILLED SQUARE BULLET	Publish */
    0x0,	/* #x0AE8 FILLED TRIANGULAR BULLET UP	Publish */
    0x0,	/* #x0AE9 FILLED TRIANGULAR BULLET DOWN	Publish */
    0x0,	/* #x0AEA LEFT POINTER	Publish */
    0x0,	/* #x0AEB RIGHT POINTER	Publish */
    0x2663,	/* #x0AEC CLUB	Publish */
    0x2666,	/* #x0AED DIAMOND	Publish */
    0x2665,	/* #x0AEE HEART	Publish */
    0x0,	/* #x0AEF */
    0x2720,	/* #x0AF0 MALTESE CROSS	Publish */
    0x2020,	/* #x0AF1 DAGGER	Publish */
    0x2021,	/* #x0AF2 DOUBLE DAGGER	Publish */
    0x2713,	/* #x0AF3 CHECK MARK, TICK	Publish */
    0x2717,	/* #x0AF4 BALLOT CROSS	Publish */
    0x266F,	/* #x0AF5 MUSICAL SHARP	Publish */
    0x266D,	/* #x0AF6 MUSICAL FLAT	Publish */
    0x2642,	/* #x0AF7 MALE SYMBOL	Publish */
    0x2640,	/* #x0AF8 FEMALE SYMBOL	Publish */
    0x260E,	/* #x0AF9 TELEPHONE SYMBOL	Publish */
    0x2315,	/* #x0AFA TELEPHONE RECORDER SYMBOL	Publish */
    0x2117,	/* #x0AFB PHONOGRAPH COPYRIGHT SIGN	Publish */
    0x2038,	/* #x0AFC CARET	Publish */
    0x201A,	/* #x0AFD SINGLE LOW QUOTATION MARK	Publish */
    0x201E,	/* #x0AFE DOUBLE LOW QUOTATION MARK	Publish */
  };

static UINT_16_BIT const APL[] = 
  {
    0x22A5,	/* #x0BC2 DOWN TACK	APL */
#define FIRST_KNOWN_APL 0xBC2
    0x0,	/* #x0BC3 UP SHOE (CAP)	APL */
    0x230A,	/* #x0BC4 DOWN STILE	APL */
    0x0,	/* #x0BC5 */
    0x0,	/* #x0BC6 UNDERBAR	APL */
    0x0,	/* #x0BC7 */
    0x0,	/* #x0BC8 */
    0x0,	/* #x0BC9 */
    0x2218,	/* #x0BCA JOT	APL */
    0x0,	/* #x0BCB */
    0x2395,	/* #x0BCC QUAD	APL */
    0x0,	/* #x0BCD */
    0x22A4,	/* #x0BCE UP TACK	APL */
    0x25CB,	/* #x0BCF CIRCLE	APL */
    0x0,	/* #x0BD0 */
    0x0,	/* #x0BD1 */
    0x0,	/* #x0BD2 */
    0x2308,	/* #x0BD3 UP STILE	APL */
    0x0,	/* #x0BD4 */
    0x0,	/* #x0BD5 */
    0x0,	/* #x0BD6 DOWN SHOE (CUP)	APL */
    0x0,	/* #x0BD7 */
    0x0,	/* #x0BD8 RIGHT SHOE	APL */
    0x0,	/* #x0BD9 */
    0x0,	/* #x0BDA LEFT SHOE	APL */
    0x0,	/* #x0BDB */
    0x0,	/* #x0BDC */
    0x22A2,	/* #x0BDC LEFT TACK	APL */
    0x0,	/* #x0BDE */
    0x0,	/* #x0BDF */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, /* 0x0BB0--0x0BBB */
    0x0, 0x0, 0x0, 0x0,
    0x22A3,	/* #x0BFC RIGHT TACK	APL */
  };

static UINT_16_BIT const HANGUL[] = 
  {
#define FIRST_KNOWN_HANGUL 0xEA1
    0x3131,     /* #x0EA1 Hangul_Kiyeog */
    0x3132,     /* #x0EA2 Hangul_SsangKiyeog */
    0x3133,     /* #x0EA3 Hangul_KiyeogSios */
    0x3134,     /* #x0EA4 Hangul_Nieun */
    0x3135,     /* #x0EA5 Hangul_NieunJieuj */
    0x3136,     /* #x0EA6 Hangul_NieunHieuh */
    0x3137,     /* #x0EA7 Hangul_Dikeud */
    0x3138,     /* #x0EA8 Hangul_SsangDikeud */
    0x3139,     /* #x0EA9 Hangul_Rieul */
    0x313a,     /* #x0EAA Hangul_RieulKiyeog */
    0x313b,     /* #x0EAB Hangul_RieulMieum */
    0x313c,     /* #x0EAC Hangul_RieulPieub */
    0x313d,     /* #x0EAD Hangul_RieulSios */
    0x313e,     /* #x0EAE Hangul_RieulTieut */
    0x313f,     /* #x0EAF Hangul_RieulPhieuf */
    0x3140,     /* #x0EB0 Hangul_RieulHieuh */
    0x3141,     /* #x0EB1 Hangul_Mieum */
    0x3142,     /* #x0EB2 Hangul_Pieub */
    0x3143,     /* #x0EB3 Hangul_SsangPieub */
    0x3144,     /* #x0EB4 Hangul_PieubSios */
    0x3145,     /* #x0EB5 Hangul_Sios */
    0x3146,     /* #x0EB6 Hangul_SsangSios */
    0x3147,     /* #x0EB7 Hangul_Ieung */
    0x3148,     /* #x0EB8 Hangul_Jieuj */
    0x3149,     /* #x0EB9 Hangul_SsangJieuj */
    0x314a,     /* #x0EBA Hangul_Cieuc */
    0x314b,     /* #x0EBB Hangul_Khieuq */
    0x314c,     /* #x0EBC Hangul_Tieut */
    0x314d,     /* #x0EBD Hangul_Phieuf */
    0x314e,     /* #x0EBE Hangul_Hieuh */
    0x314f,     /* #x0EBF Hangul_A */
    0x3150,     /* #x0EC0 Hangul_AE */
    0x3151,     /* #x0EC1 Hangul_YA */
    0x3152,     /* #x0EC2 Hangul_YAE */
    0x3153,     /* #x0EC3 Hangul_EO */
    0x3154,     /* #x0EC4 Hangul_E */
    0x3155,     /* #x0EC5 Hangul_YEO */
    0x3156,     /* #x0EC6 Hangul_YE */
    0x3157,     /* #x0EC7 Hangul_O */
    0x3158,     /* #x0EC8 Hangul_WA */
    0x3159,     /* #x0EC9 Hangul_WAE */
    0x315a,     /* #x0ECA Hangul_OE */
    0x315b,     /* #x0ECB Hangul_YO */
    0x315c,     /* #x0ECC Hangul_U */
    0x315d,     /* #x0ECD Hangul_WEO */
    0x315e,     /* #x0ECE Hangul_WE */
    0x315f,     /* #x0ECF Hangul_WI */
    0x3160,     /* #x0ED0 Hangul_YU */
    0x3161,     /* #x0ED1 Hangul_EU */
    0x3162,     /* #x0ED2 Hangul_YI */
    0x3163,     /* #x0ED3 Hangul_I */
    0x11a8,     /* #x0ED4 Hangul_J_Kiyeog */
    0x11a9,     /* #x0ED5 Hangul_J_SsangKiyeog */
    0x11aa,     /* #x0ED6 Hangul_J_KiyeogSios */
    0x11ab,     /* #x0ED7 Hangul_J_Nieun */
    0x11ac,     /* #x0ED8 Hangul_J_NieunJieuj */
    0x11ad,     /* #x0ED9 Hangul_J_NieunHieuh */
    0x11ae,     /* #x0EDA Hangul_J_Dikeud */
    0x11af,     /* #x0EDB Hangul_J_Rieul */
    0x11b0,     /* #x0EDC Hangul_J_RieulKiyeog */
    0x11b1,     /* #x0EDD Hangul_J_RieulMieum */
    0x11b2,     /* #x0EDE Hangul_J_RieulPieub */
    0x11b3,     /* #x0EDF Hangul_J_RieulSios */
    0x11b4,     /* #x0EE0 Hangul_J_RieulTieut */
    0x11b5,     /* #x0EE1 Hangul_J_RieulPhieuf */
    0x11b6,     /* #x0EE2 Hangul_J_RieulHieuh */
    0x11b7,     /* #x0EE3 Hangul_J_Mieum */
    0x11b8,     /* #x0EE4 Hangul_J_Pieub */
    0x11b9,     /* #x0EE5 Hangul_J_PieubSios */
    0x11ba,     /* #x0EE6 Hangul_J_Sios */
    0x11bb,     /* #x0EE7 Hangul_J_SsangSios */
    0x11bc,     /* #x0EE8 Hangul_J_Ieung */
    0x11bd,     /* #x0EE9 Hangul_J_Jieuj */
    0x11be,     /* #x0EEA Hangul_J_Cieuc */
    0x11bf,     /* #x0EEB Hangul_J_Khieuq */
    0x11c0,     /* #x0EEC Hangul_J_Tieut */
    0x11c1,     /* #x0EED Hangul_J_Phieuf */
    0x11c2,     /* #x0EEE Hangul_J_Hieuh */
    0x316d,     /* #x0EEF Hangul_RieulYeorinHieuh */
    0x3171,     /* #x0EF0 Hangul_SunkyeongeumMieum */
    0x3178,     /* #x0EF1 Hangul_SunkyeongeumPieub */
    0x317f,     /* #x0EF2 Hangul_PanSios */
    0x3181,     /* #x0EF3 Hangul_KkogjiDalrinIeung */
    0x3184,     /* #x0EF4 Hangul_SunkyeongeumPhieuf */
    0x3186,     /* #x0EF5 Hangul_YeorinHieuh */
    0x318d,     /* #x0EF6 Hangul_AraeA */
    0x318e,     /* #x0EF7 Hangul_AraeAE */
    0x11eb,     /* #x0EF8 Hangul_J_PanSios */
    0x11f0,     /* #x0EF9 Hangul_J_KkogjiDalrinIeung */
    0x11f9,     /* #x0EFA Hangul_J_YeorinHieuh */
    0x0000,     /* #x0EFB */
    0x0000,     /* #x0EFC */
    0x0000,     /* #x0EFD */
    0x0000,     /* #x0EFE */
    0x20a9,     /* #x0EFF Korean_Won */
  };

static UINT_16_BIT const ARMENIAN[] = 
  {
#define FIRST_KNOWN_ARMENIAN 0x14A1
    0x0000,     /* #x14A1 Armenian_eternity */
    0x0587,     /* #x14A2 Armenian_ligature_ew */
    0x0589,     /* #x14A3 Armenian_verjaket */
    0x0029,     /* #x14A4 Armenian_parenright */
    0x0028,     /* #x14A5 Armenian_parenleft */
    0x00bb,     /* #x14A6 Armenian_guillemotright */
    0x00ab,     /* #x14A7 Armenian_guillemotleft */
    0x2014,     /* #x14A8 Armenian_em_dash */
    0x002e,     /* #x14A9 Armenian_mijaket */
    0x055d,     /* #x14AA Armenian_but */
    0x002c,     /* #x14AB Armenian_comma */
    0x2013,     /* #x14AC Armenian_en_dash */
    0x058a,     /* #x14AD Armenian_yentamna */
    0x2026,     /* #x14AE Armenian_ellipsis */
    0x055c,     /* #x14AF Armenian_amanak */
    0x055b,     /* #x14B0 Armenian_shesht */
    0x055e,     /* #x14B1 Armenian_paruyk */
    0x0531,     /* #x14B2 Armenian_AYB */
    0x0561,     /* #x14B3 Armenian_ayb */
    0x0532,     /* #x14B4 Armenian_BEN */
    0x0562,     /* #x14B5 Armenian_ben */
    0x0533,     /* #x14B6 Armenian_GIM */
    0x0563,     /* #x14B7 Armenian_gim */
    0x0534,     /* #x14B8 Armenian_DA */
    0x0564,     /* #x14B9 Armenian_da */
    0x0535,     /* #x14BA Armenian_YECH */
    0x0565,     /* #x14BB Armenian_yech */
    0x0536,     /* #x14BC Armenian_ZA */
    0x0566,     /* #x14BD Armenian_za */
    0x0537,     /* #x14BE Armenian_E */
    0x0567,     /* #x14BF Armenian_e */
    0x0538,     /* #x14C0 Armenian_AT */
    0x0568,     /* #x14C1 Armenian_at */
    0x0539,     /* #x14C2 Armenian_TO */
    0x0569,     /* #x14C3 Armenian_to */
    0x053a,     /* #x14C4 Armenian_ZHE */
    0x056a,     /* #x14C5 Armenian_zhe */
    0x053b,     /* #x14C6 Armenian_INI */
    0x056b,     /* #x14C7 Armenian_ini */
    0x053c,     /* #x14C8 Armenian_LYUN */
    0x056c,     /* #x14C9 Armenian_lyun */
    0x053d,     /* #x14CA Armenian_KHE */
    0x056d,     /* #x14CB Armenian_khe */
    0x053e,     /* #x14CC Armenian_TSA */
    0x056e,     /* #x14CD Armenian_tsa */
    0x053f,     /* #x14CE Armenian_KEN */
    0x056f,     /* #x14CF Armenian_ken */
    0x0540,     /* #x14D0 Armenian_HO */
    0x0570,     /* #x14D1 Armenian_ho */
    0x0541,     /* #x14D2 Armenian_DZA */
    0x0571,     /* #x14D3 Armenian_dza */
    0x0542,     /* #x14D4 Armenian_GHAT */
    0x0572,     /* #x14D5 Armenian_ghat */
    0x0543,     /* #x14D6 Armenian_TCHE */
    0x0573,     /* #x14D7 Armenian_tche */
    0x0544,     /* #x14D8 Armenian_MEN */
    0x0574,     /* #x14D9 Armenian_men */
    0x0545,     /* #x14DA Armenian_HI */
    0x0575,     /* #x14DB Armenian_hi */
    0x0546,     /* #x14DC Armenian_NU */
    0x0576,     /* #x14DD Armenian_nu */
    0x0547,     /* #x14DE Armenian_SHA */
    0x0577,     /* #x14DF Armenian_sha */
    0x0548,     /* #x14E0 Armenian_VO */
    0x0578,     /* #x14E1 Armenian_vo */
    0x0549,     /* #x14E2 Armenian_CHA */
    0x0579,     /* #x14E3 Armenian_cha */
    0x054a,     /* #x14E4 Armenian_PE */
    0x057a,     /* #x14E5 Armenian_pe */
    0x054b,     /* #x14E6 Armenian_JE */
    0x057b,     /* #x14E7 Armenian_je */
    0x054c,     /* #x14E8 Armenian_RA */
    0x057c,     /* #x14E9 Armenian_ra */
    0x054d,     /* #x14EA Armenian_SE */
    0x057d,     /* #x14EB Armenian_se */
    0x054e,     /* #x14EC Armenian_VEV */
    0x057e,     /* #x14ED Armenian_vev */
    0x054f,     /* #x14EE Armenian_TYUN */
    0x057f,     /* #x14EF Armenian_tyun */
    0x0550,     /* #x14F0 Armenian_RE */
    0x0580,     /* #x14F1 Armenian_re */
    0x0551,     /* #x14F2 Armenian_TSO */
    0x0581,     /* #x14F3 Armenian_tso */
    0x0552,     /* #x14F4 Armenian_VYUN */
    0x0582,     /* #x14F5 Armenian_vyun */
    0x0553,     /* #x14F6 Armenian_PYUR */
    0x0583,     /* #x14F7 Armenian_pyur */
    0x0554,     /* #x14F8 Armenian_KE */
    0x0584,     /* #x14F9 Armenian_ke */
    0x0555,     /* #x14FA Armenian_O */
    0x0585,     /* #x14FB Armenian_o */
    0x0556,     /* #x14FC Armenian_FE */
    0x0586,     /* #x14FD Armenian_fe */
    0x055a,     /* #x14FE Armenian_apostrophe */
    0x00a7,     /* #x14FF Armenian_section_sign */
  };

static UINT_16_BIT const GEORGIAN[] = 
  {
#define FIRST_KNOWN_GEORGIAN 0x15D0
    0x10d0,     /* #x15D0 Georgian_an */
    0x10d1,     /* #x15D1 Georgian_ban */
    0x10d2,     /* #x15D2 Georgian_gan */
    0x10d3,     /* #x15D3 Georgian_don */
    0x10d4,     /* #x15D4 Georgian_en */
    0x10d5,     /* #x15D5 Georgian_vin */
    0x10d6,     /* #x15D6 Georgian_zen */
    0x10d7,     /* #x15D7 Georgian_tan */
    0x10d8,     /* #x15D8 Georgian_in */
    0x10d9,     /* #x15D9 Georgian_kan */
    0x10da,     /* #x15DA Georgian_las */
    0x10db,     /* #x15DB Georgian_man */
    0x10dc,     /* #x15DC Georgian_nar */
    0x10dd,     /* #x15DD Georgian_on */
    0x10de,     /* #x15DE Georgian_par */
    0x10df,     /* #x15DF Georgian_zhar */
    0x10e0,     /* #x15E0 Georgian_rae */
    0x10e1,     /* #x15E1 Georgian_san */
    0x10e2,     /* #x15E2 Georgian_tar */
    0x10e3,     /* #x15E3 Georgian_un */
    0x10e4,     /* #x15E4 Georgian_phar */
    0x10e5,     /* #x15E5 Georgian_khar */
    0x10e6,     /* #x15E6 Georgian_ghan */
    0x10e7,     /* #x15E7 Georgian_qar */
    0x10e8,     /* #x15E8 Georgian_shin */
    0x10e9,     /* #x15E9 Georgian_chin */
    0x10ea,     /* #x15EA Georgian_can */
    0x10eb,     /* #x15EB Georgian_jil */
    0x10ec,     /* #x15EC Georgian_cil */
    0x10ed,     /* #x15ED Georgian_char */
    0x10ee,     /* #x15EE Georgian_xan */
    0x10ef,     /* #x15EF Georgian_jhan */
    0x10f0,     /* #x15F0 Georgian_hae */
    0x10f1,     /* #x15F1 Georgian_he */
    0x10f2,     /* #x15F2 Georgian_hie */
    0x10f3,     /* #x15F3 Georgian_we */
    0x10f4,     /* #x15F4 Georgian_har */
    0x10f5,     /* #x15F5 Georgian_hoe */
    0x10f6,     /* #x15F6 Georgian_fi */
  };

static UINT_16_BIT const AZERI_ETC[] = 
  {
#define FIRST_KNOWN_AZERI_ETC 0x16A2
    0x0000,     /* #x16A2 Ccedillaabovedot */
    0x1e8a,     /* #x16A3 Xabovedot */
    0x0000,     /* #x16A4 */
    0x0000,     /* #x16A5 Qabovedot */
    0x012c,     /* #x16A6 Ibreve */
    0x0000,     /* #x16A7 IE */
    0x0000,     /* #x16A8 UO */
    0x01b5,     /* #x16A9 Zstroke */
    0x01e6,     /* #x16AA Gcaron */
    0x0000,     /* #x16AB */
    0x0000,     /* #x16AC */
    0x0000,     /* #x16AD */
    0x0000,     /* #x16AE */
    0x019f,     /* #x16AF Obarred */
    0x0000,     /* #x16B0 */
    0x0000,     /* #x16B1 */
    0x0000,     /* #x16B2 ccedillaabovedot */
    0x1e8b,     /* #x16B3 xabovedot */
    0x0000,     /* #x16B4 Ocaron */
    0x0000,     /* #x16B5 qabovedot */
    0x012d,     /* #x16B6 ibreve */
    0x0000,     /* #x16B7 ie */
    0x0000,     /* #x16B8 uo */
    0x01b6,     /* #x16B9 zstroke */
    0x01e7,     /* #x16BA gcaron */
    0x0000,     /* #x16BB */
    0x0000,     /* #x16BC */
    0x01d2,     /* #x16BD ocaron */
    0x0000,     /* #x16BE */
    0x0275,     /* #x16BF obarred */
    0x0000,     /* #x16C0 */
    0x0000,     /* #x16C1 */
    0x0000,     /* #x16C2 */
    0x0000,     /* #x16C3 */
    0x0000,     /* #x16C4 */
    0x0000,     /* #x16C5 */
    0x018f,     /* #x16C6 SCHWA */
    0x0000,     /* #x16C7 */
    0x0000,     /* #x16C8 */
    0x0000,     /* #x16C9 */
    0x0000,     /* #x16CA */
    0x0000,     /* #x16CB */
    0x0000,     /* #x16CC */
    0x0000,     /* #x16CD */
    0x0000,     /* #x16CE */
    0x0000,     /* #x16CF */
    0x0000,     /* #x16D0 */
    0x1e36,     /* #x16D1 Lbelowdot */
    0x0000,     /* #x16D2 Lstrokebelowdot */
    0x0000,     /* #x16D3 Gtilde */
    0x0000,     /* #x16D4 */
    0x0000,     /* #x16D5 */
    0x0000,     /* #x16D6 */
    0x0000,     /* #x16D7 */
    0x0000,     /* #x16D8 */
    0x0000,     /* #x16D9 */
    0x0000,     /* #x16DA */
    0x0000,     /* #x16DB */
    0x0000,     /* #x16DC */
    0x0000,     /* #x16DD */
    0x0000,     /* #x16DE */
    0x0000,     /* #x16DF */
    0x0000,     /* #x16E0 */
    0x1e37,     /* #x16E1 lbelowdot */
    0x0000,     /* #x16E2 lstrokebelowdot */
    0x0000,     /* #x16E3 gtilde */
    0x0000,     /* #x16E4 */
    0x0000,     /* #x16E5 */
    0x0000,     /* #x16E6 */
    0x0000,     /* #x16E7 */
    0x0000,     /* #x16E8 */
    0x0000,     /* #x16E9 */
    0x0000,     /* #x16EA */
    0x0000,     /* #x16EB */
    0x0000,     /* #x16EC */
    0x0000,     /* #x16ED */
    0x0000,     /* #x16EE */
    0x0000,     /* #x16EF */
    0x0000,     /* #x16F0 */
    0x0000,     /* #x16F1 */
    0x0000,     /* #x16F2 */
    0x0000,     /* #x16F3 */
    0x0000,     /* #x16F4 */
    0x0000,     /* #x16F5 */
    0x0259,     /* #x16F6 schwa */
  };

static UINT_16_BIT const VIETNAMESE[] = 
  {
#define FIRST_KNOWN_VIETNAMESE 0x1E9F
    0x0303,     /* #x1E9F combining_tilde */
    0x1ea0,     /* #x1EA0 Abelowdot */
    0x1ea1,     /* #x1EA1 abelowdot */
    0x1ea2,     /* #x1EA2 Ahook */
    0x1ea3,     /* #x1EA3 ahook */
    0x1ea4,     /* #x1EA4 Acircumflexacute */
    0x1ea5,     /* #x1EA5 acircumflexacute */
    0x1ea6,     /* #x1EA6 Acircumflexgrave */
    0x1ea7,     /* #x1EA7 acircumflexgrave */
    0x1ea8,     /* #x1EA8 Acircumflexhook */
    0x1ea9,     /* #x1EA9 acircumflexhook */
    0x1eaa,     /* #x1EAA Acircumflextilde */
    0x1eab,     /* #x1EAB acircumflextilde */
    0x1eac,     /* #x1EAC Acircumflexbelowdot */
    0x1ead,     /* #x1EAD acircumflexbelowdot */
    0x1eae,     /* #x1EAE Abreveacute */
    0x1eaf,     /* #x1EAF abreveacute */
    0x1eb0,     /* #x1EB0 Abrevegrave */
    0x1eb1,     /* #x1EB1 abrevegrave */
    0x1eb2,     /* #x1EB2 Abrevehook */
    0x1eb3,     /* #x1EB3 abrevehook */
    0x1eb4,     /* #x1EB4 Abrevetilde */
    0x1eb5,     /* #x1EB5 abrevetilde */
    0x1eb6,     /* #x1EB6 Abrevebelowdot */
    0x1eb7,     /* #x1EB7 abrevebelowdot */
    0x1eb8,     /* #x1EB8 Ebelowdot */
    0x1eb9,     /* #x1EB9 ebelowdot */
    0x1eba,     /* #x1EBA Ehook */
    0x1ebb,     /* #x1EBB ehook */
    0x1ebc,     /* #x1EBC Etilde */
    0x1ebd,     /* #x1EBD etilde */
    0x1ebe,     /* #x1EBE Ecircumflexacute */
    0x1ebf,     /* #x1EBF ecircumflexacute */
    0x1ec0,     /* #x1EC0 Ecircumflexgrave */
    0x1ec1,     /* #x1EC1 ecircumflexgrave */
    0x1ec2,     /* #x1EC2 Ecircumflexhook */
    0x1ec3,     /* #x1EC3 ecircumflexhook */
    0x1ec4,     /* #x1EC4 Ecircumflextilde */
    0x1ec5,     /* #x1EC5 ecircumflextilde */
    0x1ec6,     /* #x1EC6 Ecircumflexbelowdot */
    0x1ec7,     /* #x1EC7 ecircumflexbelowdot */
    0x1ec8,     /* #x1EC8 Ihook */
    0x1ec9,     /* #x1EC9 ihook */
    0x1eca,     /* #x1ECA Ibelowdot */
    0x1ecb,     /* #x1ECB ibelowdot */
    0x1ecc,     /* #x1ECC Obelowdot */
    0x1ecd,     /* #x1ECD obelowdot */
    0x1ece,     /* #x1ECE Ohook */
    0x1ecf,     /* #x1ECF ohook */
    0x1ed0,     /* #x1ED0 Ocircumflexacute */
    0x1ed1,     /* #x1ED1 ocircumflexacute */
    0x1ed2,     /* #x1ED2 Ocircumflexgrave */
    0x1ed3,     /* #x1ED3 ocircumflexgrave */
    0x1ed4,     /* #x1ED4 Ocircumflexhook */
    0x1ed5,     /* #x1ED5 ocircumflexhook */
    0x1ed6,     /* #x1ED6 Ocircumflextilde */
    0x1ed7,     /* #x1ED7 ocircumflextilde */
    0x1ed8,     /* #x1ED8 Ocircumflexbelowdot */
    0x1ed9,     /* #x1ED9 ocircumflexbelowdot */
    0x1eda,     /* #x1EDA Ohornacute */
    0x1edb,     /* #x1EDB ohornacute */
    0x1edc,     /* #x1EDC Ohorngrave */
    0x1edd,     /* #x1EDD ohorngrave */
    0x1ede,     /* #x1EDE Ohornhook */
    0x1edf,     /* #x1EDF ohornhook */
    0x1ee0,     /* #x1EE0 Ohorntilde */
    0x1ee1,     /* #x1EE1 ohorntilde */
    0x1ee2,     /* #x1EE2 Ohornbelowdot */
    0x1ee3,     /* #x1EE3 ohornbelowdot */
    0x1ee4,     /* #x1EE4 Ubelowdot */
    0x1ee5,     /* #x1EE5 ubelowdot */
    0x1ee6,     /* #x1EE6 Uhook */
    0x1ee7,     /* #x1EE7 uhook */
    0x1ee8,     /* #x1EE8 Uhornacute */
    0x1ee9,     /* #x1EE9 uhornacute */
    0x1eea,     /* #x1EEA Uhorngrave */
    0x1eeb,     /* #x1EEB uhorngrave */
    0x1eec,     /* #x1EEC Uhornhook */
    0x1eed,     /* #x1EED uhornhook */
    0x1eee,     /* #x1EEE Uhorntilde */
    0x1eef,     /* #x1EEF uhorntilde */
    0x1ef0,     /* #x1EF0 Uhornbelowdot */
    0x1ef1,     /* #x1EF1 uhornbelowdot */
    0x0300,     /* #x1EF2 combining_grave */
    0x0301,     /* #x1EF3 combining_acute */
    0x1ef4,     /* #x1EF4 Ybelowdot */
    0x1ef5,     /* #x1EF5 ybelowdot */
    0x1ef6,     /* #x1EF6 Yhook */
    0x1ef7,     /* #x1EF7 yhook */
    0x1ef8,     /* #x1EF8 Ytilde */
    0x1ef9,     /* #x1EF9 ytilde */
  
    0x01a0,     /* #x1EFA Ohorn */
    0x01a1,     /* #x1EFB ohorn */
    0x01af,     /* #x1EFC Uhorn */
    0x01b0,     /* #x1EFD uhorn */
  
    0x0309,     /* #x1EFE combining_hook */
    0x0323,     /* #x1EFF combining_belowdot */
  };

static UINT_16_BIT const CYRILLIC[] =
  {
    0x0452,	/* #x06A1 CYRILLIC SMALL LETTER DJE  */
#define FIRST_KNOWN_CYRILLIC 0x6A1
    0x0453,	/* #x06A2 CYRILLIC SMALL LETTER GJE  */
    0x0451,	/* #x06A3 CYRILLIC SMALL LETTER IO */
    0x0454,	/* #x06A4 CYRILLIC SMALL LETTER UKRAINIAN IE */
    0x0455,	/* #x06A5 CYRILLIC SMALL LETTER DZE */
    0x0456,	/* #x06A6 CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */
    0x0457,	/* #x06A7 CYRILLIC SMALL LETTER YI */
    0x0458,	/* #x06A8 CYRILLIC SMALL LETTER JE */
    0x0459,	/* #x06A9 CYRILLIC SMALL LETTER LJE */
    0x045A,	/* #x06AA CYRILLIC SMALL LETTER NJE */
    0x045B,	/* #x06AB CYRILLIC SMALL LETTER TSHE */
    0x045C,	/* #x06AC CYRILLIC SMALL LETTER KJE */
    0x0491,	/* #x06AD CYRILLIC SMALL LETTER GHE WITH UPTURN */
    0x045E,	/* #x06AE CYRILLIC SMALL LETTER SHORT U */
    0x045F,	/* #x06AF CYRILLIC SMALL LETTER DZHE */
    0x2116,	/* #x06B0 NUMERO SIGN */
    0x0402,	/* #x06B1 CYRILLIC CAPITAL LETTER DJE */
    0x0403,	/* #x06B2 CYRILLIC CAPITAL LETTER GJE */
    0x0401,	/* #x06B3 CYRILLIC CAPITAL LETTER IO */
    0x0404,	/* #x06B4 CYRILLIC CAPITAL LETTER UKRAINIAN IE */
    0x0405,	/* #x06B5 CYRILLIC CAPITAL LETTER DZE */
    0x0406,	/* #x06B6 CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */
    0x0407,	/* #x06B7 CYRILLIC CAPITAL LETTER YI */
    0x0408,	/* #x06B8 CYRILLIC CAPITAL LETTER JE */
    0x0409,	/* #x06B9 CYRILLIC CAPITAL LETTER LJE */
    0x040A,	/* #x06BA CYRILLIC CAPITAL LETTER NJE */
    0x040B,	/* #x06BB CYRILLIC CAPITAL LETTER TSHE */
    0x040C,	/* #x06BC CYRILLIC CAPITAL LETTER KJE */
    0x0490,	/* #x06BD CYRILLIC CAPITAL LETTER GHE WITH UPTURN */
    0x040E,	/* #x06BE CYRILLIC CAPITAL LETTER SHORT U */
    0x040F,	/* #x06BF CYRILLIC CAPITAL LETTER DZHE */
    0x044E,	/* #x06C0 CYRILLIC SMALL LETTER YU */
    0x0430,	/* #x06C1 CYRILLIC SMALL LETTER A */
    0x0431,	/* #x06C2 CYRILLIC SMALL LETTER BE */
    0x0446,	/* #x06C3 CYRILLIC SMALL LETTER TSE */
    0x0434,	/* #x06C4 CYRILLIC SMALL LETTER DE */
    0x0435,	/* #x06C5 CYRILLIC SMALL LETTER IE */
    0x0444,	/* #x06C6 CYRILLIC SMALL LETTER EF */
    0x0433,	/* #x06C7 CYRILLIC SMALL LETTER GHE */
    0x0445,	/* #x06C8 CYRILLIC SMALL LETTER HA */
    0x0438,	/* #x06C9 CYRILLIC SMALL LETTER I */
    0x0439,	/* #x06CA CYRILLIC SMALL LETTER SHORT I */
    0x043A,	/* #x06CB CYRILLIC SMALL LETTER KA */
    0x043B,	/* #x06CC CYRILLIC SMALL LETTER EL */
    0x043C,	/* #x06CD CYRILLIC SMALL LETTER EM */
    0x043D,	/* #x06CE CYRILLIC SMALL LETTER EN */
    0x043E,	/* #x06CF CYRILLIC SMALL LETTER O */
    0x043F,	/* #x06D0 CYRILLIC SMALL LETTER PE */
    0x044F,	/* #x06D1 CYRILLIC SMALL LETTER YA */
    0x0440,	/* #x06D2 CYRILLIC SMALL LETTER ER */
    0x0441,	/* #x06D3 CYRILLIC SMALL LETTER ES */
    0x0442,	/* #x06D4 CYRILLIC SMALL LETTER TE */
    0x0443,	/* #x06D5 CYRILLIC SMALL LETTER U */
    0x0436,	/* #x06D6 CYRILLIC SMALL LETTER ZHE */
    0x0432,	/* #x06D7 CYRILLIC SMALL LETTER VE */
    0x044C,	/* #x06D8 CYRILLIC SMALL LETTER SOFT SIGN */
    0x044B,	/* #x06D9 CYRILLIC SMALL LETTER YERU */
    0x0437,	/* #x06DA CYRILLIC SMALL LETTER ZE */
    0x0448,	/* #x06DB CYRILLIC SMALL LETTER SHA */
    0x044D,	/* #x06DC CYRILLIC SMALL LETTER E */
    0x0449,	/* #x06DD CYRILLIC SMALL LETTER SHCHA */
    0x0447,	/* #x06DE CYRILLIC SMALL LETTER CHE */
    0x044A,	/* #x06DF CYRILLIC SMALL LETTER HARD SIGN */
    0x042E,	/* #x06E0 CYRILLIC CAPITAL LETTER YU */
    0x0410,	/* #x06E1 CYRILLIC CAPITAL LETTER A */
    0x0411,	/* #x06E2 CYRILLIC CAPITAL LETTER BE */
    0x0426,	/* #x06E3 CYRILLIC CAPITAL LETTER TSE */
    0x0414,	/* #x06E4 CYRILLIC CAPITAL LETTER DE */
    0x0415,	/* #x06E5 CYRILLIC CAPITAL LETTER IE */
    0x0424,	/* #x06E6 CYRILLIC CAPITAL LETTER EF */
    0x0413,	/* #x06E7 CYRILLIC CAPITAL LETTER GHE */
    0x0425,	/* #x06E8 CYRILLIC CAPITAL LETTER HA */
    0x0418,	/* #x06E9 CYRILLIC CAPITAL LETTER I */
    0x0419,	/* #x06EA CYRILLIC CAPITAL LETTER SHORT I */
    0x041A,	/* #x06EB CYRILLIC CAPITAL LETTER KA */
    0x041B,	/* #x06EC CYRILLIC CAPITAL LETTER EL */
    0x041C,	/* #x06ED CYRILLIC CAPITAL LETTER EM */
    0x041D,	/* #x06EE CYRILLIC CAPITAL LETTER EN */
    0x041E,	/* #x06EF CYRILLIC CAPITAL LETTER O */
    0x041F,	/* #x06F0 CYRILLIC CAPITAL LETTER PE */
    0x042F,	/* #x06F1 CYRILLIC CAPITAL LETTER YA */
    0x0420,	/* #x06F2 CYRILLIC CAPITAL LETTER ER */
    0x0421,	/* #x06F3 CYRILLIC CAPITAL LETTER ES */
    0x0422,	/* #x06F4 CYRILLIC CAPITAL LETTER TE */
    0x0423,	/* #x06F5 CYRILLIC CAPITAL LETTER U */
    0x0416,	/* #x06F6 CYRILLIC CAPITAL LETTER ZHE */
    0x0412,	/* #x06F7 CYRILLIC CAPITAL LETTER VE */
    0x042C,	/* #x06F8 CYRILLIC CAPITAL LETTER SOFT SIGN */
    0x042B,	/* #x06F9 CYRILLIC CAPITAL LETTER YERU */
    0x0417,	/* #x06FA CYRILLIC CAPITAL LETTER ZE */
    0x0428,	/* #x06FB CYRILLIC CAPITAL LETTER SHA */
    0x042D,	/* #x06FC CYRILLIC CAPITAL LETTER E */
    0x0429,	/* #x06FD CYRILLIC CAPITAL LETTER SHCHA */
    0x0427,	/* #x06FE CYRILLIC CAPITAL LETTER CHE */
    0x042A,	/* #x06FF CYRILLIC CAPITAL LETTER HARD SIGN */
  };

/* For every key on the keyboard that has a known character correspondence,
   we define the character-of-keysym property of its XEmacs keysym, and make
   the default binding for the key be self-insert-command.

   The following magic is based on intimate knowledge of some of
   X11/keysymdef.h.  The keysym mappings defined by X11 are based on the
   iso8859 standards, except for Cyrillic and Greek.

   In a non-Mule world, a user can still have a multi-lingual editor, by
   doing (set-face-font "...-iso8859-2" (current-buffer)) for all their
   Latin-2 buffers, etc. and the X11 keysyms corresponding to characters in
   those character sets will still do the right thing (because of the
   make_char (code + 0x80) non-Mule case below.) Of course, X11 keysyms in
   other character sets will not do the right thing, because XEmacs won't
   support the right thing.

   This code is also called when a command lookup is about to fail, and the
   X11 platform code has worked out that it previously wasn't aware the
   keysym of that command could be generated by the user's keyboard; in that
   case, we bind its XEmacs keysym to self-insert-command if it has a
   character correspondence we know about, and tell the general event code
   that we've done so, so it can try the lookup again. */

static Lisp_Object
x_keysym_to_character (KeySym keysym)
{
#ifdef MULE
  Lisp_Object charset = Qzero;
  int code = 0;
#endif /* MULE */

  if (keysym < 0x100)
    {
      return make_char ((Ichar) keysym);
    }

  /* @@#### Add support for 0xFE?? and 0xFF?? keysyms

     See http://www.cl.cam.ac.uk/~mgk25/ucs/keysyms.txt
 */

  /* Markus Kuhn's spec says keysyms in the range #x01000100 to #x0110FFFF
     and only those should correspond directly to Unicode code points, in
     the range #x100-#x10FFFF; actual implementations can have the Latin 1
     code points do the same thing with keysyms
     #x01000000-#x01000100. */

#ifndef MULE
  if (keysym >= 0x01000000 && keysym <= 0x010000FF)
    return make_char (keysym & 0xFFFFFF);
#else
  if (keysym >= 0x01000000 && keysym <= 0x0110FFFF)
    /* Use the language-environment precedence list, not that of
       the current buffer. */
    return make_char (filtered_unicode_to_ichar
                      ((int)(keysym & 0xFFFFFF),
                       Vdefault_unicode_precedence_array, NULL,
                       CONVERR_SUCCEED));
#endif /* not MULE */

  if ((keysym & 0xff) < 0xa0)
    return Qnil;

#ifdef MULE
  switch (keysym >> 8)
    {
    case 0: /* ASCII + Latin1 */
      charset = Vcharset_latin_iso8859_1;
      code = keysym & 0xff;
      break;
    case 1: /* Latin2 */
      charset = Vcharset_latin_iso8859_2;
      code = keysym & 0xff;
      break;
    case 2: /* Latin3 */
      charset = Vcharset_latin_iso8859_3;
      code = keysym & 0xff;
      break;
    case 3: /* Latin4 */
      charset = Vcharset_latin_iso8859_4;
      code = keysym & 0xff;
      break;
    case 4: /* Katakana */
      charset = Vcharset_katakana_jisx0201;
      if ((keysym & 0xff) > 0xa0)
	code = keysym & 0xff;
      break;
    case 5: /* Arabic */
      charset = Vcharset_arabic_iso8859_6;
      code = keysym & 0xff;
      break;
    case 6: /* Cyrillic */
      {
	USE_UNICODE_MAP (keysym, CYRILLIC);
	break;
      }
    case 7: /* Greek */
      {
	static UExtbyte const greek[] = /* 0xa0 - 0xff */
	{0x00, 0xb6, 0xb8, 0xb9, 0xba, 0xda, 0x00, 0xbc,
	 0xbe, 0xdb, 0x00, 0xbf, 0x00, 0x00, 0xb5, 0xaf,
	 0x00, 0xdc, 0xdd, 0xde, 0xdf, 0xfa, 0xc0, 0xfc,
	 0xfd, 0xfb, 0xe0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	 0xd0, 0xd1, 0xd3, 0x00, 0xd4, 0xd5, 0xd6, 0xd7,
	 0xd8, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	 0xf0, 0xf1, 0xf3, 0xf2, 0xf4, 0xf5, 0xf6, 0xf7,
	 0xf8, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	charset = Vcharset_greek_iso8859_7;
	code = greek[(keysym & 0x7f) - 0x20];
	break;
      }
    case 8: 
      USE_UNICODE_MAP (keysym, TECHNICAL);
      break;
    case 9: 
      USE_UNICODE_MAP (keysym, SPECIAL);
      break;
    case 10:
      USE_UNICODE_MAP (keysym, PUBLISHING);
      break;
    case 11:
      USE_UNICODE_MAP (keysym, APL);
      break;
    case 12: /* Hebrew */
      charset = Vcharset_hebrew_iso8859_8;
      code = keysym & 0xff;
      break;
    case 13: /* Thai */
      /* #### This needs to deal with character composition.
	 Are you sure we can't leave it to the X server? */
      charset = Vcharset_thai_tis620;
      code = keysym & 0xff;
      break;
    case 14: /* Korean Hangul. */
      USE_UNICODE_MAP (keysym, HANGUL);
      break;
    case 18: /* Latin 8 - ISO8859-14. */
      charset = Ffind_charset (intern ("latin-iso8859-14"));
      code = keysym & 0xff;
      break;
    case 19: /* Latin 9 - ISO8859-15. */
      charset = Vcharset_latin_iso8859_15;
      code = keysym & 0xff;
      break;
    case 20: /* Armenian. */
      USE_UNICODE_MAP (keysym, ARMENIAN);
      break;
    case 21: /* Georgian. */
      USE_UNICODE_MAP (keysym, GEORGIAN);
      break;
    case 22: /* Azeri (and other Turkic or Caucasian languages of ex-USSR) */
      USE_UNICODE_MAP (keysym, AZERI_ETC);
      break;
    case 30: /* Vietnamese */
      USE_UNICODE_MAP (keysym, VIETNAMESE);
      break;
    case 32: /* Currency. The lower sixteen bits of these keysyms happily
		correspond exactly to the Unicode code points of the
		associated characters */
      return make_char (filtered_unicode_to_ichar
                        ((int) (keysym & 0xffff),
                         Vdefault_unicode_precedence_array, NULL,
                         CONVERR_SUCCEED));

/* @@#### Support me!

   Actually, these are somewhat already supported by x-init.el/x-compose.el,
   but only acute, grave, circum(flex), cedilla, diaeresis, tilde.  We
   should try to eliminate that code and use general Unicode support for
   converting to precomposed sequences.

0xfe50   U0300   f   # dead_grave
0xfe51   U0301   f   # dead_acute
0xfe52   U0302   f   # dead_circumflex
0xfe53   U0303   f   # dead_tilde
0xfe54   U0304   f   # dead_macron
0xfe55   U0306   f   # dead_breve
0xfe56   U0307   f   # dead_abovedot
0xfe57   U0308   f   # dead_diaeresis
0xfe58   U030a   f   # dead_abovering
0xfe59   U030b   f   # dead_doubleacute
0xfe5a   U030c   f   # dead_caron
0xfe5b   U0327   f   # dead_cedilla
0xfe5c   U0328   f   # dead_ogonek
0xfe5d   U0345   f   # dead_iota
0xfe5e   U3099   f   # dead_voiced_sound
0xfe5f   U309a   f   # dead_semivoiced_sound
0xfe60   U0323   f   # dead_belowdot
0xfe61   U0309   f   # dead_hook
0xfe62   U031b   f   # dead_horn

What about these?  We don't have to convert these to ASCII but make sure we
handle all of the KP-foo things and get them to behave like plain foo when
KP-foo isn't bound (which includes self-inserting the associated character
if necessary). DOCUMENT the existing system that does this.

0xff08   U0008   f   # BackSpace	/- back space, back char -/
0xff09   U0009   f   # Tab
0xff0a   U000a   f   # Linefeed	/- Linefeed, LF -/
0xff0b   U000b   f   # Clear
0xff0d   U000d   f   # Return	/- Return, enter -/
0xff13   U0013   f   # Pause	/- Pause, hold -/
0xff14   U0014   f   # Scroll_Lock
0xff15   U0015   f   # Sys_Req
0xff1b   U001b   f   # Escape
0xff80   U0020   f   # KP_Space	/- space -/
0xff89   U0009   f   # KP_Tab
0xff8d   U000d   f   # KP_Enter	/- enter -/
0xffaa   U002a   f   # KP_Multiply
0xffab   U002b   f   # KP_Add
0xffac   U002c   f   # KP_Separator	/- separator, often comma -/
0xffad   U002d   f   # KP_Subtract
0xffae   U002e   f   # KP_Decimal
0xffaf   U002f   f   # KP_Divide
0xffb0   U0030   f   # KP_0
0xffb1   U0031   f   # KP_1
0xffb2   U0032   f   # KP_2
0xffb3   U0033   f   # KP_3
0xffb4   U0034   f   # KP_4
0xffb5   U0035   f   # KP_5
0xffb6   U0036   f   # KP_6
0xffb7   U0037   f   # KP_7
0xffb8   U0038   f   # KP_8
0xffb9   U0039   f   # KP_9
0xffbd   U003d   f   # KP_Equal	/- equals -/
*/
    default:
      break;
    }

  assert (!NILP (charset));

  if (code == 0 || EQ (charset, Qzero))
    {
      /* CHARSET being zero is unlikely, but we shouldn't crash, even with
         error-checking turned on, if X11 gives us a keysym we don't
         understand. Don't make it an assertion. */
      return Qnil;
    }
  else
    {
      /* First try to generate a unified character by converting through
	 Unicode, then try converting directly to an Ichar (only matters
	 when non-Unicode-internal, else we get same results both ways). */
      int ucs = charset_codepoint_to_unicode (charset, 0, code, CONVERR_FAIL);
      if (ucs >= 0)
	{
          Ichar ich
            /* Use the language-environment precedence list, not that of the
               current buffer. */
            = filtered_unicode_to_ichar (ucs,
                                         Vdefault_unicode_precedence_array,
                                         NULL, CONVERR_SUCCEED);
	  if (ich >= 0)
            {
              return make_char (ich);
            }
	}
      else
	{
	  Ichar ich
            = charset_codepoint_to_ichar (charset, 0, code, CONVERR_FAIL);
	  if (ich >= 0)
	    return make_char (ich);
	}
    }
  return Qnil;
#else /* not MULE */
  if (keysym >= 0x100)
    return Qnil;
  return make_char (keysym);
#endif /* (not) MULE */
}

/************************************************************************/
/*                            keymap handling                           */
/************************************************************************/

extern Lisp_Object Vcurrent_global_map;

/* See comment near character_to_event(). */
static void
maybe_define_x_key_as_self_inserting_character (Lisp_Object emacs_keysym)
{
  if (CHARP (emacs_keysym))
    {
      if (NILP (Flookup_key (Vcurrent_global_map, emacs_keysym, Qnil))) 
        {
	  Fdefine_key (Vcurrent_global_map, emacs_keysym,
                       Qself_insert_command); 
        }
    }
}

void
x_has_keysym (KeySym keysym, Lisp_Object hash_table, int with_modifiers)
{
  KeySym upper_lower[2];
  int j;

  if (keysym < 0x80) /* ASCII keysyms have default bindings anyway. */
    return;

  /* If you execute:
     xmodmap -e 'keysym NN = scaron'
     and then press (Shift scaron), X11 will return the different
     keysym `Scaron', but  `xmodmap -pke'  might not even mention `Scaron'.
     So we "register" both `scaron' and `Scaron'. */
#ifdef HAVE_XCONVERTCASE
  XConvertCase (keysym, &upper_lower[0], &upper_lower[1]);
#else
  upper_lower[0] = upper_lower[1] = keysym;
#endif

  for (j = 0; j < (upper_lower[0] == upper_lower[1] ? 1 : 2); j++)
    {
      KeySym ks = upper_lower[j];
      Lisp_Object sym = x_keysym_to_emacs_keysym (ks);
      Lisp_Object new_value = with_modifiers ? Qt : Qsans_modifiers;
      Lisp_Object old_value = Fgethash (sym, hash_table, Qnil);

      if (! EQ (old_value, new_value)
          && ! (EQ (old_value, Qsans_modifiers) &&
                EQ (new_value, Qt)))
        {
          maybe_define_x_key_as_self_inserting_character (sym);
          Fputhash (sym, new_value, hash_table);
	}
    }
}

static void
x_reset_key_mapping (struct device *d)
{
  Display *display = DEVICE_X_DISPLAY (d);
  struct x_device *xd = DEVICE_X_DATA (d);
  KeySym *keysym, *keysym_end;
  Lisp_Object hash_table;
  int key_code_count, keysyms_per_code;

  if (xd->x_keysym_map)
    XFree ((char *) xd->x_keysym_map);
  XDisplayKeycodes (display,
		    &xd->x_keysym_map_min_code,
		    &xd->x_keysym_map_max_code);
  key_code_count = xd->x_keysym_map_max_code - xd->x_keysym_map_min_code + 1;
  xd->x_keysym_map =
    XGetKeyboardMapping (display, xd->x_keysym_map_min_code, key_code_count,
			 &xd->x_keysym_map_keysyms_per_code);

  hash_table = xd->x_keysym_map_hash_table;
  if (HASH_TABLEP (hash_table))
    Fclrhash (hash_table);
  else
    xd->x_keysym_map_hash_table = hash_table =
      make_lisp_hash_table (128, HASH_TABLE_NON_WEAK, Qequal);

  for (keysym = xd->x_keysym_map,
	 keysyms_per_code = xd->x_keysym_map_keysyms_per_code,
	 keysym_end = keysym + (key_code_count * keysyms_per_code);
       keysym < keysym_end;
       keysym += keysyms_per_code)
    {
      int j;

      if (keysym[0] == NoSymbol)
	continue;

      x_has_keysym (keysym[0], hash_table, 0);

      for (j = 1; j < keysyms_per_code; j++)
	{
	  if (keysym[j] != keysym[0] &&
	      keysym[j] != NoSymbol)
	    x_has_keysym (keysym[j], hash_table, 1);
	}
    }
}

static const Ascbyte *
index_to_name (int indice)
{
  switch (indice)
    {
    case ShiftMapIndex:   return "ModShift";
    case LockMapIndex:    return "ModLock";
    case ControlMapIndex: return "ModControl";
    case Mod1MapIndex:    return "Mod1";
    case Mod2MapIndex:    return "Mod2";
    case Mod3MapIndex:    return "Mod3";
    case Mod4MapIndex:    return "Mod4";
    case Mod5MapIndex:    return "Mod5";
    default:              return "???";
    }
}

/* X bogusly doesn't define the interpretations of any bits besides
   ModControl, ModShift, and ModLock; so the Interclient Communication
   Conventions Manual says that we have to bend over backwards to figure
   out what the other modifier bits mean.  According to ICCCM:

   - Any keycode which is assigned ModControl is a "control" key.

   - Any modifier bit which is assigned to a keycode which generates Meta_L
     or Meta_R is the modifier bit meaning "meta".  Likewise for Super, Hyper,
     etc.

   - Any keypress event which contains ModControl in its state should be
     interpreted as a "control" character.

   - Any keypress event which contains a modifier bit in its state which is
     generated by a keycode whose corresponding keysym is Meta_L or Meta_R
     should be interpreted as a "meta" character.  Likewise for Super, Hyper,
     etc.

   - It is illegal for a keysym to be associated with more than one modifier
     bit.

   This means that the only thing that emacs can reasonably interpret as a
   "meta" key is a key whose keysym is Meta_L or Meta_R, and which generates
   one of the modifier bits Mod1-Mod5.

   Unfortunately, many keyboards don't have Meta keys in their default
   configuration.  So, if there are no Meta keys, but there are "Alt" keys,
   emacs will interpret Alt as Meta.  If there are both Meta and Alt keys,
   then the Meta keys mean "Meta", and the Alt keys mean "Alt" (it used to
   mean "Symbol," but that just confused the hell out of way too many people).

   This works with the default configurations of the 19 keyboard-types I've
   checked.

   Emacs detects keyboard configurations which violate the above rules, and
   gives a warning. */

static void
x_reset_modifier_mapping (struct device *d)
{
  Display *display = DEVICE_X_DISPLAY (d);
  struct x_device *xd = DEVICE_X_DATA (d);
  int modifier_index, modifier_key, column, mkpm;
  int warned_about_overlapping_modifiers = 0;
  int warned_about_predefined_modifiers  = 0;
  int meta_bit  = 0;
  int hyper_bit = 0;
  int super_bit = 0;
  int alt_bit   = 0;
  int mode_bit  = 0;

  xd->lock_interpretation = 0;

  if (xd->x_modifier_keymap)
    {
      XFreeModifiermap (xd->x_modifier_keymap);
      /* Set it to NULL in case we receive two MappingModifier events in a
         row, and the second is processed during some CHECK_QUITs within
         x_reset_key_mapping. If that happens, XFreeModifierMap will be
         called twice on the same map, and we crash.  */
      xd->x_modifier_keymap = NULL;
    }

  x_reset_key_mapping (d);

  xd->x_modifier_keymap = XGetModifierMapping (display);

  /* Boy, I really wish C had local functions...
   */

#define modwarn(name,old,other)					\
  warn_when_safe (Qkey_mapping, Qwarning,			\
 "XEmacs:  %s (0x%x) generates %s, which is generated by %s.",	\
		  name, code, index_to_name (old), other),	\
  warned_about_overlapping_modifiers = 1

#define modbarf(name,other)					\
  warn_when_safe (Qkey_mapping, Qwarning,			\
 "XEmacs:  %s (0x%x) generates %s, which is nonsensical.",	\
		  name, code, other),				\
  warned_about_predefined_modifiers = 1

#define check_modifier(name,mask)					\
  if ((1<<modifier_index) != mask)					\
    warn_when_safe (Qkey_mapping, Qwarning,				\
 "XEmacs:  %s (0x%x) generates %s, which is nonsensical.",		\
		    name, code, index_to_name (modifier_index)),	\
    warned_about_predefined_modifiers = 1

#define store_modifier(name,old)					\
  if (old && old != modifier_index)					\
    warn_when_safe (Qkey_mapping, Qwarning,				\
 "XEmacs:  %s (0x%x) generates both %s and %s, which is nonsensical.",	\
		    name, code, index_to_name (old),			\
		    index_to_name (modifier_index));			\
  if (modifier_index == ShiftMapIndex) modbarf (name,"ModShift");	\
  else if (modifier_index == LockMapIndex) modbarf (name,"ModLock");	\
  else if (modifier_index == ControlMapIndex) modbarf (name,"ModControl"); \
  else if (sym == XK_Mode_switch)					\
    mode_bit = modifier_index; /* Mode_switch is special, see below... */ \
  else if (modifier_index == meta_bit && old != meta_bit)		\
    modwarn (name, meta_bit, "Meta");					\
  else if (modifier_index == super_bit && old != super_bit)		\
    modwarn (name, super_bit, "Super");					\
  else if (modifier_index == hyper_bit && old != hyper_bit)		\
    modwarn (name, hyper_bit, "Hyper");					\
  else if (modifier_index == alt_bit && old != alt_bit)			\
    modwarn (name, alt_bit, "Alt");					\
  else									\
    old = modifier_index;

  mkpm = xd->x_modifier_keymap->max_keypermod;
  for (modifier_index = 0; modifier_index < 8; modifier_index++)
    for (modifier_key = 0; modifier_key < mkpm; modifier_key++) {
      KeySym last_sym = 0;
      for (column = 0; column < 4; column += 2) {
	KeyCode code = xd->x_modifier_keymap->modifiermap[modifier_index * mkpm
							  + modifier_key];
	KeySym sym = (code ? XKeycodeToKeysym (display, code, column) : 0);
	if (sym == last_sym) continue;
	last_sym = sym;
	switch (sym) {
	case XK_Mode_switch:store_modifier ("Mode_switch", mode_bit); break;
	case XK_Meta_L:     store_modifier ("Meta_L", meta_bit); break;
	case XK_Meta_R:     store_modifier ("Meta_R", meta_bit); break;
	case XK_Super_L:    store_modifier ("Super_L", super_bit); break;
	case XK_Super_R:    store_modifier ("Super_R", super_bit); break;
	case XK_Hyper_L:    store_modifier ("Hyper_L", hyper_bit); break;
	case XK_Hyper_R:    store_modifier ("Hyper_R", hyper_bit); break;
	case XK_Alt_L:      store_modifier ("Alt_L", alt_bit); break;
	case XK_Alt_R:      store_modifier ("Alt_R", alt_bit); break;
	case XK_Control_L:  check_modifier ("Control_L", ControlMask); break;
	case XK_Control_R:  check_modifier ("Control_R", ControlMask); break;
	case XK_Shift_L:    check_modifier ("Shift_L", ShiftMask); break;
	case XK_Shift_R:    check_modifier ("Shift_R", ShiftMask); break;
	case XK_Shift_Lock: check_modifier ("Shift_Lock", LockMask);
	  xd->lock_interpretation = XK_Shift_Lock; break;
	case XK_Caps_Lock:  check_modifier ("Caps_Lock", LockMask);
	  xd->lock_interpretation = XK_Caps_Lock; break;

	/* It probably doesn't make any sense for a modifier bit to be
	   assigned to a key that is not one of the above, but OpenWindows
	   assigns modifier bits to a couple of random function keys for
	   no reason that I can discern, so printing a warning here would
	   be annoying. */
	}
      }
    }
#undef store_modifier
#undef check_modifier
#undef modwarn
#undef modbarf

  /* If there was no Meta key, then try using the Alt key instead.
     If there is both a Meta key and an Alt key, then the Alt key
     is not disturbed and remains an Alt key. */
  if (! meta_bit && alt_bit)
    meta_bit = alt_bit, alt_bit = 0;

  /* mode_bit overrides everything, since it's processed down inside of
     XLookupString() instead of by us.  If Meta and Mode_switch both
     generate the same modifier bit (which is an error), then we don't
     interpret that bit as Meta, because we can't make XLookupString()
     not interpret it as Mode_switch; and interpreting it as both would
     be totally wrong. */
  if (mode_bit)
    {
      const Ascbyte *warn = 0;
      if      (mode_bit == meta_bit)  warn = "Meta",  meta_bit  = 0;
      else if (mode_bit == hyper_bit) warn = "Hyper", hyper_bit = 0;
      else if (mode_bit == super_bit) warn = "Super", super_bit = 0;
      else if (mode_bit == alt_bit)   warn = "Alt",   alt_bit   = 0;
      if (warn)
	{
	  warn_when_safe
	    (Qkey_mapping, Qwarning,
	     "XEmacs:  %s is being used for both Mode_switch and %s.",
	     index_to_name (mode_bit), warn),
	    warned_about_overlapping_modifiers = 1;
	}
    }
#undef index_to_name

  xd->MetaMask   = (meta_bit   ? (1 << meta_bit)  : 0);
  xd->HyperMask  = (hyper_bit  ? (1 << hyper_bit) : 0);
  xd->SuperMask  = (super_bit  ? (1 << super_bit) : 0);
  xd->AltMask    = (alt_bit    ? (1 << alt_bit)   : 0);
  xd->ModeMask   = (mode_bit   ? (1 << mode_bit)  : 0); /* unused */


  if (warned_about_overlapping_modifiers)
    warn_when_safe (Qkey_mapping, Qwarning, "\n"
"	Two distinct modifier keys (such as Meta and Hyper) cannot generate\n"
"	the same modifier bit, because Emacs won't be able to tell which\n"
"	modifier was actually held down when some other key is pressed.  It\n"
"	won't be able to tell Meta-x and Hyper-x apart, for example.  Change\n"
"	one of these keys to use some other modifier bit.  If you intend for\n"
"	these keys to have the same behavior, then change them to have the\n"
"	same keysym as well as the same modifier bit.");

  if (warned_about_predefined_modifiers)
    warn_when_safe (Qkey_mapping, Qwarning, "\n"
"	The semantics of the modifier bits ModShift, ModLock, and ModControl\n"
"	are predefined.  It does not make sense to assign ModControl to any\n"
"	keysym other than Control_L or Control_R, or to assign any modifier\n"
"	bits to the \"control\" keysyms other than ModControl.  You can't\n"
"	turn a \"control\" key into a \"meta\" key (or vice versa) by simply\n"
"	assigning the key a different modifier bit.  You must also make that\n"
"	key generate an appropriate keysym (Control_L, Meta_L, etc).");

  /* No need to say anything more for warned_about_duplicate_modifiers. */

  if (warned_about_overlapping_modifiers || warned_about_predefined_modifiers)
    warn_when_safe (Qkey_mapping, Qwarning, "\n"
"	The meanings of the modifier bits Mod1 through Mod5 are determined\n"
"	by the keysyms used to control those bits.  Mod1 does NOT always\n"
"	mean Meta, although some non-ICCCM-compliant programs assume that.");
}

void
x_init_modifier_mapping (struct device *d)
{
  struct x_device *xd = DEVICE_X_DATA (d);
  xd->x_keysym_map_hash_table = Qnil;
  xd->x_keysym_map = NULL;
  xd->x_modifier_keymap = NULL;
  x_reset_modifier_mapping (d);
}

static int
x_key_is_modifier_p (KeyCode keycode, struct device *d)
{
  struct x_device *xd = DEVICE_X_DATA (d);
  KeySym *syms;
  int i;

  if (keycode < xd->x_keysym_map_min_code ||
      keycode > xd->x_keysym_map_max_code)
    return 0;

  syms = &xd->x_keysym_map [(keycode - xd->x_keysym_map_min_code) *
			   xd->x_keysym_map_keysyms_per_code];
  for (i = 0; i < xd->x_keysym_map_keysyms_per_code; i++)
    if (IsModifierKey (syms [i]) ||
	syms [i] == XK_Mode_switch) /* why doesn't IsModifierKey count this? */
      return 1;
  return 0;
}

/* key-handling code is always ugly.  It just ends up working out
   that way.

   Here are some pointers:

   -- DOWN_MASK indicates which modifiers should be treated as "down"
      when the corresponding upstroke happens.  It gets reset for
      a particular modifier when that modifier goes up, and reset
      for all modifiers when a non-modifier key is pressed.  Example:

      I press Control-A-Shift and then release Control-A-Shift.
      I want the Shift key to be sticky but not the Control key.

   -- LAST_DOWNKEY and RELEASE_TIME are used to keep track of
      auto-repeat -- see below.

   -- If a modifier key is sticky, I can unstick it by pressing
      the modifier key again. */

static void
x_handle_sticky_modifiers (XEvent *ev, struct device *d)
{
  struct x_device *xd;
  KeyCode keycode;
  int type;

  if (!modifier_keys_are_sticky) /* Optimize for non-sticky modifiers */
    return;

  xd = DEVICE_X_DATA (d);
  keycode = ev->xkey.keycode;
  type = ev->type;

  if (keycode < xd->x_keysym_map_min_code ||
      keycode > xd->x_keysym_map_max_code)
    return;

  if (! ((type == KeyPress || type == KeyRelease) &&
         x_key_is_modifier_p (keycode, d)))
    { /* Not a modifier key */
      Bool key_event_p = (type == KeyPress || type == KeyRelease);

      if (type == ButtonPress
	  || (type == KeyPress
	      && ((xd->last_downkey
		   && ((keycode != xd->last_downkey
			|| ev->xkey.time != xd->release_time)))
		  || (FIXNUMP (Vmodifier_keys_sticky_time)
		      && ev->xkey.time
		      > (xd->modifier_release_time
			 + XFIXNUM (Vmodifier_keys_sticky_time))))))
	{
	  xd->need_to_add_mask = 0;
	  xd->last_downkey = 0;
	}
      else if (type == KeyPress && !xd->last_downkey)
	xd->last_downkey = keycode;

      if (type == KeyPress)
	xd->release_time = 0;
      if (type == KeyPress || type == ButtonPress)
	{
	  xd->down_mask = 0;
	  xd->modifier_release_time = 0;
	}

      if (key_event_p)
        ev->xkey.state    |= xd->need_to_add_mask;
      else
        ev->xbutton.state |= xd->need_to_add_mask;

      if (type == KeyRelease && keycode == xd->last_downkey)
	/* If I hold press-and-release the Control key and then press
	   and hold down the right arrow, I want it to auto-repeat
	   Control-Right.  On the other hand, if I do the same but
	   manually press the Right arrow a bunch of times, I want
	   to see one Control-Right and then a bunch of Rights.
	   This means that we need to distinguish between an
	   auto-repeated key and a key pressed and released a bunch
	   of times.

	   Naturally, the designers of the X spec didn't see fit
	   to provide an obvious way to distinguish these cases.
	   So we assume that if the release and the next press
	   occur at the same time, the key was actually auto-
	   repeated.  Under Open-Windows, at least, this works. */
	xd->modifier_release_time = xd->release_time
	  = key_event_p ? ev->xkey.time : ev->xbutton.time;
    }
  else                          /* Modifier key pressed */
    {
      int i;
      KeySym *syms = &xd->x_keysym_map [(keycode - xd->x_keysym_map_min_code) *
					xd->x_keysym_map_keysyms_per_code];

      /* If a non-modifier key was pressed in the middle of a bunch
	 of modifiers, then it unsticks all the modifiers that were
	 previously pressed.  We cannot unstick the modifiers until
	 now because we want to check for auto-repeat of the
	 non-modifier key. */

      if (xd->last_downkey)
	{
	  xd->last_downkey = 0;
	  xd->need_to_add_mask = 0;
	}

      if (xd->modifier_release_time
	  && FIXNUMP (Vmodifier_keys_sticky_time)
	  && (ev->xkey.time
	      > xd->modifier_release_time + XFIXNUM (Vmodifier_keys_sticky_time)))
	{
	  xd->need_to_add_mask = 0;
	  xd->down_mask = 0;
	}

#define FROB(mask)				\
do {						\
  if (type == KeyPress)				\
    {						\
      /* If modifier key is already sticky,	\
         then unstick it.  Note that we do	\
         not test down_mask to deal with the	\
	 unlikely but possible case that the	\
	 modifier key auto-repeats. */		\
      if (xd->need_to_add_mask & mask)		\
	{					\
	  xd->need_to_add_mask &= ~mask;	\
	  xd->down_mask &= ~mask;		\
	}					\
      else					\
	xd->down_mask |= mask;			\
    }						\
  else						\
    {						\
      if (xd->down_mask & mask)			\
	{					\
	  xd->down_mask &= ~mask;		\
	  xd->need_to_add_mask |= mask;		\
	}					\
    }						\
  xd->modifier_release_time = ev->xkey.time;	\
} while (0)

      for (i = 0; i < xd->x_keysym_map_keysyms_per_code; i++)
        switch (syms[i])
          {
          case XK_Control_L: case XK_Control_R: FROB (ControlMask);   break;
          case XK_Shift_L:   case XK_Shift_R:   FROB (ShiftMask);     break;
          case XK_Meta_L:    case XK_Meta_R:    FROB (xd->MetaMask);  break;
          case XK_Super_L:   case XK_Super_R:   FROB (xd->SuperMask); break;
          case XK_Hyper_L:   case XK_Hyper_R:   FROB (xd->HyperMask); break;
          case XK_Alt_L:     case XK_Alt_R:     FROB (xd->AltMask);   break;
          }
    }
#undef FROB
}

static void
clear_sticky_modifiers (struct device *d)
{
  struct x_device *xd = DEVICE_X_DATA (d);

  xd->need_to_add_mask = 0;
  xd->last_downkey     = 0;
  xd->release_time     = 0;
  xd->down_mask        = 0;
}

static int
keysym_obeys_caps_lock_p (KeySym sym, struct device *d)
{
  struct x_device *xd = DEVICE_X_DATA (d);
  KeySym upper, lower;
  /* Eeeeevil hack.  Don't apply Caps_Lock to things that aren't alphabetic
     characters, where "alphabetic" means something more than simply A-Z.
     That is, if Caps_Lock is down, typing ESC doesn't produce Shift-ESC.
     But if shift-lock is down, then it does. */
  if (xd->lock_interpretation == XK_Shift_Lock)
    return 1;

  XConvertCase (sym, &lower, &upper);

  return !(sym == lower && sym == upper);
}

/* called from EmacsFrame.c (actually from Xt itself) when a
   MappingNotify event is received.  In its infinite wisdom, Xt
   decided that Xt event handlers never get MappingNotify events.
   O'Reilly Xt Programming Manual 9.1.2 says:

   MappingNotify is automatically handled by Xt, so it isn't passed
   to event handlers and you don't need to worry about it.

   Of course, we DO worry about it, so we need a special translation. */
void
emacs_Xt_mapping_action (Widget UNUSED (w), XEvent *event)
{
  struct device *d = get_device_from_display (event->xany.display);

  if (DEVICE_X_BEING_DELETED (d))
    return;
#if 0
  /* nyet.  Now this is handled by Xt. */
  XRefreshKeyboardMapping (&event->xmapping);
#endif
  /* xmodmap generates about a billion MappingKeyboard events, followed
     by a single MappingModifier event, so it might be worthwhile to
     take extra MappingKeyboard events out of the queue before requesting
     the current keymap from the server. */
  switch (event->xmapping.request)
    {
    case MappingKeyboard:  x_reset_key_mapping      (d); break;
    case MappingModifier:  x_reset_modifier_mapping (d); break;
    case MappingPointer:   /* Do something here? */      break;
    default: ABORT();
    }
}


/************************************************************************/
/*                  X to Emacs event conversion                         */
/************************************************************************/

static Lisp_Object
x_keysym_to_emacs_keysym (KeySym keysym)
{
  Extbyte *name;
  DECLARE_EISTRING(einame);
  Lisp_Object character;

  if (keysym >= XK_exclam && keysym <= XK_asciitilde)
    /* We must assume that the X keysym numbers for the ASCII graphic
       characters are the same as their ASCII codes.  */
    return make_char (keysym);

  switch (keysym)
    {
    case XK_BackSpace:	return QKbackspace;
    case XK_Tab:	return QKtab;
    case XK_Linefeed:	return QKlinefeed;
    case XK_Return:	return QKreturn;
    case XK_Escape:	return QKescape;
    case XK_space:	return QKspace;
    case XK_Delete:	return QKdelete;
    case 0:		return Qnil;
    default:
      character = x_keysym_to_character (keysym);

      if (CHARP (character))
        {
          return character; 
        }

      name = XKeysymToString (keysym);

      if (!name || !name[0])
	/* This happens if there is a mismatch between the Xlib of
           XEmacs and the Xlib of the X server...

	   Let's hard-code in some knowledge of common keysyms introduced
	   in recent X11 releases.  Snarfed from X11/keysymdef.h

	   Probably we should add some stuff here for X11R6. */
	switch (keysym)
	  {
	  case 0xFF95: return KEYSYM ("kp-home");
	  case 0xFF96: return KEYSYM ("kp-left");
	  case 0xFF97: return KEYSYM ("kp-up");
	  case 0xFF98: return KEYSYM ("kp-right");
	  case 0xFF99: return KEYSYM ("kp-down");
	  case 0xFF9A: return KEYSYM ("kp-prior");
	  case 0xFF9B: return KEYSYM ("kp-next");
	  case 0xFF9C: return KEYSYM ("kp-end");
	  case 0xFF9D: return KEYSYM ("kp-begin");
	  case 0xFF9E: return KEYSYM ("kp-insert");
	  case 0xFF9F: return KEYSYM ("kp-delete");

	  case 0x1005FF10: return KEYSYM ("SunF36"); /* labeled F11 */
	  case 0x1005FF11: return KEYSYM ("SunF37"); /* labeled F12 */
	  default:
	    {
	      Ibyte buf [(sizeof (int) * 2) + sizeof ("unknown-keysym-0x")];
	      emacs_snprintf (buf, sizeof (buf),
                              "unknown-keysym-0x%X", (int) keysym);
	      return KEYSYM ((const CIbyte *) (buf));
	    }
	  }
      
      /* If it's got a one-character name, that's good enough. */
      if (!name[1])
	return make_char ((Ichar)name[0]);

      /* In theory the Host Portable Character Set is just ASCII, but
         trusting X11 implementors to get that right is likely to lead to
         tears. */
      eicpy_ext(einame, name, Qbinary);

      /* If it's in the "Keyboard" character set, downcase it.
	 The case of those keysyms is too totally random for us to
	 force anyone to remember them.
	 The case of the other character sets is significant, however. */
      if ((((unsigned int) keysym) & (~0x1FF)) == ((unsigned int) 0xFE00))
	{
	  Ibyte *iname;
	  eilwr(einame);
	  
	  for (iname = eidata(einame); *iname != '\0';)
	    {
	      if (*iname == '_')
		{
		  *iname = '-';
		}
	      INC_IBYTEPTR(iname);
	    }
	}
      return KEYSYM ((const CIbyte *) eidata (einame));
    }
}

static Lisp_Object
x_to_emacs_keysym (XKeyPressedEvent *event, KeySym *x_keysym_out)
{
  KeySym keysym = NoSymbol;

#ifdef HAVE_XIM
  int len = 0;
  /* Some implementations of XmbLookupString don't return
     XBufferOverflow correctly, so increase the size of the xim input
     buffer from 64 to the more reasonable size 513, as Emacs has done.
     From Kenichi Handa. */
  char buffer[513];
  char *bufptr = buffer;
  int   bufsiz = sizeof (buffer);
  Status status;
#ifdef XIM_XLIB
  XIC xic = FRAME_X_XIC (x_any_window_to_frame
			 (get_device_from_display (event->display),
			  event->window));
#endif /* XIM_XLIB */
#endif /* HAVE_XIM */

  *x_keysym_out = NoSymbol;

  /* We use XLookupString if we're not using XIM, or are using
     XIM_XLIB but input context creation failed. */
#if ! (defined (HAVE_XIM) && defined (XIM_MOTIF))
#if defined (HAVE_XIM) && defined (XIM_XLIB)
     if (!xic)
#endif /* XIM_XLIB */
    {
      /* Apparently it's necessary to specify a dummy here (rather
         than passing in 0) to avoid crashes on German IRIX */
      char dummy[256];
      XLookupString (event, dummy, 200, &keysym, 0);
      *x_keysym_out = keysym;
      return (IsModifierKey (keysym) || keysym == XK_Mode_switch )
	? Qnil : x_keysym_to_emacs_keysym (keysym);
    }
#endif /* ! XIM_MOTIF */

#ifdef HAVE_XIM
 Lookup_String: /* Come-From XBufferOverflow */
#ifdef XIM_MOTIF
  len = XmImMbLookupString (XtWindowToWidget (event->display, event->window),
			    event, bufptr, bufsiz, &keysym, &status);
#else /* XIM_XLIB */
  if (xic)
    len = XmbLookupString (xic, event, bufptr, bufsiz, &keysym, &status);
#endif /* XIM_MOTIF */

#ifdef DEBUG_XEMACS
  if (debug_x_events > 0)
    {
      stderr_out ("   status=");
#define print_status_when(S) if (status == S) stderr_out (#S)
      print_status_when (XLookupKeySym);
      print_status_when (XLookupBoth);
      print_status_when (XLookupChars);
      print_status_when (XLookupNone);
      print_status_when (XBufferOverflow);

      if (status == XLookupKeySym || status == XLookupBoth)
	stderr_out (" keysym=%s",  XKeysymToString (keysym));
      if (status == XLookupChars  || status == XLookupBoth)
	{
	  if (len > 1)
	    {
	      int j;
	      stderr_out (" chars=\"");
	      for (j=0; j<len; j++)
		{
		  if (040 <= bufptr[j] && bufptr[j] >= 0177)
		    {
		      stderr_out ("%c", bufptr[j]);
		    }
		  else
		    {
		      stderr_out ("\\%o", (unsigned)(bufptr[j]));
		    }
		}
	      stderr_out ("\"");
	    }
	  else if (bufptr[0] <= 32 || bufptr[0] >= 127)
	    stderr_out (" char=0x%x", bufptr[0]);
	  else
	    stderr_out (" char=%c", bufptr[0]);
	}
      stderr_out ("\n");
    }
#endif /* DEBUG_XEMACS */

  switch (status)
    {
    case XLookupKeySym:
    case XLookupBoth:
      *x_keysym_out = keysym;
      return (IsModifierKey (keysym) || keysym == XK_Mode_switch )
	? Qnil : x_keysym_to_emacs_keysym (keysym);

    case XLookupChars:
      {
	/* Generate multiple emacs events */
	struct device *d = get_device_from_display (event->display);
        Ichar ch;
	Lisp_Object instream, fb_instream;
	Lstream *istr;
	struct gcpro gcpro1, gcpro2;

	fb_instream = make_fixed_buffer_input_stream (bufptr, len);

        /* [[ Use get_coding_system_for_text_file
		(Vcomposed_input_coding_system, 0) ]] 

	   Nope. If it is possible for the X libraries to have multiple IM
	   connections on different DISPLAYs active at once, this should be
	   a console-specific variable (like a TTY's coding system) but I've
	   seen no evidence that that is possible. Aidan Kehoe,
	   2005-12-17. */
	
	instream =
	  make_coding_input_stream
	    (XLSTREAM (fb_instream), Qkeyboard, CODING_DECODE, 0);

	istr = XLSTREAM (instream);

	GCPRO2 (instream, fb_instream);
        while ((ch = Lstream_get_ichar (istr)) != EOF)
          {
            Lisp_Object emacs_event = Fmake_event (Qnil, Qnil);
	    Lisp_Event *ev          = XEVENT (emacs_event);
            ev->channel	            = DEVICE_CONSOLE (d);
	    XSET_EVENT_TYPE (emacs_event, key_press_event);
	    /* Make sure space and linefeed and so on get the proper
	       keysyms. */
	    character_to_event (ch, ev, XCONSOLE (ev->channel),
				latin_1_maps_to_itself, 0);
            ev->timestamp	    = event->time;
            enqueue_dispatch_event (emacs_event);
          }
	Lstream_close (istr);
	UNGCPRO;
	Lstream_delete (istr);
	Lstream_delete (XLSTREAM (fb_instream));
	return Qnil;
      }
    case XLookupNone: return Qnil;
    case XBufferOverflow:
      /* !!#### needs work */
      bufptr = (char *) ALLOCA (len+1);
      bufsiz = len+1;
      goto Lookup_String;
    }
  return Qnil; /* not (usually) reached */
#endif /* HAVE_XIM */
}

static void
set_last_server_timestamp (struct device *d, XEvent *x_event)
{
  Time t;
  switch (x_event->type)
    {
    case KeyPress:
    case KeyRelease:       t = x_event->xkey.time;              break;
    case ButtonPress:
    case ButtonRelease:    t = x_event->xbutton.time;           break;
    case EnterNotify:
    case LeaveNotify:      t = x_event->xcrossing.time;         break;
    case MotionNotify:     t = x_event->xmotion.time;           break;
    case PropertyNotify:   t = x_event->xproperty.time;         break;
    case SelectionClear:   t = x_event->xselectionclear.time;   break;
    case SelectionRequest: t = x_event->xselectionrequest.time; break;
    case SelectionNotify:  t = x_event->xselection.time;        break;
    default: return;
    }
  DEVICE_X_LAST_SERVER_TIMESTAMP (d) = t;
}

static int
x_event_to_emacs_event (XEvent *x_event, Lisp_Event *emacs_event)
{
  Display *display    = x_event->xany.display;
  struct device *d    = get_device_from_display (display);
  struct x_device *xd = DEVICE_X_DATA (d);

  if (DEVICE_X_BEING_DELETED (d))
    {
      /* [[ Uh, is this 0 correct? ]] 

         Yup--it means emacs_Xt_event_handler, the only place that calls
         this, doesn't queue the emacs_event dispatch, instead immediately
         deallocating it. */
      return 0;
    }

  set_last_server_timestamp (d, x_event);

  switch (x_event->type)
    {
    case KeyRelease:
      {
	x_handle_sticky_modifiers (x_event, d);
	return 0;
      }
    case KeyPress:
    case ButtonPress:
    case ButtonRelease:
      {
	int modifiers = 0;
	int shift_p, lock_p;
	Bool key_event_p = (x_event->type == KeyPress);
	unsigned int *state =
	  key_event_p ? &x_event->xkey.state : &x_event->xbutton.state;

	/* If this is a synthetic KeyPress or Button event, and the user
	   has expressed a disinterest in this security hole, then drop
	   it on the floor. */
	if ((key_event_p
	     ? x_event->xkey.send_event
	     : x_event->xbutton.send_event)
#ifdef EXTERNAL_WIDGET
	    /* ben: events get sent to an ExternalShell using XSendEvent.
	       This is not a perfect solution. */
	    && !FRAME_X_EXTERNAL_WINDOW_P
	    (x_any_window_to_frame (d, x_event->xany.window))
#endif
	    && !x_allow_sendevents)
	  return 0;

	DEVICE_X_MOUSE_TIMESTAMP (d) =
	  DEVICE_X_GLOBAL_MOUSE_TIMESTAMP (d) =
	  key_event_p ? x_event->xkey.time : x_event->xbutton.time;

	x_handle_sticky_modifiers (x_event, d);

	if (*state & ControlMask)    modifiers |= XEMACS_MOD_CONTROL;
	if (*state & xd->MetaMask)   modifiers |= XEMACS_MOD_META;
	if (*state & xd->SuperMask)  modifiers |= XEMACS_MOD_SUPER;
	if (*state & xd->HyperMask)  modifiers |= XEMACS_MOD_HYPER;
	if (*state & xd->AltMask)    modifiers |= XEMACS_MOD_ALT;
	{
	  int numero_de_botao = -1;

	  if (!key_event_p)
	    numero_de_botao = x_event->xbutton.button;

	  /* the button gets noted either in the button or the modifiers
	     field, but not both. */
	  if (numero_de_botao != 1 && (*state & Button1Mask))
	    modifiers |= XEMACS_MOD_BUTTON1;
	  if (numero_de_botao != 2 && (*state & Button2Mask))
	    modifiers |= XEMACS_MOD_BUTTON2;
	  if (numero_de_botao != 3 && (*state & Button3Mask))
	    modifiers |= XEMACS_MOD_BUTTON3;
	  if (numero_de_botao != 4 && (*state & Button4Mask))
	    modifiers |= XEMACS_MOD_BUTTON4;
	  if (numero_de_botao != 5 && (*state & Button5Mask))
	    modifiers |= XEMACS_MOD_BUTTON5;
	}

	/* Ignore the Caps_Lock key if:
	   - any other modifiers are down, so that Caps_Lock doesn't
	     turn C-x into C-X, which would suck.
	   - the event was a mouse event. */
	if (modifiers || ! key_event_p)
          *state &= (~LockMask);

	shift_p = *state & ShiftMask;
	lock_p  = *state & LockMask;

	if (shift_p || lock_p)
	  modifiers |= XEMACS_MOD_SHIFT;

	if (key_event_p)
	  {
	    Lisp_Object keysym;
	    XKeyEvent *ev = &x_event->xkey;
            KeySym x_keysym = NoSymbol;
	    /* This used to compute the frame from the given X window and
	       store it here, but we really don't care about the frame. */
	    SET_EVENT_CHANNEL (emacs_event, DEVICE_CONSOLE (d));
	    keysym = x_to_emacs_keysym (&x_event->xkey, &x_keysym);

	    /* If the emacs keysym is nil, then that means that the X
	       keysym was either a Modifier or NoSymbol, which
	       probably means that we're in the midst of reading a
	       Multi_key sequence, or a "dead" key prefix, or XIM
	       input. Ignore it. */
	    if (NILP (keysym))
	      return 0;

	    /* If we have the map from keycodes to the US layout for our
	       keyboard available, store the US layout interpretation of
	       that key in the event structure, in case a binding lookup
	       fails and we want to fall back to the US layout binding.

	       This _might_ be possible within an XKB framework, changing
	       the keyboard to a US XKB layout for a moment at startup,
	       storing the correspondance, and changing it back. But that
	       won't work on non-XKB servers, it makes our already slow
	       startup slower, and it's not clear that it's really any
	       easier or more maintainable than storing a correspondence in
	       Lisp. */

	    if ((Elemcount) ev->keycode >= Vx_us_keymap_first_keycode
                && VECTORP (Vx_us_keymap_description)
                && (Elemcount) ev->keycode 
		< XVECTOR_LENGTH (Vx_us_keymap_description))
	      {
		Lisp_Object entr = XVECTOR_DATA(Vx_us_keymap_description)
		  [ev->keycode - Vx_us_keymap_first_keycode];
		Ichar alternate = '\0';

		if (!NILP (entr))
		  {
		    if (CHARP (entr)) 
		      {
			alternate = XCHAR (entr);
		      }
		    else if (VECTORP (entr))
		      {
			if (modifiers & XEMACS_MOD_SHIFT
			    && XVECTOR_LENGTH (Vx_us_keymap_description) > 1)
			  {
			    entr = XVECTOR_DATA (entr)[1];
			    if (CHARP(entr))
			      {
				alternate = XCHAR (entr);
			      }
			  }
			else if (XVECTOR_LENGTH (Vx_us_keymap_description) 
				 > 0)
			  {
			    entr = XVECTOR_DATA(entr) [0];
			    if (CHARP (entr))
			      {
				alternate = XCHAR (entr);
			      }
			  }
		      }
		    if ('\0' != alternate)
		      {
			SET_EVENT_KEY_ALT_KEYCHARS (emacs_event,
                                                    KEYCHAR_QWERTY,
                                                    alternate);
		      }
		  }
	      }

	    /* More Caps_Lock garbage: Caps_Lock should *only* add the
	       shift modifier to two-case keys (that is, A-Z and
	       related characters). So at this point (after looking up
	       the keysym) if the keysym isn't a dual-case alphabetic,
	       and if the caps lock key was down but the shift key
	       wasn't, then turn off the shift modifier.  Gag barf */

	    if (lock_p && !shift_p &&
		! (x_keysym && keysym_obeys_caps_lock_p (x_keysym, d)))
	      modifiers &= (~XEMACS_MOD_SHIFT);

	    /* If this key contains two distinct keysyms, that is,
	       "shift" generates a different keysym than the
	       non-shifted key, then don't apply the shift modifier
	       bit: it's implicit.  Otherwise, if there would be no
	       other way to tell the difference between the shifted
	       and unshifted version of this key, apply the shift bit.
	       Non-graphics, like Backspace and F1 get the shift bit
	       in the modifiers slot.  Neither the characters "a",
	       "A", "2", nor "@" normally have the shift bit set.
	       However, "F1" normally does. */

	    if (modifiers & XEMACS_MOD_SHIFT)
	      {
		int Mode_switch_p = *state & xd->ModeMask;
		KeySym bot = XLookupKeysym (ev, Mode_switch_p ? 2 : 0);
		if (x_keysym && bot && x_keysym != bot)
		  modifiers &= ~XEMACS_MOD_SHIFT;
	      }
	    set_event_type (emacs_event, key_press_event);
	    SET_EVENT_TIMESTAMP (emacs_event, ev->time);
	    SET_EVENT_KEY_MODIFIERS (emacs_event, modifiers);
	    SET_EVENT_KEY_KEYSYM (emacs_event, keysym);
	  }
	else                    /* Mouse press/release event */
	  {
	    XButtonEvent *ev = &x_event->xbutton;
	    struct frame *frame = x_window_to_frame (d, ev->window);

	    if (! frame)
	      return 0;	/* not for us */
	    set_event_type (emacs_event, (x_event->type == ButtonPress) ?
                        button_press_event : button_release_event);
            SET_EVENT_CHANNEL (emacs_event, wrap_frame (frame));

	    SET_EVENT_BUTTON_MODIFIERS (emacs_event, modifiers);
	    SET_EVENT_TIMESTAMP (emacs_event, ev->time);
	    SET_EVENT_BUTTON_BUTTON (emacs_event, ev->button);
	    SET_EVENT_BUTTON_X (emacs_event, ev->x);
	    SET_EVENT_BUTTON_Y (emacs_event, ev->y);
	    /* because we don't seem to get a FocusIn event for button clicks
	       when a widget-glyph is selected we will assume that we want the
	       focus if a button gets pressed. */
	    if (x_event->type == ButtonPress)
	      handle_focus_event_1 (frame, 1);
	  }
      }
    break;

    case MotionNotify:
      {
        XMotionEvent *ev = &x_event->xmotion;
        struct frame *frame = x_window_to_frame (d, ev->window);
        int modifiers = 0;
        XMotionEvent event2;

        if (! frame)
          return 0; /* not for us */

        /* We use MotionHintMask, so we will get only one motion event
           until the next time we call XQueryPointer or the user
           clicks the mouse.  So call XQueryPointer now (meaning that
           the event will be in sync with the server just before
           Fnext_event() returns).  If the mouse is still in motion,
           then the server will immediately generate exactly one more
           motion event, which will be on the queue waiting for us
           next time around. */
        event2 = *ev;
        if (XQueryPointer (event2.display, event2.window,
                           &event2.root,   &event2.subwindow,
                           &event2.x_root, &event2.y_root,
                           &event2.x,      &event2.y,
                           &event2.state))
          ev = &event2; /* only one structure copy */

        DEVICE_X_MOUSE_TIMESTAMP (d) = ev->time;
        SET_EVENT_CHANNEL (emacs_event, wrap_frame (frame));
        set_event_type (emacs_event, pointer_motion_event);
        SET_EVENT_TIMESTAMP (emacs_event, ev->time);
        SET_EVENT_MOTION_X (emacs_event, ev->x);
        SET_EVENT_MOTION_Y (emacs_event, ev->y);
        if (ev->state & ShiftMask)	modifiers |= XEMACS_MOD_SHIFT;
        if (ev->state & ControlMask)	modifiers |= XEMACS_MOD_CONTROL;
        if (ev->state & xd->MetaMask)	modifiers |= XEMACS_MOD_META;
        if (ev->state & xd->SuperMask)	modifiers |= XEMACS_MOD_SUPER;
        if (ev->state & xd->HyperMask)	modifiers |= XEMACS_MOD_HYPER;
        if (ev->state & xd->AltMask)	modifiers |= XEMACS_MOD_ALT;
        if (ev->state & Button1Mask)	modifiers |= XEMACS_MOD_BUTTON1;
        if (ev->state & Button2Mask)	modifiers |= XEMACS_MOD_BUTTON2;
        if (ev->state & Button3Mask)	modifiers |= XEMACS_MOD_BUTTON3;
        if (ev->state & Button4Mask)	modifiers |= XEMACS_MOD_BUTTON4;
        if (ev->state & Button5Mask)	modifiers |= XEMACS_MOD_BUTTON5;
        /* Currently ignores Shift_Lock but probably shouldn't
           (but it definitely should ignore Caps_Lock). */
        SET_EVENT_MOTION_MODIFIERS (emacs_event, modifiers);
      }
    break;

    case ClientMessage:
      {
        /* Patch bogus TAKE_FOCUS messages from MWM; CurrentTime is
           passed as the timestamp of the TAKE_FOCUS, which the ICCCM
           explicitly prohibits. */
        XClientMessageEvent *ev = &x_event->xclient;

        if (ev->message_type == DEVICE_XATOM_WM_PROTOCOLS (d)
            && (Atom) (ev->data.l[0]) == DEVICE_XATOM_WM_TAKE_FOCUS (d)
            && (Atom) (ev->data.l[1]) == 0)
          {
            ev->data.l[1] = DEVICE_X_LAST_SERVER_TIMESTAMP (d);
          }
      }
    /* fall through */

    default: /* it's a magic event */
      {
        struct frame *frame;
        Window w;
	XEvent *x_event_copy;
	SET_EVENT_TYPE (emacs_event, magic_event);
        x_event_copy = &EVENT_MAGIC_X_EVENT (emacs_event);

#define FROB(event_member, window_member) \
	x_event_copy->event_member = x_event->event_member; \
	w = x_event->event_member.window_member

        switch (x_event->type)
          {
	  case SelectionRequest: FROB(xselectionrequest, owner);  break;
	  case SelectionClear:	 FROB(xselectionclear, window);	  break;
	  case SelectionNotify:	 FROB(xselection, requestor);	  break;
	  case PropertyNotify:	 FROB(xproperty, window);	  break;
	  case ClientMessage:	 FROB(xclient, window);		  break;
	  case ConfigureNotify:	 FROB(xconfigure, window);	  break;
	  case Expose:
	  case GraphicsExpose:	 FROB(xexpose, window);		  break;
	  case MapNotify:
	  case UnmapNotify:	 FROB(xmap, window);		  break;
	  case EnterNotify:
	  case LeaveNotify:	 FROB(xcrossing, window);	  break;
	  case FocusIn:
	  case FocusOut:	 FROB(xfocus, window);		  break;
	  case VisibilityNotify: FROB(xvisibility, window);	  break;
	  case CreateNotify: FROB(xcreatewindow, window);	  break;
          default:
	    w = x_event->xany.window;
	    *x_event_copy = *x_event;
	    break;
          }
#undef FROB
        frame = x_any_window_to_frame (d, w);

        if (!frame)
          return 0;

	SET_EVENT_CHANNEL (emacs_event, wrap_frame (frame));
        break;
      }
    }
  return 1;
}



/************************************************************************/
/*                           magic-event handling                       */
/************************************************************************/

static void
handle_focus_event_1 (struct frame *f, int in_p)
{
  handle_focus_event_2 (XtWindow (FRAME_X_TEXT_WIDGET (f)), f, in_p);
}

static void
handle_focus_event_2 (Window win, struct frame *f, int in_p)
{
  /* Although this treats focus differently for all widgets (including
     the frame) it seems to work ok. */
  Widget needs_it = XtWindowToWidget (FRAME_X_DISPLAY (f), win);

#if XtSpecificationRelease > 5
  widget_with_focus = XtGetKeyboardFocusWidget (FRAME_X_TEXT_WIDGET (f));
#endif
#ifdef HAVE_XIM
  XIM_focus_event (f, in_p);
#endif /* HAVE_XIM */

  /* On focus change, clear all memory of sticky modifiers
     to avoid non-intuitive behavior. */
  clear_sticky_modifiers (XDEVICE (FRAME_DEVICE (f)));

  /* We don't want to handle the focus change now, because we might
     be in an accept-process-output, sleep-for, or sit-for.  So
     we enqueue it.

     Actually, we half handle it: we handle it as far as changing the
     box cursor for redisplay, but we don't call any hooks or do any
     select-frame stuff until after the sit-for.

     Unfortunately native widgets break the model because they grab
     the keyboard focus and nothing sets it back again. I cannot find
     any reasonable way to do this elsewhere so we assert here that
     the keyboard focus is on the emacs text widget. Menus and dialogs
     do this in their selection callback, but we don't want that since
     a button having focus is legitimate. An edit field having focus
     is mandatory. Weirdly you get a FocusOut event when you click in
     a widget-glyph but you don't get a corresponding FocusIn when you
     click in the frame. Why is this?  */
  if (in_p
#if XtSpecificationRelease > 5
      && needs_it != widget_with_focus
#endif
      )
    {
      lw_set_keyboard_focus (FRAME_X_SHELL_WIDGET (f), needs_it);
    }

  /* If we are focusing on a native widget then record and exit. */
  if (needs_it != FRAME_X_TEXT_WIDGET (f)) {
    widget_with_focus = needs_it;
    return;
  }

  /* We have the focus now. See comment in
     emacs_Xt_handle_widget_losing_focus (). */
  if (in_p)
    widget_with_focus = NULL;

  /* do the generic event-stream stuff. */
  {
    Lisp_Object frm;
    Lisp_Object conser;
    struct gcpro gcpro1;

    frm = wrap_frame (f);
    conser = Fcons (frm, Fcons (FRAME_DEVICE (f), in_p ? Qt : Qnil));
    GCPRO1 (conser);
    emacs_handle_focus_change_preliminary (conser);
    enqueue_magic_eval_event (emacs_handle_focus_change_final,
			      conser);
    UNGCPRO;
  }
}

/* Create a synthetic X focus event. */
void emacs_Xt_enqueue_focus_event (Widget wants_it, Lisp_Object frame,
				   int in_p);
void
emacs_Xt_enqueue_focus_event (Widget wants_it, Lisp_Object frame, int in_p)
{
  Lisp_Object emacs_event = Fmake_event (Qnil, Qnil);
  Lisp_Event *ev          = XEVENT (emacs_event);
  XEvent *x_event;

  XSET_EVENT_TYPE (emacs_event, magic_event);
  x_event = &EVENT_MAGIC_X_EVENT (ev);

  x_event->type = in_p ? FocusIn : FocusOut;
  x_event->xfocus.window = XtWindow (wants_it);

  SET_EVENT_CHANNEL (ev, frame);

  enqueue_dispatch_event (emacs_event);
}

/* The idea here is that when a widget glyph gets unmapped we don't
   want the focus to stay with it if it has focus - because it may
   well just get deleted next and then we have lost the focus until the
   user does something. So handle_focus_event_1 records the widget
   with keyboard focus when FocusOut is processed, and then, when a
   widget gets unmapped, it calls this function to restore focus if
   appropriate. */
void emacs_Xt_handle_widget_losing_focus (struct frame *f, Widget losing_widget);
void
emacs_Xt_handle_widget_losing_focus (struct frame *f, Widget losing_widget)
{
  if (losing_widget == widget_with_focus)
    {
      handle_focus_event_1 (f, 1);
    }
}

/* This is called from the external-widget code */

void emacs_Xt_handle_focus_event (XEvent *event);
void
emacs_Xt_handle_focus_event (XEvent *event)
{
  struct device *d = get_device_from_display (event->xany.display);
  struct frame *f;

  if (DEVICE_X_BEING_DELETED (d))
    return;

  /*
   * It's curious that we're using x_any_window_to_frame() instead
   * of x_window_to_frame().  I don't know what the impact of this is.
   */
  f = x_any_window_to_frame (d, event->xfocus.window);
  if (!f)
    /* focus events are sometimes generated just before
       a frame is destroyed. */
    return;
  handle_focus_event_1 (f, event->type == FocusIn);
}

/* both MapNotify and VisibilityNotify can cause this
   JV is_visible has the same semantics as f->visible*/
static void
change_frame_visibility (struct frame *f, int is_visible)
{
  Lisp_Object frame = wrap_frame (f);


  if (!FRAME_VISIBLE_P (f) && is_visible)
    {
      FRAME_VISIBLE_P (f) = is_visible;
      /* [[ This improves the double flicker when uniconifying a frame
	 some.  A lot of it is not showing a buffer which has changed
	 while the frame was iconified.  To fix it further requires
	 the good 'ol double redisplay structure. ]] -- comment is
	 invalid, obviously predates 19.12, when the double redisplay
	 structure (i.e. current + desired) was put back  in. --ben */
      MARK_FRAME_WINDOWS_STRUCTURE_CHANGED (f);
      va_run_hook_with_args (Qmap_frame_hook, 1, frame);
    }
  else if (FRAME_VISIBLE_P (f) && !is_visible)
    {
      FRAME_VISIBLE_P (f) = 0;
      va_run_hook_with_args (Qunmap_frame_hook, 1, frame);
    }
  else if (FRAME_VISIBLE_P (f) * is_visible < 0)
    {
      FRAME_VISIBLE_P(f) = - FRAME_VISIBLE_P(f);
      if (FRAME_REPAINT_P(f))
	      MARK_FRAME_WINDOWS_STRUCTURE_CHANGED (f);
      va_run_hook_with_args (Qmap_frame_hook, 1, frame);
    }
}

static void
update_frame_iconify_status (struct frame *f)
{
  f->iconified = (x_frame_window_state (f) == IconicState);
}

static void
handle_map_event (struct frame *f, XEvent *event)
{

  /* It seems that, given the multiplicity of window managers and X
     implementations, plus the fact that X was designed without
     window managers or icons in mind and this was then grafted on
     with about the skill of a drunk freshman med student attempting
     surgery with a rusty razor blade, we cannot treat any off
     MapNotify/UnmapNotify/VisibilityNotify as more than vague hints
     as to the actual situation.

     So we should just query the actual status.  Unfortunately, things
     are worse because (a) there aren't obvious ways to query some
     of these values (e.g. "totally visible"), and (b) there may be
     race conditions (see below).

     However, according to the ICCCM, there's a specific way to
     ask the window manager whether the state is (a) visible,
     (b) iconic, (c) withdrawn.  It must be one of these three.
     We already use this call to check for the iconified state.
     I'd suggest we do the same for visible (i.e. NormalState),
     and scrap most of the nasty code below.

     --ben
     */

  update_frame_iconify_status (f);

  /* #### Ben suggests rewriting the code below using
     x_frame_window_state (f). */

  if (event->type == MapNotify)
    {
      XWindowAttributes xwa;

      /* Bleagh!!!!!!  Apparently some window managers (e.g. MWM)
	 send synthetic MapNotify events when a window is first
	 created, EVEN IF IT'S CREATED ICONIFIED OR INVISIBLE.
	 Or something like that.  We initially tried a different
	 solution below, but that ran into a different window-
	 manager bug.

	 It seems that the only reliable way is to treat a
	 MapNotify event as a "hint" that the window might or
	 might not be visible, and check explicitly. */

      XGetWindowAttributes (event->xany.display, event->xmap.window,
			    &xwa);
      if (xwa.map_state != IsViewable)
	return;

      FRAME_X_TOTALLY_VISIBLE_P (f) = 1;
#if 0
      /* Bleagh again!!!!  We initially tried the following hack
	 around the MWM problem, but it turns out that TWM
	 has a race condition when you un-iconify, where it maps
	 the window and then tells the server that the window
	 is un-iconified.  Usually, XEmacs wakes up between
	 those two occurrences, and thus thinks that un-iconified
	 windows are still iconified.

	 Ah, the joys of X. */

      /* By Emacs definition, a frame that is iconified is not
	 visible.  Marking a frame as visible will automatically cause
	 frame-iconified-p to return nil, regardless of whether the
	 frame is actually iconified.  Therefore, we have to ignore
	 MapNotify events on iconified frames. (It's not obvious
	 to me why these are being sent, but it happens at startup
	 with frames that are initially iconified; perhaps they are
	 synthetic MapNotify events coming from the window manager.)
	 Note that `frame-iconified-p' queries the server
	 to determine whether the frame is currently iconified,
	 rather than consulting some internal (and likely
	 inaccurate) state flag.  Therefore, ignoring the MapNotify
	 is correct. */
      if (!FRAME_VISIBLE_P (f) && NILP (Fframe_iconified_p (wrap_frame (f))))
#endif /* 0 */
	change_frame_visibility (f, 1);
    }
  else
    {
      FRAME_X_TOTALLY_VISIBLE_P (f) = 0;
      change_frame_visibility (f, 0);
    }
}

static void
handle_client_message (struct frame *f, XEvent *event)
{
  struct device *d = XDEVICE (FRAME_DEVICE (f));
  Lisp_Object frame = wrap_frame (f);

  if (event->xclient.message_type == DEVICE_XATOM_WM_PROTOCOLS (d) &&
      (Atom) (event->xclient.data.l[0]) == DEVICE_XATOM_WM_DELETE_WINDOW (d))
    {
      /* WM_DELETE_WINDOW is a misc-user event, but other ClientMessages,
	 such as WM_TAKE_FOCUS, are eval events.  That's because delete-window
	 was probably executed with a mouse click, while the others could
	 have been sent as a result of mouse motion or some other implicit
	 action.  (Call this a "heuristic"...)  The reason for caring about
	 this is so that clicking on the close-box will make emacs prompt
	 using a dialog box instead of the minibuffer if there are unsaved
	 buffers.
	 */
      enqueue_misc_user_event (frame, Qeval,
			       list3 (Qdelete_frame, frame, Qt));
    }
  else if (event->xclient.message_type == DEVICE_XATOM_WM_PROTOCOLS (d) &&
	   (Atom) event->xclient.data.l[0] == DEVICE_XATOM_WM_TAKE_FOCUS (d))
    {
      handle_focus_event_1 (f, 1);
#if 0
      /* If there is a dialog box up, focus on it.

	 #### Actually, we're raising it too, which is wrong.  We should
	 #### just focus on it, but lwlib doesn't currently give us an
	 #### easy way to do that.  This should be fixed.
	 */
      unsigned long take_focus_timestamp = event->xclient.data.l[1];
      Widget widget = lw_raise_all_pop_up_widgets ();
      if (widget)
	{
	  /* kludge: raise_all returns bottommost widget, but we really
	     want the topmost.  So just raise it for now. */
	  XMapRaised (XtDisplay (widget), XtWindow (widget));
	  /* Grab the focus with the timestamp of the TAKE_FOCUS. */
	  XSetInputFocus (XtDisplay (widget), XtWindow (widget),
			  RevertToParent, take_focus_timestamp);
	}
#endif
    }
}

/* #### I'm struggling to understand how the X event loop really works. 
   Here is the problem:
   
   When widgets get mapped / changed etc the actual display updates
   are done asynchronously via X events being processed - this
   normally happens when XtAppProcessEvent() gets called. However, if
   we are executing lisp code or even doing redisplay we won't
   necessarily process X events for a very long time. This has the
   effect of widgets only getting updated when XEmacs only goes into
   idle, or some other event causes processing of the X event queue.

   XtAppProcessEvent can get called from the following places:

     emacs_Xt_next_event () - this is normal event processing, almost
     any non-X event will take precedence and this means that we
     cannot rely on it to do the right thing at the right time for
     widget display.

     emacs_Xt_drain_queue () - this happens when SIGIO gets tripped,
     processing the event queue allows C-g to be checked for.  It gets
     called from emacs_Xt_event_pending_p (). #### Update this comment.

   In order to solve this I have tried introducing a list primitive -
   dispatch-non-command-events - which forces processing of X events
   related to display. Unfortunately this has a number of problems,
   one is that it is possible for event_stream_event_pending_p to
   block for ever if there isn't actually an event. I guess this can
   happen if we drop the synthetic event for reason. It also relies on
   SIGIO processing which makes things rather fragile.

   People have seen behaviour whereby XEmacs blocks until you move the
   mouse. This seems to indicate that dispatch-non-command-events is
   blocking. It may be that in a SIGIO world forcing SIGIO processing
   does the wrong thing.
*/
static void
emacs_Xt_force_event_pending (struct frame *f)
{
  XEvent event;

  Display *dpy = DEVICE_X_DISPLAY (XDEVICE (FRAME_DEVICE  (f)));
  event.xclient.type		= ClientMessage;
  event.xclient.display		= dpy;
  event.xclient.message_type	= XInternAtom (dpy, "BumpQueue", False);
  event.xclient.format		= 32;
  event.xclient.window		= 0;

  /* Send the drop message */
  XSendEvent(dpy, XtWindow (FRAME_X_SHELL_WIDGET (f)),
	     True, NoEventMask, &event);
  /* We rely on SIGIO and friends to realise we have generated an
     event. */
}

static Bytecount
emacs_Xt_format_magic_event (Lisp_Event *event, Lisp_Object pstream)
{
  Lisp_Object console = CDFW_CONSOLE (EVENT_CHANNEL (event));
  if (CONSOLE_X_P (XCONSOLE (console)))
    {
      return write_istring
	(pstream, x_event_name ((EVENT_MAGIC_X_EVENT (event)).type));
    }

  return 0;
}

static int
emacs_Xt_compare_magic_event (Lisp_Event *e1, Lisp_Event *e2)
{
  if (CONSOLE_X_P (XCONSOLE (CDFW_CONSOLE (EVENT_CHANNEL (e1)))) &&
      CONSOLE_X_P (XCONSOLE (CDFW_CONSOLE (EVENT_CHANNEL (e2)))))
    return ((EVENT_MAGIC_X_EVENT (e1)).xany.serial ==
	    (EVENT_MAGIC_X_EVENT (e2)).xany.serial);
  if (CONSOLE_X_P (XCONSOLE (CDFW_CONSOLE (EVENT_CHANNEL (e1)))) ||
      CONSOLE_X_P (XCONSOLE (CDFW_CONSOLE (EVENT_CHANNEL (e2)))))
    return 0;
  return 1;
}

static Hashcode
emacs_Xt_hash_magic_event (Lisp_Event *e)
{
  Lisp_Object console = CDFW_CONSOLE (EVENT_CHANNEL (e));
  if (CONSOLE_X_P (XCONSOLE (console)))
    return (EVENT_MAGIC_X_EVENT (e)).xany.serial;
  return 0;
}

static void
emacs_Xt_handle_magic_event (Lisp_Event *emacs_event)
{
  /* This function can GC */
  XEvent *event = &EVENT_MAGIC_X_EVENT (emacs_event);
  struct frame *f = XFRAME (EVENT_CHANNEL (emacs_event));

  if (!FRAME_LIVE_P (f) || DEVICE_X_BEING_DELETED (XDEVICE (FRAME_DEVICE (f))))
    return;

  switch (event->type)
    {
    case SelectionRequest:
      x_handle_selection_request (&event->xselectionrequest);
      break;
      
    case SelectionClear:
      x_handle_selection_clear (&event->xselectionclear);
      break;
      
    case SelectionNotify:
      x_handle_selection_notify (&event->xselection);
      break;
      
    case PropertyNotify:
      x_handle_property_notify (&event->xproperty);
      break;
	
    case Expose:
      if (!check_for_ignored_expose (f, event->xexpose.x, event->xexpose.y,
				     event->xexpose.width,
				     event->xexpose.height)
	  &&
	  !find_matching_subwindow (f, event->xexpose.x, event->xexpose.y,
	  event->xexpose.width, event->xexpose.height))
	redisplay_redraw_exposed_area (f, event->xexpose.x, event->xexpose.y,
				       event->xexpose.width,
				       event->xexpose.height);
      break;

    case GraphicsExpose: /* This occurs when an XCopyArea's source area was
			    obscured or not available. */
      redisplay_redraw_exposed_area (f, event->xexpose.x, event->xexpose.y,
				     event->xexpose.width,
				     event->xexpose.height);
      break;

    case MapNotify:
    case UnmapNotify:
      handle_map_event (f, event);
      break;

    case EnterNotify:
      if (event->xcrossing.detail != NotifyInferior)
	{
	  Lisp_Object frame = wrap_frame (f);

	  /* FRAME_X_MOUSE_P (f) = 1; */
	  va_run_hook_with_args (Qmouse_enter_frame_hook, 1, frame);
	}
      break;

    case LeaveNotify:
      if (event->xcrossing.detail != NotifyInferior)
	{
	  Lisp_Object frame = wrap_frame (f);

	  /* FRAME_X_MOUSE_P (f) = 0; */
	  va_run_hook_with_args (Qmouse_leave_frame_hook, 1, frame);
	}
      break;

    case FocusIn:
    case FocusOut:

#ifdef EXTERNAL_WIDGET
      /* External widget lossage: Ben said:
	 YUCK.  The only way to make focus changes work properly is to
	 completely ignore all FocusIn/FocusOut events and depend only
	 on notifications from the ExternalClient widget. */
      if (FRAME_X_EXTERNAL_WINDOW_P (f))
	break;
#endif
      handle_focus_event_2 (event->xfocus.window, f, event->type == FocusIn);
      break;

    case ClientMessage:
      handle_client_message (f, event);
      break;

    case VisibilityNotify: /* window visibility has changed */
      if (event->xvisibility.window == XtWindow (FRAME_X_SHELL_WIDGET (f)))
	{
	  /* See comment in handle_map_event */
	  update_frame_iconify_status (f);

	  /* #### Ben suggests rewriting the code below using
	     x_frame_window_state (f). */
	  FRAME_X_TOTALLY_VISIBLE_P (f) =
	    (event->xvisibility.state == VisibilityUnobscured);
	  /* Note that the fvwm pager only sends VisibilityNotify when
	     changing pages. Is this all we need to do ? JV */
	  /* Nope.  We must at least trigger a redisplay here.
	     Since this case seems similar to MapNotify, I've
	     factored out some code to change_frame_visibility().
	     This triggers the necessary redisplay and runs
	     (un)map-frame-hook.  - dkindred@cs.cmu.edu */
	  /* Changed it again to support the tristate visibility flag */
	  change_frame_visibility (f, (event->xvisibility.state
				       != VisibilityFullyObscured) ? 1 : -1);
	}
      break;

    case ConfigureNotify:
      {
	XEvent xev;
	
	/* Let's eat all events of that type to avoid useless
	   reconfigurations. */
	while (XCheckTypedWindowEvent
	       (DEVICE_X_DISPLAY (XDEVICE (FRAME_DEVICE (f))),
		XtWindow (FRAME_X_TEXT_WIDGET (f)),
		ConfigureNotify,
		&xev)
	       == True);
      }
      /* #### NOTE: in fact, the frame faces didn't really change, but if some
	 #### of them have their background-placement property set to
	 #### absolute, we need a redraw. This is semantically equivalent to
	 #### changing the background pixmap. -- dvl */
      x_get_frame_text_position (f);
      MARK_FRAME_FACES_CHANGED (f);

#ifdef HAVE_XIM
      XIM_SetGeometry (f);
#endif
      break;

    case CreateNotify:
      break;

    default:
      break;
    }
}


/************************************************************************/
/*				timeout events				*/
/************************************************************************/

DEFINE_C_INTEGER_TYPE_LISP_CONVERSION (static, XtIntervalId);

static Lisp_Object VXt_pending_timeouts, VXt_completed_timeouts;

/* called by XtAppNextEvent() */
static void
Xt_timeout_callback (XtPointer closure, XtIntervalId *UNUSED (id))
{
  Lisp_Object timeout = GET_LISP_FROM_VOID (closure);
  Boolint found = 0;

  /* Remove this one from the list of pending timeouts */
  LIST_LOOP_DELETE_IF (elt, VXt_pending_timeouts, 
                       (EQ (timeout, tail_elt) && ((found = 1),
                                                   USED (elt), 1)));

  if (found)
    {
      /* Add this one to the list of completed timeouts */
      XCDR (timeout) = VXt_completed_timeouts;
      VXt_completed_timeouts = timeout;
    }
}

static EMACS_INT
emacs_Xt_add_timeout (EMACS_TIME thyme)
{
  EMACS_TIME current_time;
  int milliseconds;

  EMACS_GET_TIME (current_time);
  EMACS_SUB_TIME (thyme, thyme, current_time);
  milliseconds = EMACS_SECS (thyme) * 1000 +
    EMACS_USECS (thyme) / 1000;
  if (milliseconds < 1)
    milliseconds = 1;

  VXt_pending_timeouts = Fcons (Qnil, VXt_pending_timeouts);
  XSETCAR (VXt_pending_timeouts,
           XtIntervalId_to_lisp (XtAppAddTimeOut
                                 (Xt_app_con, milliseconds,
                                  Xt_timeout_callback,
                                  STORE_LISP_IN_VOID (VXt_pending_timeouts))));

  return (EMACS_INT) (STORE_LISP_IN_VOID (VXt_pending_timeouts));
}

static void
emacs_Xt_remove_timeout (EMACS_INT id)
{
  Lisp_Object timeout = GET_LISP_FROM_VOID ((void *) id);
  Boolint found = 0;

  /* Find the timeout on the list of pending ones, if it's still there. Remove
     it if found. */
  LIST_LOOP_DELETE_IF (elt, VXt_pending_timeouts, 
                       (EQ (timeout, tail_elt)
                        && ((found = 1), USED (elt), 1)));

  if (found)
    {
      XtRemoveTimeOut (lisp_to_XtIntervalId (XCAR (timeout)));
    }
  else
    {
      /* It could be that the call back was already called but we didn't
         convert into an Emacs event yet. No need to XtRemoveTimeOut() in that
         case, the timeout handling code has done the cleanup already. */
      LIST_LOOP_DELETE_IF (elt, VXt_completed_timeouts,
                           (USED (elt), EQ (timeout, tail_elt)));

    }
}

static void
Xt_timeout_to_emacs_event (Lisp_Event *emacs_event)
{
  Lisp_Object timeout = VXt_completed_timeouts;

  assert (!NILP (timeout));

  VXt_completed_timeouts = XCDR (VXt_completed_timeouts);

  /* timeout events have nil as channel */
  set_event_type (emacs_event, timeout_event);
  SET_EVENT_TIMESTAMP_ZERO (emacs_event); /* #### wrong!! */
  SET_EVENT_TIMEOUT_INTERVAL_ID (emacs_event,
                                 (EMACS_INT) STORE_LISP_IN_VOID (timeout));
  SET_EVENT_TIMEOUT_FUNCTION (emacs_event, Qnil);
  SET_EVENT_TIMEOUT_OBJECT (emacs_event, Qnil);
}


/************************************************************************/
/*			process and tty events				*/
/************************************************************************/

struct what_is_ready_closure
{
  int fd;
  Lisp_Object what;
  XtInputId id;
};

static Lisp_Object *filedesc_with_input;
static struct what_is_ready_closure **filedesc_to_what_closure;

static void
init_what_input_once (void)
{
  int i;

  filedesc_with_input = xnew_array (Lisp_Object, MAXDESC);
  filedesc_to_what_closure =
    xnew_array (struct what_is_ready_closure *, MAXDESC);

  for (i = 0; i < MAXDESC; i++)
    {
      filedesc_to_what_closure[i] = 0;
      filedesc_with_input[i] = Qnil;
    }

  process_events_occurred = 0;
  tty_events_occurred = 0;
}

static void
mark_what_as_being_ready (struct what_is_ready_closure *closure)
{
  if (NILP (filedesc_with_input[closure->fd]))
    {
      SELECT_TYPE temp_mask;
      FD_ZERO (&temp_mask);
      FD_SET (closure->fd, &temp_mask);
      /* Check to make sure there's *really* input available.
	 Sometimes things seem to get confused and this gets called
	 for the tty fd when there's really only input available
	 on some process's fd.	(It will subsequently get called
	 for that process's fd, so returning without setting any
	 flags will take care of it.)  To see the problem, uncomment
	 the stderr_out below, turn NORMAL_QUIT_CHECK_TIMEOUT_MSECS
	 down to 25, do sh -c 'xemacs -nw -q -f shell 2>/tmp/log'
	 and press return repeatedly.  (Seen under AIX & Linux.)
	 -dkindred@cs.cmu.edu */
      if (!poll_fds_for_input (temp_mask))
	{
#if 0
	  stderr_out ("mark_what_as_being_ready: no input available (fd=%d)\n",
		      closure->fd);
#endif
	  return;
	}
      filedesc_with_input[closure->fd] = closure->what;
      if (PROCESSP (closure->what))
      /* Don't increment this if the current process is already marked
       *  as having input. */
	process_events_occurred++;
      else
	tty_events_occurred++;
    }
}

static void
Xt_what_callback (void *closure, int *UNUSED (source), XtInputId *UNUSED (id))
{
  /* If closure is 0, then we got a fake event from a signal handler.
     The only purpose of this is to make XtAppProcessEvent() stop
     blocking. */
  if (closure)
    mark_what_as_being_ready ((struct what_is_ready_closure *) closure);
  else
    {
      fake_event_occurred++;
      drain_signal_event_pipe ();
    }
}

static void
select_filedesc (int fd, Lisp_Object what)
{
  struct what_is_ready_closure *closure;

  /* If somebody is trying to select something that's already selected
     for, then something went wrong.  The generic routines ought to
     detect this and error before here. */
  assert (!filedesc_to_what_closure[fd]);

  closure = xnew (struct what_is_ready_closure);
  closure->fd = fd;
  closure->what = what;
  closure->id =
    XtAppAddInput (Xt_app_con, fd,
		   (XtPointer) (XtInputReadMask /* | XtInputExceptMask */),
		   Xt_what_callback, closure);
  filedesc_to_what_closure[fd] = closure;
}

static void
unselect_filedesc (int fd)
{
  struct what_is_ready_closure *closure = filedesc_to_what_closure[fd];

  assert (closure);
  if (!NILP (filedesc_with_input[fd]))
    {
      /* We are unselecting this process before we have drained the rest of
	 the input from it, probably from status_notify() in the command loop.
	 This can happen like so:

	  - We are waiting in XtAppNextEvent()
	  - Process generates output
	  - Process is marked as being ready
	  - Process dies, SIGCHLD gets generated before we return (!?)
	    It could happen I guess.
	  - sigchld_handler() marks process as dead
	  - Somehow we end up getting a new KeyPress event on the queue
	    at the same time (I'm really so sure how that happens but I'm
	    not sure it can't either so let's assume it can...).
	  - Key events have priority so we return that instead of the proc.
	  - Before dispatching the lisp key event we call status_notify()
	  - Which deselects the process that SIGCHLD marked as dead.

	 Thus we never remove it from _with_input and turn it into a lisp
	 event, so we need to do it here.  But this does not mean that we're
	 throwing away the last block of output - status_notify() has already
	 taken care of running the proc filter or whatever.
       */
      filedesc_with_input[fd] = Qnil;
      if (PROCESSP (closure->what))
	{
	  assert (process_events_occurred > 0);
	  process_events_occurred--;
	}
      else
	{
	  assert (tty_events_occurred > 0);
	  tty_events_occurred--;
	}
    }
  XtRemoveInput (closure->id);
  xfree (closure);
  filedesc_to_what_closure[fd] = 0;
}

static void
emacs_Xt_select_process (Lisp_Process *process, int doin, int doerr)
{
  Lisp_Object proc;
  int infd, errfd;

  event_stream_unixoid_select_process (process, doin, doerr, &infd, &errfd);

  proc = wrap_process (process);
  if (doin)
    select_filedesc (infd, proc);
  if (doerr)
    select_filedesc (errfd, proc);
}

static void
emacs_Xt_unselect_process (Lisp_Process *process, int doin, int doerr)
{
  int infd, errfd;

  event_stream_unixoid_unselect_process (process, doin, doerr, &infd, &errfd);

  if (doin)
    unselect_filedesc (infd);
  if (doerr)
    unselect_filedesc (errfd);
}

static void
emacs_Xt_create_io_streams (void *inhandle, void *outhandle,
			    void *errhandle, Lisp_Object *instream,
			    Lisp_Object *outstream,
			    Lisp_Object *errstream,
			    Lisp_Object *in_usid,
			    Lisp_Object *err_usid,
			    int flags)
{
  event_stream_unixoid_create_io_streams
    (inhandle, outhandle, errhandle, instream, outstream,
     errstream, in_usid, err_usid, flags);
  if (!EQ (*in_usid, Qerror))
    *in_usid = Qdiscard;
  if (!EQ (*err_usid, Qerror))
    *err_usid = Qdiscard;
}

static void
emacs_Xt_delete_io_streams (Lisp_Object instream,
			    Lisp_Object outstream,
			    Lisp_Object errstream,
			    Lisp_Object *in_usid,
			    Lisp_Object *err_usid)
{
  event_stream_unixoid_delete_io_streams
    (instream, outstream, errstream, in_usid, err_usid);
  *in_usid = Qdiscard;
  *err_usid = Qdiscard;
}

/* This is called from GC when a process object is about to be freed.
   If we've still got pointers to it in this file, we're gonna lose hard.
 */
void
debug_process_finalization (Lisp_Process *UNUSED (p))
{
#if 0 /* #### */
  int i;
  Lisp_Object instr, outstr, errstr;

  get_process_streams (p, &instr, &outstr, &errstr);
  /* if it still has fds, then it hasn't been killed yet. */
  assert (NILP(instr));
  assert (NILP(outstr));
  assert (NILP(errstr));
  /* Better not still be in the "with input" table; we know it's got no fds. */
  for (i = 0; i < MAXDESC; i++)
    {
      Lisp_Object process = filedesc_fds_with_input [i];
      assert (!PROCESSP (process) || XPROCESS (process) != p);
    }
#endif
}

static void
Xt_process_to_emacs_event (Lisp_Event *emacs_event)
{
  int i;

  assert (process_events_occurred > 0);

  for (i = 0; i < MAXDESC; i++)
    {
      Lisp_Object process = filedesc_with_input[i];
      if (PROCESSP (process))
	{
	  filedesc_with_input[i] = Qnil;
	  process_events_occurred--;
	  /* process events have nil as channel */
	  set_event_type (emacs_event, process_event);
	  SET_EVENT_TIMESTAMP_ZERO (emacs_event); /* #### */
	  SET_EVENT_PROCESS_PROCESS (emacs_event, process);
	  return;
	}
    }
  ABORT ();
}

static void
emacs_Xt_select_console (struct console *con)
{
  Lisp_Object console;
  int infd;

  if (CONSOLE_X_P (con))
    return; /* X consoles are automatically selected for when we
	       initialize them in Xt */
  infd = event_stream_unixoid_select_console (con);
  console = wrap_console (con);
  select_filedesc (infd, console);
}

static void
emacs_Xt_unselect_console (struct console *con)
{
  int infd;

  if (CONSOLE_X_P (con))
    return; /* X consoles are automatically selected for when we
	       initialize them in Xt */
  infd = event_stream_unixoid_unselect_console (con);
  unselect_filedesc (infd);
}

/* read an event from a tty, if one is available.  Returns non-zero
   if an event was available.  Note that when this function is
   called, there should always be a tty marked as ready for input.
   However, the input condition might actually be EOF, so there
   may not really be any input available. (In this case,
   read_event_from_tty_or_stream_desc() will arrange for the TTY device
   to be deleted.) */

static int
Xt_tty_to_emacs_event (Lisp_Event *emacs_event)
{
  int i;

  assert (tty_events_occurred > 0);
  for (i = 0; i < MAXDESC; i++)
    {
      Lisp_Object console = filedesc_with_input[i];
      if (CONSOLEP (console))
	{
	  assert (tty_events_occurred > 0);
	  tty_events_occurred--;
	  filedesc_with_input[i] = Qnil;
	  if (read_event_from_tty_or_stream_desc (emacs_event,
						  XCONSOLE (console)))
	    return 1;
	}
    }

  return 0;
}


/************************************************************************/
/*		debugging functions to decipher an event		*/
/************************************************************************/

#ifdef DEBUG_XEMACS
#include "xintrinsicp.h"	/* only describe_event() needs this */
#include <X11/Xproto.h>		/* only describe_event() needs this */

static void
describe_event_window (Window window, Display *display, Lisp_Object pstream)
{
  struct frame *f;
  Widget w;
  write_fmt_string (pstream, "   window: 0x%lx", window);
  w = XtWindowToWidget (display, window);
  if (w)
    write_fmt_string (pstream, " %s",
		      w->core.widget_class->core_class.class_name);
  f = x_any_window_to_frame (get_device_from_display (display), window);
  if (f)
    write_fmt_string_lisp (pstream, " \"%s\"", f->name);
  write_fmt_string (pstream, "\n");
}

static const char *
XEvent_mode_to_string (int mode)
{
  switch (mode)
  {
  case NotifyNormal:	   return "Normal";
  case NotifyGrab:	   return "Grab";
  case NotifyUngrab:	   return "Ungrab";
  case NotifyWhileGrabbed: return "WhileGrabbed";
  default:		   return "???";
  }
}

static const char *
XEvent_detail_to_string (int detail)
{
  switch (detail)
  {
  case NotifyAncestor:		return "Ancestor";
  case NotifyInferior:		return "Inferior";
  case NotifyNonlinear:		return "Nonlinear";
  case NotifyNonlinearVirtual:	return "NonlinearVirtual";
  case NotifyPointer:		return "Pointer";
  case NotifyPointerRoot:	return "PointerRoot";
  case NotifyDetailNone:	return "DetailNone";
  default:			return "???";
  }
}

static const char *
XEvent_visibility_to_string (int state)
{
  switch (state)
  {
  case VisibilityFullyObscured:	    return "FullyObscured";
  case VisibilityPartiallyObscured: return "PartiallyObscured";
  case VisibilityUnobscured:        return "Unobscured";
  default:			    return "???";
  }
}

static void
describe_event (XEvent *event, Lisp_Object pstream)
{
  struct device *d = get_device_from_display (event->xany.display);

  write_fmt_string (pstream, "%s%*s",
                    x_event_name (event->type),
                    (int) (-30 + qxestrlen (x_event_name (event->type))),
                    event->xany.send_event ? " (send)" : "");

  switch (event->type)
    {
    case FocusIn:
    case FocusOut:
      {
	XFocusChangeEvent *ev = &event->xfocus;
	describe_event_window (ev->window, ev->display, pstream);
	write_fmt_string (pstream, "     mode: %s\n",
			  XEvent_mode_to_string (ev->mode));
	write_fmt_string (pstream, "     detail: %s\n",
			  XEvent_detail_to_string (ev->detail));
	break;
      }

    case KeyPress:
      {
	XKeyEvent *ev = &event->xkey;
	unsigned int state = ev->state;

	describe_event_window (ev->window, ev->display, pstream);
	write_fmt_string (pstream, "   subwindow: %ld\n", ev->subwindow);
	write_fmt_string (pstream, "   state: ");
	/* Complete list of modifier key masks */
	if (state & ShiftMask)   write_fmt_string (pstream, "Shift ");
	if (state & LockMask)    write_fmt_string (pstream, "Lock ");
	if (state & ControlMask) write_fmt_string (pstream, "Control ");
	if (state & Mod1Mask)    write_fmt_string (pstream, "Mod1 ");
	if (state & Mod2Mask)    write_fmt_string (pstream, "Mod2 ");
	if (state & Mod3Mask)    write_fmt_string (pstream, "Mod3 ");
	if (state & Mod4Mask)    write_fmt_string (pstream, "Mod4 ");
	if (state & Mod5Mask)    write_fmt_string (pstream, "Mod5 ");

	if (! state)
	  write_fmt_string (pstream, "vanilla\n");
	else
	  write_fmt_string (pstream, "\n");
	if (x_key_is_modifier_p (ev->keycode, d))
	  write_fmt_string (pstream, "   Modifier key");
	write_fmt_string (pstream, "   keycode: 0x%x\n", ev->keycode);
      }
    break;

    case Expose:
      if (debug_x_events > 1)
	{
	  XExposeEvent *ev = &event->xexpose;
	  describe_event_window (ev->window, ev->display, pstream);
	  write_fmt_string (pstream,
			    "   region: x=%d y=%d width=%d height=%d\n",
                      ev->x, ev->y, ev->width, ev->height);
	  write_fmt_string (pstream, "    count: %d\n", ev->count);
	}
      else
	write_fmt_string (pstream, "\n");
      break;

    case GraphicsExpose:
      if (debug_x_events > 1)
	{
	  XGraphicsExposeEvent *ev = &event->xgraphicsexpose;
	  describe_event_window (ev->drawable, ev->display, pstream);
	  write_fmt_string (pstream, "    major: %s\n",
		      (ev ->major_code == X_CopyArea  ? "CopyArea" :
		       (ev->major_code == X_CopyPlane ? "CopyPlane" : "?")));
	  write_fmt_string (pstream,
			    "   region: x=%d y=%d width=%d height=%d\n",
                      ev->x, ev->y, ev->width, ev->height);
	  write_fmt_string (pstream, "    count: %d\n", ev->count);
	}
      else
	write_fmt_string (pstream, "\n");
      break;

    case EnterNotify:
    case LeaveNotify:
      if (debug_x_events > 1)
	{
	  XCrossingEvent *ev = &event->xcrossing;
	  describe_event_window (ev->window, ev->display, pstream);
#if 0
	  write_fmt_string (pstream, " subwindow: 0x%x\n", ev->subwindow);
	  write_fmt_string (pstream, "      pos: %d %d\n", ev->x, ev->y);
	  write_fmt_string (pstream, " root pos: %d %d\n", ev->x_root,
			    ev->y_root);
#endif
	  write_fmt_string (pstream, "    mode: %s\n",
			    XEvent_mode_to_string(ev->mode));
	  write_fmt_string (pstream, "    detail: %s\n",
			    XEvent_detail_to_string(ev->detail));
	  write_fmt_string (pstream, "    focus: %d\n", ev->focus);
#if 0
	  write_fmt_string (pstream, "    state: 0x%x\n", ev->state);
#endif
	}
      else
	write_fmt_string (pstream, "\n");
      break;

    case ConfigureNotify:
      if (debug_x_events > 1)
	{
	  XConfigureEvent *ev = &event->xconfigure;
	  describe_event_window (ev->window, ev->display, pstream);
	  write_fmt_string (pstream, "    above: 0x%lx\n", ev->above);
	  write_fmt_string (pstream, "     size: %d %d %d %d\n", ev->x, ev->y,
		     ev->width, ev->height);
	  write_fmt_string (pstream, "  redirect: %d\n",
			    ev->override_redirect);
	}
      else
	write_fmt_string (pstream, "\n");
      break;

    case VisibilityNotify:
      if (debug_x_events > 1)
	{
	  XVisibilityEvent *ev = &event->xvisibility;
	  describe_event_window (ev->window, ev->display, pstream);
	  write_fmt_string (pstream, "    state: %s\n",
		      XEvent_visibility_to_string (ev->state));
	}
      else
	write_fmt_string (pstream, "\n");
      break;

    case ClientMessage:
      {
	XClientMessageEvent *ev = &event->xclient;
	char *name = XGetAtomName (ev->display, ev->message_type);
	write_fmt_string (pstream, "%s", name);
	if (!strcmp (name, "WM_PROTOCOLS"))
	  {
	    char *protname = XGetAtomName (ev->display, ev->data.l[0]);
	    write_fmt_string (pstream, "(%s)", protname);
	    XFree (protname);
	  }
	XFree (name);
	write_fmt_string (pstream, "\n");
	break;
      }

    default:
      write_fmt_string (pstream, "\n");
      break;
    }

  fflush (stdout);
}

#endif /* include describe_event definition */


/************************************************************************/
/*			get the next event from Xt			*/
/************************************************************************/

/* This business exists because menu events "happen" when
   menubar_selection_callback() is called from somewhere deep
   within XtAppProcessEvent in emacs_Xt_next_event().  The
   callback needs to terminate the modal loop in that function
   or else it will continue waiting until another event is
   received.

   Same business applies to scrollbar events. */

void
signal_special_Xt_user_event (Lisp_Object channel, Lisp_Object function,
			      Lisp_Object object)
{
  Lisp_Object event = Fmake_event (Qnil, Qnil);

  XSET_EVENT_TYPE (event, misc_user_event);
  XSET_EVENT_CHANNEL (event, channel);
  XSET_EVENT_MISC_USER_FUNCTION (event, function);
  XSET_EVENT_MISC_USER_OBJECT (event, object);
  enqueue_dispatch_event (event);
}

static void
emacs_Xt_next_event (Lisp_Event *emacs_event)
{
 we_didnt_get_an_event:

  while (NILP (dispatch_event_queue) &&
	 NILP (VXt_completed_timeouts)  &&
	 !fake_event_occurred        &&
	 !process_events_occurred    &&
	 !tty_events_occurred)
    {
      if (in_modal_loop)
	{
	  /* in_modal_loop gets set when we are in the process of
	     dispatching an event (more specifically, when we are inside of
	     a menu callback -- if we get here, it means we called a filter
	     and the filter did something that tried to fetch an event,
	     e.g. sit-for).  In such a case, we cannot safely dispatch any
	     more events.  This is because those dispatching those events
	     could cause lwlib to be entered reentranty, specifically if
	     they are menu events.  lwlib is not designed for this and will
	     crash.  We used to see this crash constantly as a result of
	     QUIT checking, but QUIT will not now function in a modal loop.
	     However, we can't just not process any events at all, because
	     that will make sit-for etc. hang.  So we go ahead and process
	     the non-X kinds of events. */
#ifdef WIN32_ANY
	  mswindows_is_blocking = 1;
#endif
	  XtAppProcessEvent (Xt_app_con, XtIMTimer | XtIMAlternateInput);
#ifdef WIN32_ANY
	  mswindows_is_blocking = 0;
#endif
	}
      else
	{
	  /* Stupid logic in XtAppProcessEvent() dictates that, if process
	     events and X events are both available, the process event gets
	     taken first.  This will cause an infinite loop if we're being
	     called from Fdiscard_input().
	  */

	  if (XtAppPending (Xt_app_con) & XtIMXEvent)
	    XtAppProcessEvent (Xt_app_con, XtIMXEvent);
	  else
	    {
	      Lisp_Object devcons, concons;

	      /* We're about to block.  Xt has a bug in it (big surprise,
		 there) in that it blocks using select() and doesn't
		 flush the Xlib output buffers (XNextEvent() does this
		 automatically before blocking).  So it's necessary
		 for us to do this ourselves.  If we don't do it, then
		 display output may not be seen until the next time
		 an X event is received. (This happens esp. with
		 subprocess output that gets sent to a visible buffer.)

		 #### The above comment may not have any validity. */

	      DEVICE_LOOP_NO_BREAK (devcons, concons)
		{
		  struct device *d;
		  d = XDEVICE (XCAR (devcons));

		  if (DEVICE_X_P (d) && DEVICE_X_DISPLAY (d))
		    /* emacs may be exiting */
		    XFlush (DEVICE_X_DISPLAY (d));
		}
#ifdef WIN32_ANY
	      mswindows_is_blocking = 1;
#endif
	      XtAppProcessEvent (Xt_app_con, XtIMAll);
#ifdef WIN32_ANY
	      mswindows_is_blocking = 0;
#endif
	    }
	}
    }

  if (!NILP (dispatch_event_queue))
    {
      Lisp_Object event, event2;
      event2 = wrap_event (emacs_event);
      event = dequeue_dispatch_event ();
      Fcopy_event (event, event2);
      Fdeallocate_event (event);
    }
  else if (tty_events_occurred)
    {
      if (!Xt_tty_to_emacs_event (emacs_event))
	goto we_didnt_get_an_event;
    }
  else if (!NILP (VXt_completed_timeouts))
    Xt_timeout_to_emacs_event (emacs_event);
  else if (fake_event_occurred)
    {
      /* A dummy event, so that a cycle of the command loop will occur. */
      fake_event_occurred = 0;
      /* eval events have nil as channel */
      set_event_type (emacs_event, eval_event);
      SET_EVENT_EVAL_FUNCTION (emacs_event, Qidentity);
      SET_EVENT_EVAL_OBJECT (emacs_event, Qnil);
    }
  else /* if (process_events_occurred) */
    Xt_process_to_emacs_event (emacs_event);

  /* No need to call XFilterEvent; Xt does it for us */
}

void
emacs_Xt_event_handler (Widget UNUSED (wid),
			XtPointer UNUSED (closure),
			XEvent *event,
			Boolean *UNUSED (continue_to_dispatch))
{
  Lisp_Object emacs_event = Fmake_event (Qnil, Qnil);

#ifdef DEBUG_XEMACS
  if (debug_x_events > 0)
    describe_event (event, Qexternal_debugging_output);
#endif /* DEBUG_XEMACS */
  if (x_event_to_emacs_event (event, XEVENT (emacs_event)))
    enqueue_dispatch_event (emacs_event);
  else
    Fdeallocate_event (emacs_event);
}


/************************************************************************/
/*                            input pending                             */
/************************************************************************/

static void
emacs_Xt_drain_queue (void)
{
  Lisp_Object devcons, concons;
  if (!in_modal_loop)
    {
      CONSOLE_LOOP (concons)
	{
	  struct console *con = XCONSOLE (XCAR (concons));
	  if (!con->input_enabled)
	    continue;

	  CONSOLE_DEVICE_LOOP (devcons, con)
	    {
	      struct device *d;
	      Display *display;
	      d = XDEVICE (XCAR (devcons));
	      if (DEVICE_X_P (d) && DEVICE_X_DISPLAY (d))
		{
		  display = DEVICE_X_DISPLAY (d);
		  while (XEventsQueued (display, QueuedAfterReading))
		    XtAppProcessEvent (Xt_app_con, XtIMXEvent);
		}
	    }
	}
      /*
	while (XtAppPending (Xt_app_con) & XtIMXEvent)
	XtAppProcessEvent (Xt_app_con, XtIMXEvent);
      */
    }

#ifdef HAVE_TTY
  drain_tty_devices ();
#endif
}

int
check_if_pending_expose_event (struct device *dev)
{
  Display *d = DEVICE_X_DISPLAY (dev);
  Lisp_Object event;

  emacs_Xt_drain_queue ();

  EVENT_CHAIN_LOOP (event, dispatch_event_queue)
    if (XEVENT_TYPE (event) == magic_event)
      {
	XEvent *xev = &XEVENT_MAGIC_X_EVENT (event);
	if (xev->type == Expose &&
	    xev->xexpose.display == d)
	  return 1;
      }

  return 0;
}

static int
emacs_Xt_current_event_timestamp (struct console *c)
{
  /* semi-yuck. */
  Lisp_Object devs = CONSOLE_DEVICE_LIST (c);

  if (NILP (devs))
    return 0;
  else
    {
      struct device *d = XDEVICE (XCAR (devs));
      return DEVICE_X_LAST_SERVER_TIMESTAMP (d);
    }
}


/************************************************************************/
/*            replacement for standard string-to-pixel converter        */
/************************************************************************/

/* This was constructed by ripping off the standard string-to-pixel
   converter from Converters.c in the Xt source code and modifying
   appropriately. */

#if 0

/* This is exported by the Xt library (at least by mine).  If this
   isn't the case somewhere, rename this appropriately and remove
   the '#if 0'.  Note, however, that I got "unknown structure"
   errors when I tried this. */
XtConvertArgRec Const colorConvertArgs[] = {
  { XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.screen),
    sizeof (Screen *) },
  { XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.colormap),
    sizeof (Colormap) }
};

#endif

#define done(type, value)               \
  if (toVal->addr != NULL) {             \
    if (toVal->size < sizeof(type)) {    \
      toVal->size = sizeof(type);        \
      return False;                      \
    }                                    \
    *(type*)(toVal->addr) = (value);     \
  } else {                               \
    static type static_val;              \
    static_val = (value);                \
    toVal->addr = (XPointer)&static_val; \
  }                                      \
  toVal->size = sizeof(type);            \
  return True /* Caller supplies `;' */

/* JH: We use this because I think there's a possibility this
   is called before the device is properly set up, in which case
   I don't want to abort. */
extern struct device *get_device_from_display_1 (Display *dpy);

static
Boolean EmacsXtCvtStringToPixel (
 Display     *dpy,
 XrmValuePtr  args,
 Cardinal    *num_args,
 XrmValuePtr  fromVal,
 XrmValuePtr  toVal,
 XtPointer   *closure_ret)
{
  String       str = (String)fromVal->addr;
  XColor       screenColor;
  XColor       exactColor;
  Screen       *screen;
  Colormap     colormap;
  Visual       *visual;
  struct device *d;
  Status       status;
  String       params[1];
  Cardinal     num_params  = 1;
  XtAppContext the_app_con = XtDisplayToApplicationContext (dpy);

  if (*num_args != 2) {
    XtAppWarningMsg(the_app_con, "wrongParameters", "cvtStringToPixel",
                    "XtToolkitError",
                    "String to pixel conversion needs screen and colormap arguments",
                    (String *)NULL, (Cardinal *)NULL);
    return False;
  }

  screen   = *((Screen **)  args[0].addr);
  colormap = *((Colormap *) args[1].addr);

  /* The original uses the private function CompareISOLatin1().
     Use XmuCompareISOLatin1() if you want, but I don't think it
     makes any difference here. */
  if (strcmp(str, XtDefaultBackground) == 0) {
    *closure_ret = False;
    /* This refers to the display's "*reverseVideo" resource.
       These display resources aren't documented anywhere that
       I can find, so I'm going to ignore this. */
    /* if (pd->rv) done(Pixel, BlackPixelOfScreen(screen)) else */
    done(Pixel, WhitePixelOfScreen(screen));
  }
  if (strcmp(str, XtDefaultForeground) == 0) {
    *closure_ret = False;
    /* if (pd->rv) done(Pixel, WhitePixelOfScreen(screen)) else */
    done(Pixel, BlackPixelOfScreen(screen));
  }

  /* Originally called XAllocNamedColor() here. */
  if ((d = get_device_from_display_1(dpy))) {
    visual = DEVICE_X_VISUAL(d);
    if (colormap != DEVICE_X_COLORMAP(d)) {
      XtAppWarningMsg(the_app_con, "weirdColormap", "cvtStringToPixel",
		      "XtToolkitWarning",
		      "The colormap passed to cvtStringToPixel doesn't match the one registered to the device.\n",
		      NULL, 0);
      status = XAllocNamedColor(dpy, colormap, (char*)str, &screenColor, &exactColor);
    } else {
      status = XParseColor (dpy, colormap, (char*)str, &screenColor);
      if (status) {
	status = x_allocate_nearest_color (dpy, colormap, visual, &screenColor);
      }
    }
  } else {
    /* We haven't set up this device totally yet, so just punt */
    status = XAllocNamedColor(dpy, colormap, (char*)str, &screenColor, &exactColor);
  }
  if (status == 0) {
    params[0] = str;
    /* Server returns a specific error code but Xlib discards it.  Ugh */
    if (XLookupColor(DisplayOfScreen(screen), colormap, (char*) str,
                     &exactColor, &screenColor)) {
      XtAppWarningMsg(the_app_con, "noColormap", "cvtStringToPixel",
                      "XtToolkitError",
                      "Cannot allocate colormap entry for \"%s\"",
                      params, &num_params);

    } else {
      XtAppWarningMsg(the_app_con, "badValue", "cvtStringToPixel",
                      "XtToolkitError",
                      "Color name \"%s\" is not defined", params, &num_params);
    }

    *closure_ret = False;
    return False;
  } else {
    *closure_ret = (char*)True;
    done(Pixel, screenColor.pixel);
  }
}

/* ARGSUSED */
static void EmacsFreePixel (
  XtAppContext app,
  XrmValuePtr  toVal,
  XtPointer    closure,
  XrmValuePtr  args,
  Cardinal    *num_args)
{
  if (*num_args != 2) {
    XtAppWarningMsg(app, "wrongParameters","freePixel","XtToolkitError",
                    "Freeing a pixel requires screen and colormap arguments",
                    (String *)NULL, (Cardinal *)NULL);
    return;
  }

  if (closure) {
    Screen   *screen  = *((Screen **)  args[0].addr);
    Colormap colormap = *((Colormap *) args[1].addr);
    XFreeColors(DisplayOfScreen(screen), colormap,
                (unsigned long*)toVal->addr, 1, (unsigned long)0);
  }
}


/************************************************************************/
/*            handle focus changes for native widgets                  */
/************************************************************************/
static void
emacs_Xt_event_widget_focus_in (Widget   w,
				XEvent   *event,
				String   *UNUSED (params),
				Cardinal *UNUSED (num_params))
{
  struct frame *f =
    x_any_widget_or_parent_to_frame (get_device_from_display (event->xany.display), w);

  XtSetKeyboardFocus (FRAME_X_SHELL_WIDGET (f), w);
}

static void
emacs_Xt_event_widget_focus_out (Widget   UNUSED (w),
				 XEvent   *UNUSED (event),
				 String   *UNUSED (params),
				 Cardinal *UNUSED (num_params))
{
}

static XtActionsRec widgetActionsList[] =
{
  { (String) "widget-focus-in",  emacs_Xt_event_widget_focus_in	 },
  { (String) "widget-focus-out", emacs_Xt_event_widget_focus_out },
};

static void
emacs_Xt_event_add_widget_actions (XtAppContext ctx)
{
  XtAppAddActions (ctx, widgetActionsList, 2);
}


/************************************************************************/
/*                            initialization                            */
/************************************************************************/

void
syms_of_event_Xt (void)
{
}

void
reinit_vars_of_event_Xt (void)
{
  Xt_event_stream = xnew_and_zero (struct event_stream);
  Xt_event_stream->event_pending_p 	 = emacs_Xt_event_pending_p;
  Xt_event_stream->force_event_pending_cb= emacs_Xt_force_event_pending;
  Xt_event_stream->next_event_cb	 = emacs_Xt_next_event;
  Xt_event_stream->handle_magic_event_cb = emacs_Xt_handle_magic_event;
  Xt_event_stream->format_magic_event_cb = emacs_Xt_format_magic_event;
  Xt_event_stream->compare_magic_event_cb= emacs_Xt_compare_magic_event;
  Xt_event_stream->hash_magic_event_cb   = emacs_Xt_hash_magic_event;
  Xt_event_stream->add_timeout_cb 	 = emacs_Xt_add_timeout;
  Xt_event_stream->remove_timeout_cb 	 = emacs_Xt_remove_timeout;
  Xt_event_stream->select_console_cb 	 = emacs_Xt_select_console;
  Xt_event_stream->unselect_console_cb 	 = emacs_Xt_unselect_console;
  Xt_event_stream->select_process_cb 	 = emacs_Xt_select_process;
  Xt_event_stream->unselect_process_cb 	 = emacs_Xt_unselect_process;
  Xt_event_stream->drain_queue_cb	 = emacs_Xt_drain_queue;
  Xt_event_stream->create_io_streams_cb  = emacs_Xt_create_io_streams;
  Xt_event_stream->delete_io_streams_cb  = emacs_Xt_delete_io_streams;
  Xt_event_stream->current_event_timestamp_cb =
    emacs_Xt_current_event_timestamp;

  last_quit_check_signal_tick_count = 0;

  /* this function only makes safe calls */
  init_what_input_once ();
}

void
vars_of_event_Xt (void)
{
  DEFVAR_BOOL ("x-allow-sendevents", &x_allow_sendevents /*
*Non-nil means to allow synthetic events.  Nil means they are ignored.
Beware: allowing emacs to process SendEvents opens a big security hole.
*/ );
  x_allow_sendevents = 0;

#ifdef DEBUG_XEMACS
  DEFVAR_INT ("debug-x-events", &debug_x_events /*
If non-zero, display debug information about X events that XEmacs sees.
Information is displayed on stderr.  Currently defined values are:

1 == non-verbose output
2 == verbose output
*/ );
  debug_x_events = 0;
#endif
  DEFVAR_LISP ("x-us-keymap-description", &Vx_us_keymap_description /*
X11-specific vector describing the current keyboard hardware, and how to map
from its keycodes to those alphanumeric and punctuation characters that
would be produced by it if a US layout were configured in software.

We use this to make possible the usage of standard key bindings on keyboards
where the keys that those bindings assume are not available; for example, on
a Russian keyboard, one can type C-Cyrillic_che C-Cyrillic_a and have XEmacs
use the binding for C-x C-f, rather than give an error message that
C-Cyrillic_che C-Cyrillic_a is not bound.

Entries are either nil, which means the corresponding key code does not map
to a non-function key in the US layout, a single character, meaning it maps to
that character, or a vector of two characters, the first indicating the
unshifted mapping, the second the shifted mapping for the US layout.

`x-us-keymap-first-keycode' tells XEmacs the keycode of the first entry in
this vector. 
*/ );
  Vx_us_keymap_description = Qnil;

  DEFVAR_INT ("x-us-keymap-first-keycode", &Vx_us_keymap_first_keycode /*
The X11 keycode that the first entry in `x-us-keymap-description'
corresponds to.  See the documentation for that variable. 

The X11 documentation for XDisplayKeycodes says this can never be less than
8, but XEmacs doesn't enforce any limitation on what you set it to. 
*/ );
  Vx_us_keymap_first_keycode = 0;

  VXt_pending_timeouts = Qnil;
  staticpro (&VXt_pending_timeouts);

  VXt_completed_timeouts = Qnil;
  staticpro (&VXt_completed_timeouts);
}

/* This mess is a hack that patches the shell widget to treat visual inheritance
   the same as colormap and depth inheritance */

static XtInitProc orig_shell_init_proc;

static void ShellVisualPatch(Widget wanted, Widget new_,
			     ArgList args, Cardinal *num_args)
{
  Widget p;
  ShellWidget w = (ShellWidget) new_;

  /* first, call the original setup */
  (*orig_shell_init_proc)(wanted, new_, args, num_args);

  /* if the visual isn't explicitly set, grab it from the nearest shell ancestor */
  if (w->shell.visual == CopyFromParent) {
    p = XtParent(w);
    while (p && !XtIsShell(p)) p = XtParent(p);
    if (p) w->shell.visual = ((ShellWidget)p)->shell.visual;
  }
}

void
init_event_Xt_late (void) /* called when already initialized */
{
  event_stream = Xt_event_stream;

  XtToolkitInitialize ();
  Xt_app_con = XtCreateApplicationContext ();
  XtAppSetFallbackResources (Xt_app_con, (String *) x_fallback_resources);

  /* In select-x.c */
  x_selection_timeout = (XtAppGetSelectionTimeout (Xt_app_con) / 1000);
  XSetErrorHandler (x_error_handler);
  XSetIOErrorHandler (x_IO_error_handler);

#ifndef WIN32_NATIVE
  XtAppAddInput (Xt_app_con, signal_event_pipe[0],
		 (XtPointer) (XtInputReadMask /* | XtInputExceptMask */),
		 Xt_what_callback, 0);
#endif

  XtAppSetTypeConverter (Xt_app_con, XtRString, XtRPixel,
		         EmacsXtCvtStringToPixel,
			 (XtConvertArgList) colorConvertArgs,
			 2, XtCacheByDisplay, EmacsFreePixel);

#ifdef XIM_XLIB
  XtAppSetTypeConverter (Xt_app_con, XtRString, XtRXimStyles,
		         EmacsXtCvtStringToXIMStyles,
			 NULL, 0,
			 XtCacheByDisplay, EmacsFreeXIMStyles);
#endif /* XIM_XLIB */
  /* Add extra actions to native widgets to handle focus and friends. */
  emacs_Xt_event_add_widget_actions (Xt_app_con);

  /* insert the visual inheritance patch/hack described above */
  orig_shell_init_proc = shellClassRec.core_class.initialize;
  shellClassRec.core_class.initialize = ShellVisualPatch;

}
