
/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 1995, 2004 IBM Corporation. All rights reserved.             */
/* Copyright (c) 2005-2018 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* https://www.oorexx.org/license.html                                        */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/******************************************************************************/
/* REXX  Support                                                              */
/*                                                                            */
/* Definition of Rexx error message numbers                                   */
/*                                                                            */
/******************************************************************************/

#ifndef RexxMessageNumbers_INCLUDED
#define RexxMessageNumbers_INCLUDED

/* ------------------------------------------------------------------------
 * --    NOTE:   file is generated by build process
 * --            ==================================================
 * --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!
 * --            ==================================================
 * ------------------------------------------------------------------------
 */

#define Error_Program_unreadable_msg                                 3
#define Error_Program_interrupted_msg                                4
#define Error_System_resources_msg                                   5
#define Error_Unmatched_quote_msg                                    6
#define Error_When_expected_msg                                      7
#define Error_Unexpected_then_msg                                    8
#define Error_Unexpected_when_msg                                    9
#define Error_Unexpected_end_msg                                     10
#define Error_Control_stack_msg                                      11
#define Error_Invalid_character_msg                                  13
#define Error_Incomplete_do_msg                                      14
#define Error_Invalid_hex_msg                                        15
#define Error_Label_not_found_msg                                    16
#define Error_Unexpected_procedure_msg                               17
#define Error_Then_expected_msg                                      18
#define Error_Symbol_or_string_msg                                   19
#define Error_Symbol_expected_msg                                    20
#define Error_Invalid_data_msg                                       21
#define Error_Invalid_character_string_msg                           22
#define Error_Invalid_data_string_msg                                23
#define Error_Invalid_trace_msg                                      24
#define Error_Invalid_subkeyword_msg                                 25
#define Error_Invalid_whole_number_msg                               26
#define Error_Invalid_do_msg                                         27
#define Error_Invalid_leave_msg                                      28
#define Error_Environment_name_msg                                   29
#define Error_Name_too_long_msg                                      30
#define Error_Invalid_variable_msg                                   31
#define Error_Expression_result_msg                                  33
#define Error_Logical_value_msg                                      34
#define Error_Invalid_expression_msg                                 35
#define Error_Unmatched_parenthesis_msg                              36
#define Error_Unexpected_comma_msg                                   37
#define Error_Invalid_template_msg                                   38
#define Error_Evaluation_stack_overflow_msg                          39
#define Error_Incorrect_call_msg                                     40
#define Error_Conversion_msg                                         41
#define Error_Overflow_msg                                           42
#define Error_Routine_not_found_msg                                  43
#define Error_Function_no_data_msg                                   44
#define Error_No_data_on_return_msg                                  45
#define Error_Variable_reference_msg                                 46
#define Error_Unexpected_label_msg                                   47
#define Error_System_service_msg                                     48
#define Error_Interpretation_msg                                     49
#define Error_Invalid_argument_msg                                   88
#define Error_Variable_expected_msg                                  89
#define Error_External_name_not_found_msg                            90
#define Error_No_result_object_msg                                   91
#define Error_OLE_Error_msg                                          92
#define Error_Incorrect_method_msg                                   93
#define Error_No_method_msg                                          97
#define Error_Execution_msg                                          98
#define Error_Translation_msg                                        99
#define Error_at_line_msg                                            100
#define Message_Translations_January_msg                             102
#define Message_Translations_February_msg                            103
#define Message_Translations_March_msg                               104
#define Message_Translations_April_msg                               105
#define Message_Translations_May_msg                                 106
#define Message_Translations_June_msg                                107
#define Message_Translations_July_msg                                108
#define Message_Translations_August_msg                              109
#define Message_Translations_September_msg                           110
#define Message_Translations_October_msg                             111
#define Message_Translations_November_msg                            112
#define Message_Translations_December_msg                            113
#define Message_Translations_debug_prompt_msg                        114
#define Error_RXSUBC_general_msg                                     115
#define Error_RXSUBC_register_msg                                    116
#define Error_RXSUBC_drop_msg                                        117
#define Error_RXSUBC_load_msg                                        118
#define Error_RXQUE_notinit_msg                                      119
#define Error_RXQUE_size_msg                                         120
#define Error_RXQUE_nomem_msg                                        121
#define Error_RXQUE_name_msg                                         122
#define Error_RXQUE_access_msg                                       123
#define Error_RXQUE_exist_msg                                        124
#define Error_RXSUBC_query_msg                                       125
#define Message_Translations_debug_error_msg                         126
#define Error_REXXC_cmd_parm_incorrect_msg                           127
#define Error_REXXC_outDifferent_msg                                 128
#define Error_REXXC_wrongNrArg_msg                                   129
#define Error_REXXC_SynCheckInfo_msg                                 130
#define Error_RXQUE_syntax_msg                                       131
#define Error_RXQUE_memfail_msg                                      132
#define Error_Program_unreadable_name_msg                            200
#define Error_Program_interrupted_condition_msg                      201
#define Error_Unmatched_quote_comment_msg                            202
#define Error_Unmatched_quote_single_msg                             203
#define Error_Unmatched_quote_double_msg                             204
#define Error_When_expected_when_msg                                 205
#define Error_When_expected_whenotherwise_msg                        206
#define Error_When_expected_nootherwise_msg                          207
#define Error_Unexpected_then_then_msg                               208
#define Error_Unexpected_then_else_msg                               209
#define Error_Unexpected_when_when_msg                               210
#define Error_Unexpected_when_otherwise_msg                          211
#define Error_Unexpected_end_nodo_msg                                212
#define Error_Unexpected_end_control_msg                             213
#define Error_Unexpected_end_nocontrol_msg                           214
#define Error_Unexpected_end_then_msg                                215
#define Error_Unexpected_end_else_msg                                216
#define Error_Unexpected_end_select_msg                              217
#define Error_Control_stack_full_msg                                 218
#define Error_Invalid_character_char_msg                             219
#define Error_Incomplete_do_do_msg                                   220
#define Error_Incomplete_do_select_msg                               221
#define Error_Incomplete_do_then_msg                                 222
#define Error_Incomplete_do_else_msg                                 223
#define Error_Incomplete_do_otherwise_msg                            224
#define Error_Invalid_hex_hexblank_msg                               225
#define Error_Invalid_hex_binblank_msg                               226
#define Error_Invalid_hex_invhex_msg                                 227
#define Error_Invalid_hex_invbin_msg                                 228
#define Error_Label_not_found_name_msg                               229
#define Error_Unexpected_procedure_call_msg                          230
#define Error_Unexpected_procedure_interpret_msg                     231
#define Error_Then_expected_if_msg                                   232
#define Error_Then_expected_when_msg                                 233
#define Error_Symbol_or_string_address_msg                           234
#define Error_Symbol_or_string_call_msg                              235
#define Error_Symbol_or_string_name_msg                              236
#define Error_Symbol_or_string_signal_msg                            237
#define Error_Symbol_or_string_stream_msg                            238
#define Error_Symbol_or_string_trace_msg                             239
#define Error_Symbol_or_string_parse_msg                             240
#define Error_Symbol_or_string_class_msg                             241
#define Error_Symbol_or_string_method_msg                            242
#define Error_Symbol_or_string_routine_msg                           243
#define Error_Symbol_or_string_requires_msg                          244
#define Error_Symbol_or_string_external_msg                          245
#define Error_Symbol_or_string_metaclass_msg                         246
#define Error_Symbol_or_string_subclass_msg                          247
#define Error_Symbol_or_string_inherit_msg                           248
#define Error_Symbol_or_string_tilde_msg                             249
#define Error_Symbol_or_string_colon_msg                             250
#define Error_Symbol_expected_drop_msg                               251
#define Error_Symbol_expected_expose_msg                             252
#define Error_Symbol_expected_parse_msg                              253
#define Error_Symbol_expected_var_msg                                254
#define Error_Symbol_expected_numeric_msg                            255
#define Error_Symbol_expected_varref_msg                             256
#define Error_Symbol_expected_leave_msg                              257
#define Error_Symbol_expected_iterate_msg                            258
#define Error_Symbol_expected_end_msg                                259
#define Error_Symbol_expected_on_msg                                 260
#define Error_Symbol_expected_off_msg                                261
#define Error_Symbol_expected_use_msg                                262
#define Error_Symbol_expected_raise_msg                              263
#define Error_Symbol_expected_user_msg                               264
#define Error_Symbol_expected_directive_msg                          265
#define Error_Symbol_expected_colon_msg                              266
#define Error_Invalid_data_nop_msg                                   267
#define Error_Invalid_data_select_msg                                268
#define Error_Invalid_data_name_msg                                  269
#define Error_Invalid_data_condition_msg                             270
#define Error_Invalid_data_signal_msg                                271
#define Error_Invalid_data_trace_msg                                 272
#define Error_Invalid_data_leave_msg                                 273
#define Error_Invalid_data_iterate_msg                               274
#define Error_Invalid_data_end_msg                                   275
#define Error_Invalid_data_form_msg                                  276
#define Error_Invalid_data_guard_off_msg                             277
#define Error_Invalid_character_string_char_msg                      278
#define Error_Invalid_character_string_DBCS_msg                      279
#define Error_Invalid_data_string_char_msg                           280
#define Error_Invalid_trace_trace_msg                                281
#define Error_Invalid_trace_debug_msg                                282
#define Error_Invalid_subkeyword_callon_msg                          283
#define Error_Invalid_subkeyword_calloff_msg                         284
#define Error_Invalid_subkeyword_signalon_msg                        285
#define Error_Invalid_subkeyword_signaloff_msg                       286
#define Error_Invalid_subkeyword_numeric_msg                         287
#define Error_Invalid_subkeyword_form_msg                            288
#define Error_Invalid_subkeyword_class_msg                           289
#define Error_Invalid_subkeyword_method_msg                          290
#define Error_Invalid_subkeyword_routine_msg                         291
#define Error_Invalid_subkeyword_requires_msg                        292
#define Error_Invalid_subkeyword_procedure_msg                       293
#define Error_Invalid_subkeyword_callonname_msg                      294
#define Error_Invalid_subkeyword_signalonname_msg                    295
#define Error_Invalid_subkeyword_parse_msg                           296
#define Error_Invalid_subkeyword_use_msg                             297
#define Error_Invalid_subkeyword_raise_msg                           298
#define Error_Invalid_subkeyword_raiseoption_msg                     299
#define Error_Invalid_subkeyword_description_msg                     300
#define Error_Invalid_subkeyword_additional_msg                      301
#define Error_Invalid_subkeyword_result_msg                          302
#define Error_Invalid_subkeyword_guard_on_msg                        303
#define Error_Invalid_whole_number_power_msg                         304
#define Error_Invalid_whole_number_repeat_msg                        305
#define Error_Invalid_whole_number_for_msg                           306
#define Error_Invalid_whole_number_parse_msg                         307
#define Error_Invalid_whole_number_digits_msg                        308
#define Error_Invalid_whole_number_fuzz_msg                          309
#define Error_Invalid_whole_number_trace_msg                         310
#define Error_Invalid_whole_number_intdiv_msg                        311
#define Error_Invalid_whole_number_rem_msg                           312
#define Error_Invalid_do_whileuntil_msg                              313
#define Error_Invalid_do_forever_msg                                 314
#define Error_Invalid_leave_leave_msg                                315
#define Error_Invalid_leave_iterate_msg                              316
#define Error_Invalid_leave_leavevar_msg                             317
#define Error_Invalid_leave_iteratevar_msg                           318
#define Error_Environment_name_name_msg                              319
#define Error_Name_too_long_name_msg                                 320
#define Error_Unexpected_label_do_msg                                321
#define Error_Unexpected_label_if_msg                                322
#define Error_Unexpected_label_select_msg                            323
#define Error_Invalid_variable_assign_msg                            324
#define Error_Invalid_variable_number_msg                            325
#define Error_Invalid_variable_period_msg                            326
#define Error_Expression_result_digits_msg                           327
#define Error_Expression_result_maxdigits_msg                        328
#define Error_Expression_result_address_msg                          329
#define Error_Expression_result_signal_msg                           330
#define Error_Expression_result_trace_msg                            331
#define Error_Expression_result_raise_msg                            332
#define Error_Logical_value_if_msg                                   333
#define Error_Incorrect_call_pad_or_name_msg                         334
#define Error_Logical_value_while_msg                                335
#define Error_Logical_value_until_msg                                336
#define Error_Logical_value_logical_msg                              337
#define Error_Logical_value_method_msg                               338
#define Error_Logical_value_guard_msg                                339
#define Error_Invalid_expression_general_msg                         340
#define Error_Invalid_expression_prefix_msg                          341
#define Error_Invalid_expression_if_msg                              342
#define Error_Invalid_expression_when_msg                            343
#define Error_Invalid_expression_control_msg                         344
#define Error_Invalid_expression_by_msg                              345
#define Error_Invalid_expression_to_msg                              346
#define Error_Invalid_expression_for_msg                             347
#define Error_Invalid_expression_while_msg                           348
#define Error_Invalid_expression_until_msg                           349
#define Error_Invalid_expression_over_msg                            350
#define Error_Invalid_expression_interpret_msg                       351
#define Error_Invalid_expression_options_msg                         352
#define Error_Invalid_expression_address_msg                         353
#define Error_Invalid_expression_signal_msg                          354
#define Error_Invalid_expression_trace_msg                           355
#define Error_Invalid_expression_form_msg                            356
#define Error_Invalid_expression_assign_msg                          357
#define Error_Invalid_expression_operator_msg                        358
#define Error_Invalid_expression_guard_msg                           359
#define Error_Invalid_expression_raise_description_msg               360
#define Error_Invalid_expression_raise_additional_msg                361
#define Error_Invalid_expression_raise_list_msg                      362
#define Error_Unmatched_parenthesis_paren_msg                        363
#define Error_Unmatched_parenthesis_square_msg                       364
#define Error_Unexpected_comma_comma_msg                             365
#define Error_Unexpected_comma_paren_msg                             366
#define Error_Unexpected_comma_bracket_msg                           367
#define Error_Invalid_template_trigger_msg                           368
#define Error_Invalid_template_position_msg                          369
#define Error_Invalid_template_with_msg                              370
#define Error_Invalid_template_missing_msg                           371
#define Error_Incorrect_call_external_msg                            372
#define Error_Incorrect_call_result_msg                              373
#define Error_Incorrect_call_minarg_msg                              374
#define Error_Incorrect_call_maxarg_msg                              375
#define Error_Incorrect_call_noarg_msg                               376
#define Error_Incorrect_call_number_msg                              377
#define Error_Incorrect_call_whole_msg                               378
#define Error_Incorrect_call_nonnegative_msg                         379
#define Error_Incorrect_call_positive_msg                            380
#define Error_Incorrect_call_toobig_msg                              381
#define Error_Incorrect_call_range_msg                               382
#define Error_Incorrect_call_null_msg                                383
#define Error_Incorrect_call_option_msg                              384
#define Error_Incorrect_call_pad_msg                                 385
#define Error_Incorrect_call_binary_msg                              386
#define Error_Incorrect_call_hex_msg                                 387
#define Error_Incorrect_call_symbol_msg                              388
#define Error_Incorrect_call_list_msg                                389
#define Error_Incorrect_call_trace_msg                               390
#define Error_Incorrect_call_random_msg                              391
#define Error_Incorrect_call_sourceline_msg                          392
#define Error_Incorrect_call_x2d_msg                                 393
#define Error_Incorrect_call_format_invalid_msg                      394
#define Error_Incorrect_call_invalid_conversion_msg                  395
#define Error_Incorrect_call_random_range_msg                        396
#define Error_Incorrect_call_stream_name_msg                         397
#define Error_Incorrect_method_stream_type_msg                       398
#define Error_Invalid_subkeyword_use_strict_msg                      399
#define Error_Incorrect_call_array_msg                               400
#define Error_Incorrect_call_nostring_msg                            401
#define Error_Incorrect_call_selector_msg                            402
#define Error_Incorrect_method_string_no_whole_number_msg            403
#define Error_Conversion_operator_msg                                404
#define Error_Conversion_prefix_msg                                  405
#define Error_Conversion_exponent_msg                                406
#define Error_Conversion_to_msg                                      407
#define Error_Conversion_by_msg                                      408
#define Error_Conversion_control_msg                                 409
#define Error_Conversion_raise_msg                                   410
#define Error_Overflow_overflow_msg                                  411
#define Error_Overflow_underflow_msg                                 412
#define Error_Overflow_zero_msg                                      413
#define Error_Overflow_expoverflow_msg                               414
#define Error_Overflow_expunderflow_msg                              415
#define Error_Overflow_power_msg                                     416
#define Error_Routine_not_found_name_msg                             417
#define Error_Routine_not_found_requires_msg                         418
#define Error_Function_no_data_function_msg                          419
#define Error_No_data_on_return_name_msg                             420
#define Error_Variable_reference_extra_msg                           421
#define Error_Variable_reference_missing_msg                         422
#define Error_Variable_reference_use_msg                             423
#define Error_Unexpected_label_interpret_msg                         424
#define Error_System_service_service_msg                             425
#define Error_External_name_not_found_class_msg                      426
#define Error_External_name_not_found_method_msg                     427
#define Error_External_name_not_found_routine_msg                    428
#define Error_No_result_object_message_msg                           429
#define Error_Incorrect_method_minarg_msg                            431
#define Error_Incorrect_method_maxarg_msg                            432
#define Error_Incorrect_method_noarg_msg                             433
#define Error_Incorrect_method_number_msg                            434
#define Error_Incorrect_method_whole_msg                             435
#define Error_Incorrect_method_nonnegative_msg                       436
#define Error_Incorrect_method_positive_msg                          437
#define Error_Incorrect_method_toobig_msg                            438
#define Error_Incorrect_method_range_msg                             439
#define Error_Incorrect_method_null_msg                              440
#define Error_Incorrect_method_hex_msg                               441
#define Error_Incorrect_method_symbol_msg                            442
#define Error_Incorrect_method_list_msg                              443
#define Error_Incorrect_method_option_msg                            444
#define Error_Incorrect_method_methodname_msg                        446
#define Error_Incorrect_method_index_msg                             447
#define Error_Incorrect_method_array_msg                             448
#define Error_Incorrect_method_binary_msg                            449
#define Error_Incorrect_method_pad_msg                               450
#define Error_Incorrect_method_length_msg                            451
#define Error_Incorrect_method_position_msg                          452
#define Error_Incorrect_method_minsub_msg                            453
#define Error_Incorrect_method_maxsub_msg                            454
#define Error_Incorrect_method_d2xd2c_msg                            455
#define Error_Incorrect_method_d2x_msg                               456
#define Error_Incorrect_method_d2c_msg                               457
#define Error_Incorrect_method_hexblank_msg                          458
#define Error_Incorrect_method_binblank_msg                          459
#define Error_Incorrect_method_invhex_msg                            460
#define Error_Incorrect_method_invbin_msg                            461
#define Error_Incorrect_method_x2dbig_msg                            462
#define Error_Incorrect_method_c2dbig_msg                            463
#define Error_Incorrect_method_supplier_msg                          464
#define Error_Incorrect_method_nostring_msg                          465
#define Error_Incorrect_method_noarray_msg                           466
#define Error_Incorrect_method_exponent_oversize_msg                 467
#define Error_Incorrect_method_before_oversize_msg                   468
#define Error_Incorrect_method_string_nonumber_msg                   469
#define Error_Incorrect_method_nomessage_msg                         470
#define Error_Incorrect_method_message_noarg_msg                     471
#define Error_Incorrect_method_message_msg                           472
#define Error_Incorrect_method_section_msg                           473
#define Error_Incorrect_method_noclass_msg                           474
#define Error_Incorrect_method_nomatch_msg                           475
#define Error_No_method_name_msg                                     476
#define Error_Program_unreadable_invalid_encoding_msg                477
#define Error_Execution_nodouble_msg                                 478
#define Error_Execution_library_msg                                  479
#define Error_Execution_terminate_msg                                480
#define Error_Execution_deadlock_msg                                 481
#define Error_Execution_badobject_msg                                482
#define Error_Execution_wrongobject_msg                              483
#define Error_Execution_nometaclass_msg                              484
#define Error_Execution_noclass_msg                                  485
#define Error_Execution_cyclic_msg                                   486
#define Error_Symbol_expected_counter_msg                            487
#define Error_Execution_noarray_msg                                  488
#define Error_Execution_nostring_msg                                 489
#define Error_Execution_message_reuse_msg                            490
#define Error_Execution_message_error_msg                            491
#define Error_Execution_raise_object_msg                             492
#define Error_Execution_propagate_msg                                493
#define Error_Execution_nomethod_msg                                 494
#define Error_Execution_error_syntax_msg                             495
#define Error_Execution_failure_syntax_msg                           496
#define Error_Execution_lostdigits_syntax_msg                        497
#define Error_Execution_nostring_syntax_msg                          498
#define Error_Execution_notready_syntax_msg                          499
#define Error_Execution_reply_msg                                    500
#define Error_Execution_reply_return_msg                             501
#define Error_Execution_reply_exit_msg                               502
#define Error_Execution_super_msg                                    503
#define Error_Execution_syntax_additional_msg                        504
#define Error_Execution_error_condition_msg                          505
#define Error_Translation_duplicate_class_msg                        506
#define Error_Translation_duplicate_method_msg                       507
#define Error_Translation_duplicate_routine_msg                      508
#define Error_Translation_duplicate_requires_msg                     509
#define Error_Translation_missing_class_msg                          510
#define Error_Translation_bad_metaclass_msg                          511
#define Error_Translation_expose_msg                                 512
#define Error_Translation_expose_interpret_msg                       513
#define Error_Translation_guard_msg                                  514
#define Error_Translation_guard_guard_msg                            515
#define Error_Translation_guard_interpret_msg                        516
#define Error_Translation_guard_expose_msg                           517
#define Error_Translation_directive_interpret_msg                    518
#define Error_Translation_use_local_interpret_msg                    519
#define Error_Translation_bad_directive_msg                          520
#define Error_Translation_bad_external_msg                           521
#define Error_Translation_use_comma_msg                              522
#define Error_Translation_reply_msg                                  523
#define Message_Translations_error_msg                               524
#define Message_Translations_running_msg                             525
#define Message_Translations_line_msg                                526
#define Error_Incorrect_method_nil_not_orderable_msg                 527
#define Error_Incorrect_method_no_method_msg                         528
#define Error_Interpretation_initialization_msg                      529
#define Error_Invalid_subkeyword_guard_msg                           530
#define Error_Incorrect_method_time_msg                              531
#define Error_Execution_mixinclass_msg                               532
#define Error_Execution_baseclass_msg                                533
#define Error_Program_unreadable_notfound_msg                        534
#define Error_Execution_recursive_inherit_msg                        535
#define Error_Execution_uninherit_msg                                536
#define Error_Translation_invalid_line_msg                           537
#define Error_Translation_requires_msg                               538
#define Error_Incorrect_method_no_method_type_msg                    539
#define Error_Incorrect_method_argType_msg                           540
#define Error_Incorrect_method_array_dimension_msg                   541
#define Error_Incorrect_method_nostring_inarray_msg                  542
#define Error_Incorrect_method_array_nostring_msg                    543
#define Error_Incorrect_method_array_noclass_msg                     544
#define Error_Invalid_do_duplicate_msg                               545
#define Error_Incorrect_method_array_too_big_msg                     546
#define Error_Program_unreadable_output_error_msg                    547
#define Error_Execution_forward_arguments_msg                        548
#define Error_Invalid_subkeyword_forward_option_msg                  549
#define Error_Invalid_subkeyword_to_msg                              550
#define Error_Invalid_subkeyword_arguments_msg                       551
#define Error_Invalid_subkeyword_continue_msg                        552
#define Error_Invalid_subkeyword_forward_class_msg                   553
#define Error_Invalid_subkeyword_message_msg                         554
#define Error_Invalid_expression_forward_to_msg                      555
#define Error_Invalid_expression_forward_arguments_msg               556
#define Error_Invalid_expression_forward_message_msg                 557
#define Error_Invalid_expression_forward_class_msg                   558
#define Error_Execution_forward_msg                                  559
#define Error_Program_unreadable_version_msg                         560
#define Error_Translation_reply_interpret_msg                        561
#define Error_Translation_forward_interpret_msg                      562
#define Error_Logical_value_authorization_msg                        563
#define Error_Execution_authorization_msg                            564
#define Error_Translation_invalid_attribute_msg                      565
#define Error_Symbol_or_string_mixinclass_msg                        566
#define Error_Translation_class_external_bad_parameters_msg          580
#define Error_Execution_no_concurrency_msg                           581
#define Error_Translation_use_local_msg                              582
#define Error_Translation_class_external_bad_class_name_msg          583
#define Error_Translation_class_external_bad_class_server_msg        584
#define Error_Interpretation_switch_msg                              585
#define Error_Incorrect_call_parm_wrong_sep_msg                      586
#define Error_Incorrect_call_format_incomp_sep_msg                   587
#define Error_Incorrect_call_queue_no_char_msg                       588
#define Error_Unknown_OLE_Error_msg                                  590
#define Error_Variant2Rexx_msg                                       591
#define Error_Rexx2Variant_msg                                       592
#define Error_Argument_Count_Mismatch_msg                            593
#define Error_Invalid_Variant_msg                                    594
#define Error_OLE_Exception_msg                                      595
#define Error_Unknown_OLE_Method_msg                                 596
#define Error_Coercion_Failed_Overflow_msg                           597
#define Error_Coercion_Failed_Type_Mismatch_msg                      598
#define Error_Parameter_Omitted_msg                                  599
#define Error_No_OLE_instance_msg                                    600
#define Error_Client_Disconnected_From_Server_msg                    601
#define Error_Incorrect_call_read_from_writeonly_msg                 603
#define Error_Incorrect_call_write_to_readonly_msg                   604
#define Error_Incorrect_method_invbase64_msg                         611
#define Error_Unsupported_method_msg                                 612
#define Error_Application_error_msg                                  613
#define Error_Program_unreadable_user_defined_msg                    614
#define Error_Program_interrupted_user_defined_msg                   615
#define Error_System_resources_user_defined_msg                      616
#define Error_Control_stack_user_defined_msg                         617
#define Error_Invalid_character_user_defined_msg                     618
#define Error_Symbol_or_string_user_defined_msg                      619
#define Error_Symbol_expected_user_defined_msg                       620
#define Error_Invalid_data_user_defined_msg                          621
#define Error_Invalid_character_string_user_defined_msg              622
#define Error_Invalid_data_string_user_defined_msg                   623
#define Error_Invalid_subkeyword_string_user_defined_msg             624
#define Error_Invalid_whole_number_user_defined_msg                  625
#define Error_Name_too_long_user_defined_msg                         626
#define Error_Invalid_variable_user_defined_msg                      627
#define Error_Expression_user_defined_msg                            628
#define Error_Logical_value_user_defined_msg                         629
#define Error_Invalid_expression_user_defined_msg                    630
#define Error_Unmatched_parenthesis_user_defined_msg                 631
#define Error_Unexpected_comma_user_defined_msg                      632
#define Error_Invalid_template_user_defined_msg                      633
#define Error_Incorrect_call_user_defined_msg                        634
#define Error_Conversion_user_defined_msg                            635
#define Error_Overflow_user_defined_msg                              636
#define Error_Routine_not_found_user_defined_msg                     637
#define Error_Function_no_data_user_defined_msg                      638
#define Error_Variable_reference_user_defined_msg                    639
#define Error_System_service_user_defined_msg                        640
#define Error_Interpretation_user_defined_msg                        641
#define Error_External_name_not_found_user_defined_msg               642
#define Error_No_result_object_user_defined_msg                      643
#define Error_OLE_Error_user_defined_msg                             644
#define Error_Incorrect_method_user_defined_msg                      645
#define Error_No_method_user_defined_msg                             646
#define Error_Execution_user_defined_msg                             647
#define Error_Translation_user_defined_msg                           648
#define Error_Unmatched_quote_user_defined_msg                       649
#define Error_Invalid_whole_number_method_msg                        650
#define Error_Logical_value_property_msg                             651
#define Error_Incorrect_call_noarray_nostem_msg                      652
#define Error_Variable_expected_USE_msg                              653
#define Error_Variable_expected_PARSE_msg                            654
#define Error_Symbol_expected_LABEL_msg                              655
#define Error_Invalid_subkeyword_select_msg                          656
#define Error_Invalid_leave_iterate_name_msg                         657
#define Error_Unexpected_end_select_nolabel_msg                      658
#define Error_Logical_value_logical_list_msg                         659
#define Error_Invalid_expression_logical_list_msg                    660
#define Error_Symbol_expected_namespace_class_msg                    661
#define Error_Symbol_expected_namespace_msg                          662
#define Error_Translation_use_arg_ellipsis_msg                       663
#define Error_Invalid_expression_use_arg_default_msg                 664
#define Error_Incorrect_method_abstract_msg                          665
#define Error_Invalid_whole_number_compareto_msg                     666
#define Error_Invalid_whole_number_compare_msg                       667
#define Error_Execution_sparse_array_msg                             668
#define Error_Incorrect_method_queue_index_msg                       669
#define Error_Execution_nostem_msg                                   670
#define Error_Invalid_argument_user_defined_msg                      671
#define Error_Invalid_argument_noarg_msg                             672
#define Error_Invalid_argument_number_msg                            673
#define Error_Invalid_argument_whole_msg                             674
#define Error_Invalid_argument_nonnegative_msg                       675
#define Error_Invalid_argument_positive_msg                          676
#define Error_Invalid_argument_toobig_msg                            677
#define Error_Invalid_argument_range_msg                             678
#define Error_Invalid_argument_null_msg                              679
#define Error_Invalid_argument_string_msg                            680
#define Error_Invalid_argument_pad_msg                               681
#define Error_Invalid_argument_length_msg                            682
#define Error_Invalid_argument_position_msg                          683
#define Error_Invalid_argument_noarray_msg                           684
#define Error_Invalid_argument_noclass_msg                           685
#define Error_Invalid_argument_argType_msg                           686
#define Error_Invalid_argument_list_msg                              687
#define Error_Invalid_argument_general_msg                           688
#define Error_Translation_duplicate_attribute_msg                    689
#define Error_Invalid_argument_format_msg                            690
#define Error_Unsupported_new_method_msg                             691
#define Error_Symbol_or_string_attribute_msg                         692
#define Error_Symbol_or_string_constant_msg                          693
#define Error_Symbol_or_string_constant_value_msg                    694
#define Error_Translation_duplicate_constant_msg                     695
#define Error_Translation_missing_resource_end_msg                   696
#define Error_Execution_library_method_msg                           697
#define Error_Execution_library_routine_msg                          698
#define Error_Execution_native_routine_msg                           699
#define Error_Incorrect_call_signature_msg                           700
#define Error_Incorrect_method_signature_msg                         701
#define Error_Incorrect_call_nostem_msg                              702
#define Error_Incorrect_method_nostem_msg                            703
#define Error_Invalid_argument_pointer_msg                           704
#define Error_Invalid_argument_nostem_msg                            705
#define Error_Invalid_argument_double_msg                            706
#define Error_Invalid_argument_maxarg_msg                            707
#define Error_Invalid_data_constant_dir_msg                          708
#define Error_Unsupported_copy_method_msg                            709
#define Error_Execution_context_not_active_msg                       710
#define Error_Execution_library_version_msg                          711
#define Error_Invalid_subkeyword_options_msg                         712
#define Error_Symbol_or_string_digits_value_msg                      713
#define Error_Symbol_or_string_fuzz_value_msg                        714
#define Error_Symbol_or_string_trace_value_msg                       715
#define Error_Execution_invalid_thread_msg                           716
#define Error_Invalid_expression_parse_msg                           717
#define Error_Invalid_expression_call_msg                            718
#define Message_Translations_routine_invocation_msg                  719
#define Message_Translations_method_invocation_msg                   720
#define Error_Incorrect_method_multi_dimension_msg                   721
#define Message_Translations_compiled_method_invocation_msg          722
#define Message_Translations_compiled_routine_invocation_msg         723
#define Message_Translations_no_source_available_msg                 724
#define Error_Incomplete_do_loop_msg                                 725
#define Error_Invalid_subkeyword_attribute_msg                       726
#define Error_Translation_abstract_method_msg                        727
#define Error_Translation_attribute_method_msg                       728
#define Error_Translation_external_attribute_msg                     729
#define Error_Translation_external_method_msg                        730
#define Error_Translation_body_error_msg                             731
#define Error_Translation_constant_body_msg                          732
#define Error_Translation_external_routine_msg                       733
#define Error_Translation_abstract_attribute_msg                     734
#define Message_Translations_internal_code_msg                       735
#define Message_Translations_sourceless_method_invocation_msg        736
#define Message_Translations_sourceless_routine_invocation_msg       737
#define Message_Translations_sourceless_program_invocation_msg       738
#define Error_Invalid_expression_select_case_msg                     739
#define Error_Translation_directive_method_routine_msg               740
#define Error_Execution_rexx_package_update_msg                      741
#define Error_Execution_rexx_defined_class_msg                       742
#define Error_Symbol_or_string_resource_msg                          743
#define Error_Invalid_subkeyword_resource_msg                        744
#define Error_Symbol_or_string_resource_end_msg                      745
#define Error_Invalid_data_resource_dir_msg                          746
#define Error_Translation_duplicate_resource_msg                     747
#define Error_Translation_reserved_namespace_msg                     748
#define Error_Invalid_argument_array_msg                             749
#define Error_Invalid_argument_array_size_msg                        750
#define Error_Symbol_or_string_keyword_msg                           751
#define Error_Invalid_subkeyword_following_msg                       752
#define Error_Execution_unassigned_variable_msg                      753
#define Error_Logical_value_when_case_msg                            754
#define Error_Invalid_expression_case_when_list_msg                  755
#define Error_Logical_value_when_msg                                 756
#define Error_Symbol_expected_annotation_attribute_msg               757
#define Error_Symbol_or_string_package_attribute_bad_value_msg       758
#define Error_Symbol_or_string_package_attribute_missing_msg         759
#define Error_Symbol_or_string_directive_option_msg                  760
#define Error_Execution_no_namespace_msg                             761
#define Error_Execution_no_namespace_class_msg                       762
#define Error_Routine_not_found_namespace_msg                        763
#define Error_Symbol_expected_qualified_call_msg                     764
#define Error_Symbol_expected_qualified_symbol_msg                   765
#define Error_Symbol_expected_annotation_type_msg                    766
#define Error_Translation_missing_annotation_target_msg              767
#define Error_Invalid_subkeyword_annotation_msg                      768
#define Error_Execution_abstract_class_msg                           769
#define Error_Execution_abstract_metaclass_msg                       770
#define Error_Symbol_expected_form_msg                               771
#define Error_Incorrect_method_message_name_msg                      772
#define Error_Execution_private_access_msg                           773
#define Error_Translation_delegate_method_msg                        774
#define Error_Symbol_expected_delegate_msg                           775
#define Error_Translation_delegate_attribute_msg                     776
#define Error_Symbol_expected_use_local_msg                          777
#define Error_Translation_use_local_compound_msg                     778
#define Error_Symbol_expected_indirect_msg                           779
#define Error_Execution_expose_method_msg                            780
#define Error_Execution_use_local_method_msg                         781
#define Error_Logical_value_supplier_msg                             782
#define Error_Execution_no_supplier_msg                              783
#define Error_Symbol_expected_after_keyword_msg                      784
#define Error_Invalid_do_with_no_control_msg                         785
#define Error_Invalid_do_with_no_over_msg                            786
#define Error_Translation_bad_class_msg                              787
#define Error_Invalid_argument_nonnegative_number_msg                788
#define Error_Invalid_argument_positive_number_msg                   789
#define Error_Invalid_argument_logical_msg                           790
#define Error_Incorrect_method_invalid_value_for_msg                 791
#define Error_Invalid_argument_variable_reference_msg                792
#define Error_Invalid_argument_variable_reference_stem_msg           793
#define Error_Invalid_argument_variable_reference_simple_msg         794
#define Error_Symbol_expected_after_prefix_reference_msg             795
#define Error_Invalid_argument_no_reference_msg                      796
#define Error_Symbol_expected_after_use_arg_reference_msg            797
#define Error_Translation_use_arg_reference_no_default_msg           798
#define Error_Execution_reference_variable_in_use_msg                799
#define Error_Execution_address_input_source_msg                     800
#define Error_Execution_address_output_target_msg                    801
#define Error_Execution_using_stream_option_msg                      802
#define Error_Invalid_whole_number_stem_array_index_msg              803
#define Error_Execution_missing_stem_array_index_msg                 804
#define Error_Execution_file_not_readable_msg                        805
#define Error_Execution_file_not_writeable_msg                       806
#define Error_Invalid_subkeyword_address_with_option_msg             807
#define Error_Invalid_subkeyword_address_input_msg                   808
#define Error_Invalid_subkeyword_address_output_msg                  809
#define Error_Invalid_subkeyword_address_error_msg                   810
#define Error_Invalid_subkeyword_address_with_io_option_msg          811
#define Error_Symbol_expected_after_stem_keyword_msg                 812
#define Error_Invalid_expression_missing_general_msg                 813
#define Error_Symbol_expected_address_with_msg                       814
#define Error_Execution_address_redirection_not_supported_msg        815
#define Error_Execution_using_rexxqueue_option_msg                   816
#define Error_Execution_address_redirection_failed_msg               817
#define Error_No_method_private_msg                                  818
#define Error_No_method_package_msg                                  819
#define Error_Execution_noinit_msg                                   820
#define Error_No_method_constant_msg                                 821
#define Error_Invalid_expression_missing_constant_msg                822
#define Error_Translation_constant_no_class_msg                      823
#define Error_Incorrect_call_bad_option_msg                          824
#define Error_Incorrect_call_relative_msg                            825
#define Error_Incorrect_call_stem_size_msg                           826
#define Error_Incorrect_call_stem_range_msg                          827
#define Error_Incorrect_call_stem_sparse_array_msg                   828
#define Error_Invalid_do_simple_do_counter_msg                       829
#define Error_No_method_unhandled_msg                                830
#define Error_Incorrect_method_invhex_group_msg                      831
#define Error_Incorrect_method_invbin_group_msg                      832
#define Error_Invalid_hex_invhex_group_msg                           833
#define Error_Invalid_hex_invbin_group_msg                           834
#define Error_Invalid_argument_date_template_msg                     835
#define Error_Invalid_argument_bad_date_msg                          836
#define Error_Incorrect_method_request_type_msg                      837
#define Error_Execution_circular_requires_msg                        838


#endif

/* -------------------------------------------------------------------------- */
/* --            file is generated by build process                        -- */
/* --            ==================================================        -- */
/* --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!        -- */
/* --            ==================================================        -- */
/* -------------------------------------------------------------------------- */
