(function() {var type_impls = {
"std":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#186-189\">source</a><a href=\"#impl-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.reverse\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#194\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.reverse\" class=\"fn\">reverse</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reverse the order of the lanes in the vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rotate_lanes_left\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#219\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.rotate_lanes_left\" class=\"fn\">rotate_lanes_left</a>&lt;const OFFSET: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Rotates the vector such that the first <code>OFFSET</code> elements of the slice move to the end\nwhile the last <code>LANES - OFFSET</code> elements move to the front. After calling <code>rotate_lanes_left</code>,\nthe element previously in lane <code>OFFSET</code> will become the first element in the slice.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rotate_lanes_right\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#245\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.rotate_lanes_right\" class=\"fn\">rotate_lanes_right</a>&lt;const OFFSET: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Rotates the vector such that the first <code>LANES - OFFSET</code> elements of the vector move to\nthe end while the last <code>OFFSET</code> elements move to the front. After calling <code>rotate_lanes_right</code>,\nthe element previously at index <code>LANES - OFFSET</code> will become the first element in the slice.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.interleave\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#284\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.interleave\" class=\"fn\">interleave</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; (<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;, <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Interleave two vectors.</p>\n<p>The resulting vectors contain lanes taken alternatively from <code>self</code> and <code>other</code>, first\nfilling the first result, and then the second.</p>\n<p>The reverse of this operation is <a href=\"std/simd/prelude/struct.Simd.html#method.deinterleave\" title=\"method std::simd::prelude::Simd::deinterleave\"><code>Simd::deinterleave</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>a = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>b = Simd::from_array([<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>]);\n<span class=\"kw\">let </span>(x, y) = a.interleave(b);\n<span class=\"macro\">assert_eq!</span>(x.to_array(), [<span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">1</span>, <span class=\"number\">5</span>]);\n<span class=\"macro\">assert_eq!</span>(y.to_array(), [<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">7</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+a+=+Simd::from_array(%5B0,+1,+2,+3%5D);%0Alet+b+=+Simd::from_array(%5B4,+5,+6,+7%5D);%0Alet+(x,+y)+=+a.interleave(b);%0Aassert_eq!(x.to_array(),+%5B0,+4,+1,+5%5D);%0Aassert_eq!(y.to_array(),+%5B2,+6,+3,+7%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deinterleave\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle.rs.html#337\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.deinterleave\" class=\"fn\">deinterleave</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; (<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;, <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Deinterleave two vectors.</p>\n<p>The first result takes every other lane of <code>self</code> and then <code>other</code>, starting with\nthe first lane.</p>\n<p>The second result takes every other lane of <code>self</code> and then <code>other</code>, starting with\nthe second lane.</p>\n<p>The reverse of this operation is <a href=\"std/simd/prelude/struct.Simd.html#method.interleave\" title=\"method std::simd::prelude::Simd::interleave\"><code>Simd::interleave</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>a = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">1</span>, <span class=\"number\">5</span>]);\n<span class=\"kw\">let </span>b = Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">7</span>]);\n<span class=\"kw\">let </span>(x, y) = a.deinterleave(b);\n<span class=\"macro\">assert_eq!</span>(x.to_array(), [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(y.to_array(), [<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+a+=+Simd::from_array(%5B0,+4,+1,+5%5D);%0Alet+b+=+Simd::from_array(%5B2,+6,+3,+7%5D);%0Alet+(x,+y)+=+a.deinterleave(b);%0Aassert_eq!(x.to_array(),+%5B0,+1,+2,+3%5D);%0Aassert_eq!(y.to_array(),+%5B4,+5,+6,+7%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle_dyn.rs.html#4-6\">source</a><a href=\"#impl-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.swizzle_dyn\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/swizzle_dyn.rs.html#17\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.swizzle_dyn\" class=\"fn\">swizzle_dyn</a>(self, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Swizzle a vector of bytes according to the index vector.\nIndices within range select the appropriate byte.\nIndices “out of bounds” instead select 0.</p>\n<p>Note that the current implementation is selected during build-time\nof the standard library, so <code>cargo build -Zbuild-std</code> may be necessary\nto unlock better performance, especially for larger vectors.\nA planned compiler improvement will enable using <code>#[target_feature]</code> instead.</p>\n</div></details></div></details>",0,"std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#107-110\">source</a><a href=\"#impl-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.LANES\" class=\"associatedconstant\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#113\">source</a><h4 class=\"code-header\">pub const <a href=\"std/simd/prelude/struct.Simd.html#associatedconstant.LANES\" class=\"constant\">LANES</a>: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a> = N</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Number of elements in this vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lanes\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#126\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.lanes\" class=\"fn\">lanes</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the number of elements in this SIMD vector.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = u32x4::splat(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(v.lanes(), <span class=\"number\">4</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::u32x4;%0Alet+v+=+u32x4::splat(0);%0Aassert_eq!(v.lanes(),+4);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.splat\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#141\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.splat\" class=\"fn\">splat</a>(value: T) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Constructs a new SIMD vector with all elements set to the given value.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = u32x4::splat(<span class=\"number\">8</span>);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">8</span>, <span class=\"number\">8</span>, <span class=\"number\">8</span>, <span class=\"number\">8</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::u32x4;%0Alet+v+=+u32x4::splat(8);%0Aassert_eq!(v.as_array(),+%26%5B8,+8,+8,+8%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#162\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.as_array\" class=\"fn\">as_array</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns an array reference containing the entire SIMD vector.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v: u64x4 = Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::%7BSimd,+u64x4%7D;%0Alet+v:+u64x4+=+Simd::from_array(%5B0,+1,+2,+3%5D);%0Aassert_eq!(v.as_array(),+%26%5B0,+1,+2,+3%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#174\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.as_mut_array\" class=\"fn\">as_mut_array</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns a mutable array reference containing the entire SIMD vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#226\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.from_array\" class=\"fn\">from_array</a>(array: <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts an array to a SIMD vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_array\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#239\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.to_array\" class=\"fn\">to_array</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts a SIMD vector to an array.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#272\">source</a><h4 class=\"code-header\">pub const fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.from_slice\" class=\"fn\">from_slice</a>(slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Converts a slice to a SIMD vector containing <code>slice[..N]</code>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the slice’s length is less than the vector’s <code>Simd::N</code>.</p>\n<h5 id=\"example\"><a href=\"#example\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>source = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>];\n<span class=\"kw\">let </span>v = u32x4::from_slice(<span class=\"kw-2\">&amp;</span>source);\n<span class=\"macro\">assert_eq!</span>(v.as_array(), <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::u32x4;%0Alet+source+=+vec!%5B1,+2,+3,+4,+5,+6%5D;%0Alet+v+=+u32x4::from_slice(%26source);%0Aassert_eq!(v.as_array(),+%26%5B1,+2,+3,+4%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#302\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.copy_to_slice\" class=\"fn\">copy_to_slice</a>(self, slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes a SIMD vector to the first <code>N</code> elements of a slice.</p>\n<h5 id=\"panics-1\"><a href=\"#panics-1\">Panics</a></h5>\n<p>Panics if the slice’s length is less than the vector’s <code>Simd::N</code>.</p>\n<h5 id=\"example-1\"><a href=\"#example-1\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>dest = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>; <span class=\"number\">6</span>];\n<span class=\"kw\">let </span>v = u32x4::from_array([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\nv.copy_to_slice(<span class=\"kw-2\">&amp;mut </span>dest);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>dest, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::u32x4;%0Alet+mut+dest+=+vec!%5B0;+6%5D;%0Alet+v+=+u32x4::from_array(%5B1,+2,+3,+4%5D);%0Av.copy_to_slice(%26mut+dest);%0Aassert_eq!(%26dest,+%26%5B1,+2,+3,+4,+0,+0%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#328\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_or\" class=\"fn\">gather_or</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from potentially discontiguous indices in <code>slice</code> to construct a SIMD vector.\nIf an index is out-of-bounds, the element is instead selected from the <code>or</code> vector.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]);  <span class=\"comment\">// Note the index that is out-of-bounds\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n\n<span class=\"kw\">let </span>result = Simd::gather_or(<span class=\"kw-2\">&amp;</span>vec, idxs, alt);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, <span class=\"number\">15</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);++//+Note+the+index+that+is+out-of-bounds%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0A%0Alet+result+=+Simd::gather_or(%26vec,+idxs,+alt);%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+15%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_or_default\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#347-349\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_or_default\" class=\"fn\">gather_or_default</a>(slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nIf an index is out-of-bounds, the element is set to the default given by <code>T: Default</code>.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]);  <span class=\"comment\">// Note the index that is out-of-bounds\n\n</span><span class=\"kw\">let </span>result = Simd::gather_or_default(<span class=\"kw-2\">&amp;</span>vec, idxs);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([<span class=\"number\">0</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, <span class=\"number\">15</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);++//+Note+the+index+that+is+out-of-bounds%0A%0Alet+result+=+Simd::gather_or_default(%26vec,+idxs);%0Aassert_eq!(result,+Simd::from_array(%5B0,+13,+10,+15%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#372-377\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select\" class=\"fn\">gather_select</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an index is disabled or is out-of-bounds, the element is selected from the <code>or</code> vector.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n\n</span><span class=\"kw\">let </span>result = Simd::gather_select(<span class=\"kw-2\">&amp;</span>vec, enable, idxs, alt);\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, -<span class=\"number\">2</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::%7BSimd,+Mask%7D;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);+//+Includes+an+out-of-bounds+index%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A%0Alet+result+=+Simd::gather_select(%26vec,+enable,+idxs,+alt);%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+-2%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#413-418\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select_unchecked\" class=\"fn\">gather_select_unchecked</a>(\n    slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Reads from indices in <code>slice</code> to construct a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an index is disabled, the element is selected from the <code>or</code> vector.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>Calling this function with an <code>enable</code>d out-of-bounds index is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>\neven if the resulting value is not used.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">5</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>alt = Simd::from_array([-<span class=\"number\">5</span>, -<span class=\"number\">4</span>, -<span class=\"number\">3</span>, -<span class=\"number\">2</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n// If this mask was used to gather, it would be unsound. Let&#39;s fix that.\n</span><span class=\"kw\">let </span>enable = enable &amp; idxs.simd_lt(Simd::splat(vec.len()));\n\n<span class=\"comment\">// The out-of-bounds index has been masked, so it&#39;s safe to gather now.\n</span><span class=\"kw\">let </span>result = <span class=\"kw\">unsafe </span>{ Simd::gather_select_unchecked(<span class=\"kw-2\">&amp;</span>vec, enable, idxs, alt) };\n<span class=\"macro\">assert_eq!</span>(result, Simd::from_array([-<span class=\"number\">5</span>, <span class=\"number\">13</span>, <span class=\"number\">10</span>, -<span class=\"number\">2</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+SimdPartialOrd,+Mask%7D;%0Alet+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+5%5D);+//+Includes+an+out-of-bounds+index%0Alet+alt+=+Simd::from_array(%5B-5,+-4,+-3,+-2%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A//+If+this+mask+was+used+to+gather,+it+would+be+unsound.+Let's+fix+that.%0Alet+enable+=+enable+%26+idxs.simd_lt(Simd::splat(vec.len()));%0A%0A//+The+out-of-bounds+index+has+been+masked,+so+it's+safe+to+gather+now.%0Alet+result+=+unsafe+%7B+Simd::gather_select_unchecked(%26vec,+enable,+idxs,+alt)+%7D;%0Aassert_eq!(result,+Simd::from_array(%5B-5,+13,+10,+-2%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#447-449\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_ptr\" class=\"fn\">gather_ptr</a>(source: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, N&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a>,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Read elementwise from pointers into a SIMD vector.</p>\n<h5 id=\"safety-1\"><a href=\"#safety-1\">Safety</a></h5>\n<p>Each read must satisfy the same conditions as <a href=\"std/ptr/fn.read.html\" title=\"fn std::ptr::read\"><code>core::ptr::read</code></a>.</p>\n<h5 id=\"example-2\"><a href=\"#example-2\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>values = [<span class=\"number\">6</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>offsets = Simd::from_array([<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>source = Simd::splat(values.as_ptr()).wrapping_add(offsets);\n<span class=\"kw\">let </span>gathered = <span class=\"kw\">unsafe </span>{ Simd::gather_ptr(source) };\n<span class=\"macro\">assert_eq!</span>(gathered, Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">6</span>, <span class=\"number\">9</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+SimdConstPtr%7D;%0Alet+values+=+%5B6,+2,+4,+9%5D;%0Alet+offsets+=+Simd::from_array(%5B1,+0,+0,+3%5D);%0Alet+source+=+Simd::splat(values.as_ptr()).wrapping_add(offsets);%0Alet+gathered+=+unsafe+%7B+Simd::gather_ptr(source)+%7D;%0Aassert_eq!(gathered,+Simd::from_array(%5B2,+6,+6,+9%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gather_select_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#481-485\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.gather_select_ptr\" class=\"fn\">gather_select_ptr</a>(\n    source: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, N&gt;,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    or: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Conditionally read elementwise from pointers into a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> pointers and disables all <code>false</code> pointers.\nIf a pointer is disabled, the element is selected from the <code>or</code> vector,\nand no read is performed.</p>\n<h5 id=\"safety-2\"><a href=\"#safety-2\">Safety</a></h5>\n<p>Enabled elements must satisfy the same conditions as <a href=\"std/ptr/fn.read.html\" title=\"fn std::ptr::read\"><code>core::ptr::read</code></a>.</p>\n<h5 id=\"example-3\"><a href=\"#example-3\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>values = [<span class=\"number\">6</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>]);\n<span class=\"kw\">let </span>offsets = Simd::from_array([<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>source = Simd::splat(values.as_ptr()).wrapping_add(offsets);\n<span class=\"kw\">let </span>gathered = <span class=\"kw\">unsafe </span>{ Simd::gather_select_ptr(source, enable, Simd::splat(<span class=\"number\">0</span>)) };\n<span class=\"macro\">assert_eq!</span>(gathered, Simd::from_array([<span class=\"number\">2</span>, <span class=\"number\">6</span>, <span class=\"number\">0</span>, <span class=\"number\">9</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BMask,+Simd,+SimdConstPtr%7D;%0Alet+values+=+%5B6,+2,+4,+9%5D;%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+false,+true%5D);%0Alet+offsets+=+Simd::from_array(%5B1,+0,+0,+3%5D);%0Alet+source+=+Simd::splat(values.as_ptr()).wrapping_add(offsets);%0Alet+gathered+=+unsafe+%7B+Simd::gather_select_ptr(source,+enable,+Simd::splat(0))+%7D;%0Aassert_eq!(gathered,+Simd::from_array(%5B2,+6,+0,+9%5D));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#507\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter\" class=\"fn\">scatter</a>(self, slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes the values in a SIMD vector to potentially discontiguous indices in <code>slice</code>.\nIf an index is out-of-bounds, the write is suppressed without panicking.\nIf two elements in the scattered vector would write to the same index\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"examples-7\"><a href=\"#examples-7\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]); <span class=\"comment\">// Note the duplicate index.\n</span><span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n\nvals.scatter(<span class=\"kw-2\">&amp;mut </span>vec, idxs); <span class=\"comment\">// two logical writes means the last wins.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[<span class=\"number\">124</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0Ause+core::simd::Simd;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);+//+Note+the+duplicate+index.%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0A%0Avals.scatter(%26mut+vec,+idxs);+//+two+logical+writes+means+the+last+wins.%0Aassert_eq!(vec,+vec!%5B124,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#532\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select\" class=\"fn\">scatter_select</a>(\n    self,\n    slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes values from a SIMD vector to multiple potentially discontiguous indices in <code>slice</code>.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf an enabled index is out-of-bounds, the write is suppressed without panicking.\nIf two enabled elements in the scattered vector would write to the same index,\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"examples-8\"><a href=\"#examples-8\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]); <span class=\"comment\">// Includes an out-of-bounds index\n</span><span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Includes a masked element\n\n</span>vals.scatter_select(<span class=\"kw-2\">&amp;mut </span>vec, enable, idxs); <span class=\"comment\">// The last write is masked, thus omitted.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[-<span class=\"number\">41</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+Mask%7D;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);+//+Includes+an+out-of-bounds+index%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Includes+a+masked+element%0A%0Avals.scatter_select(%26mut+vec,+enable,+idxs);+//+The+last+write+is+masked,+thus+omitted.%0Aassert_eq!(vec,+vec!%5B-41,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select_unchecked\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#569-574\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select_unchecked\" class=\"fn\">scatter_select_unchecked</a>(\n    self,\n    slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;,\n    idxs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Writes values from a SIMD vector to multiple potentially discontiguous indices in <code>slice</code>.\nThe mask <code>enable</code>s all <code>true</code> indices and disables all <code>false</code> indices.\nIf two enabled elements in the scattered vector would write to the same index,\nonly the last element is guaranteed to actually be written.</p>\n<h5 id=\"safety-3\"><a href=\"#safety-3\">Safety</a></h5>\n<p>Calling this function with an enabled out-of-bounds index is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>,\nand may lead to memory corruption.</p>\n<h5 id=\"examples-9\"><a href=\"#examples-9\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>];\n<span class=\"kw\">let </span>idxs = Simd::from_array([<span class=\"number\">9</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>vals = Simd::from_array([-<span class=\"number\">27</span>, <span class=\"number\">82</span>, -<span class=\"number\">41</span>, <span class=\"number\">124</span>]);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>]); <span class=\"comment\">// Masks the final index\n// If this mask was used to scatter, it would be unsound. Let&#39;s fix that.\n</span><span class=\"kw\">let </span>enable = enable &amp; idxs.simd_lt(Simd::splat(vec.len()));\n\n<span class=\"comment\">// We have masked the OOB index, so it&#39;s safe to scatter now.\n</span><span class=\"kw\">unsafe </span>{ vals.scatter_select_unchecked(<span class=\"kw-2\">&amp;mut </span>vec, enable, idxs); }\n<span class=\"comment\">// The second write to index 0 was masked, thus omitted.\n</span><span class=\"macro\">assert_eq!</span>(vec, <span class=\"macro\">vec!</span>[-<span class=\"number\">41</span>, <span class=\"number\">11</span>, <span class=\"number\">12</span>, <span class=\"number\">82</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>, <span class=\"number\">16</span>, <span class=\"number\">17</span>, <span class=\"number\">18</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+SimdPartialOrd,+Mask%7D;%0Alet+mut+vec:+Vec%3Ci32%3E+=+vec!%5B10,+11,+12,+13,+14,+15,+16,+17,+18%5D;%0Alet+idxs+=+Simd::from_array(%5B9,+3,+0,+0%5D);%0Alet+vals+=+Simd::from_array(%5B-27,+82,+-41,+124%5D);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+true,+false%5D);+//+Masks+the+final+index%0A//+If+this+mask+was+used+to+scatter,+it+would+be+unsound.+Let's+fix+that.%0Alet+enable+=+enable+%26+idxs.simd_lt(Simd::splat(vec.len()));%0A%0A//+We+have+masked+the+OOB+index,+so+it's+safe+to+scatter+now.%0Aunsafe+%7B+vals.scatter_select_unchecked(%26mut+vec,+enable,+idxs);+%7D%0A//+The+second+write+to+index+0+was+masked,+thus+omitted.%0Aassert_eq!(vec,+vec!%5B-41,+11,+12,+82,+14,+15,+16,+17,+18%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#616\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_ptr\" class=\"fn\">scatter_ptr</a>(self, dest: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, N&gt;)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Write pointers elementwise into a SIMD vector.</p>\n<h5 id=\"safety-4\"><a href=\"#safety-4\">Safety</a></h5>\n<p>Each write must satisfy the same conditions as <a href=\"std/ptr/fn.write.html\" title=\"fn std::ptr::write\"><code>core::ptr::write</code></a>.</p>\n<h5 id=\"example-4\"><a href=\"#example-4\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>values = [<span class=\"number\">0</span>; <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>offset = Simd::from_array([<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>ptrs = Simd::splat(values.as_mut_ptr()).wrapping_add(offset);\n<span class=\"kw\">unsafe </span>{ Simd::from_array([<span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">7</span>]).scatter_ptr(ptrs); }\n<span class=\"macro\">assert_eq!</span>(values, [<span class=\"number\">7</span>, <span class=\"number\">5</span>, <span class=\"number\">3</span>, <span class=\"number\">6</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BSimd,+SimdMutPtr%7D;%0Alet+mut+values+=+%5B0;+4%5D;%0Alet+offset+=+Simd::from_array(%5B3,+2,+1,+0%5D);%0Alet+ptrs+=+Simd::splat(values.as_mut_ptr()).wrapping_add(offset);%0Aunsafe+%7B+Simd::from_array(%5B6,+3,+5,+7%5D).scatter_ptr(ptrs);+%7D%0Aassert_eq!(values,+%5B7,+5,+3,+6%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.scatter_select_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#644\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"std/simd/prelude/struct.Simd.html#tymethod.scatter_select_ptr\" class=\"fn\">scatter_select_ptr</a>(\n    self,\n    dest: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, N&gt;,\n    enable: <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;\n)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span></summary><div class=\"docblock\"><p>Conditionally write pointers elementwise into a SIMD vector.\nThe mask <code>enable</code>s all <code>true</code> pointers and disables all <code>false</code> pointers.\nIf a pointer is disabled, the write to its pointee is skipped.</p>\n<h5 id=\"safety-5\"><a href=\"#safety-5\">Safety</a></h5>\n<p>Enabled pointers must satisfy the same conditions as <a href=\"std/ptr/fn.write.html\" title=\"fn std::ptr::write\"><code>core::ptr::write</code></a>.</p>\n<h5 id=\"example-5\"><a href=\"#example-5\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>values = [<span class=\"number\">0</span>; <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>offset = Simd::from_array([<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>]);\n<span class=\"kw\">let </span>ptrs = Simd::splat(values.as_mut_ptr()).wrapping_add(offset);\n<span class=\"kw\">let </span>enable = Mask::from_array([<span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">false</span>]);\n<span class=\"kw\">unsafe </span>{ Simd::from_array([<span class=\"number\">6</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">7</span>]).scatter_select_ptr(ptrs, enable); }\n<span class=\"macro\">assert_eq!</span>(values, [<span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">3</span>, <span class=\"number\">6</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(portable_simd)%5D%0Afn+main()+%7B%0A%23%5Bcfg(feature+=+%22as_crate%22)%5D+use+core_simd::simd;%0A%23%5Bcfg(not(feature+=+%22as_crate%22))%5D+use+core::simd;%0Ause+simd::%7BMask,+Simd,+SimdMutPtr%7D;%0Alet+mut+values+=+%5B0;+4%5D;%0Alet+offset+=+Simd::from_array(%5B3,+2,+1,+0%5D);%0Alet+ptrs+=+Simd::splat(values.as_mut_ptr()).wrapping_add(offset);%0Alet+enable+=+Mask::from_array(%5Btrue,+true,+false,+false%5D);%0Aunsafe+%7B+Simd::from_array(%5B6,+3,+5,+7%5D).scatter_select_ptr(ptrs,+enable);+%7D%0Aassert_eq!(values,+%5B0,+0,+3,+6%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOrAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-BitOrAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOrAssign.html\" title=\"trait std::ops::BitOrAssign\">BitOrAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.bitor_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOrAssign.html#tymethod.bitor_assign\" class=\"fn\">bitor_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>|=</code> operation. <a href=\"std/ops/trait.BitOrAssign.html#tymethod.bitor_assign\">Read more</a></div></details></div></details>","BitOrAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DivAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-DivAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.DivAssign.html\" title=\"trait std::ops::DivAssign\">DivAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Div.html\" title=\"trait std::ops::Div\">Div</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.div_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.div_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.DivAssign.html#tymethod.div_assign\" class=\"fn\">div_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>/=</code> operation. <a href=\"std/ops/trait.DivAssign.html#tymethod.div_assign\">Read more</a></div></details></div></details>","DivAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdPartialEq-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#impl-SimdPartialEq-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask type returned by each comparison.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_eq\" class=\"fn\">simd_eq</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/eq.rs.html#46\">source</a><a href=\"#method.simd_ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdPartialEq.html#tymethod.simd_ne\" class=\"fn\">simd_ne</a>(\n    self,\n    other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdPartialEq.html\" title=\"trait std::simd::prelude::SimdPartialEq\">SimdPartialEq</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdPartialEq.html#associatedtype.Mask\" title=\"type std::simd::prelude::SimdPartialEq::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Test if each lane is equal to the corresponding lane in <code>other</code>.</div></details></div></details>","SimdPartialEq","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci64,+LANES%3E%3E-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci64,+LANES%3E%3E-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i64, LANES>>","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu8,+LANES%3E%3E-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu8,+LANES%3E%3E-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u8, LANES>>","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci16,+LANES%3E%3E-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci16,+LANES%3E%3E-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i16, LANES>>","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Product-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Product-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Product-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Product-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Product-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Product-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cusize,+LANES%3E%3E-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Product%3C%26Simd%3Cusize,+LANES%3E%3E-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<usize, LANES>>","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu16,+LANES%3E%3E-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu16,+LANES%3E%3E-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u16, LANES>>","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cf64,+LANES%3E%3E-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Product%3C%26Simd%3Cf64,+LANES%3E%3E-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<f64, LANES>>","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Product-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cisize,+LANES%3E%3E-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Product%3C%26Simd%3Cisize,+LANES%3E%3E-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<isize, LANES>>","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu32,+LANES%3E%3E-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu32,+LANES%3E%3E-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u32, LANES>>","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Product-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cu64,+LANES%3E%3E-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Product%3C%26Simd%3Cu64,+LANES%3E%3E-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<u64, LANES>>","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Cf32,+LANES%3E%3E-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Product%3C%26Simd%3Cf32,+LANES%3E%3E-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<f32, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci8,+LANES%3E%3E-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci8,+LANES%3E%3E-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i8, LANES>>","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Product-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26Simd%3Ci32,+LANES%3E%3E-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Product%3C%26Simd%3Ci32,+LANES%3E%3E-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a Simd<i32, LANES>>","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Product-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Product-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Product-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Product.html\" title=\"trait std::iter::Product\">Product</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i64.html\">i64</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::SimdInt::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery lane becomes its absolute value. <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive lane and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative lane and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each lane. <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdInt","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i16.html\">i16</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::SimdInt::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery lane becomes its absolute value. <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive lane and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative lane and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each lane. <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdInt","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#impl-SimdInt-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.isize.html\">isize</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::SimdInt::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery lane becomes its absolute value. <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive lane and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative lane and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each lane. <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdInt","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i32.html\">i32</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::SimdInt::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery lane becomes its absolute value. <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive lane and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative lane and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each lane. <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdInt","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdInt-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#impl-SimdInt-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.i8.html\">i8</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Cast\" title=\"type std::simd::SimdInt::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdInt.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise absolute value, implemented in Rust.\nEvery lane becomes its absolute value. <a href=\"std/simd/trait.SimdInt.html#tymethod.abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating absolute value, implemented in Rust.\nAs abs(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_abs\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.saturating_neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating negation, implemented in Rust.\nAs neg(), except the MIN value becomes MAX instead of itself. <a href=\"std/simd/trait.SimdInt.html#tymethod.saturating_neg\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each positive lane and false if it is zero or negative.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.is_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Mask\" title=\"type std::simd::SimdInt::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each negative lane and false if it is zero or positive.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns numbers representing the sign of each lane. <a href=\"std/simd/trait.SimdInt.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/int.rs.html#315\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdInt.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdInt.html\" title=\"trait std::simd::SimdInt\">SimdInt</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdInt.html#associatedtype.Scalar\" title=\"type std::simd::SimdInt::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdInt","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsMut%3C%5BT;+N%5D%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#767-770\">source</a><a href=\"#impl-AsMut%3C%5BT;+N%5D%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.AsMut.html\" title=\"trait std::convert::AsMut\">AsMut</a>&lt;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#773\">source</a><a href=\"#method.as_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsMut.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a></h4></section></summary><div class='docblock'>Converts this type into a mutable reference of the (usually inferred) input type.</div></details></div></details>","AsMut<[T; N]>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsMut%3C%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#790-793\">source</a><a href=\"#impl-AsMut%3C%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.AsMut.html\" title=\"trait std::convert::AsMut\">AsMut</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#796\">source</a><a href=\"#method.as_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsMut.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Converts this type into a mutable reference of the (usually inferred) input type.</div></details></div></details>","AsMut<[T]>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAndAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-BitAndAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAndAssign.html\" title=\"trait std::ops::BitAndAssign\">BitAndAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.bitand_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAndAssign.html#tymethod.bitand_assign\" class=\"fn\">bitand_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>&amp;=</code> operation. <a href=\"std/ops/trait.BitAndAssign.html#tymethod.bitand_assign\">Read more</a></div></details></div></details>","BitAndAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Rem-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Rem%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Rem-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Rem-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Rem.html\" title=\"trait std::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Rem.html#associatedtype.Output\" title=\"type std::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"std/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-MulAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-MulAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.MulAssign.html\" title=\"trait std::ops::MulAssign\">MulAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.mul_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.MulAssign.html#tymethod.mul_assign\" class=\"fn\">mul_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>*=</code> operation. <a href=\"std/ops/trait.MulAssign.html#tymethod.mul_assign\">Read more</a></div></details></div></details>","MulAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#679-682\">source</a><a href=\"#impl-PartialEq-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#685\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#698\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Mul%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Mul-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Mul-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Mul-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Mul.html\" title=\"trait std::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Mul.html#associatedtype.Output\" title=\"type std::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"std/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#729-732\">source</a><a href=\"#impl-Ord-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a> + <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#735\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; <a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#826-828\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"std/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#846-848\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"std/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#871-874\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</span></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"std/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Sum-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Sum-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cf32,+LANES%3E%3E-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cf32,+LANES%3E%3E-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<f32, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Sum-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cf64,+LANES%3E%3E-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cf64,+LANES%3E%3E-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<f64, LANES>>","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Ci32,+LANES%3E%3E-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Sum%3C%26Simd%3Ci32,+LANES%3E%3E-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<i32, LANES>>","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cu32,+LANES%3E%3E-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cu32,+LANES%3E%3E-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<u32, LANES>>","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Sum-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cusize,+LANES%3E%3E-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cusize,+LANES%3E%3E-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<usize, LANES>>","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#impl-Sum-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#60\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Sum-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#impl-Sum-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#51\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cu16,+LANES%3E%3E-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cu16,+LANES%3E%3E-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#54\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<u16, LANES>>","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cu8,+LANES%3E%3E-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cu8,+LANES%3E%3E-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<u8, LANES>>","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#impl-Sum-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#52\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Sum-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Ci64,+LANES%3E%3E-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#impl-Sum%3C%26Simd%3Ci64,+LANES%3E%3E-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#61\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<i64, LANES>>","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cisize,+LANES%3E%3E-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cisize,+LANES%3E%3E-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#62\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<isize, LANES>>","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#impl-Sum-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#55\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Ci8,+LANES%3E%3E-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#impl-Sum%3C%26Simd%3Ci8,+LANES%3E%3E-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#58\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<i8, LANES>>","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#impl-Sum-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#53\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Ci16,+LANES%3E%3E-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#impl-Sum%3C%26Simd%3Ci16,+LANES%3E%3E-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#59\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<i16, LANES>>","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26Simd%3Cu64,+LANES%3E%3E-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#impl-Sum%3C%26Simd%3Cu64,+LANES%3E%3E-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#56\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = &amp;'a <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a Simd<u64, LANES>>","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#impl-Sum-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/iter/trait.Sum.html\" title=\"trait std::iter::Sum\">Sum</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/iter.rs.html#57\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.Iterator.html\" title=\"trait std::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;&gt;,</span></h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-BitOr%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitOr-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitOr.html\" title=\"trait std::ops::BitOr\">BitOr</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitOr.html#associatedtype.Output\" title=\"type std::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"std/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdUint-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#impl-SimdUint-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdUint::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdUint","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdUint-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#impl-SimdUint-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdUint::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdUint","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdUint-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#impl-SimdUint-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.u64.html\">u64</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdUint::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdUint","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdUint-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#impl-SimdUint-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.u8.html\">u8</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdUint::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdUint","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdUint-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#impl-SimdUint-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.u16.html\">u16</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Cast\" title=\"type std::simd::prelude::SimdUint::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\" class=\"fn\">saturating_add</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating add. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_add\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.saturating_sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\" class=\"fn\">saturating_sub</a>(self, second: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Lanewise saturating subtract. <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.saturating_sub\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector, with wrapping addition.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the product of the lanes of the vector, with wrapping multiplication.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_and\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_and\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_and\" class=\"fn\">reduce_and</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “and” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_or\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_or\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_or\" class=\"fn\">reduce_or</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “or” across the lanes of the vector.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_xor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/uint.rs.html#156\">source</a><a href=\"#method.reduce_xor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/prelude/trait.SimdUint.html#tymethod.reduce_xor\" class=\"fn\">reduce_xor</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/prelude/trait.SimdUint.html\" title=\"trait std::simd::prelude::SimdUint\">SimdUint</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/prelude/trait.SimdUint.html#associatedtype.Scalar\" title=\"type std::simd::prelude::SimdUint::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the cumulative bitwise “xor” across the lanes of the vector.</div></details></div></details>","SimdUint","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SubAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-SubAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.SubAssign.html\" title=\"trait std::ops::SubAssign\">SubAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.sub_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.SubAssign.html#tymethod.sub_assign\" class=\"fn\">sub_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>-=</code> operation. <a href=\"std/ops/trait.SubAssign.html#tymethod.sub_assign\">Read more</a></div></details></div></details>","SubAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdFloat-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#impl-SimdFloat-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Bits\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bits\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Bits\" class=\"associatedtype\">Bits</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Bit representation of this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" title=\"type std::simd::SimdFloat::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdFloat.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_int_unchecked\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_int_unchecked\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_int_unchecked\" class=\"fn\">to_int_unchecked</a>&lt;I&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" title=\"type std::simd::SimdFloat::Cast\">Cast</a>&lt;I&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,\n    &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a>: <a class=\"trait\" href=\"std/convert/trait.FloatToInt.html\" title=\"trait std::convert::FloatToInt\">FloatToInt</a>&lt;I&gt;,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Rounds toward zero and converts to the same-width integer type, assuming that\nthe value is finite and fits in that type. <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_int_unchecked\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_bits\" class=\"fn\">to_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Raw transmutation to an unsigned integer vector type with the\nsame size and number of lanes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.from_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.from_bits\" class=\"fn\">from_bits</a>(bits: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Raw transmutation from an unsigned integer vector type with the\nsame size and number of lanes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Produces a vector where every lane has the absolute value of the\nequivalently-indexed lane in <code>self</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.recip\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.recip\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.recip\" class=\"fn\">recip</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Takes the reciprocal (inverse) of each lane, <code>1/x</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_degrees\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_degrees\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_degrees\" class=\"fn\">to_degrees</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Converts each lane from radians to degrees.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_radians\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_radians\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_radians\" class=\"fn\">to_radians</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Converts each lane from degrees to radians.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_sign_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_sign_positive\" class=\"fn\">is_sign_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if it has a positive sign, including\n<code>+0.0</code>, <code>NaN</code>s with positive sign bit and positive infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_sign_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_sign_negative\" class=\"fn\">is_sign_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if it has a negative sign, including\n<code>-0.0</code>, <code>NaN</code>s with negative sign bit and negative infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_nan\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_nan\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_nan\" class=\"fn\">is_nan</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_infinite\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_infinite\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_infinite\" class=\"fn\">is_infinite</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is positive infinity or negative infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_finite\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_finite\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_finite\" class=\"fn\">is_finite</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is neither infinite nor <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_subnormal\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_subnormal\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_subnormal\" class=\"fn\">is_subnormal</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is subnormal.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_normal\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_normal\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_normal\" class=\"fn\">is_normal</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is neither zero, infinite,\nsubnormal, nor <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Replaces each lane with a number that represents its sign. <a href=\"std/simd/trait.SimdFloat.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copysign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.copysign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.copysign\" class=\"fn\">copysign</a>(self, sign: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns each lane with the magnitude of <code>self</code> and the sign of <code>sign</code>. <a href=\"std/simd/trait.SimdFloat.html#tymethod.copysign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum of each lane. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum of each lane. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval unless it is NaN. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_clamp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reducing multiply.  Returns the product of the lanes of the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_min\">Read more</a></div></details></div></details>","SimdFloat","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdFloat-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#impl-SimdFloat-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Mask.html\" title=\"struct std::simd::prelude::Mask\">Mask</a>&lt;&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a> as <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" title=\"type std::simd::SimdElement::Mask\">Mask</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Mask type used for manipulating this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Scalar\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Scalar\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" class=\"associatedtype\">Scalar</a> = <a class=\"primitive\" href=\"primitive.f32.html\">f32</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Scalar type contained by this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Bits\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Bits\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Bits\" class=\"associatedtype\">Bits</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Bit representation of this SIMD vector type.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Cast\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Cast\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" class=\"associatedtype\">Cast</a>&lt;T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>&gt; = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>A SIMD vector with a different element type.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.cast\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.cast\" class=\"fn\">cast</a>&lt;T&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" title=\"type std::simd::SimdFloat::Cast\">Cast</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Performs elementwise conversion of this vector’s elements to another SIMD-valid type. <a href=\"std/simd/trait.SimdFloat.html#tymethod.cast\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_int_unchecked\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_int_unchecked\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_int_unchecked\" class=\"fn\">to_int_unchecked</a>&lt;I&gt;(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Cast\" title=\"type std::simd::SimdFloat::Cast\">Cast</a>&lt;I&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/simd/trait.SimdCast.html\" title=\"trait std::simd::SimdCast\">SimdCast</a>,\n    &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a>: <a class=\"trait\" href=\"std/convert/trait.FloatToInt.html\" title=\"trait std::convert::FloatToInt\">FloatToInt</a>&lt;I&gt;,</span></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Rounds toward zero and converts to the same-width integer type, assuming that\nthe value is finite and fits in that type. <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_int_unchecked\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_bits\" class=\"fn\">to_bits</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Raw transmutation to an unsigned integer vector type with the\nsame size and number of lanes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_bits\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.from_bits\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.from_bits\" class=\"fn\">from_bits</a>(bits: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Raw transmutation from an unsigned integer vector type with the\nsame size and number of lanes.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.abs\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Produces a vector where every lane has the absolute value of the\nequivalently-indexed lane in <code>self</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.recip\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.recip\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.recip\" class=\"fn\">recip</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Takes the reciprocal (inverse) of each lane, <code>1/x</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_degrees\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_degrees\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_degrees\" class=\"fn\">to_degrees</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Converts each lane from radians to degrees.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_radians\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.to_radians\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.to_radians\" class=\"fn\">to_radians</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Converts each lane from degrees to radians.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_positive\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_sign_positive\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_sign_positive\" class=\"fn\">is_sign_positive</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if it has a positive sign, including\n<code>+0.0</code>, <code>NaN</code>s with positive sign bit and positive infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_negative\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_sign_negative\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_sign_negative\" class=\"fn\">is_sign_negative</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if it has a negative sign, including\n<code>-0.0</code>, <code>NaN</code>s with negative sign bit and negative infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_nan\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_nan\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_nan\" class=\"fn\">is_nan</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_infinite\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_infinite\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_infinite\" class=\"fn\">is_infinite</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is positive infinity or negative infinity.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_finite\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_finite\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_finite\" class=\"fn\">is_finite</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is neither infinite nor <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_subnormal\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_subnormal\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_subnormal\" class=\"fn\">is_subnormal</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is subnormal.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_normal\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.is_normal\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.is_normal\" class=\"fn\">is_normal</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Mask\" title=\"type std::simd::SimdFloat::Mask\">Mask</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns true for each lane if its value is neither zero, infinite,\nsubnormal, nor <code>NaN</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.signum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.signum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.signum\" class=\"fn\">signum</a>(self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Replaces each lane with a number that represents its sign. <a href=\"std/simd/trait.SimdFloat.html#tymethod.signum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copysign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.copysign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.copysign\" class=\"fn\">copysign</a>(self, sign: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns each lane with the magnitude of <code>self</code> and the sign of <code>sign</code>. <a href=\"std/simd/trait.SimdFloat.html#tymethod.copysign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum of each lane. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum of each lane. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval unless it is NaN. <a href=\"std/simd/trait.SimdFloat.html#tymethod.simd_clamp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_sum\" class=\"fn\">reduce_sum</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the sum of the lanes of the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_sum\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_product\" class=\"fn\">reduce_product</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Reducing multiply.  Returns the product of the lanes of the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_product\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_max\" class=\"fn\">reduce_max</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the maximum lane in the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reduce_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/elements/float.rs.html#422\">source</a><a href=\"#method.reduce_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_min\" class=\"fn\">reduce_min</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/simd/trait.SimdFloat.html\" title=\"trait std::simd::SimdFloat\">SimdFloat</a>&gt;::<a class=\"associatedtype\" href=\"std/simd/trait.SimdFloat.html#associatedtype.Scalar\" title=\"type std::simd::SimdFloat::Scalar\">Scalar</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the minimum lane in the vector. <a href=\"std/simd/trait.SimdFloat.html#tymethod.reduce_min\">Read more</a></div></details></div></details>","SimdFloat","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AddAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-AddAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.AddAssign.html\" title=\"trait std::ops::AddAssign\">AddAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Add.html\" title=\"trait std::ops::Add\">Add</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.add_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.add_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.AddAssign.html#tymethod.add_assign\" class=\"fn\">add_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>+=</code> operation. <a href=\"std/ops/trait.AddAssign.html#tymethod.add_assign\">Read more</a></div></details></div></details>","AddAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ShrAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#impl-ShrAssign%3CU%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.ShrAssign.html\" title=\"trait std::ops::ShrAssign\">ShrAssign</a>&lt;U&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Shr.html\" title=\"trait std::ops::Shr\">Shr</a>&lt;U, Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.shr_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/assign.rs.html#33-124\">source</a><a href=\"#method.shr_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.ShrAssign.html#tymethod.shr_assign\" class=\"fn\">shr_assign</a>(&amp;mut self, rhs: U)</h4></section></summary><div class='docblock'>Performs the <code>&gt;&gt;=</code> operation. <a href=\"std/ops/trait.ShrAssign.html#tymethod.shr_assign\">Read more</a></div></details></div></details>","ShrAssign<U>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdOrd-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#impl-SimdOrd-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/simd/trait.SimdOrd.html\" title=\"trait std::simd::SimdOrd\">SimdOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_max\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_max\" class=\"fn\">simd_max</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise maximum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_min\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_min\" class=\"fn\">simd_min</a>(self, other: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Returns the lane-wise minimum with <code>other</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.simd_clamp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ord.rs.html#110\">source</a><a href=\"#method.simd_clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\" class=\"fn\">simd_clamp</a>(\n    self,\n    min: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;,\n    max: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;\n) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>Restrict each lane to a certain interval. <a href=\"std/simd/trait.SimdOrd.html#tymethod.simd_clamp\">Read more</a></div></details></div></details>","SimdOrd","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Shl%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Shl-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Shl-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Shl.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&lt;&lt;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shl\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.shl\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Shl.html#tymethod.shl\" class=\"fn\">shl</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Shl.html\" title=\"trait std::ops::Shl\">Shl</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Shl.html#associatedtype.Output\" title=\"type std::ops::Shl::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&lt;&lt;</code> operation. <a href=\"std/ops/trait.Shl.html#tymethod.shl\">Read more</a></div></details></div></details>","Shl","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128d%3E-for-Simd%3Cf64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#39\">source</a><a href=\"#impl-From%3C__m128d%3E-for-Simd%3Cf64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128d.html\" title=\"struct core::core_arch::x86::__m128d\">__m128d</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#39\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128d.html\" title=\"struct core::core_arch::x86::__m128d\">__m128d</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 2&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128d>","std::simd::f64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Ci8,+64%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#14\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Ci8,+64%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#14\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 64&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512d%3E-for-Simd%3Cf64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#41\">source</a><a href=\"#impl-From%3C__m512d%3E-for-Simd%3Cf64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512d.html\" title=\"struct core::core_arch::x86::__m512d\">__m512d</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#41\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512d.html\" title=\"struct core::core_arch::x86::__m512d\">__m512d</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512d>","std::simd::f64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cusize,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#47\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cusize,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#47\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::usizex8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Ci8,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#13\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Ci8,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#13\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 32&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::i8x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%5BT;+N%5D%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#802-805\">source</a><a href=\"#impl-From%3C%5BT;+N%5D%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#808\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(array: <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<[T; N]>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cusize,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#46\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cusize,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#46\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::usizex4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Ci32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#26\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Ci32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#26\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::i32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Ci32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#28\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Ci32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#28\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::i32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CMask%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/masks/full_masks.rs.html#263-266\">source</a><a href=\"#impl-From%3CMask%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;Mask&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.MaskElement.html\" title=\"trait std::simd::MaskElement\">MaskElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/masks/full_masks.rs.html#269\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: Mask&lt;T, LANES&gt;) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<Mask<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cisize,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#51\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cisize,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#51\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::isizex16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Ci16,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#20\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Ci16,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#20\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::i16x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cu16,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#17\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cu16,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#17\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::u16x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Ci64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#38\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Ci64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#38\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::i64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512%3E-for-Simd%3Cf32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#31\">source</a><a href=\"#impl-From%3C__m512%3E-for-Simd%3Cf32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512.html\" title=\"struct core::core_arch::x86::__m512\">__m512</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#31\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512.html\" title=\"struct core::core_arch::x86::__m512\">__m512</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512>","std::simd::f32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cisize,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#49\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cisize,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#49\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::isizex4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cu64,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#35\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cu64,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#35\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::u64x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128%3E-for-Simd%3Cf32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#29\">source</a><a href=\"#impl-From%3C__m128%3E-for-Simd%3Cf32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128.html\" title=\"struct core::core_arch::x86::__m128\">__m128</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#29\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128.html\" title=\"struct core::core_arch::x86::__m128\">__m128</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128>","std::simd::f32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cu8,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#9\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cu8,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#9\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::u8x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Ci64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#36\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Ci64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#36\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 2&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::i64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cu16,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#18\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cu16,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#18\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 32&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::u16x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cu32,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#25\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cu32,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#25\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::u32x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Ci64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#37\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Ci64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#37\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::i64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cisize,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#50\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cisize,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#50\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::isizex8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256%3E-for-Simd%3Cf32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#30\">source</a><a href=\"#impl-From%3C__m256%3E-for-Simd%3Cf32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256.html\" title=\"struct core::core_arch::x86::__m256\">__m256</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#30\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256.html\" title=\"struct core::core_arch::x86::__m256\">__m256</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256>","std::simd::f32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cu8,+64%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#11\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cu8,+64%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#11\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 64&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256d%3E-for-Simd%3Cf64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#40\">source</a><a href=\"#impl-From%3C__m256d%3E-for-Simd%3Cf64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256d.html\" title=\"struct core::core_arch::x86::__m256d\">__m256d</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#40\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256d.html\" title=\"struct core::core_arch::x86::__m256d\">__m256d</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256d>","std::simd::f64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cu32,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#23\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cu32,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#23\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::u32x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cu64,+4%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#34\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cu64,+4%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#34\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 4&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::u64x4"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Cusize,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#48\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Cusize,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#48\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::usizex16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cu16,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#16\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cu16,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#16\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::u16x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Cu64,+2%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#33\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Cu64,+2%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#33\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, 2&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::u64x2"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m512i%3E-for-Simd%3Ci16,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#21\">source</a><a href=\"#impl-From%3C__m512i%3E-for-Simd%3Ci16,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#21\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m512i.html\" title=\"struct core::core_arch::x86::__m512i\">__m512i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 32&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m512i>","std::simd::i16x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cu8,+32%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#10\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cu8,+32%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#10\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, 32&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::u8x32"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Ci32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#27\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Ci32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#27\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::i32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m256i%3E-for-Simd%3Cu32,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#24\">source</a><a href=\"#impl-From%3C__m256i%3E-for-Simd%3Cu32,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#24\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m256i.html\" title=\"struct core::core_arch::x86::__m256i\">__m256i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m256i>","std::simd::u32x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Ci16,+8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#19\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Ci16,+8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#19\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, 8&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::i16x8"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C__m128i%3E-for-Simd%3Ci8,+16%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#12\">source</a><a href=\"#impl-From%3C__m128i%3E-for-Simd%3Ci8,+16%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vendor/x86.rs.html#12\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(value: <a class=\"struct\" href=\"core/core_arch/x86/struct.__m128i.html\" title=\"struct core::core_arch::x86::__m128i\">__m128i</a>) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, 16&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<__m128i>","std::simd::i8x16"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Cf32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Cf32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Cf64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Cf64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#impl-Neg-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#24-38\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Neg.html\" title=\"trait std::ops::Neg\">Neg</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Neg.html#associatedtype.Output\" title=\"type std::ops::Neg::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"std/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#657-660\">source</a><a href=\"#impl-Clone-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#663\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;</h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"std/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#169\">source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"std/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3C%26mut+%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#837-840\">source</a><a href=\"#impl-TryFrom%3C%26mut+%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.TryFrom.html\" title=\"trait std::convert::TryFrom\">TryFrom</a>&lt;&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"std/array/struct.TryFromSliceError.html\" title=\"struct std::array::TryFromSliceError\">TryFromSliceError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#845\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(slice: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;, <a class=\"struct\" href=\"std/array/struct.TryFromSliceError.html\" title=\"struct std::array::TryFromSliceError\">TryFromSliceError</a>&gt;</h4></section></summary><div class='docblock'>Performs the conversion.</div></details></div></details>","TryFrom<&mut [T]>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3C%26%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#824-827\">source</a><a href=\"#impl-TryFrom%3C%26%5BT%5D%3E-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.TryFrom.html\" title=\"trait std::convert::TryFrom\">TryFrom</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"std/array/struct.TryFromSliceError.html\" title=\"struct std::array::TryFromSliceError\">TryFromSliceError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#832\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(slice: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;, <a class=\"struct\" href=\"std/array/struct.TryFromSliceError.html\" title=\"struct std::array::TryFromSliceError\">TryFromSliceError</a>&gt;</h4></section></summary><div class='docblock'>Performs the conversion.</div></details></div></details>","TryFrom<&[T]>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-Simd%3CT,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#710-713\">source</a><a href=\"#impl-PartialOrd-for-Simd%3CT,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/vector.rs.html#716\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, N&gt;) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1122\">source</a></span><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1139\">source</a></span><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1155\">source</a></span><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1172\">source</a></span><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cf64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Sub-for-Simd%3Cf64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cf32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#impl-Sub-for-Simd%3Cf32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#235-260\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-Sub%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-Sub-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.Sub.html\" title=\"trait std::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Sub.html#associatedtype.Output\" title=\"type std::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"std/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cu16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cu16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Ci16,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Ci16,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cusize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cusize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Ci64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Ci64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cu32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cu32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Ci32,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Ci32,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cisize,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cisize,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cu64,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cu64,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Ci8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Ci8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Not-for-Simd%3Cu8,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#impl-Not-for-Simd%3Cu8,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Not.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>!</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.not\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/unary.rs.html#58-78\">source</a><a href=\"#method.not\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Not.html#tymethod.not\" class=\"fn\">not</a>(self) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Not.html\" title=\"trait std::ops::Not\">Not</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Not.html#associatedtype.Output\" title=\"type std::ops::Not::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the unary <code>!</code> operation. <a href=\"std/ops/trait.Not.html#tymethod.not\">Read more</a></div></details></div></details>","Not","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cusize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cusize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cisize,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cisize,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cu16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cu16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cu32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cu32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Ci64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Ci64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i64.html\">i64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Ci8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Ci8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#impl-BitAnd%3C%26Simd%3CT,+LANES%3E%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;: <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&lt;Output = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops/deref.rs.html#82-124\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(\n    self,\n    rhs: &amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;\n) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&lt;&amp;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd<&Simd<T, LANES>>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64","std::simd::i64x1","std::simd::i64x2","std::simd::i64x4","std::simd::i64x8","std::simd::i64x16","std::simd::i64x32","std::simd::i64x64","std::simd::isizex1","std::simd::isizex2","std::simd::isizex4","std::simd::isizex8","std::simd::isizex16","std::simd::isizex32","std::simd::isizex64","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64","std::simd::u16x1","std::simd::u16x2","std::simd::u16x4","std::simd::u16x8","std::simd::u16x16","std::simd::u16x32","std::simd::u16x64","std::simd::u32x1","std::simd::u32x2","std::simd::u32x4","std::simd::u32x8","std::simd::u32x16","std::simd::u32x32","std::simd::u32x64","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64","std::simd::usizex1","std::simd::usizex2","std::simd::usizex4","std::simd::usizex8","std::simd::usizex16","std::simd::usizex32","std::simd::usizex64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cu8,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cu8,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::u8x1","std::simd::u8x2","std::simd::u8x4","std::simd::u8x8","std::simd::u8x16","std::simd::u8x32","std::simd::u8x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Ci32,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Ci32,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::i32x1","std::simd::i32x2","std::simd::i32x4","std::simd::i32x8","std::simd::i32x16","std::simd::i32x32","std::simd::i32x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Ci16,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Ci16,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitAnd-for-Simd%3Cu64,+N%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#impl-BitAnd-for-Simd%3Cu64,+N%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a> for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;N&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;</h4></section></summary><div class='docblock'>The resulting type after applying the <code>&amp;</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitand\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#174-231\">source</a><a href=\"#method.bitand\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\" class=\"fn\">bitand</a>(self, rhs: <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt;) -&gt; &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>, N&gt; as <a class=\"trait\" href=\"std/ops/trait.BitAnd.html\" title=\"trait std::ops::BitAnd\">BitAnd</a>&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.BitAnd.html#associatedtype.Output\" title=\"type std::ops::BitAnd::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>&amp;</code> operation. <a href=\"std/ops/trait.BitAnd.html#tymethod.bitand\">Read more</a></div></details></div></details>","BitAnd","std::simd::u64x1","std::simd::u64x2","std::simd::u64x4","std::simd::u64x8","std::simd::u64x16","std::simd::u64x32","std::simd::u64x64"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IndexMut%3CI%3E-for-Simd%3CT,+LANES%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#24-28\">source</a><a href=\"#impl-IndexMut%3CI%3E-for-Simd%3CT,+LANES%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;I, T, const LANES: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/ops/trait.IndexMut.html\" title=\"trait std::ops::IndexMut\">IndexMut</a>&lt;I&gt; for <a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a>,\n    <a class=\"struct\" href=\"std/simd/struct.LaneCount.html\" title=\"struct std::simd::LaneCount\">LaneCount</a>&lt;LANES&gt;: <a class=\"trait\" href=\"std/simd/trait.SupportedLaneCount.html\" title=\"trait std::simd::SupportedLaneCount\">SupportedLaneCount</a>,\n    I: <a class=\"trait\" href=\"std/slice/trait.SliceIndex.html\" title=\"trait std::slice::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.index_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/portable-simd/crates/core_simd/src/ops.rs.html#31\">source</a><a href=\"#method.index_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.IndexMut.html#tymethod.index_mut\" class=\"fn\">index_mut</a>(&amp;mut self, index: I) -&gt; &amp;mut &lt;<a class=\"struct\" href=\"std/simd/prelude/struct.Simd.html\" title=\"struct std::simd::prelude::Simd\">Simd</a>&lt;T, LANES&gt; as <a class=\"trait\" href=\"std/ops/trait.Index.html\" title=\"trait std::ops::Index\">Index</a>&lt;I&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Index.html#associatedtype.Output\" title=\"type std::ops::Index::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the mutable indexing (<code>container[index]</code>) operation. <a href=\"std/ops/trait.IndexMut.html#tymethod.index_mut\">Read more</a></div></details></div></details>","IndexMut<I>","std::simd::f32x1","std::simd::f32x2","std::simd::f32x4","std::simd::f32x8","std::simd::f32x16","std::simd::f32x32","std::simd::f32x64","std::simd::f64x1","std::simd::f64x2","std::simd::f64x4","std::simd::f64x8","std::simd::f64x16","std::simd::f64x32","std::simd::f64x64","std::simd::i8x1","std::simd::i8x2","std::simd::i8x4","std::simd::i8x8","std::simd::i8x16","std::simd::i8x32","std::simd::i8x64","std::simd::i16x1","std::simd::i16x2","std::simd::i16x4","std::simd::i16x8","std::simd::i16x16","std::simd::i16x32","std::simd::i16x64","std::simd::i32x1","