/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecDeploymentConsumer;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecDeploymentProducer;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SearchBasedSpecValidator;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.UploadSpecValidator;
import org.jfrog.build.extractor.producerConsumer.ConsumerRunnableBase;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerExecutor;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;

public class SpecsHelper {
    private static final int DEFAULT_NUMBER_OF_THREADS = 3;
    private final Log log;

    public SpecsHelper(Log log) {
        this.log = log;
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, File workspace, Map<String, String> buildProperties, ArtifactoryBuildInfoClientBuilder clientBuilder) throws Exception {
        return this.uploadArtifactsBySpec(uploadSpec, 3, workspace, SpecsHelper.createMultiMap(buildProperties), clientBuilder);
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, File workspace, Multimap<String, String> buildProperties, ArtifactoryBuildInfoClientBuilder clientBuilder) throws Exception {
        return this.uploadArtifactsBySpec(uploadSpec, 3, workspace, buildProperties, clientBuilder);
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, int numberOfThreads, File workspace, Multimap<String, String> buildProperties, ArtifactoryBuildInfoClientBuilder clientBuilder) throws Exception {
        Spec spec = this.getSpecFromString(uploadSpec, new UploadSpecValidator());
        try (ArtifactoryBuildInfoClient client = clientBuilder.build();){
            ProducerRunnableBase[] producerRunnable = new ProducerRunnableBase[]{new SpecDeploymentProducer(spec, workspace, buildProperties)};
            ConsumerRunnableBase[] consumerRunnables = new ConsumerRunnableBase[numberOfThreads];
            for (int i = 0; i < numberOfThreads; ++i) {
                consumerRunnables[i] = new SpecDeploymentConsumer(client);
            }
            ProducerConsumerExecutor deploymentExecutor = new ProducerConsumerExecutor(this.log, producerRunnable, consumerRunnables, 10);
            deploymentExecutor.start();
            Set<DeployDetails> deployedArtifacts = ((SpecDeploymentProducer)producerRunnable[0]).getDeployedArtifacts();
            List<Artifact> list = this.convertDeployDetailsToArtifacts(deployedArtifacts);
            return list;
        }
    }

    public static <K, V> Multimap<K, V> createMultiMap(Map<K, V> input) {
        ArrayListMultimap<K, V> multimap = ArrayListMultimap.create();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            multimap.put(entry.getKey(), entry.getValue());
        }
        return multimap;
    }

    public List<Dependency> downloadArtifactsBySpec(String spec, ArtifactoryDependenciesClient client, String targetDirectory) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(client, targetDirectory, this.log);
        return helper.downloadDependencies(this.getSpecFromString(spec, new SearchBasedSpecValidator()));
    }

    public Spec getSpecFromFile(File specFile, SpecsValidator specsValidator) throws IOException {
        return this.getSpecFromString(FileUtils.readFileToString(specFile), specsValidator);
    }

    public Spec getSpecFromString(String specStr, SpecsValidator specsValidator) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        specStr = specStr.replace("\\", "\\\\");
        Spec spec = mapper.readValue(specStr, Spec.class);
        specsValidator.validate(spec);
        this.pathToUnixFormat(spec);
        return spec;
    }

    public boolean editPropertiesBySpec(String spec, ArtifactoryDependenciesClient client, EditPropertiesHelper.EditPropertiesActionType editType, String props) throws IOException {
        EditPropertiesHelper helper = new EditPropertiesHelper(client, this.log);
        return helper.editProperties(this.getSpecFromString(spec, new SearchBasedSpecValidator()), editType, props);
    }

    private void pathToUnixFormat(Spec spec) {
        for (FileSpec fileSpec : spec.getFiles()) {
            String separator;
            String string = separator = StringUtils.equalsIgnoreCase(fileSpec.getRegexp(), Boolean.TRUE.toString()) ? "\\\\\\\\" : "\\\\";
            if (fileSpec.getTarget() != null) {
                fileSpec.setTarget(fileSpec.getTarget().replaceAll("\\\\", "/"));
            }
            if (fileSpec.getPattern() != null) {
                fileSpec.setPattern(fileSpec.getPattern().replaceAll(separator, "/"));
            }
            if (fileSpec.getExcludePatterns() == null) continue;
            for (int i = 0; i < fileSpec.getExcludePatterns().length; ++i) {
                if (!StringUtils.isNotBlank(fileSpec.getExcludePattern(i))) continue;
                fileSpec.setExcludePattern(fileSpec.getExcludePattern(i).replaceAll(separator, "/"), i);
            }
        }
    }

    public static ArrayListMultimap<String, String> getPropertiesMap(String props) {
        ArrayListMultimap<String, String> propertiesMap = ArrayListMultimap.create();
        SpecsHelper.fillPropertiesMap(props, propertiesMap);
        return propertiesMap;
    }

    public static void fillPropertiesMap(String props, ArrayListMultimap<String, String> propertiesMap) {
        if (StringUtils.isBlank(props)) {
            return;
        }
        for (String prop : props.trim().split(";")) {
            String key = StringUtils.substringBefore(prop, "=");
            String[] values = StringUtils.substringAfter(prop, "=").split(",");
            propertiesMap.putAll((Object)key, Arrays.asList(values));
        }
    }

    private List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (DeployDetails detail : details) {
            String ext = FilenameUtils.getExtension(detail.getFile().getName());
            ArtifactBuilder artifactBuilder = new ArtifactBuilder(detail.getFile().getName());
            artifactBuilder.md5(detail.getMd5()).sha1(detail.getSha1()).type(ext).localPath(detail.getFile().getAbsolutePath()).remotePath(detail.getArtifactPath()).build();
            result.add(artifactBuilder.build());
        }
        return result;
    }
}

