# WARNING: Test output is dependent on the order these classes include
# certain modules; i.e. on the 'require' order.
require 'common/domain'
require 'common/user'
require 'mailshears_test'
require 'rm/plugins/davical'
require 'rm/plugins/dovecot'
require 'rm/plugins/postfixadmin'
require 'rm/plugins/roundcube'
require 'rm/rm_runner'


class TestRm < MailshearsTest

  def test_rm_user
    cfg = configuration()
    users = [ User.new("adam@example.net") ]

    output_buffer = StringIO.new()

    $stdout = output_buffer
    RmPlugin.run(cfg, *users)
    $stdout = STDOUT

    actual = output_buffer.string()

    expected =
      "DavicalRm - User adam@example.net not found.\n" +
      "DovecotRm - Removed user adam@example.net " +
        "(#{cfg.dovecot_mail_root}/example.net/adam).\n" +
      "PostfixadminRm - Removed user adam@example.net.\n" +
      "RoundcubeRm - Removed user adam@example.net (User ID: 3).\n"

    assert_equal(expected, actual)

    # Now make sure the database has what we expect.

    drm = DavicalRm.new(cfg)
    actual = drm.list_users()
    expected = [User.new('alice@example.com'), User.new('booger@example.com')]
    assert_equal(expected, actual)

    pfarm = PostfixadminRm.new(cfg)
    actual = pfarm.list_users()
    expected = [User.new('alice@example.com'),
                User.new('bob@example.com'),
                User.new('beth@example.net'),
                User.new('carol@example.net')]
    assert_equal(expected, actual)

    actual = pfarm.list_domains()
    expected = [Domain.new('example.com'), Domain.new('example.net')]
    assert_equal(expected, actual)

    actual = pfarm.list_aliases()
    expected = [{'address' => 'alice@example.com',
                 'goto' => 'alice@example.com,' +
                           'bob@example.com,' +
                           'carol@example.net'},
                {'address' => 'beth@example.net',
                 'goto' => 'beth@example.net'},
                {'address' => 'bob@example.com',
                 'goto' => 'bob@example.com'},
                {'address' => 'carol@example.net',
                 'goto' => 'carol@example.net'}]
    expected.each { |e| assert(actual.include?(e)) } # can't sort dicts
    actual.each { |a| assert(expected.include?(a)) } # can't sort dicts

    rrm = RoundcubeRm.new(cfg)
    actual = rrm.list_users()
    expected = [User.new('alice@example.com'), User.new('booger@example.com')]
    assert_equal(expected, actual)

    # Check that adam's directory is gone but that the rest remain.
    assert(maildir_exists('example.com/alice'))
    assert(maildir_exists('example.com/booger'))
    assert(maildir_exists('example.com/jeremy'))
    assert(!maildir_exists('example.net/adam'))
  end


  def test_rm_domain
    cfg = configuration()
    domains = [Domain.new("example.net")]

    output_buffer = StringIO.new()

    $stdout = output_buffer
    RmPlugin.run(cfg, *domains)
    $stdout = STDOUT

    actual = output_buffer.string()

    expected =
      "DavicalRm - Domain example.net not found.\n" +
      "DovecotRm - Removed domain example.net " +
        "(#{cfg.dovecot_mail_root}/example.net).\n" +
      "PostfixadminRm - Removed domain example.net.\n" +
      "RoundcubeRm - Removed domain example.net.\n"

    assert_equal(expected, actual)

    # Now make sure the database has what we expect.

    drm = DavicalRm.new(cfg)
    actual = drm.list_users()
    expected = [User.new('alice@example.com'), User.new('booger@example.com')]
    assert_equal(expected, actual)

    pfarm = PostfixadminRm.new(cfg)
    actual = pfarm.list_users()
    expected = [User.new('alice@example.com'),
                User.new('bob@example.com')]
    assert_equal(expected, actual)

    actual = pfarm.list_domains()
    expected = [Domain.new('example.com')]
    assert_equal(expected, actual)

    actual = pfarm.list_aliases()
    expected = [{'address' => 'alice@example.com',
                 'goto' => 'alice@example.com,bob@example.com'},
                {'address' => 'bob@example.com',
                 'goto' => 'bob@example.com'}]
    expected.each { |e| assert(actual.include?(e)) } # can't sort dicts
    actual.each { |a| assert(expected.include?(a)) } # can't sort dicts

    rrm = RoundcubeRm.new(cfg)
    actual = rrm.list_users()
    expected = [User.new('alice@example.com'), User.new('booger@example.com')]
    assert_equal(expected, actual)

    # Check that example.net's directory is gone but that the rest remain.
    assert(maildir_exists('example.com/alice'))
    assert(maildir_exists('example.com/booger'))
    assert(maildir_exists('example.com/jeremy'))
    assert(!maildir_exists('example.net'))
  end


end
