# WARNING: Test output is dependent on the order these classes include
# certain modules; i.e. on the 'require' order.
require 'common/domain'
require 'common/user'
require 'mailshears_test'
require 'mv/plugins/davical'
require 'mv/plugins/dovecot'
require 'mv/plugins/postfixadmin'
require 'mv/plugins/roundcube'
require 'mv/mv_runner'


class TestMv < MailshearsTest

  def test_mv_once
    cfg = configuration()
    src = User.new("alice@example.com")
    dst = User.new("alice@example.net")

    output_buffer = StringIO.new()

    $stdout = output_buffer
    MvPlugin.run(cfg, src, dst)
    $stdout = STDOUT

    actual = output_buffer.string()

    expected =
      "DavicalMv - Moved user alice@example.com (Principal ID: 1) " +
        "to alice@example.net (Principal ID: 1).\n" +
      "DovecotMv - Moved user alice@example.com " +
        "(#{cfg.dovecot_mail_root()}/example.com/alice) to " +
        "alice@example.net (#{cfg.dovecot_mail_root()}/example.net/alice).\n" +
      "PostfixadminMv - Moved user alice@example.com to alice@example.net.\n" +
      "RoundcubeMv - Moved user alice@example.com (User ID: 1) to " +
        "alice@example.net (User ID: 1).\n"

    assert_equal(expected, actual)

    # Now check the database.

    dmv = DavicalMv.new(cfg)
    actual = dmv.list_users()
    expected = [User.new('alice@example.net'), User.new('booger@example.com')]
    assert_equal(expected.sort(), actual.sort())

    pfamv = PostfixadminMv.new(cfg)
    actual = pfamv.list_users()
    expected = [User.new('alice@example.net'),
                User.new('bob@example.com'),
                User.new('adam@example.net'),
                User.new('beth@example.net'),
                User.new('carol@example.net')]
    assert_equal(expected.sort(), actual.sort())

    actual = pfamv.list_domains()
    expected = [Domain.new('example.com'), Domain.new('example.net')]
    assert_equal(expected.sort(), actual.sort())

    actual = pfamv.list_aliases()
    expected = [{'address' => 'adam@example.net',
                 'goto' => 'adam@example.net'},
                {'address' => 'alice@example.net',
                 'goto' => 'alice@example.net,' +
                           'adam@example.net,' +
                           'bob@example.com,' +
                           'carol@example.net'},
                {'address' => 'beth@example.net',
                 'goto' => 'beth@example.net'},
                {'address' => 'bob@example.com',
                 'goto' => 'bob@example.com'},
                {'address' => 'carol@example.net',
                 'goto' => 'carol@example.net'}]
    expected.each { |e| assert(actual.include?(e)) } # can't sort dicts
    actual.each { |a| assert(expected.include?(a)) } # can't sort dicts


    rmv = RoundcubeMv.new(cfg)
    actual = rmv.list_users()
    expected = [User.new('alice@example.net'),
                User.new('booger@example.com'),
                User.new('adam@example.net')]
    assert_equal(expected.sort(), actual.sort())

    # All the maildirs are still there.
    assert(maildir_exists('example.net/alice'))
    assert(maildir_exists('example.com/booger'))
    assert(maildir_exists('example.com/jeremy'))
    assert(maildir_exists('example.net/adam'))
  end


  def test_mv_twice
    #
    # If we move a user and then move it back, we should wind up back
    # where we started.
    #
    cfg = configuration()
    src = User.new("alice@example.com")
    dst = User.new("alice@example.net")

    output_buffer = StringIO.new()

    $stdout = output_buffer
    MvPlugin.run(cfg, src, dst)
    MvPlugin.run(cfg, dst, src)
    $stdout = STDOUT

    # Skip output verification, it's ugly. But make sure the database
    # has what we expect.

    dmv = DavicalMv.new(cfg)
    actual = dmv.list_users()
    expected = [User.new('alice@example.com'), User.new('booger@example.com')]
    assert_equal(expected.sort(), actual.sort())

    pfamv = PostfixadminMv.new(cfg)
    actual = pfamv.list_users()
    expected = [User.new('alice@example.com'),
                User.new('bob@example.com'),
                User.new('adam@example.net'),
                User.new('beth@example.net'),
                User.new('carol@example.net')]
    assert_equal(expected.sort(), actual.sort())

    actual = pfamv.list_domains()
    expected = [Domain.new('example.com'), Domain.new('example.net')]
    assert_equal(expected.sort(), actual.sort())

    actual = pfamv.list_aliases()
    expected = [{'address' => 'adam@example.net',
                 'goto' => 'adam@example.net'},
                {'address' => 'alice@example.com',
                 'goto' => 'alice@example.com,' +
                           'adam@example.net,' +
                           'bob@example.com,' +
                           'carol@example.net'},
                {'address' => 'beth@example.net',
                 'goto' => 'beth@example.net'},
                {'address' => 'bob@example.com',
                 'goto' => 'bob@example.com'},
                {'address' => 'carol@example.net',
                 'goto' => 'carol@example.net'}]
    expected.each { |e| assert(actual.include?(e)) } # can't sort dicts
    actual.each { |a| assert(expected.include?(a)) } # can't sort dicts


    rmv = RoundcubeMv.new(cfg)
    actual = rmv.list_users()
    expected = [User.new('alice@example.com'),
                User.new('booger@example.com'),
                User.new('adam@example.net')]
    assert_equal(expected.sort(), actual.sort())

    # All the maildirs are still there.
    assert(maildir_exists('example.com/alice'))
    assert(maildir_exists('example.com/booger'))
    assert(maildir_exists('example.com/jeremy'))
    assert(maildir_exists('example.net/adam'))
  end

end
