require 'common/runner'

# Dummy implementation of a {RmRunner}. Its <tt>run()</tt> method will
# tell you what would have been removed, but will not actually perform
# the operation.
#
class RmDummyRunner
  include Runner


  # Pretend to remove *targets*. Some "what if"
  # information will be output to stdout.
  #
  # This dummy runner is not particularly useful on its own. About the
  # only thing it does is let you know that the users/domains in
  # *targets* do in fact exist (through their descriptions). It's used
  # to good effect by {PruneDummyRunner}, though.
  #
  # @param cfg [Configuration] the configuration options to pass to
  #   the *plugin* we're runnning.
  #
  # @param plugin [RmPlugin] plugin that will perform the move.
  #
  # @param targets [Array<User,Domain>] the users and domains to be
  #   removed.
  #
  def run(cfg, plugin, *targets)
    targets.each do |target|
      target_description = plugin.describe(target)
      msg =  "Would remove #{target.class.to_s().downcase()} "
      msg += add_description(target, target_description)
      msg += '.'

      report(plugin, msg)
    end

  end

end
