require 'pg'

require 'common/davical_plugin'
require 'rm/rm_plugin'

# Handle the removal of DAViCal users from its database. DAViCal has
# no concept of domains.
#
class DavicalRm

  include DavicalPlugin
  include RmPlugin


  # Remove *user* from the DAViCal database. This should remove him
  # from _every_ table in which he is referenced. Fortunately, DAViCal
  # uses foreign keys properly (and only supports postgres, where they
  # work!), so we can let the ON DELETE CASCADE trigger handle most of
  # the work.
  #
  # @param user [User] the user to remove.
  #
  def remove_user(user)
    raise NonexistentUserError.new(user.to_s()) if not user_exists(user)

    sql_query = 'DELETE FROM usr WHERE username = $1;'

    connection = PG::Connection.new(@db_hash)
    begin
      connection.sync_exec_params(sql_query, [user.to_s()])
    ensure
      # Make sure the connection gets closed even if the query explodes.
      connection.close()
    end
  end


end
