require 'common/runner'

# Dummy implementation of a {MvRunner}. Its <tt>run()</tt> method will
# tell you what would have been moved, but will not actually perform
# the operation.
#
class MvDummyRunner
  include Runner

  # Pretend to move *src* to *dst* with *plugin*. Some "what if"
  # information will be output to stdout. This is useful to see if
  # there would be (for example) a username collision at *dst* before
  # attempting the move in earnest.
  #
  # @param cfg [Configuration] the configuration options to pass to
  #   the *plugin* we're runnning.
  #
  # @param plugin [Class] plugin class that will perform the move.
  #
  # @param src [User] the source user to be moved.
  #
  # @param dst [User] the destination user, to which we will move *src*.
  #
  def run(cfg, plugin, src, dst)

    if src.is_a?(Domain) or dst.is_a?(Domain) then
      msg = 'only users can be moved'
      raise NotImplementedError.new(msg)
    end

    # Since we're not actually moving anything, the destination
    # description is really only useful for seeing whether or not we'd
    # be trying to move in on top of an existing account.
    src_description = plugin.describe(src)
    dst_description = plugin.describe(dst)

    msg  = "Would move user "
    msg += add_description(src, src_description)
    msg += " to "
    add_description(dst, dst_description)
    msg += "."
    report(plugin, msg)
  end

end
