/*
  Copyright (C) 2009 to 2013 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <algorithm>

#include "tray_icon.h"

#ifdef ENABLE_NLS
#include <libintl.h>
#endif


class TrayIcon::CB {
public:
  static void tray_icon_popup(guint button,
			      guint time,
			      void* data) {
    gtk_menu_popup(GTK_MENU(static_cast<TrayIcon*>(data)->menu.get()), 0, 0, 0, 0,
		   button, time);
  }
};

extern "C" {

  static void tray_icon_popup_cb(GtkStatusIcon*,
				 guint button,
				 guint time,
				 void* data) {
    TrayIcon::CB::tray_icon_popup(button, time, data);
  }

  static void tray_icon_activated_cb(GtkStatusIcon*,
				     void* data) {
    static_cast<TrayIcon*>(data)->activate_cb();
  }

  static void popup_item_activated_cb(GtkMenuItem*,
				      void* data) {
    static_cast<const Callback::Callback*>(data)->dispatch();
  }

  static void delete_data_cb(void* data,
			     GClosure*) {
    delete static_cast<Callback::Callback*>(data);
  }

} // extern "C"

TrayIcon::TrayIcon(): status_icon(gtk_status_icon_new()),
		      menu(gtk_menu_new()) {

  GtkWidget* image;
  GtkMenuItem* item;

  image = gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU);
  item =
    GTK_MENU_ITEM(gtk_image_menu_item_new_with_label(gettext("Preferences")));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
                                image);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu.get()), GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(item));
  g_signal_connect_data(G_OBJECT(item), "activate",
			G_CALLBACK(popup_item_activated_cb),
			Callback::make(*this, &TrayIcon::popup_item_impl, prefs),
			delete_data_cb, GConnectFlags(0));

  image = gtk_image_new_from_stock(GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU);
  item =
    GTK_MENU_ITEM(gtk_image_menu_item_new_with_label(gettext("Edit devices")));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
                                image);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu.get()), GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(item));
  g_signal_connect_data(G_OBJECT(item), "activate",
			G_CALLBACK(popup_item_activated_cb),
			Callback::make(*this, &TrayIcon::popup_item_impl, devices),
			delete_data_cb, GConnectFlags(0));

  image = gtk_image_new_from_stock(GTK_STOCK_ABOUT, GTK_ICON_SIZE_MENU);
  item =
    GTK_MENU_ITEM(gtk_image_menu_item_new_with_label(gettext("About")));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
                                image);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu.get()), GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(item));
  g_signal_connect_data(G_OBJECT(item), "activate",
			G_CALLBACK(popup_item_activated_cb),
			Callback::make(*this, &TrayIcon::popup_item_impl, about),
			delete_data_cb, GConnectFlags(0));

  // insert separator
  GtkWidget* separator_item = gtk_separator_menu_item_new();
  gtk_menu_shell_append(GTK_MENU_SHELL(menu.get()), separator_item);
  gtk_widget_show(separator_item);

  image = gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
  item = 
    GTK_MENU_ITEM(gtk_image_menu_item_new_with_label(gettext("Quit")));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
                                image);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu.get()), GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(item));
  g_signal_connect_data(G_OBJECT(item), "activate",
			G_CALLBACK(popup_item_activated_cb),
			Callback::make(*this, &TrayIcon::popup_item_impl, quit),
			delete_data_cb, GConnectFlags(0));

  // have an icon size of between 22 and 38 pixels
  int icon_size = std::max(std::min(gtk_status_icon_get_size(status_icon), 40) - 2, 22);
  { // scope block for the GobjHandle
    GobjHandle<GdkPixbuf> pixbuf{gdk_pixbuf_scale_simple(prog_config.window_icon,
							 icon_size, icon_size, GDK_INTERP_HYPER)};
    gtk_status_icon_set_from_pixbuf(status_icon, pixbuf);
  }

  g_signal_connect(G_OBJECT(status_icon.get()), "activate",
                   G_CALLBACK(tray_icon_activated_cb), this);

  g_signal_connect(G_OBJECT(status_icon.get()), "popup-menu",
                   G_CALLBACK(tray_icon_popup_cb), this);

}

void TrayIcon::popup_item_impl(MenuItem item) {
  popup_cb(item);
}

bool TrayIcon::is_embedded() {

  gboolean embedded = false;
  if (status_icon.get()) {
    g_object_get(status_icon.get(),
		 "embedded", &embedded,
		 static_cast<void*>(0));
  }
  return embedded;
}
