/*
  Copyright (C) 2009 to 2013 and 2005 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "prog_defs.h"

#include <vector>
#include <string>
#include <utility>
#include <memory>
#include <set>

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "mounter.h"
#include "tray_icon.h"

#include <c++-gtk-utils/window.h>
#include <c++-gtk-utils/shared_ptr.h>
#include <c++-gtk-utils/cgu_config.h>

struct MountItem {
  std::string device;
  std::string label;
  GtkWidget* button;
};

namespace MainWindowCB {
  extern "C" {
    void mainwin_tool_button_clicked(GtkToolButton*, void*);
    void mainwin_mount_button_clicked(GtkWidget*, void*);
    void mainwin_noentries_button_clicked(GtkWidget*, void*);
    gboolean mainwin_visibility_notify_event(GtkWidget*, GdkEventVisibility*, void*);
    gboolean mainwin_window_state_event(GtkWidget*, GdkEventWindowState*, void*);
    void mainwin_delete_data(void*, GClosure*);
#if GTK_CHECK_VERSION(2,99,0)
    void mainwin_button_style_updated(GtkWidget*, void*);
    gboolean mainwin_drawing_area_draw(GtkWidget*, cairo_t*, void*);
#else
    void mainwin_button_style_set(GtkWidget*, GtkStyle*, void*);
    gboolean mainwin_drawing_area_expose_event(GtkWidget*, GdkEventExpose*, void*);
#endif
  }
}


// functor which is part of the MainWindow class implementation and
// is declared a friend below
class DisplayMountpointFunc;

class MainWindow: public WinBase {
  std::vector<SharedPtr<MountItem> > mount_list;
  std::set<GtkWidget*> button_set;

  Mounter mounter;

  GtkToolButton* prefs_button;
  GtkToolButton* mount_entries_button;
  GtkToolButton* about_button;
  GtkToolButton* quit_button;

  GtkWidget* gui_vbox;
  GtkWidget* button_vbox;

  std::unique_ptr<TrayIcon> tray_icon_a;

  std::pair<int, int> button_extents; // first = width, second = height

  bool obscured;
  bool minimised;

  bool in_dialog;

  gulong button_style_connection;

  std::pair<int, int> get_max_button_text_extents();
  std::pair<int, int> get_max_button_padding_extents();
  void populate_mount_points();
  void prefs_impl();
  void mount_entries_impl();
  void about_impl();
  void button_cb(int);
  GtkWidget* get_noentries_widget();
  void make_tray_icon();
  void reset_mount_tooltips() const;
  void reset_mount_tooltips_item(const SharedPtr<MountItem>&) const;
  void refresh_display_item(const SharedPtr<MountItem>&) const;
  void set_button_size(const SharedPtr<MountItem>&) const;
  void display_mount_points();
  void start_hidden_check_cb(bool&);

#if GTK_CHECK_VERSION(2,99,0)
  static bool draw_mount_indicator(GtkWidget*, cairo_t*);
#else
  static bool draw_mount_indicator(GtkWidget*, GdkEventExpose*);
  void button_style_set_impl(GtkStyle*);
#endif
  void button_style_updated_impl();

protected:
  virtual void on_delete_event();
public:
  // Objects of this class are not for copying
  MainWindow(const MainWindow&) = delete;
  MainWindow& operator=(const MainWindow&) = delete;

  friend void MainWindowCB::mainwin_tool_button_clicked(GtkToolButton*, void*);
  friend void MainWindowCB::mainwin_mount_button_clicked(GtkWidget*, void*);
  friend void MainWindowCB::mainwin_noentries_button_clicked(GtkWidget*, void*);
  friend gboolean MainWindowCB::mainwin_visibility_notify_event(GtkWidget*,
                                                                GdkEventVisibility*, void*);
  friend gboolean MainWindowCB::mainwin_window_state_event(GtkWidget*,
                                                           GdkEventWindowState*, void*);
  friend void MainWindowCB::mainwin_delete_data(void*, GClosure*);

#if GTK_CHECK_VERSION(2,99,0)
  friend void MainWindowCB::mainwin_button_style_updated(GtkWidget*, void*);
  friend gboolean MainWindowCB::mainwin_drawing_area_draw(GtkWidget*,
							  cairo_t*, void*);
#else
  friend void MainWindowCB::mainwin_button_style_set(GtkWidget*, GtkStyle*, void*);
  friend gboolean MainWindowCB::mainwin_drawing_area_expose_event(GtkWidget*, GdkEventExpose*, void*);
#endif

  friend class DisplayMountpointFunc;

  // these need to be public to export them as closures with Callback::Callback
  void refresh_display() const;
  void operation_fail(GtkWidget*);
  void tray_icon_activate();
  void tray_icon_action(TrayIcon::MenuItem);

  void present();

  MainWindow(bool start_hidden);
};

#endif
