/*
  Copyright (C) 2009 to 2014 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/


#include "dialogs.h"

#ifdef ENABLE_NLS
#include <libintl.h>
#endif

const int standard_size = 24;

void InfoDialogCB::info_dialog_selected(GtkDialog*, int, void* data) {
  static_cast<InfoDialog*>(data)->close();
}

InfoDialog::InfoDialog(const char* text, const char* caption,
                       GtkMessageType message_type, GtkWindow* parent, bool modal):
                       WinBase(caption, prog_config.window_icon,
			       modal, parent,
			       GTK_WINDOW(gtk_message_dialog_new(0, GtkDialogFlags(0),
								 message_type,
								 GTK_BUTTONS_CLOSE,
								 "%s", text))) {

  // make further specialisations for a message dialog object

#if GTK_CHECK_VERSION(2,14,0)
  GtkWidget* action_area = gtk_dialog_get_action_area(GTK_DIALOG(get_win()));
#else
  GtkWidget* action_area = GTK_DIALOG(get_win())->action_area;
#endif
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area),
			    GTK_BUTTONBOX_SPREAD);

  gtk_window_set_type_hint(get_win(), GDK_WINDOW_TYPE_HINT_DIALOG);

  g_signal_connect(G_OBJECT(get_win()), "response",
		   G_CALLBACK(InfoDialogCB::info_dialog_selected), this);

  gtk_window_set_position(get_win(), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_resizable(get_win(), false);

  gtk_widget_show_all(GTK_WIDGET(get_win()));
}

void InfoDialog::on_delete_event() {
  // the response event handler will cause close() to be called for
  // the GTK_RESPONSE_DELETE_EVENT id, so just return when we
  // subsequently get the delete event
  return;
}


void PromptDialogCB::prompt_dialog_selected(GtkDialog*, int id, void* data) {
  PromptDialog* instance = static_cast<PromptDialog*>(data);
  if (id == GTK_RESPONSE_ACCEPT) {
    instance->result = true;
    instance->close();
  }
  else if (id == GTK_RESPONSE_REJECT) {
    instance->result = false;
    instance->close();
  }
}

PromptDialog::PromptDialog(const char* text, const char* caption,
			   GtkWindow* parent, bool modal):
                           WinBase(caption, prog_config.window_icon,
				   modal, parent,
				   GTK_WINDOW(gtk_dialog_new_with_buttons(0, 0,
#if GTK_CHECK_VERSION(2,99,0)
						  GtkDialogFlags(0),
#else
						  GTK_DIALOG_NO_SEPARATOR,
#endif
						  GTK_STOCK_CANCEL,
						  GTK_RESPONSE_REJECT,
						  GTK_STOCK_OK,
						  GTK_RESPONSE_ACCEPT,
						  static_cast<void*>(0)))),
			   result(false) {

  GtkWidget* label = gtk_label_new(text);
  gtk_label_set_line_wrap(GTK_LABEL(label), true);
  gtk_misc_set_padding(GTK_MISC(label), standard_size/2, standard_size/2);
#if GTK_CHECK_VERSION(2,14,0)
  GtkWidget* content_area = gtk_dialog_get_content_area(GTK_DIALOG(get_win()));
#else
  GtkWidget* content_area = GTK_DIALOG(get_win())->vbox;
#endif
  gtk_container_add(GTK_CONTAINER(content_area), 
		    label);

  gtk_dialog_set_default_response(GTK_DIALOG(get_win()), GTK_RESPONSE_ACCEPT);

  gtk_window_set_type_hint(get_win(), GDK_WINDOW_TYPE_HINT_DIALOG);

  g_signal_connect(G_OBJECT(get_win()), "response",
		   G_CALLBACK(PromptDialogCB::prompt_dialog_selected), this);

  gtk_window_set_position(get_win(), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_resizable(get_win(), false);

  gtk_widget_show_all(GTK_WIDGET(get_win()));
}

int PromptDialog::get_exec_val() const {
  return result;
}

void PromptDialog::on_delete_event() {
  result = false;
  close();
}


void AboutDialogCB::about_dialog_selected(GtkDialog*, int, void* data) {
  static_cast<AboutDialog*>(data)->close();
}

AboutDialog::AboutDialog(GtkWindow* parent, bool modal):
                         WinBase(gettext("About mount-gtk"), prog_config.window_icon,
				 modal, parent,
				 GTK_WINDOW(gtk_about_dialog_new())) {

#if GTK_CHECK_VERSION(2,14,0)
  GtkWidget* action_area = gtk_dialog_get_action_area(GTK_DIALOG(get_win()));
#else
  GtkWidget* action_area = GTK_DIALOG(get_win())->action_area;
#endif
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area),
			    GTK_BUTTONBOX_SPREAD);

  gtk_window_set_type_hint(get_win(), GDK_WINDOW_TYPE_HINT_DIALOG);

  g_signal_connect(G_OBJECT(get_win()), "response",
		   G_CALLBACK(AboutDialogCB::about_dialog_selected), this);

  gtk_window_set_resizable(get_win(), false);

  if (parent && modal) gtk_window_set_position(get_win(), GTK_WIN_POS_CENTER_ON_PARENT);

  gtk_about_dialog_set_program_name(GTK_ABOUT_DIALOG(get_win()), "mount-gtk");
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(get_win()), VERSION);
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(get_win()),
				 gettext("Copyright (C) 2009 - 2020 Chris Vine"));
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(get_win()),
				gettext("This program is a front end for udisks2 and mount. "
					"It is released under the GNU General "
					"Public License, version 2"));
  gtk_about_dialog_set_logo(GTK_ABOUT_DIALOG(get_win()), prog_config.window_icon);

  gtk_widget_show_all(GTK_WIDGET(get_win()));
}

void AboutDialog::on_delete_event() {
  // the response event handler will cause close() to be called for
  // the GTK_RESPONSE_DELETE_EVENT id, so just return when we
  // subsequently get the delete event
  return;
}
