/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Spliterator;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.ColumnView;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.ElementView2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.RowView;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public interface Access2D<N extends Comparable<N>>
extends Structure2D,
Access1D<N> {
    public static Access2D<Double> asPrimitive2D(final Access2D<?> access) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return access.doubleValue(row, col);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long row, long col) {
                return access.doubleValue(row, col);
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    public static boolean equals(Access2D<?> accessA, Access2D<?> accessB, NumberContext accuracy) {
        return accessA.countRows() == accessB.countRows() && accessA.countColumns() == accessB.countColumns() && Access1D.equals(accessA, accessB, accuracy);
    }

    @Deprecated
    public static boolean isHermitian(Access2D<?> matrix) {
        boolean retVal;
        long rows = matrix.countRows();
        long cols = matrix.countColumns();
        Object anyElement = matrix.get(0L);
        boolean bl = retVal = rows == cols;
        if (anyElement instanceof ComplexNumber) {
            int j = 0;
            while (retVal && (long)j < cols) {
                double imagDiag = ComplexNumber.valueOf(matrix.get((long)((long)j), (long)((long)j))).i;
                retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, imagDiag);
                int i = j + 1;
                while (retVal && (long)i < rows) {
                    ComplexNumber lowerLeft = ComplexNumber.valueOf(matrix.get(i, j)).conjugate();
                    ComplexNumber upperRight = ComplexNumber.valueOf(matrix.get(j, i));
                    double diff = lowerLeft.subtract(upperRight).norm();
                    double sum = lowerLeft.add(upperRight).norm();
                    retVal &= PrimitiveScalar.isSmall(sum, diff);
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (retVal && (long)j < cols) {
                int i = j + 1;
                while (retVal && (long)i < rows) {
                    double lowerLeft = matrix.doubleValue(i, j);
                    double upperRight = matrix.doubleValue(j, i);
                    double diff = lowerLeft - upperRight;
                    double sum = lowerLeft + upperRight;
                    retVal &= PrimitiveScalar.isSmall(sum, diff);
                    ++i;
                }
                ++j;
            }
        }
        return retVal;
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveColumnCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return 1L;
            }

            @Override
            public long countRows() {
                return anything1D.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(nz.index(), 0L, nz.doubleValue()));
            }
        };
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveRowCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return anything1D.count();
            }

            @Override
            public long countRows() {
                return 1L;
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(0L, nz.index(), nz.doubleValue()));
            }
        };
    }

    public static String toString(Access2D<?> matrix) {
        StringBuilder builder = new StringBuilder();
        int numbRows = Math.toIntExact(matrix.countRows());
        int numbCols = Math.toIntExact(matrix.countColumns());
        builder.append(matrix.getClass().getName());
        builder.append(' ').append('<').append(' ').append(numbRows).append(' ').append('x').append(' ').append(numbCols).append(' ').append('>');
        if (numbRows > 0 && numbCols > 0 && numbRows <= 50 && numbCols <= 50 && numbRows * numbCols <= 200) {
            builder.append("\n{ { ").append(matrix.get(0L, 0L));
            for (int j = 1; j < numbCols; ++j) {
                builder.append(",\t").append(matrix.get(0L, j));
            }
            for (int i = 1; i < numbRows; ++i) {
                builder.append(" },\n{ ").append(matrix.get(i, 0L));
                for (int j = 1; j < numbCols; ++j) {
                    builder.append(",\t").append(matrix.get(i, j));
                }
            }
            builder.append(" } }");
        }
        return builder.toString();
    }

    public static Access2D<Double> wrap(final double[][] target) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return Structure2D.count(target.length, target[0].length);
            }

            @Override
            public long countColumns() {
                return target[0].length;
            }

            @Override
            public long countRows() {
                return target.length;
            }

            @Override
            public double doubleValue(long row, long col) {
                return target[(int)row][(int)col];
            }

            @Override
            public Double get(long row, long col) {
                return target[(int)row][(int)col];
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    public static <N extends Comparable<N>> Access2D<N> wrap(N[][] target) {
        return new Access2D<N>((Comparable[][])target){
            final /* synthetic */ Comparable[][] val$target;
            {
                this.val$target = comparableArray;
            }

            @Override
            public long count() {
                return Structure2D.count(this.val$target.length, this.val$target[0].length);
            }

            @Override
            public long countColumns() {
                return this.val$target[0].length;
            }

            @Override
            public long countRows() {
                return this.val$target.length;
            }

            @Override
            public double doubleValue(long index) {
                return NumberDefinition.doubleValue(this.get(index));
            }

            @Override
            public double doubleValue(long row, long col) {
                return NumberDefinition.doubleValue(this.get(row, col));
            }

            @Override
            public N get(long row, long col) {
                return this.val$target[(int)row][(int)col];
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    default public <NN extends Comparable<NN>, R extends Mutate2D.Receiver<NN>> Collectable<NN, R> asCollectable2D() {
        return new Collectable<NN, R>(){

            @Override
            public long countColumns() {
                return Access2D.this.countColumns();
            }

            @Override
            public long countRows() {
                return Access2D.this.countRows();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access2D.this);
            }
        };
    }

    @Override
    default public byte byteValue(long index) {
        long structure = this.countRows();
        return this.byteValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public byte byteValue(long row, long col) {
        return (byte)this.shortValue(row, col);
    }

    default public ColumnView<N> columns() {
        return new ColumnView(this);
    }

    @Override
    default public double doubleValue(long index) {
        long structure = this.countRows();
        long row = Structure2D.row(index, structure);
        long col = Structure2D.column(index, structure);
        return this.doubleValue(row, col);
    }

    public double doubleValue(long var1, long var3);

    @Override
    default public ElementView2D<N, ?> elements() {
        return new ElementView(Access1D.super.elements(), this.countRows());
    }

    @Override
    default public float floatValue(long index) {
        long structure = this.countRows();
        return this.floatValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public float floatValue(long row, long col) {
        return (float)this.doubleValue(row, col);
    }

    @Override
    default public N get(long index) {
        long tmpStructure = this.countRows();
        return this.get(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
    }

    public N get(long var1, long var3);

    @Override
    default public int intValue(long index) {
        long structure = this.countRows();
        return this.intValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public int intValue(long row, long col) {
        return (int)this.longValue(row, col);
    }

    @Override
    default public long longValue(long index) {
        long structure = this.countRows();
        return this.longValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public long longValue(long row, long col) {
        return Math.round(this.doubleValue(row, col));
    }

    @Override
    default public ElementView2D<N, ?> nonzeros() {
        return new ElementView(Access1D.super.nonzeros(), this.countRows());
    }

    default public RowView<N> rows() {
        return new RowView(this);
    }

    @Override
    default public short shortValue(long index) {
        long structure = this.countRows();
        return this.shortValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public short shortValue(long row, long col) {
        return (short)this.intValue(row, col);
    }

    default public double[][] toRawCopy2D() {
        int tmpRowDim = (int)this.countRows();
        int tmpColDim = (int)this.countColumns();
        double[][] retVal = new double[tmpRowDim][tmpColDim];
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRow = retVal[i];
            for (int j = 0; j < tmpColDim; ++j) {
                tmpRow[j] = this.doubleValue(i, j);
            }
        }
        return retVal;
    }

    public static interface Visitable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Visitable<N> {
        default public void visitColumn(long row, long col, VoidFunction<N> visitor) {
            this.loopColumn(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitColumn(long col, VoidFunction<N> visitor) {
            this.visitColumn(0L, col, visitor);
        }

        default public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
            this.loopDiagonal(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitDiagonal(VoidFunction<N> visitor) {
            this.visitDiagonal(0L, 0L, visitor);
        }

        public void visitOne(long var1, long var3, VoidFunction<N> var5);

        @Override
        default public void visitOne(long index, VoidFunction<N> visitor) {
            long tmpStructure = this.countRows();
            this.visitOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), visitor);
        }

        default public void visitRow(long row, long col, VoidFunction<N> visitor) {
            this.loopRow(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitRow(long row, VoidFunction<N> visitor) {
            this.visitRow(row, 0L, visitor);
        }
    }

    public static interface Sliceable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Sliceable<N> {
        default public Access1D<N> sliceColumn(long col) {
            return this.sliceColumn(0L, col);
        }

        public Access1D<N> sliceColumn(long var1, long var3);

        default public Access1D<N> sliceDiagonal() {
            return this.sliceDiagonal(0L, 0L);
        }

        public Access1D<N> sliceDiagonal(long var1, long var3);

        default public Access1D<N> sliceRow(long row) {
            return this.sliceRow(row, 0L);
        }

        public Access1D<N> sliceRow(long var1, long var3);
    }

    public static class ElementView<N extends Comparable<N>>
    implements ElementView2D<N, ElementView<N>> {
        private final ElementView1D<N, ?> myDelegate;
        private final long myStructure;

        public ElementView(ElementView1D<N, ?> delegate, long structure) {
            this.myDelegate = delegate;
            this.myStructure = structure;
        }

        @Override
        public long column() {
            return Structure2D.column(this.myDelegate.index(), this.myStructure);
        }

        @Override
        public double doubleValue() {
            return this.myDelegate.doubleValue();
        }

        @Override
        public long estimateSize() {
            return this.myDelegate.estimateSize();
        }

        @Override
        public N get() {
            return (N)((Comparable)this.myDelegate.get());
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate.hasPrevious();
        }

        @Override
        public long index() {
            return this.myDelegate.index();
        }

        @Override
        public ElementView<N> iterator() {
            return new ElementView<N>(this.myDelegate.iterator(), this.myStructure);
        }

        @Override
        public ElementView<N> next() {
            this.myDelegate.next();
            return this;
        }

        @Override
        public long nextIndex() {
            return this.myDelegate.nextIndex();
        }

        @Override
        public ElementView<N> previous() {
            this.myDelegate.previous();
            return this;
        }

        @Override
        public long previousIndex() {
            return this.myDelegate.previousIndex();
        }

        @Override
        public long row() {
            return Structure2D.row(this.myDelegate.index(), this.myStructure);
        }

        @Override
        public ElementView<N> trySplit() {
            Spliterator delegateSpliterator = this.myDelegate.trySplit();
            if (delegateSpliterator != null) {
                return new ElementView<N>(delegateSpliterator, this.myStructure);
            }
            return null;
        }
    }

    public static interface Collectable<N extends Comparable<N>, R extends Mutate2D>
    extends Structure2D {
        default public <I extends R> I collect(Factory2D<I> factory) {
            Mutate2D retVal = (Mutate2D)factory.make(this.countRows(), this.countColumns());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Aggregatable<N> {
        default public N aggregateColumn(long col, Aggregator aggregator) {
            return this.aggregateColumn(0L, col, aggregator);
        }

        public N aggregateColumn(long var1, long var3, Aggregator var5);

        default public N aggregateDiagonal(Aggregator aggregator) {
            return this.aggregateDiagonal(0L, 0L, aggregator);
        }

        public N aggregateDiagonal(long var1, long var3, Aggregator var5);

        default public N aggregateRow(long row, Aggregator aggregator) {
            return this.aggregateRow(row, 0L, aggregator);
        }

        public N aggregateRow(long var1, long var3, Aggregator var5);

        default public void reduceColumns(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countColumns(), receiver.count());
            for (long j = 0L; j < limit; ++j) {
                receiver.set(j, (Comparable<?>)this.aggregateColumn(j, aggregator));
            }
        }

        default public void reduceRows(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countRows(), receiver.count());
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.aggregateRow(i, aggregator));
            }
        }
    }
}

