/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.scalar.PrimitiveScalar;

public class Gamma
extends RandomNumber {
    private final double myShape;
    private final double myRate;

    public Gamma() {
        this(PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Gamma(double aShape, double aRate) {
        this.myShape = aShape;
        this.myRate = aRate;
    }

    @Override
    public double getExpected() {
        return this.myShape / this.myRate;
    }

    @Override
    public double getVariance() {
        return this.myShape / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        int tmpInteger = (int)this.myShape;
        double tmpFraction = this.myShape - (double)tmpInteger;
        double tmpIntegralPart = PrimitiveMath.ZERO;
        for (int i = 0; i < tmpInteger; ++i) {
            tmpIntegralPart -= PrimitiveMath.LOG.invoke(this.random().nextDouble());
        }
        double tmpFractionalPart = PrimitiveMath.ZERO;
        if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpFraction)) {
            double tmpDenom;
            double tmpNumer;
            double tmpFractionMinusOne = tmpFraction - PrimitiveMath.ONE;
            do {
                tmpFractionalPart = -PrimitiveMath.TWO * PrimitiveMath.LOG.invoke(PrimitiveMath.ONE - PrimitiveMath.POW.invoke(this.random().nextDouble(), PrimitiveMath.ONE / tmpFraction));
                double tmpNegHalfFraction = -tmpFractionalPart / PrimitiveMath.TWO;
                tmpNumer = PrimitiveMath.POW.invoke(tmpFractionalPart, tmpFractionMinusOne) * PrimitiveMath.EXP.invoke(tmpNegHalfFraction);
                tmpDenom = PrimitiveMath.POW.invoke(PrimitiveMath.TWO, tmpFractionMinusOne) * PrimitiveMath.POW.invoke(-PrimitiveMath.EXPM1.invoke(tmpNegHalfFraction), tmpFractionMinusOne);
            } while (this.random().nextDouble() > tmpNumer / tmpDenom);
        }
        return (tmpIntegralPart + tmpFractionalPart) / this.myRate;
    }
}

