/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.Mutator2D;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Structure2D;

public final class ComplexMatrix
extends BasicMatrix<ComplexNumber, ComplexMatrix> {
    public static final Factory FACTORY = new Factory();

    ComplexMatrix(ElementsSupplier<ComplexNumber> supplier) {
        super(FACTORY.getPhysicalFactory(), supplier);
    }

    public DenseReceiver copy() {
        return new DenseReceiver(this.store().copy());
    }

    public Primitive64Matrix getArgument() {
        return (Primitive64Matrix)Primitive64Matrix.FACTORY.instantiate(Primitive64Store.getComplexArgument(this.store()));
    }

    public Primitive64Matrix getImaginary() {
        return (Primitive64Matrix)Primitive64Matrix.FACTORY.instantiate(Primitive64Store.getComplexImaginary(this.store()));
    }

    public Primitive64Matrix getModulus() {
        return (Primitive64Matrix)Primitive64Matrix.FACTORY.instantiate(Primitive64Store.getComplexModulus(this.store()));
    }

    public Primitive64Matrix getReal() {
        return (Primitive64Matrix)Primitive64Matrix.FACTORY.instantiate(Primitive64Store.getComplexReal(this.store()));
    }

    @Override
    Cholesky<ComplexNumber> newCholesky(Structure2D typical) {
        return (Cholesky)Cholesky.COMPLEX.make(typical);
    }

    @Override
    DeterminantTask<ComplexNumber> newDeterminantTask(Structure2D template) {
        return DeterminantTask.COMPLEX.make(template, this.isHermitian(), false);
    }

    @Override
    Eigenvalue<ComplexNumber> newEigenvalue(Structure2D typical) {
        return Eigenvalue.COMPLEX.make(typical, this.isHermitian());
    }

    @Override
    ComplexMatrix newInstance(ElementsSupplier<ComplexNumber> store) {
        return new ComplexMatrix(store);
    }

    @Override
    InverterTask<ComplexNumber> newInverterTask(Structure2D base) {
        return InverterTask.COMPLEX.make(base, this.isHermitian(), false);
    }

    @Override
    LDL<ComplexNumber> newLDL(Structure2D typical) {
        return (LDL)LDL.COMPLEX.make(typical);
    }

    @Override
    LU<ComplexNumber> newLU(Structure2D typical) {
        return (LU)LU.COMPLEX.make(typical);
    }

    @Override
    QR<ComplexNumber> newQR(Structure2D typical) {
        return QR.COMPLEX.make(typical);
    }

    @Override
    SingularValue<ComplexNumber> newSingularValue(Structure2D typical) {
        return SingularValue.COMPLEX.make(typical);
    }

    @Override
    SolverTask<ComplexNumber> newSolverTask(Structure2D templateBody, Structure2D templateRHS) {
        return SolverTask.COMPLEX.make(templateBody, templateRHS, this.isHermitian(), false);
    }

    public static final class SparseReceiver
    extends Mutator2D<ComplexNumber, ComplexMatrix, SparseStore<ComplexNumber>> {
        SparseReceiver(SparseStore<ComplexNumber> delegate) {
            super(delegate);
        }

        @Override
        ComplexMatrix instantiate(MatrixStore<ComplexNumber> store) {
            return (ComplexMatrix)FACTORY.instantiate(store);
        }
    }

    public static final class Factory
    extends MatrixFactory<ComplexNumber, ComplexMatrix, DenseReceiver, SparseReceiver> {
        Factory() {
            super(ComplexMatrix.class, GenericStore.COMPLEX);
        }

        @Override
        DenseReceiver dense(PhysicalStore<ComplexNumber> store) {
            return new DenseReceiver(store);
        }

        @Override
        SparseReceiver sparse(SparseStore<ComplexNumber> store) {
            return new SparseReceiver(store);
        }
    }

    public static final class DenseReceiver
    extends Mutator2D<ComplexNumber, ComplexMatrix, PhysicalStore<ComplexNumber>> {
        DenseReceiver(PhysicalStore<ComplexNumber> delegate) {
            super(delegate);
        }

        @Override
        ComplexMatrix instantiate(MatrixStore<ComplexNumber> store) {
            return (ComplexMatrix)FACTORY.instantiate(store);
        }
    }
}

